/*
 * Decompiled with CFR 0.152.
 */
package de.danielnaber.jwordsplitter.converter;

import de.danielnaber.jwordsplitter.tools.FastObjectSaver;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Scanner;

public final class SerializeDict {
    private SerializeDict() {
    }

    private static HashSet<String> getFileContents(File file) throws IOException {
        HashSet<String> lines = new HashSet<String>();
        try (Scanner scanner = new Scanner(file);){
            while (scanner.hasNextLine()) {
                lines.add(scanner.nextLine());
            }
        }
        return lines;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Usage: " + SerializeDict.class.getSimpleName() + " <input> <output>");
            System.exit(1);
        }
        System.out.println("Reading " + args[0] + "...");
        HashSet<String> wordSet = SerializeDict.getFileContents(new File(args[0]));
        File outputFile = new File(args[1]);
        System.out.println("Saving " + outputFile + "...");
        FastObjectSaver.saveToFile(outputFile, wordSet);
        System.out.println("Done.");
    }
}

