/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.constant.Constable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.concurrent.ConcurrentHashMap;
import org.bridj.CLong;
import org.bridj.Callback;
import org.bridj.CommonPointerIOs;
import org.bridj.IntValuedEnum;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.bridj.SizeT;
import org.bridj.StructIO;
import org.bridj.StructObject;
import org.bridj.TimeT;
import org.bridj.TypedPointer;
import org.bridj.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PointerIO<T> {
    final Type targetType;
    final Class<?> typedPointerClass;
    final int targetSize;
    final int targetAlignment = -1;
    private static final PointerIO<?> PointerIO = org.bridj.PointerIO.getPointerInstance((PointerIO)null);
    private static final ConcurrentHashMap<StructIO, PointerIO<?>> structIOs = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Type, PointerIO<?>> ios = new ConcurrentHashMap();

    public PointerIO(Type targetType, int targetSize, Class<?> typedPointerClass) {
        this.targetType = targetType;
        this.targetSize = targetSize;
        this.typedPointerClass = typedPointerClass;
    }

    abstract T get(Pointer<T> var1, long var2);

    abstract void set(Pointer<T> var1, long var2, T var4);

    public Object getArray(Pointer<T> pointer, long byteOffset, int length) {
        return pointer.offset(byteOffset).toArray(length);
    }

    public <B extends Buffer> B getBuffer(Pointer<T> pointer, long byteOffset, int length) {
        throw new UnsupportedOperationException("Cannot create a Buffer instance of elements of type " + this.getTargetType());
    }

    public void setArray(Pointer<T> pointer, long byteOffset, Object array) {
        Object[] a = (Object[])array;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            this.set(pointer, i, a[i]);
        }
    }

    public T castTarget(long peer) {
        throw new UnsupportedOperationException("Cannot cast pointer to " + this.targetType);
    }

    PointerIO<Pointer<T>> getReferenceIO() {
        return new CommonPointerIOs.PointerPointerIO(this);
    }

    public long getTargetSize() {
        return this.targetSize;
    }

    public long getTargetAlignment() {
        return this.getTargetSize();
    }

    public boolean isTypedPointer() {
        return this.typedPointerClass != null;
    }

    public Class<?> getTypedPointerClass() {
        return this.typedPointerClass;
    }

    public Type getTargetType() {
        return this.targetType;
    }

    static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return org.bridj.PointerIO.getClass(((ParameterizedType)type).getRawType());
        }
        return null;
    }

    public static <T> PointerIO<Pointer<T>> getPointerInstance(Type target) {
        return org.bridj.PointerIO.getPointerInstance(org.bridj.PointerIO.getInstance(target));
    }

    public static <T> PointerIO<Pointer<T>> getPointerInstance(PointerIO<T> targetIO) {
        return new CommonPointerIOs.PointerPointerIO<T>(targetIO);
    }

    public static <T> PointerIO<Pointer<T>> getArrayInstance(PointerIO<T> targetIO, long[] dimensions, int iDimension) {
        return new CommonPointerIOs.PointerArrayIO<T>(targetIO, dimensions, iDimension);
    }

    static <T> PointerIO<T> getArrayIO(Object array) {
        if (array instanceof int[]) {
            return CommonPointerIOs.intIO;
        }
        if (array instanceof long[]) {
            return CommonPointerIOs.longIO;
        }
        if (array instanceof short[]) {
            return CommonPointerIOs.shortIO;
        }
        if (array instanceof byte[]) {
            return CommonPointerIOs.byteIO;
        }
        if (array instanceof char[]) {
            return CommonPointerIOs.charIO;
        }
        if (array instanceof float[]) {
            return CommonPointerIOs.floatIO;
        }
        if (array instanceof double[]) {
            return CommonPointerIOs.doubleIO;
        }
        if (array instanceof boolean[]) {
            return CommonPointerIOs.booleanIO;
        }
        return org.bridj.PointerIO.getInstance(array.getClass().getComponentType());
    }

    public static <S extends StructObject> PointerIO<S> getInstance(StructIO s) {
        PointerIO<?> previousIO;
        PointerIO<?> io = structIOs.get(s);
        if (io == null && (previousIO = structIOs.putIfAbsent(s, io = new CommonPointerIOs.StructPointerIO(s))) != null) {
            io = previousIO;
        }
        return io;
    }

    public static <P> PointerIO<P> getInstance(Type type) {
        if (type == null) {
            return null;
        }
        PointerIO<Object> io = ios.get(type);
        if (io == null) {
            PointerIO<?> previousIO;
            Class cl = Utils.getClass(type);
            if (cl != null) {
                if (cl == Pointer.class) {
                    io = org.bridj.PointerIO.getPointerInstance(((ParameterizedType)type).getActualTypeArguments()[0]);
                } else if (StructObject.class.isAssignableFrom(cl)) {
                    io = org.bridj.PointerIO.getInstance(StructIO.getInstance(cl, type));
                } else if (Callback.class.isAssignableFrom(cl)) {
                    io = new CommonPointerIOs.CallbackPointerIO(cl);
                } else if (NativeObject.class.isAssignableFrom(cl)) {
                    io = new CommonPointerIOs.NativeObjectPointerIO(type);
                } else if (IntValuedEnum.class.isAssignableFrom(cl)) {
                    Type enumType;
                    if (type instanceof ParameterizedType && (enumType = ((ParameterizedType)type).getActualTypeArguments()[0]) instanceof Class) {
                        io = new CommonPointerIOs.IntValuedEnumPointerIO((Class)enumType);
                    }
                } else if (TypedPointer.class.isAssignableFrom(cl)) {
                    io = new CommonPointerIOs.TypedPointerPointerIO(cl);
                }
            }
            if (io != null && (previousIO = ios.putIfAbsent(type, io)) != null) {
                io = previousIO;
            }
        }
        return io;
    }

    public static PointerIO<Integer> getIntInstance() {
        return CommonPointerIOs.intIO;
    }

    public static PointerIO<Long> getLongInstance() {
        return CommonPointerIOs.longIO;
    }

    public static PointerIO<Short> getShortInstance() {
        return CommonPointerIOs.shortIO;
    }

    public static PointerIO<Byte> getByteInstance() {
        return CommonPointerIOs.byteIO;
    }

    public static PointerIO<Character> getCharInstance() {
        return CommonPointerIOs.charIO;
    }

    public static PointerIO<Float> getFloatInstance() {
        return CommonPointerIOs.floatIO;
    }

    public static PointerIO<Double> getDoubleInstance() {
        return CommonPointerIOs.doubleIO;
    }

    public static PointerIO<Boolean> getBooleanInstance() {
        return CommonPointerIOs.booleanIO;
    }

    public static PointerIO<CLong> getCLongInstance() {
        return CommonPointerIOs.CLongIO;
    }

    public static PointerIO<SizeT> getSizeTInstance() {
        return CommonPointerIOs.SizeTIO;
    }

    public static PointerIO<?> getPointerInstance() {
        return PointerIO;
    }

    public static PointerIO<TimeT> getTimeTInstance() {
        return CommonPointerIOs.TimeTIO;
    }

    public static <P> PointerIO<P> getBufferPrimitiveInstance(Buffer buffer) {
        if (buffer instanceof IntBuffer) {
            return CommonPointerIOs.intIO;
        }
        if (buffer instanceof LongBuffer) {
            return CommonPointerIOs.longIO;
        }
        if (buffer instanceof ShortBuffer) {
            return CommonPointerIOs.shortIO;
        }
        if (buffer instanceof ByteBuffer) {
            return CommonPointerIOs.byteIO;
        }
        if (buffer instanceof CharBuffer) {
            return CommonPointerIOs.charIO;
        }
        if (buffer instanceof FloatBuffer) {
            return CommonPointerIOs.floatIO;
        }
        if (buffer instanceof DoubleBuffer) {
            return CommonPointerIOs.doubleIO;
        }
        throw new UnsupportedOperationException();
    }

    static {
        ios.put((Type)((Object)Pointer.class), PointerIO);
        ios.put((Type)((Object)SizeT.class), CommonPointerIOs.SizeTIO);
        ios.put((Type)((Object)TimeT.class), CommonPointerIOs.TimeTIO);
        ios.put((Type)((Object)CLong.class), CommonPointerIOs.CLongIO);
        PointerIO<Constable> io = CommonPointerIOs.intIO;
        ios.put(Integer.TYPE, io);
        ios.put((Type)((Object)Integer.class), io);
        io = CommonPointerIOs.longIO;
        ios.put(Long.TYPE, io);
        ios.put((Type)((Object)Long.class), io);
        io = CommonPointerIOs.shortIO;
        ios.put(Short.TYPE, io);
        ios.put((Type)((Object)Short.class), io);
        io = CommonPointerIOs.byteIO;
        ios.put(Byte.TYPE, io);
        ios.put((Type)((Object)Byte.class), io);
        io = CommonPointerIOs.charIO;
        ios.put(Character.TYPE, io);
        ios.put((Type)((Object)Character.class), io);
        io = CommonPointerIOs.floatIO;
        ios.put(Float.TYPE, io);
        ios.put((Type)((Object)Float.class), io);
        io = CommonPointerIOs.doubleIO;
        ios.put(Double.TYPE, io);
        ios.put((Type)((Object)Double.class), io);
        io = CommonPointerIOs.booleanIO;
        ios.put(Boolean.TYPE, io);
        ios.put((Type)((Object)Boolean.class), io);
    }
}

