"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Access to various administrative APIs.
 * @category Unstable APIs
 */
class AdminApis {
    constructor(client) {
        this.client = client;
    }
    /**
     * Gets information about a particular user.
     * @param {string} userId the user ID to lookup
     * @returns {Promise<WhoisInfo>} resolves to the whois information
     */
    whoisUser(userId) {
        return this.client.doRequest("GET", "/_matrix/client/r0/admin/whois/" + encodeURIComponent(userId));
    }
}
exports.AdminApis = AdminApis;
