/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.httpclient.impl.conn;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.wagon.providers.http.httpclient.HttpHost;
import org.apache.maven.wagon.providers.http.httpclient.annotation.Contract;
import org.apache.maven.wagon.providers.http.httpclient.annotation.ThreadingBehavior;
import org.apache.maven.wagon.providers.http.httpclient.client.protocol.HttpClientContext;
import org.apache.maven.wagon.providers.http.httpclient.config.Lookup;
import org.apache.maven.wagon.providers.http.httpclient.config.SocketConfig;
import org.apache.maven.wagon.providers.http.httpclient.conn.ConnectTimeoutException;
import org.apache.maven.wagon.providers.http.httpclient.conn.DnsResolver;
import org.apache.maven.wagon.providers.http.httpclient.conn.HttpClientConnectionOperator;
import org.apache.maven.wagon.providers.http.httpclient.conn.HttpHostConnectException;
import org.apache.maven.wagon.providers.http.httpclient.conn.ManagedHttpClientConnection;
import org.apache.maven.wagon.providers.http.httpclient.conn.SchemePortResolver;
import org.apache.maven.wagon.providers.http.httpclient.conn.UnsupportedSchemeException;
import org.apache.maven.wagon.providers.http.httpclient.conn.socket.ConnectionSocketFactory;
import org.apache.maven.wagon.providers.http.httpclient.conn.socket.LayeredConnectionSocketFactory;
import org.apache.maven.wagon.providers.http.httpclient.impl.conn.DefaultSchemePortResolver;
import org.apache.maven.wagon.providers.http.httpclient.impl.conn.SystemDefaultDnsResolver;
import org.apache.maven.wagon.providers.http.httpclient.protocol.HttpContext;
import org.apache.maven.wagon.providers.http.httpclient.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpClientConnectionOperator
implements HttpClientConnectionOperator {
    static final String SOCKET_FACTORY_REGISTRY = "http.socket-factory-registry";
    private final Log log = LogFactory.getLog(this.getClass());
    private final Lookup<ConnectionSocketFactory> socketFactoryRegistry;
    private final SchemePortResolver schemePortResolver;
    private final DnsResolver dnsResolver;

    public DefaultHttpClientConnectionOperator(Lookup<ConnectionSocketFactory> socketFactoryRegistry, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        Args.notNull(socketFactoryRegistry, "Socket factory registry");
        this.socketFactoryRegistry = socketFactoryRegistry;
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
        this.dnsResolver = dnsResolver != null ? dnsResolver : SystemDefaultDnsResolver.INSTANCE;
    }

    private Lookup<ConnectionSocketFactory> getSocketFactoryRegistry(HttpContext context) {
        Lookup<ConnectionSocketFactory> reg = (Lookup<ConnectionSocketFactory>)context.getAttribute(SOCKET_FACTORY_REGISTRY);
        if (reg == null) {
            reg = this.socketFactoryRegistry;
        }
        return reg;
    }

    @Override
    public void connect(ManagedHttpClientConnection conn, HttpHost host, InetSocketAddress localAddress, int connectTimeout, SocketConfig socketConfig, HttpContext context) throws IOException {
        InetAddress[] inetAddressArray;
        Lookup<ConnectionSocketFactory> registry = this.getSocketFactoryRegistry(context);
        ConnectionSocketFactory sf = registry.lookup(host.getSchemeName());
        if (sf == null) {
            throw new UnsupportedSchemeException(host.getSchemeName() + " protocol is not supported");
        }
        if (host.getAddress() != null) {
            InetAddress[] inetAddressArray2 = new InetAddress[1];
            inetAddressArray = inetAddressArray2;
            inetAddressArray2[0] = host.getAddress();
        } else {
            inetAddressArray = this.dnsResolver.resolve(host.getHostName());
        }
        InetAddress[] addresses = inetAddressArray;
        int port = this.schemePortResolver.resolve(host);
        for (int i = 0; i < addresses.length; ++i) {
            InetSocketAddress remoteAddress;
            block15: {
                int linger;
                InetAddress address = addresses[i];
                boolean last = i == addresses.length - 1;
                Socket sock = sf.createSocket(context);
                sock.setSoTimeout(socketConfig.getSoTimeout());
                sock.setReuseAddress(socketConfig.isSoReuseAddress());
                sock.setTcpNoDelay(socketConfig.isTcpNoDelay());
                sock.setKeepAlive(socketConfig.isSoKeepAlive());
                if (socketConfig.getRcvBufSize() > 0) {
                    sock.setReceiveBufferSize(socketConfig.getRcvBufSize());
                }
                if (socketConfig.getSndBufSize() > 0) {
                    sock.setSendBufferSize(socketConfig.getSndBufSize());
                }
                if ((linger = socketConfig.getSoLinger()) >= 0) {
                    sock.setSoLinger(true, linger);
                }
                conn.bind(sock);
                remoteAddress = new InetSocketAddress(address, port);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Connecting to " + remoteAddress));
                }
                try {
                    sock = sf.connectSocket(connectTimeout, sock, host, remoteAddress, localAddress, context);
                    conn.bind(sock);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Connection established " + conn));
                    }
                    return;
                }
                catch (SocketTimeoutException ex) {
                    if (last) {
                        throw new ConnectTimeoutException(ex, host, addresses);
                    }
                }
                catch (ConnectException ex) {
                    if (last) {
                        String msg = ex.getMessage();
                        throw "Connection timed out".equals(msg) ? new ConnectTimeoutException(ex, host, addresses) : new HttpHostConnectException(ex, host, addresses);
                    }
                }
                catch (NoRouteToHostException ex) {
                    if (!last) break block15;
                    throw ex;
                }
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Connect to " + remoteAddress + " timed out. " + "Connection will be retried using another IP address"));
        }
    }

    @Override
    public void upgrade(ManagedHttpClientConnection conn, HttpHost host, HttpContext context) throws IOException {
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        Lookup<ConnectionSocketFactory> registry = this.getSocketFactoryRegistry(clientContext);
        ConnectionSocketFactory sf = registry.lookup(host.getSchemeName());
        if (sf == null) {
            throw new UnsupportedSchemeException(host.getSchemeName() + " protocol is not supported");
        }
        if (!(sf instanceof LayeredConnectionSocketFactory)) {
            throw new UnsupportedSchemeException(host.getSchemeName() + " protocol does not support connection upgrade");
        }
        LayeredConnectionSocketFactory lsf = (LayeredConnectionSocketFactory)sf;
        Socket sock = conn.getSocket();
        int port = this.schemePortResolver.resolve(host);
        sock = lsf.createLayeredSocket(sock, host.getHostName(), port, context);
        conn.bind(sock);
    }
}

