/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.calculation;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.calculation.AbstractCalculation;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;

final class SizeInRange
extends AbstractCalculation<Boolean>
implements ListEventListener {
    private final EventList source;
    private final int min;
    private final int max;

    public SizeInRange(EventList source2, int min2, int max) {
        super(new Boolean(source2.size() >= min2 && source2.size() <= max));
        if (min2 > max) {
            throw new IllegalArgumentException("min must be less than max");
        }
        this.source = source2;
        this.source.addListEventListener(this);
        this.min = min2;
        this.max = max;
    }

    @Override
    public void dispose() {
        this.source.removeListEventListener(this);
    }

    public void listChanged(ListEvent listChanges) {
        Boolean oldValue = (Boolean)this.getValue();
        int size = listChanges.getSourceList().size();
        this.setValue(new Boolean(size >= this.min && size <= this.max));
        Boolean newValue = (Boolean)this.getValue();
        this.fireValueChange(oldValue, newValue);
    }
}

