/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt.barcode2;

import ca.odell.glazedlists.impl.adt.barcode2.BciiTree;
import ca.odell.glazedlists.impl.adt.barcode2.Element;
import java.util.Arrays;
import java.util.List;

class BciiNode<T0, T1>
implements Element<T0> {
    int count1;
    int count2;
    int count4;
    byte color;
    T0 t0;
    T1 t1;
    int size;
    byte height;
    BciiNode<T0, T1> left;
    BciiNode<T0, T1> right;
    BciiNode<T0, T1> parent;
    int sorted = 0;

    public BciiNode(byte color, int size, T0 value, BciiNode<T0, T1> parent) {
        assert (BciiTree.colorAsIndex(color) >= 0 && BciiTree.colorAsIndex(color) < 7);
        this.color = color;
        this.size = size;
        this.t0 = value;
        this.height = 1;
        this.parent = parent;
        if (color == 1) {
            this.count1 += size;
        }
        if (color == 2) {
            this.count2 += size;
        }
        if (color == 4) {
            this.count4 += size;
        }
    }

    @Override
    public T0 get() {
        return this.t0;
    }

    @Override
    public void set(T0 value) {
        this.t0 = value;
    }

    @Override
    public byte getColor() {
        return this.color;
    }

    final int size(byte colors) {
        int result = 0;
        if ((colors & 1) != 0) {
            result += this.count1;
        }
        if ((colors & 2) != 0) {
            result += this.count2;
        }
        if ((colors & 4) != 0) {
            result += this.count4;
        }
        return result;
    }

    final int nodeSize(byte colors) {
        return (colors & this.color) > 0 ? this.size : 0;
    }

    final void refreshCounts() {
        this.count1 = 0;
        this.count2 = 0;
        this.count4 = 0;
        if (this.left != null) {
            this.count1 += this.left.count1;
            this.count2 += this.left.count2;
            this.count4 += this.left.count4;
        }
        if (this.right != null) {
            this.count1 += this.right.count1;
            this.count2 += this.right.count2;
            this.count4 += this.right.count4;
        }
        if (this.color == 1) {
            this.count1 += this.size;
        }
        if (this.color == 2) {
            this.count2 += this.size;
        }
        if (this.color == 4) {
            this.count4 += this.size;
        }
    }

    public String toString() {
        return this.toString(Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H"));
    }

    String toString(List colors) {
        StringBuffer result = new StringBuffer();
        this.asTree(0, result, colors);
        return result.toString();
    }

    void asTree(int indentation, StringBuffer out, List colors) {
        if (this.left != null) {
            this.left.asTree(indentation + 1, out, colors);
        }
        for (int i = 0; i < indentation; ++i) {
            out.append("   ");
        }
        out.append(colors.get(BciiTree.colorAsIndex(this.color)));
        out.append(" [").append(this.size).append("]");
        if (this.t0 != null) {
            out.append(": ");
            if (this.t0 instanceof BciiNode) {
                out.append("<Node>");
            } else {
                out.append(this.t0);
            }
        }
        out.append("\n");
        if (this.right != null) {
            this.right.asTree(indentation + 1, out, colors);
        }
    }

    @Override
    public void setSorted(int sorted2) {
        this.sorted = sorted2;
    }

    @Override
    public int getSorted() {
        return this.sorted;
    }

    @Override
    public Element<T0> next() {
        return BciiTree.next(this);
    }

    @Override
    public Element<T0> previous() {
        return BciiTree.previous(this);
    }
}

