/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

import eu.hansolo.tilesfx.events.BoundsEvent;
import eu.hansolo.tilesfx.events.BoundsEventListener;
import eu.hansolo.tilesfx.tools.Helper;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class CtxBounds {
    private double x;
    private double y;
    private double width;
    private double height;
    private List<BoundsEventListener> listeners;

    public CtxBounds() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public CtxBounds(double WIDTH, double HEIGHT) {
        this(0.0, 0.0, WIDTH, HEIGHT);
    }

    public CtxBounds(double X, double Y, double WIDTH, double HEIGHT) {
        this.x = X;
        this.y = Y;
        this.width = Helper.clamp(0.0, Double.MAX_VALUE, WIDTH);
        this.height = Helper.clamp(0.0, Double.MAX_VALUE, HEIGHT);
        this.listeners = new CopyOnWriteArrayList<BoundsEventListener>();
    }

    public double getX() {
        return this.x;
    }

    public void setX(double X) {
        this.x = X;
        this.fireBoundsEvent();
    }

    public double getY() {
        return this.y;
    }

    public void setY(double Y) {
        this.y = Y;
        this.fireBoundsEvent();
    }

    public double getMinX() {
        return this.x;
    }

    public double getMaxX() {
        return this.x + this.width;
    }

    public double getMinY() {
        return this.y;
    }

    public double getMaxY() {
        return this.y + this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double WIDTH) {
        this.width = Helper.clamp(0.0, Double.MAX_VALUE, WIDTH);
        this.fireBoundsEvent();
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double HEIGHT) {
        this.height = Helper.clamp(0.0, Double.MAX_VALUE, HEIGHT);
        this.fireBoundsEvent();
    }

    public double getCenterX() {
        return this.x + this.width * 0.5;
    }

    public double getCenterY() {
        return this.y + this.height * 0.5;
    }

    public void set(CtxBounds BOUNDS) {
        this.set(BOUNDS.getX(), BOUNDS.getY(), BOUNDS.getWidth(), BOUNDS.getHeight());
    }

    public void set(double X, double Y, double WIDTH, double HEIGHT) {
        this.x = X;
        this.y = Y;
        this.width = WIDTH;
        this.height = HEIGHT;
        this.fireBoundsEvent();
    }

    public void setOnBoundsEvent(BoundsEventListener LISTENER) {
        this.addBoundsEventListener(LISTENER);
    }

    public void addBoundsEventListener(BoundsEventListener LISTENER) {
        if (!this.listeners.contains(LISTENER)) {
            this.listeners.add(LISTENER);
        }
    }

    public void removeBoundsEventListener(BoundsEventListener LISTENER) {
        if (this.listeners.contains(LISTENER)) {
            this.listeners.remove(LISTENER);
        }
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void fireBoundsEvent() {
        BoundsEvent boundsEvent = new BoundsEvent(this);
        for (BoundsEventListener listener : this.listeners) {
            listener.onBoundsEvent(boundsEvent);
        }
    }

    public String toString() {
        return "[x:" + this.getX() + ", " + "y:" + this.getY() + ", " + "w:" + this.getWidth() + ", " + "h:" + this.getHeight() + "]";
    }
}

