/*
 * Decompiled with CFR 0.152.
 */
package mediathek.update;

import java.awt.Container;
import java.awt.Frame;
import java.net.URISyntaxException;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.Hyperlink;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import mediathek.gui.actions.UrlHyperlinkAction;
import mediathek.tool.EscapeKeyHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogHinweisUpdate
extends JDialog {
    private static final Logger logger = LogManager.getLogger(DialogHinweisUpdate.class);
    private JTextArea jTextArea1;
    private JButton jButtonOk;
    private JFXPanel hyperLinkPanel;

    public DialogHinweisUpdate(JFrame parent, String ttext) {
        super((Frame)parent, true);
        this.initComponents();
        EscapeKeyHandler.installHandler(this, this::dispose);
        this.jButtonOk.addActionListener(e -> this.dispose());
        this.jTextArea1.setText(ttext);
        Platform.runLater(() -> {
            Hyperlink link = new Hyperlink("Link zur Website");
            link.setBackground(new Background(new BackgroundFill(Color.rgb(236, 236, 236), CornerRadii.EMPTY, Insets.EMPTY)));
            link.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                try {
                    UrlHyperlinkAction.openURL(parent, "https://mediathekview.de/download/");
                }
                catch (URISyntaxException ex) {
                    logger.error(ex);
                }
            }));
            this.hyperLinkPanel.setScene(new Scene(link));
        });
        this.setSize(450, this.getHeight());
    }

    private void initComponents() {
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jButtonOk = new JButton();
        this.hyperLinkPanel = new JFXPanel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Programminformationen");
        Container contentPane = this.getContentPane();
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("\n\n");
        this.jTextArea1.setWrapStyleWord(true);
        jScrollPane1.setViewportView(this.jTextArea1);
        this.jButtonOk.setText("Schlie\u00dfen");
        GroupLayout contentPaneLayout = new GroupLayout(contentPane);
        contentPane.setLayout(contentPaneLayout);
        contentPaneLayout.setHorizontalGroup(contentPaneLayout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, contentPaneLayout.createSequentialGroup().addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.hyperLinkPanel, -1, -1, Short.MAX_VALUE).addGroup(contentPaneLayout.createSequentialGroup().addContainerGap().addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(contentPaneLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOk)).addComponent(jScrollPane1, GroupLayout.Alignment.LEADING)))).addGap(5, 5, 5)));
        contentPaneLayout.setVerticalGroup(contentPaneLayout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, contentPaneLayout.createSequentialGroup().addContainerGap().addComponent(jScrollPane1, -1, 208, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hyperLinkPanel, -2, -1, -2).addGap(2, 2, 2).addComponent(this.jButtonOk).addContainerGap()));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

