/*
 * Decompiled with CFR 0.152.
 */
package net.posick.mDNS;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.posick.mDNS.Browse;
import net.posick.mDNS.Constants;
import net.posick.mDNS.DNSSDListener;
import net.posick.mDNS.Lookup;
import net.posick.mDNS.MulticastDNSLookupBase;
import net.posick.mDNS.ServiceInstance;
import net.posick.mDNS.ServiceName;
import net.posick.mDNS.ServiceRegistrationException;
import net.posick.mDNS.utils.Executors;
import net.posick.mDNS.utils.ListenerProcessor;
import net.posick.mDNS.utils.Misc;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Message;
import org.xbill.DNS.MulticastDNSUtils;
import org.xbill.DNS.NSECRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.Update;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MulticastDNSService
extends MulticastDNSLookupBase {
    private static final Logger logger = Misc.getLogger(MulticastDNSService.class, Options.check("mdns_verbose") || Options.check("verbose"));
    protected Executors executors = Executors.newInstance();
    protected ArrayList<ServiceDiscoveryOperation> discoveryOperations = new ArrayList();

    @Override
    public void close() throws IOException {
        for (ServiceDiscoveryOperation discoveryOperation : this.discoveryOperations) {
            try {
                discoveryOperation.close();
            }
            catch (Exception exception) {}
        }
    }

    public Set<Lookup.Domain> getBrowseDomains(Set<Name> searchPath) {
        Name[] defaultDomains;
        LinkedHashSet<Lookup.Domain> results = new LinkedHashSet<Lookup.Domain>();
        for (Name name : defaultDomains = Constants.ALL_MULTICAST_DNS_DOMAINS) {
            results.add(new Lookup.Domain(name));
        }
        results.addAll(this.getDomains(new String[]{"db._dns-sd._udp", "b._dns-sd._udp", "lb._dns-sd._udp"}, searchPath.toArray(new Name[searchPath.size()])));
        return results;
    }

    public Set<Lookup.Domain> getDefaultBrowseDomains(Set<Name> searchPath) {
        Name[] defaultDomains;
        LinkedHashSet<Lookup.Domain> results = new LinkedHashSet<Lookup.Domain>();
        for (Name name : defaultDomains = Constants.ALL_MULTICAST_DNS_DOMAINS) {
            results.add(new Lookup.Domain(name));
        }
        searchPath.addAll(Arrays.asList(Constants.ALL_MULTICAST_DNS_DOMAINS));
        results.addAll(this.getDomains(new String[]{"db._dns-sd._udp"}, searchPath.toArray(new Name[searchPath.size()])));
        return results;
    }

    public Set<Lookup.Domain> getDefaultRegistrationDomains(Set<Name> searchPath) {
        Name[] defaultDomains;
        LinkedHashSet<Lookup.Domain> results = new LinkedHashSet<Lookup.Domain>();
        for (Name name : defaultDomains = Constants.ALL_MULTICAST_DNS_DOMAINS) {
            results.add(new Lookup.Domain(name));
        }
        searchPath.addAll(Arrays.asList(Constants.ALL_MULTICAST_DNS_DOMAINS));
        results.addAll(this.getDomains(new String[]{"dr._dns-sd._udp"}, searchPath.toArray(new Name[searchPath.size()])));
        return results;
    }

    public Set<Lookup.Domain> getRegistrationDomains(Set<Name> searchPath) {
        Name[] defaultDomains;
        LinkedHashSet<Lookup.Domain> results = new LinkedHashSet<Lookup.Domain>();
        for (Name name : defaultDomains = Constants.ALL_MULTICAST_DNS_DOMAINS) {
            results.add(new Lookup.Domain(name));
        }
        results.addAll(this.getDomains(new String[]{"dr._dns-sd._udp", "r._dns-sd._udp"}, searchPath.toArray(new Name[searchPath.size()])));
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInstance register(ServiceInstance service) throws IOException {
        Register register = new Register(service);
        try {
            ServiceInstance serviceInstance = register.register();
            return serviceInstance;
        }
        finally {
            register.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object startServiceDiscovery(Browse browser, DNSSDListener listener) throws IOException {
        ServiceDiscoveryOperation discoveryOperation = new ServiceDiscoveryOperation(browser, listener);
        ArrayList<ServiceDiscoveryOperation> arrayList = this.discoveryOperations;
        synchronized (arrayList) {
            this.discoveryOperations.add(discoveryOperation);
        }
        discoveryOperation.start();
        return discoveryOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopServiceDiscovery(Object id) throws IOException {
        ArrayList<ServiceDiscoveryOperation> arrayList = this.discoveryOperations;
        synchronized (arrayList) {
            ServiceDiscoveryOperation discoveryOperation;
            int pos = this.discoveryOperations.indexOf(id);
            if (pos >= 0 && (discoveryOperation = this.discoveryOperations.get(pos)) != null) {
                this.discoveryOperations.remove(pos);
                discoveryOperation.close();
                return true;
            }
        }
        if (id instanceof ServiceDiscoveryOperation) {
            ((ServiceDiscoveryOperation)id).close();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(ServiceInstance service) throws IOException {
        Unregister unregister = new Unregister(service);
        try {
            boolean bl = unregister.unregister();
            return bl;
        }
        finally {
            unregister.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(ServiceName name) throws IOException {
        Unregister unregister = new Unregister(name);
        try {
            boolean bl = unregister.unregister();
            return bl;
        }
        finally {
            unregister.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Lookup.Domain> getDomains(String[] names, Name[] path) {
        LinkedHashSet<Lookup.Domain> results = new LinkedHashSet<Lookup.Domain>();
        Stack<Name[]> stack = new Stack<Name[]>();
        stack.push(path);
        while (!stack.isEmpty()) {
            Name[] searchPath = (Name[])stack.pop();
            Lookup lookup2 = null;
            try {
                lookup2 = new Lookup(names);
                lookup2.setSearchPath(searchPath);
                lookup2.setQuerier(this.querier);
                Lookup.Domain[] domains = lookup2.lookupDomains();
                if (domains == null || domains.length <= 0) continue;
                ArrayList<Name> newDomains = new ArrayList<Name>();
                for (int index = 0; index < domains.length; ++index) {
                    if (results.contains(domains[index].getName())) continue;
                    newDomains.add(domains[index].getName());
                    results.add(domains[index]);
                }
                if (newDomains.size() <= 0) continue;
                stack.push(newDomains.toArray(new Name[newDomains.size()]));
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error getting domains - " + e.getMessage(), e);
            }
            finally {
                if (lookup2 == null) continue;
                try {
                    lookup2.close();
                }
                catch (Exception exception) {}
            }
        }
        return results;
    }

    public static boolean hasMulticastDomains(Message query) {
        Record[] records = MulticastDNSUtils.extractRecords(query, 0, 1, 2, 3);
        if (records != null) {
            for (Record record : records) {
                if (!MulticastDNSService.isMulticastDomain(record.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasUnicastDomains(Message query) {
        Record[] records = MulticastDNSUtils.extractRecords(query, 0, 1, 2, 3);
        if (records != null) {
            for (Record record : records) {
                if (MulticastDNSService.isMulticastDomain(record.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMulticastDomain(Name name) {
        for (Name multicastDomain : IPv4_MULTICAST_DOMAINS) {
            if (!name.equals(multicastDomain) && !name.subdomain(multicastDomain)) continue;
            return true;
        }
        for (Name multicastDomain : IPv6_MULTICAST_DOMAINS) {
            if (!name.equals(multicastDomain) && !name.subdomain(multicastDomain)) continue;
            return true;
        }
        return false;
    }

    protected class Unregister {
        private final ServiceName serviceName;

        protected Unregister(ServiceInstance service) {
            this(service.getName());
        }

        protected Unregister(ServiceName serviceName) {
            this.serviceName = serviceName;
        }

        protected void close() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        protected boolean unregister() throws IOException {
            void var9_13;
            String domain = this.serviceName.getDomain();
            Name fullTypeName = new Name(this.serviceName.getFullType() + "." + domain);
            Name typeName = new Name(this.serviceName.getType() + "." + domain);
            Name shortSRVName = this.serviceName.getServiceRRName();
            ArrayList<PTRRecord> records = new ArrayList<PTRRecord>();
            ArrayList additionalRecords = new ArrayList();
            records.add(new PTRRecord(typeName, 1, 0L, shortSRVName));
            if (!fullTypeName.equals(typeName)) {
                records.add(new PTRRecord(fullTypeName, 1, 0L, shortSRVName));
            }
            Update update2 = new Update(new Name(domain));
            for (Record record : records) {
                update2.add(record);
            }
            for (Record record : additionalRecords) {
                update2.addRecord(record, 3);
            }
            ResolverListener resolverListener = new ResolverListener(){

                public void handleException(Object id, Exception e) {
                }

                public void receiveMessage(Object id, Message m3) {
                }
            };
            boolean bl = false;
            while (++var9_13 < 3) {
                MulticastDNSService.this.querier.sendAsync(update2, resolverListener);
                long retry = System.currentTimeMillis() + 2000L;
                while (System.currentTimeMillis() < retry) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            Lookup lookup2 = new Lookup(new Name[]{typeName, fullTypeName}, 12, 255);
            try {
                boolean found = false;
                Record[] results = lookup2.lookupRecords();
                if (results != null) {
                    for (Record record : results) {
                        if (!shortSRVName.equals(((PTRRecord)record).getTarget())) continue;
                        found = true;
                    }
                }
                boolean bl2 = !found;
                return bl2;
            }
            finally {
                lookup2.close();
            }
        }
    }

    protected class ServiceDiscoveryOperation
    implements ResolverListener {
        private final Browse browser;
        private final ListenerProcessor<DNSSDListener> listenerProcessor = new ListenerProcessor<DNSSDListener>(DNSSDListener.class);
        private final Map services = new LinkedHashMap();

        ServiceDiscoveryOperation(Browse browser) {
            this(browser, null);
        }

        ServiceDiscoveryOperation(Browse browser, DNSSDListener listener) {
            this.browser = browser;
            if (listener != null) {
                this.registerListener(listener);
            }
        }

        public void close() {
            try {
                this.listenerProcessor.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.browser.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void handleException(Object id, Exception e) {
            this.listenerProcessor.getDispatcher().handleException(id, e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receiveMessage(Object id, Message message) {
            PTRRecord ptr;
            if (message == null) {
                return;
            }
            LinkedHashSet<Name> additionalNames = new LinkedHashSet<Name>();
            LinkedList<Record> ignoredRecords = new LinkedList<Record>();
            LinkedList<Record> filteredRecords = new LinkedList<Record>();
            Record[] thatAnswers = MulticastDNSUtils.extractRecords(message, 1, 2, 3);
            for (Record record : thatAnswers) {
                if (this.answersQuery(record)) {
                    Name additionalName = record.getAdditionalName();
                    if (additionalName != null) {
                        additionalNames.add(additionalName);
                    }
                    switch (record.getType()) {
                        case 12: {
                            ptr = (PTRRecord)record;
                            additionalNames.add(ptr.getTarget());
                            break;
                        }
                        case 33: {
                            SRVRecord srv = (SRVRecord)record;
                            additionalNames.add(srv.getTarget());
                            break;
                        }
                    }
                    filteredRecords.add(record);
                    continue;
                }
                ignoredRecords.add(record);
            }
            for (Record record : ignoredRecords) {
                if (!additionalNames.contains(record.getName())) continue;
                filteredRecords.add(record);
            }
            if (filteredRecords.size() > 0) {
                this.listenerProcessor.getDispatcher().receiveMessage(id, message);
                HashMap<ServiceName, ServiceInstance> foundServices = new HashMap<ServiceName, ServiceInstance>();
                HashMap<ServiceName, ServiceInstance> removedServices = new HashMap<ServiceName, ServiceInstance>();
                block21: for (Record record : filteredRecords) {
                    try {
                        ServiceInstance service = null;
                        switch (record.getType()) {
                            case 12: {
                                ptr = (PTRRecord)record;
                                if (ptr.getTTL() > 0L) {
                                    ServiceInstance[] instances = MulticastDNSLookupBase.extractServiceInstances(MulticastDNSService.this.querier.send(Message.newQuery(Record.newRecord(ptr.getTarget(), 255, MulticastDNSService.this.dclass))));
                                    if (instances.length <= 0) continue block21;
                                    Map map = this.services;
                                    synchronized (map) {
                                        for (int i = 0; i < instances.length; ++i) {
                                            if (this.services.containsKey(instances[i].getName())) continue;
                                            this.services.put(instances[i].getName(), instances[i]);
                                            foundServices.put(instances[i].getName(), instances[i]);
                                        }
                                        break;
                                    }
                                }
                                Map map = this.services;
                                synchronized (map) {
                                    service = (ServiceInstance)this.services.get(ptr.getTarget());
                                    if (service != null) {
                                        this.services.remove(service.getName());
                                        removedServices.put(service.getName(), service);
                                    }
                                    break;
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.WARNING, "Error parsing SRV record - " + e.getMessage(), e);
                            continue;
                        }
                        logger.logp(Level.WARNING, this.getClass().getName(), "receiveMessage", "Error parsing SRV record - " + e.getMessage());
                    }
                }
                for (ServiceInstance service : foundServices.values()) {
                    try {
                        this.listenerProcessor.getDispatcher().serviceDiscovered(id, service);
                    }
                    catch (Exception e) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.WARNING, "Error sending serviceDiscovered event - " + e.getMessage(), e);
                            continue;
                        }
                        logger.logp(Level.WARNING, this.getClass().getName(), "receiveMessage", "Error sending serviceDiscovered event - " + e.getMessage());
                    }
                }
                for (ServiceInstance service : removedServices.values()) {
                    try {
                        this.listenerProcessor.getDispatcher().serviceRemoved(id, service);
                    }
                    catch (Exception e) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.WARNING, "Error sending serviceRemoved event - " + e.getMessage(), e);
                            continue;
                        }
                        logger.logp(Level.WARNING, this.getClass().getName(), "receiveMessage", "Error sending serviceRemoved event - " + e.getMessage());
                    }
                }
            }
        }

        public void start() {
            this.browser.start(this);
        }

        boolean answersQuery(Record record) {
            if (record != null) {
                for (Message query : this.browser.queries) {
                    for (Record question : MulticastDNSUtils.extractRecords(query, 0)) {
                        Name questionName = question.getName();
                        Name recordName = record.getName();
                        int questionType = question.getType();
                        int recordType = record.getType();
                        int questionDClass = question.getDClass();
                        int recordDClass = record.getDClass();
                        if (questionType != 255 && questionType != recordType || !questionName.equals(recordName) && !questionName.subdomain(recordName) && !recordName.toString().endsWith("." + questionName.toString()) || questionDClass != 255 && (questionDClass & Short.MAX_VALUE) != (recordDClass & Short.MAX_VALUE)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        Browse getBrowser() {
            return this.browser;
        }

        boolean matchesBrowse(Message message) {
            if (message != null) {
                Record[] thatAnswers;
                for (Record thatAnswer : thatAnswers = MulticastDNSUtils.extractRecords(message, 1, 2, 3)) {
                    if (!this.answersQuery(thatAnswer)) continue;
                    return true;
                }
            }
            return false;
        }

        DNSSDListener registerListener(DNSSDListener listener) {
            return this.listenerProcessor.registerListener(listener);
        }

        DNSSDListener unregisterListener(DNSSDListener listener) {
            return this.listenerProcessor.unregisterListener(listener);
        }
    }

    protected class Register {
        private final ServiceInstance service;

        protected Register(ServiceInstance service) throws UnknownHostException {
            this.service = service;
        }

        protected void close() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ServiceInstance register() throws IOException {
            Object resolverListener22;
            final ArrayList<Exception> replies = new ArrayList<Exception>();
            Message query = Message.newQuery(Record.newRecord(this.service.getName(), 255, 1));
            if (this.service.getHost() == null) {
                throw new IOException("Service Records must have a target, aka. Host value set.");
            }
            SRVRecord srvRecord = new SRVRecord(this.service.getName(), 1, 3600L, 0, 0, this.service.getPort(), this.service.getHost());
            int tries = 0;
            while (tries++ < 3) {
                MulticastDNSService.this.querier.sendAsync(query, new ResolverListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleException(Object id, Exception e) {
                        List list = replies;
                        synchronized (list) {
                            replies.add(e);
                            replies.notifyAll();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void receiveMessage(Object id, Message m3) {
                        List list = replies;
                        synchronized (list) {
                            replies.add(m3);
                            replies.notifyAll();
                        }
                    }
                });
                ArrayList<Exception> arrayList = replies;
                synchronized (arrayList) {
                    try {
                        replies.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (replies.size() > 0) {
                        for (Object e : replies) {
                            if (e instanceof Exception) {
                                if (e instanceof IOException) {
                                    throw (IOException)e;
                                }
                                Exception e2 = (Exception)e;
                                IOException ioe = new IOException(e2.getMessage());
                                ioe.setStackTrace(e2.getStackTrace());
                                throw ioe;
                            }
                            Message message = (Message)e;
                            if (message.getRcode() != 0 && message.getRcode() != 1) continue;
                            Record[] records = MulticastDNSUtils.extractRecords(message, 1, 2, 3);
                            for (int r = 0; r < records.length; ++r) {
                                if (records[r].getType() != 33 || records[r].getTTL() <= 0L || srvRecord.equals(records[r])) continue;
                                throw new ServiceRegistrationException(ServiceRegistrationException.REASON.SERVICE_NAME_ALREADY_EXISTS, "A service with name \"" + this.service.getName() + "\" already exists.");
                            }
                        }
                    }
                }
            }
            replies.clear();
            ServiceName serviceName = this.service.getName();
            Name domain = new Name(serviceName.getDomain());
            Update[] updateArray = new Update[]{new Update(domain), new Update(domain)};
            Name fullTypeName = new Name(serviceName.getFullType() + "." + domain);
            Name typeName = new Name(serviceName.getType() + "." + domain);
            Name shortSRVName = serviceName.getServiceRRName();
            try {
                ArrayList<Record> records = new ArrayList<Record>();
                ArrayList<Record> additionalRecords = new ArrayList<Record>();
                InetAddress[] addresses = this.service.getAddresses();
                if (addresses != null) {
                    for (int index = 0; index < addresses.length; ++index) {
                        if (addresses[index] == null) continue;
                        if (addresses[index].getAddress().length == 4) {
                            additionalRecords.add(new ARecord(this.service.getHost(), 32769, 120L, addresses[index]));
                            continue;
                        }
                        additionalRecords.add(new AAAARecord(this.service.getHost(), 32769, 120L, addresses[index]));
                    }
                }
                records.add(new PTRRecord(typeName, 1, 120L, shortSRVName));
                if (!fullTypeName.equals(typeName)) {
                    records.add(new PTRRecord(fullTypeName, 1, 120L, shortSRVName));
                }
                records.add(new SRVRecord(shortSRVName, 32769, 120L, 0, 0, this.service.getPort(), this.service.getHost()));
                records.add(new TXTRecord(shortSRVName, 32769, 4500L, Arrays.asList(this.service.getText())));
                additionalRecords.add(new NSECRecord(shortSRVName, 32769, 4500L, shortSRVName, new int[]{16, 33}));
                additionalRecords.add(new NSECRecord(this.service.getHost(), 32769, 120L, this.service.getHost(), new int[]{1, 28}));
                for (Record record : records) {
                    updateArray[0].add(record);
                }
                for (Record record : additionalRecords) {
                    updateArray[0].addRecord(record, 3);
                }
                records.clear();
                additionalRecords.clear();
                records.add(new PTRRecord(new Name("_services._dns-sd._udp." + domain), 1, 120L, typeName));
                if (!fullTypeName.equals(typeName)) {
                    records.add(new PTRRecord(new Name("_services._dns-sd._udp." + domain), 1, 120L, fullTypeName));
                }
                for (Record record : records) {
                    updateArray[1].add(record);
                }
                resolverListener22 = new ResolverListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleException(Object id, Exception e) {
                        List list = replies;
                        synchronized (list) {
                            replies.add(e);
                            replies.notifyAll();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void receiveMessage(Object id, Message m3) {
                        List list = replies;
                        synchronized (list) {
                            replies.add(m3);
                            replies.notifyAll();
                        }
                    }
                };
                tries = 0;
                while (tries++ < 2) {
                    MulticastDNSService.this.querier.sendAsync(updateArray[0], (ResolverListener)resolverListener22);
                    long retry = System.currentTimeMillis() + 1000L;
                    while (System.currentTimeMillis() < retry) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                MulticastDNSService.this.querier.sendAsync(updateArray[1], (ResolverListener)resolverListener22);
            }
            catch (Exception e) {
                ArrayList<Exception> arrayList = replies;
                synchronized (arrayList) {
                    replies.add(e);
                    replies.notifyAll();
                }
            }
            long endTime = System.currentTimeMillis() + 10000L;
            Object[] instances = null;
            while (instances == null && System.currentTimeMillis() < endTime) {
                if (replies.size() == 0) {
                    try {
                        resolverListener22 = replies;
                        synchronized (resolverListener22) {
                            replies.wait(1000L);
                        }
                    }
                    catch (InterruptedException resolverListener22) {
                        // empty catch block
                    }
                }
                Lookup lookup2 = new Lookup(new Name[]{shortSRVName}, 255);
                try {
                    instances = lookup2.lookupServices();
                    if (instances == null || instances.length <= 0) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, this.getClass().getName(), "register", "Response received.");
                    }
                    if (instances.length > 1) {
                        logger.logp(Level.WARNING, this.getClass().getName(), "register", "Warning: More than one service with the name \"" + shortSRVName + "\" was registered.");
                        throw new IOException("Too many services returned! + Instances: " + Arrays.toString(instances));
                    }
                    ServiceInstance serviceInstance = instances[0];
                    return serviceInstance;
                }
                finally {
                    try {
                        lookup2.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            logger.logp(Level.WARNING, this.getClass().getName(), "register", "How did the execution path getting here!?");
            throw new ServiceRegistrationException(ServiceRegistrationException.REASON.UNKNOWN);
        }
    }
}

