/*
 * Decompiled with CFR 0.152.
 */
package net.posick.mDNS.utils;

import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Misc {
    public static final Logger globalLogger = Logger.getLogger("global");

    public static final void close(Closeable closable) {
        if (closable != null) {
            try {
                closable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final StringBuilder trimTrailingDot(StringBuilder builder) {
        for (int index = builder.length() - 1; index >= 0; --index) {
            char ch = builder.charAt(index);
            if (ch == '.' || Character.isWhitespace(ch)) continue;
            builder.setLength(index);
            break;
        }
        return builder;
    }

    public static final String trimTrailingDot(String string) {
        for (int index = string.length() - 1; index >= 0; --index) {
            char ch = string.charAt(index);
            if (ch == '.' || Character.isWhitespace(ch)) continue;
            return string.substring(0, index + 1);
        }
        return string;
    }

    public static final String throwableToString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return e.getMessage() + "\nStack Trace:\n" + sw.toString();
    }

    public static final String unescape(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder output = new StringBuilder();
        char[] chars = string.toCharArray();
        boolean escape = false;
        int codePoint = 0;
        int count = 0;
        for (char c : chars) {
            if (c == '\\') {
                escape = true;
                count = 2;
                codePoint = 0;
                continue;
            }
            if (escape && count < 0) {
                escape = false;
                output.append((char)codePoint);
            }
            if (escape) {
                if (Character.isDigit(c)) {
                    codePoint = (int)((double)codePoint + (double)(c - 48) * Math.pow(10.0, count));
                }
            } else {
                output.append(c);
            }
            --count;
        }
        return output.toString();
    }

    public static Level setGlobalLogLevel(Level level) {
        Level result = globalLogger.getLevel();
        globalLogger.setLevel(Level.FINE);
        return result;
    }

    public static final Logger getLogger(Class<?> cls, boolean verbose) {
        return Misc.getLogger(cls.getName(), verbose);
    }

    public static final Logger getLogger(String name, boolean verbose) {
        Logger logger = Logger.getLogger(name);
        logger.setParent(globalLogger);
        if (verbose) {
            logger.setLevel(Level.FINEST);
        }
        return logger;
    }
}

