/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema;

import com.sun.tools.xjc.reader.Ring;
import com.sun.tools.xjc.reader.xmlschema.BGMBuilder;
import com.sun.tools.xjc.reader.xmlschema.BindingComponent;
import com.sun.tools.xjc.reader.xmlschema.SimpleTypeBuilder;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIDeclaration;
import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSAttContainer;
import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSIdentityConstraint;
import com.sun.xml.xsom.XSListSimpleType;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSNotation;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSUnionSimpleType;
import com.sun.xml.xsom.XSWildcard;
import com.sun.xml.xsom.XSXPath;
import com.sun.xml.xsom.visitor.XSSimpleTypeVisitor;
import com.sun.xml.xsom.visitor.XSVisitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class UnusedCustomizationChecker
extends BindingComponent
implements XSVisitor,
XSSimpleTypeVisitor {
    private final BGMBuilder builder = Ring.get(BGMBuilder.class);
    private final SimpleTypeBuilder stb = Ring.get(SimpleTypeBuilder.class);
    private final Set<XSComponent> visitedComponents = new HashSet<XSComponent>();

    UnusedCustomizationChecker() {
    }

    void run() {
        for (XSSchema s : Ring.get(XSSchemaSet.class).getSchemas()) {
            this.schema(s);
            this.run(s.getAttGroupDecls());
            this.run(s.getAttributeDecls());
            this.run(s.getComplexTypes());
            this.run(s.getElementDecls());
            this.run(s.getModelGroupDecls());
            this.run(s.getNotations());
            this.run(s.getSimpleTypes());
        }
    }

    private void run(Map<String, ? extends XSComponent> col) {
        for (XSComponent xSComponent : col.values()) {
            xSComponent.visit(this);
        }
    }

    private boolean check(XSComponent c) {
        if (!this.visitedComponents.add(c)) {
            return false;
        }
        for (BIDeclaration decl : this.builder.getBindInfo(c).getDecls()) {
            this.check(decl, c);
        }
        this.checkExpectedContentTypes(c);
        return true;
    }

    private void checkExpectedContentTypes(XSComponent c) {
        if (c.getForeignAttribute("http://www.w3.org/2005/05/xmlmime", "expectedContentTypes") == null) {
            return;
        }
        if (c instanceof XSParticle) {
            return;
        }
        if (!this.stb.isAcknowledgedXmimeContentTypes(c)) {
            this.getErrorReporter().warning(c.getLocator(), "UnusedCustomizationChecker.WarnUnusedExpectedContentTypes", new Object[0]);
        }
    }

    private void check(BIDeclaration decl, XSComponent c) {
        if (!decl.isAcknowledged()) {
            this.getErrorReporter().error(decl.getLocation(), "UnusedCustomizationChecker.UnacknolwedgedCustomization", decl.getName().getLocalPart());
            this.getErrorReporter().error(c.getLocator(), "UnusedCustomizationChecker.UnacknolwedgedCustomization.Relevant", new Object[0]);
            decl.markAsAcknowledged();
        }
        for (BIDeclaration d : decl.getChildren()) {
            this.check(d, c);
        }
    }

    @Override
    public void annotation(XSAnnotation ann) {
    }

    @Override
    public void attGroupDecl(XSAttGroupDecl decl) {
        if (this.check(decl)) {
            this.attContainer(decl);
        }
    }

    @Override
    public void attributeDecl(XSAttributeDecl decl) {
        if (this.check(decl)) {
            decl.getType().visit(this);
        }
    }

    @Override
    public void attributeUse(XSAttributeUse use) {
        if (this.check(use)) {
            use.getDecl().visit(this);
        }
    }

    @Override
    public void complexType(XSComplexType type) {
        if (this.check(type)) {
            type.getContentType().visit(this);
            this.attContainer(type);
        }
    }

    private void attContainer(XSAttContainer cont) {
        Iterator<XSComponent> itr = cont.iterateAttGroups();
        while (itr.hasNext()) {
            itr.next().visit(this);
        }
        itr = cont.iterateDeclaredAttributeUses();
        while (itr.hasNext()) {
            ((XSAttributeUse)itr.next()).visit(this);
        }
        XSWildcard wc = cont.getAttributeWildcard();
        if (wc != null) {
            wc.visit(this);
        }
    }

    @Override
    public void schema(XSSchema schema) {
        this.check(schema);
    }

    @Override
    public void facet(XSFacet facet2) {
        this.check(facet2);
    }

    @Override
    public void notation(XSNotation notation2) {
        this.check(notation2);
    }

    @Override
    public void wildcard(XSWildcard wc) {
        this.check(wc);
    }

    @Override
    public void modelGroupDecl(XSModelGroupDecl decl) {
        if (this.check(decl)) {
            decl.getModelGroup().visit(this);
        }
    }

    @Override
    public void modelGroup(XSModelGroup group2) {
        if (this.check(group2)) {
            for (int i = 0; i < group2.getSize(); ++i) {
                group2.getChild(i).visit(this);
            }
        }
    }

    @Override
    public void elementDecl(XSElementDecl decl) {
        if (this.check(decl)) {
            decl.getType().visit(this);
            for (XSIdentityConstraint id : decl.getIdentityConstraints()) {
                id.visit(this);
            }
        }
    }

    @Override
    public void simpleType(XSSimpleType simpleType2) {
        if (this.check(simpleType2)) {
            simpleType2.visit(this);
        }
    }

    @Override
    public void particle(XSParticle particle2) {
        if (this.check(particle2)) {
            particle2.getTerm().visit(this);
        }
    }

    @Override
    public void empty(XSContentType empty) {
        this.check(empty);
    }

    @Override
    public void listSimpleType(XSListSimpleType type) {
        if (this.check(type)) {
            type.getItemType().visit(this);
        }
    }

    @Override
    public void restrictionSimpleType(XSRestrictionSimpleType type) {
        if (this.check(type)) {
            type.getBaseType().visit(this);
        }
    }

    @Override
    public void unionSimpleType(XSUnionSimpleType type) {
        if (this.check(type)) {
            for (int i = 0; i < type.getMemberSize(); ++i) {
                type.getMember(i).visit(this);
            }
        }
    }

    @Override
    public void identityConstraint(XSIdentityConstraint id) {
        if (this.check(id)) {
            id.getSelector().visit(this);
            for (XSXPath xp : id.getFields()) {
                xp.visit(this);
            }
        }
    }

    @Override
    public void xpath(XSXPath xp) {
        this.check(xp);
    }
}

