/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import gnu.trove.set.hash.TLongHashSet;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.Street;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RoutingContext;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class GeocodingUtilities {
    private static final Log log = PlatformUtil.getLog(GeocodingUtilities.class);
    public static final float THRESHOLD_MULTIPLIER_SKIP_STREETS_AFTER = 4.0f;
    public static final float STOP_SEARCHING_STREET_WITH_MULTIPLIER_RADIUS = 100.0f;
    public static final float STOP_SEARCHING_STREET_WITHOUT_MULTIPLIER_RADIUS = 400.0f;
    public static final float DISTANCE_STREET_NAME_PROXIMITY_BY_NAME = 15000.0f;
    public static final float DISTANCE_STREET_FROM_CLOSEST_WITH_SAME_NAME = 1000.0f;
    public static final float THRESHOLD_MULTIPLIER_SKIP_BUILDINGS_AFTER = 1.5f;
    public static final float DISTANCE_BULDING_PROXIMITY = 100.0f;
    public static final String[] SUFFIXES = new String[]{"av.", "avenue", "\u043f\u0440\u043e\u0441\u043f.", "\u043f\u0435\u0440.", "\u043f\u0440.", "\u0437\u0430\u0443\u043b.", "\u043f\u0440\u043e\u0441\u043f\u0435\u043a\u0442", "\u043f\u0435\u0440\u0435\u0443\u043b.", "\u0431\u0443\u043b.", "\u0431\u0443\u043b\u044c\u0432\u0430\u0440", "\u0442\u0440\u0430\u043a\u0442"};
    public static final String[] DEFAULT_SUFFIXES = new String[]{"str.", "street", "\u0443\u043b\u0438\u0446\u0430", "\u0443\u043b.", "\u0432\u0443\u043b\u0438\u0446\u0430", "\u0432\u0443\u043b.", "\u0432\u0443\u043b\u0438\u0446\u044f"};
    private static Set<String> SET_DEF_SUFFIXES = null;
    private static Set<String> SET_SUFFIXES = null;
    public static final Comparator<GeocodingResult> DISTANCE_COMPARATOR = new Comparator<GeocodingResult>(){

        @Override
        public int compare(GeocodingResult o1, GeocodingResult o2) {
            LatLon l1 = o1.getLocation();
            LatLon l2 = o2.getLocation();
            if (l1 == null || l2 == null) {
                return l2 == l1 ? 0 : (l1 == null ? -1 : 1);
            }
            return Double.compare(MapUtils.getDistance(l1, o1.searchPoint), MapUtils.getDistance(l2, o2.searchPoint));
        }
    };

    public static Set<String> getDefSuffixesSet() {
        if (SET_DEF_SUFFIXES == null) {
            SET_DEF_SUFFIXES = new TreeSet<String>();
            SET_DEF_SUFFIXES.addAll(Arrays.asList(DEFAULT_SUFFIXES));
        }
        return SET_DEF_SUFFIXES;
    }

    public static Set<String> getSuffixesSet() {
        if (SET_SUFFIXES == null) {
            SET_SUFFIXES = new TreeSet<String>();
            SET_SUFFIXES.addAll(Arrays.asList(SUFFIXES));
        }
        return SET_SUFFIXES;
    }

    public List<GeocodingResult> reverseGeocodingSearch(RoutingContext ctx, double lat, double lon) throws IOException {
        RoutePlannerFrontEnd rp = new RoutePlannerFrontEnd(false);
        ArrayList<GeocodingResult> lst = new ArrayList<GeocodingResult>();
        ArrayList<BinaryRoutePlanner.RouteSegmentPoint> listR = new ArrayList<BinaryRoutePlanner.RouteSegmentPoint>();
        rp.findRouteSegment(lat, lon, ctx, listR);
        double distSquare = 0.0;
        TLongHashSet set = new TLongHashSet();
        HashSet<String> streetNames = new HashSet<String>();
        for (BinaryRoutePlanner.RouteSegmentPoint p : listR) {
            boolean emptyName;
            RouteDataObject road = p.getRoad();
            if (!set.add(road.getId())) continue;
            boolean bl = emptyName = Algorithms.isEmpty(road.getName()) && Algorithms.isEmpty(road.getRef());
            if (!emptyName) {
                if (distSquare == 0.0 || distSquare > p.distSquare) {
                    distSquare = p.distSquare;
                }
                GeocodingResult sr = new GeocodingResult();
                sr.searchPoint = new LatLon(lat, lon);
                sr.streetName = Algorithms.isEmpty(road.getName()) ? road.getRef() : road.getName();
                sr.point = p;
                sr.connectionPoint = new LatLon(MapUtils.get31LatitudeY(p.preciseY), MapUtils.get31LongitudeX(p.preciseX));
                sr.regionFP = road.region.getFilePointer();
                sr.regionLen = road.region.getLength();
                if (streetNames.add(sr.streetName)) {
                    lst.add(sr);
                }
            }
            if (!(p.distSquare > 10000.0 && distSquare != 0.0 && p.distSquare > 4.0 * distSquare) && !(p.distSquare > 160000.0)) continue;
            break;
        }
        Collections.sort(lst, DISTANCE_COMPARATOR);
        return lst;
    }

    public List<String> prepareStreetName(String s) {
        ArrayList<String> ls = new ArrayList<String>();
        int beginning = 0;
        block0: for (int i = 1; i < s.length(); ++i) {
            if (s.charAt(i) == ' ') {
                this.addWord(ls, s.substring(beginning, i));
                beginning = i;
                continue;
            }
            if (s.charAt(i) != '(') continue;
            this.addWord(ls, s.substring(beginning, i));
            while (i < s.length()) {
                char c = s.charAt(i);
                beginning = ++i;
                if (c != ')') continue;
                continue block0;
            }
        }
        if (beginning < s.length()) {
            String lastWord = s.substring(beginning, s.length());
            this.addWord(ls, lastWord);
        }
        Collections.sort(ls, Collator.getInstance());
        return ls;
    }

    private void addWord(List<String> ls, String word) {
        String w = word.trim().toLowerCase();
        if (!Algorithms.isEmpty(w) && !GeocodingUtilities.getDefSuffixesSet().contains(w)) {
            ls.add(w);
        }
    }

    public List<GeocodingResult> justifyReverseGeocodingSearch(final GeocodingResult road, BinaryMapIndexReader reader, double knownMinBuidlingDistance, final ResultMatcher<GeocodingResult> result) throws IOException {
        final ArrayList streetsList = new ArrayList();
        final List<String> streetNamePacked = this.prepareStreetName(road.streetName);
        if (streetNamePacked.size() > 0) {
            log.info((Object)("Search street by name " + road.streetName + " " + streetNamePacked));
            String mainWord = "";
            for (int i = 0; i < streetNamePacked.size(); ++i) {
                String s = streetNamePacked.get(i);
                if (GeocodingUtilities.getSuffixesSet().contains(s) || s.length() <= mainWord.length()) continue;
                mainWord = s;
            }
            if (Algorithms.isEmpty(mainWord)) {
                mainWord = streetNamePacked.get(0);
            }
            BinaryMapIndexReader.SearchRequest<MapObject> req = BinaryMapIndexReader.buildAddressByNameRequest(new ResultMatcher<MapObject>(){

                @Override
                public boolean publish(MapObject object) {
                    if (object instanceof Street && GeocodingUtilities.this.prepareStreetName(object.getName()).equals(streetNamePacked)) {
                        double d = MapUtils.getDistance(object.getLocation(), road.searchPoint.getLatitude(), road.searchPoint.getLongitude());
                        if (d < 15000.0) {
                            GeocodingResult rs = new GeocodingResult(road);
                            rs.street = (Street)object;
                            rs.connectionPoint = rs.street.getLocation();
                            rs.city = rs.street.getCity();
                            streetsList.add(rs);
                            return true;
                        }
                        return false;
                    }
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return result != null && result.isCancelled();
                }
            }, mainWord);
            reader.searchAddressDataByName(req);
        }
        ArrayList<GeocodingResult> res = new ArrayList<GeocodingResult>();
        if (streetsList.size() == 0) {
            res.add(road);
        } else {
            Collections.sort(streetsList, DISTANCE_COMPARATOR);
            double streetDistance = 0.0;
            for (GeocodingResult street : streetsList) {
                if (streetDistance == 0.0) {
                    streetDistance = street.getDistance();
                } else if (street.getDistance() > streetDistance + 1000.0) continue;
                street.connectionPoint = road.connectionPoint;
                List<GeocodingResult> streetBuildings = this.loadStreetBuildings(road, reader, street);
                Collections.sort(streetBuildings, DISTANCE_COMPARATOR);
                if (streetBuildings.size() > 0) {
                    GeocodingResult nextBld;
                    Iterator<GeocodingResult> it = streetBuildings.iterator();
                    if (knownMinBuidlingDistance == 0.0) {
                        GeocodingResult firstBld = it.next();
                        knownMinBuidlingDistance = firstBld.getDistance();
                        res.add(firstBld);
                    }
                    while (it.hasNext() && !((nextBld = it.next()).getDistance() > knownMinBuidlingDistance * 1.5)) {
                        res.add(nextBld);
                    }
                }
                res.add(street);
            }
        }
        Collections.sort(res, DISTANCE_COMPARATOR);
        return res;
    }

    private List<GeocodingResult> loadStreetBuildings(GeocodingResult road, BinaryMapIndexReader reader, GeocodingResult street) throws IOException {
        ArrayList<GeocodingResult> streetBuildings = new ArrayList<GeocodingResult>();
        reader.preloadBuildings(street.street, null);
        log.info((Object)("Preload buildings " + street.street.getName() + " " + street.city.getName() + " " + street.street.getId()));
        for (Building b : street.street.getBuildings()) {
            if (b.getLatLon2() != null) {
                int intv;
                double plon;
                double slat = b.getLocation().getLatitude();
                double slon = b.getLocation().getLongitude();
                double tolat = b.getLatLon2().getLatitude();
                double tolon = b.getLatLon2().getLongitude();
                double coeff = MapUtils.getProjectionCoeff(road.searchPoint.getLatitude(), road.searchPoint.getLongitude(), slat, slon, tolat, tolon);
                double plat = slat + (tolat - slat) * coeff;
                if (!(MapUtils.getDistance(road.searchPoint, plat, plon = slon + (tolon - slon) * coeff) < 100.0)) continue;
                GeocodingResult bld = new GeocodingResult(street);
                bld.building = b;
                bld.connectionPoint = b.getLocation();
                streetBuildings.add(bld);
                if (Algorithms.isEmpty(b.getName2())) continue;
                int fi = Algorithms.extractFirstIntegerNumber(b.getName());
                int si = Algorithms.extractFirstIntegerNumber(b.getName2());
                if (si == 0 || fi == 0) continue;
                int num = (int)((double)fi + (double)(si - fi) * coeff);
                Building.BuildingInterpolation type = b.getInterpolationType();
                if (type == Building.BuildingInterpolation.EVEN || type == Building.BuildingInterpolation.ODD) {
                    if (num % 2 == (type == Building.BuildingInterpolation.EVEN ? 1 : 0)) {
                        --num;
                    }
                } else if (b.getInterpolationInterval() > 0 && (num - fi) % (intv = b.getInterpolationInterval()) != 0) {
                    num = (num - fi) / intv * intv + fi;
                }
                bld.buildingInterpolation = num + "";
                continue;
            }
            if (!(MapUtils.getDistance(b.getLocation(), road.searchPoint) < 100.0)) continue;
            GeocodingResult bld = new GeocodingResult(street);
            bld.building = b;
            bld.connectionPoint = b.getLocation();
            streetBuildings.add(bld);
        }
        return streetBuildings;
    }

    public static class GeocodingResult {
        public LatLon searchPoint;
        public LatLon connectionPoint;
        public int regionFP;
        public int regionLen;
        public BinaryRoutePlanner.RouteSegmentPoint point;
        public String streetName;
        public Building building;
        public String buildingInterpolation;
        public Street street;
        public City city;
        private double dist = -1.0;

        public GeocodingResult() {
        }

        public GeocodingResult(GeocodingResult r) {
            this.searchPoint = r.searchPoint;
            this.regionFP = r.regionFP;
            this.regionLen = r.regionLen;
            this.connectionPoint = r.connectionPoint;
            this.streetName = r.streetName;
            this.point = r.point;
            this.building = r.building;
            this.city = r.city;
            this.street = r.street;
        }

        public LatLon getLocation() {
            return this.connectionPoint;
        }

        public double getDistance() {
            if (this.dist == -1.0 && this.connectionPoint != null && this.searchPoint != null) {
                this.dist = MapUtils.getDistance(this.connectionPoint, this.searchPoint);
            }
            return this.dist;
        }

        public double getDistanceP() {
            if (this.point != null && this.searchPoint != null) {
                return Math.sqrt(this.point.distSquare);
            }
            return -1.0;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            if (this.building != null) {
                bld.append(this.building.getName());
            }
            if (this.street != null) {
                bld.append(" str. ").append(this.street.getName()).append(" city ").append(this.city.getName());
            } else if (this.streetName != null) {
                bld.append(" str. ").append(this.streetName);
            } else if (this.city != null) {
                bld.append(" city ").append(this.city.getName());
            }
            if (this.connectionPoint != null && this.searchPoint != null) {
                bld.append(" dist=").append((int)this.getDistance());
            }
            return bld.toString();
        }
    }
}

