/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.osmand.PlatformUtil;
import net.osmand.plus.GPXUtilities;
import net.osmand.plus.GpxSelectionHelper;
import net.osmand.plus.helpers.GpxUiHelper;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.actions.OffRoadAction;
import org.apache.commons.logging.Log;

public class SelectTrackAction
extends OffRoadAction {
    private JTextField mTextField;
    private TrackTableModel mSourceModel;
    private JTable mTable;
    private KeyAdapter mKeyListener;
    private MouseAdapter mMouseListener;
    private TableRowSorter<TrackTableModel> mSorter;
    private static final Log log = PlatformUtil.getLog(SelectTrackAction.class);

    public SelectTrackAction(OsmWindow pContext, String pTitle) {
        super(pContext, pTitle, null);
    }

    public SelectTrackAction(OsmWindow pContext) {
        super(pContext);
    }

    @Override
    public void actionPerformed(ActionEvent pE) {
        this.createDialog();
        this.setWaitingCursor();
        this.mDialog.setTitle(this.getResourceString("select_track"));
        Container contentPane = this.mDialog.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        gbl.columnWeights = new double[]{1.0};
        gbl.rowWeights = new double[]{1.0};
        contentPane.setLayout(gbl);
        int y = 0;
        contentPane.add((Component)new JLabel(this.getResourceString("filter")), new GridBagConstraints(0, y, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.mTextField = new JTextField();
        contentPane.add((Component)this.mTextField, new GridBagConstraints(1, y++, 1, 1, 4.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mTable = new JTable();
        this.mTable.setRowHeight(UIManager.getFont("Table.font").getSize());
        this.mSourceModel = new TrackTableModel();
        this.mTable.setModel(this.mSourceModel);
        this.mTable.setSelectionMode(2);
        this.mSorter = new TableRowSorter<TrackTableModel>(this.mSourceModel);
        this.mTable.setRowSorter(this.mSorter);
        this.mTextField.getDocument().addDocumentListener(new FilterTextDocumentListener());
        this.mTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent pE) {
                if (pE.getKeyCode() == 40) {
                    pE.consume();
                    SelectTrackAction.this.mTable.requestFocus();
                    SelectTrackAction.this.selectFirstElementIfNecessary();
                }
            }
        });
        this.mTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "Enter");
        this.mTable.getActionMap().put("Enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SelectTrackAction.this.toggleSelectedItems(SelectTrackAction.this.mSourceModel.getSelectedRows());
            }
        });
        this.mKeyListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent pE) {
                if (pE.getKeyCode() == 38 && SelectTrackAction.this.mTable.getSelectedRowCount() == 0) {
                    pE.consume();
                    SelectTrackAction.this.requestFocusToTextField();
                }
                super.keyTyped(pE);
            }
        };
        this.mTable.addKeyListener(this.mKeyListener);
        this.mMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() >= 2) {
                    evt.consume();
                    SelectTrackAction.this.toggleSelectedItems(SelectTrackAction.this.mSourceModel.getSelectedRows());
                }
            }
        };
        this.mTable.addMouseListener(this.mMouseListener);
        contentPane.add((Component)new JScrollPane(this.mTable), new GridBagConstraints(0, y++, 2, 1, 1.0, 4.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        List<GpxSelectionHelper.SelectedGpxFile> selectedGPXFiles = this.mContext.getSelectedGpxHelper().getSelectedGPXFiles();
        List<String> fileList = GpxUiHelper.getSortedGPXFilenames(this.mContext.getAppPath("tracks/import/"), true);
        for (String file : fileList) {
            GPXUtilities.GPXFile gpxFile = null;
            for (GpxSelectionHelper.SelectedGpxFile selFile : selectedGPXFiles) {
                String path = selFile.getGpxFile().path;
                if (!path.equals(file)) continue;
                gpxFile = selFile.getGpxFile();
                break;
            }
            this.mSourceModel.addRow(new TrackItem(new File(file), gpxFile));
        }
        this.mDialog.pack();
        this.decorateDialog();
        this.removeWaitingCursor();
        this.decorateDialog();
        this.mDialog.setVisible(true);
    }

    protected void toggleSelectedItems(List<TrackItem> pList) {
        if (pList.isEmpty()) {
            return;
        }
        boolean select = !pList.get(0).isSelected();
        for (TrackItem trackItem : pList) {
            log.info((Object)("Select (" + select + ") of item " + trackItem));
            if (select) {
                if (trackItem.mGpxFile != null) continue;
                GPXUtilities.GPXFile gpxFile = GPXUtilities.loadGPXFile(this.mContext, trackItem.mFile);
                trackItem.mGpxFile = gpxFile;
                continue;
            }
            if (trackItem.mGpxFile == null) continue;
            trackItem.mGpxFile = null;
        }
        this.mContext.getSelectedGpxHelper().clearAllGpxFileToShow();
        for (TrackItem trackItem : this.mSourceModel.mRows) {
            if (trackItem.mGpxFile == null) continue;
            this.mContext.getSelectedGpxHelper().selectGpxFile(trackItem.mGpxFile, true, false);
        }
        this.mContext.getDrawPanel().drawLater();
        this.mSourceModel.fireTableDataChanged();
    }

    public void selectFirstElementIfNecessary() {
        if (this.mTable.getSelectedRowCount() == 0 && this.mTable.getModel().getRowCount() > 0) {
            this.mTable.setRowSelectionInterval(0, 0);
        }
    }

    public void requestFocusToTextField() {
        this.mTextField.selectAll();
        this.mTextField.requestFocus();
    }

    private final class FilterTextDocumentListener
    implements DocumentListener {
        private static final int TYPE_DELAY_TIME = 500;
        private Timer mTypeDelayTimer = null;

        private synchronized void change(DocumentEvent event) {
            if (this.mTypeDelayTimer != null) {
                this.mTypeDelayTimer.cancel();
                this.mTypeDelayTimer = null;
            }
            this.mTypeDelayTimer = new Timer();
            this.mTypeDelayTimer.schedule((TimerTask)new DelayedTextEntry(event), 500L);
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            this.change(event);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            this.change(event);
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            this.change(event);
        }

        protected class DelayedTextEntry
        extends TimerTask {
            private final DocumentEvent event;

            DelayedTextEntry(DocumentEvent event) {
                this.event = event;
            }

            private String getText(Document document) throws BadLocationException {
                String text = document.getText(0, document.getLength());
                return text;
            }

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Document document = DelayedTextEntry.this.event.getDocument();
                            String text = DelayedTextEntry.this.getText(document);
                            RowFilter rf = null;
                            try {
                                rf = RowFilter.regexFilter("(?i)" + text, 1);
                            }
                            catch (PatternSyntaxException e) {
                                return;
                            }
                            SelectTrackAction.this.mSorter.setRowFilter(rf);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
            }
        }
    }

    public class TrackTableModel
    extends AbstractTableModel {
        private Vector<TrackTableColumn> mColumns = new Vector();
        private Vector<TrackItem> mRows = new Vector();

        public TrackTableModel() {
            this.mColumns.addElement(new TrackTableColumn("selected", Boolean.class, item -> item.isSelected(), new SelectedTableCellRenderer()));
            this.mColumns.addElement(new TrackTableColumn("name", String.class, item -> item.getFile(), new DefaultTableCellRenderer()));
            this.mColumns.addElement(new TrackTableColumn("author", String.class, item -> item.getAuthor(), new DefaultTableCellRenderer()));
            this.mColumns.addElement(new TrackTableColumn("date", Date.class, item -> item.getDate(), new GpxDateTableCellRenderer()));
            this.mColumns.addElement(new TrackTableColumn("distance", String.class, item -> item.getTotalDistance(), new DefaultTableCellRenderer()));
            for (TrackTableColumn column : this.mColumns) {
                SelectTrackAction.this.mTable.setDefaultRenderer(column.mClass, column.mRenderer);
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.mColumns.get((int)columnIndex).mClass;
        }

        @Override
        public String getColumnName(int pColumn) {
            return SelectTrackAction.this.getResourceString(this.mColumns.get((int)pColumn).mName);
        }

        public void addRow(TrackItem pItem) {
            this.mRows.add(pItem);
        }

        public TrackItem getItemAt(int pJ) {
            return this.mRows.get(pJ);
        }

        @Override
        public int getRowCount() {
            return this.mRows.size();
        }

        @Override
        public int getColumnCount() {
            return this.mColumns.size();
        }

        @Override
        public Object getValueAt(int pRowIndex, int pColumnIndex) {
            TrackTableColumn column = this.mColumns.get(pColumnIndex);
            return column.mMapping.get(this.getItemAt(pRowIndex));
        }

        public List<TrackItem> getSelectedRows() {
            int[] selectedRows = SelectTrackAction.this.mTable.getSelectedRows();
            Vector<TrackItem> res = new Vector<TrackItem>();
            for (int i = 0; i < selectedRows.length; ++i) {
                int j = SelectTrackAction.this.mTable.convertRowIndexToModel(selectedRows[i]);
                res.add(this.getItemAt(j));
            }
            return res;
        }
    }

    public static class TrackTableColumn {
        String mName;
        public Class<?> mClass;
        private TrackItemToColumn mMapping;
        private TableCellRenderer mRenderer;

        public TrackTableColumn(String pName, Class<?> pClass, TrackItemToColumn pMapping, TableCellRenderer pRenderer) {
            this.mName = pName;
            this.mClass = pClass;
            this.mMapping = pMapping;
            this.mRenderer = pRenderer;
        }
    }

    static interface TrackItemToColumn {
        public Object get(TrackItem var1);
    }

    public class SelectedTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Boolean) {
                Boolean d = (Boolean)value;
                this.setText(d.toString());
            }
            return this;
        }
    }

    public class GpxDateTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Date) {
                Date d = (Date)value;
                this.setText(DateFormat.getDateTimeInstance().format(d));
            }
            return this;
        }
    }

    public static class TrackItem {
        File mFile;
        private GPXUtilities.GPXFile mGpxFile;

        public String toString() {
            return "TrackItem [mFile=" + this.mFile + ", mGpxFile=" + this.mGpxFile + "]";
        }

        public String getFile() {
            return this.mFile.getName();
        }

        public TrackItem(File pFile, GPXUtilities.GPXFile pGpxFile) {
            this.mFile = pFile;
            this.mGpxFile = pGpxFile;
        }

        public boolean isSelected() {
            return this.mGpxFile != null;
        }

        public Date getDate() {
            GPXUtilities.WptPt lastPoint;
            if (this.isSelected() && (lastPoint = this.mGpxFile.getLastPoint()) != null) {
                return new Date(lastPoint.time);
            }
            return null;
        }

        public String getAuthor() {
            if (this.isSelected()) {
                return this.mGpxFile.author;
            }
            return "";
        }

        public String getTotalDistance() {
            if (this.isSelected()) {
                return "" + this.mGpxFile.getAnalysis((long)0L).totalDistance;
            }
            return "";
        }
    }
}

