/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.util.StringTokenizer;
import net.sourceforge.plantuml.cute.RotationZoom;

public class MyDouble {
    private static final double NO_CURVE = Double.MIN_VALUE;
    private final double value;
    private final double curvation;

    public MyDouble(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        this.value = Double.parseDouble(st.nextToken());
        this.curvation = st.hasMoreTokens() ? Double.parseDouble(st.nextToken()) : Double.MIN_VALUE;
    }

    public String toString() {
        return this.value + "[" + this.curvation + "]";
    }

    private MyDouble(double value, double curvation) {
        this.value = value;
        this.curvation = curvation;
    }

    public double getCurvation(double def) {
        if (this.curvation == Double.MIN_VALUE) {
            return def;
        }
        return this.curvation;
    }

    public double getValue() {
        return this.value;
    }

    public boolean hasCurvation() {
        return this.curvation != Double.MIN_VALUE;
    }

    public MyDouble rotateZoom(RotationZoom rotationZoom) {
        double newValue = rotationZoom.applyZoom(this.value);
        double curvation = this.curvation == Double.MIN_VALUE ? Double.MIN_VALUE : rotationZoom.applyZoom(this.curvation);
        return new MyDouble(newValue, curvation);
    }

    public MyDouble toRadians() {
        return new MyDouble(Math.toRadians(this.value), this.curvation);
    }
}

