/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CancelledException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.file.GcLog;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.internal.storage.file.ObjectDirectoryInserter;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.RefDirectory;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.internal.storage.reftree.RefTreeNames;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSet;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.internal.WorkQueue;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.GitDateParser;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GC {
    private static final Logger LOG = LoggerFactory.getLogger(GC.class);
    private static final String PRUNE_EXPIRE_DEFAULT = "2.weeks.ago";
    private static final String PRUNE_PACK_EXPIRE_DEFAULT = "1.hour.ago";
    private static final Pattern PATTERN_LOOSE_OBJECT = Pattern.compile("[0-9a-fA-F]{38}");
    private static final String PACK_EXT = "." + PackExt.PACK.getExtension();
    private static final String BITMAP_EXT = "." + PackExt.BITMAP_INDEX.getExtension();
    private static final String INDEX_EXT = "." + PackExt.INDEX.getExtension();
    private static final int DEFAULT_AUTOPACKLIMIT = 50;
    private static final int DEFAULT_AUTOLIMIT = 6700;
    private static volatile ExecutorService executor;
    private final FileRepository repo;
    private ProgressMonitor pm;
    private long expireAgeMillis = -1L;
    private Date expire;
    private long packExpireAgeMillis = -1L;
    private Date packExpire;
    private PackConfig pconfig = null;
    private Collection<Ref> lastPackedRefs;
    private long lastRepackTime;
    private boolean automatic;
    private boolean background;

    public static void setExecutor(ExecutorService e) {
        executor = e;
    }

    public GC(FileRepository repo) {
        this.repo = repo;
        this.pm = NullProgressMonitor.INSTANCE;
    }

    public Collection<PackFile> gc() throws IOException, ParseException {
        GcLog gcLog;
        GcLog gcLog2 = gcLog = this.background ? new GcLog(this.repo) : null;
        if (gcLog != null && !gcLog.lock(this.background)) {
            return Collections.emptyList();
        }
        Callable<Collection> gcTask = () -> {
            block12: {
                try {
                    Object message;
                    Collection<PackFile> newPacks = this.doGc();
                    if (this.automatic && this.tooManyLooseObjects() && gcLog != null) {
                        message = JGitText.get().gcTooManyUnpruned;
                        gcLog.write((String)message);
                        gcLog.commit();
                    }
                    message = newPacks;
                    return message;
                }
                catch (IOException | ParseException e) {
                    if (this.background) {
                        if (gcLog == null) {
                            List message = Collections.emptyList();
                            return message;
                        }
                        try {
                            gcLog.write(e.getMessage());
                            StringWriter sw = new StringWriter();
                            e.printStackTrace(new PrintWriter(sw));
                            gcLog.write(sw.toString());
                            gcLog.commit();
                        }
                        catch (IOException e2) {
                            e2.addSuppressed(e);
                            LOG.error(e2.getMessage(), (Throwable)e2);
                        }
                        break block12;
                    }
                    throw new JGitInternalException(e.getMessage(), e);
                }
                finally {
                    if (gcLog != null) {
                        gcLog.unlock();
                    }
                }
            }
            return Collections.emptyList();
        };
        Future<Collection> result = this.executor().submit(gcTask);
        if (this.background) {
            return Collections.emptyList();
        }
        try {
            return result.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    private ExecutorService executor() {
        return executor != null ? executor : WorkQueue.getExecutor();
    }

    private Collection<PackFile> doGc() throws IOException, ParseException {
        if (this.automatic && !this.needGc()) {
            return Collections.emptyList();
        }
        this.pm.start(6);
        this.packRefs();
        Collection<PackFile> newPacks = this.repack();
        this.prune(Collections.emptySet());
        return newPacks;
    }

    private void loosen(ObjectDirectoryInserter inserter, ObjectReader reader, PackFile pack, HashSet<ObjectId> existing) throws IOException {
        for (PackIndex.MutableEntry entry : pack) {
            ObjectId oid = entry.toObjectId();
            if (existing.contains(oid)) continue;
            existing.add(oid);
            ObjectLoader loader = reader.open(oid);
            inserter.insert(loader.getType(), loader.getSize(), loader.openStream(), true);
        }
    }

    private void deleteOldPacks(Collection<PackFile> oldPacks, Collection<PackFile> newPacks) throws ParseException, IOException {
        HashSet<ObjectId> ids = new HashSet<ObjectId>();
        for (PackFile pack : newPacks) {
            for (PackIndex.MutableEntry entry : pack) {
                ids.add(entry.toObjectId());
            }
        }
        ObjectReader reader = this.repo.newObjectReader();
        ObjectDirectory dir = this.repo.getObjectDatabase();
        ObjectDirectoryInserter inserter = dir.newInserter();
        boolean shouldLoosen = !"now".equals(this.getPruneExpireStr()) && this.getExpireDate() < Long.MAX_VALUE;
        this.prunePreserved();
        long packExpireDate = this.getPackExpireDate();
        block2: for (PackFile oldPack : oldPacks) {
            this.checkCancelled();
            String oldName = oldPack.getPackName();
            for (PackFile newPack : newPacks) {
                if (!oldName.equals(newPack.getPackName())) continue;
                continue block2;
            }
            if (oldPack.shouldBeKept() || this.repo.getFS().lastModified(oldPack.getPackFile()) >= packExpireDate) continue;
            oldPack.close();
            if (shouldLoosen) {
                this.loosen(inserter, reader, oldPack, ids);
            }
            this.prunePack(oldName);
        }
        this.repo.getObjectDatabase().close();
    }

    private void removeOldPack(File packFile, String packName, PackExt ext, int deleteOptions) throws IOException {
        if (this.pconfig != null && this.pconfig.isPreserveOldPacks()) {
            File oldPackDir = this.repo.getObjectDatabase().getPreservedDirectory();
            FileUtils.mkdir(oldPackDir, true);
            String oldPackName = "pack-" + packName + ".old-" + ext.getExtension();
            File oldPackFile = new File(oldPackDir, oldPackName);
            FileUtils.rename(packFile, oldPackFile);
        } else {
            FileUtils.delete(packFile, deleteOptions);
        }
    }

    private void prunePreserved() {
        if (this.pconfig != null && this.pconfig.isPrunePreserved()) {
            try {
                FileUtils.delete(this.repo.getObjectDatabase().getPreservedDirectory(), 7);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void prunePack(String packName) {
        PackExt[] extensions = PackExt.values();
        try {
            File f;
            int deleteOptions = 6;
            for (PackExt ext : extensions) {
                if (!PackExt.PACK.equals(ext)) continue;
                f = this.nameFor(packName, "." + ext.getExtension());
                this.removeOldPack(f, packName, ext, deleteOptions);
                break;
            }
            deleteOptions |= 8;
            for (PackExt ext : extensions) {
                if (PackExt.PACK.equals(ext)) continue;
                f = this.nameFor(packName, "." + ext.getExtension());
                this.removeOldPack(f, packName, ext, deleteOptions);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prunePacked() throws IOException {
        ObjectDirectory objdb = this.repo.getObjectDatabase();
        Collection<PackFile> packs = objdb.getPacks();
        File objects = this.repo.getObjectsDirectory();
        String[] fanout = objects.list();
        if (fanout != null && fanout.length > 0) {
            this.pm.beginTask(JGitText.get().pruneLoosePackedObjects, fanout.length);
            try {
                for (String d : fanout) {
                    String[] entries;
                    this.checkCancelled();
                    this.pm.update(1);
                    if (d.length() != 2 || (entries = new File(objects, d).list()) == null) continue;
                    for (String e : entries) {
                        ObjectId id;
                        this.checkCancelled();
                        if (e.length() != 38) continue;
                        try {
                            id = ObjectId.fromString(d + e);
                        }
                        catch (IllegalArgumentException notAnObject) {
                            continue;
                        }
                        boolean found = false;
                        for (PackFile p : packs) {
                            this.checkCancelled();
                            if (!p.hasObject(id)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        FileUtils.delete(objdb.fileFor(id), 14);
                    }
                }
            }
            finally {
                this.pm.endTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prune(Set<ObjectId> objectsToKeep) throws IOException, ParseException {
        Collection<Ref> newRefs;
        long expireDate = this.getExpireDate();
        HashMap<ObjectId, File> deletionCandidates = new HashMap<ObjectId, File>();
        Set<ObjectId> indexObjects = null;
        File objects = this.repo.getObjectsDirectory();
        String[] fanout = objects.list();
        if (fanout == null || fanout.length == 0) {
            return;
        }
        this.pm.beginTask(JGitText.get().pruneLooseUnreferencedObjects, fanout.length);
        try {
            for (String d : fanout) {
                File[] entries;
                this.checkCancelled();
                this.pm.update(1);
                if (d.length() != 2 || (entries = new File(objects, d).listFiles()) == null) continue;
                for (File f : entries) {
                    this.checkCancelled();
                    String fName = f.getName();
                    if (fName.length() != 38 || this.repo.getFS().lastModified(f) >= expireDate) continue;
                    try {
                        ObjectId id = ObjectId.fromString(d + fName);
                        if (objectsToKeep.contains(id)) continue;
                        if (indexObjects == null) {
                            indexObjects = this.listNonHEADIndexObjects();
                        }
                        if (indexObjects.contains(id)) continue;
                        deletionCandidates.put(id, f);
                    }
                    catch (IllegalArgumentException notAnObject) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            this.pm.endTask();
        }
        if (deletionCandidates.isEmpty()) {
            return;
        }
        this.checkCancelled();
        if (this.lastPackedRefs == null || this.lastPackedRefs.isEmpty()) {
            newRefs = this.getAllRefs();
        } else {
            HashMap<String, Ref> last = new HashMap<String, Ref>();
            for (Ref r : this.lastPackedRefs) {
                last.put(r.getName(), r);
            }
            newRefs = new ArrayList<Ref>();
            for (Ref r : this.getAllRefs()) {
                Object old;
                if (GC.equals(r, (Ref)(old = (Ref)last.get(r.getName())))) continue;
                newRefs.add(r);
            }
        }
        if (!newRefs.isEmpty()) {
            ObjectWalk w = new ObjectWalk(this.repo);
            try {
                for (Ref cr : newRefs) {
                    this.checkCancelled();
                    w.markStart(w.parseAny(cr.getObjectId()));
                }
                if (this.lastPackedRefs != null) {
                    for (Ref lpr : this.lastPackedRefs) {
                        w.markUninteresting(w.parseAny(lpr.getObjectId()));
                    }
                }
                this.removeReferenced(deletionCandidates, w);
            }
            finally {
                w.dispose();
            }
        }
        if (deletionCandidates.isEmpty()) {
            return;
        }
        ObjectWalk w = new ObjectWalk(this.repo);
        try {
            for (Ref ar : this.getAllRefs()) {
                for (ObjectId id : this.listRefLogObjects(ar, this.lastRepackTime)) {
                    this.checkCancelled();
                    w.markStart(w.parseAny(id));
                }
            }
            if (this.lastPackedRefs != null) {
                for (Ref lpr : this.lastPackedRefs) {
                    this.checkCancelled();
                    w.markUninteresting(w.parseAny(lpr.getObjectId()));
                }
            }
            this.removeReferenced(deletionCandidates, w);
        }
        finally {
            w.dispose();
        }
        if (deletionCandidates.isEmpty()) {
            return;
        }
        this.checkCancelled();
        HashSet<File> touchedFanout = new HashSet<File>();
        for (File f : deletionCandidates.values()) {
            if (f.lastModified() >= expireDate) continue;
            f.delete();
            touchedFanout.add(f.getParentFile());
        }
        for (File f : touchedFanout) {
            FileUtils.delete(f, 24);
        }
        this.repo.getObjectDatabase().close();
    }

    private long getExpireDate() throws ParseException {
        long expireDate = Long.MAX_VALUE;
        if (this.expire == null && this.expireAgeMillis == -1L) {
            String pruneExpireStr = this.getPruneExpireStr();
            if (pruneExpireStr == null) {
                pruneExpireStr = PRUNE_EXPIRE_DEFAULT;
            }
            this.expire = GitDateParser.parse(pruneExpireStr, null, SystemReader.getInstance().getLocale());
            this.expireAgeMillis = -1L;
        }
        if (this.expire != null) {
            expireDate = this.expire.getTime();
        }
        if (this.expireAgeMillis != -1L) {
            expireDate = System.currentTimeMillis() - this.expireAgeMillis;
        }
        return expireDate;
    }

    private String getPruneExpireStr() {
        return this.repo.getConfig().getString("gc", null, "pruneexpire");
    }

    private long getPackExpireDate() throws ParseException {
        long packExpireDate = Long.MAX_VALUE;
        if (this.packExpire == null && this.packExpireAgeMillis == -1L) {
            String prunePackExpireStr = this.repo.getConfig().getString("gc", null, "prunepackexpire");
            if (prunePackExpireStr == null) {
                prunePackExpireStr = PRUNE_PACK_EXPIRE_DEFAULT;
            }
            this.packExpire = GitDateParser.parse(prunePackExpireStr, null, SystemReader.getInstance().getLocale());
            this.packExpireAgeMillis = -1L;
        }
        if (this.packExpire != null) {
            packExpireDate = this.packExpire.getTime();
        }
        if (this.packExpireAgeMillis != -1L) {
            packExpireDate = System.currentTimeMillis() - this.packExpireAgeMillis;
        }
        return packExpireDate;
    }

    private void removeReferenced(Map<ObjectId, File> id2File, ObjectWalk w) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevObject ro = w.next();
        while (ro != null) {
            this.checkCancelled();
            if (id2File.remove(ro.getId()) != null && id2File.isEmpty()) {
                return;
            }
            ro = w.next();
        }
        ro = w.nextObject();
        while (ro != null) {
            this.checkCancelled();
            if (id2File.remove(ro.getId()) != null && id2File.isEmpty()) {
                return;
            }
            ro = w.nextObject();
        }
    }

    private static boolean equals(Ref r1, Ref r2) {
        if (r1 == null || r2 == null) {
            return false;
        }
        if (r1.isSymbolic()) {
            if (!r2.isSymbolic()) {
                return false;
            }
            return r1.getTarget().getName().equals(r2.getTarget().getName());
        }
        if (r2.isSymbolic()) {
            return false;
        }
        return Objects.equals(r1.getObjectId(), r2.getObjectId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void packRefs() throws IOException {
        Collection<Ref> refs = this.repo.getRefDatabase().getRefs("refs/").values();
        ArrayList<String> refsToBePacked = new ArrayList<String>(refs.size());
        this.pm.beginTask(JGitText.get().packRefs, refs.size());
        try {
            for (Ref ref : refs) {
                this.checkCancelled();
                if (!ref.isSymbolic() && ref.getStorage().isLoose()) {
                    refsToBePacked.add(ref.getName());
                }
                this.pm.update(1);
            }
            ((RefDirectory)this.repo.getRefDatabase()).pack(refsToBePacked);
        }
        finally {
            this.pm.endTask();
        }
    }

    public Collection<PackFile> repack() throws IOException {
        PackFile txn;
        PackFile rest;
        Collection<PackFile> toBeDeleted = this.repo.getObjectDatabase().getPacks();
        long time = System.currentTimeMillis();
        Collection<Ref> refsBefore = this.getAllRefs();
        HashSet allHeadsAndTags = new HashSet();
        HashSet<ObjectId> allHeads = new HashSet<ObjectId>();
        HashSet<ObjectId> allTags = new HashSet<ObjectId>();
        HashSet<ObjectId> nonHeads = new HashSet<ObjectId>();
        HashSet<ObjectId> txnHeads = new HashSet<ObjectId>();
        HashSet<ObjectId> tagTargets = new HashSet<ObjectId>();
        Set<ObjectId> indexObjects = this.listNonHEADIndexObjects();
        RefDatabase refdb = this.repo.getRefDatabase();
        for (Ref ref : refsBefore) {
            this.checkCancelled();
            nonHeads.addAll(this.listRefLogObjects(ref, 0L));
            if (ref.isSymbolic() || ref.getObjectId() == null) continue;
            if (GC.isHead(ref)) {
                allHeads.add(ref.getObjectId());
            } else if (GC.isTag(ref)) {
                allTags.add(ref.getObjectId());
            } else if (RefTreeNames.isRefTree(refdb, ref.getName())) {
                txnHeads.add(ref.getObjectId());
            } else {
                nonHeads.add(ref.getObjectId());
            }
            if (ref.getPeeledObjectId() == null) continue;
            tagTargets.add(ref.getPeeledObjectId());
        }
        LinkedList<ObjectIdSet> excluded = new LinkedList<ObjectIdSet>();
        for (PackFile f : this.repo.getObjectDatabase().getPacks()) {
            this.checkCancelled();
            if (!f.shouldBeKept()) continue;
            excluded.add(f.getIndex());
        }
        allTags.removeAll(allHeads);
        allHeadsAndTags.addAll(allHeads);
        allHeadsAndTags.addAll(allTags);
        tagTargets.addAll(allHeadsAndTags);
        nonHeads.addAll(indexObjects);
        ArrayList<PackFile> arrayList = new ArrayList<PackFile>(2);
        PackFile heads = null;
        if (!allHeadsAndTags.isEmpty() && (heads = this.writePack(allHeadsAndTags, PackWriter.NONE, allTags, tagTargets, excluded)) != null) {
            arrayList.add(heads);
            excluded.add(0, heads.getIndex());
        }
        if (!nonHeads.isEmpty() && (rest = this.writePack(nonHeads, allHeadsAndTags, PackWriter.NONE, tagTargets, excluded)) != null) {
            arrayList.add(rest);
        }
        if (!txnHeads.isEmpty() && (txn = this.writePack(txnHeads, PackWriter.NONE, PackWriter.NONE, null, excluded)) != null) {
            arrayList.add(txn);
        }
        try {
            this.deleteOldPacks(toBeDeleted, arrayList);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        this.prunePacked();
        this.deleteOrphans();
        this.lastPackedRefs = refsBefore;
        this.lastRepackTime = time;
        return arrayList;
    }

    private static boolean isHead(Ref ref) {
        return ref.getName().startsWith("refs/heads/");
    }

    private static boolean isTag(Ref ref) {
        return ref.getName().startsWith("refs/tags/");
    }

    private void deleteOrphans() {
        Path packDir = Paths.get(this.repo.getObjectsDirectory().getAbsolutePath(), "pack");
        List fileNames = null;
        try {
            Stream<Path> files = Files.list(packDir);
            Object object = null;
            try {
                fileNames = files.map(path -> path.getFileName().toString()).filter(name -> name.endsWith(PACK_EXT) || name.endsWith(BITMAP_EXT) || name.endsWith(INDEX_EXT)).sorted(Collections.reverseOrder()).collect(Collectors.toList());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (files != null) {
                    if (object != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        files.close();
                    }
                }
            }
        }
        catch (IOException files) {
            // empty catch block
        }
        if (fileNames == null) {
            return;
        }
        String base = null;
        for (String n : fileNames) {
            if (n.endsWith(PACK_EXT)) {
                base = n.substring(0, n.lastIndexOf(46));
                continue;
            }
            if (base != null && n.startsWith(base)) continue;
            try {
                Files.delete(new File(packDir.toFile(), n).toPath());
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private Set<ObjectId> listRefLogObjects(Ref ref, long minTime) throws IOException {
        ReflogReader reflogReader = this.repo.getReflogReader(ref.getName());
        if (reflogReader == null) {
            return Collections.emptySet();
        }
        List<ReflogEntry> rlEntries = reflogReader.getReverseEntries();
        if (rlEntries == null || rlEntries.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ObjectId> ret = new HashSet<ObjectId>();
        for (ReflogEntry e : rlEntries) {
            ObjectId oldId;
            if (e.getWho().getWhen().getTime() < minTime) break;
            ObjectId newId = e.getNewId();
            if (newId != null && !ObjectId.zeroId().equals(newId)) {
                ret.add(newId);
            }
            if ((oldId = e.getOldId()) == null || ObjectId.zeroId().equals(oldId)) continue;
            ret.add(oldId);
        }
        return ret;
    }

    private Collection<Ref> getAllRefs() throws IOException {
        RefDatabase refdb = this.repo.getRefDatabase();
        Collection<Ref> refs = refdb.getRefs("").values();
        List<Ref> addl = refdb.getAdditionalRefs();
        if (!addl.isEmpty()) {
            ArrayList<Ref> all = new ArrayList<Ref>(refs.size() + addl.size());
            all.addAll(refs);
            for (Ref r : addl) {
                this.checkCancelled();
                if (!r.getName().startsWith("refs/")) continue;
                all.add(r);
            }
            return all;
        }
        return refs;
    }

    private Set<ObjectId> listNonHEADIndexObjects() throws CorruptObjectException, IOException {
        if (this.repo.isBare()) {
            return Collections.emptySet();
        }
        try (TreeWalk treeWalk = new TreeWalk(this.repo);){
            Serializable serializable;
            treeWalk.addTree(new DirCacheIterator(this.repo.readDirCache()));
            ObjectId headID = this.repo.resolve("HEAD");
            if (headID != null) {
                RevWalk revWalk = new RevWalk(this.repo);
                serializable = null;
                try {
                    treeWalk.addTree(revWalk.parseTree(headID));
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    if (revWalk != null) {
                        if (serializable != null) {
                            try {
                                revWalk.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)serializable).addSuppressed(throwable);
                            }
                        } else {
                            revWalk.close();
                        }
                    }
                }
            }
            treeWalk.setFilter(TreeFilter.ANY_DIFF);
            treeWalk.setRecursive(true);
            HashSet<ObjectId> ret = new HashSet<ObjectId>();
            block22: while (treeWalk.next()) {
                this.checkCancelled();
                ObjectId objectId = treeWalk.getObjectId(0);
                switch (treeWalk.getRawMode(0) & 0xF000) {
                    case 0: 
                    case 57344: {
                        continue block22;
                    }
                    case 16384: 
                    case 32768: 
                    case 40960: {
                        ret.add(objectId);
                        continue block22;
                    }
                }
                throw new IOException(MessageFormat.format(JGitText.get().corruptObjectInvalidMode3, String.format("%o", treeWalk.getRawMode(0)), objectId == null ? "null" : objectId.name(), treeWalk.getPathString(), this.repo.getIndexFile()));
            }
            serializable = ret;
            return serializable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private PackFile writePack(@NonNull Set<? extends ObjectId> want, @NonNull Set<? extends ObjectId> have, @NonNull Set<ObjectId> tags, Set<ObjectId> tagTargets, List<ObjectIdSet> excludeObjects) throws IOException {
        this.checkCancelled();
        File tmpPack = null;
        TreeMap<PackExt, File> tmpExts = new TreeMap<PackExt, File>(new Comparator<PackExt>(){

            @Override
            public int compare(PackExt o1, PackExt o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == PackExt.INDEX) {
                    return 1;
                }
                if (o2 == PackExt.INDEX) {
                    return -1;
                }
                return Integer.signum(o1.hashCode() - o2.hashCode());
            }
        });
        try {
            PackFile packFile;
            try (PackWriter pw = new PackWriter(this.pconfig == null ? new PackConfig(this.repo) : this.pconfig, this.repo.newObjectReader());){
                File realPack;
                pw.setDeltaBaseAsOffset(true);
                pw.setReuseDeltaCommits(false);
                if (tagTargets != null) {
                    pw.setTagTargets(tagTargets);
                }
                if (excludeObjects != null) {
                    for (Object idx : excludeObjects) {
                        pw.excludeObjects((ObjectIdSet)idx);
                    }
                }
                pw.preparePack(this.pm, want, have, PackWriter.NONE, tags);
                if (pw.getObjectCount() == 0L) {
                    Iterator<ObjectIdSet> iterator = null;
                    return iterator;
                }
                this.checkCancelled();
                String id = pw.computeName().getName();
                File packdir = new File(this.repo.getObjectsDirectory(), "pack");
                tmpPack = File.createTempFile("gc_", ".pack_tmp", packdir);
                String tmpBase = tmpPack.getName().substring(0, tmpPack.getName().lastIndexOf(46));
                File tmpIdx = new File(packdir, tmpBase + ".idx_tmp");
                tmpExts.put(PackExt.INDEX, tmpIdx);
                if (!tmpIdx.createNewFile()) {
                    throw new IOException(MessageFormat.format(JGitText.get().cannotCreateIndexfile, tmpIdx.getPath()));
                }
                FileOutputStream fos = new FileOutputStream(tmpPack);
                FileChannel channel = fos.getChannel();
                OutputStream channelStream = Channels.newOutputStream(channel);
                try {
                    pw.writePack(this.pm, this.pm, channelStream);
                }
                finally {
                    channel.force(true);
                    channelStream.close();
                    fos.close();
                }
                fos = new FileOutputStream(tmpIdx);
                FileChannel idxChannel = fos.getChannel();
                OutputStream idxStream = Channels.newOutputStream(idxChannel);
                try {
                    pw.writeIndex(idxStream);
                }
                finally {
                    idxChannel.force(true);
                    idxStream.close();
                    fos.close();
                }
                if (pw.prepareBitmapIndex(this.pm)) {
                    File tmpBitmapIdx = new File(packdir, tmpBase + ".bitmap_tmp");
                    tmpExts.put(PackExt.BITMAP_INDEX, tmpBitmapIdx);
                    if (!tmpBitmapIdx.createNewFile()) {
                        throw new IOException(MessageFormat.format(JGitText.get().cannotCreateIndexfile, tmpBitmapIdx.getPath()));
                    }
                    fos = new FileOutputStream(tmpBitmapIdx);
                    idxChannel = fos.getChannel();
                    idxStream = Channels.newOutputStream(idxChannel);
                    try {
                        pw.writeBitmapIndex(idxStream);
                    }
                    finally {
                        idxChannel.force(true);
                        idxStream.close();
                        fos.close();
                    }
                }
                if ((realPack = this.nameFor(id, ".pack")).exists()) {
                    for (PackFile p : this.repo.getObjectDatabase().getPacks()) {
                        if (!realPack.getPath().equals(p.getPackFile().getPath())) continue;
                        p.close();
                        break;
                    }
                }
                tmpPack.setReadOnly();
                FileUtils.rename(tmpPack, realPack, StandardCopyOption.ATOMIC_MOVE);
                for (Map.Entry tmpEntry : tmpExts.entrySet()) {
                    File tmpExt = (File)tmpEntry.getValue();
                    tmpExt.setReadOnly();
                    File realExt = this.nameFor(id, "." + ((PackExt)tmpEntry.getKey()).getExtension());
                    try {
                        FileUtils.rename(tmpExt, realExt, StandardCopyOption.ATOMIC_MOVE);
                    }
                    catch (IOException e) {
                        File newExt = new File(realExt.getParentFile(), realExt.getName() + ".new");
                        try {
                            FileUtils.rename(tmpExt, newExt, StandardCopyOption.ATOMIC_MOVE);
                        }
                        catch (IOException e2) {
                            newExt = tmpExt;
                            e = e2;
                        }
                        throw new IOException(MessageFormat.format(JGitText.get().panicCantRenameIndexFile, newExt, realExt), e);
                    }
                }
                packFile = this.repo.getObjectDatabase().openPack(realPack);
            }
            return packFile;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (tmpPack != null && tmpPack.exists()) {
                tmpPack.delete();
            }
            for (File tmpExt : tmpExts.values()) {
                if (!tmpExt.exists()) continue;
                tmpExt.delete();
            }
        }
    }

    private File nameFor(String name, String ext) {
        File packdir = new File(this.repo.getObjectsDirectory(), "pack");
        return new File(packdir, "pack-" + name + ext);
    }

    private void checkCancelled() throws CancelledException {
        if (this.pm.isCancelled()) {
            throw new CancelledException(JGitText.get().operationCanceled);
        }
    }

    public RepoStatistics getStatistics() throws IOException {
        RepoStatistics ret = new RepoStatistics();
        Collection<PackFile> packs = this.repo.getObjectDatabase().getPacks();
        for (PackFile f : packs) {
            ret.numberOfPackedObjects += f.getIndex().getObjectCount();
            ++ret.numberOfPackFiles;
            ret.sizeOfPackedObjects += f.getPackFile().length();
            if (f.getBitmapIndex() == null) continue;
            ret.numberOfBitmaps += (long)f.getBitmapIndex().getBitmapCount();
        }
        File objDir = this.repo.getObjectsDirectory();
        String[] fanout = objDir.list();
        if (fanout != null && fanout.length > 0) {
            for (String d : fanout) {
                File[] entries;
                if (d.length() != 2 || (entries = new File(objDir, d).listFiles()) == null) continue;
                for (File f : entries) {
                    if (f.getName().length() != 38) continue;
                    ++ret.numberOfLooseObjects;
                    ret.sizeOfLooseObjects += f.length();
                }
            }
        }
        RefDatabase refDb = this.repo.getRefDatabase();
        for (Ref r : refDb.getRefs("").values()) {
            Ref.Storage storage = r.getStorage();
            if (storage == Ref.Storage.LOOSE || storage == Ref.Storage.LOOSE_PACKED) {
                ++ret.numberOfLooseRefs;
            }
            if (storage != Ref.Storage.PACKED && storage != Ref.Storage.LOOSE_PACKED) continue;
            ++ret.numberOfPackedRefs;
        }
        return ret;
    }

    public GC setProgressMonitor(ProgressMonitor pm) {
        this.pm = pm == null ? NullProgressMonitor.INSTANCE : pm;
        return this;
    }

    public void setExpireAgeMillis(long expireAgeMillis) {
        this.expireAgeMillis = expireAgeMillis;
        this.expire = null;
    }

    public void setPackExpireAgeMillis(long packExpireAgeMillis) {
        this.packExpireAgeMillis = packExpireAgeMillis;
        this.expire = null;
    }

    public void setPackConfig(PackConfig pconfig) {
        this.pconfig = pconfig;
    }

    public void setExpire(Date expire) {
        this.expire = expire;
        this.expireAgeMillis = -1L;
    }

    public void setPackExpire(Date packExpire) {
        this.packExpire = packExpire;
        this.packExpireAgeMillis = -1L;
    }

    public void setAuto(boolean auto) {
        this.automatic = auto;
    }

    void setBackground(boolean background) {
        this.background = background;
    }

    private boolean needGc() {
        if (this.tooManyPacks()) {
            this.addRepackAllOption();
        } else if (!this.tooManyLooseObjects()) {
            return false;
        }
        return true;
    }

    private void addRepackAllOption() {
    }

    boolean tooManyPacks() {
        int autopacklimit = this.repo.getConfig().getInt("gc", "autopacklimit", 50);
        if (autopacklimit <= 0) {
            return false;
        }
        return this.repo.getObjectDatabase().getPacks().size() > autopacklimit + 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean tooManyLooseObjects() {
        int auto = this.getLooseObjectLimit();
        if (auto <= 0) {
            return false;
        }
        int n = 0;
        int threshold = (auto + 255) / 256;
        Path dir = this.repo.getObjectsDirectory().toPath().resolve("17");
        if (!Files.exists(dir, new LinkOption[0])) {
            return false;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path file) throws IOException {
                Path fileName = file.getFileName();
                return Files.isRegularFile(file, new LinkOption[0]) && fileName != null && PATTERN_LOOSE_OBJECT.matcher(fileName.toString()).matches();
            }
        });){
            Iterator<Path> iter = stream.iterator();
            while (iter.hasNext()) {
                if (++n > threshold) {
                    boolean bl = true;
                    return bl;
                }
                iter.next();
            }
            return false;
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private int getLooseObjectLimit() {
        return this.repo.getConfig().getInt("gc", "auto", 6700);
    }

    public static class RepoStatistics {
        public long numberOfPackedObjects;
        public long numberOfPackFiles;
        public long numberOfLooseObjects;
        public long sizeOfLooseObjects;
        public long sizeOfPackedObjects;
        public long numberOfLooseRefs;
        public long numberOfPackedRefs;
        public long numberOfBitmaps;

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("numberOfPackedObjects=").append(this.numberOfPackedObjects);
            b.append(", numberOfPackFiles=").append(this.numberOfPackFiles);
            b.append(", numberOfLooseObjects=").append(this.numberOfLooseObjects);
            b.append(", numberOfLooseRefs=").append(this.numberOfLooseRefs);
            b.append(", numberOfPackedRefs=").append(this.numberOfPackedRefs);
            b.append(", sizeOfLooseObjects=").append(this.sizeOfLooseObjects);
            b.append(", sizeOfPackedObjects=").append(this.sizeOfPackedObjects);
            b.append(", numberOfBitmaps=").append(this.numberOfBitmaps);
            return b.toString();
        }
    }
}

