/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class RemoveAllDisjointAxioms
extends AbstractCompositeOntologyChange {
    private static final long serialVersionUID = 40000L;

    public RemoveAllDisjointAxioms(@Nonnull OWLDataFactory dataFactory, @Nonnull Set<OWLOntology> ontologies) {
        super(dataFactory);
        this.generateChanges(OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null"));
    }

    private void generateChanges(@Nonnull Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            assert (ont != null);
            for (OWLClassAxiom oWLClassAxiom : ont.getAxioms(AxiomType.DISJOINT_CLASSES)) {
                assert (oWLClassAxiom != null);
                this.addChange(new RemoveAxiom(ont, oWLClassAxiom));
            }
        }
    }
}

