/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.util.OWLAxiomVisitorExAdapter;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorExAdapter;

public class HornAxiomVisitorEx
extends OWLAxiomVisitorExAdapter<Boolean> {
    @Nonnull
    private final PositiveAppearanceVisitorEx positive = new PositiveAppearanceVisitorEx();
    @Nonnull
    private final NegativeAppearanceVisitorEx negative = new NegativeAppearanceVisitorEx();

    @Nonnull
    static Boolean b(boolean b) {
        return b;
    }

    protected boolean checkNegative(OWLClassExpression c) {
        return c.accept(this.negative);
    }

    protected boolean checkPositive(OWLClassExpression c) {
        return c.accept(this.positive);
    }

    public HornAxiomVisitorEx() {
        super(HornAxiomVisitorEx.b(false));
    }

    @Override
    public Boolean visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        return HornAxiomVisitorEx.b(true);
    }

    @Override
    public Boolean visit(OWLAnnotationPropertyDomainAxiom axiom) {
        return HornAxiomVisitorEx.b(true);
    }

    @Override
    public Boolean visit(OWLAnnotationPropertyRangeAxiom axiom) {
        return HornAxiomVisitorEx.b(true);
    }

    @Override
    public Boolean visit(@Nonnull OWLSubClassOfAxiom axiom) {
        return HornAxiomVisitorEx.b(this.checkNegative(axiom.getSubClass()) && this.checkNegative(axiom.getSuperClass()));
    }

    @Override
    public Boolean visit(OWLDisjointClassesAxiom axiom) {
        for (OWLClassExpression c : axiom.getClassExpressions()) {
            if (this.checkNegative(c)) continue;
            return HornAxiomVisitorEx.b(false);
        }
        return HornAxiomVisitorEx.b(true);
    }

    @Override
    public Boolean visit(OWLObjectPropertyDomainAxiom axiom) {
        return HornAxiomVisitorEx.b(this.checkPositive(axiom.getDomain()));
    }

    @Override
    public Boolean visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        return HornAxiomVisitorEx.b(true);
    }

    @Override
    public Boolean visit(OWLObjectPropertyRangeAxiom axiom) {
        return HornAxiomVisitorEx.b(this.checkPositive((OWLClassExpression)axiom.getRange()));
    }

    @Override
    public Boolean visit(OWLFunctionalObjectPropertyAxiom axiom) {
        return HornAxiomVisitorEx.b(true);
    }

    @Override
    public Boolean visit(OWLSubObjectPropertyOfAxiom axiom) {
        return HornAxiomVisitorEx.b(true);
    }

    @Override
    public Boolean visit(OWLDisjointUnionAxiom axiom) {
        OWLClass c1 = axiom.getOWLClass();
        if (!this.checkPositive(c1) || !this.checkNegative(c1)) {
            return HornAxiomVisitorEx.b(false);
        }
        for (OWLClassExpression c : axiom.getClassExpressions()) {
            if (this.checkPositive(c) && this.checkNegative(c)) continue;
            return HornAxiomVisitorEx.b(false);
        }
        return HornAxiomVisitorEx.b(true);
    }

    @Override
    public Boolean visit(OWLDeclarationAxiom axiom) {
        return HornAxiomVisitorEx.b(true);
    }

    @Override
    public Boolean visit(OWLAnnotationAssertionAxiom axiom) {
        return HornAxiomVisitorEx.b(true);
    }

    @Override
    public Boolean visit(OWLSymmetricObjectPropertyAxiom axiom) {
        return HornAxiomVisitorEx.b(true);
    }

    @Override
    public Boolean visit(OWLEquivalentClassesAxiom axiom) {
        for (OWLClassExpression c : axiom.getClassExpressions()) {
            if (this.checkPositive(c) && this.checkNegative(c)) continue;
            return HornAxiomVisitorEx.b(false);
        }
        return HornAxiomVisitorEx.b(true);
    }

    @Override
    public Boolean visit(OWLTransitiveObjectPropertyAxiom axiom) {
        return HornAxiomVisitorEx.b(true);
    }

    @Override
    public Boolean visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        return HornAxiomVisitorEx.b(true);
    }

    @Override
    public Boolean visit(OWLInverseObjectPropertiesAxiom axiom) {
        return HornAxiomVisitorEx.b(true);
    }

    private class NegativeAppearanceVisitorEx
    extends OWLClassExpressionVisitorExAdapter<Boolean> {
        NegativeAppearanceVisitorEx() {
            super(HornAxiomVisitorEx.b(false));
        }

        @Override
        public Boolean visit(OWLClass ce) {
            return HornAxiomVisitorEx.b(true);
        }

        @Override
        public Boolean visit(OWLObjectIntersectionOf ce) {
            for (OWLClassExpression c : ce.getOperands()) {
                if (!c.accept(this).equals(Boolean.FALSE)) continue;
                return HornAxiomVisitorEx.b(false);
            }
            return HornAxiomVisitorEx.b(true);
        }

        @Override
        public Boolean visit(OWLObjectUnionOf ce) {
            for (OWLClassExpression c : ce.getOperands()) {
                if (!c.accept(this).equals(Boolean.FALSE)) continue;
                return HornAxiomVisitorEx.b(false);
            }
            return HornAxiomVisitorEx.b(true);
        }

        @Override
        public Boolean visit(OWLObjectSomeValuesFrom ce) {
            return ((OWLClassExpression)ce.getFiller()).accept(this);
        }

        @Override
        public Boolean visit(OWLObjectMinCardinality ce) {
            return HornAxiomVisitorEx.b(ce.getCardinality() <= 1 && ((OWLClassExpression)ce.getFiller()).accept(this) != false);
        }
    }

    private class PositiveAppearanceVisitorEx
    extends OWLClassExpressionVisitorExAdapter<Boolean> {
        PositiveAppearanceVisitorEx() {
            super(HornAxiomVisitorEx.b(false));
        }

        @Override
        public Boolean visit(OWLClass ce) {
            return HornAxiomVisitorEx.b(true);
        }

        @Override
        public Boolean visit(OWLObjectIntersectionOf ce) {
            for (OWLClassExpression c : ce.getOperands()) {
                if (!c.accept(this).equals(Boolean.FALSE)) continue;
                return HornAxiomVisitorEx.b(false);
            }
            return HornAxiomVisitorEx.b(true);
        }

        @Override
        public Boolean visit(OWLObjectComplementOf ce) {
            return HornAxiomVisitorEx.b(HornAxiomVisitorEx.this.checkNegative(ce.getOperand()));
        }

        @Override
        public Boolean visit(OWLObjectSomeValuesFrom ce) {
            return ((OWLClassExpression)ce.getFiller()).accept(this);
        }

        @Override
        public Boolean visit(OWLObjectAllValuesFrom ce) {
            return ((OWLClassExpression)ce.getFiller()).accept(this);
        }

        @Override
        public Boolean visit(OWLObjectMinCardinality ce) {
            return ((OWLClassExpression)ce.getFiller()).accept(this);
        }

        @Override
        public Boolean visit(OWLObjectExactCardinality ce) {
            return HornAxiomVisitorEx.b(ce.getCardinality() <= 1 && ((OWLClassExpression)ce.getFiller()).accept(this) != false && HornAxiomVisitorEx.this.checkNegative((OWLClassExpression)ce.getFiller()));
        }

        @Override
        public Boolean visit(OWLObjectMaxCardinality ce) {
            return HornAxiomVisitorEx.b(ce.getCardinality() <= 1 && HornAxiomVisitorEx.this.checkNegative((OWLClassExpression)ce.getFiller()));
        }
    }
}

