/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.conf.valueset;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.conf.IRIExpander;
import org.protege.editor.owl.model.conf.valueset.LabelledValue;
import org.protege.editor.owl.model.conf.valueset.ValueSet;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.ui.renderer.RenderingEscapeUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLObject;

@JsonTypeName(value="SubClasses")
public class SubClassesValueSet
implements ValueSet {
    private final String classIri;

    public SubClassesValueSet(@Nonnull @JsonProperty(value="classIri") String classIri) {
        this.classIri = (String)Preconditions.checkNotNull((Object)classIri);
    }

    @Nonnull
    public Optional<IRI> getClassIri() {
        return IRIExpander.expand(this.classIri);
    }

    @Override
    @Nonnull
    public List<LabelledValue> getLabelledValues(@Nonnull OWLModelManager modelManager) {
        return this.getClassIri().map(iri -> {
            OWLObjectHierarchyProvider<OWLClass> hierarchyProvider = modelManager.getOWLHierarchyManager().getOWLClassHierarchyProvider();
            OWLClass cls = modelManager.getOWLDataFactory().getOWLClass(iri);
            return hierarchyProvider.getChildren(cls).stream().filter(c -> !modelManager.isDeprecated((OWLObject)c)).map(child -> new LabelledValue(cls, RenderingEscapeUtils.unescape(modelManager.getRendering((OWLObject)child)))).collect(Collectors.toList());
        }).orElse(Collections.emptyList());
    }
}

