/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.entity;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.ui.menu.MenuBuilder;
import org.protege.editor.core.ui.menu.PopupMenuId;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.entity.EntityBannerView;
import org.protege.editor.owl.ui.view.EntityBannerFormatter;
import org.protege.editor.owl.ui.view.EntityBannerFormatterImpl;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityBannerPresenter {
    private static final Logger logger = LoggerFactory.getLogger(EntityBannerPresenter.class);
    private static final String ENTITY_BANNER_MENU_ID = "[EntityBanner]";
    @Nonnull
    private final EntityBannerView view;
    @Nonnull
    private final OWLEditorKit editorKit;
    @Nonnull
    private final EntityBannerFormatter formatter = new EntityBannerFormatterImpl();

    public EntityBannerPresenter(@Nonnull EntityBannerView view, @Nonnull OWLEditorKit editorKit) {
        this.view = (EntityBannerView)Preconditions.checkNotNull((Object)view);
        this.editorKit = (OWLEditorKit)((Object)Preconditions.checkNotNull((Object)((Object)editorKit)));
    }

    @Nonnull
    public JComponent getView() {
        return this.view.asJComponent();
    }

    public void start() {
        this.editorKit.getOWLWorkspace().getOWLSelectionModel().addListener(this::handleSelectionChanged);
        this.handleSelectionChanged();
        MenuBuilder menuBuilder = new MenuBuilder((EditorKit)this.editorKit);
        JPopupMenu popupMenu = menuBuilder.buildPopupMenu(new PopupMenuId(ENTITY_BANNER_MENU_ID));
        this.view.setPopupMenu(popupMenu);
    }

    private void handleSelectionChanged() {
        this.view.clear();
        OWLEntity entity = this.editorKit.getOWLWorkspace().getOWLSelectionModel().getSelectedEntity();
        if (entity == null) {
            this.view.asJComponent().setVisible(false);
            this.view.setMenuEnabled(false);
        } else {
            this.view.asJComponent().setVisible(true);
            String formattedBanner = this.formatter.formatBanner(entity, this.editorKit);
            this.view.setText(formattedBanner);
            Icon entityIcon = this.editorKit.getOWLWorkspace().getOWLIconProvider().getIcon((OWLObject)entity);
            this.view.setIcon(entityIcon);
            this.view.setMenuEnabled(true);
        }
    }

    public void dispose() {
        this.editorKit.getOWLWorkspace().getOWLSelectionModel().removeListener(this::handleSelectionChanged);
    }
}

