/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.deprecation;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.util.OboUtilities;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class DeprecationWizardEntityRenderer {
    @Nonnull
    private final OWLModelManager modelManager;

    public DeprecationWizardEntityRenderer(@Nonnull OWLModelManager modelManager) {
        this.modelManager = (OWLModelManager)Preconditions.checkNotNull((Object)modelManager);
    }

    public static DeprecationWizardEntityRenderer renderer(@Nonnull OWLModelManager modelManager) {
        return new DeprecationWizardEntityRenderer(modelManager);
    }

    public String getRendering(@Nonnull OWLEntity entity) {
        return this.modelManager.getRendering((OWLObject)entity) + this.getOboIdBracketedRendering(entity);
    }

    public String getHtmlRendering(@Nonnull OWLEntity entity) {
        return "<span style=\"font-weight: bold;\">" + this.modelManager.getRendering((OWLObject)entity) + "</span>" + this.getOboIdBracketedRendering(entity);
    }

    private String getOboIdBracketedRendering(@Nonnull OWLEntity entity) {
        return OboUtilities.getOboIdFromIri(entity.getIRI()).map(id -> " (" + id + ")").orElse("");
    }
}

