/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.dataproperty;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.OWLDataPropertySetEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.dataproperty.OWLDisjointDataPropertiesFrameSectionRow;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class OWLDisjointDataPropertiesFrameSection
extends AbstractOWLFrameSection<OWLDataProperty, OWLDisjointDataPropertiesAxiom, Set<OWLDataProperty>> {
    public static final String LABEL = "Disjoint With";

    public OWLDisjointDataPropertiesFrameSection(OWLEditorKit editorKit, OWLFrame<? extends OWLDataProperty> frame) {
        super(editorKit, LABEL, "Disjoint properties", frame);
    }

    @Override
    protected OWLDisjointDataPropertiesAxiom createAxiom(Set<OWLDataProperty> object) {
        HashSet<OWLDataProperty> disjoints = new HashSet<OWLDataProperty>(object);
        disjoints.add((OWLDataProperty)this.getRootObject());
        return this.getOWLDataFactory().getOWLDisjointDataPropertiesAxiom(disjoints);
    }

    @Override
    protected void clear() {
    }

    @Override
    protected void refill(OWLOntology ontology) {
        for (OWLDisjointDataPropertiesAxiom ax : ontology.getDisjointDataPropertiesAxioms((OWLDataProperty)this.getRootObject())) {
            this.addRow(new OWLDisjointDataPropertiesFrameSectionRow(this.getOWLEditorKit(), this, ontology, (OWLDataProperty)this.getRootObject(), ax));
        }
    }

    @Override
    public OWLObjectEditor<Set<OWLDataProperty>> getObjectEditor() {
        return new OWLDataPropertySetEditor(this.getOWLEditorKit());
    }

    @Override
    public boolean checkEditorResults(OWLObjectEditor<Set<OWLDataProperty>> editor) {
        Set<OWLDataProperty> equivalents = editor.getEditedObject();
        return !equivalents.contains(this.getRootObject());
    }

    @Override
    protected boolean isResettingChange(OWLOntologyChange change) {
        return change.isAxiomChange() && change.getAxiom() instanceof OWLDisjointDataPropertiesAxiom && ((OWLDisjointDataPropertiesAxiom)change.getAxiom()).getProperties().contains(this.getRootObject());
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLDataProperty, OWLDisjointDataPropertiesAxiom, Set<OWLDataProperty>>> getRowComparator() {
        return null;
    }
}

