/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.rfb.LogWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ExtProcess
implements Runnable {
    private String cmd = null;
    private LogWriter vlog = null;
    private boolean shutdown = false;
    private Process pid = null;

    public ExtProcess(String string, LogWriter logWriter, boolean bl) {
        this.cmd = string;
        this.vlog = logWriter;
        this.shutdown = bl;
    }

    public ExtProcess(String string, LogWriter logWriter) {
        this(string, logWriter, false);
    }

    public ExtProcess(String string) {
        this(string, null, false);
    }

    @Override
    public void run() {
        try {
            Runtime runtime = Runtime.getRuntime();
            this.pid = runtime.exec(this.cmd);
            if (this.shutdown) {
                runtime.addShutdownHook(new MyShutdownHook(this.pid));
            }
            if (this.vlog != null) {
                new MyProcessLogger(this.pid, this.vlog).start();
            }
            this.pid.waitFor();
        }
        catch (InterruptedException interruptedException) {
            this.vlog.info(interruptedException.getMessage(), new Object[0]);
        }
        catch (IOException iOException) {
            this.vlog.info(iOException.getMessage(), new Object[0]);
        }
    }

    private static class MyShutdownHook
    extends Thread {
        private Process proc = null;

        public MyShutdownHook(Process process) {
            this.proc = process;
        }

        @Override
        public void run() {
            try {
                this.proc.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.proc.destroy();
            }
        }
    }

    private static class MyProcessLogger
    extends Thread {
        private final BufferedReader err;
        private final LogWriter vlog;

        public MyProcessLogger(Process process, LogWriter logWriter) {
            InputStreamReader inputStreamReader = new InputStreamReader(process.getErrorStream());
            this.err = new BufferedReader(inputStreamReader);
            this.vlog = logWriter;
        }

        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        String string;
                        if ((string = this.err.readLine()) == null) {
                            continue;
                        }
                        this.vlog.info(string, new Object[0]);
                    }
                }
                catch (IOException iOException) {
                    this.vlog.info(iOException.getMessage(), new Object[0]);
                    try {
                        if (this.err != null) {
                            this.err.close();
                        }
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.err != null) {
                        this.err.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

