ntkrnlmp_types = {
  '_KRESOURCEMANAGER_COMPLETION_BINDING' : [ 0x14, {
    'NotificationListHead' : [ 0x0, ['_LIST_ENTRY']],
    'Port' : [ 0x8, ['pointer', ['void']]],
    'Key' : [ 0xc, ['unsigned long']],
    'BindingProcess' : [ 0x10, ['pointer', ['_EPROCESS']]],
} ],
  '_VF_TRACKER' : [ 0x10, {
    'TrackerFlags' : [ 0x0, ['unsigned long']],
    'TrackerSize' : [ 0x4, ['unsigned long']],
    'TrackerIndex' : [ 0x8, ['unsigned long']],
    'TraceDepth' : [ 0xc, ['unsigned long']],
} ],
  '_EX_RUNDOWN_REF' : [ 0x4, {
    'Count' : [ 0x0, ['unsigned long']],
    'Ptr' : [ 0x0, ['pointer', ['void']]],
} ],
  '_CALL_PERFORMANCE_DATA' : [ 0x204, {
    'SpinLock' : [ 0x0, ['unsigned long']],
    'HashTable' : [ 0x4, ['array', 64, ['_LIST_ENTRY']]],
} ],
  '_ARBITER_ALTERNATIVE' : [ 0x38, {
    'Minimum' : [ 0x0, ['unsigned long long']],
    'Maximum' : [ 0x8, ['unsigned long long']],
    'Length' : [ 0x10, ['unsigned long long']],
    'Alignment' : [ 0x18, ['unsigned long long']],
    'Priority' : [ 0x20, ['long']],
    'Flags' : [ 0x24, ['unsigned long']],
    'Descriptor' : [ 0x28, ['pointer', ['_IO_RESOURCE_DESCRIPTOR']]],
    'Reserved' : [ 0x2c, ['array', 3, ['unsigned long']]],
} ],
  '_WHEA_PERSISTENCE_INFO' : [ 0x8, {
    'Signature' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned long long')]],
    'Length' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 40, native_type='unsigned long long')]],
    'Identifier' : [ 0x0, ['BitField', dict(start_bit = 40, end_bit = 56, native_type='unsigned long long')]],
    'Attributes' : [ 0x0, ['BitField', dict(start_bit = 56, end_bit = 58, native_type='unsigned long long')]],
    'DoNotLog' : [ 0x0, ['BitField', dict(start_bit = 58, end_bit = 59, native_type='unsigned long long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 59, end_bit = 64, native_type='unsigned long long')]],
    'AsULONGLONG' : [ 0x0, ['unsigned long long']],
} ],
  '_MI_SECTION_IMAGE_INFORMATION' : [ 0x38, {
    'ExportedImageInformation' : [ 0x0, ['_SECTION_IMAGE_INFORMATION']],
    'InternalImageInformation' : [ 0x30, ['_MI_EXTRA_IMAGE_INFORMATION']],
} ],
  '_HEAP_USERDATA_HEADER' : [ 0x10, {
    'SFreeListEntry' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'SubSegment' : [ 0x0, ['pointer', ['_HEAP_SUBSEGMENT']]],
    'Reserved' : [ 0x4, ['pointer', ['void']]],
    'SizeIndex' : [ 0x8, ['unsigned long']],
    'Signature' : [ 0xc, ['unsigned long']],
} ],
  '_PPM_DIA_STATS' : [ 0xc, {
    'PerfLevel' : [ 0x0, ['unsigned long']],
    'IdleTime' : [ 0x4, ['unsigned long']],
    'TimeInterval' : [ 0x8, ['unsigned long']],
} ],
  '_STACK_TABLE' : [ 0x8040, {
    'NumStackTraces' : [ 0x0, ['unsigned short']],
    'TraceCapacity' : [ 0x2, ['unsigned short']],
    'StackTrace' : [ 0x4, ['array', 16, ['pointer', ['_OBJECT_REF_TRACE']]]],
    'StackTableHash' : [ 0x44, ['array', 16381, ['unsigned short']]],
} ],
  '_CM_INDEX_HINT_BLOCK' : [ 0x8, {
    'Count' : [ 0x0, ['unsigned long']],
    'HashKey' : [ 0x4, ['array', 1, ['unsigned long']]],
} ],
  '_TOKEN_CONTROL' : [ 0x28, {
    'TokenId' : [ 0x0, ['_LUID']],
    'AuthenticationId' : [ 0x8, ['_LUID']],
    'ModifiedId' : [ 0x10, ['_LUID']],
    'TokenSource' : [ 0x18, ['_TOKEN_SOURCE']],
} ],
  '_DEFERRED_WRITE' : [ 0x28, {
    'NodeTypeCode' : [ 0x0, ['short']],
    'NodeByteSize' : [ 0x2, ['short']],
    'FileObject' : [ 0x4, ['pointer', ['_FILE_OBJECT']]],
    'BytesToWrite' : [ 0x8, ['unsigned long']],
    'DeferredWriteLinks' : [ 0xc, ['_LIST_ENTRY']],
    'Event' : [ 0x14, ['pointer', ['_KEVENT']]],
    'PostRoutine' : [ 0x18, ['pointer', ['void']]],
    'Context1' : [ 0x1c, ['pointer', ['void']]],
    'Context2' : [ 0x20, ['pointer', ['void']]],
    'LimitModifiedPages' : [ 0x24, ['unsigned char']],
} ],
  '_DBGKD_ANY_CONTROL_SET' : [ 0x1c, {
    'X86ControlSet' : [ 0x0, ['_X86_DBGKD_CONTROL_SET']],
    'AlphaControlSet' : [ 0x0, ['unsigned long']],
    'IA64ControlSet' : [ 0x0, ['_IA64_DBGKD_CONTROL_SET']],
    'Amd64ControlSet' : [ 0x0, ['_AMD64_DBGKD_CONTROL_SET']],
    'ArmControlSet' : [ 0x0, ['_ARM_DBGKD_CONTROL_SET']],
} ],
  '_ARBITER_ORDERING_LIST' : [ 0x8, {
    'Count' : [ 0x0, ['unsigned short']],
    'Maximum' : [ 0x2, ['unsigned short']],
    'Orderings' : [ 0x4, ['pointer', ['_ARBITER_ORDERING']]],
} ],
  '_SECTION_IMAGE_INFORMATION' : [ 0x30, {
    'TransferAddress' : [ 0x0, ['pointer', ['void']]],
    'ZeroBits' : [ 0x4, ['unsigned long']],
    'MaximumStackSize' : [ 0x8, ['unsigned long']],
    'CommittedStackSize' : [ 0xc, ['unsigned long']],
    'SubSystemType' : [ 0x10, ['unsigned long']],
    'SubSystemMinorVersion' : [ 0x14, ['unsigned short']],
    'SubSystemMajorVersion' : [ 0x16, ['unsigned short']],
    'SubSystemVersion' : [ 0x14, ['unsigned long']],
    'GpValue' : [ 0x18, ['unsigned long']],
    'ImageCharacteristics' : [ 0x1c, ['unsigned short']],
    'DllCharacteristics' : [ 0x1e, ['unsigned short']],
    'Machine' : [ 0x20, ['unsigned short']],
    'ImageContainsCode' : [ 0x22, ['unsigned char']],
    'ImageFlags' : [ 0x23, ['unsigned char']],
    'ComPlusNativeReady' : [ 0x23, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'ComPlusILOnly' : [ 0x23, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'ImageDynamicallyRelocated' : [ 0x23, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'ImageMappedFlat' : [ 0x23, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'Reserved' : [ 0x23, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned char')]],
    'LoaderFlags' : [ 0x24, ['unsigned long']],
    'ImageFileSize' : [ 0x28, ['unsigned long']],
    'CheckSum' : [ 0x2c, ['unsigned long']],
} ],
  '_ARM_DBGKD_CONTROL_SET' : [ 0xc, {
    'Continue' : [ 0x0, ['unsigned long']],
    'CurrentSymbolStart' : [ 0x4, ['unsigned long']],
    'CurrentSymbolEnd' : [ 0x8, ['unsigned long']],
} ],
  '_TOKEN_AUDIT_POLICY' : [ 0x1b, {
    'PerUserPolicy' : [ 0x0, ['array', 27, ['unsigned char']]],
} ],
  '__unnamed_203f' : [ 0x8, {
    'EndingOffset' : [ 0x0, ['pointer', ['_LARGE_INTEGER']]],
    'ResourceToRelease' : [ 0x4, ['pointer', ['pointer', ['_ERESOURCE']]]],
} ],
  '__unnamed_2041' : [ 0x4, {
    'ResourceToRelease' : [ 0x0, ['pointer', ['_ERESOURCE']]],
} ],
  '__unnamed_2045' : [ 0x8, {
    'SyncType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'SyncTypeOther', 1: 'SyncTypeCreateSection'})]],
    'PageProtection' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_2049' : [ 0x8, {
    'NotificationType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'NotifyTypeCreate', 1: 'NotifyTypeRetired'})]],
    'SafeToRecurse' : [ 0x4, ['unsigned char']],
} ],
  '__unnamed_204b' : [ 0x14, {
    'Argument1' : [ 0x0, ['pointer', ['void']]],
    'Argument2' : [ 0x4, ['pointer', ['void']]],
    'Argument3' : [ 0x8, ['pointer', ['void']]],
    'Argument4' : [ 0xc, ['pointer', ['void']]],
    'Argument5' : [ 0x10, ['pointer', ['void']]],
} ],
  '_FS_FILTER_PARAMETERS' : [ 0x14, {
    'AcquireForModifiedPageWriter' : [ 0x0, ['__unnamed_203f']],
    'ReleaseForModifiedPageWriter' : [ 0x0, ['__unnamed_2041']],
    'AcquireForSectionSynchronization' : [ 0x0, ['__unnamed_2045']],
    'NotifyStreamFileObject' : [ 0x0, ['__unnamed_2049']],
    'Others' : [ 0x0, ['__unnamed_204b']],
} ],
  '_PROFILE_PARAMETER_BLOCK' : [ 0x10, {
    'Status' : [ 0x0, ['unsigned short']],
    'Reserved' : [ 0x2, ['unsigned short']],
    'DockingState' : [ 0x4, ['unsigned short']],
    'Capabilities' : [ 0x6, ['unsigned short']],
    'DockID' : [ 0x8, ['unsigned long']],
    'SerialNumber' : [ 0xc, ['unsigned long']],
} ],
  '_COMPRESSED_DATA_INFO' : [ 0xc, {
    'CompressionFormatAndEngine' : [ 0x0, ['unsigned short']],
    'CompressionUnitShift' : [ 0x2, ['unsigned char']],
    'ChunkShift' : [ 0x3, ['unsigned char']],
    'ClusterShift' : [ 0x4, ['unsigned char']],
    'Reserved' : [ 0x5, ['unsigned char']],
    'NumberOfChunks' : [ 0x6, ['unsigned short']],
    'CompressedChunkSizes' : [ 0x8, ['array', 1, ['unsigned long']]],
} ],
  '_POP_HIBER_CONTEXT' : [ 0x100, {
    'WriteToFile' : [ 0x0, ['unsigned char']],
    'ReserveLoaderMemory' : [ 0x1, ['unsigned char']],
    'ReserveFreeMemory' : [ 0x2, ['unsigned char']],
    'VerifyOnWake' : [ 0x3, ['unsigned char']],
    'Reset' : [ 0x4, ['unsigned char']],
    'HiberFlags' : [ 0x5, ['unsigned char']],
    'WroteHiberFile' : [ 0x6, ['unsigned char']],
    'Lock' : [ 0x8, ['unsigned long']],
    'MapFrozen' : [ 0xc, ['unsigned char']],
    'MemoryMap' : [ 0x10, ['_RTL_BITMAP']],
    'DiscardedMemoryPages' : [ 0x18, ['_RTL_BITMAP']],
    'ClonedRanges' : [ 0x20, ['_LIST_ENTRY']],
    'ClonedRangeCount' : [ 0x28, ['unsigned long']],
    'NextCloneRange' : [ 0x2c, ['pointer', ['_LIST_ENTRY']]],
    'NextPreserve' : [ 0x30, ['unsigned long']],
    'LoaderMdl' : [ 0x34, ['pointer', ['_MDL']]],
    'AllocatedMdl' : [ 0x38, ['pointer', ['_MDL']]],
    'PagesOut' : [ 0x40, ['unsigned long long']],
    'IoPages' : [ 0x48, ['pointer', ['void']]],
    'IoPagesCount' : [ 0x4c, ['unsigned long']],
    'CurrentMcb' : [ 0x50, ['pointer', ['void']]],
    'DumpStack' : [ 0x54, ['pointer', ['_DUMP_STACK_CONTEXT']]],
    'WakeState' : [ 0x58, ['pointer', ['_KPROCESSOR_STATE']]],
    'HiberVa' : [ 0x5c, ['unsigned long']],
    'HiberPte' : [ 0x60, ['_LARGE_INTEGER']],
    'Status' : [ 0x68, ['long']],
    'MemoryImage' : [ 0x6c, ['pointer', ['PO_MEMORY_IMAGE']]],
    'TableHead' : [ 0x70, ['pointer', ['_PO_MEMORY_RANGE_TABLE']]],
    'CompressionWorkspace' : [ 0x74, ['pointer', ['unsigned char']]],
    'CompressedWriteBuffer' : [ 0x78, ['pointer', ['unsigned char']]],
    'PerformanceStats' : [ 0x7c, ['pointer', ['unsigned long']]],
    'CompressionBlock' : [ 0x80, ['pointer', ['void']]],
    'DmaIO' : [ 0x84, ['pointer', ['void']]],
    'TemporaryHeap' : [ 0x88, ['pointer', ['void']]],
    'PerfInfo' : [ 0x90, ['_PO_HIBER_PERF']],
    'BootLoaderLogMdl' : [ 0xf0, ['pointer', ['_MDL']]],
    'FirmwareRuntimeInformationMdl' : [ 0xf4, ['pointer', ['_MDL']]],
    'ResumeContext' : [ 0xf8, ['pointer', ['void']]],
    'ResumeContextPages' : [ 0xfc, ['unsigned long']],
} ],
  '_OBJECT_REF_TRACE' : [ 0x40, {
    'StackTrace' : [ 0x0, ['array', 16, ['pointer', ['void']]]],
} ],
  '_OBJECT_NAME_INFORMATION' : [ 0x8, {
    'Name' : [ 0x0, ['_UNICODE_STRING']],
} ],
  '_DUMP_STACK_CONTEXT' : [ 0xb0, {
    'Init' : [ 0x0, ['_DUMP_INITIALIZATION_CONTEXT']],
    'PartitionOffset' : [ 0x70, ['_LARGE_INTEGER']],
    'DumpPointers' : [ 0x78, ['pointer', ['void']]],
    'PointersLength' : [ 0x7c, ['unsigned long']],
    'ModulePrefix' : [ 0x80, ['pointer', ['unsigned short']]],
    'DriverList' : [ 0x84, ['_LIST_ENTRY']],
    'InitMsg' : [ 0x8c, ['_STRING']],
    'ProgMsg' : [ 0x94, ['_STRING']],
    'DoneMsg' : [ 0x9c, ['_STRING']],
    'FileObject' : [ 0xa4, ['pointer', ['void']]],
    'UsageType' : [ 0xa8, ['Enumeration', dict(target = 'long', choices = {0: 'DeviceUsageTypeUndefined', 1: 'DeviceUsageTypePaging', 2: 'DeviceUsageTypeHibernation', 3: 'DeviceUsageTypeDumpFile'})]],
} ],
  '_FILE_STANDARD_INFORMATION' : [ 0x18, {
    'AllocationSize' : [ 0x0, ['_LARGE_INTEGER']],
    'EndOfFile' : [ 0x8, ['_LARGE_INTEGER']],
    'NumberOfLinks' : [ 0x10, ['unsigned long']],
    'DeletePending' : [ 0x14, ['unsigned char']],
    'Directory' : [ 0x15, ['unsigned char']],
} ],
  '_POP_SHUTDOWN_BUG_CHECK' : [ 0x20, {
    'ThreadHandle' : [ 0x0, ['pointer', ['void']]],
    'ThreadId' : [ 0x4, ['pointer', ['void']]],
    'ProcessId' : [ 0x8, ['pointer', ['void']]],
    'Code' : [ 0xc, ['unsigned long']],
    'Parameter1' : [ 0x10, ['unsigned long']],
    'Parameter2' : [ 0x14, ['unsigned long']],
    'Parameter3' : [ 0x18, ['unsigned long']],
    'Parameter4' : [ 0x1c, ['unsigned long']],
} ],
  '_MI_EXTRA_IMAGE_INFORMATION' : [ 0x8, {
    'SizeOfHeaders' : [ 0x0, ['unsigned long']],
    'ImageMerge' : [ 0x4, ['pointer', ['void']]],
} ],
  '_RTL_HANDLE_TABLE_ENTRY' : [ 0x4, {
    'Flags' : [ 0x0, ['unsigned long']],
    'NextFree' : [ 0x0, ['pointer', ['_RTL_HANDLE_TABLE_ENTRY']]],
} ],
  '_SECURITY_DESCRIPTOR_RELATIVE' : [ 0x14, {
    'Revision' : [ 0x0, ['unsigned char']],
    'Sbz1' : [ 0x1, ['unsigned char']],
    'Control' : [ 0x2, ['unsigned short']],
    'Owner' : [ 0x4, ['unsigned long']],
    'Group' : [ 0x8, ['unsigned long']],
    'Sacl' : [ 0xc, ['unsigned long']],
    'Dacl' : [ 0x10, ['unsigned long']],
} ],
  '_WHEA_GENERIC_PROCESSOR_ERROR_VALIDBITS' : [ 0x8, {
    'ProcessorType' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'InstructionSet' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'ErrorType' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'Operation' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long long')]],
    'Flags' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long long')]],
    'Level' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long long')]],
    'CPUVersion' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long long')]],
    'CPUBrandString' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long long')]],
    'ProcessorId' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long long')]],
    'TargetAddress' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long long')]],
    'RequesterId' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'ResponderId' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long long')]],
    'InstructionPointer' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 64, native_type='unsigned long long')]],
    'ValidBits' : [ 0x0, ['unsigned long long']],
} ],
  '__unnamed_2072' : [ 0x10, {
    'TestAllocation' : [ 0x0, ['_ARBITER_TEST_ALLOCATION_PARAMETERS']],
    'RetestAllocation' : [ 0x0, ['_ARBITER_RETEST_ALLOCATION_PARAMETERS']],
    'BootAllocation' : [ 0x0, ['_ARBITER_BOOT_ALLOCATION_PARAMETERS']],
    'QueryAllocatedResources' : [ 0x0, ['_ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS']],
    'QueryConflict' : [ 0x0, ['_ARBITER_QUERY_CONFLICT_PARAMETERS']],
    'QueryArbitrate' : [ 0x0, ['_ARBITER_QUERY_ARBITRATE_PARAMETERS']],
    'AddReserved' : [ 0x0, ['_ARBITER_ADD_RESERVED_PARAMETERS']],
} ],
  '_ARBITER_PARAMETERS' : [ 0x10, {
    'Parameters' : [ 0x0, ['__unnamed_2072']],
} ],
  '__unnamed_2076' : [ 0x8, {
    'idxRecord' : [ 0x0, ['unsigned long']],
    'cidContainer' : [ 0x4, ['unsigned long']],
} ],
  '_CLS_LSN' : [ 0x8, {
    'offset' : [ 0x0, ['__unnamed_2076']],
    'ullOffset' : [ 0x0, ['unsigned long long']],
} ],
  'POWER_ACTION_POLICY' : [ 0xc, {
    'Action' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'PowerActionNone', 1: 'PowerActionReserved', 2: 'PowerActionSleep', 3: 'PowerActionHibernate', 4: 'PowerActionShutdown', 5: 'PowerActionShutdownReset', 6: 'PowerActionShutdownOff', 7: 'PowerActionWarmEject'})]],
    'Flags' : [ 0x4, ['unsigned long']],
    'EventCode' : [ 0x8, ['unsigned long']],
} ],
  'PO_MEMORY_IMAGE' : [ 0xf0, {
    'Signature' : [ 0x0, ['unsigned long']],
    'ImageType' : [ 0x4, ['unsigned long']],
    'CheckSum' : [ 0x8, ['unsigned long']],
    'LengthSelf' : [ 0xc, ['unsigned long']],
    'PageSelf' : [ 0x10, ['unsigned long']],
    'PageSize' : [ 0x14, ['unsigned long']],
    'SystemTime' : [ 0x18, ['_LARGE_INTEGER']],
    'InterruptTime' : [ 0x20, ['unsigned long long']],
    'FeatureFlags' : [ 0x28, ['unsigned long']],
    'HiberFlags' : [ 0x2c, ['unsigned char']],
    'spare' : [ 0x2d, ['array', 3, ['unsigned char']]],
    'NoHiberPtes' : [ 0x30, ['unsigned long']],
    'HiberVa' : [ 0x34, ['unsigned long']],
    'HiberPte' : [ 0x38, ['_LARGE_INTEGER']],
    'NoFreePages' : [ 0x40, ['unsigned long']],
    'FreeMapCheck' : [ 0x44, ['unsigned long']],
    'WakeCheck' : [ 0x48, ['unsigned long']],
    'TotalPages' : [ 0x4c, ['unsigned long']],
    'FirstTablePage' : [ 0x50, ['unsigned long']],
    'PerfInfo' : [ 0x58, ['_PO_HIBER_PERF']],
    'FirmwareRuntimeInformationPages' : [ 0xb8, ['unsigned long']],
    'FirmwareRuntimeInformation' : [ 0xbc, ['array', 1, ['unsigned long']]],
    'NoBootLoaderLogPages' : [ 0xc0, ['unsigned long']],
    'BootLoaderLogPages' : [ 0xc4, ['array', 8, ['unsigned long']]],
    'NotUsed' : [ 0xe4, ['unsigned long']],
    'ResumeContextCheck' : [ 0xe8, ['unsigned long']],
    'ResumeContextPages' : [ 0xec, ['unsigned long']],
} ],
  'EX_QUEUE_WORKER_INFO' : [ 0x4, {
    'QueueDisabled' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'MakeThreadsAsNecessary' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'WaitMode' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'WorkerCount' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
    'QueueWorkerInfo' : [ 0x0, ['long']],
} ],
  'BATTERY_REPORTING_SCALE' : [ 0x8, {
    'Granularity' : [ 0x0, ['unsigned long']],
    'Capacity' : [ 0x4, ['unsigned long']],
} ],
  '_CURDIR' : [ 0xc, {
    'DosPath' : [ 0x0, ['_UNICODE_STRING']],
    'Handle' : [ 0x8, ['pointer', ['void']]],
} ],
  '_PO_HIBER_PERF' : [ 0x60, {
    'IoTicks' : [ 0x0, ['unsigned long long']],
    'InitTicks' : [ 0x8, ['unsigned long long']],
    'CopyTicks' : [ 0x10, ['unsigned long long']],
    'StartCount' : [ 0x18, ['unsigned long long']],
    'ElapsedTime' : [ 0x20, ['unsigned long']],
    'IoTime' : [ 0x24, ['unsigned long']],
    'CopyTime' : [ 0x28, ['unsigned long']],
    'InitTime' : [ 0x2c, ['unsigned long']],
    'PagesWritten' : [ 0x30, ['unsigned long']],
    'PagesProcessed' : [ 0x34, ['unsigned long']],
    'BytesCopied' : [ 0x38, ['unsigned long']],
    'DumpCount' : [ 0x3c, ['unsigned long']],
    'FileRuns' : [ 0x40, ['unsigned long']],
    'ResumeAppStartTime' : [ 0x48, ['unsigned long long']],
    'ResumeAppEndTime' : [ 0x50, ['unsigned long long']],
    'HiberFileResumeTime' : [ 0x58, ['unsigned long long']],
} ],
  '_DEVICE_FLAGS' : [ 0x4, {
    'Failed' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ReadOnly' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Removable' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'ConsoleIn' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'ConsoleOut' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'Input' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'Output' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
} ],
  '_RTL_BALANCED_LINKS' : [ 0x10, {
    'Parent' : [ 0x0, ['pointer', ['_RTL_BALANCED_LINKS']]],
    'LeftChild' : [ 0x4, ['pointer', ['_RTL_BALANCED_LINKS']]],
    'RightChild' : [ 0x8, ['pointer', ['_RTL_BALANCED_LINKS']]],
    'Balance' : [ 0xc, ['unsigned char']],
    'Reserved' : [ 0xd, ['array', 3, ['unsigned char']]],
} ],
  '_MMVIEW' : [ 0x8, {
    'Entry' : [ 0x0, ['unsigned long']],
    'Writable' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ControlArea' : [ 0x4, ['pointer', ['_CONTROL_AREA']]],
} ],
  '_MM_SESSION_SPACE_FLAGS' : [ 0x4, {
    'Initialized' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'DeletePending' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'PoolInitialized' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'DynamicVaInitialized' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'WsInitialized' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'PoolDestroyed' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'ObjectInitialized' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'Filler' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 32, native_type='unsigned long')]],
} ],
  '_RTL_CRITICAL_SECTION_DEBUG' : [ 0x20, {
    'Type' : [ 0x0, ['unsigned short']],
    'CreatorBackTraceIndex' : [ 0x2, ['unsigned short']],
    'CriticalSection' : [ 0x4, ['pointer', ['_RTL_CRITICAL_SECTION']]],
    'ProcessLocksList' : [ 0x8, ['_LIST_ENTRY']],
    'EntryCount' : [ 0x10, ['unsigned long']],
    'ContentionCount' : [ 0x14, ['unsigned long']],
    'Flags' : [ 0x18, ['unsigned long']],
    'CreatorBackTraceIndexHigh' : [ 0x1c, ['unsigned short']],
    'SpareUSHORT' : [ 0x1e, ['unsigned short']],
} ],
  '__unnamed_2093' : [ 0x14, {
    'ClassGuid' : [ 0x0, ['_GUID']],
    'SymbolicLinkName' : [ 0x10, ['array', 1, ['wchar']]],
} ],
  '__unnamed_2095' : [ 0x2, {
    'DeviceIds' : [ 0x0, ['array', 1, ['wchar']]],
} ],
  '__unnamed_2097' : [ 0x2, {
    'DeviceId' : [ 0x0, ['array', 1, ['wchar']]],
} ],
  '__unnamed_2099' : [ 0x8, {
    'NotificationStructure' : [ 0x0, ['pointer', ['void']]],
    'DeviceIds' : [ 0x4, ['array', 1, ['wchar']]],
} ],
  '__unnamed_209b' : [ 0x4, {
    'Notification' : [ 0x0, ['pointer', ['void']]],
} ],
  '__unnamed_209d' : [ 0x8, {
    'NotificationCode' : [ 0x0, ['unsigned long']],
    'NotificationData' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_209f' : [ 0x8, {
    'VetoType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'PNP_VetoTypeUnknown', 1: 'PNP_VetoLegacyDevice', 2: 'PNP_VetoPendingClose', 3: 'PNP_VetoWindowsApp', 4: 'PNP_VetoWindowsService', 5: 'PNP_VetoOutstandingOpen', 6: 'PNP_VetoDevice', 7: 'PNP_VetoDriver', 8: 'PNP_VetoIllegalDeviceRequest', 9: 'PNP_VetoInsufficientPower', 10: 'PNP_VetoNonDisableable', 11: 'PNP_VetoLegacyDriver', 12: 'PNP_VetoInsufficientRights'})]],
    'DeviceIdVetoNameBuffer' : [ 0x4, ['array', 1, ['wchar']]],
} ],
  '__unnamed_20a1' : [ 0x10, {
    'BlockedDriverGuid' : [ 0x0, ['_GUID']],
} ],
  '__unnamed_20a3' : [ 0x2, {
    'ParentId' : [ 0x0, ['array', 1, ['wchar']]],
} ],
  '__unnamed_20a5' : [ 0x1c, {
    'PowerSettingGuid' : [ 0x0, ['_GUID']],
    'PowerSettingChanged' : [ 0x10, ['unsigned char']],
    'DataLength' : [ 0x14, ['unsigned long']],
    'Data' : [ 0x18, ['array', 1, ['unsigned char']]],
} ],
  '__unnamed_20a7' : [ 0x1c, {
    'DeviceClass' : [ 0x0, ['__unnamed_2093']],
    'TargetDevice' : [ 0x0, ['__unnamed_2095']],
    'InstallDevice' : [ 0x0, ['__unnamed_2097']],
    'CustomNotification' : [ 0x0, ['__unnamed_2099']],
    'ProfileNotification' : [ 0x0, ['__unnamed_209b']],
    'PowerNotification' : [ 0x0, ['__unnamed_209d']],
    'VetoNotification' : [ 0x0, ['__unnamed_209f']],
    'BlockedDriverNotification' : [ 0x0, ['__unnamed_20a1']],
    'InvalidIDNotification' : [ 0x0, ['__unnamed_20a3']],
    'PowerSettingNotification' : [ 0x0, ['__unnamed_20a5']],
} ],
  '_PLUGPLAY_EVENT_BLOCK' : [ 0x40, {
    'EventGuid' : [ 0x0, ['_GUID']],
    'EventCategory' : [ 0x10, ['Enumeration', dict(target = 'long', choices = {0: 'HardwareProfileChangeEvent', 1: 'TargetDeviceChangeEvent', 2: 'DeviceClassChangeEvent', 3: 'CustomDeviceEvent', 4: 'DeviceInstallEvent', 5: 'DeviceArrivalEvent', 6: 'PowerEvent', 7: 'VetoEvent', 8: 'BlockedDriverEvent', 9: 'InvalidIDEvent', 10: 'PowerSettingChange', 11: 'MaxPlugEventCategory'})]],
    'Result' : [ 0x14, ['pointer', ['unsigned long']]],
    'Flags' : [ 0x18, ['unsigned long']],
    'TotalSize' : [ 0x1c, ['unsigned long']],
    'DeviceObject' : [ 0x20, ['pointer', ['void']]],
    'u' : [ 0x24, ['__unnamed_20a7']],
} ],
  '_HEADLESS_LOADER_BLOCK' : [ 0x34, {
    'UsedBiosSettings' : [ 0x0, ['unsigned char']],
    'DataBits' : [ 0x1, ['unsigned char']],
    'StopBits' : [ 0x2, ['unsigned char']],
    'Parity' : [ 0x3, ['unsigned char']],
    'BaudRate' : [ 0x4, ['unsigned long']],
    'PortNumber' : [ 0x8, ['unsigned long']],
    'PortAddress' : [ 0xc, ['pointer', ['unsigned char']]],
    'PciDeviceId' : [ 0x10, ['unsigned short']],
    'PciVendorId' : [ 0x12, ['unsigned short']],
    'PciBusNumber' : [ 0x14, ['unsigned char']],
    'PciBusSegment' : [ 0x16, ['unsigned short']],
    'PciSlotNumber' : [ 0x18, ['unsigned char']],
    'PciFunctionNumber' : [ 0x19, ['unsigned char']],
    'PciFlags' : [ 0x1c, ['unsigned long']],
    'SystemGUID' : [ 0x20, ['_GUID']],
    'IsMMIODevice' : [ 0x30, ['unsigned char']],
    'TerminalType' : [ 0x31, ['unsigned char']],
} ],
  '_POWER_CHANNEL_SUMMARY' : [ 0x14, {
    'Signature' : [ 0x0, ['unsigned long']],
    'TotalCount' : [ 0x4, ['unsigned long']],
    'D0Count' : [ 0x8, ['unsigned long']],
    'NotifyList' : [ 0xc, ['_LIST_ENTRY']],
} ],
  '__unnamed_20ba' : [ 0x8, {
    'Signature' : [ 0x0, ['unsigned long']],
    'CheckSum' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_20bc' : [ 0x10, {
    'DiskId' : [ 0x0, ['_GUID']],
} ],
  '__unnamed_20be' : [ 0x10, {
    'Mbr' : [ 0x0, ['__unnamed_20ba']],
    'Gpt' : [ 0x0, ['__unnamed_20bc']],
} ],
  '_DUMP_INITIALIZATION_CONTEXT' : [ 0x70, {
    'Length' : [ 0x0, ['unsigned long']],
    'Reserved' : [ 0x4, ['unsigned long']],
    'MemoryBlock' : [ 0x8, ['pointer', ['void']]],
    'CommonBuffer' : [ 0xc, ['array', 2, ['pointer', ['void']]]],
    'PhysicalAddress' : [ 0x18, ['array', 2, ['_LARGE_INTEGER']]],
    'StallRoutine' : [ 0x28, ['pointer', ['void']]],
    'OpenRoutine' : [ 0x2c, ['pointer', ['void']]],
    'WriteRoutine' : [ 0x30, ['pointer', ['void']]],
    'FinishRoutine' : [ 0x34, ['pointer', ['void']]],
    'AdapterObject' : [ 0x38, ['pointer', ['_ADAPTER_OBJECT']]],
    'MappedRegisterBase' : [ 0x3c, ['pointer', ['void']]],
    'PortConfiguration' : [ 0x40, ['pointer', ['void']]],
    'CrashDump' : [ 0x44, ['unsigned char']],
    'MaximumTransferSize' : [ 0x48, ['unsigned long']],
    'CommonBufferSize' : [ 0x4c, ['unsigned long']],
    'TargetAddress' : [ 0x50, ['pointer', ['void']]],
    'WritePendingRoutine' : [ 0x54, ['pointer', ['void']]],
    'PartitionStyle' : [ 0x58, ['unsigned long']],
    'DiskInfo' : [ 0x5c, ['__unnamed_20be']],
} ],
  '_MI_SYSTEM_PTE_TYPE' : [ 0x2c, {
    'Bitmap' : [ 0x0, ['_RTL_BITMAP']],
    'Hint' : [ 0x8, ['unsigned long']],
    'BasePte' : [ 0xc, ['pointer', ['_MMPTE']]],
    'FailureCount' : [ 0x10, ['pointer', ['unsigned long']]],
    'Vm' : [ 0x14, ['pointer', ['_MMSUPPORT']]],
    'TotalSystemPtes' : [ 0x18, ['long']],
    'TotalFreeSystemPtes' : [ 0x1c, ['long']],
    'CachedPteCount' : [ 0x20, ['long']],
    'PteFailures' : [ 0x24, ['unsigned long']],
    'GlobalMutex' : [ 0x28, ['pointer', ['_KGUARDED_MUTEX']]],
} ],
  '_NETWORK_LOADER_BLOCK' : [ 0x10, {
    'DHCPServerACK' : [ 0x0, ['pointer', ['unsigned char']]],
    'DHCPServerACKLength' : [ 0x4, ['unsigned long']],
    'BootServerReplyPacket' : [ 0x8, ['pointer', ['unsigned char']]],
    'BootServerReplyPacketLength' : [ 0xc, ['unsigned long']],
} ],
  '_CM_KEY_SECURITY' : [ 0x28, {
    'Signature' : [ 0x0, ['unsigned short']],
    'Reserved' : [ 0x2, ['unsigned short']],
    'Flink' : [ 0x4, ['unsigned long']],
    'Blink' : [ 0x8, ['unsigned long']],
    'ReferenceCount' : [ 0xc, ['unsigned long']],
    'DescriptorLength' : [ 0x10, ['unsigned long']],
    'Descriptor' : [ 0x14, ['_SECURITY_DESCRIPTOR_RELATIVE']],
} ],
  '_PO_DEVICE_NOTIFY_ORDER' : [ 0x148, {
    'Locked' : [ 0x0, ['unsigned char']],
    'WarmEjectPdoPointer' : [ 0x4, ['pointer', ['pointer', ['_DEVICE_OBJECT']]]],
    'OrderLevel' : [ 0x8, ['array', 8, ['_PO_NOTIFY_ORDER_LEVEL']]],
} ],
  '_IA64_DBGKD_CONTROL_SET' : [ 0x14, {
    'Continue' : [ 0x0, ['unsigned long']],
    'CurrentSymbolStart' : [ 0x4, ['unsigned long long']],
    'CurrentSymbolEnd' : [ 0xc, ['unsigned long long']],
} ],
  '_ARBITER_CONFLICT_INFO' : [ 0x18, {
    'OwningObject' : [ 0x0, ['pointer', ['_DEVICE_OBJECT']]],
    'Start' : [ 0x8, ['unsigned long long']],
    'End' : [ 0x10, ['unsigned long long']],
} ],
  '_PO_NOTIFY_ORDER_LEVEL' : [ 0x28, {
    'DeviceCount' : [ 0x0, ['unsigned long']],
    'ActiveCount' : [ 0x4, ['unsigned long']],
    'WaitSleep' : [ 0x8, ['_LIST_ENTRY']],
    'ReadySleep' : [ 0x10, ['_LIST_ENTRY']],
    'ReadyS0' : [ 0x18, ['_LIST_ENTRY']],
    'WaitS0' : [ 0x20, ['_LIST_ENTRY']],
} ],
  '_VI_DEADLOCK_ADDRESS_RANGE' : [ 0x8, {
    'Start' : [ 0x0, ['pointer', ['unsigned char']]],
    'End' : [ 0x4, ['pointer', ['unsigned char']]],
} ],
  '_AMD64_DBGKD_CONTROL_SET' : [ 0x1c, {
    'TraceFlag' : [ 0x0, ['unsigned long']],
    'Dr7' : [ 0x4, ['unsigned long long']],
    'CurrentSymbolStart' : [ 0xc, ['unsigned long long']],
    'CurrentSymbolEnd' : [ 0x14, ['unsigned long long']],
} ],
  '_ETW_REPLY_QUEUE' : [ 0x2c, {
    'Queue' : [ 0x0, ['_KQUEUE']],
    'EventsLost' : [ 0x28, ['long']],
} ],
  '_ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS' : [ 0x4, {
    'AllocatedResources' : [ 0x0, ['pointer', ['pointer', ['_CM_PARTIAL_RESOURCE_LIST']]]],
} ],
  '_KSPECIAL_REGISTERS' : [ 0x54, {
    'Cr0' : [ 0x0, ['unsigned long']],
    'Cr2' : [ 0x4, ['unsigned long']],
    'Cr3' : [ 0x8, ['unsigned long']],
    'Cr4' : [ 0xc, ['unsigned long']],
    'KernelDr0' : [ 0x10, ['unsigned long']],
    'KernelDr1' : [ 0x14, ['unsigned long']],
    'KernelDr2' : [ 0x18, ['unsigned long']],
    'KernelDr3' : [ 0x1c, ['unsigned long']],
    'KernelDr6' : [ 0x20, ['unsigned long']],
    'KernelDr7' : [ 0x24, ['unsigned long']],
    'Gdtr' : [ 0x28, ['_DESCRIPTOR']],
    'Idtr' : [ 0x30, ['_DESCRIPTOR']],
    'Tr' : [ 0x38, ['unsigned short']],
    'Ldtr' : [ 0x3a, ['unsigned short']],
    'Reserved' : [ 0x3c, ['array', 6, ['unsigned long']]],
} ],
  '_PO_MEMORY_RANGE_TABLE' : [ 0x14, {
    'Next' : [ 0x0, ['pointer', ['_PO_MEMORY_RANGE_TABLE']]],
    'NextTable' : [ 0x4, ['unsigned long']],
    'EntryCount' : [ 0x8, ['unsigned long']],
    'Range' : [ 0xc, ['array', 1, ['_PO_MEMORY_RANGE']]],
} ],
  '_RTL_ACTIVATION_CONTEXT_STACK_FRAME' : [ 0xc, {
    'Previous' : [ 0x0, ['pointer', ['_RTL_ACTIVATION_CONTEXT_STACK_FRAME']]],
    'ActivationContext' : [ 0x4, ['pointer', ['_ACTIVATION_CONTEXT']]],
    'Flags' : [ 0x8, ['unsigned long']],
} ],
  '_ARBITER_ORDERING' : [ 0x10, {
    'Start' : [ 0x0, ['unsigned long long']],
    'End' : [ 0x8, ['unsigned long long']],
} ],
  '_RTL_AVL_TABLE' : [ 0x38, {
    'BalancedRoot' : [ 0x0, ['_RTL_BALANCED_LINKS']],
    'OrderedPointer' : [ 0x10, ['pointer', ['void']]],
    'WhichOrderedElement' : [ 0x14, ['unsigned long']],
    'NumberGenericTableElements' : [ 0x18, ['unsigned long']],
    'DepthOfTree' : [ 0x1c, ['unsigned long']],
    'RestartKey' : [ 0x20, ['pointer', ['_RTL_BALANCED_LINKS']]],
    'DeleteCount' : [ 0x24, ['unsigned long']],
    'CompareRoutine' : [ 0x28, ['pointer', ['void']]],
    'AllocateRoutine' : [ 0x2c, ['pointer', ['void']]],
    'FreeRoutine' : [ 0x30, ['pointer', ['void']]],
    'TableContext' : [ 0x34, ['pointer', ['void']]],
} ],
  '_KTRANSACTION_HISTORY' : [ 0x8, {
    'RecordType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {1: 'KTMOH_CommitTransaction_Result', 2: 'KTMOH_RollbackTransaction_Result'})]],
    'Payload' : [ 0x4, ['unsigned long']],
} ],
  '_DESCRIPTOR' : [ 0x8, {
    'Pad' : [ 0x0, ['unsigned short']],
    'Limit' : [ 0x2, ['unsigned short']],
    'Base' : [ 0x4, ['unsigned long']],
} ],
  '_PO_MEMORY_RANGE' : [ 0x8, {
    'StartPage' : [ 0x0, ['unsigned long']],
    'EndPage' : [ 0x4, ['unsigned long']],
} ],
  'LIST_ENTRY64' : [ 0x10, {
    'Flink' : [ 0x0, ['unsigned long long']],
    'Blink' : [ 0x8, ['unsigned long long']],
} ],
  'LIST_ENTRY32' : [ 0x8, {
    'Flink' : [ 0x0, ['unsigned long']],
    'Blink' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_1019' : [ 0x8, {
    'LowPart' : [ 0x0, ['unsigned long']],
    'HighPart' : [ 0x4, ['unsigned long']],
} ],
  '_ULARGE_INTEGER' : [ 0x8, {
    'LowPart' : [ 0x0, ['unsigned long']],
    'HighPart' : [ 0x4, ['unsigned long']],
    'u' : [ 0x0, ['__unnamed_1019']],
    'QuadPart' : [ 0x0, ['unsigned long long']],
} ],
  '__unnamed_101e' : [ 0x8, {
    'LowPart' : [ 0x0, ['unsigned long']],
    'HighPart' : [ 0x4, ['long']],
} ],
  '_LARGE_INTEGER' : [ 0x8, {
    'LowPart' : [ 0x0, ['unsigned long']],
    'HighPart' : [ 0x4, ['long']],
    'u' : [ 0x0, ['__unnamed_101e']],
    'QuadPart' : [ 0x0, ['long long']],
} ],
  '__unnamed_1037' : [ 0x4, {
    'LongFunction' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Private' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_1039' : [ 0x4, {
    'Flags' : [ 0x0, ['unsigned long']],
    's' : [ 0x0, ['__unnamed_1037']],
} ],
  '_TP_CALLBACK_ENVIRON' : [ 0x20, {
    'Version' : [ 0x0, ['unsigned long']],
    'Pool' : [ 0x4, ['pointer', ['_TP_POOL']]],
    'CleanupGroup' : [ 0x8, ['pointer', ['_TP_CLEANUP_GROUP']]],
    'CleanupGroupCancelCallback' : [ 0xc, ['pointer', ['void']]],
    'RaceDll' : [ 0x10, ['pointer', ['void']]],
    'ActivationContext' : [ 0x14, ['pointer', ['_ACTIVATION_CONTEXT']]],
    'FinalizationCallback' : [ 0x18, ['pointer', ['void']]],
    'u' : [ 0x1c, ['__unnamed_1039']],
} ],
  '_TP_TASK_CALLBACKS' : [ 0x8, {
    'ExecuteCallback' : [ 0x0, ['pointer', ['void']]],
    'Unposted' : [ 0x4, ['pointer', ['void']]],
} ],
  '_TP_TASK' : [ 0x4, {
    'Callbacks' : [ 0x0, ['pointer', ['_TP_TASK_CALLBACKS']]],
} ],
  '_TP_DIRECT' : [ 0x4, {
    'Callback' : [ 0x0, ['pointer', ['void']]],
} ],
  '_LIST_ENTRY' : [ 0x8, {
    'Flink' : [ 0x0, ['pointer', ['_LIST_ENTRY']]],
    'Blink' : [ 0x4, ['pointer', ['_LIST_ENTRY']]],
} ],
  '_SINGLE_LIST_ENTRY' : [ 0x4, {
    'Next' : [ 0x0, ['pointer', ['_SINGLE_LIST_ENTRY']]],
} ],
  '_UNICODE_STRING' : [ 0x8, {
    'Length' : [ 0x0, ['unsigned short']],
    'MaximumLength' : [ 0x2, ['unsigned short']],
    'Buffer' : [ 0x4, ['pointer', ['unsigned short']]],
} ],
  '_STRING' : [ 0x8, {
    'Length' : [ 0x0, ['unsigned short']],
    'MaximumLength' : [ 0x2, ['unsigned short']],
    'Buffer' : [ 0x4, ['pointer', ['unsigned char']]],
} ],
  '_LUID' : [ 0x8, {
    'LowPart' : [ 0x0, ['unsigned long']],
    'HighPart' : [ 0x4, ['long']],
} ],
  '_IMAGE_NT_HEADERS' : [ 0xf8, {
    'Signature' : [ 0x0, ['unsigned long']],
    'FileHeader' : [ 0x4, ['_IMAGE_FILE_HEADER']],
    'OptionalHeader' : [ 0x18, ['_IMAGE_OPTIONAL_HEADER']],
} ],
  '_KPRCB' : [ 0x2008, {
    'MinorVersion' : [ 0x0, ['unsigned short']],
    'MajorVersion' : [ 0x2, ['unsigned short']],
    'CurrentThread' : [ 0x4, ['pointer', ['_KTHREAD']]],
    'NextThread' : [ 0x8, ['pointer', ['_KTHREAD']]],
    'IdleThread' : [ 0xc, ['pointer', ['_KTHREAD']]],
    'Number' : [ 0x10, ['unsigned char']],
    'NestingLevel' : [ 0x11, ['unsigned char']],
    'BuildType' : [ 0x12, ['unsigned short']],
    'SetMember' : [ 0x14, ['unsigned long']],
    'CpuType' : [ 0x18, ['unsigned char']],
    'CpuID' : [ 0x19, ['unsigned char']],
    'CpuStep' : [ 0x1a, ['unsigned short']],
    'CpuStepping' : [ 0x1a, ['unsigned char']],
    'CpuModel' : [ 0x1b, ['unsigned char']],
    'ProcessorState' : [ 0x1c, ['_KPROCESSOR_STATE']],
    'KernelReserved' : [ 0x33c, ['array', 16, ['unsigned long']]],
    'HalReserved' : [ 0x37c, ['array', 16, ['unsigned long']]],
    'CFlushSize' : [ 0x3bc, ['unsigned long']],
    'CoresPerPhysicalProcessor' : [ 0x3c0, ['unsigned char']],
    'LogicalProcessorsPerCore' : [ 0x3c1, ['unsigned char']],
    'PrcbPad0' : [ 0x3c2, ['array', 2, ['unsigned char']]],
    'MHz' : [ 0x3c4, ['unsigned long']],
    'PrcbPad1' : [ 0x3c8, ['array', 80, ['unsigned char']]],
    'LockQueue' : [ 0x418, ['array', 49, ['_KSPIN_LOCK_QUEUE']]],
    'NpxThread' : [ 0x5a0, ['pointer', ['_KTHREAD']]],
    'InterruptCount' : [ 0x5a4, ['unsigned long']],
    'KernelTime' : [ 0x5a8, ['unsigned long']],
    'UserTime' : [ 0x5ac, ['unsigned long']],
    'DpcTime' : [ 0x5b0, ['unsigned long']],
    'DpcTimeCount' : [ 0x5b4, ['unsigned long']],
    'InterruptTime' : [ 0x5b8, ['unsigned long']],
    'AdjustDpcThreshold' : [ 0x5bc, ['unsigned long']],
    'PageColor' : [ 0x5c0, ['unsigned long']],
    'SkipTick' : [ 0x5c4, ['unsigned char']],
    'DebuggerSavedIRQL' : [ 0x5c5, ['unsigned char']],
    'NodeColor' : [ 0x5c6, ['unsigned char']],
    'PollSlot' : [ 0x5c7, ['unsigned char']],
    'NodeShiftedColor' : [ 0x5c8, ['unsigned long']],
    'ParentNode' : [ 0x5cc, ['pointer', ['_KNODE']]],
    'MultiThreadProcessorSet' : [ 0x5d0, ['unsigned long']],
    'MultiThreadSetMaster' : [ 0x5d4, ['pointer', ['_KPRCB']]],
    'SecondaryColorMask' : [ 0x5d8, ['unsigned long']],
    'DpcTimeLimit' : [ 0x5dc, ['unsigned long']],
    'CcFastReadNoWait' : [ 0x5e0, ['unsigned long']],
    'CcFastReadWait' : [ 0x5e4, ['unsigned long']],
    'CcFastReadNotPossible' : [ 0x5e8, ['unsigned long']],
    'CcCopyReadNoWait' : [ 0x5ec, ['unsigned long']],
    'CcCopyReadWait' : [ 0x5f0, ['unsigned long']],
    'CcCopyReadNoWaitMiss' : [ 0x5f4, ['unsigned long']],
    'MmSpinLockOrdering' : [ 0x5f8, ['long']],
    'IoReadOperationCount' : [ 0x5fc, ['long']],
    'IoWriteOperationCount' : [ 0x600, ['long']],
    'IoOtherOperationCount' : [ 0x604, ['long']],
    'IoReadTransferCount' : [ 0x608, ['_LARGE_INTEGER']],
    'IoWriteTransferCount' : [ 0x610, ['_LARGE_INTEGER']],
    'IoOtherTransferCount' : [ 0x618, ['_LARGE_INTEGER']],
    'CcFastMdlReadNoWait' : [ 0x620, ['unsigned long']],
    'CcFastMdlReadWait' : [ 0x624, ['unsigned long']],
    'CcFastMdlReadNotPossible' : [ 0x628, ['unsigned long']],
    'CcMapDataNoWait' : [ 0x62c, ['unsigned long']],
    'CcMapDataWait' : [ 0x630, ['unsigned long']],
    'CcPinMappedDataCount' : [ 0x634, ['unsigned long']],
    'CcPinReadNoWait' : [ 0x638, ['unsigned long']],
    'CcPinReadWait' : [ 0x63c, ['unsigned long']],
    'CcMdlReadNoWait' : [ 0x640, ['unsigned long']],
    'CcMdlReadWait' : [ 0x644, ['unsigned long']],
    'CcLazyWriteHotSpots' : [ 0x648, ['unsigned long']],
    'CcLazyWriteIos' : [ 0x64c, ['unsigned long']],
    'CcLazyWritePages' : [ 0x650, ['unsigned long']],
    'CcDataFlushes' : [ 0x654, ['unsigned long']],
    'CcDataPages' : [ 0x658, ['unsigned long']],
    'CcLostDelayedWrites' : [ 0x65c, ['unsigned long']],
    'CcFastReadResourceMiss' : [ 0x660, ['unsigned long']],
    'CcCopyReadWaitMiss' : [ 0x664, ['unsigned long']],
    'CcFastMdlReadResourceMiss' : [ 0x668, ['unsigned long']],
    'CcMapDataNoWaitMiss' : [ 0x66c, ['unsigned long']],
    'CcMapDataWaitMiss' : [ 0x670, ['unsigned long']],
    'CcPinReadNoWaitMiss' : [ 0x674, ['unsigned long']],
    'CcPinReadWaitMiss' : [ 0x678, ['unsigned long']],
    'CcMdlReadNoWaitMiss' : [ 0x67c, ['unsigned long']],
    'CcMdlReadWaitMiss' : [ 0x680, ['unsigned long']],
    'CcReadAheadIos' : [ 0x684, ['unsigned long']],
    'KeAlignmentFixupCount' : [ 0x688, ['unsigned long']],
    'KeExceptionDispatchCount' : [ 0x68c, ['unsigned long']],
    'KeSystemCalls' : [ 0x690, ['unsigned long']],
    'PrcbPad2' : [ 0x694, ['array', 3, ['unsigned long']]],
    'PPLookasideList' : [ 0x6a0, ['array', 16, ['_PP_LOOKASIDE_LIST']]],
    'PPNPagedLookasideList' : [ 0x720, ['array', 32, ['_GENERAL_LOOKASIDE_POOL']]],
    'PPPagedLookasideList' : [ 0x1020, ['array', 32, ['_GENERAL_LOOKASIDE_POOL']]],
    'PacketBarrier' : [ 0x1920, ['unsigned long']],
    'ReverseStall' : [ 0x1924, ['long']],
    'IpiFrame' : [ 0x1928, ['pointer', ['void']]],
    'PrcbPad3' : [ 0x192c, ['array', 52, ['unsigned char']]],
    'CurrentPacket' : [ 0x1960, ['array', 3, ['pointer', ['void']]]],
    'TargetSet' : [ 0x196c, ['unsigned long']],
    'WorkerRoutine' : [ 0x1970, ['pointer', ['void']]],
    'IpiFrozen' : [ 0x1974, ['unsigned long']],
    'PrcbPad4' : [ 0x1978, ['array', 40, ['unsigned char']]],
    'RequestSummary' : [ 0x19a0, ['unsigned long']],
    'SignalDone' : [ 0x19a4, ['pointer', ['_KPRCB']]],
    'PrcbPad5' : [ 0x19a8, ['array', 56, ['unsigned char']]],
    'DpcData' : [ 0x19e0, ['array', 2, ['_KDPC_DATA']]],
    'DpcStack' : [ 0x1a08, ['pointer', ['void']]],
    'MaximumDpcQueueDepth' : [ 0x1a0c, ['long']],
    'DpcRequestRate' : [ 0x1a10, ['unsigned long']],
    'MinimumDpcRate' : [ 0x1a14, ['unsigned long']],
    'DpcInterruptRequested' : [ 0x1a18, ['unsigned char']],
    'DpcThreadRequested' : [ 0x1a19, ['unsigned char']],
    'DpcRoutineActive' : [ 0x1a1a, ['unsigned char']],
    'DpcThreadActive' : [ 0x1a1b, ['unsigned char']],
    'PrcbLock' : [ 0x1a1c, ['unsigned long']],
    'DpcLastCount' : [ 0x1a20, ['unsigned long']],
    'TimerHand' : [ 0x1a24, ['unsigned long']],
    'TimerRequest' : [ 0x1a28, ['unsigned long']],
    'PrcbPad41' : [ 0x1a2c, ['pointer', ['void']]],
    'DpcEvent' : [ 0x1a30, ['_KEVENT']],
    'ThreadDpcEnable' : [ 0x1a40, ['unsigned char']],
    'QuantumEnd' : [ 0x1a41, ['unsigned char']],
    'PrcbPad50' : [ 0x1a42, ['unsigned char']],
    'IdleSchedule' : [ 0x1a43, ['unsigned char']],
    'DpcSetEventRequest' : [ 0x1a44, ['long']],
    'Sleeping' : [ 0x1a48, ['long']],
    'PeriodicCount' : [ 0x1a4c, ['unsigned long']],
    'PeriodicBias' : [ 0x1a50, ['unsigned long']],
    'PrcbPad51' : [ 0x1a54, ['array', 6, ['unsigned char']]],
    'TickOffset' : [ 0x1a5c, ['long']],
    'CallDpc' : [ 0x1a60, ['_KDPC']],
    'ClockKeepAlive' : [ 0x1a80, ['long']],
    'ClockCheckSlot' : [ 0x1a84, ['unsigned char']],
    'ClockPollCycle' : [ 0x1a85, ['unsigned char']],
    'PrcbPad6' : [ 0x1a86, ['array', 2, ['unsigned char']]],
    'DpcWatchdogPeriod' : [ 0x1a88, ['long']],
    'DpcWatchdogCount' : [ 0x1a8c, ['long']],
    'ThreadWatchdogPeriod' : [ 0x1a90, ['long']],
    'ThreadWatchdogCount' : [ 0x1a94, ['long']],
    'PrcbPad70' : [ 0x1a98, ['array', 2, ['unsigned long']]],
    'WaitListHead' : [ 0x1aa0, ['_LIST_ENTRY']],
    'WaitLock' : [ 0x1aa8, ['unsigned long']],
    'ReadySummary' : [ 0x1aac, ['unsigned long']],
    'QueueIndex' : [ 0x1ab0, ['unsigned long']],
    'DeferredReadyListHead' : [ 0x1ab4, ['_SINGLE_LIST_ENTRY']],
    'StartCycles' : [ 0x1ab8, ['unsigned long long']],
    'CycleTime' : [ 0x1ac0, ['unsigned long long']],
    'PrcbPad71' : [ 0x1ac8, ['array', 3, ['unsigned long long']]],
    'DispatcherReadyListHead' : [ 0x1ae0, ['array', 32, ['_LIST_ENTRY']]],
    'ChainedInterruptList' : [ 0x1be0, ['pointer', ['void']]],
    'LookasideIrpFloat' : [ 0x1be4, ['long']],
    'MmPageFaultCount' : [ 0x1be8, ['long']],
    'MmCopyOnWriteCount' : [ 0x1bec, ['long']],
    'MmTransitionCount' : [ 0x1bf0, ['long']],
    'MmCacheTransitionCount' : [ 0x1bf4, ['long']],
    'MmDemandZeroCount' : [ 0x1bf8, ['long']],
    'MmPageReadCount' : [ 0x1bfc, ['long']],
    'MmPageReadIoCount' : [ 0x1c00, ['long']],
    'MmCacheReadCount' : [ 0x1c04, ['long']],
    'MmCacheIoCount' : [ 0x1c08, ['long']],
    'MmDirtyPagesWriteCount' : [ 0x1c0c, ['long']],
    'MmDirtyWriteIoCount' : [ 0x1c10, ['long']],
    'MmMappedPagesWriteCount' : [ 0x1c14, ['long']],
    'MmMappedWriteIoCount' : [ 0x1c18, ['long']],
    'CachedCommit' : [ 0x1c1c, ['unsigned long']],
    'CachedResidentAvailable' : [ 0x1c20, ['unsigned long']],
    'HyperPte' : [ 0x1c24, ['pointer', ['void']]],
    'CpuVendor' : [ 0x1c28, ['unsigned char']],
    'PrcbPad8' : [ 0x1c29, ['array', 3, ['unsigned char']]],
    'VendorString' : [ 0x1c2c, ['array', 13, ['unsigned char']]],
    'InitialApicId' : [ 0x1c39, ['unsigned char']],
    'LogicalProcessorsPerPhysicalProcessor' : [ 0x1c3a, ['unsigned char']],
    'PrcbPad9' : [ 0x1c3b, ['array', 5, ['unsigned char']]],
    'FeatureBits' : [ 0x1c40, ['unsigned long']],
    'UpdateSignature' : [ 0x1c48, ['_LARGE_INTEGER']],
    'IsrTime' : [ 0x1c50, ['unsigned long long']],
    'SpareField1' : [ 0x1c58, ['unsigned long long']],
    'NpxSaveArea' : [ 0x1c60, ['_FX_SAVE_AREA']],
    'PowerState' : [ 0x1e70, ['_PROCESSOR_POWER_STATE']],
    'DpcWatchdogDpc' : [ 0x1f38, ['_KDPC']],
    'DpcWatchdogTimer' : [ 0x1f58, ['_KTIMER']],
    'WheaInfo' : [ 0x1f80, ['pointer', ['void']]],
    'EtwSupport' : [ 0x1f84, ['pointer', ['void']]],
    'InterruptObjectPool' : [ 0x1f88, ['_SLIST_HEADER']],
    'HypercallPageList' : [ 0x1f90, ['_SLIST_HEADER']],
    'HypercallPageVirtual' : [ 0x1f98, ['pointer', ['void']]],
    'VirtualApicAssist' : [ 0x1f9c, ['pointer', ['void']]],
    'StatisticsPage' : [ 0x1fa0, ['pointer', ['unsigned long long']]],
    'RateControl' : [ 0x1fa4, ['pointer', ['void']]],
    'Cache' : [ 0x1fa8, ['array', 5, ['_CACHE_DESCRIPTOR']]],
    'CacheCount' : [ 0x1fe4, ['unsigned long']],
    'CacheProcessorMask' : [ 0x1fe8, ['array', 5, ['unsigned long']]],
    'PackageProcessorSet' : [ 0x1ffc, ['unsigned long']],
    'CoreProcessorSet' : [ 0x2000, ['unsigned long']],
} ],
  '_KPCR' : [ 0x2128, {
    'NtTib' : [ 0x0, ['_NT_TIB']],
    'Used_ExceptionList' : [ 0x0, ['pointer', ['_EXCEPTION_REGISTRATION_RECORD']]],
    'Used_StackBase' : [ 0x4, ['pointer', ['void']]],
    'Spare2' : [ 0x8, ['pointer', ['void']]],
    'TssCopy' : [ 0xc, ['pointer', ['void']]],
    'ContextSwitches' : [ 0x10, ['unsigned long']],
    'SetMemberCopy' : [ 0x14, ['unsigned long']],
    'Used_Self' : [ 0x18, ['pointer', ['void']]],
    'SelfPcr' : [ 0x1c, ['pointer', ['_KPCR']]],
    'Prcb' : [ 0x20, ['pointer', ['_KPRCB']]],
    'Irql' : [ 0x24, ['unsigned char']],
    'IRR' : [ 0x28, ['unsigned long']],
    'IrrActive' : [ 0x2c, ['unsigned long']],
    'IDR' : [ 0x30, ['unsigned long']],
    'KdVersionBlock' : [ 0x34, ['pointer', ['void']]],
    'IDT' : [ 0x38, ['pointer', ['_KIDTENTRY']]],
    'GDT' : [ 0x3c, ['pointer', ['_KGDTENTRY']]],
    'TSS' : [ 0x40, ['pointer', ['_KTSS']]],
    'MajorVersion' : [ 0x44, ['unsigned short']],
    'MinorVersion' : [ 0x46, ['unsigned short']],
    'SetMember' : [ 0x48, ['unsigned long']],
    'StallScaleFactor' : [ 0x4c, ['unsigned long']],
    'SpareUnused' : [ 0x50, ['unsigned char']],
    'Number' : [ 0x51, ['unsigned char']],
    'Spare0' : [ 0x52, ['unsigned char']],
    'SecondLevelCacheAssociativity' : [ 0x53, ['unsigned char']],
    'VdmAlert' : [ 0x54, ['unsigned long']],
    'KernelReserved' : [ 0x58, ['array', 14, ['unsigned long']]],
    'SecondLevelCacheSize' : [ 0x90, ['unsigned long']],
    'HalReserved' : [ 0x94, ['array', 16, ['unsigned long']]],
    'InterruptMode' : [ 0xd4, ['unsigned long']],
    'Spare1' : [ 0xd8, ['unsigned char']],
    'KernelReserved2' : [ 0xdc, ['array', 17, ['unsigned long']]],
    'PrcbData' : [ 0x120, ['_KPRCB']],
} ],
  '_KAPC' : [ 0x30, {
    'Type' : [ 0x0, ['unsigned char']],
    'SpareByte0' : [ 0x1, ['unsigned char']],
    'Size' : [ 0x2, ['unsigned char']],
    'SpareByte1' : [ 0x3, ['unsigned char']],
    'SpareLong0' : [ 0x4, ['unsigned long']],
    'Thread' : [ 0x8, ['pointer', ['_KTHREAD']]],
    'ApcListEntry' : [ 0xc, ['_LIST_ENTRY']],
    'KernelRoutine' : [ 0x14, ['pointer', ['void']]],
    'RundownRoutine' : [ 0x18, ['pointer', ['void']]],
    'NormalRoutine' : [ 0x1c, ['pointer', ['void']]],
    'NormalContext' : [ 0x20, ['pointer', ['void']]],
    'SystemArgument1' : [ 0x24, ['pointer', ['void']]],
    'SystemArgument2' : [ 0x28, ['pointer', ['void']]],
    'ApcStateIndex' : [ 0x2c, ['unsigned char']],
    'ApcMode' : [ 0x2d, ['unsigned char']],
    'Inserted' : [ 0x2e, ['unsigned char']],
} ],
  '_KTHREAD' : [ 0x1e0, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'CycleTime' : [ 0x10, ['unsigned long long']],
    'HighCycleTime' : [ 0x18, ['unsigned long']],
    'QuantumTarget' : [ 0x20, ['unsigned long long']],
    'InitialStack' : [ 0x28, ['pointer', ['void']]],
    'StackLimit' : [ 0x2c, ['pointer', ['void']]],
    'KernelStack' : [ 0x30, ['pointer', ['void']]],
    'ThreadLock' : [ 0x34, ['unsigned long']],
    'ApcState' : [ 0x38, ['_KAPC_STATE']],
    'ApcStateFill' : [ 0x38, ['array', 23, ['unsigned char']]],
    'Priority' : [ 0x4f, ['unsigned char']],
    'NextProcessor' : [ 0x50, ['unsigned short']],
    'DeferredProcessor' : [ 0x52, ['unsigned short']],
    'ApcQueueLock' : [ 0x54, ['unsigned long']],
    'ContextSwitches' : [ 0x58, ['unsigned long']],
    'State' : [ 0x5c, ['unsigned char']],
    'NpxState' : [ 0x5d, ['unsigned char']],
    'WaitIrql' : [ 0x5e, ['unsigned char']],
    'WaitMode' : [ 0x5f, ['unsigned char']],
    'WaitStatus' : [ 0x60, ['long']],
    'WaitBlockList' : [ 0x64, ['pointer', ['_KWAIT_BLOCK']]],
    'GateObject' : [ 0x64, ['pointer', ['_KGATE']]],
    'KernelStackResident' : [ 0x68, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ReadyTransition' : [ 0x68, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ProcessReadyQueue' : [ 0x68, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'WaitNext' : [ 0x68, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'SystemAffinityActive' : [ 0x68, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'Alertable' : [ 0x68, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'GdiFlushActive' : [ 0x68, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'UserStackWalkActive' : [ 0x68, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'Reserved' : [ 0x68, ['BitField', dict(start_bit = 8, end_bit = 32, native_type='unsigned long')]],
    'MiscFlags' : [ 0x68, ['long']],
    'WaitReason' : [ 0x6c, ['unsigned char']],
    'SwapBusy' : [ 0x6d, ['unsigned char']],
    'Alerted' : [ 0x6e, ['array', 2, ['unsigned char']]],
    'WaitListEntry' : [ 0x70, ['_LIST_ENTRY']],
    'SwapListEntry' : [ 0x70, ['_SINGLE_LIST_ENTRY']],
    'Queue' : [ 0x78, ['pointer', ['_KQUEUE']]],
    'WaitTime' : [ 0x7c, ['unsigned long']],
    'KernelApcDisable' : [ 0x80, ['short']],
    'SpecialApcDisable' : [ 0x82, ['short']],
    'CombinedApcDisable' : [ 0x80, ['unsigned long']],
    'Teb' : [ 0x84, ['pointer', ['void']]],
    'Timer' : [ 0x88, ['_KTIMER']],
    'TimerFill' : [ 0x88, ['array', 40, ['unsigned char']]],
    'AutoAlignment' : [ 0xb0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'DisableBoost' : [ 0xb0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'EtwStackTraceApc1Inserted' : [ 0xb0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'EtwStackTraceApc2Inserted' : [ 0xb0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'CycleChargePending' : [ 0xb0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'CalloutActive' : [ 0xb0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'ApcQueueable' : [ 0xb0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'EnableStackSwap' : [ 0xb0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'GuiThread' : [ 0xb0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'ReservedFlags' : [ 0xb0, ['BitField', dict(start_bit = 9, end_bit = 32, native_type='unsigned long')]],
    'ThreadFlags' : [ 0xb0, ['long']],
    'WaitBlock' : [ 0xb8, ['array', 4, ['_KWAIT_BLOCK']]],
    'WaitBlockFill0' : [ 0xb8, ['array', 23, ['unsigned char']]],
    'IdealProcessor' : [ 0xcf, ['unsigned char']],
    'WaitBlockFill1' : [ 0xb8, ['array', 47, ['unsigned char']]],
    'PreviousMode' : [ 0xe7, ['unsigned char']],
    'WaitBlockFill2' : [ 0xb8, ['array', 71, ['unsigned char']]],
    'ResourceIndex' : [ 0xff, ['unsigned char']],
    'WaitBlockFill3' : [ 0xb8, ['array', 95, ['unsigned char']]],
    'LargeStack' : [ 0x117, ['unsigned char']],
    'QueueListEntry' : [ 0x118, ['_LIST_ENTRY']],
    'TrapFrame' : [ 0x120, ['pointer', ['_KTRAP_FRAME']]],
    'FirstArgument' : [ 0x124, ['pointer', ['void']]],
    'CallbackStack' : [ 0x128, ['pointer', ['void']]],
    'CallbackDepth' : [ 0x128, ['unsigned long']],
    'ServiceTable' : [ 0x12c, ['pointer', ['void']]],
    'ApcStateIndex' : [ 0x130, ['unsigned char']],
    'BasePriority' : [ 0x131, ['unsigned char']],
    'PriorityDecrement' : [ 0x132, ['unsigned char']],
    'Preempted' : [ 0x133, ['unsigned char']],
    'AdjustReason' : [ 0x134, ['unsigned char']],
    'AdjustIncrement' : [ 0x135, ['unsigned char']],
    'Spare01' : [ 0x136, ['unsigned char']],
    'Saturation' : [ 0x137, ['unsigned char']],
    'SystemCallNumber' : [ 0x138, ['unsigned long']],
    'FreezeCount' : [ 0x13c, ['unsigned long']],
    'UserAffinity' : [ 0x140, ['unsigned long']],
    'Process' : [ 0x144, ['pointer', ['_KPROCESS']]],
    'Affinity' : [ 0x148, ['unsigned long']],
    'ApcStatePointer' : [ 0x14c, ['array', 2, ['pointer', ['_KAPC_STATE']]]],
    'SavedApcState' : [ 0x154, ['_KAPC_STATE']],
    'SavedApcStateFill' : [ 0x154, ['array', 23, ['unsigned char']]],
    'Spare02' : [ 0x16b, ['unsigned char']],
    'SuspendCount' : [ 0x16c, ['unsigned char']],
    'UserIdealProcessor' : [ 0x16d, ['unsigned char']],
    'Spare03' : [ 0x16e, ['unsigned char']],
    'OtherPlatformFill' : [ 0x16f, ['unsigned char']],
    'Win32Thread' : [ 0x170, ['pointer', ['void']]],
    'StackBase' : [ 0x174, ['pointer', ['void']]],
    'SuspendApc' : [ 0x178, ['_KAPC']],
    'SuspendApcFill0' : [ 0x178, ['array', 1, ['unsigned char']]],
    'Spare04' : [ 0x179, ['unsigned char']],
    'SuspendApcFill1' : [ 0x178, ['array', 3, ['unsigned char']]],
    'QuantumReset' : [ 0x17b, ['unsigned char']],
    'SuspendApcFill2' : [ 0x178, ['array', 4, ['unsigned char']]],
    'KernelTime' : [ 0x17c, ['unsigned long']],
    'SuspendApcFill3' : [ 0x178, ['array', 36, ['unsigned char']]],
    'WaitPrcb' : [ 0x19c, ['pointer', ['_KPRCB']]],
    'SuspendApcFill4' : [ 0x178, ['array', 40, ['unsigned char']]],
    'LegoData' : [ 0x1a0, ['pointer', ['void']]],
    'SuspendApcFill5' : [ 0x178, ['array', 47, ['unsigned char']]],
    'PowerState' : [ 0x1a7, ['unsigned char']],
    'UserTime' : [ 0x1a8, ['unsigned long']],
    'SuspendSemaphore' : [ 0x1ac, ['_KSEMAPHORE']],
    'SuspendSemaphorefill' : [ 0x1ac, ['array', 20, ['unsigned char']]],
    'SListFaultCount' : [ 0x1c0, ['unsigned long']],
    'ThreadListEntry' : [ 0x1c4, ['_LIST_ENTRY']],
    'MutantListHead' : [ 0x1cc, ['_LIST_ENTRY']],
    'SListFaultAddress' : [ 0x1d4, ['pointer', ['void']]],
    'MdlForLockedTeb' : [ 0x1d8, ['pointer', ['void']]],
} ],
  '_FAST_MUTEX' : [ 0x20, {
    'Count' : [ 0x0, ['long']],
    'Owner' : [ 0x4, ['pointer', ['_KTHREAD']]],
    'Contention' : [ 0x8, ['unsigned long']],
    'Gate' : [ 0xc, ['_KEVENT']],
    'OldIrql' : [ 0x1c, ['unsigned long']],
} ],
  '_SLIST_HEADER' : [ 0x8, {
    'Alignment' : [ 0x0, ['unsigned long long']],
    'Next' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Depth' : [ 0x4, ['unsigned short']],
    'Sequence' : [ 0x6, ['unsigned short']],
} ],
  '_LOOKASIDE_LIST_EX' : [ 0x48, {
    'L' : [ 0x0, ['_GENERAL_LOOKASIDE_POOL']],
} ],
  '_NPAGED_LOOKASIDE_LIST' : [ 0xc0, {
    'L' : [ 0x0, ['_GENERAL_LOOKASIDE']],
    'Lock__ObsoleteButDoNotDelete' : [ 0x80, ['unsigned long']],
} ],
  '_PAGED_LOOKASIDE_LIST' : [ 0xc0, {
    'L' : [ 0x0, ['_GENERAL_LOOKASIDE']],
    'Lock__ObsoleteButDoNotDelete' : [ 0x80, ['_FAST_MUTEX']],
} ],
  '_QUAD' : [ 0x8, {
    'UseThisFieldToCopy' : [ 0x0, ['long long']],
    'DoNotUseThisField' : [ 0x0, ['double']],
} ],
  '_IO_STATUS_BLOCK' : [ 0x8, {
    'Status' : [ 0x0, ['long']],
    'Pointer' : [ 0x0, ['pointer', ['void']]],
    'Information' : [ 0x4, ['unsigned long']],
} ],
  '_EX_PUSH_LOCK' : [ 0x4, {
    'Locked' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Waiting' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Waking' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'MultipleShared' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'Shared' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 32, native_type='unsigned long')]],
    'Value' : [ 0x0, ['unsigned long']],
    'Ptr' : [ 0x0, ['pointer', ['void']]],
} ],
  '_EX_PUSH_LOCK_CACHE_AWARE' : [ 0x80, {
    'Locks' : [ 0x0, ['array', 32, ['pointer', ['_EX_PUSH_LOCK']]]],
} ],
  '_GENERAL_LOOKASIDE' : [ 0x80, {
    'ListHead' : [ 0x0, ['_SLIST_HEADER']],
    'SingleListHead' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Depth' : [ 0x8, ['unsigned short']],
    'MaximumDepth' : [ 0xa, ['unsigned short']],
    'TotalAllocates' : [ 0xc, ['unsigned long']],
    'AllocateMisses' : [ 0x10, ['unsigned long']],
    'AllocateHits' : [ 0x10, ['unsigned long']],
    'TotalFrees' : [ 0x14, ['unsigned long']],
    'FreeMisses' : [ 0x18, ['unsigned long']],
    'FreeHits' : [ 0x18, ['unsigned long']],
    'Type' : [ 0x1c, ['Enumeration', dict(target = 'long', choices = {0: 'NonPagedPool', 1: 'PagedPool', 2: 'NonPagedPoolMustSucceed', 3: 'DontUseThisType', 4: 'NonPagedPoolCacheAligned', 5: 'PagedPoolCacheAligned', 6: 'NonPagedPoolCacheAlignedMustS', 7: 'MaxPoolType', 34: 'NonPagedPoolMustSucceedSession', 35: 'DontUseThisTypeSession', 32: 'NonPagedPoolSession', 36: 'NonPagedPoolCacheAlignedSession', 33: 'PagedPoolSession', 38: 'NonPagedPoolCacheAlignedMustSSession', 37: 'PagedPoolCacheAlignedSession'})]],
    'Tag' : [ 0x20, ['unsigned long']],
    'Size' : [ 0x24, ['unsigned long']],
    'AllocateEx' : [ 0x28, ['pointer', ['void']]],
    'Allocate' : [ 0x28, ['pointer', ['void']]],
    'FreeEx' : [ 0x2c, ['pointer', ['void']]],
    'Free' : [ 0x2c, ['pointer', ['void']]],
    'ListEntry' : [ 0x30, ['_LIST_ENTRY']],
    'LastTotalAllocates' : [ 0x38, ['unsigned long']],
    'LastAllocateMisses' : [ 0x3c, ['unsigned long']],
    'LastAllocateHits' : [ 0x3c, ['unsigned long']],
    'Future' : [ 0x40, ['array', 2, ['unsigned long']]],
} ],
  '_EX_FAST_REF' : [ 0x4, {
    'Object' : [ 0x0, ['pointer', ['void']]],
    'RefCnt' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned long')]],
    'Value' : [ 0x0, ['unsigned long']],
} ],
  '_EX_PUSH_LOCK_WAIT_BLOCK' : [ 0x30, {
    'WakeGate' : [ 0x0, ['_KGATE']],
    'WakeEvent' : [ 0x0, ['_KEVENT']],
    'Next' : [ 0x10, ['pointer', ['_EX_PUSH_LOCK_WAIT_BLOCK']]],
    'Last' : [ 0x14, ['pointer', ['_EX_PUSH_LOCK_WAIT_BLOCK']]],
    'Previous' : [ 0x18, ['pointer', ['_EX_PUSH_LOCK_WAIT_BLOCK']]],
    'ShareCount' : [ 0x1c, ['long']],
    'Flags' : [ 0x20, ['long']],
} ],
  '_ETHREAD' : [ 0x288, {
    'Tcb' : [ 0x0, ['_KTHREAD']],
    'CreateTime' : [ 0x1e0, ['_LARGE_INTEGER']],
    'ExitTime' : [ 0x1e8, ['_LARGE_INTEGER']],
    'KeyedWaitChain' : [ 0x1e8, ['_LIST_ENTRY']],
    'ExitStatus' : [ 0x1f0, ['long']],
    'OfsChain' : [ 0x1f0, ['pointer', ['void']]],
    'PostBlockList' : [ 0x1f4, ['_LIST_ENTRY']],
    'ForwardLinkShadow' : [ 0x1f4, ['pointer', ['void']]],
    'StartAddress' : [ 0x1f8, ['pointer', ['void']]],
    'TerminationPort' : [ 0x1fc, ['pointer', ['_TERMINATION_PORT']]],
    'ReaperLink' : [ 0x1fc, ['pointer', ['_ETHREAD']]],
    'KeyedWaitValue' : [ 0x1fc, ['pointer', ['void']]],
    'Win32StartParameter' : [ 0x1fc, ['pointer', ['void']]],
    'ActiveTimerListLock' : [ 0x200, ['unsigned long']],
    'ActiveTimerListHead' : [ 0x204, ['_LIST_ENTRY']],
    'Cid' : [ 0x20c, ['_CLIENT_ID']],
    'KeyedWaitSemaphore' : [ 0x214, ['_KSEMAPHORE']],
    'AlpcWaitSemaphore' : [ 0x214, ['_KSEMAPHORE']],
    'ClientSecurity' : [ 0x228, ['_PS_CLIENT_SECURITY_CONTEXT']],
    'IrpList' : [ 0x22c, ['_LIST_ENTRY']],
    'TopLevelIrp' : [ 0x234, ['unsigned long']],
    'DeviceToVerify' : [ 0x238, ['pointer', ['_DEVICE_OBJECT']]],
    'RateControlApc' : [ 0x23c, ['pointer', ['_PSP_RATE_APC']]],
    'Win32StartAddress' : [ 0x240, ['pointer', ['void']]],
    'SparePtr0' : [ 0x244, ['pointer', ['void']]],
    'ThreadListEntry' : [ 0x248, ['_LIST_ENTRY']],
    'RundownProtect' : [ 0x250, ['_EX_RUNDOWN_REF']],
    'ThreadLock' : [ 0x254, ['_EX_PUSH_LOCK']],
    'ReadClusterSize' : [ 0x258, ['unsigned long']],
    'MmLockOrdering' : [ 0x25c, ['long']],
    'CrossThreadFlags' : [ 0x260, ['unsigned long']],
    'Terminated' : [ 0x260, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ThreadInserted' : [ 0x260, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'HideFromDebugger' : [ 0x260, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'ActiveImpersonationInfo' : [ 0x260, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'SystemThread' : [ 0x260, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'HardErrorsAreDisabled' : [ 0x260, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'BreakOnTermination' : [ 0x260, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'SkipCreationMsg' : [ 0x260, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'SkipTerminationMsg' : [ 0x260, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'CopyTokenOnOpen' : [ 0x260, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'ThreadIoPriority' : [ 0x260, ['BitField', dict(start_bit = 10, end_bit = 13, native_type='unsigned long')]],
    'ThreadPagePriority' : [ 0x260, ['BitField', dict(start_bit = 13, end_bit = 16, native_type='unsigned long')]],
    'RundownFail' : [ 0x260, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'SameThreadPassiveFlags' : [ 0x264, ['unsigned long']],
    'ActiveExWorker' : [ 0x264, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ExWorkerCanWaitUser' : [ 0x264, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'MemoryMaker' : [ 0x264, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'ClonedThread' : [ 0x264, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'KeyedEventInUse' : [ 0x264, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'RateApcState' : [ 0x264, ['BitField', dict(start_bit = 5, end_bit = 7, native_type='unsigned long')]],
    'SelfTerminate' : [ 0x264, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'SameThreadApcFlags' : [ 0x268, ['unsigned long']],
    'Spare' : [ 0x268, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'StartAddressInvalid' : [ 0x268, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'EtwPageFaultCalloutActive' : [ 0x268, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'OwnsProcessWorkingSetExclusive' : [ 0x268, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'OwnsProcessWorkingSetShared' : [ 0x268, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'OwnsSystemWorkingSetExclusive' : [ 0x268, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'OwnsSystemWorkingSetShared' : [ 0x268, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'OwnsSessionWorkingSetExclusive' : [ 0x268, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'OwnsSessionWorkingSetShared' : [ 0x269, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'OwnsProcessAddressSpaceExclusive' : [ 0x269, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'OwnsProcessAddressSpaceShared' : [ 0x269, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'SuppressSymbolLoad' : [ 0x269, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'Prefetching' : [ 0x269, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'OwnsDynamicMemoryShared' : [ 0x269, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'OwnsChangeControlAreaExclusive' : [ 0x269, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'OwnsChangeControlAreaShared' : [ 0x269, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'Spare1' : [ 0x26a, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned char')]],
    'PriorityRegionActive' : [ 0x26b, ['unsigned char']],
    'CacheManagerActive' : [ 0x26c, ['unsigned char']],
    'DisablePageFaultClustering' : [ 0x26d, ['unsigned char']],
    'ActiveFaultCount' : [ 0x26e, ['unsigned char']],
    'AlpcMessageId' : [ 0x270, ['unsigned long']],
    'AlpcMessage' : [ 0x274, ['pointer', ['void']]],
    'AlpcReceiveAttributeSet' : [ 0x274, ['unsigned long']],
    'AlpcWaitListEntry' : [ 0x278, ['_LIST_ENTRY']],
    'CacheManagerCount' : [ 0x280, ['unsigned long']],
} ],
  '_EPROCESS' : [ 0x270, {
    'Pcb' : [ 0x0, ['_KPROCESS']],
    'ProcessLock' : [ 0x80, ['_EX_PUSH_LOCK']],
    'CreateTime' : [ 0x88, ['_LARGE_INTEGER']],
    'ExitTime' : [ 0x90, ['_LARGE_INTEGER']],
    'RundownProtect' : [ 0x98, ['_EX_RUNDOWN_REF']],
    'UniqueProcessId' : [ 0x9c, ['pointer', ['void']]],
    'ActiveProcessLinks' : [ 0xa0, ['_LIST_ENTRY']],
    'QuotaUsage' : [ 0xa8, ['array', 3, ['unsigned long']]],
    'QuotaPeak' : [ 0xb4, ['array', 3, ['unsigned long']]],
    'CommitCharge' : [ 0xc0, ['unsigned long']],
    'PeakVirtualSize' : [ 0xc4, ['unsigned long']],
    'VirtualSize' : [ 0xc8, ['unsigned long']],
    'SessionProcessLinks' : [ 0xcc, ['_LIST_ENTRY']],
    'DebugPort' : [ 0xd4, ['pointer', ['void']]],
    'ExceptionPortData' : [ 0xd8, ['pointer', ['void']]],
    'ExceptionPortValue' : [ 0xd8, ['unsigned long']],
    'ExceptionPortState' : [ 0xd8, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned long')]],
    'ObjectTable' : [ 0xdc, ['pointer', ['_HANDLE_TABLE']]],
    'Token' : [ 0xe0, ['_EX_FAST_REF']],
    'WorkingSetPage' : [ 0xe4, ['unsigned long']],
    'AddressCreationLock' : [ 0xe8, ['_EX_PUSH_LOCK']],
    'RotateInProgress' : [ 0xec, ['pointer', ['_ETHREAD']]],
    'ForkInProgress' : [ 0xf0, ['pointer', ['_ETHREAD']]],
    'HardwareTrigger' : [ 0xf4, ['unsigned long']],
    'PhysicalVadRoot' : [ 0xf8, ['pointer', ['_MM_AVL_TABLE']]],
    'CloneRoot' : [ 0xfc, ['pointer', ['void']]],
    'NumberOfPrivatePages' : [ 0x100, ['unsigned long']],
    'NumberOfLockedPages' : [ 0x104, ['unsigned long']],
    'Win32Process' : [ 0x108, ['pointer', ['void']]],
    'Job' : [ 0x10c, ['pointer', ['_EJOB']]],
    'SectionObject' : [ 0x110, ['pointer', ['void']]],
    'SectionBaseAddress' : [ 0x114, ['pointer', ['void']]],
    'QuotaBlock' : [ 0x118, ['pointer', ['_EPROCESS_QUOTA_BLOCK']]],
    'WorkingSetWatch' : [ 0x11c, ['pointer', ['_PAGEFAULT_HISTORY']]],
    'Win32WindowStation' : [ 0x120, ['pointer', ['void']]],
    'InheritedFromUniqueProcessId' : [ 0x124, ['pointer', ['void']]],
    'LdtInformation' : [ 0x128, ['pointer', ['void']]],
    'Spare' : [ 0x12c, ['pointer', ['void']]],
    'VdmObjects' : [ 0x130, ['pointer', ['void']]],
    'DeviceMap' : [ 0x134, ['pointer', ['void']]],
    'EtwDataSource' : [ 0x138, ['pointer', ['void']]],
    'FreeTebHint' : [ 0x13c, ['pointer', ['void']]],
    'PageDirectoryPte' : [ 0x140, ['_HARDWARE_PTE']],
    'Filler' : [ 0x140, ['unsigned long long']],
    'Session' : [ 0x148, ['pointer', ['void']]],
    'ImageFileName' : [ 0x14c, ['array', 16, ['unsigned char']]],
    'JobLinks' : [ 0x15c, ['_LIST_ENTRY']],
    'LockedPagesList' : [ 0x164, ['pointer', ['void']]],
    'ThreadListHead' : [ 0x168, ['_LIST_ENTRY']],
    'SecurityPort' : [ 0x170, ['pointer', ['void']]],
    'PaeTop' : [ 0x174, ['pointer', ['void']]],
    'ActiveThreads' : [ 0x178, ['unsigned long']],
    'ImagePathHash' : [ 0x17c, ['unsigned long']],
    'DefaultHardErrorProcessing' : [ 0x180, ['unsigned long']],
    'LastThreadExitStatus' : [ 0x184, ['long']],
    'Peb' : [ 0x188, ['pointer', ['_PEB']]],
    'PrefetchTrace' : [ 0x18c, ['_EX_FAST_REF']],
    'ReadOperationCount' : [ 0x190, ['_LARGE_INTEGER']],
    'WriteOperationCount' : [ 0x198, ['_LARGE_INTEGER']],
    'OtherOperationCount' : [ 0x1a0, ['_LARGE_INTEGER']],
    'ReadTransferCount' : [ 0x1a8, ['_LARGE_INTEGER']],
    'WriteTransferCount' : [ 0x1b0, ['_LARGE_INTEGER']],
    'OtherTransferCount' : [ 0x1b8, ['_LARGE_INTEGER']],
    'CommitChargeLimit' : [ 0x1c0, ['unsigned long']],
    'CommitChargePeak' : [ 0x1c4, ['unsigned long']],
    'AweInfo' : [ 0x1c8, ['pointer', ['void']]],
    'SeAuditProcessCreationInfo' : [ 0x1cc, ['_SE_AUDIT_PROCESS_CREATION_INFO']],
    'Vm' : [ 0x1d0, ['_MMSUPPORT']],
    'MmProcessLinks' : [ 0x218, ['_LIST_ENTRY']],
    'ModifiedPageCount' : [ 0x220, ['unsigned long']],
    'Flags2' : [ 0x224, ['unsigned long']],
    'JobNotReallyActive' : [ 0x224, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'AccountingFolded' : [ 0x224, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'NewProcessReported' : [ 0x224, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'ExitProcessReported' : [ 0x224, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'ReportCommitChanges' : [ 0x224, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'LastReportMemory' : [ 0x224, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'ReportPhysicalPageChanges' : [ 0x224, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'HandleTableRundown' : [ 0x224, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'NeedsHandleRundown' : [ 0x224, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'RefTraceEnabled' : [ 0x224, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'NumaAware' : [ 0x224, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'ProtectedProcess' : [ 0x224, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'DefaultPagePriority' : [ 0x224, ['BitField', dict(start_bit = 12, end_bit = 15, native_type='unsigned long')]],
    'PrimaryTokenFrozen' : [ 0x224, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'ProcessVerifierTarget' : [ 0x224, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'StackRandomizationDisabled' : [ 0x224, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'AffinityPermanent' : [ 0x224, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'AffinityUpdateEnable' : [ 0x224, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'CrossSessionCreate' : [ 0x224, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'Flags' : [ 0x228, ['unsigned long']],
    'CreateReported' : [ 0x228, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'NoDebugInherit' : [ 0x228, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ProcessExiting' : [ 0x228, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'ProcessDelete' : [ 0x228, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'Wow64SplitPages' : [ 0x228, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'VmDeleted' : [ 0x228, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'OutswapEnabled' : [ 0x228, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'Outswapped' : [ 0x228, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'ForkFailed' : [ 0x228, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'Wow64VaSpace4Gb' : [ 0x228, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'AddressSpaceInitialized' : [ 0x228, ['BitField', dict(start_bit = 10, end_bit = 12, native_type='unsigned long')]],
    'SetTimerResolution' : [ 0x228, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'BreakOnTermination' : [ 0x228, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'DeprioritizeViews' : [ 0x228, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'WriteWatch' : [ 0x228, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'ProcessInSession' : [ 0x228, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'OverrideAddressSpace' : [ 0x228, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'HasAddressSpace' : [ 0x228, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'LaunchPrefetched' : [ 0x228, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'InjectInpageErrors' : [ 0x228, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'VmTopDown' : [ 0x228, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'ImageNotifyDone' : [ 0x228, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long')]],
    'PdeUpdateNeeded' : [ 0x228, ['BitField', dict(start_bit = 23, end_bit = 24, native_type='unsigned long')]],
    'VdmAllowed' : [ 0x228, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long')]],
    'SmapAllowed' : [ 0x228, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'ProcessInserted' : [ 0x228, ['BitField', dict(start_bit = 26, end_bit = 27, native_type='unsigned long')]],
    'DefaultIoPriority' : [ 0x228, ['BitField', dict(start_bit = 27, end_bit = 30, native_type='unsigned long')]],
    'ProcessSelfDelete' : [ 0x228, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'SpareProcessFlags' : [ 0x228, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'ExitStatus' : [ 0x22c, ['long']],
    'Spare7' : [ 0x230, ['unsigned short']],
    'SubSystemMinorVersion' : [ 0x232, ['unsigned char']],
    'SubSystemMajorVersion' : [ 0x233, ['unsigned char']],
    'SubSystemVersion' : [ 0x232, ['unsigned short']],
    'PriorityClass' : [ 0x234, ['unsigned char']],
    'VadRoot' : [ 0x238, ['_MM_AVL_TABLE']],
    'Cookie' : [ 0x258, ['unsigned long']],
    'AlpcContext' : [ 0x25c, ['_ALPC_PROCESS_CONTEXT']],
} ],
  '__unnamed_11d8' : [ 0x2c, {
    'InitialPrivilegeSet' : [ 0x0, ['_INITIAL_PRIVILEGE_SET']],
    'PrivilegeSet' : [ 0x0, ['_PRIVILEGE_SET']],
} ],
  '_ACCESS_STATE' : [ 0x74, {
    'OperationID' : [ 0x0, ['_LUID']],
    'SecurityEvaluated' : [ 0x8, ['unsigned char']],
    'GenerateAudit' : [ 0x9, ['unsigned char']],
    'GenerateOnClose' : [ 0xa, ['unsigned char']],
    'PrivilegesAllocated' : [ 0xb, ['unsigned char']],
    'Flags' : [ 0xc, ['unsigned long']],
    'RemainingDesiredAccess' : [ 0x10, ['unsigned long']],
    'PreviouslyGrantedAccess' : [ 0x14, ['unsigned long']],
    'OriginalDesiredAccess' : [ 0x18, ['unsigned long']],
    'SubjectSecurityContext' : [ 0x1c, ['_SECURITY_SUBJECT_CONTEXT']],
    'SecurityDescriptor' : [ 0x2c, ['pointer', ['void']]],
    'AuxData' : [ 0x30, ['pointer', ['void']]],
    'Privileges' : [ 0x34, ['__unnamed_11d8']],
    'AuditPrivileges' : [ 0x60, ['unsigned char']],
    'ObjectName' : [ 0x64, ['_UNICODE_STRING']],
    'ObjectTypeName' : [ 0x6c, ['_UNICODE_STRING']],
} ],
  '__unnamed_11e6' : [ 0x4, {
    'MasterIrp' : [ 0x0, ['pointer', ['_IRP']]],
    'IrpCount' : [ 0x0, ['long']],
    'SystemBuffer' : [ 0x0, ['pointer', ['void']]],
} ],
  '__unnamed_11eb' : [ 0x8, {
    'UserApcRoutine' : [ 0x0, ['pointer', ['void']]],
    'IssuingProcess' : [ 0x0, ['pointer', ['void']]],
    'UserApcContext' : [ 0x4, ['pointer', ['void']]],
} ],
  '__unnamed_11ed' : [ 0x8, {
    'AsynchronousParameters' : [ 0x0, ['__unnamed_11eb']],
    'AllocationSize' : [ 0x0, ['_LARGE_INTEGER']],
} ],
  '__unnamed_11f8' : [ 0x28, {
    'DeviceQueueEntry' : [ 0x0, ['_KDEVICE_QUEUE_ENTRY']],
    'DriverContext' : [ 0x0, ['array', 4, ['pointer', ['void']]]],
    'Thread' : [ 0x10, ['pointer', ['_ETHREAD']]],
    'AuxiliaryBuffer' : [ 0x14, ['pointer', ['unsigned char']]],
    'ListEntry' : [ 0x18, ['_LIST_ENTRY']],
    'CurrentStackLocation' : [ 0x20, ['pointer', ['_IO_STACK_LOCATION']]],
    'PacketType' : [ 0x20, ['unsigned long']],
    'OriginalFileObject' : [ 0x24, ['pointer', ['_FILE_OBJECT']]],
} ],
  '__unnamed_11fa' : [ 0x30, {
    'Overlay' : [ 0x0, ['__unnamed_11f8']],
    'Apc' : [ 0x0, ['_KAPC']],
    'CompletionKey' : [ 0x0, ['pointer', ['void']]],
} ],
  '_IRP' : [ 0x70, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['unsigned short']],
    'MdlAddress' : [ 0x4, ['pointer', ['_MDL']]],
    'Flags' : [ 0x8, ['unsigned long']],
    'AssociatedIrp' : [ 0xc, ['__unnamed_11e6']],
    'ThreadListEntry' : [ 0x10, ['_LIST_ENTRY']],
    'IoStatus' : [ 0x18, ['_IO_STATUS_BLOCK']],
    'RequestorMode' : [ 0x20, ['unsigned char']],
    'PendingReturned' : [ 0x21, ['unsigned char']],
    'StackCount' : [ 0x22, ['unsigned char']],
    'CurrentLocation' : [ 0x23, ['unsigned char']],
    'Cancel' : [ 0x24, ['unsigned char']],
    'CancelIrql' : [ 0x25, ['unsigned char']],
    'ApcEnvironment' : [ 0x26, ['unsigned char']],
    'AllocationFlags' : [ 0x27, ['unsigned char']],
    'UserIosb' : [ 0x28, ['pointer', ['_IO_STATUS_BLOCK']]],
    'UserEvent' : [ 0x2c, ['pointer', ['_KEVENT']]],
    'Overlay' : [ 0x30, ['__unnamed_11ed']],
    'CancelRoutine' : [ 0x38, ['pointer', ['void']]],
    'UserBuffer' : [ 0x3c, ['pointer', ['void']]],
    'Tail' : [ 0x40, ['__unnamed_11fa']],
} ],
  '__unnamed_1200' : [ 0x10, {
    'SecurityContext' : [ 0x0, ['pointer', ['_IO_SECURITY_CONTEXT']]],
    'Options' : [ 0x4, ['unsigned long']],
    'FileAttributes' : [ 0x8, ['unsigned short']],
    'ShareAccess' : [ 0xa, ['unsigned short']],
    'EaLength' : [ 0xc, ['unsigned long']],
} ],
  '__unnamed_1204' : [ 0x10, {
    'SecurityContext' : [ 0x0, ['pointer', ['_IO_SECURITY_CONTEXT']]],
    'Options' : [ 0x4, ['unsigned long']],
    'Reserved' : [ 0x8, ['unsigned short']],
    'ShareAccess' : [ 0xa, ['unsigned short']],
    'Parameters' : [ 0xc, ['pointer', ['_NAMED_PIPE_CREATE_PARAMETERS']]],
} ],
  '__unnamed_1208' : [ 0x10, {
    'SecurityContext' : [ 0x0, ['pointer', ['_IO_SECURITY_CONTEXT']]],
    'Options' : [ 0x4, ['unsigned long']],
    'Reserved' : [ 0x8, ['unsigned short']],
    'ShareAccess' : [ 0xa, ['unsigned short']],
    'Parameters' : [ 0xc, ['pointer', ['_MAILSLOT_CREATE_PARAMETERS']]],
} ],
  '__unnamed_120a' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned long']],
    'Key' : [ 0x4, ['unsigned long']],
    'ByteOffset' : [ 0x8, ['_LARGE_INTEGER']],
} ],
  '__unnamed_120e' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned long']],
    'FileName' : [ 0x4, ['pointer', ['_UNICODE_STRING']]],
    'FileInformationClass' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {1: 'FileDirectoryInformation', 2: 'FileFullDirectoryInformation', 3: 'FileBothDirectoryInformation', 4: 'FileBasicInformation', 5: 'FileStandardInformation', 6: 'FileInternalInformation', 7: 'FileEaInformation', 8: 'FileAccessInformation', 9: 'FileNameInformation', 10: 'FileRenameInformation', 11: 'FileLinkInformation', 12: 'FileNamesInformation', 13: 'FileDispositionInformation', 14: 'FilePositionInformation', 15: 'FileFullEaInformation', 16: 'FileModeInformation', 17: 'FileAlignmentInformation', 18: 'FileAllInformation', 19: 'FileAllocationInformation', 20: 'FileEndOfFileInformation', 21: 'FileAlternateNameInformation', 22: 'FileStreamInformation', 23: 'FilePipeInformation', 24: 'FilePipeLocalInformation', 25: 'FilePipeRemoteInformation', 26: 'FileMailslotQueryInformation', 27: 'FileMailslotSetInformation', 28: 'FileCompressionInformation', 29: 'FileObjectIdInformation', 30: 'FileCompletionInformation', 31: 'FileMoveClusterInformation', 32: 'FileQuotaInformation', 33: 'FileReparsePointInformation', 34: 'FileNetworkOpenInformation', 35: 'FileAttributeTagInformation', 36: 'FileTrackingInformation', 37: 'FileIdBothDirectoryInformation', 38: 'FileIdFullDirectoryInformation', 39: 'FileValidDataLengthInformation', 40: 'FileShortNameInformation', 41: 'FileIoCompletionNotificationInformation', 42: 'FileIoStatusBlockRangeInformation', 43: 'FileIoPriorityHintInformation', 44: 'FileSfioReserveInformation', 45: 'FileSfioVolumeInformation', 46: 'FileHardLinkInformation', 47: 'FileProcessIdsUsingFileInformation', 48: 'FileNormalizedNameInformation', 49: 'FileNetworkPhysicalNameInformation', 50: 'FileIdGlobalTxDirectoryInformation', 51: 'FileMaximumInformation'})]],
    'FileIndex' : [ 0xc, ['unsigned long']],
} ],
  '__unnamed_1210' : [ 0x8, {
    'Length' : [ 0x0, ['unsigned long']],
    'CompletionFilter' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_1212' : [ 0x8, {
    'Length' : [ 0x0, ['unsigned long']],
    'FileInformationClass' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {1: 'FileDirectoryInformation', 2: 'FileFullDirectoryInformation', 3: 'FileBothDirectoryInformation', 4: 'FileBasicInformation', 5: 'FileStandardInformation', 6: 'FileInternalInformation', 7: 'FileEaInformation', 8: 'FileAccessInformation', 9: 'FileNameInformation', 10: 'FileRenameInformation', 11: 'FileLinkInformation', 12: 'FileNamesInformation', 13: 'FileDispositionInformation', 14: 'FilePositionInformation', 15: 'FileFullEaInformation', 16: 'FileModeInformation', 17: 'FileAlignmentInformation', 18: 'FileAllInformation', 19: 'FileAllocationInformation', 20: 'FileEndOfFileInformation', 21: 'FileAlternateNameInformation', 22: 'FileStreamInformation', 23: 'FilePipeInformation', 24: 'FilePipeLocalInformation', 25: 'FilePipeRemoteInformation', 26: 'FileMailslotQueryInformation', 27: 'FileMailslotSetInformation', 28: 'FileCompressionInformation', 29: 'FileObjectIdInformation', 30: 'FileCompletionInformation', 31: 'FileMoveClusterInformation', 32: 'FileQuotaInformation', 33: 'FileReparsePointInformation', 34: 'FileNetworkOpenInformation', 35: 'FileAttributeTagInformation', 36: 'FileTrackingInformation', 37: 'FileIdBothDirectoryInformation', 38: 'FileIdFullDirectoryInformation', 39: 'FileValidDataLengthInformation', 40: 'FileShortNameInformation', 41: 'FileIoCompletionNotificationInformation', 42: 'FileIoStatusBlockRangeInformation', 43: 'FileIoPriorityHintInformation', 44: 'FileSfioReserveInformation', 45: 'FileSfioVolumeInformation', 46: 'FileHardLinkInformation', 47: 'FileProcessIdsUsingFileInformation', 48: 'FileNormalizedNameInformation', 49: 'FileNetworkPhysicalNameInformation', 50: 'FileIdGlobalTxDirectoryInformation', 51: 'FileMaximumInformation'})]],
} ],
  '__unnamed_1214' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned long']],
    'FileInformationClass' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {1: 'FileDirectoryInformation', 2: 'FileFullDirectoryInformation', 3: 'FileBothDirectoryInformation', 4: 'FileBasicInformation', 5: 'FileStandardInformation', 6: 'FileInternalInformation', 7: 'FileEaInformation', 8: 'FileAccessInformation', 9: 'FileNameInformation', 10: 'FileRenameInformation', 11: 'FileLinkInformation', 12: 'FileNamesInformation', 13: 'FileDispositionInformation', 14: 'FilePositionInformation', 15: 'FileFullEaInformation', 16: 'FileModeInformation', 17: 'FileAlignmentInformation', 18: 'FileAllInformation', 19: 'FileAllocationInformation', 20: 'FileEndOfFileInformation', 21: 'FileAlternateNameInformation', 22: 'FileStreamInformation', 23: 'FilePipeInformation', 24: 'FilePipeLocalInformation', 25: 'FilePipeRemoteInformation', 26: 'FileMailslotQueryInformation', 27: 'FileMailslotSetInformation', 28: 'FileCompressionInformation', 29: 'FileObjectIdInformation', 30: 'FileCompletionInformation', 31: 'FileMoveClusterInformation', 32: 'FileQuotaInformation', 33: 'FileReparsePointInformation', 34: 'FileNetworkOpenInformation', 35: 'FileAttributeTagInformation', 36: 'FileTrackingInformation', 37: 'FileIdBothDirectoryInformation', 38: 'FileIdFullDirectoryInformation', 39: 'FileValidDataLengthInformation', 40: 'FileShortNameInformation', 41: 'FileIoCompletionNotificationInformation', 42: 'FileIoStatusBlockRangeInformation', 43: 'FileIoPriorityHintInformation', 44: 'FileSfioReserveInformation', 45: 'FileSfioVolumeInformation', 46: 'FileHardLinkInformation', 47: 'FileProcessIdsUsingFileInformation', 48: 'FileNormalizedNameInformation', 49: 'FileNetworkPhysicalNameInformation', 50: 'FileIdGlobalTxDirectoryInformation', 51: 'FileMaximumInformation'})]],
    'FileObject' : [ 0x8, ['pointer', ['_FILE_OBJECT']]],
    'ReplaceIfExists' : [ 0xc, ['unsigned char']],
    'AdvanceOnly' : [ 0xd, ['unsigned char']],
    'ClusterCount' : [ 0xc, ['unsigned long']],
    'DeleteHandle' : [ 0xc, ['pointer', ['void']]],
} ],
  '__unnamed_1216' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned long']],
    'EaList' : [ 0x4, ['pointer', ['void']]],
    'EaListLength' : [ 0x8, ['unsigned long']],
    'EaIndex' : [ 0xc, ['unsigned long']],
} ],
  '__unnamed_1218' : [ 0x4, {
    'Length' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_121c' : [ 0x8, {
    'Length' : [ 0x0, ['unsigned long']],
    'FsInformationClass' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {1: 'FileFsVolumeInformation', 2: 'FileFsLabelInformation', 3: 'FileFsSizeInformation', 4: 'FileFsDeviceInformation', 5: 'FileFsAttributeInformation', 6: 'FileFsControlInformation', 7: 'FileFsFullSizeInformation', 8: 'FileFsObjectIdInformation', 9: 'FileFsDriverPathInformation', 10: 'FileFsVolumeFlagsInformation', 11: 'FileFsMaximumInformation'})]],
} ],
  '__unnamed_121e' : [ 0x10, {
    'OutputBufferLength' : [ 0x0, ['unsigned long']],
    'InputBufferLength' : [ 0x4, ['unsigned long']],
    'FsControlCode' : [ 0x8, ['unsigned long']],
    'Type3InputBuffer' : [ 0xc, ['pointer', ['void']]],
} ],
  '__unnamed_1221' : [ 0x10, {
    'Length' : [ 0x0, ['pointer', ['_LARGE_INTEGER']]],
    'Key' : [ 0x4, ['unsigned long']],
    'ByteOffset' : [ 0x8, ['_LARGE_INTEGER']],
} ],
  '__unnamed_1223' : [ 0x10, {
    'OutputBufferLength' : [ 0x0, ['unsigned long']],
    'InputBufferLength' : [ 0x4, ['unsigned long']],
    'IoControlCode' : [ 0x8, ['unsigned long']],
    'Type3InputBuffer' : [ 0xc, ['pointer', ['void']]],
} ],
  '__unnamed_1225' : [ 0x8, {
    'SecurityInformation' : [ 0x0, ['unsigned long']],
    'Length' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_1227' : [ 0x8, {
    'SecurityInformation' : [ 0x0, ['unsigned long']],
    'SecurityDescriptor' : [ 0x4, ['pointer', ['void']]],
} ],
  '__unnamed_122b' : [ 0x8, {
    'Vpb' : [ 0x0, ['pointer', ['_VPB']]],
    'DeviceObject' : [ 0x4, ['pointer', ['_DEVICE_OBJECT']]],
} ],
  '__unnamed_122f' : [ 0x4, {
    'Srb' : [ 0x0, ['pointer', ['_SCSI_REQUEST_BLOCK']]],
} ],
  '__unnamed_1233' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned long']],
    'StartSid' : [ 0x4, ['pointer', ['void']]],
    'SidList' : [ 0x8, ['pointer', ['_FILE_GET_QUOTA_INFORMATION']]],
    'SidListLength' : [ 0xc, ['unsigned long']],
} ],
  '__unnamed_1237' : [ 0x4, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'BusRelations', 1: 'EjectionRelations', 2: 'PowerRelations', 3: 'RemovalRelations', 4: 'TargetDeviceRelation', 5: 'SingleBusRelations'})]],
} ],
  '__unnamed_123e' : [ 0x10, {
    'InterfaceType' : [ 0x0, ['pointer', ['_GUID']]],
    'Size' : [ 0x4, ['unsigned short']],
    'Version' : [ 0x6, ['unsigned short']],
    'Interface' : [ 0x8, ['pointer', ['_INTERFACE']]],
    'InterfaceSpecificData' : [ 0xc, ['pointer', ['void']]],
} ],
  '__unnamed_1242' : [ 0x4, {
    'Capabilities' : [ 0x0, ['pointer', ['_DEVICE_CAPABILITIES']]],
} ],
  '__unnamed_1246' : [ 0x4, {
    'IoResourceRequirementList' : [ 0x0, ['pointer', ['_IO_RESOURCE_REQUIREMENTS_LIST']]],
} ],
  '__unnamed_1248' : [ 0x10, {
    'WhichSpace' : [ 0x0, ['unsigned long']],
    'Buffer' : [ 0x4, ['pointer', ['void']]],
    'Offset' : [ 0x8, ['unsigned long']],
    'Length' : [ 0xc, ['unsigned long']],
} ],
  '__unnamed_124a' : [ 0x1, {
    'Lock' : [ 0x0, ['unsigned char']],
} ],
  '__unnamed_124e' : [ 0x4, {
    'IdType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'BusQueryDeviceID', 1: 'BusQueryHardwareIDs', 2: 'BusQueryCompatibleIDs', 3: 'BusQueryInstanceID', 4: 'BusQueryDeviceSerialNumber'})]],
} ],
  '__unnamed_1252' : [ 0x8, {
    'DeviceTextType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'DeviceTextDescription', 1: 'DeviceTextLocationInformation'})]],
    'LocaleId' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_1256' : [ 0x8, {
    'InPath' : [ 0x0, ['unsigned char']],
    'Reserved' : [ 0x1, ['array', 3, ['unsigned char']]],
    'Type' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'DeviceUsageTypeUndefined', 1: 'DeviceUsageTypePaging', 2: 'DeviceUsageTypeHibernation', 3: 'DeviceUsageTypeDumpFile'})]],
} ],
  '__unnamed_125a' : [ 0x4, {
    'PowerState' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
} ],
  '__unnamed_125e' : [ 0x4, {
    'PowerSequence' : [ 0x0, ['pointer', ['_POWER_SEQUENCE']]],
} ],
  '__unnamed_1266' : [ 0x10, {
    'SystemContext' : [ 0x0, ['unsigned long']],
    'SystemPowerStateContext' : [ 0x0, ['_SYSTEM_POWER_STATE_CONTEXT']],
    'Type' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'SystemPowerState', 1: 'DevicePowerState'})]],
    'State' : [ 0x8, ['_POWER_STATE']],
    'ShutdownType' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: 'PowerActionNone', 1: 'PowerActionReserved', 2: 'PowerActionSleep', 3: 'PowerActionHibernate', 4: 'PowerActionShutdown', 5: 'PowerActionShutdownReset', 6: 'PowerActionShutdownOff', 7: 'PowerActionWarmEject'})]],
} ],
  '__unnamed_126a' : [ 0x8, {
    'AllocatedResources' : [ 0x0, ['pointer', ['_CM_RESOURCE_LIST']]],
    'AllocatedResourcesTranslated' : [ 0x4, ['pointer', ['_CM_RESOURCE_LIST']]],
} ],
  '__unnamed_126c' : [ 0x10, {
    'ProviderId' : [ 0x0, ['unsigned long']],
    'DataPath' : [ 0x4, ['pointer', ['void']]],
    'BufferSize' : [ 0x8, ['unsigned long']],
    'Buffer' : [ 0xc, ['pointer', ['void']]],
} ],
  '__unnamed_126e' : [ 0x10, {
    'Argument1' : [ 0x0, ['pointer', ['void']]],
    'Argument2' : [ 0x4, ['pointer', ['void']]],
    'Argument3' : [ 0x8, ['pointer', ['void']]],
    'Argument4' : [ 0xc, ['pointer', ['void']]],
} ],
  '__unnamed_1270' : [ 0x10, {
    'Create' : [ 0x0, ['__unnamed_1200']],
    'CreatePipe' : [ 0x0, ['__unnamed_1204']],
    'CreateMailslot' : [ 0x0, ['__unnamed_1208']],
    'Read' : [ 0x0, ['__unnamed_120a']],
    'Write' : [ 0x0, ['__unnamed_120a']],
    'QueryDirectory' : [ 0x0, ['__unnamed_120e']],
    'NotifyDirectory' : [ 0x0, ['__unnamed_1210']],
    'QueryFile' : [ 0x0, ['__unnamed_1212']],
    'SetFile' : [ 0x0, ['__unnamed_1214']],
    'QueryEa' : [ 0x0, ['__unnamed_1216']],
    'SetEa' : [ 0x0, ['__unnamed_1218']],
    'QueryVolume' : [ 0x0, ['__unnamed_121c']],
    'SetVolume' : [ 0x0, ['__unnamed_121c']],
    'FileSystemControl' : [ 0x0, ['__unnamed_121e']],
    'LockControl' : [ 0x0, ['__unnamed_1221']],
    'DeviceIoControl' : [ 0x0, ['__unnamed_1223']],
    'QuerySecurity' : [ 0x0, ['__unnamed_1225']],
    'SetSecurity' : [ 0x0, ['__unnamed_1227']],
    'MountVolume' : [ 0x0, ['__unnamed_122b']],
    'VerifyVolume' : [ 0x0, ['__unnamed_122b']],
    'Scsi' : [ 0x0, ['__unnamed_122f']],
    'QueryQuota' : [ 0x0, ['__unnamed_1233']],
    'SetQuota' : [ 0x0, ['__unnamed_1218']],
    'QueryDeviceRelations' : [ 0x0, ['__unnamed_1237']],
    'QueryInterface' : [ 0x0, ['__unnamed_123e']],
    'DeviceCapabilities' : [ 0x0, ['__unnamed_1242']],
    'FilterResourceRequirements' : [ 0x0, ['__unnamed_1246']],
    'ReadWriteConfig' : [ 0x0, ['__unnamed_1248']],
    'SetLock' : [ 0x0, ['__unnamed_124a']],
    'QueryId' : [ 0x0, ['__unnamed_124e']],
    'QueryDeviceText' : [ 0x0, ['__unnamed_1252']],
    'UsageNotification' : [ 0x0, ['__unnamed_1256']],
    'WaitWake' : [ 0x0, ['__unnamed_125a']],
    'PowerSequence' : [ 0x0, ['__unnamed_125e']],
    'Power' : [ 0x0, ['__unnamed_1266']],
    'StartDevice' : [ 0x0, ['__unnamed_126a']],
    'WMI' : [ 0x0, ['__unnamed_126c']],
    'Others' : [ 0x0, ['__unnamed_126e']],
} ],
  '_IO_STACK_LOCATION' : [ 0x24, {
    'MajorFunction' : [ 0x0, ['unsigned char']],
    'MinorFunction' : [ 0x1, ['unsigned char']],
    'Flags' : [ 0x2, ['unsigned char']],
    'Control' : [ 0x3, ['unsigned char']],
    'Parameters' : [ 0x4, ['__unnamed_1270']],
    'DeviceObject' : [ 0x14, ['pointer', ['_DEVICE_OBJECT']]],
    'FileObject' : [ 0x18, ['pointer', ['_FILE_OBJECT']]],
    'CompletionRoutine' : [ 0x1c, ['pointer', ['void']]],
    'Context' : [ 0x20, ['pointer', ['void']]],
} ],
  '_IO_DRIVER_CREATE_CONTEXT' : [ 0x10, {
    'Size' : [ 0x0, ['short']],
    'ExtraCreateParameter' : [ 0x4, ['pointer', ['_ECP_LIST']]],
    'DeviceObjectHint' : [ 0x8, ['pointer', ['void']]],
    'TxnParameters' : [ 0xc, ['pointer', ['_TXN_PARAMETER_BLOCK']]],
} ],
  '_IO_PRIORITY_INFO' : [ 0x10, {
    'Size' : [ 0x0, ['unsigned long']],
    'ThreadPriority' : [ 0x4, ['unsigned long']],
    'PagePriority' : [ 0x8, ['unsigned long']],
    'IoPriority' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: 'IoPriorityVeryLow', 1: 'IoPriorityLow', 2: 'IoPriorityNormal', 3: 'IoPriorityHigh', 4: 'IoPriorityCritical', 5: 'MaxIoPriorityTypes'})]],
} ],
  '_OBJECT_ATTRIBUTES' : [ 0x18, {
    'Length' : [ 0x0, ['unsigned long']],
    'RootDirectory' : [ 0x4, ['pointer', ['void']]],
    'ObjectName' : [ 0x8, ['pointer', ['_UNICODE_STRING']]],
    'Attributes' : [ 0xc, ['unsigned long']],
    'SecurityDescriptor' : [ 0x10, ['pointer', ['void']]],
    'SecurityQualityOfService' : [ 0x14, ['pointer', ['void']]],
} ],
  '_OBJECT_HANDLE_INFORMATION' : [ 0x8, {
    'HandleAttributes' : [ 0x0, ['unsigned long']],
    'GrantedAccess' : [ 0x4, ['unsigned long']],
} ],
  '_OBJECT_HEADER' : [ 0x20, {
    'PointerCount' : [ 0x0, ['long']],
    'HandleCount' : [ 0x4, ['long']],
    'NextToFree' : [ 0x4, ['pointer', ['void']]],
    'Type' : [ 0x8, ['pointer', ['_OBJECT_TYPE']]],
    'NameInfoOffset' : [ 0xc, ['unsigned char']],
    'HandleInfoOffset' : [ 0xd, ['unsigned char']],
    'QuotaInfoOffset' : [ 0xe, ['unsigned char']],
    'Flags' : [ 0xf, ['unsigned char']],
    'ObjectCreateInfo' : [ 0x10, ['pointer', ['_OBJECT_CREATE_INFORMATION']]],
    'QuotaBlockCharged' : [ 0x10, ['pointer', ['void']]],
    'SecurityDescriptor' : [ 0x14, ['pointer', ['void']]],
    'Body' : [ 0x18, ['_QUAD']],
} ],
  '_OBJECT_HEADER_QUOTA_INFO' : [ 0x10, {
    'PagedPoolCharge' : [ 0x0, ['unsigned long']],
    'NonPagedPoolCharge' : [ 0x4, ['unsigned long']],
    'SecurityDescriptorCharge' : [ 0x8, ['unsigned long']],
    'ExclusiveProcess' : [ 0xc, ['pointer', ['_EPROCESS']]],
} ],
  '_OBJECT_HEADER_HANDLE_INFO' : [ 0x8, {
    'HandleCountDataBase' : [ 0x0, ['pointer', ['_OBJECT_HANDLE_COUNT_DATABASE']]],
    'SingleEntry' : [ 0x0, ['_OBJECT_HANDLE_COUNT_ENTRY']],
} ],
  '_OBJECT_HEADER_NAME_INFO' : [ 0x10, {
    'Directory' : [ 0x0, ['pointer', ['_OBJECT_DIRECTORY']]],
    'Name' : [ 0x4, ['_UNICODE_STRING']],
    'QueryReferences' : [ 0xc, ['unsigned long']],
} ],
  '_OBJECT_HEADER_CREATOR_INFO' : [ 0x10, {
    'TypeList' : [ 0x0, ['_LIST_ENTRY']],
    'CreatorUniqueProcess' : [ 0x8, ['pointer', ['void']]],
    'CreatorBackTraceIndex' : [ 0xc, ['unsigned short']],
    'Reserved' : [ 0xe, ['unsigned short']],
} ],
  '_EVENT_DATA_DESCRIPTOR' : [ 0x10, {
    'Ptr' : [ 0x0, ['unsigned long long']],
    'Size' : [ 0x8, ['unsigned long']],
    'Reserved' : [ 0xc, ['unsigned long']],
} ],
  '_EVENT_DESCRIPTOR' : [ 0x10, {
    'Id' : [ 0x0, ['unsigned short']],
    'Version' : [ 0x2, ['unsigned char']],
    'Channel' : [ 0x3, ['unsigned char']],
    'Level' : [ 0x4, ['unsigned char']],
    'Opcode' : [ 0x5, ['unsigned char']],
    'Task' : [ 0x6, ['unsigned short']],
    'Keyword' : [ 0x8, ['unsigned long long']],
} ],
  '_PERFINFO_GROUPMASK' : [ 0x20, {
    'Masks' : [ 0x0, ['array', 8, ['unsigned long']]],
} ],
  '_FILE_OBJECT' : [ 0x80, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['short']],
    'DeviceObject' : [ 0x4, ['pointer', ['_DEVICE_OBJECT']]],
    'Vpb' : [ 0x8, ['pointer', ['_VPB']]],
    'FsContext' : [ 0xc, ['pointer', ['void']]],
    'FsContext2' : [ 0x10, ['pointer', ['void']]],
    'SectionObjectPointer' : [ 0x14, ['pointer', ['_SECTION_OBJECT_POINTERS']]],
    'PrivateCacheMap' : [ 0x18, ['pointer', ['void']]],
    'FinalStatus' : [ 0x1c, ['long']],
    'RelatedFileObject' : [ 0x20, ['pointer', ['_FILE_OBJECT']]],
    'LockOperation' : [ 0x24, ['unsigned char']],
    'DeletePending' : [ 0x25, ['unsigned char']],
    'ReadAccess' : [ 0x26, ['unsigned char']],
    'WriteAccess' : [ 0x27, ['unsigned char']],
    'DeleteAccess' : [ 0x28, ['unsigned char']],
    'SharedRead' : [ 0x29, ['unsigned char']],
    'SharedWrite' : [ 0x2a, ['unsigned char']],
    'SharedDelete' : [ 0x2b, ['unsigned char']],
    'Flags' : [ 0x2c, ['unsigned long']],
    'FileName' : [ 0x30, ['_UNICODE_STRING']],
    'CurrentByteOffset' : [ 0x38, ['_LARGE_INTEGER']],
    'Waiters' : [ 0x40, ['unsigned long']],
    'Busy' : [ 0x44, ['unsigned long']],
    'LastLock' : [ 0x48, ['pointer', ['void']]],
    'Lock' : [ 0x4c, ['_KEVENT']],
    'Event' : [ 0x5c, ['_KEVENT']],
    'CompletionContext' : [ 0x6c, ['pointer', ['_IO_COMPLETION_CONTEXT']]],
    'IrpListLock' : [ 0x70, ['unsigned long']],
    'IrpList' : [ 0x74, ['_LIST_ENTRY']],
    'FileObjectExtension' : [ 0x7c, ['pointer', ['void']]],
} ],
  '_MM_PAGE_ACCESS_INFO_HEADER' : [ 0x38, {
    'Link' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Type' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'MmPteAccessType', 1: 'MmCcReadAheadType', 2: 'MmPfnRepurposeType', 3: 'MmMaximumPageAccessType'})]],
    'EmptySequenceNumber' : [ 0x8, ['unsigned long']],
    'CurrentFileIndex' : [ 0x8, ['unsigned long']],
    'CreateTime' : [ 0x10, ['unsigned long long']],
    'EmptyTime' : [ 0x18, ['unsigned long long']],
    'TempEntry' : [ 0x18, ['pointer', ['_MM_PAGE_ACCESS_INFO']]],
    'PageEntry' : [ 0x20, ['pointer', ['_MM_PAGE_ACCESS_INFO']]],
    'FileEntry' : [ 0x24, ['pointer', ['unsigned long']]],
    'FirstFileEntry' : [ 0x28, ['pointer', ['unsigned long']]],
    'Process' : [ 0x2c, ['pointer', ['_EPROCESS']]],
    'SessionId' : [ 0x30, ['unsigned long']],
    'PageFrameEntry' : [ 0x20, ['pointer', ['unsigned long']]],
    'LastPageFrameEntry' : [ 0x24, ['pointer', ['unsigned long']]],
} ],
  '_PF_HARD_FAULT_INFO' : [ 0x30, {
    'KernelTimeStamp' : [ 0x0, ['_ETW_KERNEL_TRACE_TIMESTAMP']],
    'HardFaultEvent' : [ 0x10, ['_PERFINFO_HARDPAGEFAULT_INFORMATION']],
    'IoTimeInTicks' : [ 0x28, ['_LARGE_INTEGER']],
} ],
  '_WHEA_ERROR_RECORD' : [ 0xc8, {
    'Header' : [ 0x0, ['_WHEA_ERROR_RECORD_HEADER']],
    'SectionDescriptor' : [ 0x80, ['array', 1, ['_WHEA_ERROR_RECORD_SECTION_DESCRIPTOR']]],
} ],
  '_GUID' : [ 0x10, {
    'Data1' : [ 0x0, ['unsigned long']],
    'Data2' : [ 0x4, ['unsigned short']],
    'Data3' : [ 0x6, ['unsigned short']],
    'Data4' : [ 0x8, ['array', 8, ['unsigned char']]],
} ],
  '__unnamed_1320' : [ 0xd0, {
    'ProcessorError' : [ 0x0, ['_WHEA_GENERIC_PROCESSOR_ERROR']],
    'MemoryError' : [ 0x0, ['_WHEA_MEMORY_ERROR']],
    'NmiError' : [ 0x0, ['_WHEA_NMI_ERROR']],
    'PciExpressError' : [ 0x0, ['_WHEA_PCIEXPRESS_ERROR']],
    'PciXBusError' : [ 0x0, ['_WHEA_PCIXBUS_ERROR']],
    'PciXDeviceError' : [ 0x0, ['_WHEA_PCIXDEVICE_ERROR']],
} ],
  '_WHEA_ERROR_PACKET' : [ 0x119, {
    'Signature' : [ 0x0, ['unsigned long']],
    'Flags' : [ 0x4, ['_WHEA_ERROR_PACKET_FLAGS']],
    'Size' : [ 0x8, ['unsigned long']],
    'RawDataLength' : [ 0xc, ['unsigned long']],
    'Reserved1' : [ 0x10, ['unsigned long long']],
    'Context' : [ 0x18, ['unsigned long long']],
    'ErrorType' : [ 0x20, ['Enumeration', dict(target = 'long', choices = {0: 'WheaErrTypeProcessor', 1: 'WheaErrTypeMemory', 2: 'WheaErrTypePCIExpress', 3: 'WheaErrTypeNMI', 4: 'WheaErrTypePCIXBus', 5: 'WheaErrTypePCIXDevice', 6: 'WheaErrTypeGeneric'})]],
    'ErrorSeverity' : [ 0x24, ['Enumeration', dict(target = 'long', choices = {0: 'WheaErrSevRecoverable', 1: 'WheaErrSevFatal', 2: 'WheaErrSevCorrected', 3: 'WheaErrSevNone'})]],
    'ErrorSourceId' : [ 0x28, ['unsigned long']],
    'ErrorSourceType' : [ 0x2c, ['Enumeration', dict(target = 'long', choices = {0: 'WheaErrSrcTypeMCE', 1: 'WheaErrSrcTypeCMC', 2: 'WheaErrSrcTypeCPE', 3: 'WheaErrSrcTypeNMI', 4: 'WheaErrSrcTypePCIe', 5: 'WheaErrSrcTypeGeneric', 6: 'WheaErrSrcTypeINIT', 7: 'WheaErrSrcTypeBOOT', 8: 'WheaErrSrcTypeSCIGeneric', 9: 'WheaErrSrcTypeIPFMCA', 10: 'WheaErrSrcTypeIPFCMC', 11: 'WheaErrSrcTypeIPFCPE', 12: 'WheaErrSrcTypeMax'})]],
    'Reserved2' : [ 0x30, ['unsigned long']],
    'Version' : [ 0x34, ['unsigned long']],
    'Cpu' : [ 0x38, ['unsigned long long']],
    'u' : [ 0x40, ['__unnamed_1320']],
    'RawDataFormat' : [ 0x110, ['Enumeration', dict(target = 'long', choices = {0: 'WheaRawDataFormatIPFSalRecord', 1: 'WheaRawDataFormatIA32MCA', 2: 'WheaRawDataFormatIntel64MCA', 3: 'WheaRawDataFormatAMD64MCA', 4: 'WheaRawDataFormatMemory', 5: 'WheaRawDataFormatPCIExpress', 6: 'WheaRawDataFormatNMIPort', 7: 'WheaRawDataFormatPCIXBus', 8: 'WheaRawDataFormatPCIXDevice', 9: 'WheaRawDataFormatGeneric', 10: 'WheaRawDataFormatMax'})]],
    'RawDataOffset' : [ 0x114, ['unsigned long']],
    'RawData' : [ 0x118, ['array', 1, ['unsigned char']]],
} ],
  '_KPROCESS' : [ 0x80, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'ProfileListHead' : [ 0x10, ['_LIST_ENTRY']],
    'DirectoryTableBase' : [ 0x18, ['unsigned long']],
    'Unused0' : [ 0x1c, ['unsigned long']],
    'LdtDescriptor' : [ 0x20, ['_KGDTENTRY']],
    'Int21Descriptor' : [ 0x28, ['_KIDTENTRY']],
    'IopmOffset' : [ 0x30, ['unsigned short']],
    'Unused1' : [ 0x32, ['unsigned char']],
    'Unused2' : [ 0x33, ['unsigned char']],
    'ActiveProcessors' : [ 0x34, ['unsigned long']],
    'KernelTime' : [ 0x38, ['unsigned long']],
    'UserTime' : [ 0x3c, ['unsigned long']],
    'ReadyListHead' : [ 0x40, ['_LIST_ENTRY']],
    'SwapListEntry' : [ 0x48, ['_SINGLE_LIST_ENTRY']],
    'VdmTrapcHandler' : [ 0x4c, ['pointer', ['void']]],
    'ThreadListHead' : [ 0x50, ['_LIST_ENTRY']],
    'ProcessLock' : [ 0x58, ['unsigned long']],
    'Affinity' : [ 0x5c, ['unsigned long']],
    'AutoAlignment' : [ 0x60, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='long')]],
    'DisableBoost' : [ 0x60, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='long')]],
    'DisableQuantum' : [ 0x60, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='long')]],
    'ReservedFlags' : [ 0x60, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='long')]],
    'ProcessFlags' : [ 0x60, ['long']],
    'BasePriority' : [ 0x64, ['unsigned char']],
    'QuantumReset' : [ 0x65, ['unsigned char']],
    'State' : [ 0x66, ['unsigned char']],
    'ThreadSeed' : [ 0x67, ['unsigned char']],
    'PowerState' : [ 0x68, ['unsigned char']],
    'IdealNode' : [ 0x69, ['unsigned char']],
    'Visited' : [ 0x6a, ['unsigned char']],
    'Flags' : [ 0x6b, ['_KEXECUTE_OPTIONS']],
    'ExecuteOptions' : [ 0x6b, ['unsigned char']],
    'StackCount' : [ 0x6c, ['unsigned long']],
    'ProcessListEntry' : [ 0x70, ['_LIST_ENTRY']],
    'CycleTime' : [ 0x78, ['unsigned long long']],
} ],
  '__unnamed_13d6' : [ 0x4, {
    'Long' : [ 0x0, ['unsigned long']],
    'VolatileLong' : [ 0x0, ['unsigned long']],
    'Flush' : [ 0x0, ['_HARDWARE_PTE']],
    'Hard' : [ 0x0, ['_MMPTE_HARDWARE']],
    'Proto' : [ 0x0, ['_MMPTE_PROTOTYPE']],
    'Soft' : [ 0x0, ['_MMPTE_SOFTWARE']],
    'TimeStamp' : [ 0x0, ['_MMPTE_TIMESTAMP']],
    'Trans' : [ 0x0, ['_MMPTE_TRANSITION']],
    'Subsect' : [ 0x0, ['_MMPTE_SUBSECTION']],
    'List' : [ 0x0, ['_MMPTE_LIST']],
} ],
  '_MMPTE' : [ 0x4, {
    'u' : [ 0x0, ['__unnamed_13d6']],
} ],
  '__unnamed_13ea' : [ 0xc, {
    'I386' : [ 0x0, ['_I386_LOADER_BLOCK']],
    'Alpha' : [ 0x0, ['_ALPHA_LOADER_BLOCK']],
    'Ia64' : [ 0x0, ['_IA64_LOADER_BLOCK']],
} ],
  '_LOADER_PARAMETER_BLOCK' : [ 0x7c, {
    'LoadOrderListHead' : [ 0x0, ['_LIST_ENTRY']],
    'MemoryDescriptorListHead' : [ 0x8, ['_LIST_ENTRY']],
    'BootDriverListHead' : [ 0x10, ['_LIST_ENTRY']],
    'KernelStack' : [ 0x18, ['unsigned long']],
    'Prcb' : [ 0x1c, ['unsigned long']],
    'Process' : [ 0x20, ['unsigned long']],
    'Thread' : [ 0x24, ['unsigned long']],
    'RegistryLength' : [ 0x28, ['unsigned long']],
    'RegistryBase' : [ 0x2c, ['pointer', ['void']]],
    'ConfigurationRoot' : [ 0x30, ['pointer', ['_CONFIGURATION_COMPONENT_DATA']]],
    'ArcBootDeviceName' : [ 0x34, ['pointer', ['unsigned char']]],
    'ArcHalDeviceName' : [ 0x38, ['pointer', ['unsigned char']]],
    'NtBootPathName' : [ 0x3c, ['pointer', ['unsigned char']]],
    'NtHalPathName' : [ 0x40, ['pointer', ['unsigned char']]],
    'LoadOptions' : [ 0x44, ['pointer', ['unsigned char']]],
    'NlsData' : [ 0x48, ['pointer', ['_NLS_DATA_BLOCK']]],
    'ArcDiskInformation' : [ 0x4c, ['pointer', ['_ARC_DISK_INFORMATION']]],
    'OemFontFile' : [ 0x50, ['pointer', ['void']]],
    'SetupLoaderBlock' : [ 0x54, ['pointer', ['_SETUP_LOADER_BLOCK']]],
    'Extension' : [ 0x58, ['pointer', ['_LOADER_PARAMETER_EXTENSION']]],
    'u' : [ 0x5c, ['__unnamed_13ea']],
    'FirmwareInformation' : [ 0x68, ['_FIRMWARE_INFORMATION_LOADER_BLOCK']],
} ],
  '_MMPTE_FLUSH_LIST' : [ 0x8c, {
    'Count' : [ 0x0, ['unsigned long']],
    'MaximumCount' : [ 0x4, ['unsigned long']],
    'FlushVa' : [ 0x8, ['array', 33, ['pointer', ['void']]]],
} ],
  '_MI_COLOR_BASE' : [ 0x8, {
    'ColorPointer' : [ 0x0, ['pointer', ['unsigned short']]],
    'ColorMask' : [ 0x4, ['unsigned short']],
    'ColorNode' : [ 0x6, ['unsigned short']],
} ],
  '_MMSUPPORT' : [ 0x48, {
    'WorkingSetExpansionLinks' : [ 0x0, ['_LIST_ENTRY']],
    'LastTrimStamp' : [ 0x8, ['unsigned short']],
    'NextPageColor' : [ 0xa, ['unsigned short']],
    'Flags' : [ 0xc, ['_MMSUPPORT_FLAGS']],
    'PageFaultCount' : [ 0x10, ['unsigned long']],
    'PeakWorkingSetSize' : [ 0x14, ['unsigned long']],
    'ChargedWslePages' : [ 0x18, ['unsigned long']],
    'MinimumWorkingSetSize' : [ 0x1c, ['unsigned long']],
    'MaximumWorkingSetSize' : [ 0x20, ['unsigned long']],
    'VmWorkingSetList' : [ 0x24, ['pointer', ['_MMWSL']]],
    'Claim' : [ 0x28, ['unsigned long']],
    'ActualWslePages' : [ 0x2c, ['unsigned long']],
    'WorkingSetPrivateSize' : [ 0x30, ['unsigned long']],
    'WorkingSetSizeOverhead' : [ 0x34, ['unsigned long']],
    'WorkingSetSize' : [ 0x38, ['unsigned long']],
    'ExitGate' : [ 0x3c, ['pointer', ['_KGATE']]],
    'WorkingSetMutex' : [ 0x40, ['_EX_PUSH_LOCK']],
    'AccessLog' : [ 0x44, ['pointer', ['void']]],
} ],
  '__unnamed_1424' : [ 0x4, {
    'Flink' : [ 0x0, ['unsigned long']],
    'WsIndex' : [ 0x0, ['unsigned long']],
    'Event' : [ 0x0, ['pointer', ['_KEVENT']]],
    'Next' : [ 0x0, ['pointer', ['void']]],
    'VolatileNext' : [ 0x0, ['pointer', ['void']]],
    'KernelStackOwner' : [ 0x0, ['pointer', ['_KTHREAD']]],
    'NextStackPfn' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
} ],
  '__unnamed_1426' : [ 0x4, {
    'Blink' : [ 0x0, ['unsigned long']],
    'ImageProtoPte' : [ 0x0, ['pointer', ['_MMPTE']]],
    'ShareCount' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_1429' : [ 0x4, {
    'ReferenceCount' : [ 0x0, ['unsigned short']],
    'VolatileReferenceCount' : [ 0x0, ['short']],
    'ShortFlags' : [ 0x2, ['unsigned short']],
} ],
  '__unnamed_142b' : [ 0x4, {
    'ReferenceCount' : [ 0x0, ['unsigned short']],
    'ByteFlags' : [ 0x2, ['unsigned char']],
    'InterlockedByteFlags' : [ 0x3, ['unsigned char']],
} ],
  '__unnamed_142d' : [ 0x4, {
    'ReferenceCount' : [ 0x0, ['unsigned short']],
    'e1' : [ 0x2, ['_MMPFNENTRY']],
    'e2' : [ 0x0, ['__unnamed_1429']],
    'e3' : [ 0x0, ['__unnamed_142b']],
} ],
  '__unnamed_1432' : [ 0x4, {
    'PteFrame' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 25, native_type='unsigned long')]],
    'PfnImageVerified' : [ 0x0, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'AweAllocation' : [ 0x0, ['BitField', dict(start_bit = 26, end_bit = 27, native_type='unsigned long')]],
    'PrototypePte' : [ 0x0, ['BitField', dict(start_bit = 27, end_bit = 28, native_type='unsigned long')]],
    'PageColor' : [ 0x0, ['BitField', dict(start_bit = 28, end_bit = 32, native_type='unsigned long')]],
} ],
  '_MMPFN' : [ 0x18, {
    'u1' : [ 0x0, ['__unnamed_1424']],
    'u2' : [ 0x4, ['__unnamed_1426']],
    'PteAddress' : [ 0x8, ['pointer', ['_MMPTE']]],
    'VolatilePteAddress' : [ 0x8, ['pointer', ['void']]],
    'u3' : [ 0xc, ['__unnamed_142d']],
    'OriginalPte' : [ 0x10, ['_MMPTE']],
    'AweReferenceCount' : [ 0x10, ['long']],
    'u4' : [ 0x14, ['__unnamed_1432']],
} ],
  '__unnamed_143c' : [ 0x4, {
    'VirtualAddress' : [ 0x0, ['pointer', ['void']]],
    'Long' : [ 0x0, ['unsigned long']],
    'e1' : [ 0x0, ['_MMWSLENTRY']],
    'e2' : [ 0x0, ['_MMWSLE_FREE_ENTRY']],
} ],
  '_MMWSLE' : [ 0x4, {
    'u1' : [ 0x0, ['__unnamed_143c']],
} ],
  '_MMWSL' : [ 0x6b8, {
    'FirstFree' : [ 0x0, ['unsigned long']],
    'FirstDynamic' : [ 0x4, ['unsigned long']],
    'LastEntry' : [ 0x8, ['unsigned long']],
    'NextSlot' : [ 0xc, ['unsigned long']],
    'Wsle' : [ 0x10, ['pointer', ['_MMWSLE']]],
    'LowestPagableAddress' : [ 0x14, ['pointer', ['void']]],
    'LastInitializedWsle' : [ 0x18, ['unsigned long']],
    'NextEstimationSlot' : [ 0x1c, ['unsigned long']],
    'NextAgingSlot' : [ 0x20, ['unsigned long']],
    'EstimatedAvailable' : [ 0x24, ['unsigned long']],
    'GrowthSinceLastEstimate' : [ 0x28, ['unsigned long']],
    'NumberOfCommittedPageTables' : [ 0x2c, ['unsigned long']],
    'VadBitMapHint' : [ 0x30, ['unsigned long']],
    'NonDirectCount' : [ 0x34, ['unsigned long']],
    'LastVadBit' : [ 0x38, ['unsigned long']],
    'MaximumLastVadBit' : [ 0x3c, ['unsigned long']],
    'LastAllocationSizeHint' : [ 0x40, ['unsigned long']],
    'LastAllocationSize' : [ 0x44, ['unsigned long']],
    'NonDirectHash' : [ 0x48, ['pointer', ['_MMWSLE_NONDIRECT_HASH']]],
    'HashTableStart' : [ 0x4c, ['pointer', ['_MMWSLE_HASH']]],
    'HighestPermittedHashAddress' : [ 0x50, ['pointer', ['_MMWSLE_HASH']]],
    'HighestUserAddress' : [ 0x54, ['pointer', ['void']]],
    'UsedPageTableEntries' : [ 0x58, ['array', 768, ['unsigned short']]],
    'CommittedPageTables' : [ 0x658, ['array', 24, ['unsigned long']]],
} ],
  '__unnamed_1454' : [ 0x4, {
    'LongFlags' : [ 0x0, ['unsigned long']],
    'Flags' : [ 0x0, ['_MMSECTION_FLAGS']],
} ],
  '__unnamed_1456' : [ 0x4, {
    'ModifiedWriteCount' : [ 0x0, ['unsigned short']],
    'FlushInProgressCount' : [ 0x2, ['unsigned short']],
} ],
  '__unnamed_1458' : [ 0x4, {
    'e2' : [ 0x0, ['__unnamed_1456']],
} ],
  '__unnamed_1462' : [ 0xc, {
    'NumberOfSystemCacheViews' : [ 0x0, ['unsigned long']],
    'ImageRelocationStartBit' : [ 0x0, ['unsigned long']],
    'WritableUserReferences' : [ 0x4, ['long']],
    'ImageRelocationSizeIn64k' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned long')]],
    'Unused' : [ 0x4, ['BitField', dict(start_bit = 16, end_bit = 30, native_type='unsigned long')]],
    'BitMap64' : [ 0x4, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'ImageActive' : [ 0x4, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'SubsectionRoot' : [ 0x8, ['pointer', ['_MM_SUBSECTION_AVL_TABLE']]],
    'SeImageStub' : [ 0x8, ['pointer', ['_MI_IMAGE_SECURITY_REFERENCE']]],
} ],
  '__unnamed_1464' : [ 0xc, {
    'e2' : [ 0x0, ['__unnamed_1462']],
} ],
  '_CONTROL_AREA' : [ 0x48, {
    'Segment' : [ 0x0, ['pointer', ['_SEGMENT']]],
    'DereferenceList' : [ 0x4, ['_LIST_ENTRY']],
    'NumberOfSectionReferences' : [ 0xc, ['unsigned long']],
    'NumberOfPfnReferences' : [ 0x10, ['unsigned long']],
    'NumberOfMappedViews' : [ 0x14, ['unsigned long']],
    'NumberOfUserReferences' : [ 0x18, ['unsigned long']],
    'u' : [ 0x1c, ['__unnamed_1454']],
    'u1' : [ 0x20, ['__unnamed_1458']],
    'FilePointer' : [ 0x24, ['_EX_FAST_REF']],
    'ControlAreaLock' : [ 0x28, ['long']],
    'StartingFrame' : [ 0x2c, ['unsigned long']],
    'WaitingForDeletion' : [ 0x30, ['pointer', ['_MI_SECTION_CREATION_GATE']]],
    'u2' : [ 0x34, ['__unnamed_1464']],
    'LockedPages' : [ 0x40, ['long long']],
} ],
  '_MMPAGING_FILE' : [ 0x50, {
    'Size' : [ 0x0, ['unsigned long']],
    'MaximumSize' : [ 0x4, ['unsigned long']],
    'MinimumSize' : [ 0x8, ['unsigned long']],
    'FreeSpace' : [ 0xc, ['unsigned long']],
    'PeakUsage' : [ 0x10, ['unsigned long']],
    'HighestPage' : [ 0x14, ['unsigned long']],
    'File' : [ 0x18, ['pointer', ['_FILE_OBJECT']]],
    'Entry' : [ 0x1c, ['array', 2, ['pointer', ['_MMMOD_WRITER_MDL_ENTRY']]]],
    'PageFileName' : [ 0x24, ['_UNICODE_STRING']],
    'Bitmap' : [ 0x2c, ['pointer', ['_RTL_BITMAP']]],
    'BitmapHint' : [ 0x30, ['unsigned long']],
    'LastAllocationSize' : [ 0x34, ['unsigned long']],
    'PageFileNumber' : [ 0x38, ['BitField', dict(start_bit = 0, end_bit = 4, native_type='unsigned short')]],
    'BootPartition' : [ 0x38, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned short')]],
    'Spare0' : [ 0x38, ['BitField', dict(start_bit = 5, end_bit = 16, native_type='unsigned short')]],
    'AdriftMdls' : [ 0x3a, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'Spare1' : [ 0x3a, ['BitField', dict(start_bit = 1, end_bit = 16, native_type='unsigned short')]],
    'FileHandle' : [ 0x3c, ['pointer', ['void']]],
    'AvailableList' : [ 0x40, ['_SLIST_HEADER']],
    'NeedProcessingList' : [ 0x48, ['_SLIST_HEADER']],
} ],
  '_MMPAGING_FILE_FREE_ENTRY' : [ 0x8, {
    'ListEntry' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'FreeBit' : [ 0x4, ['unsigned long']],
} ],
  '_RTL_BITMAP' : [ 0x8, {
    'SizeOfBitMap' : [ 0x0, ['unsigned long']],
    'Buffer' : [ 0x4, ['pointer', ['unsigned long']]],
} ],
  '__unnamed_149d' : [ 0x4, {
    'Balance' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='long')]],
    'Parent' : [ 0x0, ['pointer', ['_MMVAD']]],
} ],
  '__unnamed_14a0' : [ 0x4, {
    'LongFlags' : [ 0x0, ['unsigned long']],
    'VadFlags' : [ 0x0, ['_MMVAD_FLAGS']],
} ],
  '__unnamed_14a3' : [ 0x4, {
    'LongFlags3' : [ 0x0, ['unsigned long']],
    'VadFlags3' : [ 0x0, ['_MMVAD_FLAGS3']],
} ],
  '_MMVAD_SHORT' : [ 0x20, {
    'u1' : [ 0x0, ['__unnamed_149d']],
    'LeftChild' : [ 0x4, ['pointer', ['_MMVAD']]],
    'RightChild' : [ 0x8, ['pointer', ['_MMVAD']]],
    'StartingVpn' : [ 0xc, ['unsigned long']],
    'EndingVpn' : [ 0x10, ['unsigned long']],
    'u' : [ 0x14, ['__unnamed_14a0']],
    'PushLock' : [ 0x18, ['_EX_PUSH_LOCK']],
    'u5' : [ 0x1c, ['__unnamed_14a3']],
} ],
  '_MM_AVL_TABLE' : [ 0x20, {
    'BalancedRoot' : [ 0x0, ['_MMADDRESS_NODE']],
    'DepthOfTree' : [ 0x14, ['BitField', dict(start_bit = 0, end_bit = 5, native_type='unsigned long')]],
    'Unused' : [ 0x14, ['BitField', dict(start_bit = 5, end_bit = 8, native_type='unsigned long')]],
    'NumberGenericTableElements' : [ 0x14, ['BitField', dict(start_bit = 8, end_bit = 32, native_type='unsigned long')]],
    'NodeHint' : [ 0x18, ['pointer', ['void']]],
    'NodeFreeHint' : [ 0x1c, ['pointer', ['void']]],
} ],
  '__unnamed_14ac' : [ 0x4, {
    'LongFlags2' : [ 0x0, ['unsigned long']],
    'VadFlags2' : [ 0x0, ['_MMVAD_FLAGS2']],
} ],
  '_MMVAD' : [ 0x30, {
    'u1' : [ 0x0, ['__unnamed_149d']],
    'LeftChild' : [ 0x4, ['pointer', ['_MMVAD']]],
    'RightChild' : [ 0x8, ['pointer', ['_MMVAD']]],
    'StartingVpn' : [ 0xc, ['unsigned long']],
    'EndingVpn' : [ 0x10, ['unsigned long']],
    'u' : [ 0x14, ['__unnamed_14a0']],
    'PushLock' : [ 0x18, ['_EX_PUSH_LOCK']],
    'u5' : [ 0x1c, ['__unnamed_14a3']],
    'u2' : [ 0x20, ['__unnamed_14ac']],
    'Subsection' : [ 0x24, ['pointer', ['_SUBSECTION']]],
    'MappedSubsection' : [ 0x24, ['pointer', ['_MSUBSECTION']]],
    'FirstPrototypePte' : [ 0x28, ['pointer', ['_MMPTE']]],
    'LastContiguousPte' : [ 0x2c, ['pointer', ['_MMPTE']]],
} ],
  '__unnamed_14be' : [ 0x4, {
    'Balance' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='long')]],
    'Parent' : [ 0x0, ['pointer', ['_MMADDRESS_NODE']]],
    'NextToFree' : [ 0x0, ['pointer', ['_MI_PER_SESSION_PROTOS']]],
} ],
  '__unnamed_14c0' : [ 0x4, {
    'ReferenceCount' : [ 0x0, ['unsigned long']],
    'NumberOfPtesToFree' : [ 0x0, ['unsigned long']],
} ],
  '_MI_PER_SESSION_PROTOS' : [ 0x1c, {
    'u1' : [ 0x0, ['__unnamed_14be']],
    'LeftChild' : [ 0x4, ['pointer', ['_MMADDRESS_NODE']]],
    'RightChild' : [ 0x8, ['pointer', ['_MMADDRESS_NODE']]],
    'SessionId' : [ 0xc, ['unsigned long']],
    'StartingVpn' : [ 0xc, ['unsigned long']],
    'Subsection' : [ 0xc, ['pointer', ['_SUBSECTION']]],
    'EndingVpn' : [ 0x10, ['unsigned long']],
    'SubsectionBase' : [ 0x14, ['pointer', ['_MMPTE']]],
    'u2' : [ 0x18, ['__unnamed_14c0']],
} ],
  '__unnamed_14c5' : [ 0x4, {
    'LongFlags' : [ 0x0, ['unsigned long']],
    'SubsectionFlags' : [ 0x0, ['_MMSUBSECTION_FLAGS']],
} ],
  '_SUBSECTION' : [ 0x20, {
    'ControlArea' : [ 0x0, ['pointer', ['_CONTROL_AREA']]],
    'SubsectionBase' : [ 0x4, ['pointer', ['_MMPTE']]],
    'NextSubsection' : [ 0x8, ['pointer', ['_SUBSECTION']]],
    'PtesInSubsection' : [ 0xc, ['unsigned long']],
    'UnusedPtes' : [ 0x10, ['unsigned long']],
    'GlobalPerSessionHead' : [ 0x10, ['pointer', ['_MM_AVL_TABLE']]],
    'u' : [ 0x14, ['__unnamed_14c5']],
    'StartingSector' : [ 0x18, ['unsigned long']],
    'NumberOfFullSectors' : [ 0x1c, ['unsigned long']],
} ],
  '__unnamed_14ce' : [ 0x8, {
    'IoStatus' : [ 0x0, ['_IO_STATUS_BLOCK']],
} ],
  '__unnamed_14d0' : [ 0x4, {
    'KeepForever' : [ 0x0, ['unsigned long']],
} ],
  '_MMMOD_WRITER_MDL_ENTRY' : [ 0x60, {
    'Links' : [ 0x0, ['_LIST_ENTRY']],
    'u' : [ 0x8, ['__unnamed_14ce']],
    'Irp' : [ 0x10, ['pointer', ['_IRP']]],
    'u1' : [ 0x14, ['__unnamed_14d0']],
    'PagingFile' : [ 0x18, ['pointer', ['_MMPAGING_FILE']]],
    'File' : [ 0x1c, ['pointer', ['_FILE_OBJECT']]],
    'ControlArea' : [ 0x20, ['pointer', ['_CONTROL_AREA']]],
    'FileResource' : [ 0x24, ['pointer', ['_ERESOURCE']]],
    'WriteOffset' : [ 0x28, ['_LARGE_INTEGER']],
    'IssueTime' : [ 0x30, ['_LARGE_INTEGER']],
    'PointerMdl' : [ 0x38, ['pointer', ['_MDL']]],
    'Mdl' : [ 0x3c, ['_MDL']],
    'Page' : [ 0x58, ['array', 1, ['unsigned long']]],
} ],
  '__unnamed_14d9' : [ 0x20, {
    'Mdl' : [ 0x0, ['_MDL']],
    'Page' : [ 0x1c, ['array', 1, ['unsigned long']]],
} ],
  '_MI_PAGEFILE_TRACES' : [ 0x40, {
    'Status' : [ 0x0, ['long']],
    'Priority' : [ 0x4, ['unsigned char']],
    'IrpPriority' : [ 0x5, ['unsigned char']],
    'CurrentTime' : [ 0x8, ['_LARGE_INTEGER']],
    'AvailablePages' : [ 0x10, ['unsigned long']],
    'ModifiedPagesTotal' : [ 0x14, ['unsigned long']],
    'ModifiedPagefilePages' : [ 0x18, ['unsigned long']],
    'ModifiedNoWritePages' : [ 0x1c, ['unsigned long']],
    'MdlHack' : [ 0x20, ['__unnamed_14d9']],
} ],
  '_HHIVE' : [ 0x2e8, {
    'Signature' : [ 0x0, ['unsigned long']],
    'GetCellRoutine' : [ 0x4, ['pointer', ['void']]],
    'ReleaseCellRoutine' : [ 0x8, ['pointer', ['void']]],
    'Allocate' : [ 0xc, ['pointer', ['void']]],
    'Free' : [ 0x10, ['pointer', ['void']]],
    'FileSetSize' : [ 0x14, ['pointer', ['void']]],
    'FileWrite' : [ 0x18, ['pointer', ['void']]],
    'FileRead' : [ 0x1c, ['pointer', ['void']]],
    'FileFlush' : [ 0x20, ['pointer', ['void']]],
    'BaseBlock' : [ 0x24, ['pointer', ['_HBASE_BLOCK']]],
    'DirtyVector' : [ 0x28, ['_RTL_BITMAP']],
    'DirtyCount' : [ 0x30, ['unsigned long']],
    'DirtyAlloc' : [ 0x34, ['unsigned long']],
    'BaseBlockAlloc' : [ 0x38, ['unsigned long']],
    'Cluster' : [ 0x3c, ['unsigned long']],
    'Flat' : [ 0x40, ['unsigned char']],
    'ReadOnly' : [ 0x41, ['unsigned char']],
    'DirtyFlag' : [ 0x42, ['unsigned char']],
    'HvBinHeadersUse' : [ 0x44, ['unsigned long']],
    'HvFreeCellsUse' : [ 0x48, ['unsigned long']],
    'HvUsedCellsUse' : [ 0x4c, ['unsigned long']],
    'CmUsedCellsUse' : [ 0x50, ['unsigned long']],
    'HiveFlags' : [ 0x54, ['unsigned long']],
    'CurrentLog' : [ 0x58, ['unsigned long']],
    'LogSize' : [ 0x5c, ['array', 2, ['unsigned long']]],
    'RefreshCount' : [ 0x64, ['unsigned long']],
    'StorageTypeCount' : [ 0x68, ['unsigned long']],
    'Version' : [ 0x6c, ['unsigned long']],
    'Storage' : [ 0x70, ['array', 2, ['_DUAL']]],
} ],
  '_iobuf' : [ 0x20, {
    '_ptr' : [ 0x0, ['pointer', ['unsigned char']]],
    '_cnt' : [ 0x4, ['long']],
    '_base' : [ 0x8, ['pointer', ['unsigned char']]],
    '_flag' : [ 0xc, ['long']],
    '_file' : [ 0x10, ['long']],
    '_charbuf' : [ 0x14, ['long']],
    '_bufsiz' : [ 0x18, ['long']],
    '_tmpfname' : [ 0x1c, ['pointer', ['unsigned char']]],
} ],
  '_CM_VIEW_OF_FILE' : [ 0x30, {
    'MappedViewLinks' : [ 0x0, ['_LIST_ENTRY']],
    'PinnedViewLinks' : [ 0x8, ['_LIST_ENTRY']],
    'FlushedViewLinks' : [ 0x10, ['_LIST_ENTRY']],
    'CmHive' : [ 0x18, ['pointer', ['_CMHIVE']]],
    'Bcb' : [ 0x1c, ['pointer', ['void']]],
    'ViewAddress' : [ 0x20, ['pointer', ['void']]],
    'FileOffset' : [ 0x24, ['unsigned long']],
    'Size' : [ 0x28, ['unsigned long']],
    'UseCount' : [ 0x2c, ['unsigned long']],
} ],
  '_TEB' : [ 0xff8, {
    'NtTib' : [ 0x0, ['_NT_TIB']],
    'EnvironmentPointer' : [ 0x1c, ['pointer', ['void']]],
    'ClientId' : [ 0x20, ['_CLIENT_ID']],
    'ActiveRpcHandle' : [ 0x28, ['pointer', ['void']]],
    'ThreadLocalStoragePointer' : [ 0x2c, ['pointer', ['void']]],
    'ProcessEnvironmentBlock' : [ 0x30, ['pointer', ['_PEB']]],
    'LastErrorValue' : [ 0x34, ['unsigned long']],
    'CountOfOwnedCriticalSections' : [ 0x38, ['unsigned long']],
    'CsrClientThread' : [ 0x3c, ['pointer', ['void']]],
    'Win32ThreadInfo' : [ 0x40, ['pointer', ['void']]],
    'User32Reserved' : [ 0x44, ['array', 26, ['unsigned long']]],
    'UserReserved' : [ 0xac, ['array', 5, ['unsigned long']]],
    'WOW32Reserved' : [ 0xc0, ['pointer', ['void']]],
    'CurrentLocale' : [ 0xc4, ['unsigned long']],
    'FpSoftwareStatusRegister' : [ 0xc8, ['unsigned long']],
    'SystemReserved1' : [ 0xcc, ['array', 54, ['pointer', ['void']]]],
    'ExceptionCode' : [ 0x1a4, ['long']],
    'ActivationContextStackPointer' : [ 0x1a8, ['pointer', ['_ACTIVATION_CONTEXT_STACK']]],
    'SpareBytes1' : [ 0x1ac, ['array', 36, ['unsigned char']]],
    'TxFsContext' : [ 0x1d0, ['unsigned long']],
    'GdiTebBatch' : [ 0x1d4, ['_GDI_TEB_BATCH']],
    'RealClientId' : [ 0x6b4, ['_CLIENT_ID']],
    'GdiCachedProcessHandle' : [ 0x6bc, ['pointer', ['void']]],
    'GdiClientPID' : [ 0x6c0, ['unsigned long']],
    'GdiClientTID' : [ 0x6c4, ['unsigned long']],
    'GdiThreadLocalInfo' : [ 0x6c8, ['pointer', ['void']]],
    'Win32ClientInfo' : [ 0x6cc, ['array', 62, ['unsigned long']]],
    'glDispatchTable' : [ 0x7c4, ['array', 233, ['pointer', ['void']]]],
    'glReserved1' : [ 0xb68, ['array', 29, ['unsigned long']]],
    'glReserved2' : [ 0xbdc, ['pointer', ['void']]],
    'glSectionInfo' : [ 0xbe0, ['pointer', ['void']]],
    'glSection' : [ 0xbe4, ['pointer', ['void']]],
    'glTable' : [ 0xbe8, ['pointer', ['void']]],
    'glCurrentRC' : [ 0xbec, ['pointer', ['void']]],
    'glContext' : [ 0xbf0, ['pointer', ['void']]],
    'LastStatusValue' : [ 0xbf4, ['unsigned long']],
    'StaticUnicodeString' : [ 0xbf8, ['_UNICODE_STRING']],
    'StaticUnicodeBuffer' : [ 0xc00, ['array', 261, ['wchar']]],
    'DeallocationStack' : [ 0xe0c, ['pointer', ['void']]],
    'TlsSlots' : [ 0xe10, ['array', 64, ['pointer', ['void']]]],
    'TlsLinks' : [ 0xf10, ['_LIST_ENTRY']],
    'Vdm' : [ 0xf18, ['pointer', ['void']]],
    'ReservedForNtRpc' : [ 0xf1c, ['pointer', ['void']]],
    'DbgSsReserved' : [ 0xf20, ['array', 2, ['pointer', ['void']]]],
    'HardErrorMode' : [ 0xf28, ['unsigned long']],
    'Instrumentation' : [ 0xf2c, ['array', 9, ['pointer', ['void']]]],
    'ActivityId' : [ 0xf50, ['_GUID']],
    'SubProcessTag' : [ 0xf60, ['pointer', ['void']]],
    'EtwLocalData' : [ 0xf64, ['pointer', ['void']]],
    'EtwTraceData' : [ 0xf68, ['pointer', ['void']]],
    'WinSockData' : [ 0xf6c, ['pointer', ['void']]],
    'GdiBatchCount' : [ 0xf70, ['unsigned long']],
    'SpareBool0' : [ 0xf74, ['unsigned char']],
    'SpareBool1' : [ 0xf75, ['unsigned char']],
    'SpareBool2' : [ 0xf76, ['unsigned char']],
    'IdealProcessor' : [ 0xf77, ['unsigned char']],
    'GuaranteedStackBytes' : [ 0xf78, ['unsigned long']],
    'ReservedForPerf' : [ 0xf7c, ['pointer', ['void']]],
    'ReservedForOle' : [ 0xf80, ['pointer', ['void']]],
    'WaitingOnLoaderLock' : [ 0xf84, ['unsigned long']],
    'SavedPriorityState' : [ 0xf88, ['pointer', ['void']]],
    'SoftPatchPtr1' : [ 0xf8c, ['unsigned long']],
    'ThreadPoolData' : [ 0xf90, ['pointer', ['void']]],
    'TlsExpansionSlots' : [ 0xf94, ['pointer', ['pointer', ['void']]]],
    'ImpersonationLocale' : [ 0xf98, ['unsigned long']],
    'IsImpersonating' : [ 0xf9c, ['unsigned long']],
    'NlsCache' : [ 0xfa0, ['pointer', ['void']]],
    'pShimData' : [ 0xfa4, ['pointer', ['void']]],
    'HeapVirtualAffinity' : [ 0xfa8, ['unsigned long']],
    'CurrentTransactionHandle' : [ 0xfac, ['pointer', ['void']]],
    'ActiveFrame' : [ 0xfb0, ['pointer', ['_TEB_ACTIVE_FRAME']]],
    'FlsData' : [ 0xfb4, ['pointer', ['void']]],
    'PreferredLanguages' : [ 0xfb8, ['pointer', ['void']]],
    'UserPrefLanguages' : [ 0xfbc, ['pointer', ['void']]],
    'MergedPrefLanguages' : [ 0xfc0, ['pointer', ['void']]],
    'MuiImpersonation' : [ 0xfc4, ['unsigned long']],
    'CrossTebFlags' : [ 0xfc8, ['unsigned short']],
    'SpareCrossTebBits' : [ 0xfc8, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned short')]],
    'SameTebFlags' : [ 0xfca, ['unsigned short']],
    'DbgSafeThunkCall' : [ 0xfca, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'DbgInDebugPrint' : [ 0xfca, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'DbgHasFiberData' : [ 0xfca, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned short')]],
    'DbgSkipThreadAttach' : [ 0xfca, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned short')]],
    'DbgWerInShipAssertCode' : [ 0xfca, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned short')]],
    'DbgRanProcessInit' : [ 0xfca, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned short')]],
    'DbgClonedThread' : [ 0xfca, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned short')]],
    'DbgSuppressDebugMsg' : [ 0xfca, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned short')]],
    'RtlDisableUserStackWalk' : [ 0xfca, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned short')]],
    'RtlExceptionAttached' : [ 0xfca, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned short')]],
    'SpareSameTebBits' : [ 0xfca, ['BitField', dict(start_bit = 10, end_bit = 16, native_type='unsigned short')]],
    'TxnScopeEnterCallback' : [ 0xfcc, ['pointer', ['void']]],
    'TxnScopeExitCallback' : [ 0xfd0, ['pointer', ['void']]],
    'TxnScopeContext' : [ 0xfd4, ['pointer', ['void']]],
    'LockCount' : [ 0xfd8, ['unsigned long']],
    'ProcessRundown' : [ 0xfdc, ['unsigned long']],
    'LastSwitchTime' : [ 0xfe0, ['unsigned long long']],
    'TotalSwitchOutTime' : [ 0xfe8, ['unsigned long long']],
    'WaitReasonBitMap' : [ 0xff0, ['_LARGE_INTEGER']],
} ],
  '_KTIMER' : [ 0x28, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'DueTime' : [ 0x10, ['_ULARGE_INTEGER']],
    'TimerListEntry' : [ 0x18, ['_LIST_ENTRY']],
    'Dpc' : [ 0x20, ['pointer', ['_KDPC']]],
    'Period' : [ 0x24, ['long']],
} ],
  '_KEVENT' : [ 0x10, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
} ],
  '_KLOCK_QUEUE_HANDLE' : [ 0xc, {
    'LockQueue' : [ 0x0, ['_KSPIN_LOCK_QUEUE']],
    'OldIrql' : [ 0x8, ['unsigned char']],
} ],
  '_KSPIN_LOCK_QUEUE' : [ 0x8, {
    'Next' : [ 0x0, ['pointer', ['_KSPIN_LOCK_QUEUE']]],
    'Lock' : [ 0x4, ['pointer', ['unsigned long']]],
} ],
  '_KQUEUE' : [ 0x28, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'EntryListHead' : [ 0x10, ['_LIST_ENTRY']],
    'CurrentCount' : [ 0x18, ['unsigned long']],
    'MaximumCount' : [ 0x1c, ['unsigned long']],
    'ThreadListHead' : [ 0x20, ['_LIST_ENTRY']],
} ],
  '_KWAIT_BLOCK' : [ 0x18, {
    'WaitListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Thread' : [ 0x8, ['pointer', ['_KTHREAD']]],
    'Object' : [ 0xc, ['pointer', ['void']]],
    'NextWaitBlock' : [ 0x10, ['pointer', ['_KWAIT_BLOCK']]],
    'WaitKey' : [ 0x14, ['unsigned short']],
    'WaitType' : [ 0x16, ['unsigned char']],
    'SpareByte' : [ 0x17, ['unsigned char']],
} ],
  '_KTIMER_TABLE_ENTRY' : [ 0x10, {
    'Entry' : [ 0x0, ['_LIST_ENTRY']],
    'Time' : [ 0x8, ['_ULARGE_INTEGER']],
} ],
  '__unnamed_15ab' : [ 0x8, {
    'IdleTransitionTime' : [ 0x0, ['unsigned long long']],
} ],
  '__unnamed_15ad' : [ 0x8, {
    'LastIdleCheck' : [ 0x0, ['unsigned long long']],
} ],
  '__unnamed_15b4' : [ 0x2, {
    'AsUSHORT' : [ 0x0, ['unsigned short']],
    'PStateDomain' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'PStateDomainIdleAccounting' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 16, native_type='unsigned short')]],
} ],
  '_PROCESSOR_POWER_STATE' : [ 0xc8, {
    'IdleStates' : [ 0x0, ['pointer', ['_PPM_IDLE_STATES']]],
    'LastTimeCheck' : [ 0x8, ['unsigned long long']],
    'IdleTimeAccumulated' : [ 0x10, ['unsigned long long']],
    'Native' : [ 0x18, ['__unnamed_15ab']],
    'Hv' : [ 0x18, ['__unnamed_15ad']],
    'IdleAccounting' : [ 0x20, ['pointer', ['PPM_IDLE_ACCOUNTING']]],
    'PerfStates' : [ 0x24, ['pointer', ['_PPM_PERF_STATES']]],
    'LastKernelUserTime' : [ 0x28, ['unsigned long']],
    'LastIdleThreadKTime' : [ 0x2c, ['unsigned long']],
    'LastGlobalTimeHv' : [ 0x30, ['unsigned long long']],
    'LastProcessorTimeHv' : [ 0x38, ['unsigned long long']],
    'ThermalConstraint' : [ 0x40, ['unsigned char']],
    'LastBusyPercentage' : [ 0x41, ['unsigned char']],
    'Flags' : [ 0x42, ['__unnamed_15b4']],
    'PerfTimer' : [ 0x48, ['_KTIMER']],
    'PerfDpc' : [ 0x70, ['_KDPC']],
    'LastSysTime' : [ 0x90, ['unsigned long']],
    'PStateMaster' : [ 0x94, ['pointer', ['_KPRCB']]],
    'PStateSet' : [ 0x98, ['unsigned long']],
    'CurrentPState' : [ 0x9c, ['unsigned long']],
    'DesiredPState' : [ 0xa0, ['unsigned long']],
    'PStateIdleStartTime' : [ 0xa4, ['unsigned long']],
    'PStateIdleTime' : [ 0xa8, ['unsigned long']],
    'LastPStateIdleTime' : [ 0xac, ['unsigned long']],
    'PStateStartTime' : [ 0xb0, ['unsigned long']],
    'DiaIndex' : [ 0xb4, ['unsigned long']],
    'Reserved0' : [ 0xb8, ['unsigned long']],
    'WmiDispatchPtr' : [ 0xbc, ['unsigned long']],
    'WmiInterfaceEnabled' : [ 0xc0, ['long']],
} ],
  '__unnamed_15bb' : [ 0x208, {
    'FnArea' : [ 0x0, ['_FNSAVE_FORMAT']],
    'FxArea' : [ 0x0, ['_FXSAVE_FORMAT']],
} ],
  '_FX_SAVE_AREA' : [ 0x210, {
    'U' : [ 0x0, ['__unnamed_15bb']],
    'NpxSavedCpu' : [ 0x208, ['unsigned long']],
    'Cr0NpxState' : [ 0x20c, ['unsigned long']],
} ],
  '_KERNEL_STACK_CONTROL' : [ 0x1c, {
    'PreviousTrapFrame' : [ 0x0, ['pointer', ['_KTRAP_FRAME']]],
    'PreviousExceptionList' : [ 0x0, ['pointer', ['void']]],
    'StackControlFlags' : [ 0x4, ['unsigned long']],
    'PreviousLargeStack' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'PreviousSegmentsPresent' : [ 0x4, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ExpandCalloutStack' : [ 0x4, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'Previous' : [ 0x8, ['_KERNEL_STACK_SEGMENT']],
} ],
  '_PNP_DEVICE_COMPLETION_QUEUE' : [ 0x2c, {
    'SpinLock' : [ 0x0, ['unsigned long']],
    'DispatchedCount' : [ 0x4, ['unsigned long']],
    'DispatchedList' : [ 0x8, ['_LIST_ENTRY']],
    'CompletedSemaphore' : [ 0x10, ['_KSEMAPHORE']],
    'CompletedList' : [ 0x24, ['_LIST_ENTRY']],
} ],
  '__unnamed_15e4' : [ 0x28, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Wcb' : [ 0x0, ['_WAIT_CONTEXT_BLOCK']],
} ],
  '_DEVICE_OBJECT' : [ 0xb8, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['unsigned short']],
    'ReferenceCount' : [ 0x4, ['long']],
    'DriverObject' : [ 0x8, ['pointer', ['_DRIVER_OBJECT']]],
    'NextDevice' : [ 0xc, ['pointer', ['_DEVICE_OBJECT']]],
    'AttachedDevice' : [ 0x10, ['pointer', ['_DEVICE_OBJECT']]],
    'CurrentIrp' : [ 0x14, ['pointer', ['_IRP']]],
    'Timer' : [ 0x18, ['pointer', ['_IO_TIMER']]],
    'Flags' : [ 0x1c, ['unsigned long']],
    'Characteristics' : [ 0x20, ['unsigned long']],
    'Vpb' : [ 0x24, ['pointer', ['_VPB']]],
    'DeviceExtension' : [ 0x28, ['pointer', ['void']]],
    'DeviceType' : [ 0x2c, ['unsigned long']],
    'StackSize' : [ 0x30, ['unsigned char']],
    'Queue' : [ 0x34, ['__unnamed_15e4']],
    'AlignmentRequirement' : [ 0x5c, ['unsigned long']],
    'DeviceQueue' : [ 0x60, ['_KDEVICE_QUEUE']],
    'Dpc' : [ 0x74, ['_KDPC']],
    'ActiveThreadCount' : [ 0x94, ['unsigned long']],
    'SecurityDescriptor' : [ 0x98, ['pointer', ['void']]],
    'DeviceLock' : [ 0x9c, ['_KEVENT']],
    'SectorSize' : [ 0xac, ['unsigned short']],
    'Spare1' : [ 0xae, ['unsigned short']],
    'DeviceObjectExtension' : [ 0xb0, ['pointer', ['_DEVOBJ_EXTENSION']]],
    'Reserved' : [ 0xb4, ['pointer', ['void']]],
} ],
  '__unnamed_15f6' : [ 0x4, {
    'LegacyDeviceNode' : [ 0x0, ['pointer', ['_DEVICE_NODE']]],
    'PendingDeviceRelations' : [ 0x0, ['pointer', ['_DEVICE_RELATIONS']]],
    'Information' : [ 0x0, ['pointer', ['void']]],
} ],
  '__unnamed_15f8' : [ 0x4, {
    'NextResourceDeviceNode' : [ 0x0, ['pointer', ['_DEVICE_NODE']]],
} ],
  '__unnamed_15fc' : [ 0x10, {
    'DockStatus' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'DOCK_NOTDOCKDEVICE', 1: 'DOCK_QUIESCENT', 2: 'DOCK_ARRIVING', 3: 'DOCK_DEPARTING', 4: 'DOCK_EJECTIRP_COMPLETED'})]],
    'ListEntry' : [ 0x4, ['_LIST_ENTRY']],
    'SerialNumber' : [ 0xc, ['pointer', ['unsigned short']]],
} ],
  '_DEVICE_NODE' : [ 0x158, {
    'Sibling' : [ 0x0, ['pointer', ['_DEVICE_NODE']]],
    'Child' : [ 0x4, ['pointer', ['_DEVICE_NODE']]],
    'Parent' : [ 0x8, ['pointer', ['_DEVICE_NODE']]],
    'LastChild' : [ 0xc, ['pointer', ['_DEVICE_NODE']]],
    'Level' : [ 0x10, ['unsigned long']],
    'Notify' : [ 0x14, ['_PO_DEVICE_NOTIFY']],
    'PoIrpManager' : [ 0x38, ['_PO_IRP_MANAGER']],
    'State' : [ 0x48, ['Enumeration', dict(target = 'long', choices = {768: 'DeviceNodeUnspecified', 769: 'DeviceNodeUninitialized', 770: 'DeviceNodeInitialized', 771: 'DeviceNodeDriversAdded', 772: 'DeviceNodeResourcesAssigned', 773: 'DeviceNodeStartPending', 774: 'DeviceNodeStartCompletion', 775: 'DeviceNodeStartPostWork', 776: 'DeviceNodeStarted', 777: 'DeviceNodeQueryStopped', 778: 'DeviceNodeStopped', 779: 'DeviceNodeRestartCompletion', 780: 'DeviceNodeEnumeratePending', 781: 'DeviceNodeEnumerateCompletion', 782: 'DeviceNodeAwaitingQueuedDeletion', 783: 'DeviceNodeAwaitingQueuedRemoval', 784: 'DeviceNodeQueryRemoved', 785: 'DeviceNodeRemovePendingCloses', 786: 'DeviceNodeRemoved', 787: 'DeviceNodeDeletePendingCloses', 788: 'DeviceNodeDeleted', 789: 'MaxDeviceNodeState'})]],
    'PreviousState' : [ 0x4c, ['Enumeration', dict(target = 'long', choices = {768: 'DeviceNodeUnspecified', 769: 'DeviceNodeUninitialized', 770: 'DeviceNodeInitialized', 771: 'DeviceNodeDriversAdded', 772: 'DeviceNodeResourcesAssigned', 773: 'DeviceNodeStartPending', 774: 'DeviceNodeStartCompletion', 775: 'DeviceNodeStartPostWork', 776: 'DeviceNodeStarted', 777: 'DeviceNodeQueryStopped', 778: 'DeviceNodeStopped', 779: 'DeviceNodeRestartCompletion', 780: 'DeviceNodeEnumeratePending', 781: 'DeviceNodeEnumerateCompletion', 782: 'DeviceNodeAwaitingQueuedDeletion', 783: 'DeviceNodeAwaitingQueuedRemoval', 784: 'DeviceNodeQueryRemoved', 785: 'DeviceNodeRemovePendingCloses', 786: 'DeviceNodeRemoved', 787: 'DeviceNodeDeletePendingCloses', 788: 'DeviceNodeDeleted', 789: 'MaxDeviceNodeState'})]],
    'StateHistory' : [ 0x50, ['array', -80, ['Enumeration', dict(target = 'long', choices = {768: 'DeviceNodeUnspecified', 769: 'DeviceNodeUninitialized', 770: 'DeviceNodeInitialized', 771: 'DeviceNodeDriversAdded', 772: 'DeviceNodeResourcesAssigned', 773: 'DeviceNodeStartPending', 774: 'DeviceNodeStartCompletion', 775: 'DeviceNodeStartPostWork', 776: 'DeviceNodeStarted', 777: 'DeviceNodeQueryStopped', 778: 'DeviceNodeStopped', 779: 'DeviceNodeRestartCompletion', 780: 'DeviceNodeEnumeratePending', 781: 'DeviceNodeEnumerateCompletion', 782: 'DeviceNodeAwaitingQueuedDeletion', 783: 'DeviceNodeAwaitingQueuedRemoval', 784: 'DeviceNodeQueryRemoved', 785: 'DeviceNodeRemovePendingCloses', 786: 'DeviceNodeRemoved', 787: 'DeviceNodeDeletePendingCloses', 788: 'DeviceNodeDeleted', 789: 'MaxDeviceNodeState'})]]],
    'StateHistoryEntry' : [ 0xa0, ['unsigned long']],
    'CompletionStatus' : [ 0xa4, ['long']],
    'PendingIrp' : [ 0xa8, ['pointer', ['_IRP']]],
    'Flags' : [ 0xac, ['unsigned long']],
    'UserFlags' : [ 0xb0, ['unsigned long']],
    'Problem' : [ 0xb4, ['unsigned long']],
    'PhysicalDeviceObject' : [ 0xb8, ['pointer', ['_DEVICE_OBJECT']]],
    'ResourceList' : [ 0xbc, ['pointer', ['_CM_RESOURCE_LIST']]],
    'ResourceListTranslated' : [ 0xc0, ['pointer', ['_CM_RESOURCE_LIST']]],
    'InstancePath' : [ 0xc4, ['_UNICODE_STRING']],
    'ServiceName' : [ 0xcc, ['_UNICODE_STRING']],
    'DuplicatePDO' : [ 0xd4, ['pointer', ['_DEVICE_OBJECT']]],
    'ResourceRequirements' : [ 0xd8, ['pointer', ['_IO_RESOURCE_REQUIREMENTS_LIST']]],
    'InterfaceType' : [ 0xdc, ['Enumeration', dict(target = 'long', choices = {0: 'Internal', 1: 'Isa', 2: 'Eisa', 3: 'MicroChannel', 4: 'TurboChannel', 5: 'PCIBus', 6: 'VMEBus', 7: 'NuBus', 8: 'PCMCIABus', 9: 'CBus', 10: 'MPIBus', 11: 'MPSABus', 12: 'ProcessorInternal', 13: 'InternalPowerBus', 14: 'PNPISABus', 15: 'PNPBus', 16: 'Vmcs', 17: 'MaximumInterfaceType', -1: 'InterfaceTypeUndefined'})]],
    'BusNumber' : [ 0xe0, ['unsigned long']],
    'ChildInterfaceType' : [ 0xe4, ['Enumeration', dict(target = 'long', choices = {0: 'Internal', 1: 'Isa', 2: 'Eisa', 3: 'MicroChannel', 4: 'TurboChannel', 5: 'PCIBus', 6: 'VMEBus', 7: 'NuBus', 8: 'PCMCIABus', 9: 'CBus', 10: 'MPIBus', 11: 'MPSABus', 12: 'ProcessorInternal', 13: 'InternalPowerBus', 14: 'PNPISABus', 15: 'PNPBus', 16: 'Vmcs', 17: 'MaximumInterfaceType', -1: 'InterfaceTypeUndefined'})]],
    'ChildBusNumber' : [ 0xe8, ['unsigned long']],
    'ChildBusTypeIndex' : [ 0xec, ['unsigned short']],
    'RemovalPolicy' : [ 0xee, ['unsigned char']],
    'HardwareRemovalPolicy' : [ 0xef, ['unsigned char']],
    'TargetDeviceNotify' : [ 0xf0, ['_LIST_ENTRY']],
    'DeviceArbiterList' : [ 0xf8, ['_LIST_ENTRY']],
    'DeviceTranslatorList' : [ 0x100, ['_LIST_ENTRY']],
    'NoTranslatorMask' : [ 0x108, ['unsigned short']],
    'QueryTranslatorMask' : [ 0x10a, ['unsigned short']],
    'NoArbiterMask' : [ 0x10c, ['unsigned short']],
    'QueryArbiterMask' : [ 0x10e, ['unsigned short']],
    'OverUsed1' : [ 0x110, ['__unnamed_15f6']],
    'OverUsed2' : [ 0x114, ['__unnamed_15f8']],
    'BootResources' : [ 0x118, ['pointer', ['_CM_RESOURCE_LIST']]],
    'BootResourcesTranslated' : [ 0x11c, ['pointer', ['_CM_RESOURCE_LIST']]],
    'CapabilityFlags' : [ 0x120, ['unsigned long']],
    'DockInfo' : [ 0x124, ['__unnamed_15fc']],
    'DisableableDepends' : [ 0x134, ['unsigned long']],
    'PendedSetInterfaceState' : [ 0x138, ['_LIST_ENTRY']],
    'LegacyBusListEntry' : [ 0x140, ['_LIST_ENTRY']],
    'DriverUnloadRetryCount' : [ 0x148, ['unsigned long']],
    'PreviousParent' : [ 0x14c, ['pointer', ['_DEVICE_NODE']]],
    'DeletedChildren' : [ 0x150, ['unsigned long']],
    'NumaNodeIndex' : [ 0x154, ['unsigned long']],
} ],
  '_PNP_ASSIGN_RESOURCES_CONTEXT' : [ 0xc, {
    'IncludeFailedDevices' : [ 0x0, ['unsigned long']],
    'DeviceCount' : [ 0x4, ['unsigned long']],
    'DeviceList' : [ 0x8, ['array', 1, ['pointer', ['_DEVICE_OBJECT']]]],
} ],
  '_PNP_RESOURCE_REQUEST' : [ 0x28, {
    'PhysicalDevice' : [ 0x0, ['pointer', ['_DEVICE_OBJECT']]],
    'Flags' : [ 0x4, ['unsigned long']],
    'AllocationType' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: 'ArbiterRequestLegacyReported', 1: 'ArbiterRequestHalReported', 2: 'ArbiterRequestLegacyAssigned', 3: 'ArbiterRequestPnpDetected', 4: 'ArbiterRequestPnpEnumerated', -1: 'ArbiterRequestUndefined'})]],
    'Priority' : [ 0xc, ['unsigned long']],
    'Position' : [ 0x10, ['unsigned long']],
    'ResourceRequirements' : [ 0x14, ['pointer', ['_IO_RESOURCE_REQUIREMENTS_LIST']]],
    'ReqList' : [ 0x18, ['pointer', ['void']]],
    'ResourceAssignment' : [ 0x1c, ['pointer', ['_CM_RESOURCE_LIST']]],
    'TranslatedResourceAssignment' : [ 0x20, ['pointer', ['_CM_RESOURCE_LIST']]],
    'Status' : [ 0x24, ['long']],
} ],
  '_IO_RESOURCE_REQUIREMENTS_LIST' : [ 0x48, {
    'ListSize' : [ 0x0, ['unsigned long']],
    'InterfaceType' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'Internal', 1: 'Isa', 2: 'Eisa', 3: 'MicroChannel', 4: 'TurboChannel', 5: 'PCIBus', 6: 'VMEBus', 7: 'NuBus', 8: 'PCMCIABus', 9: 'CBus', 10: 'MPIBus', 11: 'MPSABus', 12: 'ProcessorInternal', 13: 'InternalPowerBus', 14: 'PNPISABus', 15: 'PNPBus', 16: 'Vmcs', 17: 'MaximumInterfaceType', -1: 'InterfaceTypeUndefined'})]],
    'BusNumber' : [ 0x8, ['unsigned long']],
    'SlotNumber' : [ 0xc, ['unsigned long']],
    'Reserved' : [ 0x10, ['array', 3, ['unsigned long']]],
    'AlternativeLists' : [ 0x1c, ['unsigned long']],
    'List' : [ 0x20, ['array', 1, ['_IO_RESOURCE_LIST']]],
} ],
  '_EXCEPTION_RECORD64' : [ 0x98, {
    'ExceptionCode' : [ 0x0, ['long']],
    'ExceptionFlags' : [ 0x4, ['unsigned long']],
    'ExceptionRecord' : [ 0x8, ['unsigned long long']],
    'ExceptionAddress' : [ 0x10, ['unsigned long long']],
    'NumberParameters' : [ 0x18, ['unsigned long']],
    '__unusedAlignment' : [ 0x1c, ['unsigned long']],
    'ExceptionInformation' : [ 0x20, ['array', 15, ['unsigned long long']]],
} ],
  '_EXCEPTION_RECORD32' : [ 0x50, {
    'ExceptionCode' : [ 0x0, ['long']],
    'ExceptionFlags' : [ 0x4, ['unsigned long']],
    'ExceptionRecord' : [ 0x8, ['unsigned long']],
    'ExceptionAddress' : [ 0xc, ['unsigned long']],
    'NumberParameters' : [ 0x10, ['unsigned long']],
    'ExceptionInformation' : [ 0x14, ['array', 15, ['unsigned long']]],
} ],
  '_DBGKM_EXCEPTION64' : [ 0xa0, {
    'ExceptionRecord' : [ 0x0, ['_EXCEPTION_RECORD64']],
    'FirstChance' : [ 0x98, ['unsigned long']],
} ],
  '_DBGKM_EXCEPTION32' : [ 0x54, {
    'ExceptionRecord' : [ 0x0, ['_EXCEPTION_RECORD32']],
    'FirstChance' : [ 0x50, ['unsigned long']],
} ],
  '_DBGKD_LOAD_SYMBOLS64' : [ 0x28, {
    'PathNameLength' : [ 0x0, ['unsigned long']],
    'BaseOfDll' : [ 0x8, ['unsigned long long']],
    'ProcessId' : [ 0x10, ['unsigned long long']],
    'CheckSum' : [ 0x18, ['unsigned long']],
    'SizeOfImage' : [ 0x1c, ['unsigned long']],
    'UnloadSymbols' : [ 0x20, ['unsigned char']],
} ],
  '_DBGKD_LOAD_SYMBOLS32' : [ 0x18, {
    'PathNameLength' : [ 0x0, ['unsigned long']],
    'BaseOfDll' : [ 0x4, ['unsigned long']],
    'ProcessId' : [ 0x8, ['unsigned long']],
    'CheckSum' : [ 0xc, ['unsigned long']],
    'SizeOfImage' : [ 0x10, ['unsigned long']],
    'UnloadSymbols' : [ 0x14, ['unsigned char']],
} ],
  '_DBGKD_READ_MEMORY64' : [ 0x10, {
    'TargetBaseAddress' : [ 0x0, ['unsigned long long']],
    'TransferCount' : [ 0x8, ['unsigned long']],
    'ActualBytesRead' : [ 0xc, ['unsigned long']],
} ],
  '_DBGKD_READ_MEMORY32' : [ 0xc, {
    'TargetBaseAddress' : [ 0x0, ['unsigned long']],
    'TransferCount' : [ 0x4, ['unsigned long']],
    'ActualBytesRead' : [ 0x8, ['unsigned long']],
} ],
  '_DBGKD_WRITE_MEMORY64' : [ 0x10, {
    'TargetBaseAddress' : [ 0x0, ['unsigned long long']],
    'TransferCount' : [ 0x8, ['unsigned long']],
    'ActualBytesWritten' : [ 0xc, ['unsigned long']],
} ],
  '_DBGKD_WRITE_MEMORY32' : [ 0xc, {
    'TargetBaseAddress' : [ 0x0, ['unsigned long']],
    'TransferCount' : [ 0x4, ['unsigned long']],
    'ActualBytesWritten' : [ 0x8, ['unsigned long']],
} ],
  '_DBGKD_WRITE_BREAKPOINT64' : [ 0x10, {
    'BreakPointAddress' : [ 0x0, ['unsigned long long']],
    'BreakPointHandle' : [ 0x8, ['unsigned long']],
} ],
  '_DBGKD_WRITE_BREAKPOINT32' : [ 0x8, {
    'BreakPointAddress' : [ 0x0, ['unsigned long']],
    'BreakPointHandle' : [ 0x4, ['unsigned long']],
} ],
  '_DBGKD_READ_WRITE_IO64' : [ 0x10, {
    'IoAddress' : [ 0x0, ['unsigned long long']],
    'DataSize' : [ 0x8, ['unsigned long']],
    'DataValue' : [ 0xc, ['unsigned long']],
} ],
  '_DBGKD_READ_WRITE_IO32' : [ 0xc, {
    'DataSize' : [ 0x0, ['unsigned long']],
    'IoAddress' : [ 0x4, ['unsigned long']],
    'DataValue' : [ 0x8, ['unsigned long']],
} ],
  '_DBGKD_READ_WRITE_IO_EXTENDED64' : [ 0x20, {
    'DataSize' : [ 0x0, ['unsigned long']],
    'InterfaceType' : [ 0x4, ['unsigned long']],
    'BusNumber' : [ 0x8, ['unsigned long']],
    'AddressSpace' : [ 0xc, ['unsigned long']],
    'IoAddress' : [ 0x10, ['unsigned long long']],
    'DataValue' : [ 0x18, ['unsigned long']],
} ],
  '_DBGKD_READ_WRITE_IO_EXTENDED32' : [ 0x18, {
    'DataSize' : [ 0x0, ['unsigned long']],
    'InterfaceType' : [ 0x4, ['unsigned long']],
    'BusNumber' : [ 0x8, ['unsigned long']],
    'AddressSpace' : [ 0xc, ['unsigned long']],
    'IoAddress' : [ 0x10, ['unsigned long']],
    'DataValue' : [ 0x14, ['unsigned long']],
} ],
  '_DBGKD_SET_SPECIAL_CALL32' : [ 0x4, {
    'SpecialCall' : [ 0x0, ['unsigned long']],
} ],
  '_DBGKD_SET_SPECIAL_CALL64' : [ 0x8, {
    'SpecialCall' : [ 0x0, ['unsigned long long']],
} ],
  '_DBGKD_SET_INTERNAL_BREAKPOINT32' : [ 0x8, {
    'BreakpointAddress' : [ 0x0, ['unsigned long']],
    'Flags' : [ 0x4, ['unsigned long']],
} ],
  '_DBGKD_SET_INTERNAL_BREAKPOINT64' : [ 0x10, {
    'BreakpointAddress' : [ 0x0, ['unsigned long long']],
    'Flags' : [ 0x8, ['unsigned long']],
} ],
  '_DBGKD_GET_INTERNAL_BREAKPOINT64' : [ 0x20, {
    'BreakpointAddress' : [ 0x0, ['unsigned long long']],
    'Flags' : [ 0x8, ['unsigned long']],
    'Calls' : [ 0xc, ['unsigned long']],
    'MaxCallsPerPeriod' : [ 0x10, ['unsigned long']],
    'MinInstructions' : [ 0x14, ['unsigned long']],
    'MaxInstructions' : [ 0x18, ['unsigned long']],
    'TotalInstructions' : [ 0x1c, ['unsigned long']],
} ],
  '_DBGKD_GET_INTERNAL_BREAKPOINT32' : [ 0x1c, {
    'BreakpointAddress' : [ 0x0, ['unsigned long']],
    'Flags' : [ 0x4, ['unsigned long']],
    'Calls' : [ 0x8, ['unsigned long']],
    'MaxCallsPerPeriod' : [ 0xc, ['unsigned long']],
    'MinInstructions' : [ 0x10, ['unsigned long']],
    'MaxInstructions' : [ 0x14, ['unsigned long']],
    'TotalInstructions' : [ 0x18, ['unsigned long']],
} ],
  '__unnamed_16a1' : [ 0x28, {
    'ReadMemory' : [ 0x0, ['_DBGKD_READ_MEMORY64']],
    'WriteMemory' : [ 0x0, ['_DBGKD_WRITE_MEMORY64']],
    'GetContext' : [ 0x0, ['_DBGKD_GET_CONTEXT']],
    'SetContext' : [ 0x0, ['_DBGKD_SET_CONTEXT']],
    'WriteBreakPoint' : [ 0x0, ['_DBGKD_WRITE_BREAKPOINT64']],
    'RestoreBreakPoint' : [ 0x0, ['_DBGKD_RESTORE_BREAKPOINT']],
    'Continue' : [ 0x0, ['_DBGKD_CONTINUE']],
    'Continue2' : [ 0x0, ['_DBGKD_CONTINUE2']],
    'ReadWriteIo' : [ 0x0, ['_DBGKD_READ_WRITE_IO64']],
    'ReadWriteIoExtended' : [ 0x0, ['_DBGKD_READ_WRITE_IO_EXTENDED64']],
    'QuerySpecialCalls' : [ 0x0, ['_DBGKD_QUERY_SPECIAL_CALLS']],
    'SetSpecialCall' : [ 0x0, ['_DBGKD_SET_SPECIAL_CALL64']],
    'SetInternalBreakpoint' : [ 0x0, ['_DBGKD_SET_INTERNAL_BREAKPOINT64']],
    'GetInternalBreakpoint' : [ 0x0, ['_DBGKD_GET_INTERNAL_BREAKPOINT64']],
    'GetVersion64' : [ 0x0, ['_DBGKD_GET_VERSION64']],
    'BreakPointEx' : [ 0x0, ['_DBGKD_BREAKPOINTEX']],
    'ReadWriteMsr' : [ 0x0, ['_DBGKD_READ_WRITE_MSR']],
    'SearchMemory' : [ 0x0, ['_DBGKD_SEARCH_MEMORY']],
    'GetSetBusData' : [ 0x0, ['_DBGKD_GET_SET_BUS_DATA']],
    'FillMemory' : [ 0x0, ['_DBGKD_FILL_MEMORY']],
    'QueryMemory' : [ 0x0, ['_DBGKD_QUERY_MEMORY']],
    'SwitchPartition' : [ 0x0, ['_DBGKD_SWITCH_PARTITION']],
} ],
  '_DBGKD_MANIPULATE_STATE64' : [ 0x38, {
    'ApiNumber' : [ 0x0, ['unsigned long']],
    'ProcessorLevel' : [ 0x4, ['unsigned short']],
    'Processor' : [ 0x6, ['unsigned short']],
    'ReturnStatus' : [ 0x8, ['long']],
    'u' : [ 0x10, ['__unnamed_16a1']],
} ],
  '__unnamed_16a8' : [ 0x28, {
    'ReadMemory' : [ 0x0, ['_DBGKD_READ_MEMORY32']],
    'WriteMemory' : [ 0x0, ['_DBGKD_WRITE_MEMORY32']],
    'ReadMemory64' : [ 0x0, ['_DBGKD_READ_MEMORY64']],
    'WriteMemory64' : [ 0x0, ['_DBGKD_WRITE_MEMORY64']],
    'GetContext' : [ 0x0, ['_DBGKD_GET_CONTEXT']],
    'SetContext' : [ 0x0, ['_DBGKD_SET_CONTEXT']],
    'WriteBreakPoint' : [ 0x0, ['_DBGKD_WRITE_BREAKPOINT32']],
    'RestoreBreakPoint' : [ 0x0, ['_DBGKD_RESTORE_BREAKPOINT']],
    'Continue' : [ 0x0, ['_DBGKD_CONTINUE']],
    'Continue2' : [ 0x0, ['_DBGKD_CONTINUE2']],
    'ReadWriteIo' : [ 0x0, ['_DBGKD_READ_WRITE_IO32']],
    'ReadWriteIoExtended' : [ 0x0, ['_DBGKD_READ_WRITE_IO_EXTENDED32']],
    'QuerySpecialCalls' : [ 0x0, ['_DBGKD_QUERY_SPECIAL_CALLS']],
    'SetSpecialCall' : [ 0x0, ['_DBGKD_SET_SPECIAL_CALL32']],
    'SetInternalBreakpoint' : [ 0x0, ['_DBGKD_SET_INTERNAL_BREAKPOINT32']],
    'GetInternalBreakpoint' : [ 0x0, ['_DBGKD_GET_INTERNAL_BREAKPOINT32']],
    'GetVersion32' : [ 0x0, ['_DBGKD_GET_VERSION32']],
    'BreakPointEx' : [ 0x0, ['_DBGKD_BREAKPOINTEX']],
    'ReadWriteMsr' : [ 0x0, ['_DBGKD_READ_WRITE_MSR']],
    'SearchMemory' : [ 0x0, ['_DBGKD_SEARCH_MEMORY']],
} ],
  '_DBGKD_MANIPULATE_STATE32' : [ 0x34, {
    'ApiNumber' : [ 0x0, ['unsigned long']],
    'ProcessorLevel' : [ 0x4, ['unsigned short']],
    'Processor' : [ 0x6, ['unsigned short']],
    'ReturnStatus' : [ 0x8, ['long']],
    'u' : [ 0xc, ['__unnamed_16a8']],
} ],
  '_POP_CPU_INFO' : [ 0x10, {
    'Eax' : [ 0x0, ['unsigned long']],
    'Ebx' : [ 0x4, ['unsigned long']],
    'Ecx' : [ 0x8, ['unsigned long']],
    'Edx' : [ 0xc, ['unsigned long']],
} ],
  '_VOLUME_CACHE_MAP' : [ 0x18, {
    'NodeTypeCode' : [ 0x0, ['short']],
    'NodeByteCode' : [ 0x2, ['short']],
    'UseCount' : [ 0x4, ['unsigned long']],
    'DeviceObject' : [ 0x8, ['pointer', ['_DEVICE_OBJECT']]],
    'VolumeCacheMapLinks' : [ 0xc, ['_LIST_ENTRY']],
    'Flags' : [ 0x14, ['unsigned long']],
} ],
  '_SHARED_CACHE_MAP' : [ 0x140, {
    'NodeTypeCode' : [ 0x0, ['short']],
    'NodeByteSize' : [ 0x2, ['short']],
    'OpenCount' : [ 0x4, ['unsigned long']],
    'FileSize' : [ 0x8, ['_LARGE_INTEGER']],
    'BcbList' : [ 0x10, ['_LIST_ENTRY']],
    'SectionSize' : [ 0x18, ['_LARGE_INTEGER']],
    'ValidDataLength' : [ 0x20, ['_LARGE_INTEGER']],
    'ValidDataGoal' : [ 0x28, ['_LARGE_INTEGER']],
    'InitialVacbs' : [ 0x30, ['array', 4, ['pointer', ['_VACB']]]],
    'Vacbs' : [ 0x40, ['pointer', ['pointer', ['_VACB']]]],
    'FileObjectFastRef' : [ 0x44, ['_EX_FAST_REF']],
    'ActiveVacb' : [ 0x48, ['pointer', ['_VACB']]],
    'NeedToZero' : [ 0x4c, ['pointer', ['void']]],
    'ActivePage' : [ 0x50, ['unsigned long']],
    'NeedToZeroPage' : [ 0x54, ['unsigned long']],
    'ActiveVacbSpinLock' : [ 0x58, ['unsigned long']],
    'VacbActiveCount' : [ 0x5c, ['unsigned long']],
    'DirtyPages' : [ 0x60, ['unsigned long']],
    'SharedCacheMapLinks' : [ 0x64, ['_LIST_ENTRY']],
    'Flags' : [ 0x6c, ['unsigned long']],
    'Status' : [ 0x70, ['long']],
    'Mbcb' : [ 0x74, ['pointer', ['_MBCB']]],
    'Section' : [ 0x78, ['pointer', ['void']]],
    'CreateEvent' : [ 0x7c, ['pointer', ['_KEVENT']]],
    'WaitOnActiveCount' : [ 0x80, ['pointer', ['_KEVENT']]],
    'PagesToWrite' : [ 0x84, ['unsigned long']],
    'BeyondLastFlush' : [ 0x88, ['long long']],
    'Callbacks' : [ 0x90, ['pointer', ['_CACHE_MANAGER_CALLBACKS']]],
    'LazyWriteContext' : [ 0x94, ['pointer', ['void']]],
    'PrivateList' : [ 0x98, ['_LIST_ENTRY']],
    'LogHandle' : [ 0xa0, ['pointer', ['void']]],
    'FlushToLsnRoutine' : [ 0xa4, ['pointer', ['void']]],
    'DirtyPageThreshold' : [ 0xa8, ['unsigned long']],
    'LazyWritePassCount' : [ 0xac, ['unsigned long']],
    'UninitializeEvent' : [ 0xb0, ['pointer', ['_CACHE_UNINITIALIZE_EVENT']]],
    'NeedToZeroVacb' : [ 0xb4, ['pointer', ['_VACB']]],
    'BcbSpinLock' : [ 0xb8, ['unsigned long']],
    'Reserved' : [ 0xbc, ['pointer', ['void']]],
    'Event' : [ 0xc0, ['_KEVENT']],
    'HighWaterMappingOffset' : [ 0xd0, ['_LARGE_INTEGER']],
    'PrivateCacheMap' : [ 0xd8, ['_PRIVATE_CACHE_MAP']],
    'WriteBehindWorkQueueEntry' : [ 0x130, ['pointer', ['void']]],
    'VolumeCacheMap' : [ 0x134, ['pointer', ['_VOLUME_CACHE_MAP']]],
    'ProcImagePathHash' : [ 0x138, ['unsigned long']],
    'MappedWritesInProgress' : [ 0x13c, ['unsigned long']],
} ],
  '__unnamed_16f0' : [ 0x8, {
    'FileOffset' : [ 0x0, ['_LARGE_INTEGER']],
    'ActiveCount' : [ 0x0, ['unsigned short']],
} ],
  '_VACB' : [ 0x20, {
    'BaseAddress' : [ 0x0, ['pointer', ['void']]],
    'SharedCacheMap' : [ 0x4, ['pointer', ['_SHARED_CACHE_MAP']]],
    'Overlay' : [ 0x8, ['__unnamed_16f0']],
    'LruList' : [ 0x10, ['_LIST_ENTRY']],
    'ArrayHead' : [ 0x18, ['pointer', ['_VACB_ARRAY_HEADER']]],
} ],
  '__unnamed_16fe' : [ 0x4, {
    'FileObject' : [ 0x0, ['pointer', ['_FILE_OBJECT']]],
} ],
  '__unnamed_1700' : [ 0x4, {
    'SharedCacheMap' : [ 0x0, ['pointer', ['_SHARED_CACHE_MAP']]],
} ],
  '__unnamed_1702' : [ 0x4, {
    'Event' : [ 0x0, ['pointer', ['_KEVENT']]],
} ],
  '__unnamed_1704' : [ 0x4, {
    'Reason' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_1706' : [ 0x4, {
    'Read' : [ 0x0, ['__unnamed_16fe']],
    'Write' : [ 0x0, ['__unnamed_1700']],
    'Event' : [ 0x0, ['__unnamed_1702']],
    'Notification' : [ 0x0, ['__unnamed_1704']],
} ],
  '_WORK_QUEUE_ENTRY' : [ 0x18, {
    'WorkQueueLinks' : [ 0x0, ['_LIST_ENTRY']],
    'CoalescedWorkQueueLinks' : [ 0x8, ['_LIST_ENTRY']],
    'Parameters' : [ 0x10, ['__unnamed_1706']],
    'Function' : [ 0x14, ['unsigned char']],
} ],
  '_VACB_LEVEL_REFERENCE' : [ 0x8, {
    'Reference' : [ 0x0, ['long']],
    'SpecialReference' : [ 0x4, ['long']],
} ],
  '_HEAP_LIST_LOOKUP' : [ 0x24, {
    'ExtendedLookup' : [ 0x0, ['pointer', ['_HEAP_LIST_LOOKUP']]],
    'ArraySize' : [ 0x4, ['unsigned long']],
    'ExtraItem' : [ 0x8, ['unsigned long']],
    'ItemCount' : [ 0xc, ['unsigned long']],
    'OutOfRangeItems' : [ 0x10, ['unsigned long']],
    'BaseIndex' : [ 0x14, ['unsigned long']],
    'ListHead' : [ 0x18, ['pointer', ['_LIST_ENTRY']]],
    'ListsInUseUlong' : [ 0x1c, ['pointer', ['unsigned long']]],
    'ListHints' : [ 0x20, ['pointer', ['pointer', ['_LIST_ENTRY']]]],
} ],
  '_HEAP' : [ 0x130, {
    'Entry' : [ 0x0, ['_HEAP_ENTRY']],
    'SegmentSignature' : [ 0x8, ['unsigned long']],
    'SegmentFlags' : [ 0xc, ['unsigned long']],
    'SegmentListEntry' : [ 0x10, ['_LIST_ENTRY']],
    'Heap' : [ 0x18, ['pointer', ['_HEAP']]],
    'BaseAddress' : [ 0x1c, ['pointer', ['void']]],
    'NumberOfPages' : [ 0x20, ['unsigned long']],
    'FirstEntry' : [ 0x24, ['pointer', ['_HEAP_ENTRY']]],
    'LastValidEntry' : [ 0x28, ['pointer', ['_HEAP_ENTRY']]],
    'NumberOfUnCommittedPages' : [ 0x2c, ['unsigned long']],
    'NumberOfUnCommittedRanges' : [ 0x30, ['unsigned long']],
    'SegmentAllocatorBackTraceIndex' : [ 0x34, ['unsigned short']],
    'Reserved' : [ 0x36, ['unsigned short']],
    'UCRSegmentList' : [ 0x38, ['_LIST_ENTRY']],
    'Flags' : [ 0x40, ['unsigned long']],
    'ForceFlags' : [ 0x44, ['unsigned long']],
    'CompatibilityFlags' : [ 0x48, ['unsigned long']],
    'EncodeFlagMask' : [ 0x4c, ['unsigned long']],
    'Encoding' : [ 0x50, ['_HEAP_ENTRY']],
    'PointerKey' : [ 0x58, ['unsigned long']],
    'Interceptor' : [ 0x5c, ['unsigned long']],
    'VirtualMemoryThreshold' : [ 0x60, ['unsigned long']],
    'Signature' : [ 0x64, ['unsigned long']],
    'SegmentReserve' : [ 0x68, ['unsigned long']],
    'SegmentCommit' : [ 0x6c, ['unsigned long']],
    'DeCommitFreeBlockThreshold' : [ 0x70, ['unsigned long']],
    'DeCommitTotalFreeThreshold' : [ 0x74, ['unsigned long']],
    'TotalFreeSize' : [ 0x78, ['unsigned long']],
    'MaximumAllocationSize' : [ 0x7c, ['unsigned long']],
    'ProcessHeapsListIndex' : [ 0x80, ['unsigned short']],
    'HeaderValidateLength' : [ 0x82, ['unsigned short']],
    'HeaderValidateCopy' : [ 0x84, ['pointer', ['void']]],
    'NextAvailableTagIndex' : [ 0x88, ['unsigned short']],
    'MaximumTagIndex' : [ 0x8a, ['unsigned short']],
    'TagEntries' : [ 0x8c, ['pointer', ['_HEAP_TAG_ENTRY']]],
    'UCRList' : [ 0x90, ['_LIST_ENTRY']],
    'AlignRound' : [ 0x98, ['unsigned long']],
    'AlignMask' : [ 0x9c, ['unsigned long']],
    'VirtualAllocdBlocks' : [ 0xa0, ['_LIST_ENTRY']],
    'SegmentList' : [ 0xa8, ['_LIST_ENTRY']],
    'AllocatorBackTraceIndex' : [ 0xb0, ['unsigned short']],
    'NonDedicatedListLength' : [ 0xb4, ['unsigned long']],
    'BlocksIndex' : [ 0xb8, ['pointer', ['void']]],
    'UCRIndex' : [ 0xbc, ['pointer', ['void']]],
    'PseudoTagEntries' : [ 0xc0, ['pointer', ['_HEAP_PSEUDO_TAG_ENTRY']]],
    'FreeLists' : [ 0xc4, ['_LIST_ENTRY']],
    'LockVariable' : [ 0xcc, ['pointer', ['_HEAP_LOCK']]],
    'CommitRoutine' : [ 0xd0, ['pointer', ['void']]],
    'FrontEndHeap' : [ 0xd4, ['pointer', ['void']]],
    'FrontHeapLockCount' : [ 0xd8, ['unsigned short']],
    'FrontEndHeapType' : [ 0xda, ['unsigned char']],
    'Counters' : [ 0xdc, ['_HEAP_COUNTERS']],
    'TuningParameters' : [ 0x124, ['_HEAP_TUNING_PARAMETERS']],
} ],
  '_HEAP_ENTRY' : [ 0x8, {
    'Size' : [ 0x0, ['unsigned short']],
    'Flags' : [ 0x2, ['unsigned char']],
    'SmallTagIndex' : [ 0x3, ['unsigned char']],
    'SubSegmentCode' : [ 0x0, ['pointer', ['void']]],
    'PreviousSize' : [ 0x4, ['unsigned short']],
    'SegmentOffset' : [ 0x6, ['unsigned char']],
    'LFHFlags' : [ 0x6, ['unsigned char']],
    'UnusedBytes' : [ 0x7, ['unsigned char']],
    'FunctionIndex' : [ 0x0, ['unsigned short']],
    'ContextValue' : [ 0x2, ['unsigned short']],
    'InterceptorValue' : [ 0x0, ['unsigned long']],
    'UnusedBytesLength' : [ 0x4, ['unsigned short']],
    'EntryOffset' : [ 0x6, ['unsigned char']],
    'ExtendedBlockSignature' : [ 0x7, ['unsigned char']],
    'Code1' : [ 0x0, ['unsigned long']],
    'Code2' : [ 0x4, ['unsigned short']],
    'Code3' : [ 0x6, ['unsigned char']],
    'Code4' : [ 0x7, ['unsigned char']],
    'AgregateCode' : [ 0x0, ['unsigned long long']],
} ],
  '_HEAP_SEGMENT' : [ 0x40, {
    'Entry' : [ 0x0, ['_HEAP_ENTRY']],
    'SegmentSignature' : [ 0x8, ['unsigned long']],
    'SegmentFlags' : [ 0xc, ['unsigned long']],
    'SegmentListEntry' : [ 0x10, ['_LIST_ENTRY']],
    'Heap' : [ 0x18, ['pointer', ['_HEAP']]],
    'BaseAddress' : [ 0x1c, ['pointer', ['void']]],
    'NumberOfPages' : [ 0x20, ['unsigned long']],
    'FirstEntry' : [ 0x24, ['pointer', ['_HEAP_ENTRY']]],
    'LastValidEntry' : [ 0x28, ['pointer', ['_HEAP_ENTRY']]],
    'NumberOfUnCommittedPages' : [ 0x2c, ['unsigned long']],
    'NumberOfUnCommittedRanges' : [ 0x30, ['unsigned long']],
    'SegmentAllocatorBackTraceIndex' : [ 0x34, ['unsigned short']],
    'Reserved' : [ 0x36, ['unsigned short']],
    'UCRSegmentList' : [ 0x38, ['_LIST_ENTRY']],
} ],
  '_HEAP_FREE_ENTRY' : [ 0x10, {
    'Size' : [ 0x0, ['unsigned short']],
    'Flags' : [ 0x2, ['unsigned char']],
    'SmallTagIndex' : [ 0x3, ['unsigned char']],
    'SubSegmentCode' : [ 0x0, ['pointer', ['void']]],
    'PreviousSize' : [ 0x4, ['unsigned short']],
    'SegmentOffset' : [ 0x6, ['unsigned char']],
    'LFHFlags' : [ 0x6, ['unsigned char']],
    'UnusedBytes' : [ 0x7, ['unsigned char']],
    'FunctionIndex' : [ 0x0, ['unsigned short']],
    'ContextValue' : [ 0x2, ['unsigned short']],
    'InterceptorValue' : [ 0x0, ['unsigned long']],
    'UnusedBytesLength' : [ 0x4, ['unsigned short']],
    'EntryOffset' : [ 0x6, ['unsigned char']],
    'ExtendedBlockSignature' : [ 0x7, ['unsigned char']],
    'Code1' : [ 0x0, ['unsigned long']],
    'Code2' : [ 0x4, ['unsigned short']],
    'Code3' : [ 0x6, ['unsigned char']],
    'Code4' : [ 0x7, ['unsigned char']],
    'AgregateCode' : [ 0x0, ['unsigned long long']],
    'FreeList' : [ 0x8, ['_LIST_ENTRY']],
} ],
  '_LDR_DATA_TABLE_ENTRY' : [ 0x68, {
    'InLoadOrderLinks' : [ 0x0, ['_LIST_ENTRY']],
    'InMemoryOrderLinks' : [ 0x8, ['_LIST_ENTRY']],
    'InInitializationOrderLinks' : [ 0x10, ['_LIST_ENTRY']],
    'DllBase' : [ 0x18, ['pointer', ['void']]],
    'EntryPoint' : [ 0x1c, ['pointer', ['void']]],
    'SizeOfImage' : [ 0x20, ['unsigned long']],
    'FullDllName' : [ 0x24, ['_UNICODE_STRING']],
    'BaseDllName' : [ 0x2c, ['_UNICODE_STRING']],
    'Flags' : [ 0x34, ['unsigned long']],
    'LoadCount' : [ 0x38, ['unsigned short']],
    'TlsIndex' : [ 0x3a, ['unsigned short']],
    'HashLinks' : [ 0x3c, ['_LIST_ENTRY']],
    'SectionPointer' : [ 0x3c, ['pointer', ['void']]],
    'CheckSum' : [ 0x40, ['unsigned long']],
    'TimeDateStamp' : [ 0x44, ['unsigned long']],
    'LoadedImports' : [ 0x44, ['pointer', ['void']]],
    'EntryPointActivationContext' : [ 0x48, ['pointer', ['_ACTIVATION_CONTEXT']]],
    'PatchInformation' : [ 0x4c, ['pointer', ['void']]],
    'ForwarderLinks' : [ 0x50, ['_LIST_ENTRY']],
    'ServiceTagLinks' : [ 0x58, ['_LIST_ENTRY']],
    'StaticLinks' : [ 0x60, ['_LIST_ENTRY']],
} ],
  '_HEAP_SUBSEGMENT' : [ 0x20, {
    'LocalInfo' : [ 0x0, ['pointer', ['_HEAP_LOCAL_SEGMENT_INFO']]],
    'UserBlocks' : [ 0x4, ['pointer', ['_HEAP_USERDATA_HEADER']]],
    'AggregateExchg' : [ 0x8, ['_INTERLOCK_SEQ']],
    'BlockSize' : [ 0x10, ['unsigned short']],
    'Flags' : [ 0x12, ['unsigned short']],
    'BlockCount' : [ 0x14, ['unsigned short']],
    'SizeIndex' : [ 0x16, ['unsigned char']],
    'AffinityIndex' : [ 0x17, ['unsigned char']],
    'Alignment' : [ 0x10, ['array', 2, ['unsigned long']]],
    'SFreeListEntry' : [ 0x18, ['_SINGLE_LIST_ENTRY']],
    'Lock' : [ 0x1c, ['unsigned long']],
} ],
  '_ETW_SYSTEMTIME' : [ 0x10, {
    'Year' : [ 0x0, ['unsigned short']],
    'Month' : [ 0x2, ['unsigned short']],
    'DayOfWeek' : [ 0x4, ['unsigned short']],
    'Day' : [ 0x6, ['unsigned short']],
    'Hour' : [ 0x8, ['unsigned short']],
    'Minute' : [ 0xa, ['unsigned short']],
    'Second' : [ 0xc, ['unsigned short']],
    'Milliseconds' : [ 0xe, ['unsigned short']],
} ],
  '_TIME_FIELDS' : [ 0x10, {
    'Year' : [ 0x0, ['short']],
    'Month' : [ 0x2, ['short']],
    'Day' : [ 0x4, ['short']],
    'Hour' : [ 0x6, ['short']],
    'Minute' : [ 0x8, ['short']],
    'Second' : [ 0xa, ['short']],
    'Milliseconds' : [ 0xc, ['short']],
    'Weekday' : [ 0xe, ['short']],
} ],
  '_WMI_LOGGER_CONTEXT' : [ 0x280, {
    'StartTime' : [ 0x0, ['_LARGE_INTEGER']],
    'LogFileHandle' : [ 0x8, ['pointer', ['void']]],
    'LoggerThread' : [ 0xc, ['pointer', ['_ETHREAD']]],
    'LoggerStatus' : [ 0x10, ['long']],
    'LoggerId' : [ 0x14, ['unsigned long']],
    'NBQHead' : [ 0x18, ['pointer', ['void']]],
    'OverflowNBQHead' : [ 0x1c, ['pointer', ['void']]],
    'QueueBlockFreeList' : [ 0x20, ['_SLIST_HEADER']],
    'GlobalList' : [ 0x28, ['_SLIST_HEADER']],
    'BatchedBufferList' : [ 0x30, ['pointer', ['_WMI_BUFFER_HEADER']]],
    'LoggerName' : [ 0x34, ['_UNICODE_STRING']],
    'LogFileName' : [ 0x3c, ['_UNICODE_STRING']],
    'LogFilePattern' : [ 0x44, ['_UNICODE_STRING']],
    'NewLogFileName' : [ 0x4c, ['_UNICODE_STRING']],
    'ClockType' : [ 0x54, ['unsigned long']],
    'CollectionOn' : [ 0x58, ['long']],
    'MaximumFileSize' : [ 0x5c, ['unsigned long']],
    'LoggerMode' : [ 0x60, ['unsigned long']],
    'LastFlushedBuffer' : [ 0x64, ['unsigned long']],
    'FlushTimer' : [ 0x68, ['unsigned long']],
    'FlushThreshold' : [ 0x6c, ['unsigned long']],
    'ByteOffset' : [ 0x70, ['_LARGE_INTEGER']],
    'FlushTimeStamp' : [ 0x78, ['_LARGE_INTEGER']],
    'MinimumBuffers' : [ 0x80, ['unsigned long']],
    'BuffersAvailable' : [ 0x84, ['long']],
    'NumberOfBuffers' : [ 0x88, ['long']],
    'MaximumBuffers' : [ 0x8c, ['unsigned long']],
    'EventsLost' : [ 0x90, ['unsigned long']],
    'BuffersWritten' : [ 0x94, ['unsigned long']],
    'LogBuffersLost' : [ 0x98, ['unsigned long']],
    'RealTimeBuffersDelivered' : [ 0x9c, ['unsigned long']],
    'RealTimeBuffersLost' : [ 0xa0, ['unsigned long']],
    'BufferSize' : [ 0xa4, ['unsigned long']],
    'MaximumEventSize' : [ 0xa8, ['unsigned long']],
    'SequencePtr' : [ 0xac, ['pointer', ['long']]],
    'LocalSequence' : [ 0xb0, ['unsigned long']],
    'InstanceGuid' : [ 0xb4, ['_GUID']],
    'GetCpuClock' : [ 0xc4, ['pointer', ['void']]],
    'FileCounter' : [ 0xc8, ['long']],
    'BufferCallback' : [ 0xcc, ['pointer', ['void']]],
    'PoolType' : [ 0xd0, ['Enumeration', dict(target = 'long', choices = {0: 'NonPagedPool', 1: 'PagedPool', 2: 'NonPagedPoolMustSucceed', 3: 'DontUseThisType', 4: 'NonPagedPoolCacheAligned', 5: 'PagedPoolCacheAligned', 6: 'NonPagedPoolCacheAlignedMustS', 7: 'MaxPoolType', 34: 'NonPagedPoolMustSucceedSession', 35: 'DontUseThisTypeSession', 32: 'NonPagedPoolSession', 36: 'NonPagedPoolCacheAlignedSession', 33: 'PagedPoolSession', 38: 'NonPagedPoolCacheAlignedMustSSession', 37: 'PagedPoolCacheAlignedSession'})]],
    'ReferenceTime' : [ 0xd8, ['_ETW_REF_CLOCK']],
    'RealtimeLoggerContextFreed' : [ 0xe8, ['unsigned char']],
    'Consumers' : [ 0xec, ['_LIST_ENTRY']],
    'NumConsumers' : [ 0xf4, ['unsigned long']],
    'Connecting' : [ 0xf8, ['_LIST_ENTRY']],
    'NewConsumer' : [ 0x100, ['unsigned char']],
    'RealtimeLogfileHandle' : [ 0x104, ['pointer', ['void']]],
    'RealtimeLogfileName' : [ 0x108, ['_UNICODE_STRING']],
    'RealtimeWriteOffset' : [ 0x110, ['_LARGE_INTEGER']],
    'RealtimeReadOffset' : [ 0x118, ['_LARGE_INTEGER']],
    'RealtimeLogfileSize' : [ 0x120, ['_LARGE_INTEGER']],
    'RealtimeLogfileUsage' : [ 0x128, ['unsigned long long']],
    'RealtimeMaximumFileSize' : [ 0x130, ['unsigned long long']],
    'RealtimeBuffersSaved' : [ 0x138, ['unsigned long']],
    'RealtimeReferenceTime' : [ 0x140, ['_ETW_REF_CLOCK']],
    'RealtimeDisconnectProcessId' : [ 0x150, ['unsigned long']],
    'RealtimeDisconnectConsumerId' : [ 0x154, ['unsigned long']],
    'NewRTEventsLost' : [ 0x158, ['Enumeration', dict(target = 'long', choices = {0: 'EtwRtEventNoLoss', 1: 'EtwRtEventLost', 2: 'EtwRtBufferLost', 3: 'EtwRtBackupLost', 4: 'EtwRtEventLossMax'})]],
    'LoggerEvent' : [ 0x15c, ['_KEVENT']],
    'FlushEvent' : [ 0x16c, ['_KEVENT']],
    'FlushDpc' : [ 0x17c, ['_KDPC']],
    'LoggerMutex' : [ 0x19c, ['_KMUTANT']],
    'LoggerLock' : [ 0x1bc, ['_EX_PUSH_LOCK']],
    'ClientSecurityContext' : [ 0x1c0, ['_SECURITY_CLIENT_CONTEXT']],
    'SecurityDescriptor' : [ 0x1fc, ['_EX_FAST_REF']],
    'DummyBufferForMarker' : [ 0x200, ['_WMI_BUFFER_HEADER']],
    'BufferSequenceNumber' : [ 0x248, ['long long']],
    'AcceptNewEvents' : [ 0x250, ['long']],
    'Flags' : [ 0x254, ['unsigned long']],
    'Persistent' : [ 0x254, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'AutoLogger' : [ 0x254, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'FsReady' : [ 0x254, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'RealTime' : [ 0x254, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'Wow' : [ 0x254, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'KernelTrace' : [ 0x254, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'NoMoreEnable' : [ 0x254, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'RequestFlag' : [ 0x258, ['unsigned long']],
    'RequestNewFie' : [ 0x258, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'RequestUpdateFile' : [ 0x258, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'RequestFlush' : [ 0x258, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'RequestDisableRealtime' : [ 0x258, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'RequestDisconnectConsumer' : [ 0x258, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'StackTraceFilterHookCount' : [ 0x25c, ['unsigned short']],
    'StackTraceFilter' : [ 0x25e, ['array', 16, ['unsigned short']]],
} ],
  '_WMI_BUFFER_HEADER' : [ 0x48, {
    'Wnode' : [ 0x0, ['_WNODE_HEADER']],
    'BufferSize' : [ 0x0, ['unsigned long']],
    'SavedOffset' : [ 0x4, ['unsigned long']],
    'CurrentOffset' : [ 0x8, ['unsigned long']],
    'ReferenceCount' : [ 0xc, ['long']],
    'TimeStamp' : [ 0x10, ['_LARGE_INTEGER']],
    'StartPerfClock' : [ 0x10, ['_LARGE_INTEGER']],
    'SequenceNumber' : [ 0x18, ['long long']],
    'Padding0' : [ 0x20, ['array', 2, ['unsigned long']]],
    'SlistEntry' : [ 0x20, ['_SINGLE_LIST_ENTRY']],
    'NextBuffer' : [ 0x20, ['pointer', ['_WMI_BUFFER_HEADER']]],
    'ClientContext' : [ 0x28, ['_ETW_BUFFER_CONTEXT']],
    'State' : [ 0x2c, ['Enumeration', dict(target = 'long', choices = {0: 'EtwBufferStateFree', 1: 'EtwBufferStateGeneralLogging', 2: 'EtwBufferStateCSwitch', 3: 'EtwBufferStateFlush', 4: 'EtwBufferStateMaximum'})]],
    'Flags' : [ 0x2c, ['unsigned long']],
    'Offset' : [ 0x30, ['unsigned long']],
    'BufferFlag' : [ 0x34, ['unsigned short']],
    'BufferType' : [ 0x36, ['unsigned short']],
    'Padding1' : [ 0x38, ['array', 4, ['unsigned long']]],
    'StartTime' : [ 0x38, ['_LARGE_INTEGER']],
    'Entry' : [ 0x38, ['_LIST_ENTRY']],
    'Padding2' : [ 0x38, ['pointer', ['void']]],
    'GlobalEntry' : [ 0x3c, ['_SINGLE_LIST_ENTRY']],
    'Pointer0' : [ 0x38, ['pointer', ['void']]],
    'Pointer1' : [ 0x3c, ['pointer', ['void']]],
} ],
  '_SYSTEM_TRACE_HEADER' : [ 0x20, {
    'Marker' : [ 0x0, ['unsigned long']],
    'Version' : [ 0x0, ['unsigned short']],
    'HeaderType' : [ 0x2, ['unsigned char']],
    'Flags' : [ 0x3, ['unsigned char']],
    'Header' : [ 0x4, ['unsigned long']],
    'Packet' : [ 0x4, ['_WMI_TRACE_PACKET']],
    'ThreadId' : [ 0x8, ['unsigned long']],
    'ProcessId' : [ 0xc, ['unsigned long']],
    'SystemTime' : [ 0x10, ['_LARGE_INTEGER']],
    'KernelTime' : [ 0x18, ['unsigned long']],
    'UserTime' : [ 0x1c, ['unsigned long']],
} ],
  '_PERFINFO_TRACE_HEADER' : [ 0x18, {
    'Marker' : [ 0x0, ['unsigned long']],
    'Version' : [ 0x0, ['unsigned short']],
    'HeaderType' : [ 0x2, ['unsigned char']],
    'Flags' : [ 0x3, ['unsigned char']],
    'Header' : [ 0x4, ['unsigned long']],
    'Packet' : [ 0x4, ['_WMI_TRACE_PACKET']],
    'TS' : [ 0x8, ['unsigned long long']],
    'SystemTime' : [ 0x8, ['_LARGE_INTEGER']],
    'Data' : [ 0x10, ['array', 1, ['unsigned char']]],
} ],
  '_ETW_LAST_ENABLE_INFO' : [ 0x10, {
    'EnableFlags' : [ 0x0, ['_LARGE_INTEGER']],
    'LoggerId' : [ 0x8, ['unsigned short']],
    'Level' : [ 0xa, ['unsigned char']],
    'Enabled' : [ 0xb, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'InternalFlag' : [ 0xb, ['BitField', dict(start_bit = 1, end_bit = 8, native_type='unsigned char')]],
} ],
  '_TRACE_ENABLE_CONTEXT' : [ 0x8, {
    'LoggerId' : [ 0x0, ['unsigned short']],
    'Level' : [ 0x2, ['unsigned char']],
    'InternalFlag' : [ 0x3, ['unsigned char']],
    'EnableFlags' : [ 0x4, ['unsigned long']],
} ],
  '_TRACE_ENABLE_CONTEXT_EX' : [ 0x10, {
    'LoggerId' : [ 0x0, ['unsigned short']],
    'Level' : [ 0x2, ['unsigned char']],
    'InternalFlag' : [ 0x3, ['unsigned char']],
    'EnableFlags' : [ 0x4, ['unsigned long']],
    'EnableFlagsHigh' : [ 0x8, ['unsigned long']],
    'Reserved' : [ 0xc, ['unsigned long']],
} ],
  '_ETW_GUID_ENTRY' : [ 0x158, {
    'GuidList' : [ 0x0, ['_LIST_ENTRY']],
    'RefCount' : [ 0x8, ['long']],
    'Guid' : [ 0xc, ['_GUID']],
    'RegListHead' : [ 0x1c, ['_LIST_ENTRY']],
    'SecurityDescriptor' : [ 0x24, ['pointer', ['void']]],
    'LastEnable' : [ 0x28, ['_ETW_LAST_ENABLE_INFO']],
    'ProviderEnableInfo' : [ 0x38, ['_TRACE_ENABLE_INFO']],
    'EnableInfo' : [ 0x58, ['array', 8, ['_TRACE_ENABLE_INFO']]],
} ],
  '_TRACE_ENABLE_INFO' : [ 0x20, {
    'IsEnabled' : [ 0x0, ['unsigned long']],
    'Level' : [ 0x4, ['unsigned char']],
    'Reserved1' : [ 0x5, ['unsigned char']],
    'LoggerId' : [ 0x6, ['unsigned short']],
    'EnableProperty' : [ 0x8, ['unsigned long']],
    'Reserved2' : [ 0xc, ['unsigned long']],
    'MatchAnyKeyword' : [ 0x10, ['unsigned long long']],
    'MatchAllKeyword' : [ 0x18, ['unsigned long long']],
} ],
  '__unnamed_17f1' : [ 0x4, {
    'DataLength' : [ 0x0, ['short']],
    'TotalLength' : [ 0x2, ['short']],
} ],
  '__unnamed_17f3' : [ 0x4, {
    's1' : [ 0x0, ['__unnamed_17f1']],
    'Length' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_17f5' : [ 0x4, {
    'Type' : [ 0x0, ['short']],
    'DataInfoOffset' : [ 0x2, ['short']],
} ],
  '__unnamed_17f7' : [ 0x4, {
    's2' : [ 0x0, ['__unnamed_17f5']],
    'ZeroInit' : [ 0x0, ['unsigned long']],
} ],
  '_PORT_MESSAGE' : [ 0x18, {
    'u1' : [ 0x0, ['__unnamed_17f3']],
    'u2' : [ 0x4, ['__unnamed_17f7']],
    'ClientId' : [ 0x8, ['_CLIENT_ID']],
    'DoNotUseThisField' : [ 0x8, ['double']],
    'MessageId' : [ 0x10, ['unsigned long']],
    'ClientViewSize' : [ 0x14, ['unsigned long']],
    'CallbackId' : [ 0x14, ['unsigned long']],
} ],
  '_BLOB_TYPE' : [ 0x24, {
    'ResourceId' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'BLOB_TYPE_UNKNOWN', 1: 'BLOB_TYPE_CONNECTION_INFO', 2: 'BLOB_TYPE_MESSAGE', 3: 'BLOB_TYPE_SECURITY_CONTEXT', 4: 'BLOB_TYPE_SECTION', 5: 'BLOB_TYPE_REGION', 6: 'BLOB_TYPE_VIEW', 7: 'BLOB_TYPE_RESERVE', 8: 'BLOB_TYPE_DIRECT_TRANSFER', 9: 'BLOB_TYPE_HANDLE_DATA', 10: 'BLOB_TYPE_MAX_ID'})]],
    'PoolTag' : [ 0x4, ['unsigned long']],
    'Flags' : [ 0x8, ['unsigned long']],
    'CreatedObjects' : [ 0xc, ['unsigned long']],
    'DeletedObjects' : [ 0x10, ['unsigned long']],
    'DeleteProcedure' : [ 0x14, ['pointer', ['void']]],
    'DestroyProcedure' : [ 0x18, ['pointer', ['void']]],
    'UsualSize' : [ 0x1c, ['unsigned long']],
    'LookasideIndex' : [ 0x20, ['unsigned long']],
} ],
  '_ALPC_HANDLE_ENTRY' : [ 0x4, {
    'Object' : [ 0x0, ['pointer', ['void']]],
} ],
  '__unnamed_180e' : [ 0x1, {
    'ReferenceCache' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Lookaside' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Initializing' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'Deleted' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
} ],
  '__unnamed_1810' : [ 0x1, {
    's1' : [ 0x0, ['__unnamed_180e']],
    'Flags' : [ 0x0, ['unsigned char']],
} ],
  '_BLOB' : [ 0x18, {
    'ResourceList' : [ 0x0, ['_LIST_ENTRY']],
    'FreeListEntry' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'u1' : [ 0x8, ['__unnamed_1810']],
    'ResourceId' : [ 0x9, ['unsigned char']],
    'CachedReferences' : [ 0xa, ['short']],
    'ReferenceCount' : [ 0xc, ['long']],
    'Lock' : [ 0x10, ['_EX_PUSH_LOCK']],
    'Pad' : [ 0x14, ['unsigned long']],
} ],
  '__unnamed_1818' : [ 0x4, {
    'Internal' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Secure' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
} ],
  '__unnamed_181a' : [ 0x4, {
    's1' : [ 0x0, ['__unnamed_1818']],
} ],
  '_KALPC_SECTION' : [ 0x28, {
    'u1' : [ 0x0, ['__unnamed_181a']],
    'SectionObject' : [ 0x4, ['pointer', ['void']]],
    'Size' : [ 0x8, ['unsigned long']],
    'HandleTable' : [ 0xc, ['pointer', ['_ALPC_HANDLE_TABLE']]],
    'SectionHandle' : [ 0x10, ['pointer', ['void']]],
    'OwnerProcess' : [ 0x14, ['pointer', ['_EPROCESS']]],
    'OwnerPort' : [ 0x18, ['pointer', ['_ALPC_PORT']]],
    'NumberOfRegions' : [ 0x1c, ['unsigned long']],
    'RegionListHead' : [ 0x20, ['_LIST_ENTRY']],
} ],
  '__unnamed_1827' : [ 0x4, {
    'Secure' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
} ],
  '__unnamed_1829' : [ 0x4, {
    's1' : [ 0x0, ['__unnamed_1827']],
} ],
  '_KALPC_REGION' : [ 0x30, {
    'u1' : [ 0x0, ['__unnamed_1829']],
    'RegionListEntry' : [ 0x4, ['_LIST_ENTRY']],
    'Section' : [ 0xc, ['pointer', ['_KALPC_SECTION']]],
    'Offset' : [ 0x10, ['unsigned long']],
    'Size' : [ 0x14, ['unsigned long']],
    'ViewSize' : [ 0x18, ['unsigned long']],
    'ReadOnlyView' : [ 0x1c, ['pointer', ['_KALPC_VIEW']]],
    'ReadWriteView' : [ 0x20, ['pointer', ['_KALPC_VIEW']]],
    'NumberOfViews' : [ 0x24, ['unsigned long']],
    'ViewListHead' : [ 0x28, ['_LIST_ENTRY']],
} ],
  '__unnamed_182f' : [ 0x4, {
    'WriteAccess' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'AutoRelease' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ForceUnlink' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
} ],
  '__unnamed_1831' : [ 0x4, {
    's1' : [ 0x0, ['__unnamed_182f']],
} ],
  '_KALPC_VIEW' : [ 0x34, {
    'ViewListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'u1' : [ 0x8, ['__unnamed_1831']],
    'Region' : [ 0xc, ['pointer', ['_KALPC_REGION']]],
    'OwnerPort' : [ 0x10, ['pointer', ['_ALPC_PORT']]],
    'OwnerProcess' : [ 0x14, ['pointer', ['_EPROCESS']]],
    'Address' : [ 0x18, ['pointer', ['void']]],
    'Size' : [ 0x1c, ['unsigned long']],
    'SecureViewHandle' : [ 0x20, ['pointer', ['void']]],
    'WriteAccessHandle' : [ 0x24, ['pointer', ['void']]],
    'NumberOfOwnerMessages' : [ 0x28, ['unsigned long']],
    'ProcessViewListEntry' : [ 0x2c, ['_LIST_ENTRY']],
} ],
  '_ALPC_COMMUNICATION_INFO' : [ 0x24, {
    'ConnectionPort' : [ 0x0, ['pointer', ['_ALPC_PORT']]],
    'ServerCommunicationPort' : [ 0x4, ['pointer', ['_ALPC_PORT']]],
    'ClientCommunicationPort' : [ 0x8, ['pointer', ['_ALPC_PORT']]],
    'CommunicationList' : [ 0xc, ['_LIST_ENTRY']],
    'HandleTable' : [ 0x14, ['_ALPC_HANDLE_TABLE']],
} ],
  '__unnamed_1849' : [ 0x4, {
    'Initialized' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Type' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 3, native_type='unsigned long')]],
    'ConnectionPending' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'ConnectionRefused' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'Disconnected' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'Closed' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'NoFlushOnClose' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'ReturnExtendedInfo' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'Waitable' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'DynamicSecurity' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'Wow64CompletionList' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'Lpc' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'LpcToLpc' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'HasCompletionList' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'HadCompletionList' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
} ],
  '__unnamed_184b' : [ 0x4, {
    's1' : [ 0x0, ['__unnamed_1849']],
    'State' : [ 0x0, ['unsigned long']],
} ],
  '_ALPC_PORT' : [ 0xf4, {
    'PortListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'CommunicationInfo' : [ 0x8, ['pointer', ['_ALPC_COMMUNICATION_INFO']]],
    'OwnerProcess' : [ 0xc, ['pointer', ['_EPROCESS']]],
    'SequenceNo' : [ 0x10, ['unsigned long']],
    'CompletionPort' : [ 0x14, ['pointer', ['void']]],
    'CompletionKey' : [ 0x18, ['pointer', ['void']]],
    'CompletionPacketLookaside' : [ 0x1c, ['pointer', ['_ALPC_COMPLETION_PACKET_LOOKASIDE']]],
    'PortContext' : [ 0x20, ['pointer', ['void']]],
    'StaticSecurity' : [ 0x24, ['_SECURITY_CLIENT_CONTEXT']],
    'MainQueue' : [ 0x60, ['_LIST_ENTRY']],
    'PendingQueue' : [ 0x68, ['_LIST_ENTRY']],
    'LargeMessageQueue' : [ 0x70, ['_LIST_ENTRY']],
    'WaitQueue' : [ 0x78, ['_LIST_ENTRY']],
    'Semaphore' : [ 0x80, ['pointer', ['_KSEMAPHORE']]],
    'DummyEvent' : [ 0x80, ['pointer', ['_KEVENT']]],
    'Lock' : [ 0x84, ['_EX_PUSH_LOCK']],
    'PortAttributes' : [ 0x88, ['_ALPC_PORT_ATTRIBUTES']],
    'ResourceListLock' : [ 0xb4, ['_EX_PUSH_LOCK']],
    'ResourceListHead' : [ 0xb8, ['_LIST_ENTRY']],
    'CompletionList' : [ 0xc0, ['pointer', ['_ALPC_COMPLETION_LIST']]],
    'MessageZone' : [ 0xc4, ['pointer', ['_ALPC_MESSAGE_ZONE']]],
    'CanceledQueue' : [ 0xc8, ['_LIST_ENTRY']],
    'u1' : [ 0xd0, ['__unnamed_184b']],
    'TargetQueuePort' : [ 0xd4, ['pointer', ['_ALPC_PORT']]],
    'TargetSequencePort' : [ 0xd8, ['pointer', ['_ALPC_PORT']]],
    'Message' : [ 0xdc, ['pointer', ['_KALPC_MESSAGE']]],
    'MainQueueLength' : [ 0xe0, ['unsigned long']],
    'PendingQueueLength' : [ 0xe4, ['unsigned long']],
    'LargeMessageQueueLength' : [ 0xe8, ['unsigned long']],
    'CanceledQueueLength' : [ 0xec, ['unsigned long']],
    'WaitQueueLength' : [ 0xf0, ['unsigned long']],
} ],
  '__unnamed_1862' : [ 0x4, {
    'QueueType' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned long')]],
    'QueuePortType' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 6, native_type='unsigned long')]],
    'Canceled' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'Ready' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'ReleaseMessage' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'SharedQuota' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'ReplyWaitReply' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'OwnerPortReference' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'ReserveReference' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'ReceiverReference' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
} ],
  '__unnamed_1864' : [ 0x4, {
    's1' : [ 0x0, ['__unnamed_1862']],
    'State' : [ 0x0, ['unsigned long']],
} ],
  '_KALPC_MESSAGE' : [ 0x90, {
    'Entry' : [ 0x0, ['_LIST_ENTRY']],
    'ExtensionBuffer' : [ 0x8, ['pointer', ['void']]],
    'ExtensionBufferSize' : [ 0xc, ['unsigned long']],
    'QuotaProcess' : [ 0x10, ['pointer', ['_EPROCESS']]],
    'QuotaBlock' : [ 0x10, ['pointer', ['void']]],
    'SequenceNo' : [ 0x14, ['long']],
    'u1' : [ 0x18, ['__unnamed_1864']],
    'CancelSequencePort' : [ 0x1c, ['pointer', ['_ALPC_PORT']]],
    'CancelQueuePort' : [ 0x20, ['pointer', ['_ALPC_PORT']]],
    'CancelSequenceNo' : [ 0x24, ['long']],
    'CancelListEntry' : [ 0x28, ['_LIST_ENTRY']],
    'WaitingThread' : [ 0x30, ['pointer', ['_ETHREAD']]],
    'Reserve' : [ 0x34, ['pointer', ['_KALPC_RESERVE']]],
    'PortQueue' : [ 0x38, ['pointer', ['_ALPC_PORT']]],
    'OwnerPort' : [ 0x3c, ['pointer', ['_ALPC_PORT']]],
    'UniqueTableEntry' : [ 0x40, ['pointer', ['_HANDLE_TABLE_ENTRY']]],
    'MessageAttributes' : [ 0x44, ['_KALPC_MESSAGE_ATTRIBUTES']],
    'DataUserVa' : [ 0x60, ['pointer', ['void']]],
    'DataSystemVa' : [ 0x64, ['pointer', ['void']]],
    'CommunicationInfo' : [ 0x68, ['pointer', ['_ALPC_COMMUNICATION_INFO']]],
    'ConnectionPort' : [ 0x6c, ['pointer', ['_ALPC_PORT']]],
    'ServerThread' : [ 0x70, ['pointer', ['_ETHREAD']]],
    'PortMessage' : [ 0x78, ['_PORT_MESSAGE']],
} ],
  '_REMOTE_PORT_VIEW' : [ 0xc, {
    'Length' : [ 0x0, ['unsigned long']],
    'ViewSize' : [ 0x4, ['unsigned long']],
    'ViewBase' : [ 0x8, ['pointer', ['void']]],
} ],
  '_KALPC_HANDLE_DATA' : [ 0xc, {
    'Flags' : [ 0x0, ['unsigned long']],
    'ObjectType' : [ 0x4, ['unsigned long']],
    'DuplicateContext' : [ 0x8, ['pointer', ['_OB_DUPLICATE_OBJECT_STATE']]],
} ],
  '_KALPC_MESSAGE_ATTRIBUTES' : [ 0x1c, {
    'ClientContext' : [ 0x0, ['pointer', ['void']]],
    'ServerContext' : [ 0x4, ['pointer', ['void']]],
    'PortContext' : [ 0x8, ['pointer', ['void']]],
    'CancelPortContext' : [ 0xc, ['pointer', ['void']]],
    'SecurityData' : [ 0x10, ['pointer', ['_KALPC_SECURITY_DATA']]],
    'View' : [ 0x14, ['pointer', ['_KALPC_VIEW']]],
    'HandleData' : [ 0x18, ['pointer', ['_KALPC_HANDLE_DATA']]],
} ],
  '__unnamed_18a2' : [ 0x4, {
    'Revoked' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Impersonated' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
} ],
  '__unnamed_18a4' : [ 0x4, {
    's1' : [ 0x0, ['__unnamed_18a2']],
} ],
  '_KALPC_SECURITY_DATA' : [ 0x50, {
    'HandleTable' : [ 0x0, ['pointer', ['_ALPC_HANDLE_TABLE']]],
    'ContextHandle' : [ 0x4, ['pointer', ['void']]],
    'OwningProcess' : [ 0x8, ['pointer', ['_EPROCESS']]],
    'OwnerPort' : [ 0xc, ['pointer', ['_ALPC_PORT']]],
    'DynamicSecurity' : [ 0x10, ['_SECURITY_CLIENT_CONTEXT']],
    'u1' : [ 0x4c, ['__unnamed_18a4']],
} ],
  '_ALPC_DISPATCH_CONTEXT' : [ 0x20, {
    'PortObject' : [ 0x0, ['pointer', ['_ALPC_PORT']]],
    'Message' : [ 0x4, ['pointer', ['_KALPC_MESSAGE']]],
    'CommunicationInfo' : [ 0x8, ['pointer', ['_ALPC_COMMUNICATION_INFO']]],
    'Flags' : [ 0xc, ['unsigned long']],
    'TargetThread' : [ 0x10, ['pointer', ['_ETHREAD']]],
    'TargetPort' : [ 0x14, ['pointer', ['_ALPC_PORT']]],
    'TotalLength' : [ 0x18, ['unsigned short']],
    'Type' : [ 0x1a, ['unsigned short']],
    'DataInfoOffset' : [ 0x1c, ['unsigned short']],
} ],
  '_ALPC_MESSAGE_ATTRIBUTES' : [ 0x8, {
    'AllocatedAttributes' : [ 0x0, ['unsigned long']],
    'ValidAttributes' : [ 0x4, ['unsigned long']],
} ],
  '_ALPC_PORT_ATTRIBUTES' : [ 0x2c, {
    'Flags' : [ 0x0, ['unsigned long']],
    'SecurityQos' : [ 0x4, ['_SECURITY_QUALITY_OF_SERVICE']],
    'MaxMessageLength' : [ 0x10, ['unsigned long']],
    'MemoryBandwidth' : [ 0x14, ['unsigned long']],
    'MaxPoolUsage' : [ 0x18, ['unsigned long']],
    'MaxSectionSize' : [ 0x1c, ['unsigned long']],
    'MaxViewSize' : [ 0x20, ['unsigned long']],
    'MaxTotalSectionSize' : [ 0x24, ['unsigned long']],
    'DupObjectTypes' : [ 0x28, ['unsigned long']],
} ],
  '_LUID_AND_ATTRIBUTES' : [ 0xc, {
    'Luid' : [ 0x0, ['_LUID']],
    'Attributes' : [ 0x8, ['unsigned long']],
} ],
  '_TOKEN' : [ 0x1e8, {
    'TokenSource' : [ 0x0, ['_TOKEN_SOURCE']],
    'TokenId' : [ 0x10, ['_LUID']],
    'AuthenticationId' : [ 0x18, ['_LUID']],
    'ParentTokenId' : [ 0x20, ['_LUID']],
    'ExpirationTime' : [ 0x28, ['_LARGE_INTEGER']],
    'TokenLock' : [ 0x30, ['pointer', ['_ERESOURCE']]],
    'ModifiedId' : [ 0x34, ['_LUID']],
    'Privileges' : [ 0x40, ['_SEP_TOKEN_PRIVILEGES']],
    'AuditPolicy' : [ 0x58, ['_SEP_AUDIT_POLICY']],
    'SessionId' : [ 0x74, ['unsigned long']],
    'UserAndGroupCount' : [ 0x78, ['unsigned long']],
    'RestrictedSidCount' : [ 0x7c, ['unsigned long']],
    'VariableLength' : [ 0x80, ['unsigned long']],
    'DynamicCharged' : [ 0x84, ['unsigned long']],
    'DynamicAvailable' : [ 0x88, ['unsigned long']],
    'DefaultOwnerIndex' : [ 0x8c, ['unsigned long']],
    'UserAndGroups' : [ 0x90, ['pointer', ['_SID_AND_ATTRIBUTES']]],
    'RestrictedSids' : [ 0x94, ['pointer', ['_SID_AND_ATTRIBUTES']]],
    'PrimaryGroup' : [ 0x98, ['pointer', ['void']]],
    'DynamicPart' : [ 0x9c, ['pointer', ['unsigned long']]],
    'DefaultDacl' : [ 0xa0, ['pointer', ['_ACL']]],
    'TokenType' : [ 0xa4, ['Enumeration', dict(target = 'long', choices = {1: 'TokenPrimary', 2: 'TokenImpersonation'})]],
    'ImpersonationLevel' : [ 0xa8, ['Enumeration', dict(target = 'long', choices = {0: 'SecurityAnonymous', 1: 'SecurityIdentification', 2: 'SecurityImpersonation', 3: 'SecurityDelegation'})]],
    'TokenFlags' : [ 0xac, ['unsigned long']],
    'TokenInUse' : [ 0xb0, ['unsigned char']],
    'IntegrityLevelIndex' : [ 0xb4, ['unsigned long']],
    'MandatoryPolicy' : [ 0xb8, ['unsigned long']],
    'ProxyData' : [ 0xbc, ['pointer', ['_SECURITY_TOKEN_PROXY_DATA']]],
    'AuditData' : [ 0xc0, ['pointer', ['_SECURITY_TOKEN_AUDIT_DATA']]],
    'LogonSession' : [ 0xc4, ['pointer', ['_SEP_LOGON_SESSION_REFERENCES']]],
    'OriginatingLogonSession' : [ 0xc8, ['_LUID']],
    'SidHash' : [ 0xd0, ['_SID_AND_ATTRIBUTES_HASH']],
    'RestrictedSidHash' : [ 0x158, ['_SID_AND_ATTRIBUTES_HASH']],
    'VariablePart' : [ 0x1e0, ['unsigned long']],
} ],
  '_SEP_LOGON_SESSION_REFERENCES' : [ 0x34, {
    'Next' : [ 0x0, ['pointer', ['_SEP_LOGON_SESSION_REFERENCES']]],
    'LogonId' : [ 0x4, ['_LUID']],
    'BuddyLogonId' : [ 0xc, ['_LUID']],
    'ReferenceCount' : [ 0x14, ['unsigned long']],
    'Flags' : [ 0x18, ['unsigned long']],
    'pDeviceMap' : [ 0x1c, ['pointer', ['_DEVICE_MAP']]],
    'Token' : [ 0x20, ['pointer', ['void']]],
    'AccountName' : [ 0x24, ['_UNICODE_STRING']],
    'AuthorityName' : [ 0x2c, ['_UNICODE_STRING']],
} ],
  '_OBP_LOOKUP_CONTEXT' : [ 0x14, {
    'Directory' : [ 0x0, ['pointer', ['_OBJECT_DIRECTORY']]],
    'Object' : [ 0x4, ['pointer', ['void']]],
    'HashValue' : [ 0x8, ['unsigned long']],
    'HashIndex' : [ 0xc, ['unsigned short']],
    'DirectoryLocked' : [ 0xe, ['unsigned char']],
    'LockStateSignature' : [ 0x10, ['unsigned long']],
} ],
  '_OBJECT_DIRECTORY' : [ 0xa8, {
    'HashBuckets' : [ 0x0, ['array', 37, ['pointer', ['_OBJECT_DIRECTORY_ENTRY']]]],
    'Lock' : [ 0x94, ['_EX_PUSH_LOCK']],
    'DeviceMap' : [ 0x98, ['pointer', ['_DEVICE_MAP']]],
    'SessionId' : [ 0x9c, ['unsigned long']],
    'NamespaceEntry' : [ 0xa0, ['pointer', ['void']]],
    'Flags' : [ 0xa4, ['unsigned long']],
} ],
  '_OBJECT_TYPE' : [ 0x140, {
    'TypeList' : [ 0x0, ['_LIST_ENTRY']],
    'Name' : [ 0x8, ['_UNICODE_STRING']],
    'DefaultObject' : [ 0x10, ['pointer', ['void']]],
    'Index' : [ 0x14, ['unsigned long']],
    'TotalNumberOfObjects' : [ 0x18, ['unsigned long']],
    'TotalNumberOfHandles' : [ 0x1c, ['unsigned long']],
    'HighWaterNumberOfObjects' : [ 0x20, ['unsigned long']],
    'HighWaterNumberOfHandles' : [ 0x24, ['unsigned long']],
    'TypeInfo' : [ 0x28, ['_OBJECT_TYPE_INITIALIZER']],
    'Mutex' : [ 0x78, ['_ERESOURCE']],
    'TypeLock' : [ 0xb0, ['_EX_PUSH_LOCK']],
    'Key' : [ 0xb4, ['unsigned long']],
    'ObjectLocks' : [ 0xb8, ['array', 32, ['_EX_PUSH_LOCK']]],
    'CallbackList' : [ 0x138, ['_LIST_ENTRY']],
} ],
  '_PS_CLIENT_SECURITY_CONTEXT' : [ 0x4, {
    'ImpersonationData' : [ 0x0, ['unsigned long']],
    'ImpersonationToken' : [ 0x0, ['pointer', ['void']]],
    'ImpersonationLevel' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned long')]],
    'EffectiveOnly' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
} ],
  '_MMVAD_FLAGS3' : [ 0x4, {
    'PreferredNode' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 6, native_type='unsigned long')]],
    'Teb' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'SequentialAccess' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'LastSequentialTrim' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 24, native_type='unsigned long')]],
    'Spare2' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
} ],
  '_MI_VERIFIER_POOL_HEADER' : [ 0x4, {
    'VerifierPoolEntry' : [ 0x0, ['pointer', ['_VI_POOL_ENTRY']]],
} ],
  '_HBASE_BLOCK' : [ 0x1000, {
    'Signature' : [ 0x0, ['unsigned long']],
    'Sequence1' : [ 0x4, ['unsigned long']],
    'Sequence2' : [ 0x8, ['unsigned long']],
    'TimeStamp' : [ 0xc, ['_LARGE_INTEGER']],
    'Major' : [ 0x14, ['unsigned long']],
    'Minor' : [ 0x18, ['unsigned long']],
    'Type' : [ 0x1c, ['unsigned long']],
    'Format' : [ 0x20, ['unsigned long']],
    'RootCell' : [ 0x24, ['unsigned long']],
    'Length' : [ 0x28, ['unsigned long']],
    'Cluster' : [ 0x2c, ['unsigned long']],
    'FileName' : [ 0x30, ['array', 64, ['unsigned char']]],
    'RmId' : [ 0x70, ['_GUID']],
    'LogId' : [ 0x80, ['_GUID']],
    'Flags' : [ 0x90, ['unsigned long']],
    'TmId' : [ 0x94, ['_GUID']],
    'GuidSignature' : [ 0xa4, ['unsigned long']],
    'Reserved1' : [ 0xa8, ['array', 85, ['unsigned long']]],
    'CheckSum' : [ 0x1fc, ['unsigned long']],
    'Reserved2' : [ 0x200, ['array', 882, ['unsigned long']]],
    'ThawTmId' : [ 0xfc8, ['_GUID']],
    'ThawRmId' : [ 0xfd8, ['_GUID']],
    'ThawLogId' : [ 0xfe8, ['_GUID']],
    'BootType' : [ 0xff8, ['unsigned long']],
    'BootRecover' : [ 0xffc, ['unsigned long']],
} ],
  '_ERESOURCE' : [ 0x38, {
    'SystemResourcesList' : [ 0x0, ['_LIST_ENTRY']],
    'OwnerTable' : [ 0x8, ['pointer', ['_OWNER_ENTRY']]],
    'ActiveCount' : [ 0xc, ['short']],
    'Flag' : [ 0xe, ['unsigned short']],
    'SharedWaiters' : [ 0x10, ['pointer', ['_KSEMAPHORE']]],
    'ExclusiveWaiters' : [ 0x14, ['pointer', ['_KEVENT']]],
    'OwnerEntry' : [ 0x18, ['_OWNER_ENTRY']],
    'ActiveEntries' : [ 0x20, ['unsigned long']],
    'ContentionCount' : [ 0x24, ['unsigned long']],
    'NumberOfSharedWaiters' : [ 0x28, ['unsigned long']],
    'NumberOfExclusiveWaiters' : [ 0x2c, ['unsigned long']],
    'Address' : [ 0x30, ['pointer', ['void']]],
    'CreatorBackTraceIndex' : [ 0x30, ['unsigned long']],
    'SpinLock' : [ 0x34, ['unsigned long']],
} ],
  '_LPCP_MESSAGE' : [ 0x30, {
    'Entry' : [ 0x0, ['_LIST_ENTRY']],
    'FreeEntry' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Reserved0' : [ 0x4, ['unsigned long']],
    'SenderPort' : [ 0x8, ['pointer', ['void']]],
    'RepliedToThread' : [ 0xc, ['pointer', ['_ETHREAD']]],
    'PortContext' : [ 0x10, ['pointer', ['void']]],
    'Request' : [ 0x18, ['_PORT_MESSAGE']],
} ],
  '_HARDWARE_PTE' : [ 0x4, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Write' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Owner' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'WriteThrough' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'CacheDisable' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'Accessed' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'Dirty' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'LargePage' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'Global' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'CopyOnWrite' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'reserved' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'PageFrameNumber' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 32, native_type='unsigned long')]],
} ],
  '_DUAL' : [ 0x13c, {
    'Length' : [ 0x0, ['unsigned long']],
    'Map' : [ 0x4, ['pointer', ['_HMAP_DIRECTORY']]],
    'SmallDir' : [ 0x8, ['pointer', ['_HMAP_TABLE']]],
    'Guard' : [ 0xc, ['unsigned long']],
    'FreeDisplay' : [ 0x10, ['array', 24, ['_FREE_DISPLAY']]],
    'FreeSummary' : [ 0x130, ['unsigned long']],
    'FreeBins' : [ 0x134, ['_LIST_ENTRY']],
} ],
  '_DISPATCHER_HEADER' : [ 0x10, {
    'Type' : [ 0x0, ['unsigned char']],
    'Abandoned' : [ 0x1, ['unsigned char']],
    'Absolute' : [ 0x1, ['unsigned char']],
    'NpxIrql' : [ 0x1, ['unsigned char']],
    'Signalling' : [ 0x1, ['unsigned char']],
    'Size' : [ 0x2, ['unsigned char']],
    'Hand' : [ 0x2, ['unsigned char']],
    'Inserted' : [ 0x3, ['unsigned char']],
    'DebugActive' : [ 0x3, ['unsigned char']],
    'DpcActive' : [ 0x3, ['unsigned char']],
    'Lock' : [ 0x0, ['long']],
    'SignalState' : [ 0x4, ['long']],
    'WaitListHead' : [ 0x8, ['_LIST_ENTRY']],
} ],
  '_VI_POOL_ENTRY' : [ 0x10, {
    'PageHeader' : [ 0x0, ['_VI_POOL_PAGE_HEADER']],
    'InUse' : [ 0x0, ['_VI_POOL_ENTRY_INUSE']],
    'NextFree' : [ 0x0, ['pointer', ['_SINGLE_LIST_ENTRY']]],
} ],
  '_MM_PAGE_ACCESS_INFO' : [ 0x8, {
    'Flags' : [ 0x0, ['_MM_PAGE_ACCESS_INFO_FLAGS']],
    'FileOffset' : [ 0x0, ['unsigned long long']],
    'VirtualAddress' : [ 0x0, ['pointer', ['void']]],
    'DontUse0' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned long')]],
    'Spare0' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
    'PointerProtoPte' : [ 0x4, ['pointer', ['void']]],
} ],
  '_HEAP_COUNTERS' : [ 0x48, {
    'TotalMemoryReserved' : [ 0x0, ['unsigned long']],
    'TotalMemoryCommitted' : [ 0x4, ['unsigned long']],
    'TotalMemoryLargeUCR' : [ 0x8, ['unsigned long']],
    'TotalSizeInVirtualBlocks' : [ 0xc, ['unsigned long']],
    'TotalSegments' : [ 0x10, ['unsigned long']],
    'TotalUCRs' : [ 0x14, ['unsigned long']],
    'CommittOps' : [ 0x18, ['unsigned long']],
    'DeCommitOps' : [ 0x1c, ['unsigned long']],
    'LockAcquires' : [ 0x20, ['unsigned long']],
    'LockCollisions' : [ 0x24, ['unsigned long']],
    'CommitRate' : [ 0x28, ['unsigned long']],
    'DecommittRate' : [ 0x2c, ['unsigned long']],
    'CommitFailures' : [ 0x30, ['unsigned long']],
    'InBlockCommitFailures' : [ 0x34, ['unsigned long']],
    'CompactHeapCalls' : [ 0x38, ['unsigned long']],
    'CompactedUCRs' : [ 0x3c, ['unsigned long']],
    'InBlockDeccommits' : [ 0x40, ['unsigned long']],
    'InBlockDeccomitSize' : [ 0x44, ['unsigned long']],
} ],
  '_SYSPTES_HEADER' : [ 0x14, {
    'ListHead' : [ 0x0, ['_LIST_ENTRY']],
    'Count' : [ 0x8, ['unsigned long']],
    'NumberOfEntries' : [ 0xc, ['unsigned long']],
    'NumberOfEntriesPeak' : [ 0x10, ['unsigned long']],
} ],
  '_EXCEPTION_RECORD' : [ 0x50, {
    'ExceptionCode' : [ 0x0, ['long']],
    'ExceptionFlags' : [ 0x4, ['unsigned long']],
    'ExceptionRecord' : [ 0x8, ['pointer', ['_EXCEPTION_RECORD']]],
    'ExceptionAddress' : [ 0xc, ['pointer', ['void']]],
    'NumberParameters' : [ 0x10, ['unsigned long']],
    'ExceptionInformation' : [ 0x14, ['array', 15, ['unsigned long']]],
} ],
  '_PERFINFO_HARDPAGEFAULT_INFORMATION' : [ 0x18, {
    'ReadOffset' : [ 0x0, ['_LARGE_INTEGER']],
    'VirtualAddress' : [ 0x8, ['pointer', ['void']]],
    'FileObject' : [ 0xc, ['pointer', ['void']]],
    'ThreadId' : [ 0x10, ['unsigned long']],
    'ByteCount' : [ 0x14, ['unsigned long']],
} ],
  '_I386_LOADER_BLOCK' : [ 0xc, {
    'CommonDataArea' : [ 0x0, ['pointer', ['void']]],
    'MachineType' : [ 0x4, ['unsigned long']],
    'VirtualBias' : [ 0x8, ['unsigned long']],
} ],
  '_CELL_DATA' : [ 0x50, {
    'u' : [ 0x0, ['_u']],
} ],
  '_ARC_DISK_INFORMATION' : [ 0x8, {
    'DiskSignatures' : [ 0x0, ['_LIST_ENTRY']],
} ],
  '_INITIAL_PRIVILEGE_SET' : [ 0x2c, {
    'PrivilegeCount' : [ 0x0, ['unsigned long']],
    'Control' : [ 0x4, ['unsigned long']],
    'Privilege' : [ 0x8, ['array', 3, ['_LUID_AND_ATTRIBUTES']]],
} ],
  '_HEAP_TUNING_PARAMETERS' : [ 0x8, {
    'CommittThresholdShift' : [ 0x0, ['unsigned long']],
    'MaxPreCommittThreshold' : [ 0x4, ['unsigned long']],
} ],
  '_MMWSLE_NONDIRECT_HASH' : [ 0x8, {
    'Key' : [ 0x0, ['pointer', ['void']]],
    'Index' : [ 0x4, ['unsigned long']],
} ],
  '_DBGKD_SEARCH_MEMORY' : [ 0x18, {
    'SearchAddress' : [ 0x0, ['unsigned long long']],
    'FoundAddress' : [ 0x0, ['unsigned long long']],
    'SearchLength' : [ 0x8, ['unsigned long long']],
    'PatternLength' : [ 0x10, ['unsigned long']],
} ],
  '_HMAP_DIRECTORY' : [ 0x1000, {
    'Directory' : [ 0x0, ['array', 1024, ['pointer', ['_HMAP_TABLE']]]],
} ],
  '_DEVPROPKEY' : [ 0x14, {
    'fmtid' : [ 0x0, ['_GUID']],
    'pid' : [ 0x10, ['unsigned long']],
} ],
  '_WHEA_NMI_ERROR' : [ 0xc, {
    'Data' : [ 0x0, ['array', 8, ['unsigned char']]],
    'Flags' : [ 0x8, ['_WHEA_NMI_ERROR_FLAGS']],
} ],
  '_HANDLE_TABLE' : [ 0x38, {
    'TableCode' : [ 0x0, ['unsigned long']],
    'QuotaProcess' : [ 0x4, ['pointer', ['_EPROCESS']]],
    'UniqueProcessId' : [ 0x8, ['pointer', ['void']]],
    'HandleLock' : [ 0xc, ['_EX_PUSH_LOCK']],
    'HandleTableList' : [ 0x10, ['_LIST_ENTRY']],
    'HandleContentionEvent' : [ 0x18, ['_EX_PUSH_LOCK']],
    'DebugInfo' : [ 0x1c, ['pointer', ['_HANDLE_TRACE_DEBUG_INFO']]],
    'ExtraInfoPages' : [ 0x20, ['long']],
    'Flags' : [ 0x24, ['unsigned long']],
    'StrictFIFO' : [ 0x24, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'FirstFreeHandle' : [ 0x28, ['long']],
    'LastFreeHandleEntry' : [ 0x2c, ['pointer', ['_HANDLE_TABLE_ENTRY']]],
    'HandleCount' : [ 0x30, ['long']],
    'NextHandleNeedingPool' : [ 0x34, ['unsigned long']],
} ],
  '_POOL_TRACKER_BIG_PAGES' : [ 0x10, {
    'Va' : [ 0x0, ['pointer', ['void']]],
    'Key' : [ 0x4, ['unsigned long']],
    'PoolType' : [ 0x8, ['unsigned long']],
    'NumberOfBytes' : [ 0xc, ['unsigned long']],
} ],
  '_MMVAD_FLAGS2' : [ 0x4, {
    'FileOffset' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 24, native_type='unsigned long')]],
    'SecNoChange' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long')]],
    'OneSecured' : [ 0x0, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'MultipleSecured' : [ 0x0, ['BitField', dict(start_bit = 26, end_bit = 27, native_type='unsigned long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 27, end_bit = 28, native_type='unsigned long')]],
    'LongVad' : [ 0x0, ['BitField', dict(start_bit = 28, end_bit = 29, native_type='unsigned long')]],
    'ExtendableFile' : [ 0x0, ['BitField', dict(start_bit = 29, end_bit = 30, native_type='unsigned long')]],
    'Inherit' : [ 0x0, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'CopyOnWrite' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
} ],
  '_VI_CANCEL_GLOBALS' : [ 0x6c, {
    'CancelLock' : [ 0x0, ['unsigned long']],
    'IssueLock' : [ 0x4, ['unsigned long']],
    'Counters' : [ 0x8, ['array', 25, ['long']]],
} ],
  '_KALPC_RESERVE' : [ 0x14, {
    'OwnerPort' : [ 0x0, ['pointer', ['_ALPC_PORT']]],
    'HandleTable' : [ 0x4, ['pointer', ['_ALPC_HANDLE_TABLE']]],
    'Handle' : [ 0x8, ['pointer', ['void']]],
    'Message' : [ 0xc, ['pointer', ['_KALPC_MESSAGE']]],
    'Active' : [ 0x10, ['long']],
} ],
  '_TEB_ACTIVE_FRAME' : [ 0xc, {
    'Flags' : [ 0x0, ['unsigned long']],
    'Previous' : [ 0x4, ['pointer', ['_TEB_ACTIVE_FRAME']]],
    'Context' : [ 0x8, ['pointer', ['_TEB_ACTIVE_FRAME_CONTEXT']]],
} ],
  '_FILE_GET_QUOTA_INFORMATION' : [ 0x14, {
    'NextEntryOffset' : [ 0x0, ['unsigned long']],
    'SidLength' : [ 0x4, ['unsigned long']],
    'Sid' : [ 0x8, ['_SID']],
} ],
  '_CM_KEY_BODY' : [ 0x2c, {
    'Type' : [ 0x0, ['unsigned long']],
    'KeyControlBlock' : [ 0x4, ['pointer', ['_CM_KEY_CONTROL_BLOCK']]],
    'NotifyBlock' : [ 0x8, ['pointer', ['_CM_NOTIFY_BLOCK']]],
    'ProcessID' : [ 0xc, ['pointer', ['void']]],
    'KeyBodyList' : [ 0x10, ['_LIST_ENTRY']],
    'Flags' : [ 0x18, ['unsigned long']],
    'KtmTrans' : [ 0x1c, ['pointer', ['void']]],
    'KtmUow' : [ 0x20, ['pointer', ['_GUID']]],
    'ContextListHead' : [ 0x24, ['_LIST_ENTRY']],
} ],
  '_MMPTE_PROTOTYPE' : [ 0x4, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ProtoAddressLow' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 9, native_type='unsigned long')]],
    'ReadOnly' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'ProtoAddressHigh' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 32, native_type='unsigned long')]],
} ],
  '_WHEA_ERROR_PACKET_FLAGS' : [ 0x4, {
    'PreviousError' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'CpuValid' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'HypervisorError' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'Simulated' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 32, native_type='unsigned long')]],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_THERMAL_INFORMATION_EX' : [ 0x50, {
    'ThermalStamp' : [ 0x0, ['unsigned long']],
    'ThermalConstant1' : [ 0x4, ['unsigned long']],
    'ThermalConstant2' : [ 0x8, ['unsigned long']],
    'Processors' : [ 0xc, ['unsigned long']],
    'SamplingPeriod' : [ 0x10, ['unsigned long']],
    'CurrentTemperature' : [ 0x14, ['unsigned long']],
    'PassiveTripPoint' : [ 0x18, ['unsigned long']],
    'CriticalTripPoint' : [ 0x1c, ['unsigned long']],
    'ActiveTripPointCount' : [ 0x20, ['unsigned char']],
    'ActiveTripPoint' : [ 0x24, ['array', 10, ['unsigned long']]],
    'S4TransitionTripPoint' : [ 0x4c, ['unsigned long']],
} ],
  '__unnamed_1991' : [ 0x4, {
    'FilePointerIndex' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 9, native_type='unsigned long')]],
    'HardFault' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'Image' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'Spare0' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
} ],
  '__unnamed_1993' : [ 0x4, {
    'FilePointerIndex' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 9, native_type='unsigned long')]],
    'HardFault' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'Spare1' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 12, native_type='unsigned long')]],
} ],
  '_MM_PAGE_ACCESS_INFO_FLAGS' : [ 0x4, {
    'File' : [ 0x0, ['__unnamed_1991']],
    'Private' : [ 0x0, ['__unnamed_1993']],
} ],
  '_VI_VERIFIER_ISSUE' : [ 0x10, {
    'IssueType' : [ 0x0, ['unsigned long']],
    'Address' : [ 0x4, ['pointer', ['void']]],
    'Parameters' : [ 0x8, ['array', 2, ['unsigned long']]],
} ],
  '_MMSUBSECTION_FLAGS' : [ 0x4, {
    'SubsectionAccessed' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 6, native_type='unsigned short')]],
    'StartingSector4132' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 16, native_type='unsigned short')]],
    'SubsectionStatic' : [ 0x2, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'GlobalMemory' : [ 0x2, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'DirtyPages' : [ 0x2, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned short')]],
    'Spare' : [ 0x2, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned short')]],
    'SectorEndOffset' : [ 0x2, ['BitField', dict(start_bit = 4, end_bit = 16, native_type='unsigned short')]],
} ],
  '_EXCEPTION_POINTERS' : [ 0x8, {
    'ExceptionRecord' : [ 0x0, ['pointer', ['_EXCEPTION_RECORD']]],
    'ContextRecord' : [ 0x4, ['pointer', ['_CONTEXT']]],
} ],
  '_KMUTANT' : [ 0x20, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'MutantListEntry' : [ 0x10, ['_LIST_ENTRY']],
    'OwnerThread' : [ 0x18, ['pointer', ['_KTHREAD']]],
    'Abandoned' : [ 0x1c, ['unsigned char']],
    'ApcDisable' : [ 0x1d, ['unsigned char']],
} ],
  '_OBJECT_REF_INFO' : [ 0x1c, {
    'ObjectHeader' : [ 0x0, ['pointer', ['_OBJECT_HEADER']]],
    'NextRef' : [ 0x4, ['pointer', ['void']]],
    'ImageFileName' : [ 0x8, ['array', 16, ['unsigned char']]],
    'NextPos' : [ 0x18, ['unsigned short']],
    'MaxStacks' : [ 0x1a, ['unsigned short']],
    'StackInfo' : [ 0x1c, ['array', 0, ['_OBJECT_REF_STACK_INFO']]],
} ],
  '_CMHIVE' : [ 0x5e0, {
    'Hive' : [ 0x0, ['_HHIVE']],
    'FileHandles' : [ 0x2e8, ['array', 6, ['pointer', ['void']]]],
    'NotifyList' : [ 0x300, ['_LIST_ENTRY']],
    'HiveList' : [ 0x308, ['_LIST_ENTRY']],
    'HiveLock' : [ 0x310, ['pointer', ['_FAST_MUTEX']]],
    'ViewLock' : [ 0x314, ['_EX_PUSH_LOCK']],
    'ViewLockOwner' : [ 0x318, ['pointer', ['_KTHREAD']]],
    'ViewLockLast' : [ 0x31c, ['unsigned long']],
    'ViewUnLockLast' : [ 0x320, ['unsigned long']],
    'WriterLock' : [ 0x324, ['pointer', ['_FAST_MUTEX']]],
    'FlusherLock' : [ 0x328, ['_EX_PUSH_LOCK']],
    'SecurityLock' : [ 0x32c, ['_EX_PUSH_LOCK']],
    'MappedViewList' : [ 0x330, ['_LIST_ENTRY']],
    'PinnedViewList' : [ 0x338, ['_LIST_ENTRY']],
    'FlushedViewList' : [ 0x340, ['_LIST_ENTRY']],
    'MappedViewCount' : [ 0x348, ['unsigned short']],
    'PinnedViewCount' : [ 0x34a, ['unsigned short']],
    'UseCount' : [ 0x34c, ['unsigned long']],
    'ViewsPerHive' : [ 0x350, ['unsigned long']],
    'FileObject' : [ 0x354, ['pointer', ['_FILE_OBJECT']]],
    'LastShrinkHiveSize' : [ 0x358, ['unsigned long']],
    'ActualFileSize' : [ 0x360, ['_LARGE_INTEGER']],
    'FileFullPath' : [ 0x368, ['_UNICODE_STRING']],
    'FileUserName' : [ 0x370, ['_UNICODE_STRING']],
    'HiveRootPath' : [ 0x378, ['_UNICODE_STRING']],
    'SecurityCount' : [ 0x380, ['unsigned long']],
    'SecurityCacheSize' : [ 0x384, ['unsigned long']],
    'SecurityHitHint' : [ 0x388, ['long']],
    'SecurityCache' : [ 0x38c, ['pointer', ['_CM_KEY_SECURITY_CACHE_ENTRY']]],
    'SecurityHash' : [ 0x390, ['array', 64, ['_LIST_ENTRY']]],
    'UnloadEventCount' : [ 0x590, ['unsigned long']],
    'UnloadEventArray' : [ 0x594, ['pointer', ['pointer', ['_KEVENT']]]],
    'RootKcb' : [ 0x598, ['pointer', ['_CM_KEY_CONTROL_BLOCK']]],
    'Frozen' : [ 0x59c, ['unsigned char']],
    'UnloadWorkItem' : [ 0x5a0, ['pointer', ['_CM_WORKITEM']]],
    'GrowOnlyMode' : [ 0x5a4, ['unsigned char']],
    'GrowOffset' : [ 0x5a8, ['unsigned long']],
    'KcbConvertListHead' : [ 0x5ac, ['_LIST_ENTRY']],
    'KnodeConvertListHead' : [ 0x5b4, ['_LIST_ENTRY']],
    'CellRemapArray' : [ 0x5bc, ['pointer', ['_CM_CELL_REMAP_BLOCK']]],
    'Flags' : [ 0x5c0, ['unsigned long']],
    'TrustClassEntry' : [ 0x5c4, ['_LIST_ENTRY']],
    'FlushCount' : [ 0x5cc, ['unsigned long']],
    'CmRm' : [ 0x5d0, ['pointer', ['_CM_RM']]],
    'CmRmInitFailPoint' : [ 0x5d4, ['unsigned long']],
    'CmRmInitFailStatus' : [ 0x5d8, ['long']],
    'CreatorOwner' : [ 0x5dc, ['pointer', ['_KTHREAD']]],
} ],
  '_MI_IMAGE_SECURITY_REFERENCE' : [ 0xc, {
    'SecurityContext' : [ 0x0, ['_IMAGE_SECURITY_CONTEXT']],
    'DynamicRelocations' : [ 0x4, ['pointer', ['void']]],
    'ReferenceCount' : [ 0x8, ['long']],
} ],
  '_HEAP_TAG_ENTRY' : [ 0x40, {
    'Allocs' : [ 0x0, ['unsigned long']],
    'Frees' : [ 0x4, ['unsigned long']],
    'Size' : [ 0x8, ['unsigned long']],
    'TagIndex' : [ 0xc, ['unsigned short']],
    'CreatorBackTraceIndex' : [ 0xe, ['unsigned short']],
    'TagName' : [ 0x10, ['array', 24, ['wchar']]],
} ],
  '_SECURITY_QUALITY_OF_SERVICE' : [ 0xc, {
    'Length' : [ 0x0, ['unsigned long']],
    'ImpersonationLevel' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'SecurityAnonymous', 1: 'SecurityIdentification', 2: 'SecurityImpersonation', 3: 'SecurityDelegation'})]],
    'ContextTrackingMode' : [ 0x8, ['unsigned char']],
    'EffectiveOnly' : [ 0x9, ['unsigned char']],
} ],
  '__unnamed_19c2' : [ 0x8, {
    'List' : [ 0x0, ['_LIST_ENTRY']],
    'Secured' : [ 0x0, ['_MMADDRESS_LIST']],
} ],
  '__unnamed_19c8' : [ 0x4, {
    'Banked' : [ 0x0, ['pointer', ['_MMBANKED_SECTION']]],
    'ExtendedInfo' : [ 0x0, ['pointer', ['_MMEXTEND_INFO']]],
} ],
  '_MMVAD_LONG' : [ 0x3c, {
    'u1' : [ 0x0, ['__unnamed_149d']],
    'LeftChild' : [ 0x4, ['pointer', ['_MMVAD']]],
    'RightChild' : [ 0x8, ['pointer', ['_MMVAD']]],
    'StartingVpn' : [ 0xc, ['unsigned long']],
    'EndingVpn' : [ 0x10, ['unsigned long']],
    'u' : [ 0x14, ['__unnamed_14a0']],
    'PushLock' : [ 0x18, ['_EX_PUSH_LOCK']],
    'u5' : [ 0x1c, ['__unnamed_14a3']],
    'u2' : [ 0x20, ['__unnamed_14ac']],
    'Subsection' : [ 0x24, ['pointer', ['_SUBSECTION']]],
    'FirstPrototypePte' : [ 0x28, ['pointer', ['_MMPTE']]],
    'LastContiguousPte' : [ 0x2c, ['pointer', ['_MMPTE']]],
    'u3' : [ 0x30, ['__unnamed_19c2']],
    'u4' : [ 0x38, ['__unnamed_19c8']],
} ],
  '_MMWSLE_FREE_ENTRY' : [ 0x4, {
    'MustBeZero' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'PreviousFree' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 12, native_type='unsigned long')]],
    'NextFree' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 32, native_type='unsigned long')]],
} ],
  '_NT_TIB' : [ 0x1c, {
    'ExceptionList' : [ 0x0, ['pointer', ['_EXCEPTION_REGISTRATION_RECORD']]],
    'StackBase' : [ 0x4, ['pointer', ['void']]],
    'StackLimit' : [ 0x8, ['pointer', ['void']]],
    'SubSystemTib' : [ 0xc, ['pointer', ['void']]],
    'FiberData' : [ 0x10, ['pointer', ['void']]],
    'Version' : [ 0x10, ['unsigned long']],
    'ArbitraryUserPointer' : [ 0x14, ['pointer', ['void']]],
    'Self' : [ 0x18, ['pointer', ['_NT_TIB']]],
} ],
  '_EJOB' : [ 0x128, {
    'Event' : [ 0x0, ['_KEVENT']],
    'JobLinks' : [ 0x10, ['_LIST_ENTRY']],
    'ProcessListHead' : [ 0x18, ['_LIST_ENTRY']],
    'JobLock' : [ 0x20, ['_ERESOURCE']],
    'TotalUserTime' : [ 0x58, ['_LARGE_INTEGER']],
    'TotalKernelTime' : [ 0x60, ['_LARGE_INTEGER']],
    'ThisPeriodTotalUserTime' : [ 0x68, ['_LARGE_INTEGER']],
    'ThisPeriodTotalKernelTime' : [ 0x70, ['_LARGE_INTEGER']],
    'TotalPageFaultCount' : [ 0x78, ['unsigned long']],
    'TotalProcesses' : [ 0x7c, ['unsigned long']],
    'ActiveProcesses' : [ 0x80, ['unsigned long']],
    'TotalTerminatedProcesses' : [ 0x84, ['unsigned long']],
    'PerProcessUserTimeLimit' : [ 0x88, ['_LARGE_INTEGER']],
    'PerJobUserTimeLimit' : [ 0x90, ['_LARGE_INTEGER']],
    'LimitFlags' : [ 0x98, ['unsigned long']],
    'MinimumWorkingSetSize' : [ 0x9c, ['unsigned long']],
    'MaximumWorkingSetSize' : [ 0xa0, ['unsigned long']],
    'ActiveProcessLimit' : [ 0xa4, ['unsigned long']],
    'Affinity' : [ 0xa8, ['unsigned long']],
    'PriorityClass' : [ 0xac, ['unsigned char']],
    'AccessState' : [ 0xb0, ['pointer', ['_JOB_ACCESS_STATE']]],
    'UIRestrictionsClass' : [ 0xb4, ['unsigned long']],
    'EndOfJobTimeAction' : [ 0xb8, ['unsigned long']],
    'CompletionPort' : [ 0xbc, ['pointer', ['void']]],
    'CompletionKey' : [ 0xc0, ['pointer', ['void']]],
    'SessionId' : [ 0xc4, ['unsigned long']],
    'SchedulingClass' : [ 0xc8, ['unsigned long']],
    'ReadOperationCount' : [ 0xd0, ['unsigned long long']],
    'WriteOperationCount' : [ 0xd8, ['unsigned long long']],
    'OtherOperationCount' : [ 0xe0, ['unsigned long long']],
    'ReadTransferCount' : [ 0xe8, ['unsigned long long']],
    'WriteTransferCount' : [ 0xf0, ['unsigned long long']],
    'OtherTransferCount' : [ 0xf8, ['unsigned long long']],
    'ProcessMemoryLimit' : [ 0x100, ['unsigned long']],
    'JobMemoryLimit' : [ 0x104, ['unsigned long']],
    'PeakProcessMemoryUsed' : [ 0x108, ['unsigned long']],
    'PeakJobMemoryUsed' : [ 0x10c, ['unsigned long']],
    'CurrentJobMemoryUsed' : [ 0x110, ['unsigned long']],
    'MemoryLimitsLock' : [ 0x114, ['_EX_PUSH_LOCK']],
    'JobSetLinks' : [ 0x118, ['_LIST_ENTRY']],
    'MemberLevel' : [ 0x120, ['unsigned long']],
    'JobFlags' : [ 0x124, ['unsigned long']],
} ],
  '__unnamed_19d8' : [ 0x4, {
    'AsULONG' : [ 0x0, ['unsigned long']],
    'AllowScaling' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Disabled' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Hypervisor' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 4, native_type='unsigned long')]],
    'HvMaxCState' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 32, native_type='unsigned long')]],
} ],
  '_PPM_IDLE_STATES' : [ 0x3c, {
    'Type' : [ 0x0, ['unsigned long']],
    'Count' : [ 0x4, ['unsigned long']],
    'Flags' : [ 0x8, ['__unnamed_19d8']],
    'TargetState' : [ 0xc, ['unsigned long']],
    'ActualState' : [ 0x10, ['unsigned long']],
    'OldState' : [ 0x14, ['unsigned long']],
    'TargetProcessors' : [ 0x18, ['unsigned long']],
    'State' : [ 0x1c, ['array', 1, ['_PPM_IDLE_STATE']]],
} ],
  '_PEB' : [ 0x238, {
    'InheritedAddressSpace' : [ 0x0, ['unsigned char']],
    'ReadImageFileExecOptions' : [ 0x1, ['unsigned char']],
    'BeingDebugged' : [ 0x2, ['unsigned char']],
    'BitField' : [ 0x3, ['unsigned char']],
    'ImageUsesLargePages' : [ 0x3, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'IsProtectedProcess' : [ 0x3, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'IsLegacyProcess' : [ 0x3, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'IsImageDynamicallyRelocated' : [ 0x3, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'SkipPatchingUser32Forwarders' : [ 0x3, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'SpareBits' : [ 0x3, ['BitField', dict(start_bit = 5, end_bit = 8, native_type='unsigned char')]],
    'Mutant' : [ 0x4, ['pointer', ['void']]],
    'ImageBaseAddress' : [ 0x8, ['pointer', ['void']]],
    'Ldr' : [ 0xc, ['pointer', ['_PEB_LDR_DATA']]],
    'ProcessParameters' : [ 0x10, ['pointer', ['_RTL_USER_PROCESS_PARAMETERS']]],
    'SubSystemData' : [ 0x14, ['pointer', ['void']]],
    'ProcessHeap' : [ 0x18, ['pointer', ['void']]],
    'FastPebLock' : [ 0x1c, ['pointer', ['_RTL_CRITICAL_SECTION']]],
    'AtlThunkSListPtr' : [ 0x20, ['pointer', ['void']]],
    'IFEOKey' : [ 0x24, ['pointer', ['void']]],
    'CrossProcessFlags' : [ 0x28, ['unsigned long']],
    'ProcessInJob' : [ 0x28, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ProcessInitializing' : [ 0x28, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ProcessUsingVEH' : [ 0x28, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'ProcessUsingVCH' : [ 0x28, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'ReservedBits0' : [ 0x28, ['BitField', dict(start_bit = 4, end_bit = 32, native_type='unsigned long')]],
    'KernelCallbackTable' : [ 0x2c, ['pointer', ['void']]],
    'UserSharedInfoPtr' : [ 0x2c, ['pointer', ['void']]],
    'SystemReserved' : [ 0x30, ['array', 1, ['unsigned long']]],
    'SpareUlong' : [ 0x34, ['unsigned long']],
    'SparePebPtr0' : [ 0x38, ['unsigned long']],
    'TlsExpansionCounter' : [ 0x3c, ['unsigned long']],
    'TlsBitmap' : [ 0x40, ['pointer', ['void']]],
    'TlsBitmapBits' : [ 0x44, ['array', 2, ['unsigned long']]],
    'ReadOnlySharedMemoryBase' : [ 0x4c, ['pointer', ['void']]],
    'HotpatchInformation' : [ 0x50, ['pointer', ['void']]],
    'ReadOnlyStaticServerData' : [ 0x54, ['pointer', ['pointer', ['void']]]],
    'AnsiCodePageData' : [ 0x58, ['pointer', ['void']]],
    'OemCodePageData' : [ 0x5c, ['pointer', ['void']]],
    'UnicodeCaseTableData' : [ 0x60, ['pointer', ['void']]],
    'NumberOfProcessors' : [ 0x64, ['unsigned long']],
    'NtGlobalFlag' : [ 0x68, ['unsigned long']],
    'CriticalSectionTimeout' : [ 0x70, ['_LARGE_INTEGER']],
    'HeapSegmentReserve' : [ 0x78, ['unsigned long']],
    'HeapSegmentCommit' : [ 0x7c, ['unsigned long']],
    'HeapDeCommitTotalFreeThreshold' : [ 0x80, ['unsigned long']],
    'HeapDeCommitFreeBlockThreshold' : [ 0x84, ['unsigned long']],
    'NumberOfHeaps' : [ 0x88, ['unsigned long']],
    'MaximumNumberOfHeaps' : [ 0x8c, ['unsigned long']],
    'ProcessHeaps' : [ 0x90, ['pointer', ['pointer', ['void']]]],
    'GdiSharedHandleTable' : [ 0x94, ['pointer', ['void']]],
    'ProcessStarterHelper' : [ 0x98, ['pointer', ['void']]],
    'GdiDCAttributeList' : [ 0x9c, ['unsigned long']],
    'LoaderLock' : [ 0xa0, ['pointer', ['_RTL_CRITICAL_SECTION']]],
    'OSMajorVersion' : [ 0xa4, ['unsigned long']],
    'OSMinorVersion' : [ 0xa8, ['unsigned long']],
    'OSBuildNumber' : [ 0xac, ['unsigned short']],
    'OSCSDVersion' : [ 0xae, ['unsigned short']],
    'OSPlatformId' : [ 0xb0, ['unsigned long']],
    'ImageSubsystem' : [ 0xb4, ['unsigned long']],
    'ImageSubsystemMajorVersion' : [ 0xb8, ['unsigned long']],
    'ImageSubsystemMinorVersion' : [ 0xbc, ['unsigned long']],
    'ActiveProcessAffinityMask' : [ 0xc0, ['unsigned long']],
    'GdiHandleBuffer' : [ 0xc4, ['array', 34, ['unsigned long']]],
    'PostProcessInitRoutine' : [ 0x14c, ['pointer', ['void']]],
    'TlsExpansionBitmap' : [ 0x150, ['pointer', ['void']]],
    'TlsExpansionBitmapBits' : [ 0x154, ['array', 32, ['unsigned long']]],
    'SessionId' : [ 0x1d4, ['unsigned long']],
    'AppCompatFlags' : [ 0x1d8, ['_ULARGE_INTEGER']],
    'AppCompatFlagsUser' : [ 0x1e0, ['_ULARGE_INTEGER']],
    'pShimData' : [ 0x1e8, ['pointer', ['void']]],
    'AppCompatInfo' : [ 0x1ec, ['pointer', ['void']]],
    'CSDVersion' : [ 0x1f0, ['_UNICODE_STRING']],
    'ActivationContextData' : [ 0x1f8, ['pointer', ['_ACTIVATION_CONTEXT_DATA']]],
    'ProcessAssemblyStorageMap' : [ 0x1fc, ['pointer', ['_ASSEMBLY_STORAGE_MAP']]],
    'SystemDefaultActivationContextData' : [ 0x200, ['pointer', ['_ACTIVATION_CONTEXT_DATA']]],
    'SystemAssemblyStorageMap' : [ 0x204, ['pointer', ['_ASSEMBLY_STORAGE_MAP']]],
    'MinimumStackCommit' : [ 0x208, ['unsigned long']],
    'FlsCallback' : [ 0x20c, ['pointer', ['_FLS_CALLBACK_INFO']]],
    'FlsListHead' : [ 0x210, ['_LIST_ENTRY']],
    'FlsBitmap' : [ 0x218, ['pointer', ['void']]],
    'FlsBitmapBits' : [ 0x21c, ['array', 4, ['unsigned long']]],
    'FlsHighIndex' : [ 0x22c, ['unsigned long']],
    'WerRegistrationData' : [ 0x230, ['pointer', ['void']]],
    'WerShipAssertPtr' : [ 0x234, ['pointer', ['void']]],
} ],
  '__unnamed_19f0' : [ 0x10, {
    'EfiInformation' : [ 0x0, ['_EFI_FIRMWARE_INFORMATION']],
    'PcatInformation' : [ 0x0, ['_PCAT_FIRMWARE_INFORMATION']],
} ],
  '_FIRMWARE_INFORMATION_LOADER_BLOCK' : [ 0x14, {
    'FirmwareTypeEfi' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 32, native_type='unsigned long')]],
    'u' : [ 0x4, ['__unnamed_19f0']],
} ],
  '_HEAP_UCR_DESCRIPTOR' : [ 0x18, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'SegmentEntry' : [ 0x8, ['_LIST_ENTRY']],
    'Address' : [ 0x10, ['pointer', ['void']]],
    'Size' : [ 0x14, ['unsigned long']],
} ],
  '__unnamed_19f7' : [ 0x4, {
    'BaseMid' : [ 0x0, ['unsigned char']],
    'Flags1' : [ 0x1, ['unsigned char']],
    'Flags2' : [ 0x2, ['unsigned char']],
    'BaseHi' : [ 0x3, ['unsigned char']],
} ],
  '__unnamed_19fd' : [ 0x4, {
    'BaseMid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned long')]],
    'Type' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 13, native_type='unsigned long')]],
    'Dpl' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 15, native_type='unsigned long')]],
    'Pres' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'LimitHi' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 20, native_type='unsigned long')]],
    'Sys' : [ 0x0, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'Reserved_0' : [ 0x0, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'Default_Big' : [ 0x0, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long')]],
    'Granularity' : [ 0x0, ['BitField', dict(start_bit = 23, end_bit = 24, native_type='unsigned long')]],
    'BaseHi' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_19ff' : [ 0x4, {
    'Bytes' : [ 0x0, ['__unnamed_19f7']],
    'Bits' : [ 0x0, ['__unnamed_19fd']],
} ],
  '_KGDTENTRY' : [ 0x8, {
    'LimitLow' : [ 0x0, ['unsigned short']],
    'BaseLow' : [ 0x2, ['unsigned short']],
    'HighWord' : [ 0x4, ['__unnamed_19ff']],
} ],
  '_POOL_DESCRIPTOR' : [ 0x1034, {
    'PoolType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'NonPagedPool', 1: 'PagedPool', 2: 'NonPagedPoolMustSucceed', 3: 'DontUseThisType', 4: 'NonPagedPoolCacheAligned', 5: 'PagedPoolCacheAligned', 6: 'NonPagedPoolCacheAlignedMustS', 7: 'MaxPoolType', 34: 'NonPagedPoolMustSucceedSession', 35: 'DontUseThisTypeSession', 32: 'NonPagedPoolSession', 36: 'NonPagedPoolCacheAlignedSession', 33: 'PagedPoolSession', 38: 'NonPagedPoolCacheAlignedMustSSession', 37: 'PagedPoolCacheAlignedSession'})]],
    'PoolIndex' : [ 0x4, ['unsigned long']],
    'RunningAllocs' : [ 0x8, ['long']],
    'RunningDeAllocs' : [ 0xc, ['long']],
    'TotalPages' : [ 0x10, ['long']],
    'TotalBigPages' : [ 0x14, ['long']],
    'Threshold' : [ 0x18, ['unsigned long']],
    'LockAddress' : [ 0x1c, ['pointer', ['void']]],
    'PendingFrees' : [ 0x20, ['pointer', ['pointer', ['void']]]],
    'ThreadsProcessingDeferrals' : [ 0x24, ['long']],
    'PendingFreeDepth' : [ 0x28, ['long']],
    'TotalBytes' : [ 0x2c, ['unsigned long']],
    'Spare0' : [ 0x30, ['unsigned long']],
    'ListHeads' : [ 0x34, ['array', 512, ['_LIST_ENTRY']]],
} ],
  '_KGATE' : [ 0x10, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
} ],
  '_WHEA_ERROR_RECORD_HEADER' : [ 0x80, {
    'Signature' : [ 0x0, ['unsigned long']],
    'Revision' : [ 0x4, ['_WHEA_REVISION']],
    'SignatureEnd' : [ 0x6, ['unsigned long']],
    'SectionCount' : [ 0xa, ['unsigned short']],
    'Severity' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: 'WheaErrSevRecoverable', 1: 'WheaErrSevFatal', 2: 'WheaErrSevCorrected', 3: 'WheaErrSevNone'})]],
    'ValidBits' : [ 0x10, ['_WHEA_ERROR_RECORD_HEADER_VALIDBITS']],
    'Length' : [ 0x14, ['unsigned long']],
    'Timestamp' : [ 0x18, ['_WHEA_TIMESTAMP']],
    'PlatformId' : [ 0x20, ['_GUID']],
    'PartitionId' : [ 0x30, ['_GUID']],
    'CreatorId' : [ 0x40, ['_GUID']],
    'NotifyType' : [ 0x50, ['_GUID']],
    'RecordId' : [ 0x60, ['unsigned long long']],
    'Flags' : [ 0x68, ['_WHEA_ERROR_RECORD_HEADER_FLAGS']],
    'PersistenceInfo' : [ 0x6c, ['_WHEA_PERSISTENCE_INFO']],
    'Reserved' : [ 0x74, ['array', 12, ['unsigned char']]],
} ],
  '_ALPC_PROCESS_CONTEXT' : [ 0x10, {
    'Lock' : [ 0x0, ['_EX_PUSH_LOCK']],
    'ViewListHead' : [ 0x4, ['_LIST_ENTRY']],
    'PagedPoolQuotaCache' : [ 0xc, ['unsigned long']],
} ],
  '_CM_NOTIFY_BLOCK' : [ 0x2c, {
    'HiveList' : [ 0x0, ['_LIST_ENTRY']],
    'PostList' : [ 0x8, ['_LIST_ENTRY']],
    'KeyControlBlock' : [ 0x10, ['pointer', ['_CM_KEY_CONTROL_BLOCK']]],
    'KeyBody' : [ 0x14, ['pointer', ['_CM_KEY_BODY']]],
    'Filter' : [ 0x18, ['BitField', dict(start_bit = 0, end_bit = 30, native_type='unsigned long')]],
    'WatchTree' : [ 0x18, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'NotifyPending' : [ 0x18, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'SubjectContext' : [ 0x1c, ['_SECURITY_SUBJECT_CONTEXT']],
} ],
  '_KINTERRUPT' : [ 0x270, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['short']],
    'InterruptListEntry' : [ 0x4, ['_LIST_ENTRY']],
    'ServiceRoutine' : [ 0xc, ['pointer', ['void']]],
    'MessageServiceRoutine' : [ 0x10, ['pointer', ['void']]],
    'MessageIndex' : [ 0x14, ['unsigned long']],
    'ServiceContext' : [ 0x18, ['pointer', ['void']]],
    'SpinLock' : [ 0x1c, ['unsigned long']],
    'TickCount' : [ 0x20, ['unsigned long']],
    'ActualLock' : [ 0x24, ['pointer', ['unsigned long']]],
    'DispatchAddress' : [ 0x28, ['pointer', ['void']]],
    'Vector' : [ 0x2c, ['unsigned long']],
    'Irql' : [ 0x30, ['unsigned char']],
    'SynchronizeIrql' : [ 0x31, ['unsigned char']],
    'FloatingSave' : [ 0x32, ['unsigned char']],
    'Connected' : [ 0x33, ['unsigned char']],
    'Number' : [ 0x34, ['unsigned char']],
    'ShareVector' : [ 0x35, ['unsigned char']],
    'Mode' : [ 0x38, ['Enumeration', dict(target = 'long', choices = {0: 'LevelSensitive', 1: 'Latched'})]],
    'Polarity' : [ 0x3c, ['Enumeration', dict(target = 'long', choices = {0: 'InterruptPolarityUnknown', 1: 'InterruptActiveHigh', 2: 'InterruptActiveLow'})]],
    'ServiceCount' : [ 0x40, ['unsigned long']],
    'DispatchCount' : [ 0x44, ['unsigned long']],
    'Rsvd1' : [ 0x48, ['unsigned long long']],
    'DispatchCode' : [ 0x50, ['array', 135, ['unsigned long']]],
} ],
  '_HANDLE_TABLE_ENTRY' : [ 0x8, {
    'Object' : [ 0x0, ['pointer', ['void']]],
    'ObAttributes' : [ 0x0, ['unsigned long']],
    'InfoTable' : [ 0x0, ['pointer', ['_HANDLE_TABLE_ENTRY_INFO']]],
    'Value' : [ 0x0, ['unsigned long']],
    'GrantedAccess' : [ 0x4, ['unsigned long']],
    'GrantedAccessIndex' : [ 0x4, ['unsigned short']],
    'CreatorBackTraceIndex' : [ 0x6, ['unsigned short']],
    'NextFreeTableEntry' : [ 0x4, ['long']],
} ],
  '_SID' : [ 0xc, {
    'Revision' : [ 0x0, ['unsigned char']],
    'SubAuthorityCount' : [ 0x1, ['unsigned char']],
    'IdentifierAuthority' : [ 0x2, ['_SID_IDENTIFIER_AUTHORITY']],
    'SubAuthority' : [ 0x8, ['array', 1, ['unsigned long']]],
} ],
  '_IMAGE_FILE_HEADER' : [ 0x14, {
    'Machine' : [ 0x0, ['unsigned short']],
    'NumberOfSections' : [ 0x2, ['unsigned short']],
    'TimeDateStamp' : [ 0x4, ['unsigned long']],
    'PointerToSymbolTable' : [ 0x8, ['unsigned long']],
    'NumberOfSymbols' : [ 0xc, ['unsigned long']],
    'SizeOfOptionalHeader' : [ 0x10, ['unsigned short']],
    'Characteristics' : [ 0x12, ['unsigned short']],
} ],
  '_MMEXTEND_INFO' : [ 0x10, {
    'CommittedSize' : [ 0x0, ['unsigned long long']],
    'ReferenceCount' : [ 0x8, ['unsigned long']],
} ],
  '_HIVE_LIST_ENTRY' : [ 0x20, {
    'FileName' : [ 0x0, ['pointer', ['unsigned short']]],
    'BaseName' : [ 0x4, ['pointer', ['unsigned short']]],
    'RegRootName' : [ 0x8, ['pointer', ['unsigned short']]],
    'CmHive' : [ 0xc, ['pointer', ['_CMHIVE']]],
    'HHiveFlags' : [ 0x10, ['unsigned long']],
    'CmHiveFlags' : [ 0x14, ['unsigned long']],
    'CmHive2' : [ 0x18, ['pointer', ['_CMHIVE']]],
    'ThreadFinished' : [ 0x1c, ['unsigned char']],
    'ThreadStarted' : [ 0x1d, ['unsigned char']],
    'Allocate' : [ 0x1e, ['unsigned char']],
    'WinPERequired' : [ 0x1f, ['unsigned char']],
} ],
  '_CONTEXT' : [ 0x2cc, {
    'ContextFlags' : [ 0x0, ['unsigned long']],
    'Dr0' : [ 0x4, ['unsigned long']],
    'Dr1' : [ 0x8, ['unsigned long']],
    'Dr2' : [ 0xc, ['unsigned long']],
    'Dr3' : [ 0x10, ['unsigned long']],
    'Dr6' : [ 0x14, ['unsigned long']],
    'Dr7' : [ 0x18, ['unsigned long']],
    'FloatSave' : [ 0x1c, ['_FLOATING_SAVE_AREA']],
    'SegGs' : [ 0x8c, ['unsigned long']],
    'SegFs' : [ 0x90, ['unsigned long']],
    'SegEs' : [ 0x94, ['unsigned long']],
    'SegDs' : [ 0x98, ['unsigned long']],
    'Edi' : [ 0x9c, ['unsigned long']],
    'Esi' : [ 0xa0, ['unsigned long']],
    'Ebx' : [ 0xa4, ['unsigned long']],
    'Edx' : [ 0xa8, ['unsigned long']],
    'Ecx' : [ 0xac, ['unsigned long']],
    'Eax' : [ 0xb0, ['unsigned long']],
    'Ebp' : [ 0xb4, ['unsigned long']],
    'Eip' : [ 0xb8, ['unsigned long']],
    'SegCs' : [ 0xbc, ['unsigned long']],
    'EFlags' : [ 0xc0, ['unsigned long']],
    'Esp' : [ 0xc4, ['unsigned long']],
    'SegSs' : [ 0xc8, ['unsigned long']],
    'ExtendedRegisters' : [ 0xcc, ['array', 512, ['unsigned char']]],
} ],
  '_ALPC_HANDLE_TABLE' : [ 0x10, {
    'Flags' : [ 0x0, ['unsigned long']],
    'Handles' : [ 0x4, ['pointer', ['_ALPC_HANDLE_ENTRY']]],
    'TotalHandles' : [ 0x8, ['unsigned long']],
    'Lock' : [ 0xc, ['_EX_PUSH_LOCK']],
} ],
  '_MMPTE_HARDWARE' : [ 0x4, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Dirty1' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Owner' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'WriteThrough' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'CacheDisable' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'Accessed' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'Dirty' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'LargePage' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'Global' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'CopyOnWrite' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'Write' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'PageFrameNumber' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 32, native_type='unsigned long')]],
} ],
  '_IO_COMPLETION_CONTEXT' : [ 0x8, {
    'Port' : [ 0x0, ['pointer', ['void']]],
    'Key' : [ 0x4, ['pointer', ['void']]],
} ],
  '_IOV_FORCED_PENDING_TRACE' : [ 0x100, {
    'Irp' : [ 0x0, ['pointer', ['_IRP']]],
    'StackTrace' : [ 0x4, ['array', 63, ['pointer', ['void']]]],
} ],
  '_DBGKD_SET_CONTEXT' : [ 0x4, {
    'ContextFlags' : [ 0x0, ['unsigned long']],
} ],
  '_VI_POOL_ENTRY_INUSE' : [ 0x10, {
    'VirtualAddress' : [ 0x0, ['pointer', ['void']]],
    'CallingAddress' : [ 0x4, ['pointer', ['void']]],
    'NumberOfBytes' : [ 0x8, ['unsigned long']],
    'Tag' : [ 0xc, ['unsigned long']],
} ],
  '_ALPC_COMPLETION_LIST' : [ 0x54, {
    'Entry' : [ 0x0, ['_LIST_ENTRY']],
    'OwnerProcess' : [ 0x8, ['pointer', ['_EPROCESS']]],
    'Mdl' : [ 0xc, ['pointer', ['_MDL']]],
    'UserVa' : [ 0x10, ['pointer', ['void']]],
    'UserLimit' : [ 0x14, ['pointer', ['void']]],
    'DataUserVa' : [ 0x18, ['pointer', ['void']]],
    'SystemVa' : [ 0x1c, ['pointer', ['void']]],
    'TotalSize' : [ 0x20, ['unsigned long']],
    'Header' : [ 0x24, ['pointer', ['_ALPC_COMPLETION_LIST_HEADER']]],
    'List' : [ 0x28, ['pointer', ['void']]],
    'ListSize' : [ 0x2c, ['unsigned long']],
    'Bitmap' : [ 0x30, ['pointer', ['void']]],
    'BitmapSize' : [ 0x34, ['unsigned long']],
    'Data' : [ 0x38, ['pointer', ['void']]],
    'DataSize' : [ 0x3c, ['unsigned long']],
    'BitmapLimit' : [ 0x40, ['unsigned long']],
    'BitmapNextHint' : [ 0x44, ['unsigned long']],
    'ConcurrencyCount' : [ 0x48, ['unsigned long']],
    'AttributeFlags' : [ 0x4c, ['unsigned long']],
    'AttributeSize' : [ 0x50, ['unsigned long']],
} ],
  '_INTERFACE' : [ 0x10, {
    'Size' : [ 0x0, ['unsigned short']],
    'Version' : [ 0x2, ['unsigned short']],
    'Context' : [ 0x4, ['pointer', ['void']]],
    'InterfaceReference' : [ 0x8, ['pointer', ['void']]],
    'InterfaceDereference' : [ 0xc, ['pointer', ['void']]],
} ],
  '_ACL' : [ 0x8, {
    'AclRevision' : [ 0x0, ['unsigned char']],
    'Sbz1' : [ 0x1, ['unsigned char']],
    'AclSize' : [ 0x2, ['unsigned short']],
    'AceCount' : [ 0x4, ['unsigned short']],
    'Sbz2' : [ 0x6, ['unsigned short']],
} ],
  '_LAZY_WRITER' : [ 0x58, {
    'WorkQueue' : [ 0x0, ['_LIST_ENTRY']],
    'ScanDpc' : [ 0x8, ['_KDPC']],
    'ScanTimer' : [ 0x28, ['_KTIMER']],
    'ScanActive' : [ 0x50, ['unsigned char']],
    'OtherWork' : [ 0x51, ['unsigned char']],
    'PendingTeardown' : [ 0x52, ['unsigned char']],
} ],
  '_PI_BUS_EXTENSION' : [ 0x44, {
    'Flags' : [ 0x0, ['unsigned long']],
    'NumberCSNs' : [ 0x4, ['unsigned char']],
    'ReadDataPort' : [ 0x8, ['pointer', ['unsigned char']]],
    'DataPortMapped' : [ 0xc, ['unsigned char']],
    'AddressPort' : [ 0x10, ['pointer', ['unsigned char']]],
    'AddrPortMapped' : [ 0x14, ['unsigned char']],
    'CommandPort' : [ 0x18, ['pointer', ['unsigned char']]],
    'CmdPortMapped' : [ 0x1c, ['unsigned char']],
    'NextSlotNumber' : [ 0x20, ['unsigned long']],
    'DeviceList' : [ 0x24, ['_SINGLE_LIST_ENTRY']],
    'CardList' : [ 0x28, ['_SINGLE_LIST_ENTRY']],
    'PhysicalBusDevice' : [ 0x2c, ['pointer', ['_DEVICE_OBJECT']]],
    'FunctionalBusDevice' : [ 0x30, ['pointer', ['_DEVICE_OBJECT']]],
    'AttachedDevice' : [ 0x34, ['pointer', ['_DEVICE_OBJECT']]],
    'BusNumber' : [ 0x38, ['unsigned long']],
    'SystemPowerState' : [ 0x3c, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'DevicePowerState' : [ 0x40, ['Enumeration', dict(target = 'long', choices = {0: 'PowerDeviceUnspecified', 1: 'PowerDeviceD0', 2: 'PowerDeviceD1', 3: 'PowerDeviceD2', 4: 'PowerDeviceD3', 5: 'PowerDeviceMaximum'})]],
} ],
  '_DRIVER_OBJECT' : [ 0xa8, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['short']],
    'DeviceObject' : [ 0x4, ['pointer', ['_DEVICE_OBJECT']]],
    'Flags' : [ 0x8, ['unsigned long']],
    'DriverStart' : [ 0xc, ['pointer', ['void']]],
    'DriverSize' : [ 0x10, ['unsigned long']],
    'DriverSection' : [ 0x14, ['pointer', ['void']]],
    'DriverExtension' : [ 0x18, ['pointer', ['_DRIVER_EXTENSION']]],
    'DriverName' : [ 0x1c, ['_UNICODE_STRING']],
    'HardwareDatabase' : [ 0x24, ['pointer', ['_UNICODE_STRING']]],
    'FastIoDispatch' : [ 0x28, ['pointer', ['_FAST_IO_DISPATCH']]],
    'DriverInit' : [ 0x2c, ['pointer', ['void']]],
    'DriverStartIo' : [ 0x30, ['pointer', ['void']]],
    'DriverUnload' : [ 0x34, ['pointer', ['void']]],
    'MajorFunction' : [ 0x38, ['array', 28, ['pointer', ['void']]]],
} ],
  '_SID_AND_ATTRIBUTES' : [ 0x8, {
    'Sid' : [ 0x0, ['pointer', ['void']]],
    'Attributes' : [ 0x4, ['unsigned long']],
} ],
  '_SID_IDENTIFIER_AUTHORITY' : [ 0x6, {
    'Value' : [ 0x0, ['array', 6, ['unsigned char']]],
} ],
  '_CM_RM' : [ 0x58, {
    'RmListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'TransactionListHead' : [ 0x8, ['_LIST_ENTRY']],
    'TmHandle' : [ 0x10, ['pointer', ['void']]],
    'Tm' : [ 0x14, ['pointer', ['void']]],
    'RmHandle' : [ 0x18, ['pointer', ['void']]],
    'KtmRm' : [ 0x1c, ['pointer', ['void']]],
    'RefCount' : [ 0x20, ['unsigned long']],
    'ContainerNum' : [ 0x24, ['unsigned long']],
    'ContainerSize' : [ 0x28, ['unsigned long long']],
    'CmHive' : [ 0x30, ['pointer', ['_CMHIVE']]],
    'LogFileObject' : [ 0x34, ['pointer', ['void']]],
    'MarshallingContext' : [ 0x38, ['pointer', ['void']]],
    'RmFlags' : [ 0x3c, ['unsigned long']],
    'LogStartStatus1' : [ 0x40, ['long']],
    'LogStartStatus2' : [ 0x44, ['long']],
    'BaseLsn' : [ 0x48, ['unsigned long long']],
    'RmLock' : [ 0x50, ['pointer', ['_ERESOURCE']]],
} ],
  '_MMVAD_FLAGS' : [ 0x4, {
    'CommitCharge' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 19, native_type='unsigned long')]],
    'NoChange' : [ 0x0, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'VadType' : [ 0x0, ['BitField', dict(start_bit = 20, end_bit = 23, native_type='unsigned long')]],
    'MemCommit' : [ 0x0, ['BitField', dict(start_bit = 23, end_bit = 24, native_type='unsigned long')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 29, native_type='unsigned long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 29, end_bit = 31, native_type='unsigned long')]],
    'PrivateMemory' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
} ],
  '_WHEA_PCIXDEVICE_ERROR' : [ 0x68, {
    'ValidBits' : [ 0x0, ['_WHEA_PCIXDEVICE_ERROR_VALIDBITS']],
    'ErrorStatus' : [ 0x8, ['_WHEA_ERROR_STATUS']],
    'IdInfo' : [ 0x10, ['_WHEA_PCIXDEVICE_ID']],
    'MemoryNumber' : [ 0x20, ['unsigned long']],
    'IoNumber' : [ 0x24, ['unsigned long']],
    'RegisterDataPairs' : [ 0x28, ['array', 4, ['WHEA_PCIXDEVICE_REGISTER_PAIR']]],
} ],
  '_MMWSLE_HASH' : [ 0x4, {
    'Index' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_1a7e' : [ 0x18, {
    'CriticalSection' : [ 0x0, ['_RTL_CRITICAL_SECTION']],
} ],
  '_HEAP_LOCK' : [ 0x18, {
    'Lock' : [ 0x0, ['__unnamed_1a7e']],
} ],
  '_DBGKD_FILL_MEMORY' : [ 0x10, {
    'Address' : [ 0x0, ['unsigned long long']],
    'Length' : [ 0x8, ['unsigned long']],
    'Flags' : [ 0xc, ['unsigned short']],
    'PatternLength' : [ 0xe, ['unsigned short']],
} ],
  '_DRIVER_EXTENSION' : [ 0x1c, {
    'DriverObject' : [ 0x0, ['pointer', ['_DRIVER_OBJECT']]],
    'AddDevice' : [ 0x4, ['pointer', ['void']]],
    'Count' : [ 0x8, ['unsigned long']],
    'ServiceKeyName' : [ 0xc, ['_UNICODE_STRING']],
    'ClientDriverExtension' : [ 0x14, ['pointer', ['_IO_CLIENT_EXTENSION']]],
    'FsFilterCallbacks' : [ 0x18, ['pointer', ['_FS_FILTER_CALLBACKS']]],
} ],
  '_HEAP_STOP_ON_VALUES' : [ 0x18, {
    'AllocAddress' : [ 0x0, ['unsigned long']],
    'AllocTag' : [ 0x4, ['_HEAP_STOP_ON_TAG']],
    'ReAllocAddress' : [ 0x8, ['unsigned long']],
    'ReAllocTag' : [ 0xc, ['_HEAP_STOP_ON_TAG']],
    'FreeAddress' : [ 0x10, ['unsigned long']],
    'FreeTag' : [ 0x14, ['_HEAP_STOP_ON_TAG']],
} ],
  '_PP_LOOKASIDE_LIST' : [ 0x8, {
    'P' : [ 0x0, ['pointer', ['_GENERAL_LOOKASIDE']]],
    'L' : [ 0x4, ['pointer', ['_GENERAL_LOOKASIDE']]],
} ],
  '_HEAP_PSEUDO_TAG_ENTRY' : [ 0xc, {
    'Allocs' : [ 0x0, ['unsigned long']],
    'Frees' : [ 0x4, ['unsigned long']],
    'Size' : [ 0x8, ['unsigned long']],
} ],
  '_CALL_HASH_ENTRY' : [ 0x14, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'CallersAddress' : [ 0x8, ['pointer', ['void']]],
    'CallersCaller' : [ 0xc, ['pointer', ['void']]],
    'CallCount' : [ 0x10, ['unsigned long']],
} ],
  '_VF_TRACKER_STAMP' : [ 0x8, {
    'Thread' : [ 0x0, ['pointer', ['void']]],
    'Flags' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned char')]],
    'OldIrql' : [ 0x5, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned char')]],
    'NewIrql' : [ 0x6, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned char')]],
    'Processor' : [ 0x7, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned char')]],
} ],
  '_VI_TRACK_IRQL' : [ 0x20, {
    'Thread' : [ 0x0, ['pointer', ['void']]],
    'OldIrql' : [ 0x4, ['unsigned char']],
    'NewIrql' : [ 0x5, ['unsigned char']],
    'Processor' : [ 0x6, ['unsigned char']],
    'TickCount' : [ 0x8, ['unsigned long']],
    'StackTrace' : [ 0xc, ['array', 5, ['pointer', ['void']]]],
} ],
  '_PEB_LDR_DATA' : [ 0x30, {
    'Length' : [ 0x0, ['unsigned long']],
    'Initialized' : [ 0x4, ['unsigned char']],
    'SsHandle' : [ 0x8, ['pointer', ['void']]],
    'InLoadOrderModuleList' : [ 0xc, ['_LIST_ENTRY']],
    'InMemoryOrderModuleList' : [ 0x14, ['_LIST_ENTRY']],
    'InInitializationOrderModuleList' : [ 0x1c, ['_LIST_ENTRY']],
    'EntryInProgress' : [ 0x24, ['pointer', ['void']]],
    'ShutdownInProgress' : [ 0x28, ['unsigned char']],
    'ShutdownThreadId' : [ 0x2c, ['pointer', ['void']]],
} ],
  '_HEAP_STOP_ON_TAG' : [ 0x4, {
    'HeapAndTagIndex' : [ 0x0, ['unsigned long']],
    'TagIndex' : [ 0x0, ['unsigned short']],
    'HeapIndex' : [ 0x2, ['unsigned short']],
} ],
  '_DBGKD_GET_CONTEXT' : [ 0x4, {
    'Unused' : [ 0x0, ['unsigned long']],
} ],
  '_TEB_ACTIVE_FRAME_CONTEXT' : [ 0x8, {
    'Flags' : [ 0x0, ['unsigned long']],
    'FrameName' : [ 0x4, ['pointer', ['unsigned char']]],
} ],
  '_NLS_DATA_BLOCK' : [ 0xc, {
    'AnsiCodePageData' : [ 0x0, ['pointer', ['void']]],
    'OemCodePageData' : [ 0x4, ['pointer', ['void']]],
    'UnicodeCaseTableData' : [ 0x8, ['pointer', ['void']]],
} ],
  '_CM_KEY_CONTROL_BLOCK' : [ 0x90, {
    'RefCount' : [ 0x0, ['unsigned long']],
    'ExtFlags' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 9, native_type='unsigned long')]],
    'PrivateAlloc' : [ 0x4, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'Delete' : [ 0x4, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'DelayedCloseIndex' : [ 0x4, ['BitField', dict(start_bit = 11, end_bit = 22, native_type='unsigned long')]],
    'TotalLevels' : [ 0x4, ['BitField', dict(start_bit = 22, end_bit = 32, native_type='unsigned long')]],
    'KeyHash' : [ 0x8, ['_CM_KEY_HASH']],
    'ConvKey' : [ 0x8, ['unsigned long']],
    'NextHash' : [ 0xc, ['pointer', ['_CM_KEY_HASH']]],
    'KeyHive' : [ 0x10, ['pointer', ['_HHIVE']]],
    'KeyCell' : [ 0x14, ['unsigned long']],
    'ParentKcb' : [ 0x18, ['pointer', ['_CM_KEY_CONTROL_BLOCK']]],
    'NameBlock' : [ 0x1c, ['pointer', ['_CM_NAME_CONTROL_BLOCK']]],
    'CachedSecurity' : [ 0x20, ['pointer', ['_CM_KEY_SECURITY_CACHE']]],
    'ValueCache' : [ 0x24, ['_CACHED_CHILD_LIST']],
    'IndexHint' : [ 0x2c, ['pointer', ['_CM_INDEX_HINT_BLOCK']]],
    'HashKey' : [ 0x2c, ['unsigned long']],
    'SubKeyCount' : [ 0x2c, ['unsigned long']],
    'KeyBodyListHead' : [ 0x30, ['_LIST_ENTRY']],
    'FreeListEntry' : [ 0x30, ['_LIST_ENTRY']],
    'KeyBodyArray' : [ 0x38, ['array', 4, ['pointer', ['_CM_KEY_BODY']]]],
    'DelayCloseEntry' : [ 0x48, ['pointer', ['void']]],
    'KcbLastWriteTime' : [ 0x50, ['_LARGE_INTEGER']],
    'KcbMaxNameLen' : [ 0x58, ['unsigned short']],
    'KcbMaxValueNameLen' : [ 0x5a, ['unsigned short']],
    'KcbMaxValueDataLen' : [ 0x5c, ['unsigned long']],
    'KcbUserFlags' : [ 0x60, ['BitField', dict(start_bit = 0, end_bit = 4, native_type='unsigned long')]],
    'KcbVirtControlFlags' : [ 0x60, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned long')]],
    'KcbDebug' : [ 0x60, ['BitField', dict(start_bit = 8, end_bit = 16, native_type='unsigned long')]],
    'Flags' : [ 0x60, ['BitField', dict(start_bit = 16, end_bit = 32, native_type='unsigned long')]],
    'KCBUoWListHead' : [ 0x64, ['_LIST_ENTRY']],
    'TransKCBOwner' : [ 0x6c, ['pointer', ['_CM_TRANS']]],
    'KCBLock' : [ 0x70, ['_CM_INTENT_LOCK']],
    'KeyLock' : [ 0x78, ['_CM_INTENT_LOCK']],
    'TransValueCache' : [ 0x80, ['_CHILD_LIST']],
    'TransValueListOwner' : [ 0x88, ['pointer', ['_CM_TRANS']]],
    'FullKCBName' : [ 0x8c, ['pointer', ['_UNICODE_STRING']]],
} ],
  '_MMPTE_SOFTWARE' : [ 0x4, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'PageFileLow' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 5, native_type='unsigned long')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 10, native_type='unsigned long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'Transition' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'PageFileHigh' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 32, native_type='unsigned long')]],
} ],
  '_CACHE_UNINITIALIZE_EVENT' : [ 0x14, {
    'Next' : [ 0x0, ['pointer', ['_CACHE_UNINITIALIZE_EVENT']]],
    'Event' : [ 0x4, ['_KEVENT']],
} ],
  '_SECURITY_TOKEN_AUDIT_DATA' : [ 0xc, {
    'Length' : [ 0x0, ['unsigned long']],
    'GrantMask' : [ 0x4, ['unsigned long']],
    'DenyMask' : [ 0x8, ['unsigned long']],
} ],
  '_CM_RESOURCE_LIST' : [ 0x24, {
    'Count' : [ 0x0, ['unsigned long']],
    'List' : [ 0x4, ['array', 1, ['_CM_FULL_RESOURCE_DESCRIPTOR']]],
} ],
  '_POOL_TRACKER_TABLE' : [ 0x1c, {
    'Key' : [ 0x0, ['long']],
    'NonPagedAllocs' : [ 0x4, ['long']],
    'NonPagedFrees' : [ 0x8, ['long']],
    'NonPagedBytes' : [ 0xc, ['unsigned long']],
    'PagedAllocs' : [ 0x10, ['unsigned long']],
    'PagedFrees' : [ 0x14, ['unsigned long']],
    'PagedBytes' : [ 0x18, ['unsigned long']],
} ],
  '_MM_SUBSECTION_AVL_TABLE' : [ 0x20, {
    'BalancedRoot' : [ 0x0, ['_MMSUBSECTION_NODE']],
    'DepthOfTree' : [ 0x18, ['BitField', dict(start_bit = 0, end_bit = 5, native_type='unsigned long')]],
    'Unused' : [ 0x18, ['BitField', dict(start_bit = 5, end_bit = 8, native_type='unsigned long')]],
    'NumberGenericTableElements' : [ 0x18, ['BitField', dict(start_bit = 8, end_bit = 32, native_type='unsigned long')]],
    'NodeHint' : [ 0x1c, ['pointer', ['void']]],
} ],
  '_HANDLE_TABLE_ENTRY_INFO' : [ 0x4, {
    'AuditMask' : [ 0x0, ['unsigned long']],
} ],
  '_CM_FULL_RESOURCE_DESCRIPTOR' : [ 0x20, {
    'InterfaceType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'Internal', 1: 'Isa', 2: 'Eisa', 3: 'MicroChannel', 4: 'TurboChannel', 5: 'PCIBus', 6: 'VMEBus', 7: 'NuBus', 8: 'PCMCIABus', 9: 'CBus', 10: 'MPIBus', 11: 'MPSABus', 12: 'ProcessorInternal', 13: 'InternalPowerBus', 14: 'PNPISABus', 15: 'PNPBus', 16: 'Vmcs', 17: 'MaximumInterfaceType', -1: 'InterfaceTypeUndefined'})]],
    'BusNumber' : [ 0x4, ['unsigned long']],
    'PartialResourceList' : [ 0x8, ['_CM_PARTIAL_RESOURCE_LIST']],
} ],
  '_POWER_SEQUENCE' : [ 0xc, {
    'SequenceD1' : [ 0x0, ['unsigned long']],
    'SequenceD2' : [ 0x4, ['unsigned long']],
    'SequenceD3' : [ 0x8, ['unsigned long']],
} ],
  '_KSEMAPHORE' : [ 0x14, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'Limit' : [ 0x10, ['long']],
} ],
  '_OBJECT_REF_STACK_INFO' : [ 0x8, {
    'Sequence' : [ 0x0, ['unsigned long']],
    'Index' : [ 0x4, ['unsigned short']],
    'NumTraces' : [ 0x6, ['unsigned short']],
} ],
  '_DBGKD_READ_WRITE_MSR' : [ 0xc, {
    'Msr' : [ 0x0, ['unsigned long']],
    'DataValueLow' : [ 0x4, ['unsigned long']],
    'DataValueHigh' : [ 0x8, ['unsigned long']],
} ],
  '_MMPFNENTRY' : [ 0x2, {
    'PageLocation' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned char')]],
    'WriteInProgress' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'Modified' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'ReadInProgress' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'CacheAttribute' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 8, native_type='unsigned char')]],
    'Priority' : [ 0x1, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned char')]],
    'Rom' : [ 0x1, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'InPageError' : [ 0x1, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'KernelStack' : [ 0x1, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'RemovalRequested' : [ 0x1, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'ParityError' : [ 0x1, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
} ],
  '_SEGMENT_OBJECT' : [ 0x28, {
    'BaseAddress' : [ 0x0, ['pointer', ['void']]],
    'TotalNumberOfPtes' : [ 0x4, ['unsigned long']],
    'SizeOfSegment' : [ 0x8, ['_LARGE_INTEGER']],
    'NonExtendedPtes' : [ 0x10, ['unsigned long']],
    'ImageCommitment' : [ 0x14, ['unsigned long']],
    'ControlArea' : [ 0x18, ['pointer', ['_CONTROL_AREA']]],
    'Subsection' : [ 0x1c, ['pointer', ['_SUBSECTION']]],
    'MmSectionFlags' : [ 0x20, ['pointer', ['_MMSECTION_FLAGS']]],
    'MmSubSectionFlags' : [ 0x24, ['pointer', ['_MMSUBSECTION_FLAGS']]],
} ],
  '_IMAGE_DOS_HEADER' : [ 0x40, {
    'e_magic' : [ 0x0, ['unsigned short']],
    'e_cblp' : [ 0x2, ['unsigned short']],
    'e_cp' : [ 0x4, ['unsigned short']],
    'e_crlc' : [ 0x6, ['unsigned short']],
    'e_cparhdr' : [ 0x8, ['unsigned short']],
    'e_minalloc' : [ 0xa, ['unsigned short']],
    'e_maxalloc' : [ 0xc, ['unsigned short']],
    'e_ss' : [ 0xe, ['unsigned short']],
    'e_sp' : [ 0x10, ['unsigned short']],
    'e_csum' : [ 0x12, ['unsigned short']],
    'e_ip' : [ 0x14, ['unsigned short']],
    'e_cs' : [ 0x16, ['unsigned short']],
    'e_lfarlc' : [ 0x18, ['unsigned short']],
    'e_ovno' : [ 0x1a, ['unsigned short']],
    'e_res' : [ 0x1c, ['array', 4, ['unsigned short']]],
    'e_oemid' : [ 0x24, ['unsigned short']],
    'e_oeminfo' : [ 0x26, ['unsigned short']],
    'e_res2' : [ 0x28, ['array', 10, ['unsigned short']]],
    'e_lfanew' : [ 0x3c, ['long']],
} ],
  '_KTSS' : [ 0x20ac, {
    'Backlink' : [ 0x0, ['unsigned short']],
    'Reserved0' : [ 0x2, ['unsigned short']],
    'Esp0' : [ 0x4, ['unsigned long']],
    'Ss0' : [ 0x8, ['unsigned short']],
    'Reserved1' : [ 0xa, ['unsigned short']],
    'NotUsed1' : [ 0xc, ['array', 4, ['unsigned long']]],
    'CR3' : [ 0x1c, ['unsigned long']],
    'Eip' : [ 0x20, ['unsigned long']],
    'EFlags' : [ 0x24, ['unsigned long']],
    'Eax' : [ 0x28, ['unsigned long']],
    'Ecx' : [ 0x2c, ['unsigned long']],
    'Edx' : [ 0x30, ['unsigned long']],
    'Ebx' : [ 0x34, ['unsigned long']],
    'Esp' : [ 0x38, ['unsigned long']],
    'Ebp' : [ 0x3c, ['unsigned long']],
    'Esi' : [ 0x40, ['unsigned long']],
    'Edi' : [ 0x44, ['unsigned long']],
    'Es' : [ 0x48, ['unsigned short']],
    'Reserved2' : [ 0x4a, ['unsigned short']],
    'Cs' : [ 0x4c, ['unsigned short']],
    'Reserved3' : [ 0x4e, ['unsigned short']],
    'Ss' : [ 0x50, ['unsigned short']],
    'Reserved4' : [ 0x52, ['unsigned short']],
    'Ds' : [ 0x54, ['unsigned short']],
    'Reserved5' : [ 0x56, ['unsigned short']],
    'Fs' : [ 0x58, ['unsigned short']],
    'Reserved6' : [ 0x5a, ['unsigned short']],
    'Gs' : [ 0x5c, ['unsigned short']],
    'Reserved7' : [ 0x5e, ['unsigned short']],
    'LDT' : [ 0x60, ['unsigned short']],
    'Reserved8' : [ 0x62, ['unsigned short']],
    'Flags' : [ 0x64, ['unsigned short']],
    'IoMapBase' : [ 0x66, ['unsigned short']],
    'IoMaps' : [ 0x68, ['array', 1, ['_KiIoAccessMap']]],
    'IntDirectionMap' : [ 0x208c, ['array', 32, ['unsigned char']]],
} ],
  '_TOKEN_SOURCE' : [ 0x10, {
    'SourceName' : [ 0x0, ['array', 8, ['unsigned char']]],
    'SourceIdentifier' : [ 0x8, ['_LUID']],
} ],
  '_DBGKD_QUERY_MEMORY' : [ 0x18, {
    'Address' : [ 0x0, ['unsigned long long']],
    'Reserved' : [ 0x8, ['unsigned long long']],
    'AddressSpace' : [ 0x10, ['unsigned long']],
    'Flags' : [ 0x14, ['unsigned long']],
} ],
  '_KIDTENTRY' : [ 0x8, {
    'Offset' : [ 0x0, ['unsigned short']],
    'Selector' : [ 0x2, ['unsigned short']],
    'Access' : [ 0x4, ['unsigned short']],
    'ExtendedOffset' : [ 0x6, ['unsigned short']],
} ],
  'CMP_OFFSET_ARRAY' : [ 0xc, {
    'FileOffset' : [ 0x0, ['unsigned long']],
    'DataBuffer' : [ 0x4, ['pointer', ['void']]],
    'DataLength' : [ 0x8, ['unsigned long']],
} ],
  '_MMSUPPORT_FLAGS' : [ 0x4, {
    'SessionSpace' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'ModwriterAttached' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'TrimHard' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'MaximumWorkingSetHard' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'ForceTrim' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'MinimumWorkingSetHard' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'SessionMaster' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'TrimmerAttached' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'TrimmerDetaching' : [ 0x1, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Reserved' : [ 0x1, ['BitField', dict(start_bit = 1, end_bit = 4, native_type='unsigned char')]],
    'PageStealers' : [ 0x1, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned char')]],
    'MemoryPriority' : [ 0x2, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned char')]],
    'WsleDeleted' : [ 0x3, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'VmExiting' : [ 0x3, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'ExpansionFailed' : [ 0x3, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'Available' : [ 0x3, ['BitField', dict(start_bit = 3, end_bit = 8, native_type='unsigned char')]],
} ],
  'PPM_IDLE_ACCOUNTING' : [ 0x48, {
    'StateCount' : [ 0x0, ['unsigned long']],
    'TotalTransitions' : [ 0x4, ['unsigned long']],
    'ResetCount' : [ 0x8, ['unsigned long']],
    'StartTime' : [ 0x10, ['unsigned long long']],
    'State' : [ 0x18, ['array', 1, ['PPM_IDLE_STATE_ACCOUNTING']]],
} ],
  'PPM_IDLE_STATE_ACCOUNTING' : [ 0x30, {
    'IdleTransitions' : [ 0x0, ['unsigned long']],
    'FailedTransitions' : [ 0x4, ['unsigned long']],
    'InvalidBucketIndex' : [ 0x8, ['unsigned long']],
    'TotalTime' : [ 0x10, ['unsigned long long']],
    'IdleTimeBuckets' : [ 0x18, ['array', 6, ['unsigned long']]],
} ],
  '_IMAGE_OPTIONAL_HEADER' : [ 0xe0, {
    'Magic' : [ 0x0, ['unsigned short']],
    'MajorLinkerVersion' : [ 0x2, ['unsigned char']],
    'MinorLinkerVersion' : [ 0x3, ['unsigned char']],
    'SizeOfCode' : [ 0x4, ['unsigned long']],
    'SizeOfInitializedData' : [ 0x8, ['unsigned long']],
    'SizeOfUninitializedData' : [ 0xc, ['unsigned long']],
    'AddressOfEntryPoint' : [ 0x10, ['unsigned long']],
    'BaseOfCode' : [ 0x14, ['unsigned long']],
    'BaseOfData' : [ 0x18, ['unsigned long']],
    'ImageBase' : [ 0x1c, ['unsigned long']],
    'SectionAlignment' : [ 0x20, ['unsigned long']],
    'FileAlignment' : [ 0x24, ['unsigned long']],
    'MajorOperatingSystemVersion' : [ 0x28, ['unsigned short']],
    'MinorOperatingSystemVersion' : [ 0x2a, ['unsigned short']],
    'MajorImageVersion' : [ 0x2c, ['unsigned short']],
    'MinorImageVersion' : [ 0x2e, ['unsigned short']],
    'MajorSubsystemVersion' : [ 0x30, ['unsigned short']],
    'MinorSubsystemVersion' : [ 0x32, ['unsigned short']],
    'Win32VersionValue' : [ 0x34, ['unsigned long']],
    'SizeOfImage' : [ 0x38, ['unsigned long']],
    'SizeOfHeaders' : [ 0x3c, ['unsigned long']],
    'CheckSum' : [ 0x40, ['unsigned long']],
    'Subsystem' : [ 0x44, ['unsigned short']],
    'DllCharacteristics' : [ 0x46, ['unsigned short']],
    'SizeOfStackReserve' : [ 0x48, ['unsigned long']],
    'SizeOfStackCommit' : [ 0x4c, ['unsigned long']],
    'SizeOfHeapReserve' : [ 0x50, ['unsigned long']],
    'SizeOfHeapCommit' : [ 0x54, ['unsigned long']],
    'LoaderFlags' : [ 0x58, ['unsigned long']],
    'NumberOfRvaAndSizes' : [ 0x5c, ['unsigned long']],
    'DataDirectory' : [ 0x60, ['array', 16, ['_IMAGE_DATA_DIRECTORY']]],
} ],
  '_ALPC_COMPLETION_PACKET_LOOKASIDE' : [ 0x24, {
    'Lock' : [ 0x0, ['unsigned long']],
    'Size' : [ 0x4, ['unsigned long']],
    'ActiveCount' : [ 0x8, ['unsigned long']],
    'PendingNullCount' : [ 0xc, ['unsigned long']],
    'PendingCheckCompletionListCount' : [ 0x10, ['unsigned long']],
    'PendingDelete' : [ 0x14, ['unsigned long']],
    'FreeListHead' : [ 0x18, ['_SINGLE_LIST_ENTRY']],
    'CompletionPort' : [ 0x1c, ['pointer', ['void']]],
    'CompletionKey' : [ 0x20, ['pointer', ['void']]],
    'Entry' : [ 0x24, ['array', 0, ['_ALPC_COMPLETION_PACKET_LOOKASIDE_ENTRY']]],
} ],
  '_KSYSTEM_TIME' : [ 0xc, {
    'LowPart' : [ 0x0, ['unsigned long']],
    'High1Time' : [ 0x4, ['long']],
    'High2Time' : [ 0x8, ['long']],
} ],
  '_TERMINATION_PORT' : [ 0x8, {
    'Next' : [ 0x0, ['pointer', ['_TERMINATION_PORT']]],
    'Port' : [ 0x4, ['pointer', ['void']]],
} ],
  '_MEMORY_ALLOCATION_DESCRIPTOR' : [ 0x14, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'MemoryType' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: 'LoaderExceptionBlock', 1: 'LoaderSystemBlock', 2: 'LoaderFree', 3: 'LoaderBad', 4: 'LoaderLoadedProgram', 5: 'LoaderFirmwareTemporary', 6: 'LoaderFirmwarePermanent', 7: 'LoaderOsloaderHeap', 8: 'LoaderOsloaderStack', 9: 'LoaderSystemCode', 10: 'LoaderHalCode', 11: 'LoaderBootDriver', 12: 'LoaderConsoleInDriver', 13: 'LoaderConsoleOutDriver', 14: 'LoaderStartupDpcStack', 15: 'LoaderStartupKernelStack', 16: 'LoaderStartupPanicStack', 17: 'LoaderStartupPcrPage', 18: 'LoaderStartupPdrPage', 19: 'LoaderRegistryData', 20: 'LoaderMemoryData', 21: 'LoaderNlsData', 22: 'LoaderSpecialMemory', 23: 'LoaderBBTMemory', 24: 'LoaderReserve', 25: 'LoaderXIPRom', 26: 'LoaderHALCachedMemory', 27: 'LoaderLargePageFiller', 28: 'LoaderErrorLogMemory', 29: 'LoaderMaximum'})]],
    'BasePage' : [ 0xc, ['unsigned long']],
    'PageCount' : [ 0x10, ['unsigned long']],
} ],
  '_CM_INTENT_LOCK' : [ 0x8, {
    'OwnerCount' : [ 0x0, ['unsigned long']],
    'OwnerTable' : [ 0x4, ['pointer', ['pointer', ['_CM_KCB_UOW']]]],
} ],
  '_THERMAL_INFORMATION' : [ 0x4c, {
    'ThermalStamp' : [ 0x0, ['unsigned long']],
    'ThermalConstant1' : [ 0x4, ['unsigned long']],
    'ThermalConstant2' : [ 0x8, ['unsigned long']],
    'Processors' : [ 0xc, ['unsigned long']],
    'SamplingPeriod' : [ 0x10, ['unsigned long']],
    'CurrentTemperature' : [ 0x14, ['unsigned long']],
    'PassiveTripPoint' : [ 0x18, ['unsigned long']],
    'CriticalTripPoint' : [ 0x1c, ['unsigned long']],
    'ActiveTripPointCount' : [ 0x20, ['unsigned char']],
    'ActiveTripPoint' : [ 0x24, ['array', 10, ['unsigned long']]],
} ],
  '_MAPPED_FILE_SEGMENT' : [ 0x28, {
    'ControlArea' : [ 0x0, ['pointer', ['_CONTROL_AREA']]],
    'TotalNumberOfPtes' : [ 0x4, ['unsigned long']],
    'SegmentFlags' : [ 0x8, ['_SEGMENT_FLAGS']],
    'NumberOfCommittedPages' : [ 0xc, ['unsigned long']],
    'SizeOfSegment' : [ 0x10, ['unsigned long long']],
    'ExtendInfo' : [ 0x18, ['pointer', ['_MMEXTEND_INFO']]],
    'BasedAddress' : [ 0x18, ['pointer', ['void']]],
    'SegmentLock' : [ 0x1c, ['_EX_PUSH_LOCK']],
    'LastSubsectionHint' : [ 0x20, ['pointer', ['_MSUBSECTION']]],
} ],
  '_GDI_TEB_BATCH' : [ 0x4e0, {
    'Offset' : [ 0x0, ['unsigned long']],
    'HDC' : [ 0x4, ['unsigned long']],
    'Buffer' : [ 0x8, ['array', 310, ['unsigned long']]],
} ],
  '_VI_FAULT_TRACE' : [ 0x24, {
    'Thread' : [ 0x0, ['pointer', ['_ETHREAD']]],
    'StackTrace' : [ 0x4, ['array', 8, ['pointer', ['void']]]],
} ],
  '_WHEA_PCIXBUS_ERROR' : [ 0x48, {
    'ValidBits' : [ 0x0, ['_WHEA_PCIXBUS_ERROR_VALIDBITS']],
    'ErrorStatus' : [ 0x8, ['_WHEA_ERROR_STATUS']],
    'ErrorType' : [ 0x10, ['unsigned short']],
    'BusId' : [ 0x12, ['_WHEA_PCIXBUS_ID']],
    'Reserved' : [ 0x14, ['unsigned long']],
    'BusAddress' : [ 0x18, ['unsigned long long']],
    'BusData' : [ 0x20, ['unsigned long long']],
    'BusCommand' : [ 0x28, ['_WHEA_PCIXBUS_COMMAND']],
    'RequesterId' : [ 0x30, ['unsigned long long']],
    'CompleterId' : [ 0x38, ['unsigned long long']],
    'TargetId' : [ 0x40, ['unsigned long long']],
} ],
  '_DBGKD_CONTINUE2' : [ 0x20, {
    'ContinueStatus' : [ 0x0, ['long']],
    'ControlSet' : [ 0x4, ['_X86_DBGKD_CONTROL_SET']],
    'AnyControlSet' : [ 0x4, ['_DBGKD_ANY_CONTROL_SET']],
} ],
  '_SECURITY_TOKEN_PROXY_DATA' : [ 0x18, {
    'Length' : [ 0x0, ['unsigned long']],
    'ProxyClass' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'ProxyFull', 1: 'ProxyService', 2: 'ProxyTree', 3: 'ProxyDirectory'})]],
    'PathInfo' : [ 0x8, ['_UNICODE_STRING']],
    'ContainerMask' : [ 0x10, ['unsigned long']],
    'ObjectMask' : [ 0x14, ['unsigned long']],
} ],
  '_OBJECT_HANDLE_COUNT_DATABASE' : [ 0xc, {
    'CountEntries' : [ 0x0, ['unsigned long']],
    'HandleCountEntries' : [ 0x4, ['array', 1, ['_OBJECT_HANDLE_COUNT_ENTRY']]],
} ],
  '_WHEA_ERROR_RECORD_SECTION_DESCRIPTOR' : [ 0x48, {
    'SectionOffset' : [ 0x0, ['unsigned long']],
    'SectionLength' : [ 0x4, ['unsigned long']],
    'Revision' : [ 0x8, ['_WHEA_REVISION']],
    'ValidBits' : [ 0xa, ['_WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_VALIDBITS']],
    'Reserved' : [ 0xb, ['unsigned char']],
    'Flags' : [ 0xc, ['_WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_FLAGS']],
    'SectionType' : [ 0x10, ['_GUID']],
    'FRUId' : [ 0x20, ['_GUID']],
    'SectionSeverity' : [ 0x30, ['Enumeration', dict(target = 'long', choices = {0: 'WheaErrSevRecoverable', 1: 'WheaErrSevFatal', 2: 'WheaErrSevCorrected', 3: 'WheaErrSevNone'})]],
    'FRUText' : [ 0x34, ['array', 20, ['unsigned char']]],
} ],
  '_OWNER_ENTRY' : [ 0x8, {
    'OwnerThread' : [ 0x0, ['unsigned long']],
    'OwnerCount' : [ 0x4, ['long']],
    'TableSize' : [ 0x4, ['unsigned long']],
} ],
  '_MI_SECTION_CREATION_GATE' : [ 0x14, {
    'Next' : [ 0x0, ['pointer', ['_MI_SECTION_CREATION_GATE']]],
    'Gate' : [ 0x4, ['_KGATE']],
} ],
  '_ETIMER' : [ 0x98, {
    'KeTimer' : [ 0x0, ['_KTIMER']],
    'TimerApc' : [ 0x28, ['_KAPC']],
    'TimerDpc' : [ 0x58, ['_KDPC']],
    'ActiveTimerListEntry' : [ 0x78, ['_LIST_ENTRY']],
    'Lock' : [ 0x80, ['unsigned long']],
    'Period' : [ 0x84, ['long']],
    'ApcAssociated' : [ 0x88, ['unsigned char']],
    'WakeTimer' : [ 0x89, ['unsigned char']],
    'WakeTimerListEntry' : [ 0x8c, ['_LIST_ENTRY']],
} ],
  '_FREE_DISPLAY' : [ 0xc, {
    'RealVectorSize' : [ 0x0, ['unsigned long']],
    'Display' : [ 0x4, ['_RTL_BITMAP']],
} ],
  '_POOL_BLOCK_HEAD' : [ 0x10, {
    'Header' : [ 0x0, ['_POOL_HEADER']],
    'List' : [ 0x8, ['_LIST_ENTRY']],
} ],
  '_WHEA_PCIXBUS_ERROR_VALIDBITS' : [ 0x8, {
    'ErrorStatus' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'ErrorType' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'BusId' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'BusAddress' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long long')]],
    'BusData' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long long')]],
    'BusCommand' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long long')]],
    'RequesterId' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long long')]],
    'CompleterId' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long long')]],
    'TargetId' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 64, native_type='unsigned long long')]],
    'ValidBits' : [ 0x0, ['unsigned long long']],
} ],
  '__unnamed_1b64' : [ 0x4, {
    'Flags' : [ 0x0, ['_MMSECURE_FLAGS']],
    'StartVa' : [ 0x0, ['pointer', ['void']]],
} ],
  '_MMADDRESS_LIST' : [ 0x8, {
    'u1' : [ 0x0, ['__unnamed_1b64']],
    'EndVa' : [ 0x4, ['pointer', ['void']]],
} ],
  '_FNSAVE_FORMAT' : [ 0x6c, {
    'ControlWord' : [ 0x0, ['unsigned long']],
    'StatusWord' : [ 0x4, ['unsigned long']],
    'TagWord' : [ 0x8, ['unsigned long']],
    'ErrorOffset' : [ 0xc, ['unsigned long']],
    'ErrorSelector' : [ 0x10, ['unsigned long']],
    'DataOffset' : [ 0x14, ['unsigned long']],
    'DataSelector' : [ 0x18, ['unsigned long']],
    'RegisterArea' : [ 0x1c, ['array', 80, ['unsigned char']]],
} ],
  '_ARBITER_INSTANCE' : [ 0x5ec, {
    'Signature' : [ 0x0, ['unsigned long']],
    'MutexEvent' : [ 0x4, ['pointer', ['_KEVENT']]],
    'Name' : [ 0x8, ['pointer', ['unsigned short']]],
    'OrderingName' : [ 0xc, ['pointer', ['unsigned short']]],
    'ResourceType' : [ 0x10, ['long']],
    'Allocation' : [ 0x14, ['pointer', ['_RTL_RANGE_LIST']]],
    'PossibleAllocation' : [ 0x18, ['pointer', ['_RTL_RANGE_LIST']]],
    'OrderingList' : [ 0x1c, ['_ARBITER_ORDERING_LIST']],
    'ReservedList' : [ 0x24, ['_ARBITER_ORDERING_LIST']],
    'ReferenceCount' : [ 0x2c, ['long']],
    'Interface' : [ 0x30, ['pointer', ['_ARBITER_INTERFACE']]],
    'AllocationStackMaxSize' : [ 0x34, ['unsigned long']],
    'AllocationStack' : [ 0x38, ['pointer', ['_ARBITER_ALLOCATION_STATE']]],
    'UnpackRequirement' : [ 0x3c, ['pointer', ['void']]],
    'PackResource' : [ 0x40, ['pointer', ['void']]],
    'UnpackResource' : [ 0x44, ['pointer', ['void']]],
    'ScoreRequirement' : [ 0x48, ['pointer', ['void']]],
    'TestAllocation' : [ 0x4c, ['pointer', ['void']]],
    'RetestAllocation' : [ 0x50, ['pointer', ['void']]],
    'CommitAllocation' : [ 0x54, ['pointer', ['void']]],
    'RollbackAllocation' : [ 0x58, ['pointer', ['void']]],
    'BootAllocation' : [ 0x5c, ['pointer', ['void']]],
    'QueryArbitrate' : [ 0x60, ['pointer', ['void']]],
    'QueryConflict' : [ 0x64, ['pointer', ['void']]],
    'AddReserved' : [ 0x68, ['pointer', ['void']]],
    'StartArbiter' : [ 0x6c, ['pointer', ['void']]],
    'PreprocessEntry' : [ 0x70, ['pointer', ['void']]],
    'AllocateEntry' : [ 0x74, ['pointer', ['void']]],
    'GetNextAllocationRange' : [ 0x78, ['pointer', ['void']]],
    'FindSuitableRange' : [ 0x7c, ['pointer', ['void']]],
    'AddAllocation' : [ 0x80, ['pointer', ['void']]],
    'BacktrackAllocation' : [ 0x84, ['pointer', ['void']]],
    'OverrideConflict' : [ 0x88, ['pointer', ['void']]],
    'InitializeRangeList' : [ 0x8c, ['pointer', ['void']]],
    'TransactionInProgress' : [ 0x90, ['unsigned char']],
    'TransactionEvent' : [ 0x94, ['pointer', ['_KEVENT']]],
    'Extension' : [ 0x98, ['pointer', ['void']]],
    'BusDeviceObject' : [ 0x9c, ['pointer', ['_DEVICE_OBJECT']]],
    'ConflictCallbackContext' : [ 0xa0, ['pointer', ['void']]],
    'ConflictCallback' : [ 0xa4, ['pointer', ['void']]],
    'PdoDescriptionString' : [ 0xa8, ['array', 336, ['wchar']]],
    'PdoSymbolicNameString' : [ 0x348, ['array', 672, ['unsigned char']]],
    'PdoAddressString' : [ 0x5e8, ['array', 1, ['wchar']]],
} ],
  '_KDEVICE_QUEUE_ENTRY' : [ 0x10, {
    'DeviceListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'SortKey' : [ 0x8, ['unsigned long']],
    'Inserted' : [ 0xc, ['unsigned char']],
} ],
  '_HMAP_TABLE' : [ 0x2000, {
    'Table' : [ 0x0, ['array', 512, ['_HMAP_ENTRY']]],
} ],
  '_WHEA_MEMORY_ERROR' : [ 0x49, {
    'ValidBits' : [ 0x0, ['_WHEA_MEMORY_ERROR_VALIDBITS']],
    'ErrorStatus' : [ 0x8, ['_WHEA_ERROR_STATUS']],
    'PhysicalAddress' : [ 0x10, ['unsigned long long']],
    'PhysicalAddressMask' : [ 0x18, ['unsigned long long']],
    'Node' : [ 0x20, ['unsigned short']],
    'Card' : [ 0x22, ['unsigned short']],
    'Module' : [ 0x24, ['unsigned short']],
    'Bank' : [ 0x26, ['unsigned short']],
    'Device' : [ 0x28, ['unsigned short']],
    'Row' : [ 0x2a, ['unsigned short']],
    'Column' : [ 0x2c, ['unsigned short']],
    'BitPosition' : [ 0x2e, ['unsigned short']],
    'RequesterId' : [ 0x30, ['unsigned long long']],
    'ResponderId' : [ 0x38, ['unsigned long long']],
    'TargetId' : [ 0x40, ['unsigned long long']],
    'ErrorType' : [ 0x48, ['unsigned char']],
} ],
  '_IMAGE_DATA_DIRECTORY' : [ 0x8, {
    'VirtualAddress' : [ 0x0, ['unsigned long']],
    'Size' : [ 0x4, ['unsigned long']],
} ],
  '_DEVICE_CAPABILITIES' : [ 0x40, {
    'Size' : [ 0x0, ['unsigned short']],
    'Version' : [ 0x2, ['unsigned short']],
    'DeviceD1' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'DeviceD2' : [ 0x4, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'LockSupported' : [ 0x4, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'EjectSupported' : [ 0x4, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'Removable' : [ 0x4, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'DockDevice' : [ 0x4, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'UniqueID' : [ 0x4, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'SilentInstall' : [ 0x4, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'RawDeviceOK' : [ 0x4, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'SurpriseRemovalOK' : [ 0x4, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'WakeFromD0' : [ 0x4, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'WakeFromD1' : [ 0x4, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'WakeFromD2' : [ 0x4, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'WakeFromD3' : [ 0x4, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'HardwareDisabled' : [ 0x4, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'NonDynamic' : [ 0x4, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'WarmEjectSupported' : [ 0x4, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'NoDisplayInUI' : [ 0x4, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'Reserved' : [ 0x4, ['BitField', dict(start_bit = 18, end_bit = 32, native_type='unsigned long')]],
    'Address' : [ 0x8, ['unsigned long']],
    'UINumber' : [ 0xc, ['unsigned long']],
    'DeviceState' : [ 0x10, ['array', -28, ['Enumeration', dict(target = 'long', choices = {0: 'PowerDeviceUnspecified', 1: 'PowerDeviceD0', 2: 'PowerDeviceD1', 3: 'PowerDeviceD2', 4: 'PowerDeviceD3', 5: 'PowerDeviceMaximum'})]]],
    'SystemWake' : [ 0x2c, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'DeviceWake' : [ 0x30, ['Enumeration', dict(target = 'long', choices = {0: 'PowerDeviceUnspecified', 1: 'PowerDeviceD0', 2: 'PowerDeviceD1', 3: 'PowerDeviceD2', 4: 'PowerDeviceD3', 5: 'PowerDeviceMaximum'})]],
    'D1Latency' : [ 0x34, ['unsigned long']],
    'D2Latency' : [ 0x38, ['unsigned long']],
    'D3Latency' : [ 0x3c, ['unsigned long']],
} ],
  '_KGUARDED_MUTEX' : [ 0x20, {
    'Count' : [ 0x0, ['long']],
    'Owner' : [ 0x4, ['pointer', ['_KTHREAD']]],
    'Contention' : [ 0x8, ['unsigned long']],
    'Gate' : [ 0xc, ['_KGATE']],
    'KernelApcDisable' : [ 0x1c, ['short']],
    'SpecialApcDisable' : [ 0x1e, ['short']],
    'CombinedApcDisable' : [ 0x1c, ['unsigned long']],
} ],
  '_ALPHA_LOADER_BLOCK' : [ 0x4, {
    'PlaceHolder' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_1bd0' : [ 0x18, {
    'Length' : [ 0x0, ['unsigned long']],
    'Alignment' : [ 0x4, ['unsigned long']],
    'MinimumAddress' : [ 0x8, ['_LARGE_INTEGER']],
    'MaximumAddress' : [ 0x10, ['_LARGE_INTEGER']],
} ],
  '__unnamed_1bd6' : [ 0x14, {
    'MinimumVector' : [ 0x0, ['unsigned long']],
    'MaximumVector' : [ 0x4, ['unsigned long']],
    'AffinityPolicy' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: 'IrqPolicyMachineDefault', 1: 'IrqPolicyAllCloseProcessors', 2: 'IrqPolicyOneCloseProcessor', 3: 'IrqPolicyAllProcessorsInMachine', 4: 'IrqPolicySpecifiedProcessors', 5: 'IrqPolicySpreadMessagesAcrossAllProcessors'})]],
    'PriorityPolicy' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: 'IrqPriorityUndefined', 1: 'IrqPriorityLow', 2: 'IrqPriorityNormal', 3: 'IrqPriorityHigh'})]],
    'TargetedProcessors' : [ 0x10, ['unsigned long']],
} ],
  '__unnamed_1bd8' : [ 0x8, {
    'MinimumChannel' : [ 0x0, ['unsigned long']],
    'MaximumChannel' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_1bda' : [ 0xc, {
    'Data' : [ 0x0, ['array', 3, ['unsigned long']]],
} ],
  '__unnamed_1bdc' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned long']],
    'MinBusNumber' : [ 0x4, ['unsigned long']],
    'MaxBusNumber' : [ 0x8, ['unsigned long']],
    'Reserved' : [ 0xc, ['unsigned long']],
} ],
  '__unnamed_1bde' : [ 0xc, {
    'Priority' : [ 0x0, ['unsigned long']],
    'Reserved1' : [ 0x4, ['unsigned long']],
    'Reserved2' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_1be0' : [ 0x18, {
    'Length40' : [ 0x0, ['unsigned long']],
    'Alignment40' : [ 0x4, ['unsigned long']],
    'MinimumAddress' : [ 0x8, ['_LARGE_INTEGER']],
    'MaximumAddress' : [ 0x10, ['_LARGE_INTEGER']],
} ],
  '__unnamed_1be2' : [ 0x18, {
    'Length48' : [ 0x0, ['unsigned long']],
    'Alignment48' : [ 0x4, ['unsigned long']],
    'MinimumAddress' : [ 0x8, ['_LARGE_INTEGER']],
    'MaximumAddress' : [ 0x10, ['_LARGE_INTEGER']],
} ],
  '__unnamed_1be4' : [ 0x18, {
    'Length64' : [ 0x0, ['unsigned long']],
    'Alignment64' : [ 0x4, ['unsigned long']],
    'MinimumAddress' : [ 0x8, ['_LARGE_INTEGER']],
    'MaximumAddress' : [ 0x10, ['_LARGE_INTEGER']],
} ],
  '__unnamed_1be6' : [ 0x18, {
    'Port' : [ 0x0, ['__unnamed_1bd0']],
    'Memory' : [ 0x0, ['__unnamed_1bd0']],
    'Interrupt' : [ 0x0, ['__unnamed_1bd6']],
    'Dma' : [ 0x0, ['__unnamed_1bd8']],
    'Generic' : [ 0x0, ['__unnamed_1bd0']],
    'DevicePrivate' : [ 0x0, ['__unnamed_1bda']],
    'BusNumber' : [ 0x0, ['__unnamed_1bdc']],
    'ConfigData' : [ 0x0, ['__unnamed_1bde']],
    'Memory40' : [ 0x0, ['__unnamed_1be0']],
    'Memory48' : [ 0x0, ['__unnamed_1be2']],
    'Memory64' : [ 0x0, ['__unnamed_1be4']],
} ],
  '_IO_RESOURCE_DESCRIPTOR' : [ 0x20, {
    'Option' : [ 0x0, ['unsigned char']],
    'Type' : [ 0x1, ['unsigned char']],
    'ShareDisposition' : [ 0x2, ['unsigned char']],
    'Spare1' : [ 0x3, ['unsigned char']],
    'Flags' : [ 0x4, ['unsigned short']],
    'Spare2' : [ 0x6, ['unsigned short']],
    'u' : [ 0x8, ['__unnamed_1be6']],
} ],
  '_POP_THERMAL_ZONE' : [ 0xd8, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'State' : [ 0x8, ['unsigned char']],
    'Flags' : [ 0x9, ['unsigned char']],
    'Mode' : [ 0xa, ['unsigned char']],
    'PendingMode' : [ 0xb, ['unsigned char']],
    'ActivePoint' : [ 0xc, ['unsigned char']],
    'PendingActivePoint' : [ 0xd, ['unsigned char']],
    'Throttle' : [ 0x10, ['long']],
    'LastTime' : [ 0x18, ['unsigned long long']],
    'SampleRate' : [ 0x20, ['unsigned long']],
    'LastTemp' : [ 0x24, ['unsigned long']],
    'PassiveTimer' : [ 0x28, ['_KTIMER']],
    'PassiveDpc' : [ 0x50, ['_KDPC']],
    'OverThrottled' : [ 0x70, ['_POP_ACTION_TRIGGER']],
    'Irp' : [ 0x80, ['pointer', ['_IRP']]],
    'Info' : [ 0x84, ['_THERMAL_INFORMATION_EX']],
} ],
  '_MMPTE_LIST' : [ 0x4, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'OneEntry' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'filler0' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 10, native_type='unsigned long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'filler1' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'NextEntry' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 32, native_type='unsigned long')]],
} ],
  '_VI_POOL_PAGE_HEADER' : [ 0xc, {
    'NextPage' : [ 0x0, ['pointer', ['_SINGLE_LIST_ENTRY']]],
    'VerifierEntry' : [ 0x4, ['pointer', ['void']]],
    'Signature' : [ 0x8, ['unsigned long']],
} ],
  '_HANDLE_TRACE_DEBUG_INFO' : [ 0x80, {
    'RefCount' : [ 0x0, ['long']],
    'TableSize' : [ 0x4, ['unsigned long']],
    'BitMaskFlags' : [ 0x8, ['unsigned long']],
    'CloseCompactionLock' : [ 0xc, ['_FAST_MUTEX']],
    'CurrentStackIndex' : [ 0x2c, ['unsigned long']],
    'TraceDb' : [ 0x30, ['array', 1, ['_HANDLE_TRACE_DB_ENTRY']]],
} ],
  '_MDL' : [ 0x1c, {
    'Next' : [ 0x0, ['pointer', ['_MDL']]],
    'Size' : [ 0x4, ['short']],
    'MdlFlags' : [ 0x6, ['short']],
    'Process' : [ 0x8, ['pointer', ['_EPROCESS']]],
    'MappedSystemVa' : [ 0xc, ['pointer', ['void']]],
    'StartVa' : [ 0x10, ['pointer', ['void']]],
    'ByteCount' : [ 0x14, ['unsigned long']],
    'ByteOffset' : [ 0x18, ['unsigned long']],
} ],
  '_WHEA_PCIXBUS_COMMAND' : [ 0x8, {
    'Command' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 56, native_type='unsigned long long')]],
    'PCIXCommand' : [ 0x0, ['BitField', dict(start_bit = 56, end_bit = 57, native_type='unsigned long long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 57, end_bit = 64, native_type='unsigned long long')]],
    'AsULONGLONG' : [ 0x0, ['unsigned long long']],
} ],
  '_CM_TRANS' : [ 0x68, {
    'TransactionListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'KCBUoWListHead' : [ 0x8, ['_LIST_ENTRY']],
    'LazyCommitListEntry' : [ 0x10, ['_LIST_ENTRY']],
    'KtmTrans' : [ 0x18, ['pointer', ['void']]],
    'CmRm' : [ 0x1c, ['pointer', ['_CM_RM']]],
    'KtmEnlistmentObject' : [ 0x20, ['pointer', ['_KENLISTMENT']]],
    'KtmEnlistmentHandle' : [ 0x24, ['pointer', ['void']]],
    'KtmUow' : [ 0x28, ['_GUID']],
    'StartLsn' : [ 0x38, ['unsigned long long']],
    'TransState' : [ 0x40, ['unsigned long']],
    'HiveCount' : [ 0x44, ['unsigned long']],
    'HiveArray' : [ 0x48, ['array', 8, ['pointer', ['_CMHIVE']]]],
} ],
  '_WHEA_ERROR_RECORD_HEADER_VALIDBITS' : [ 0x4, {
    'Timestamp' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'PlatformId' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'PartitionId' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_CM_PARTIAL_RESOURCE_LIST' : [ 0x18, {
    'Version' : [ 0x0, ['unsigned short']],
    'Revision' : [ 0x2, ['unsigned short']],
    'Count' : [ 0x4, ['unsigned long']],
    'PartialDescriptors' : [ 0x8, ['array', 1, ['_CM_PARTIAL_RESOURCE_DESCRIPTOR']]],
} ],
  '_RTL_RANGE_LIST' : [ 0x14, {
    'ListHead' : [ 0x0, ['_LIST_ENTRY']],
    'Flags' : [ 0x8, ['unsigned long']],
    'Count' : [ 0xc, ['unsigned long']],
    'Stamp' : [ 0x10, ['unsigned long']],
} ],
  '_OBJECT_CREATE_INFORMATION' : [ 0x30, {
    'Attributes' : [ 0x0, ['unsigned long']],
    'RootDirectory' : [ 0x4, ['pointer', ['void']]],
    'ParseContext' : [ 0x8, ['pointer', ['void']]],
    'ProbeMode' : [ 0xc, ['unsigned char']],
    'PagedPoolCharge' : [ 0x10, ['unsigned long']],
    'NonPagedPoolCharge' : [ 0x14, ['unsigned long']],
    'SecurityDescriptorCharge' : [ 0x18, ['unsigned long']],
    'SecurityDescriptor' : [ 0x1c, ['pointer', ['void']]],
    'SecurityQos' : [ 0x20, ['pointer', ['_SECURITY_QUALITY_OF_SERVICE']]],
    'SecurityQualityOfService' : [ 0x24, ['_SECURITY_QUALITY_OF_SERVICE']],
} ],
  '_POOL_HACKER' : [ 0x28, {
    'Header' : [ 0x0, ['_POOL_HEADER']],
    'Contents' : [ 0x8, ['array', 8, ['unsigned long']]],
} ],
  '_SECTION_OBJECT_POINTERS' : [ 0xc, {
    'DataSectionObject' : [ 0x0, ['pointer', ['void']]],
    'SharedCacheMap' : [ 0x4, ['pointer', ['void']]],
    'ImageSectionObject' : [ 0x8, ['pointer', ['void']]],
} ],
  '_VF_BTS_DATA_MANAGEMENT_AREA' : [ 0x34, {
    'BTSBufferBase' : [ 0x0, ['pointer', ['void']]],
    'BTSIndex' : [ 0x4, ['pointer', ['void']]],
    'BTSMax' : [ 0x8, ['pointer', ['void']]],
    'BTSInterruptThreshold' : [ 0xc, ['pointer', ['void']]],
    'PEBSBufferBase' : [ 0x10, ['pointer', ['void']]],
    'PEBSIndex' : [ 0x14, ['pointer', ['void']]],
    'PEBSMax' : [ 0x18, ['pointer', ['void']]],
    'PEBSInterruptThreshold' : [ 0x1c, ['pointer', ['void']]],
    'PEBSCounterReset' : [ 0x20, ['array', 2, ['pointer', ['void']]]],
    'Reserved' : [ 0x28, ['array', 12, ['unsigned char']]],
} ],
  '_FLOATING_SAVE_AREA' : [ 0x70, {
    'ControlWord' : [ 0x0, ['unsigned long']],
    'StatusWord' : [ 0x4, ['unsigned long']],
    'TagWord' : [ 0x8, ['unsigned long']],
    'ErrorOffset' : [ 0xc, ['unsigned long']],
    'ErrorSelector' : [ 0x10, ['unsigned long']],
    'DataOffset' : [ 0x14, ['unsigned long']],
    'DataSelector' : [ 0x18, ['unsigned long']],
    'RegisterArea' : [ 0x1c, ['array', 80, ['unsigned char']]],
    'Cr0NpxState' : [ 0x6c, ['unsigned long']],
} ],
  '_SEP_AUDIT_POLICY' : [ 0x1c, {
    'AdtTokenPolicy' : [ 0x0, ['_TOKEN_AUDIT_POLICY']],
    'PolicySetStatus' : [ 0x1b, ['unsigned char']],
} ],
  '_MMPTE_TIMESTAMP' : [ 0x4, {
    'MustBeZero' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'PageFileLow' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 5, native_type='unsigned long')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 10, native_type='unsigned long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'Transition' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'GlobalTimeStamp' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 32, native_type='unsigned long')]],
} ],
  '_SID_AND_ATTRIBUTES_HASH' : [ 0x88, {
    'SidCount' : [ 0x0, ['unsigned long']],
    'SidAttr' : [ 0x4, ['pointer', ['_SID_AND_ATTRIBUTES']]],
    'Hash' : [ 0x8, ['array', 32, ['unsigned long']]],
} ],
  '_MBCB' : [ 0x80, {
    'NodeTypeCode' : [ 0x0, ['short']],
    'NodeIsInZone' : [ 0x2, ['short']],
    'PagesToWrite' : [ 0x4, ['unsigned long']],
    'DirtyPages' : [ 0x8, ['unsigned long']],
    'Reserved' : [ 0xc, ['unsigned long']],
    'BitmapRanges' : [ 0x10, ['_LIST_ENTRY']],
    'ResumeWritePage' : [ 0x18, ['long long']],
    'BitmapRange1' : [ 0x20, ['_BITMAP_RANGE']],
    'BitmapRange2' : [ 0x40, ['_BITMAP_RANGE']],
    'BitmapRange3' : [ 0x60, ['_BITMAP_RANGE']],
} ],
  '__unnamed_1c2b' : [ 0x1, {
    'AsUCHAR' : [ 0x0, ['unsigned char']],
    'NoDomainAccounting' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'IncreasePolicy' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 3, native_type='unsigned char')]],
    'DecreasePolicy' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 5, native_type='unsigned char')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 8, native_type='unsigned char')]],
} ],
  'PROCESSOR_PERFSTATE_POLICY' : [ 0x1c, {
    'Revision' : [ 0x0, ['unsigned long']],
    'MaxThrottle' : [ 0x4, ['unsigned char']],
    'MinThrottle' : [ 0x5, ['unsigned char']],
    'BusyAdjThreshold' : [ 0x6, ['unsigned char']],
    'Spare' : [ 0x7, ['unsigned char']],
    'Flags' : [ 0x7, ['__unnamed_1c2b']],
    'TimeCheck' : [ 0x8, ['unsigned long']],
    'IncreaseTime' : [ 0xc, ['unsigned long']],
    'DecreaseTime' : [ 0x10, ['unsigned long']],
    'IncreasePercent' : [ 0x14, ['unsigned long']],
    'DecreasePercent' : [ 0x18, ['unsigned long']],
} ],
  '_BUS_EXTENSION_LIST' : [ 0x8, {
    'Next' : [ 0x0, ['pointer', ['void']]],
    'BusExtension' : [ 0x4, ['pointer', ['_PI_BUS_EXTENSION']]],
} ],
  '_CACHED_CHILD_LIST' : [ 0x8, {
    'Count' : [ 0x0, ['unsigned long']],
    'ValueList' : [ 0x4, ['unsigned long']],
    'RealKcb' : [ 0x4, ['pointer', ['_CM_KEY_CONTROL_BLOCK']]],
} ],
  '_KDEVICE_QUEUE' : [ 0x14, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['short']],
    'DeviceListHead' : [ 0x4, ['_LIST_ENTRY']],
    'Lock' : [ 0xc, ['unsigned long']],
    'Busy' : [ 0x10, ['unsigned char']],
} ],
  '_SYSTEM_POWER_STATE_CONTEXT' : [ 0x4, {
    'Reserved1' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned long')]],
    'TargetSystemState' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 12, native_type='unsigned long')]],
    'EffectiveSystemState' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 16, native_type='unsigned long')]],
    'CurrentSystemState' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 20, native_type='unsigned long')]],
    'IgnoreHibernationPath' : [ 0x0, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'PseudoTransition' : [ 0x0, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'Reserved2' : [ 0x0, ['BitField', dict(start_bit = 22, end_bit = 32, native_type='unsigned long')]],
    'ContextAsUlong' : [ 0x0, ['unsigned long']],
} ],
  '_OBJECT_TYPE_INITIALIZER' : [ 0x50, {
    'Length' : [ 0x0, ['unsigned short']],
    'ObjectTypeFlags' : [ 0x2, ['unsigned char']],
    'CaseInsensitive' : [ 0x2, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'UnnamedObjectsOnly' : [ 0x2, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'UseDefaultObject' : [ 0x2, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'SecurityRequired' : [ 0x2, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'MaintainHandleCount' : [ 0x2, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'MaintainTypeList' : [ 0x2, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'SupportsObjectCallbacks' : [ 0x2, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'ObjectTypeCode' : [ 0x4, ['unsigned long']],
    'InvalidAttributes' : [ 0x8, ['unsigned long']],
    'GenericMapping' : [ 0xc, ['_GENERIC_MAPPING']],
    'ValidAccessMask' : [ 0x1c, ['unsigned long']],
    'RetainAccess' : [ 0x20, ['unsigned long']],
    'PoolType' : [ 0x24, ['Enumeration', dict(target = 'long', choices = {0: 'NonPagedPool', 1: 'PagedPool', 2: 'NonPagedPoolMustSucceed', 3: 'DontUseThisType', 4: 'NonPagedPoolCacheAligned', 5: 'PagedPoolCacheAligned', 6: 'NonPagedPoolCacheAlignedMustS', 7: 'MaxPoolType', 34: 'NonPagedPoolMustSucceedSession', 35: 'DontUseThisTypeSession', 32: 'NonPagedPoolSession', 36: 'NonPagedPoolCacheAlignedSession', 33: 'PagedPoolSession', 38: 'NonPagedPoolCacheAlignedMustSSession', 37: 'PagedPoolCacheAlignedSession'})]],
    'DefaultPagedPoolCharge' : [ 0x28, ['unsigned long']],
    'DefaultNonPagedPoolCharge' : [ 0x2c, ['unsigned long']],
    'DumpProcedure' : [ 0x30, ['pointer', ['void']]],
    'OpenProcedure' : [ 0x34, ['pointer', ['void']]],
    'CloseProcedure' : [ 0x38, ['pointer', ['void']]],
    'DeleteProcedure' : [ 0x3c, ['pointer', ['void']]],
    'ParseProcedure' : [ 0x40, ['pointer', ['void']]],
    'SecurityProcedure' : [ 0x44, ['pointer', ['void']]],
    'QueryNameProcedure' : [ 0x48, ['pointer', ['void']]],
    'OkayToCloseProcedure' : [ 0x4c, ['pointer', ['void']]],
} ],
  '_IO_CLIENT_EXTENSION' : [ 0x8, {
    'NextExtension' : [ 0x0, ['pointer', ['_IO_CLIENT_EXTENSION']]],
    'ClientIdentificationAddress' : [ 0x4, ['pointer', ['void']]],
} ],
  '_ETW_BUFFER_CONTEXT' : [ 0x4, {
    'ProcessorNumber' : [ 0x0, ['unsigned char']],
    'Alignment' : [ 0x1, ['unsigned char']],
    'LoggerId' : [ 0x2, ['unsigned short']],
} ],
  '_KDPC' : [ 0x20, {
    'Type' : [ 0x0, ['unsigned char']],
    'Importance' : [ 0x1, ['unsigned char']],
    'Number' : [ 0x2, ['unsigned short']],
    'DpcListEntry' : [ 0x4, ['_LIST_ENTRY']],
    'DeferredRoutine' : [ 0xc, ['pointer', ['void']]],
    'DeferredContext' : [ 0x10, ['pointer', ['void']]],
    'SystemArgument1' : [ 0x14, ['pointer', ['void']]],
    'SystemArgument2' : [ 0x18, ['pointer', ['void']]],
    'DpcData' : [ 0x1c, ['pointer', ['void']]],
} ],
  '_KERNEL_STACK_SEGMENT' : [ 0x14, {
    'StackBase' : [ 0x0, ['unsigned long']],
    'StackLimit' : [ 0x4, ['unsigned long']],
    'KernelStack' : [ 0x8, ['unsigned long']],
    'InitialStack' : [ 0xc, ['unsigned long']],
    'ActualLimit' : [ 0x10, ['unsigned long']],
} ],
  '_KEXECUTE_OPTIONS' : [ 0x1, {
    'ExecuteDisable' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'ExecuteEnable' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'DisableThunkEmulation' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'Permanent' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'ExecuteDispatchEnable' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'ImageDispatchEnable' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'DisableExceptionChainValidation' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
} ],
  '_SEP_TOKEN_PRIVILEGES' : [ 0x18, {
    'Present' : [ 0x0, ['unsigned long long']],
    'Enabled' : [ 0x8, ['unsigned long long']],
    'EnabledByDefault' : [ 0x10, ['unsigned long long']],
} ],
  '_WHEA_PCIXDEVICE_ERROR_VALIDBITS' : [ 0x8, {
    'ErrorStatus' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'IdInfo' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'MemoryNumber' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'IoNumber' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long long')]],
    'RegisterDataPairs' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 64, native_type='unsigned long long')]],
    'ValidBits' : [ 0x0, ['unsigned long long']],
} ],
  'WHEA_PCIXDEVICE_REGISTER_PAIR' : [ 0x10, {
    'Register' : [ 0x0, ['unsigned long long']],
    'Data' : [ 0x8, ['unsigned long long']],
} ],
  '_ARBITER_ALLOCATION_STATE' : [ 0x38, {
    'Start' : [ 0x0, ['unsigned long long']],
    'End' : [ 0x8, ['unsigned long long']],
    'CurrentMinimum' : [ 0x10, ['unsigned long long']],
    'CurrentMaximum' : [ 0x18, ['unsigned long long']],
    'Entry' : [ 0x20, ['pointer', ['_ARBITER_LIST_ENTRY']]],
    'CurrentAlternative' : [ 0x24, ['pointer', ['_ARBITER_ALTERNATIVE']]],
    'AlternativeCount' : [ 0x28, ['unsigned long']],
    'Alternatives' : [ 0x2c, ['pointer', ['_ARBITER_ALTERNATIVE']]],
    'Flags' : [ 0x30, ['unsigned short']],
    'RangeAttributes' : [ 0x32, ['unsigned char']],
    'RangeAvailableAttributes' : [ 0x33, ['unsigned char']],
    'WorkSpace' : [ 0x34, ['unsigned long']],
} ],
  '_VACB_ARRAY_HEADER' : [ 0x10, {
    'Links' : [ 0x0, ['_LIST_ENTRY']],
    'MappingCount' : [ 0x8, ['unsigned long']],
    'Reserved' : [ 0xc, ['unsigned long']],
} ],
  '_MMWSLENTRY' : [ 0x4, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'LockedInWs' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'LockedInMemory' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 8, native_type='unsigned long')]],
    'Hashed' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'Direct' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'Age' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 12, native_type='unsigned long')]],
    'VirtualPageNumber' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 32, native_type='unsigned long')]],
} ],
  '_DBGKD_SWITCH_PARTITION' : [ 0x4, {
    'Partition' : [ 0x0, ['unsigned long']],
} ],
  '_DBGKD_GET_VERSION32' : [ 0x28, {
    'MajorVersion' : [ 0x0, ['unsigned short']],
    'MinorVersion' : [ 0x2, ['unsigned short']],
    'ProtocolVersion' : [ 0x4, ['unsigned short']],
    'Flags' : [ 0x6, ['unsigned short']],
    'KernBase' : [ 0x8, ['unsigned long']],
    'PsLoadedModuleList' : [ 0xc, ['unsigned long']],
    'MachineType' : [ 0x10, ['unsigned short']],
    'ThCallbackStack' : [ 0x12, ['unsigned short']],
    'NextCallback' : [ 0x14, ['unsigned short']],
    'FramePointer' : [ 0x16, ['unsigned short']],
    'KiCallUserMode' : [ 0x18, ['unsigned long']],
    'KeUserCallbackDispatcher' : [ 0x1c, ['unsigned long']],
    'BreakpointWithStatus' : [ 0x20, ['unsigned long']],
    'DebuggerDataList' : [ 0x24, ['unsigned long']],
} ],
  '_INTERLOCK_SEQ' : [ 0x8, {
    'Depth' : [ 0x0, ['unsigned short']],
    'FreeEntryOffset' : [ 0x2, ['unsigned short']],
    'OffsetAndDepth' : [ 0x0, ['unsigned long']],
    'Sequence' : [ 0x4, ['unsigned long']],
    'Exchg' : [ 0x0, ['long long']],
} ],
  '_WHEA_TIMESTAMP' : [ 0x8, {
    'Seconds' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned long long')]],
    'Minutes' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 16, native_type='unsigned long long')]],
    'Hours' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 24, native_type='unsigned long long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long long')]],
    'Day' : [ 0x0, ['BitField', dict(start_bit = 32, end_bit = 40, native_type='unsigned long long')]],
    'Month' : [ 0x0, ['BitField', dict(start_bit = 40, end_bit = 48, native_type='unsigned long long')]],
    'Year' : [ 0x0, ['BitField', dict(start_bit = 48, end_bit = 56, native_type='unsigned long long')]],
    'Century' : [ 0x0, ['BitField', dict(start_bit = 56, end_bit = 64, native_type='unsigned long long')]],
    'AsLARGE_INTEGER' : [ 0x0, ['_LARGE_INTEGER']],
} ],
  '_VPB' : [ 0x58, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['short']],
    'Flags' : [ 0x4, ['unsigned short']],
    'VolumeLabelLength' : [ 0x6, ['unsigned short']],
    'DeviceObject' : [ 0x8, ['pointer', ['_DEVICE_OBJECT']]],
    'RealDevice' : [ 0xc, ['pointer', ['_DEVICE_OBJECT']]],
    'SerialNumber' : [ 0x10, ['unsigned long']],
    'ReferenceCount' : [ 0x14, ['unsigned long']],
    'VolumeLabel' : [ 0x18, ['array', 32, ['wchar']]],
} ],
  '_CACHE_DESCRIPTOR' : [ 0xc, {
    'Level' : [ 0x0, ['unsigned char']],
    'Associativity' : [ 0x1, ['unsigned char']],
    'LineSize' : [ 0x2, ['unsigned short']],
    'Size' : [ 0x4, ['unsigned long']],
    'Type' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: 'CacheUnified', 1: 'CacheInstruction', 2: 'CacheData', 3: 'CacheTrace'})]],
} ],
  '_SECURITY_SUBJECT_CONTEXT' : [ 0x10, {
    'ClientToken' : [ 0x0, ['pointer', ['void']]],
    'ImpersonationLevel' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'SecurityAnonymous', 1: 'SecurityIdentification', 2: 'SecurityImpersonation', 3: 'SecurityDelegation'})]],
    'PrimaryToken' : [ 0x8, ['pointer', ['void']]],
    'ProcessAuditId' : [ 0xc, ['pointer', ['void']]],
} ],
  '_GENERIC_MAPPING' : [ 0x10, {
    'GenericRead' : [ 0x0, ['unsigned long']],
    'GenericWrite' : [ 0x4, ['unsigned long']],
    'GenericExecute' : [ 0x8, ['unsigned long']],
    'GenericAll' : [ 0xc, ['unsigned long']],
} ],
  '_KiIoAccessMap' : [ 0x2024, {
    'DirectionMap' : [ 0x0, ['array', 32, ['unsigned char']]],
    'IoMap' : [ 0x20, ['array', 8196, ['unsigned char']]],
} ],
  '_PF_KERNEL_GLOBALS' : [ 0x40, {
    'AccessBufferAgeThreshold' : [ 0x0, ['unsigned long long']],
    'AccessBufferRef' : [ 0x8, ['_EX_RUNDOWN_REF']],
    'AccessBufferExistsEvent' : [ 0xc, ['_KEVENT']],
    'AccessBufferMax' : [ 0x1c, ['unsigned long']],
    'AccessBufferList' : [ 0x20, ['_SLIST_HEADER']],
    'StreamSequenceNumber' : [ 0x28, ['long']],
    'Flags' : [ 0x2c, ['unsigned long']],
    'ScenarioPrefetchCount' : [ 0x30, ['long']],
} ],
  '_ARBITER_QUERY_ARBITRATE_PARAMETERS' : [ 0x4, {
    'ArbitrationList' : [ 0x0, ['pointer', ['_LIST_ENTRY']]],
} ],
  '_DBGKD_RESTORE_BREAKPOINT' : [ 0x4, {
    'BreakPointHandle' : [ 0x0, ['unsigned long']],
} ],
  '_ARBITER_BOOT_ALLOCATION_PARAMETERS' : [ 0x4, {
    'ArbitrationList' : [ 0x0, ['pointer', ['_LIST_ENTRY']]],
} ],
  '_EXCEPTION_REGISTRATION_RECORD' : [ 0x8, {
    'Next' : [ 0x0, ['pointer', ['_EXCEPTION_REGISTRATION_RECORD']]],
    'Handler' : [ 0x4, ['pointer', ['void']]],
} ],
  '_WHEA_PCIXBUS_ID' : [ 0x2, {
    'BusNumber' : [ 0x0, ['unsigned char']],
    'BusSegment' : [ 0x1, ['unsigned char']],
    'AsUSHORT' : [ 0x0, ['unsigned short']],
} ],
  '_ETW_REF_CLOCK' : [ 0x10, {
    'StartTime' : [ 0x0, ['_LARGE_INTEGER']],
    'StartPerfClock' : [ 0x8, ['_LARGE_INTEGER']],
} ],
  '_OB_DUPLICATE_OBJECT_STATE' : [ 0x1c, {
    'SourceProcess' : [ 0x0, ['pointer', ['_EPROCESS']]],
    'SourceHandle' : [ 0x4, ['pointer', ['void']]],
    'Object' : [ 0x8, ['pointer', ['void']]],
    'ObjectType' : [ 0xc, ['pointer', ['_OBJECT_TYPE']]],
    'TargetAccess' : [ 0x10, ['unsigned long']],
    'ObjectInfo' : [ 0x14, ['_HANDLE_TABLE_ENTRY_INFO']],
    'HandleAttributes' : [ 0x18, ['unsigned long']],
} ],
  '_MMPTE_SUBSECTION' : [ 0x4, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'SubsectionAddressLow' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 10, native_type='unsigned long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'SubsectionAddressHigh' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 32, native_type='unsigned long')]],
} ],
  '_POWER_STATE' : [ 0x4, {
    'SystemState' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'DeviceState' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'PowerDeviceUnspecified', 1: 'PowerDeviceD0', 2: 'PowerDeviceD1', 3: 'PowerDeviceD2', 4: 'PowerDeviceD3', 5: 'PowerDeviceMaximum'})]],
} ],
  '_EFI_FIRMWARE_INFORMATION' : [ 0x10, {
    'FirmwareVersion' : [ 0x0, ['unsigned long']],
    'VirtualEfiRuntimeServices' : [ 0x4, ['pointer', ['_VIRTUAL_EFI_RUNTIME_SERVICES']]],
    'SetVirtualAddressMapStatus' : [ 0x8, ['long']],
    'MissedMappingsCount' : [ 0xc, ['unsigned long']],
} ],
  '__unnamed_1cbe' : [ 0xc, {
    'Start' : [ 0x0, ['_LARGE_INTEGER']],
    'Length' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_1cc0' : [ 0xc, {
    'Level' : [ 0x0, ['unsigned long']],
    'Vector' : [ 0x4, ['unsigned long']],
    'Affinity' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_1cc2' : [ 0xc, {
    'Reserved' : [ 0x0, ['unsigned short']],
    'MessageCount' : [ 0x2, ['unsigned short']],
    'Vector' : [ 0x4, ['unsigned long']],
    'Affinity' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_1cc4' : [ 0xc, {
    'Raw' : [ 0x0, ['__unnamed_1cc2']],
    'Translated' : [ 0x0, ['__unnamed_1cc0']],
} ],
  '__unnamed_1cc6' : [ 0xc, {
    'Channel' : [ 0x0, ['unsigned long']],
    'Port' : [ 0x4, ['unsigned long']],
    'Reserved1' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_1cc8' : [ 0xc, {
    'Start' : [ 0x0, ['unsigned long']],
    'Length' : [ 0x4, ['unsigned long']],
    'Reserved' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_1cca' : [ 0xc, {
    'DataSize' : [ 0x0, ['unsigned long']],
    'Reserved1' : [ 0x4, ['unsigned long']],
    'Reserved2' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_1ccc' : [ 0xc, {
    'Start' : [ 0x0, ['_LARGE_INTEGER']],
    'Length40' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_1cce' : [ 0xc, {
    'Start' : [ 0x0, ['_LARGE_INTEGER']],
    'Length48' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_1cd0' : [ 0xc, {
    'Start' : [ 0x0, ['_LARGE_INTEGER']],
    'Length64' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_1cd2' : [ 0xc, {
    'Generic' : [ 0x0, ['__unnamed_1cbe']],
    'Port' : [ 0x0, ['__unnamed_1cbe']],
    'Interrupt' : [ 0x0, ['__unnamed_1cc0']],
    'MessageInterrupt' : [ 0x0, ['__unnamed_1cc4']],
    'Memory' : [ 0x0, ['__unnamed_1cbe']],
    'Dma' : [ 0x0, ['__unnamed_1cc6']],
    'DevicePrivate' : [ 0x0, ['__unnamed_1bda']],
    'BusNumber' : [ 0x0, ['__unnamed_1cc8']],
    'DeviceSpecificData' : [ 0x0, ['__unnamed_1cca']],
    'Memory40' : [ 0x0, ['__unnamed_1ccc']],
    'Memory48' : [ 0x0, ['__unnamed_1cce']],
    'Memory64' : [ 0x0, ['__unnamed_1cd0']],
} ],
  '_CM_PARTIAL_RESOURCE_DESCRIPTOR' : [ 0x10, {
    'Type' : [ 0x0, ['unsigned char']],
    'ShareDisposition' : [ 0x1, ['unsigned char']],
    'Flags' : [ 0x2, ['unsigned short']],
    'u' : [ 0x4, ['__unnamed_1cd2']],
} ],
  '_WHEA_REVISION' : [ 0x2, {
    'MinorRevision' : [ 0x0, ['unsigned char']],
    'MajorRevision' : [ 0x1, ['unsigned char']],
    'AsUSHORT' : [ 0x0, ['unsigned short']],
} ],
  '__unnamed_1cd9' : [ 0x4, {
    'PhysicalAddress' : [ 0x0, ['unsigned long']],
    'VirtualSize' : [ 0x0, ['unsigned long']],
} ],
  '_IMAGE_SECTION_HEADER' : [ 0x28, {
    'Name' : [ 0x0, ['array', 8, ['unsigned char']]],
    'Misc' : [ 0x8, ['__unnamed_1cd9']],
    'VirtualAddress' : [ 0xc, ['unsigned long']],
    'SizeOfRawData' : [ 0x10, ['unsigned long']],
    'PointerToRawData' : [ 0x14, ['unsigned long']],
    'PointerToRelocations' : [ 0x18, ['unsigned long']],
    'PointerToLinenumbers' : [ 0x1c, ['unsigned long']],
    'NumberOfRelocations' : [ 0x20, ['unsigned short']],
    'NumberOfLinenumbers' : [ 0x22, ['unsigned short']],
    'Characteristics' : [ 0x24, ['unsigned long']],
} ],
  '_ARBITER_ADD_RESERVED_PARAMETERS' : [ 0x4, {
    'ReserveDevice' : [ 0x0, ['pointer', ['_DEVICE_OBJECT']]],
} ],
  '_KUSER_SHARED_DATA' : [ 0x3b8, {
    'TickCountLowDeprecated' : [ 0x0, ['unsigned long']],
    'TickCountMultiplier' : [ 0x4, ['unsigned long']],
    'InterruptTime' : [ 0x8, ['_KSYSTEM_TIME']],
    'SystemTime' : [ 0x14, ['_KSYSTEM_TIME']],
    'TimeZoneBias' : [ 0x20, ['_KSYSTEM_TIME']],
    'ImageNumberLow' : [ 0x2c, ['unsigned short']],
    'ImageNumberHigh' : [ 0x2e, ['unsigned short']],
    'NtSystemRoot' : [ 0x30, ['array', 260, ['wchar']]],
    'MaxStackTraceDepth' : [ 0x238, ['unsigned long']],
    'CryptoExponent' : [ 0x23c, ['unsigned long']],
    'TimeZoneId' : [ 0x240, ['unsigned long']],
    'LargePageMinimum' : [ 0x244, ['unsigned long']],
    'Reserved2' : [ 0x248, ['array', 7, ['unsigned long']]],
    'NtProductType' : [ 0x264, ['Enumeration', dict(target = 'long', choices = {1: 'NtProductWinNt', 2: 'NtProductLanManNt', 3: 'NtProductServer'})]],
    'ProductTypeIsValid' : [ 0x268, ['unsigned char']],
    'NtMajorVersion' : [ 0x26c, ['unsigned long']],
    'NtMinorVersion' : [ 0x270, ['unsigned long']],
    'ProcessorFeatures' : [ 0x274, ['array', 64, ['unsigned char']]],
    'Reserved1' : [ 0x2b4, ['unsigned long']],
    'Reserved3' : [ 0x2b8, ['unsigned long']],
    'TimeSlip' : [ 0x2bc, ['unsigned long']],
    'AlternativeArchitecture' : [ 0x2c0, ['Enumeration', dict(target = 'long', choices = {0: 'StandardDesign', 1: 'NEC98x86', 2: 'EndAlternatives'})]],
    'SystemExpirationDate' : [ 0x2c8, ['_LARGE_INTEGER']],
    'SuiteMask' : [ 0x2d0, ['unsigned long']],
    'KdDebuggerEnabled' : [ 0x2d4, ['unsigned char']],
    'NXSupportPolicy' : [ 0x2d5, ['unsigned char']],
    'ActiveConsoleId' : [ 0x2d8, ['unsigned long']],
    'DismountCount' : [ 0x2dc, ['unsigned long']],
    'ComPlusPackage' : [ 0x2e0, ['unsigned long']],
    'LastSystemRITEventTickCount' : [ 0x2e4, ['unsigned long']],
    'NumberOfPhysicalPages' : [ 0x2e8, ['unsigned long']],
    'SafeBootMode' : [ 0x2ec, ['unsigned char']],
    'SharedDataFlags' : [ 0x2f0, ['unsigned long']],
    'DbgErrorPortPresent' : [ 0x2f0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'DbgElevationEnabled' : [ 0x2f0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'DbgVirtEnabled' : [ 0x2f0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'DbgInstallerDetectEnabled' : [ 0x2f0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'DbgSystemDllRelocated' : [ 0x2f0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'DbgDynProcessorEnabled' : [ 0x2f0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'DbgSEHValidationEnabled' : [ 0x2f0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'SpareBits' : [ 0x2f0, ['BitField', dict(start_bit = 7, end_bit = 32, native_type='unsigned long')]],
    'TestRetInstruction' : [ 0x2f8, ['unsigned long long']],
    'SystemCall' : [ 0x300, ['unsigned long']],
    'SystemCallReturn' : [ 0x304, ['unsigned long']],
    'SystemCallPad' : [ 0x308, ['array', 3, ['unsigned long long']]],
    'TickCount' : [ 0x320, ['_KSYSTEM_TIME']],
    'TickCountQuad' : [ 0x320, ['unsigned long long']],
    'Cookie' : [ 0x330, ['unsigned long']],
    'ConsoleSessionForegroundProcessId' : [ 0x338, ['long long']],
    'Wow64SharedInformation' : [ 0x340, ['array', 16, ['unsigned long']]],
    'UserModeGlobalLogger' : [ 0x380, ['array', 8, ['unsigned short']]],
    'HeapTracingPid' : [ 0x390, ['array', 2, ['unsigned long']]],
    'CritSecTracingPid' : [ 0x398, ['array', 2, ['unsigned long']]],
    'ImageFileExecutionOptions' : [ 0x3a0, ['unsigned long']],
    'LangGenerationCount' : [ 0x3a4, ['unsigned long']],
    'AffinityPad' : [ 0x3a8, ['unsigned long long']],
    'ActiveProcessorAffinity' : [ 0x3a8, ['unsigned long']],
    'InterruptTimeBias' : [ 0x3b0, ['unsigned long long']],
} ],
  '__unnamed_1ced' : [ 0x50, {
    'CellData' : [ 0x0, ['_CELL_DATA']],
    'List' : [ 0x0, ['array', 1, ['unsigned long']]],
} ],
  '_CM_CACHED_VALUE_INDEX' : [ 0x54, {
    'CellIndex' : [ 0x0, ['unsigned long']],
    'Data' : [ 0x4, ['__unnamed_1ced']],
} ],
  '_CONFIGURATION_COMPONENT_DATA' : [ 0x34, {
    'Parent' : [ 0x0, ['pointer', ['_CONFIGURATION_COMPONENT_DATA']]],
    'Child' : [ 0x4, ['pointer', ['_CONFIGURATION_COMPONENT_DATA']]],
    'Sibling' : [ 0x8, ['pointer', ['_CONFIGURATION_COMPONENT_DATA']]],
    'ComponentEntry' : [ 0xc, ['_CONFIGURATION_COMPONENT']],
    'ConfigurationData' : [ 0x30, ['pointer', ['void']]],
} ],
  '_DBGKD_QUERY_SPECIAL_CALLS' : [ 0x4, {
    'NumberOfSpecialCalls' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_1cf7' : [ 0x4, {
    'Balance' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='long')]],
    'Parent' : [ 0x0, ['pointer', ['_MMSUBSECTION_NODE']]],
} ],
  '_MMSUBSECTION_NODE' : [ 0x18, {
    'u' : [ 0x0, ['__unnamed_14c5']],
    'StartingSector' : [ 0x4, ['unsigned long']],
    'NumberOfFullSectors' : [ 0x8, ['unsigned long']],
    'u1' : [ 0xc, ['__unnamed_1cf7']],
    'LeftChild' : [ 0x10, ['pointer', ['_MMSUBSECTION_NODE']]],
    'RightChild' : [ 0x14, ['pointer', ['_MMSUBSECTION_NODE']]],
} ],
  '__unnamed_1cfd' : [ 0x8, {
    'IdleTime' : [ 0x0, ['unsigned long']],
    'NonIdleTime' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_1cff' : [ 0x8, {
    'Disk' : [ 0x0, ['__unnamed_1cfd']],
} ],
  '_DEVICE_OBJECT_POWER_EXTENSION' : [ 0x60, {
    'IdleCount' : [ 0x0, ['unsigned long']],
    'BusyCount' : [ 0x4, ['unsigned long']],
    'TotalBusyCount' : [ 0x8, ['unsigned long']],
    'ConservationIdleTime' : [ 0xc, ['unsigned long']],
    'PerformanceIdleTime' : [ 0x10, ['unsigned long']],
    'DeviceObject' : [ 0x14, ['pointer', ['_DEVICE_OBJECT']]],
    'IdleList' : [ 0x18, ['_LIST_ENTRY']],
    'DeviceType' : [ 0x20, ['unsigned char']],
    'IdleState' : [ 0x24, ['Enumeration', dict(target = 'long', choices = {0: 'PowerDeviceUnspecified', 1: 'PowerDeviceD0', 2: 'PowerDeviceD1', 3: 'PowerDeviceD2', 4: 'PowerDeviceD3', 5: 'PowerDeviceMaximum'})]],
    'CurrentState' : [ 0x28, ['Enumeration', dict(target = 'long', choices = {0: 'PowerDeviceUnspecified', 1: 'PowerDeviceD0', 2: 'PowerDeviceD1', 3: 'PowerDeviceD2', 4: 'PowerDeviceD3', 5: 'PowerDeviceMaximum'})]],
    'NotifySourceList' : [ 0x2c, ['_LIST_ENTRY']],
    'NotifyTargetList' : [ 0x34, ['_LIST_ENTRY']],
    'PowerChannelSummary' : [ 0x3c, ['_POWER_CHANNEL_SUMMARY']],
    'Volume' : [ 0x50, ['_LIST_ENTRY']],
    'Specific' : [ 0x58, ['__unnamed_1cff']],
} ],
  '_ARBITER_RETEST_ALLOCATION_PARAMETERS' : [ 0xc, {
    'ArbitrationList' : [ 0x0, ['pointer', ['_LIST_ENTRY']]],
    'AllocateFromCount' : [ 0x4, ['unsigned long']],
    'AllocateFrom' : [ 0x8, ['pointer', ['_CM_PARTIAL_RESOURCE_DESCRIPTOR']]],
} ],
  '_WHEA_ERROR_STATUS' : [ 0x8, {
    'ErrorStatus' : [ 0x0, ['unsigned long long']],
    'Reserved1' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned long long')]],
    'ErrorType' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 16, native_type='unsigned long long')]],
    'Address' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long long')]],
    'Control' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long long')]],
    'Data' : [ 0x0, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long long')]],
    'Responder' : [ 0x0, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long long')]],
    'Requester' : [ 0x0, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long long')]],
    'FirstError' : [ 0x0, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long long')]],
    'Overflow' : [ 0x0, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long long')]],
    'Reserved2' : [ 0x0, ['BitField', dict(start_bit = 23, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_VALIDBITS' : [ 0x1, {
    'FRUId' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'FRUText' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 8, native_type='unsigned char')]],
    'AsUCHAR' : [ 0x0, ['unsigned char']],
} ],
  '_FS_FILTER_CALLBACKS' : [ 0x38, {
    'SizeOfFsFilterCallbacks' : [ 0x0, ['unsigned long']],
    'Reserved' : [ 0x4, ['unsigned long']],
    'PreAcquireForSectionSynchronization' : [ 0x8, ['pointer', ['void']]],
    'PostAcquireForSectionSynchronization' : [ 0xc, ['pointer', ['void']]],
    'PreReleaseForSectionSynchronization' : [ 0x10, ['pointer', ['void']]],
    'PostReleaseForSectionSynchronization' : [ 0x14, ['pointer', ['void']]],
    'PreAcquireForCcFlush' : [ 0x18, ['pointer', ['void']]],
    'PostAcquireForCcFlush' : [ 0x1c, ['pointer', ['void']]],
    'PreReleaseForCcFlush' : [ 0x20, ['pointer', ['void']]],
    'PostReleaseForCcFlush' : [ 0x24, ['pointer', ['void']]],
    'PreAcquireForModifiedPageWriter' : [ 0x28, ['pointer', ['void']]],
    'PostAcquireForModifiedPageWriter' : [ 0x2c, ['pointer', ['void']]],
    'PreReleaseForModifiedPageWriter' : [ 0x30, ['pointer', ['void']]],
    'PostReleaseForModifiedPageWriter' : [ 0x34, ['pointer', ['void']]],
} ],
  '_KENLISTMENT' : [ 0x168, {
    'cookie' : [ 0x0, ['unsigned long']],
    'NamespaceLink' : [ 0x4, ['_KTMOBJECT_NAMESPACE_LINK']],
    'EnlistmentId' : [ 0x18, ['_GUID']],
    'Mutex' : [ 0x28, ['_KMUTANT']],
    'NextSameTx' : [ 0x48, ['_LIST_ENTRY']],
    'NextSameRm' : [ 0x50, ['_LIST_ENTRY']],
    'ResourceManager' : [ 0x58, ['pointer', ['_KRESOURCEMANAGER']]],
    'Transaction' : [ 0x5c, ['pointer', ['_KTRANSACTION']]],
    'State' : [ 0x60, ['Enumeration', dict(target = 'long', choices = {0: 'KEnlistmentUninitialized', 256: 'KEnlistmentActive', 258: 'KEnlistmentPrepared', 259: 'KEnlistmentInDoubt', 260: 'KEnlistmentCommitted', 261: 'KEnlistmentCommittedNotify', 262: 'KEnlistmentCommitRequested', 257: 'KEnlistmentPreparing', 264: 'KEnlistmentDelegated', 265: 'KEnlistmentDelegatedDisconnected', 266: 'KEnlistmentPrePreparing', 263: 'KEnlistmentAborted', 268: 'KEnlistmentRecovering', 269: 'KEnlistmentAborting', 270: 'KEnlistmentReadOnly', 271: 'KEnlistmentOutcomeUnavailable', 272: 'KEnlistmentOffline', 273: 'KEnlistmentPrePrepared', 274: 'KEnlistmentInitialized', 267: 'KEnlistmentForgotten'})]],
    'Flags' : [ 0x64, ['unsigned long']],
    'NotificationMask' : [ 0x68, ['unsigned long']],
    'Key' : [ 0x6c, ['pointer', ['void']]],
    'KeyRefCount' : [ 0x70, ['unsigned long']],
    'RecoveryInformation' : [ 0x74, ['pointer', ['void']]],
    'RecoveryInformationLength' : [ 0x78, ['unsigned long']],
    'DynamicNameInformation' : [ 0x7c, ['pointer', ['void']]],
    'DynamicNameInformationLength' : [ 0x80, ['unsigned long']],
    'FinalNotification' : [ 0x84, ['pointer', ['_KTMNOTIFICATION_PACKET']]],
    'SupSubEnlistment' : [ 0x88, ['pointer', ['_KENLISTMENT']]],
    'SupSubEnlHandle' : [ 0x8c, ['pointer', ['void']]],
    'SubordinateTxHandle' : [ 0x90, ['pointer', ['void']]],
    'CrmEnlistmentEnId' : [ 0x94, ['_GUID']],
    'CrmEnlistmentTmId' : [ 0xa4, ['_GUID']],
    'CrmEnlistmentRmId' : [ 0xb4, ['_GUID']],
    'NextHistory' : [ 0xc4, ['unsigned long']],
    'History' : [ 0xc8, ['array', 20, ['_KENLISTMENT_HISTORY']]],
} ],
  '_ARBITER_INTERFACE' : [ 0x18, {
    'Size' : [ 0x0, ['unsigned short']],
    'Version' : [ 0x2, ['unsigned short']],
    'Context' : [ 0x4, ['pointer', ['void']]],
    'InterfaceReference' : [ 0x8, ['pointer', ['void']]],
    'InterfaceDereference' : [ 0xc, ['pointer', ['void']]],
    'ArbiterHandler' : [ 0x10, ['pointer', ['void']]],
    'Flags' : [ 0x14, ['unsigned long']],
} ],
  '_KAPC_STATE' : [ 0x18, {
    'ApcListHead' : [ 0x0, ['array', 2, ['_LIST_ENTRY']]],
    'Process' : [ 0x10, ['pointer', ['_KPROCESS']]],
    'KernelApcInProgress' : [ 0x14, ['unsigned char']],
    'KernelApcPending' : [ 0x15, ['unsigned char']],
    'UserApcPending' : [ 0x16, ['unsigned char']],
} ],
  '_IA64_LOADER_BLOCK' : [ 0x4, {
    'PlaceHolder' : [ 0x0, ['unsigned long']],
} ],
  '_DEVICE_RELATIONS' : [ 0x8, {
    'Count' : [ 0x0, ['unsigned long']],
    'Objects' : [ 0x4, ['array', 1, ['pointer', ['_DEVICE_OBJECT']]]],
} ],
  '_IMAGE_ROM_OPTIONAL_HEADER' : [ 0x38, {
    'Magic' : [ 0x0, ['unsigned short']],
    'MajorLinkerVersion' : [ 0x2, ['unsigned char']],
    'MinorLinkerVersion' : [ 0x3, ['unsigned char']],
    'SizeOfCode' : [ 0x4, ['unsigned long']],
    'SizeOfInitializedData' : [ 0x8, ['unsigned long']],
    'SizeOfUninitializedData' : [ 0xc, ['unsigned long']],
    'AddressOfEntryPoint' : [ 0x10, ['unsigned long']],
    'BaseOfCode' : [ 0x14, ['unsigned long']],
    'BaseOfData' : [ 0x18, ['unsigned long']],
    'BaseOfBss' : [ 0x1c, ['unsigned long']],
    'GprMask' : [ 0x20, ['unsigned long']],
    'CprMask' : [ 0x24, ['array', 4, ['unsigned long']]],
    'GpValue' : [ 0x34, ['unsigned long']],
} ],
  '_ALPC_COMPLETION_LIST_HEADER' : [ 0x300, {
    'StartMagic' : [ 0x0, ['unsigned long long']],
    'TotalSize' : [ 0x8, ['unsigned long']],
    'ListOffset' : [ 0xc, ['unsigned long']],
    'ListSize' : [ 0x10, ['unsigned long']],
    'BitmapOffset' : [ 0x14, ['unsigned long']],
    'BitmapSize' : [ 0x18, ['unsigned long']],
    'DataOffset' : [ 0x1c, ['unsigned long']],
    'DataSize' : [ 0x20, ['unsigned long']],
    'AttributeFlags' : [ 0x24, ['unsigned long']],
    'AttributeSize' : [ 0x28, ['unsigned long']],
    'State' : [ 0x80, ['_ALPC_COMPLETION_LIST_STATE']],
    'LastMessageId' : [ 0x88, ['unsigned long']],
    'LastCallbackId' : [ 0x8c, ['unsigned long']],
    'PostCount' : [ 0x100, ['unsigned long']],
    'ReturnCount' : [ 0x180, ['unsigned long']],
    'LogSequenceNumber' : [ 0x200, ['unsigned long']],
    'UserLock' : [ 0x280, ['_RTL_SRWLOCK']],
    'EndMagic' : [ 0x288, ['unsigned long long']],
} ],
  '_IMAGE_DEBUG_DIRECTORY' : [ 0x1c, {
    'Characteristics' : [ 0x0, ['unsigned long']],
    'TimeDateStamp' : [ 0x4, ['unsigned long']],
    'MajorVersion' : [ 0x8, ['unsigned short']],
    'MinorVersion' : [ 0xa, ['unsigned short']],
    'Type' : [ 0xc, ['unsigned long']],
    'SizeOfData' : [ 0x10, ['unsigned long']],
    'AddressOfRawData' : [ 0x14, ['unsigned long']],
    'PointerToRawData' : [ 0x18, ['unsigned long']],
} ],
  '_DEVICE_MAP' : [ 0x34, {
    'DosDevicesDirectory' : [ 0x0, ['pointer', ['_OBJECT_DIRECTORY']]],
    'GlobalDosDevicesDirectory' : [ 0x4, ['pointer', ['_OBJECT_DIRECTORY']]],
    'DosDevicesDirectoryHandle' : [ 0x8, ['pointer', ['void']]],
    'ReferenceCount' : [ 0xc, ['unsigned long']],
    'DriveMap' : [ 0x10, ['unsigned long']],
    'DriveType' : [ 0x14, ['array', 32, ['unsigned char']]],
} ],
  '_CHILD_LIST' : [ 0x8, {
    'Count' : [ 0x0, ['unsigned long']],
    'List' : [ 0x4, ['unsigned long']],
} ],
  '_ETW_KERNEL_TRACE_TIMESTAMP' : [ 0x10, {
    'KernelTraceTimeStamp' : [ 0x0, ['array', 2, ['_LARGE_INTEGER']]],
} ],
  '_HEAP_DEBUGGING_INFORMATION' : [ 0x1c, {
    'InterceptorFunction' : [ 0x0, ['pointer', ['void']]],
    'InterceptorValue' : [ 0x4, ['unsigned short']],
    'ExtendedOptions' : [ 0x8, ['unsigned long']],
    'StackTraceDepth' : [ 0xc, ['unsigned long']],
    'MinTotalBlockSize' : [ 0x10, ['unsigned long']],
    'MaxTotalBlockSize' : [ 0x14, ['unsigned long']],
    'HeapLeakEnumerationRoutine' : [ 0x18, ['pointer', ['void']]],
} ],
  '_IO_RESOURCE_LIST' : [ 0x28, {
    'Version' : [ 0x0, ['unsigned short']],
    'Revision' : [ 0x2, ['unsigned short']],
    'Count' : [ 0x4, ['unsigned long']],
    'Descriptors' : [ 0x8, ['array', 1, ['_IO_RESOURCE_DESCRIPTOR']]],
} ],
  '_MMBANKED_SECTION' : [ 0x20, {
    'BasePhysicalPage' : [ 0x0, ['unsigned long']],
    'BasedPte' : [ 0x4, ['pointer', ['_MMPTE']]],
    'BankSize' : [ 0x8, ['unsigned long']],
    'BankShift' : [ 0xc, ['unsigned long']],
    'BankedRoutine' : [ 0x10, ['pointer', ['void']]],
    'Context' : [ 0x14, ['pointer', ['void']]],
    'CurrentMappedPte' : [ 0x18, ['pointer', ['_MMPTE']]],
    'BankTemplate' : [ 0x1c, ['array', 1, ['_MMPTE']]],
} ],
  '_WHEA_ERROR_RECORD_HEADER_FLAGS' : [ 0x4, {
    'Recovered' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'PreviousError' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Simulated' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_WHEA_PCIEXPRESS_ERROR' : [ 0xd0, {
    'ValidBits' : [ 0x0, ['_WHEA_PCIEXPRESS_ERROR_VALIDBITS']],
    'PortType' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: 'WheaPciExpressEndpoint', 1: 'WheaPciExpressLegacyEndpoint', 4: 'WheaPciExpressRootPort', 5: 'WheaPciExpressUpstreamSwitchPort', 6: 'WheaPciExpressDownstreamSwitchPort', 7: 'WheaPciExpressToPciXBridge', 8: 'WheaPciXToExpressBridge', 9: 'WheaPciExpressRootComplexIntegratedEndpoint', 10: 'WheaPciExpressRootComplexEventCollector'})]],
    'Version' : [ 0xc, ['_WHEA_PCIEXPRESS_VERSION']],
    'CommandStatus' : [ 0x10, ['_WHEA_PCIEXPRESS_COMMAND_STATUS']],
    'Reserved' : [ 0x14, ['unsigned long']],
    'DeviceId' : [ 0x18, ['_WHEA_PCIEXPRESS_DEVICE_ID']],
    'DeviceSerialNumber' : [ 0x28, ['unsigned long long']],
    'BridgeControlStatus' : [ 0x30, ['_WHEA_PCIEXPRESS_BRIDGE_CONTROL_STATUS']],
    'ExpressCapability' : [ 0x34, ['array', 60, ['unsigned char']]],
    'AerInfo' : [ 0x70, ['array', 96, ['unsigned char']]],
} ],
  '_HEAP_VIRTUAL_ALLOC_ENTRY' : [ 0x20, {
    'Entry' : [ 0x0, ['_LIST_ENTRY']],
    'ExtraStuff' : [ 0x8, ['_HEAP_ENTRY_EXTRA']],
    'CommitSize' : [ 0x10, ['unsigned long']],
    'ReserveSize' : [ 0x14, ['unsigned long']],
    'BusyBlock' : [ 0x18, ['_HEAP_ENTRY']],
} ],
  '_RTL_CRITICAL_SECTION' : [ 0x18, {
    'DebugInfo' : [ 0x0, ['pointer', ['_RTL_CRITICAL_SECTION_DEBUG']]],
    'LockCount' : [ 0x4, ['long']],
    'RecursionCount' : [ 0x8, ['long']],
    'OwningThread' : [ 0xc, ['pointer', ['void']]],
    'LockSemaphore' : [ 0x10, ['pointer', ['void']]],
    'SpinCount' : [ 0x14, ['unsigned long']],
} ],
  '_KTRAP_FRAME' : [ 0x8c, {
    'DbgEbp' : [ 0x0, ['unsigned long']],
    'DbgEip' : [ 0x4, ['unsigned long']],
    'DbgArgMark' : [ 0x8, ['unsigned long']],
    'DbgArgPointer' : [ 0xc, ['unsigned long']],
    'TempSegCs' : [ 0x10, ['unsigned short']],
    'Logging' : [ 0x12, ['unsigned char']],
    'Reserved' : [ 0x13, ['unsigned char']],
    'TempEsp' : [ 0x14, ['unsigned long']],
    'Dr0' : [ 0x18, ['unsigned long']],
    'Dr1' : [ 0x1c, ['unsigned long']],
    'Dr2' : [ 0x20, ['unsigned long']],
    'Dr3' : [ 0x24, ['unsigned long']],
    'Dr6' : [ 0x28, ['unsigned long']],
    'Dr7' : [ 0x2c, ['unsigned long']],
    'SegGs' : [ 0x30, ['unsigned long']],
    'SegEs' : [ 0x34, ['unsigned long']],
    'SegDs' : [ 0x38, ['unsigned long']],
    'Edx' : [ 0x3c, ['unsigned long']],
    'Ecx' : [ 0x40, ['unsigned long']],
    'Eax' : [ 0x44, ['unsigned long']],
    'PreviousPreviousMode' : [ 0x48, ['unsigned long']],
    'ExceptionList' : [ 0x4c, ['pointer', ['_EXCEPTION_REGISTRATION_RECORD']]],
    'SegFs' : [ 0x50, ['unsigned long']],
    'Edi' : [ 0x54, ['unsigned long']],
    'Esi' : [ 0x58, ['unsigned long']],
    'Ebx' : [ 0x5c, ['unsigned long']],
    'Ebp' : [ 0x60, ['unsigned long']],
    'ErrCode' : [ 0x64, ['unsigned long']],
    'Eip' : [ 0x68, ['unsigned long']],
    'SegCs' : [ 0x6c, ['unsigned long']],
    'EFlags' : [ 0x70, ['unsigned long']],
    'HardwareEsp' : [ 0x74, ['unsigned long']],
    'HardwareSegSs' : [ 0x78, ['unsigned long']],
    'V86Es' : [ 0x7c, ['unsigned long']],
    'V86Ds' : [ 0x80, ['unsigned long']],
    'V86Fs' : [ 0x84, ['unsigned long']],
    'V86Gs' : [ 0x88, ['unsigned long']],
} ],
  '__unnamed_1d74' : [ 0x4, {
    'AsULONG' : [ 0x0, ['unsigned long']],
    'UsingHypervisor' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'NoDomainAccounting' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'IncreasePolicy' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 4, native_type='unsigned long')]],
    'DecreasePolicy' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 6, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 32, native_type='unsigned long')]],
} ],
  '_PPM_PERF_STATES' : [ 0x78, {
    'Count' : [ 0x0, ['unsigned long']],
    'MaxFrequency' : [ 0x4, ['unsigned long']],
    'PStateCap' : [ 0x8, ['unsigned long']],
    'TStateCap' : [ 0xc, ['unsigned long']],
    'MaxPerfState' : [ 0x10, ['unsigned long']],
    'MinPerfState' : [ 0x14, ['unsigned long']],
    'LowestPState' : [ 0x18, ['unsigned long']],
    'IncreaseTime' : [ 0x1c, ['unsigned long']],
    'DecreaseTime' : [ 0x20, ['unsigned long']],
    'BusyAdjThreshold' : [ 0x24, ['unsigned char']],
    'Reserved' : [ 0x25, ['unsigned char']],
    'ThrottleStatesOnly' : [ 0x26, ['unsigned char']],
    'PolicyType' : [ 0x27, ['unsigned char']],
    'TimerInterval' : [ 0x28, ['unsigned long']],
    'Flags' : [ 0x2c, ['__unnamed_1d74']],
    'TargetProcessors' : [ 0x30, ['unsigned long']],
    'PStateHandler' : [ 0x34, ['pointer', ['void']]],
    'PStateContext' : [ 0x38, ['unsigned long']],
    'TStateHandler' : [ 0x3c, ['pointer', ['void']]],
    'TStateContext' : [ 0x40, ['unsigned long']],
    'FeedbackHandler' : [ 0x44, ['pointer', ['void']]],
    'DiaStats' : [ 0x48, ['pointer', ['_PPM_DIA_STATS']]],
    'DiaStatsCount' : [ 0x4c, ['unsigned long']],
    'State' : [ 0x50, ['array', 1, ['_PPM_PERF_STATE']]],
} ],
  '_WAIT_CONTEXT_BLOCK' : [ 0x28, {
    'WaitQueueEntry' : [ 0x0, ['_KDEVICE_QUEUE_ENTRY']],
    'DeviceRoutine' : [ 0x10, ['pointer', ['void']]],
    'DeviceContext' : [ 0x14, ['pointer', ['void']]],
    'NumberOfMapRegisters' : [ 0x18, ['unsigned long']],
    'DeviceObject' : [ 0x1c, ['pointer', ['void']]],
    'CurrentIrp' : [ 0x20, ['pointer', ['void']]],
    'BufferChainingDpc' : [ 0x24, ['pointer', ['_KDPC']]],
} ],
  '_SECTION_OBJECT' : [ 0x18, {
    'StartingVa' : [ 0x0, ['pointer', ['void']]],
    'EndingVa' : [ 0x4, ['pointer', ['void']]],
    'Parent' : [ 0x8, ['pointer', ['void']]],
    'LeftChild' : [ 0xc, ['pointer', ['void']]],
    'RightChild' : [ 0x10, ['pointer', ['void']]],
    'Segment' : [ 0x14, ['pointer', ['_SEGMENT_OBJECT']]],
} ],
  '_CM_NAME_CONTROL_BLOCK' : [ 0x10, {
    'Compressed' : [ 0x0, ['unsigned char']],
    'RefCount' : [ 0x2, ['unsigned short']],
    'NameHash' : [ 0x4, ['_CM_NAME_HASH']],
    'ConvKey' : [ 0x4, ['unsigned long']],
    'NextHash' : [ 0x8, ['pointer', ['_CM_KEY_HASH']]],
    'NameLength' : [ 0xc, ['unsigned short']],
    'Name' : [ 0xe, ['array', 1, ['wchar']]],
} ],
  '_PPM_PERF_STATE' : [ 0x28, {
    'Frequency' : [ 0x0, ['unsigned long']],
    'Power' : [ 0x4, ['unsigned long']],
    'PercentFrequency' : [ 0x8, ['unsigned char']],
    'IncreaseLevel' : [ 0x9, ['unsigned char']],
    'DecreaseLevel' : [ 0xa, ['unsigned char']],
    'Type' : [ 0xb, ['unsigned char']],
    'Control' : [ 0x10, ['unsigned long long']],
    'Status' : [ 0x18, ['unsigned long long']],
    'TotalHitCount' : [ 0x20, ['unsigned long']],
    'DesiredCount' : [ 0x24, ['unsigned long']],
} ],
  '_u' : [ 0x50, {
    'KeyNode' : [ 0x0, ['_CM_KEY_NODE']],
    'KeyValue' : [ 0x0, ['_CM_KEY_VALUE']],
    'KeySecurity' : [ 0x0, ['_CM_KEY_SECURITY']],
    'KeyIndex' : [ 0x0, ['_CM_KEY_INDEX']],
    'ValueData' : [ 0x0, ['_CM_BIG_DATA']],
    'KeyList' : [ 0x0, ['array', 1, ['unsigned long']]],
    'KeyString' : [ 0x0, ['array', 1, ['wchar']]],
} ],
  '_GENERAL_LOOKASIDE_POOL' : [ 0x48, {
    'ListHead' : [ 0x0, ['_SLIST_HEADER']],
    'SingleListHead' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Depth' : [ 0x8, ['unsigned short']],
    'MaximumDepth' : [ 0xa, ['unsigned short']],
    'TotalAllocates' : [ 0xc, ['unsigned long']],
    'AllocateMisses' : [ 0x10, ['unsigned long']],
    'AllocateHits' : [ 0x10, ['unsigned long']],
    'TotalFrees' : [ 0x14, ['unsigned long']],
    'FreeMisses' : [ 0x18, ['unsigned long']],
    'FreeHits' : [ 0x18, ['unsigned long']],
    'Type' : [ 0x1c, ['Enumeration', dict(target = 'long', choices = {0: 'NonPagedPool', 1: 'PagedPool', 2: 'NonPagedPoolMustSucceed', 3: 'DontUseThisType', 4: 'NonPagedPoolCacheAligned', 5: 'PagedPoolCacheAligned', 6: 'NonPagedPoolCacheAlignedMustS', 7: 'MaxPoolType', 34: 'NonPagedPoolMustSucceedSession', 35: 'DontUseThisTypeSession', 32: 'NonPagedPoolSession', 36: 'NonPagedPoolCacheAlignedSession', 33: 'PagedPoolSession', 38: 'NonPagedPoolCacheAlignedMustSSession', 37: 'PagedPoolCacheAlignedSession'})]],
    'Tag' : [ 0x20, ['unsigned long']],
    'Size' : [ 0x24, ['unsigned long']],
    'AllocateEx' : [ 0x28, ['pointer', ['void']]],
    'Allocate' : [ 0x28, ['pointer', ['void']]],
    'FreeEx' : [ 0x2c, ['pointer', ['void']]],
    'Free' : [ 0x2c, ['pointer', ['void']]],
    'ListEntry' : [ 0x30, ['_LIST_ENTRY']],
    'LastTotalAllocates' : [ 0x38, ['unsigned long']],
    'LastAllocateMisses' : [ 0x3c, ['unsigned long']],
    'LastAllocateHits' : [ 0x3c, ['unsigned long']],
    'Future' : [ 0x40, ['array', 2, ['unsigned long']]],
} ],
  '_WHEA_NMI_ERROR_FLAGS' : [ 0x4, {
    'HypervisorError' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 32, native_type='unsigned long')]],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_HEAP_LOOKASIDE' : [ 0x30, {
    'ListHead' : [ 0x0, ['_SLIST_HEADER']],
    'Depth' : [ 0x8, ['unsigned short']],
    'MaximumDepth' : [ 0xa, ['unsigned short']],
    'TotalAllocates' : [ 0xc, ['unsigned long']],
    'AllocateMisses' : [ 0x10, ['unsigned long']],
    'TotalFrees' : [ 0x14, ['unsigned long']],
    'FreeMisses' : [ 0x18, ['unsigned long']],
    'LastTotalAllocates' : [ 0x1c, ['unsigned long']],
    'LastAllocateMisses' : [ 0x20, ['unsigned long']],
    'Counters' : [ 0x24, ['array', 2, ['unsigned long']]],
} ],
  '_WMI_TRACE_PACKET' : [ 0x4, {
    'Size' : [ 0x0, ['unsigned short']],
    'HookId' : [ 0x2, ['unsigned short']],
    'Type' : [ 0x2, ['unsigned char']],
    'Group' : [ 0x3, ['unsigned char']],
} ],
  '_RTL_ATOM_TABLE' : [ 0x44, {
    'Signature' : [ 0x0, ['unsigned long']],
    'CriticalSection' : [ 0x4, ['_RTL_CRITICAL_SECTION']],
    'RtlHandleTable' : [ 0x1c, ['_RTL_HANDLE_TABLE']],
    'NumberOfBuckets' : [ 0x3c, ['unsigned long']],
    'Buckets' : [ 0x40, ['array', 1, ['pointer', ['_RTL_ATOM_TABLE_ENTRY']]]],
} ],
  '_POP_POWER_ACTION' : [ 0xa0, {
    'Updates' : [ 0x0, ['unsigned char']],
    'State' : [ 0x1, ['unsigned char']],
    'Shutdown' : [ 0x2, ['unsigned char']],
    'Action' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'PowerActionNone', 1: 'PowerActionReserved', 2: 'PowerActionSleep', 3: 'PowerActionHibernate', 4: 'PowerActionShutdown', 5: 'PowerActionShutdownReset', 6: 'PowerActionShutdownOff', 7: 'PowerActionWarmEject'})]],
    'LightestState' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'Flags' : [ 0xc, ['unsigned long']],
    'Status' : [ 0x10, ['long']],
    'DeviceType' : [ 0x14, ['Enumeration', dict(target = 'long', choices = {0: 'PolicyDeviceSystemButton', 1: 'PolicyDeviceThermalZone', 2: 'PolicyDeviceBattery', 3: 'PolicyDeviceMemory', 4: 'PolicyInitiatePowerActionAPI', 5: 'PolicySetPowerStateAPI', 6: 'PolicyImmediateDozeS4', 7: 'PolicySystemIdle', 8: 'PolicyDeviceMax'})]],
    'DeviceTypeFlags' : [ 0x18, ['unsigned long']],
    'IrpMinor' : [ 0x1c, ['unsigned char']],
    'Waking' : [ 0x1d, ['unsigned char']],
    'SystemState' : [ 0x20, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'NextSystemState' : [ 0x24, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'EffectiveSystemState' : [ 0x28, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'CurrentSystemState' : [ 0x2c, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'ShutdownBugCode' : [ 0x30, ['pointer', ['_POP_SHUTDOWN_BUG_CHECK']]],
    'DevState' : [ 0x34, ['pointer', ['_POP_DEVICE_SYS_STATE']]],
    'DisplayResumeContext' : [ 0x38, ['pointer', ['_POP_DISPLAY_RESUME_CONTEXT']]],
    'HiberContext' : [ 0x3c, ['pointer', ['_POP_HIBER_CONTEXT']]],
    'WakeTime' : [ 0x40, ['unsigned long long']],
    'SleepTime' : [ 0x48, ['unsigned long long']],
    'FilteredCapabilities' : [ 0x50, ['SYSTEM_POWER_CAPABILITIES']],
} ],
  '_CM_KEY_VALUE' : [ 0x18, {
    'Signature' : [ 0x0, ['unsigned short']],
    'NameLength' : [ 0x2, ['unsigned short']],
    'DataLength' : [ 0x4, ['unsigned long']],
    'Data' : [ 0x8, ['unsigned long']],
    'Type' : [ 0xc, ['unsigned long']],
    'Flags' : [ 0x10, ['unsigned short']],
    'Spare' : [ 0x12, ['unsigned short']],
    'Name' : [ 0x14, ['array', 1, ['wchar']]],
} ],
  '_CM_KEY_HASH' : [ 0x10, {
    'ConvKey' : [ 0x0, ['unsigned long']],
    'NextHash' : [ 0x4, ['pointer', ['_CM_KEY_HASH']]],
    'KeyHive' : [ 0x8, ['pointer', ['_HHIVE']]],
    'KeyCell' : [ 0xc, ['unsigned long']],
} ],
  '_PO_DEVICE_NOTIFY' : [ 0x24, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'TargetDevice' : [ 0x8, ['pointer', ['_DEVICE_OBJECT']]],
    'OrderLevel' : [ 0xc, ['unsigned char']],
    'DeviceObject' : [ 0x10, ['pointer', ['_DEVICE_OBJECT']]],
    'DeviceName' : [ 0x14, ['pointer', ['unsigned short']]],
    'DriverName' : [ 0x18, ['pointer', ['unsigned short']]],
    'ChildCount' : [ 0x1c, ['unsigned long']],
    'ActiveChild' : [ 0x20, ['unsigned long']],
} ],
  '_CM_KEY_SECURITY_CACHE_ENTRY' : [ 0x8, {
    'Cell' : [ 0x0, ['unsigned long']],
    'CachedSecurity' : [ 0x4, ['pointer', ['_CM_KEY_SECURITY_CACHE']]],
} ],
  '_FS_FILTER_CALLBACK_DATA' : [ 0x24, {
    'SizeOfFsFilterCallbackData' : [ 0x0, ['unsigned long']],
    'Operation' : [ 0x4, ['unsigned char']],
    'Reserved' : [ 0x5, ['unsigned char']],
    'DeviceObject' : [ 0x8, ['pointer', ['_DEVICE_OBJECT']]],
    'FileObject' : [ 0xc, ['pointer', ['_FILE_OBJECT']]],
    'Parameters' : [ 0x10, ['_FS_FILTER_PARAMETERS']],
} ],
  '_IMAGE_SECURITY_CONTEXT' : [ 0x4, {
    'PageHashes' : [ 0x0, ['pointer', ['void']]],
    'Value' : [ 0x0, ['unsigned long']],
    'SecurityBeingCreated' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'SecurityMandatory' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Unused' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'PageHashPointer' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_1dc7' : [ 0x4, {
    'Level' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_1dc9' : [ 0x4, {
    'Type' : [ 0x0, ['unsigned long']],
} ],
  '_POP_ACTION_TRIGGER' : [ 0x10, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'PolicyDeviceSystemButton', 1: 'PolicyDeviceThermalZone', 2: 'PolicyDeviceBattery', 3: 'PolicyDeviceMemory', 4: 'PolicyInitiatePowerActionAPI', 5: 'PolicySetPowerStateAPI', 6: 'PolicyImmediateDozeS4', 7: 'PolicySystemIdle', 8: 'PolicyDeviceMax'})]],
    'Flags' : [ 0x4, ['unsigned long']],
    'Wait' : [ 0x8, ['pointer', ['_POP_TRIGGER_WAIT']]],
    'Battery' : [ 0xc, ['__unnamed_1dc7']],
    'Button' : [ 0xc, ['__unnamed_1dc9']],
} ],
  '_KENLISTMENT_HISTORY' : [ 0x8, {
    'Notification' : [ 0x0, ['unsigned long']],
    'NewState' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'KEnlistmentUninitialized', 256: 'KEnlistmentActive', 258: 'KEnlistmentPrepared', 259: 'KEnlistmentInDoubt', 260: 'KEnlistmentCommitted', 261: 'KEnlistmentCommittedNotify', 262: 'KEnlistmentCommitRequested', 257: 'KEnlistmentPreparing', 264: 'KEnlistmentDelegated', 265: 'KEnlistmentDelegatedDisconnected', 266: 'KEnlistmentPrePreparing', 263: 'KEnlistmentAborted', 268: 'KEnlistmentRecovering', 269: 'KEnlistmentAborting', 270: 'KEnlistmentReadOnly', 271: 'KEnlistmentOutcomeUnavailable', 272: 'KEnlistmentOffline', 273: 'KEnlistmentPrePrepared', 274: 'KEnlistmentInitialized', 267: 'KEnlistmentForgotten'})]],
} ],
  '_FAST_IO_DISPATCH' : [ 0x70, {
    'SizeOfFastIoDispatch' : [ 0x0, ['unsigned long']],
    'FastIoCheckIfPossible' : [ 0x4, ['pointer', ['void']]],
    'FastIoRead' : [ 0x8, ['pointer', ['void']]],
    'FastIoWrite' : [ 0xc, ['pointer', ['void']]],
    'FastIoQueryBasicInfo' : [ 0x10, ['pointer', ['void']]],
    'FastIoQueryStandardInfo' : [ 0x14, ['pointer', ['void']]],
    'FastIoLock' : [ 0x18, ['pointer', ['void']]],
    'FastIoUnlockSingle' : [ 0x1c, ['pointer', ['void']]],
    'FastIoUnlockAll' : [ 0x20, ['pointer', ['void']]],
    'FastIoUnlockAllByKey' : [ 0x24, ['pointer', ['void']]],
    'FastIoDeviceControl' : [ 0x28, ['pointer', ['void']]],
    'AcquireFileForNtCreateSection' : [ 0x2c, ['pointer', ['void']]],
    'ReleaseFileForNtCreateSection' : [ 0x30, ['pointer', ['void']]],
    'FastIoDetachDevice' : [ 0x34, ['pointer', ['void']]],
    'FastIoQueryNetworkOpenInfo' : [ 0x38, ['pointer', ['void']]],
    'AcquireForModWrite' : [ 0x3c, ['pointer', ['void']]],
    'MdlRead' : [ 0x40, ['pointer', ['void']]],
    'MdlReadComplete' : [ 0x44, ['pointer', ['void']]],
    'PrepareMdlWrite' : [ 0x48, ['pointer', ['void']]],
    'MdlWriteComplete' : [ 0x4c, ['pointer', ['void']]],
    'FastIoReadCompressed' : [ 0x50, ['pointer', ['void']]],
    'FastIoWriteCompressed' : [ 0x54, ['pointer', ['void']]],
    'MdlReadCompleteCompressed' : [ 0x58, ['pointer', ['void']]],
    'MdlWriteCompleteCompressed' : [ 0x5c, ['pointer', ['void']]],
    'FastIoQueryOpen' : [ 0x60, ['pointer', ['void']]],
    'ReleaseForModWrite' : [ 0x64, ['pointer', ['void']]],
    'AcquireForCcFlush' : [ 0x68, ['pointer', ['void']]],
    'ReleaseForCcFlush' : [ 0x6c, ['pointer', ['void']]],
} ],
  '_DBGKD_BREAKPOINTEX' : [ 0x8, {
    'BreakPointCount' : [ 0x0, ['unsigned long']],
    'ContinueStatus' : [ 0x4, ['long']],
} ],
  '_CM_CELL_REMAP_BLOCK' : [ 0x8, {
    'OldCell' : [ 0x0, ['unsigned long']],
    'NewCell' : [ 0x4, ['unsigned long']],
} ],
  '_OBJECT_DIRECTORY_ENTRY' : [ 0xc, {
    'ChainLink' : [ 0x0, ['pointer', ['_OBJECT_DIRECTORY_ENTRY']]],
    'Object' : [ 0x4, ['pointer', ['void']]],
    'HashValue' : [ 0x8, ['unsigned long']],
} ],
  '_LOADER_PARAMETER_EXTENSION' : [ 0x84, {
    'Size' : [ 0x0, ['unsigned long']],
    'Profile' : [ 0x4, ['_PROFILE_PARAMETER_BLOCK']],
    'MajorVersion' : [ 0x14, ['unsigned long']],
    'MinorVersion' : [ 0x18, ['unsigned long']],
    'EmInfFileImage' : [ 0x1c, ['pointer', ['void']]],
    'EmInfFileSize' : [ 0x20, ['unsigned long']],
    'TriageDumpBlock' : [ 0x24, ['pointer', ['void']]],
    'LoaderPagesSpanned' : [ 0x28, ['unsigned long']],
    'HeadlessLoaderBlock' : [ 0x2c, ['pointer', ['_HEADLESS_LOADER_BLOCK']]],
    'SMBiosEPSHeader' : [ 0x30, ['pointer', ['_SMBIOS_TABLE_HEADER']]],
    'DrvDBImage' : [ 0x34, ['pointer', ['void']]],
    'DrvDBSize' : [ 0x38, ['unsigned long']],
    'NetworkLoaderBlock' : [ 0x3c, ['pointer', ['_NETWORK_LOADER_BLOCK']]],
    'HalpIRQLToTPR' : [ 0x40, ['pointer', ['unsigned char']]],
    'HalpVectorToIRQL' : [ 0x44, ['pointer', ['unsigned char']]],
    'FirmwareDescriptorListHead' : [ 0x48, ['_LIST_ENTRY']],
    'AcpiTable' : [ 0x50, ['pointer', ['void']]],
    'AcpiTableSize' : [ 0x54, ['unsigned long']],
    'BootViaWinload' : [ 0x58, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Reserved' : [ 0x58, ['BitField', dict(start_bit = 1, end_bit = 32, native_type='unsigned long')]],
    'LoaderPerformanceData' : [ 0x5c, ['pointer', ['_LOADER_PERFORMANCE_DATA']]],
    'BootApplicationPersistentData' : [ 0x60, ['_LIST_ENTRY']],
    'WmdTestResult' : [ 0x68, ['pointer', ['void']]],
    'BootIdentifier' : [ 0x6c, ['_GUID']],
    'ResumePages' : [ 0x7c, ['unsigned long']],
    'DumpHeader' : [ 0x80, ['pointer', ['void']]],
} ],
  '_PI_RESOURCE_ARBITER_ENTRY' : [ 0x38, {
    'DeviceArbiterList' : [ 0x0, ['_LIST_ENTRY']],
    'ResourceType' : [ 0x8, ['unsigned char']],
    'ArbiterInterface' : [ 0xc, ['pointer', ['_ARBITER_INTERFACE']]],
    'DeviceNode' : [ 0x10, ['pointer', ['_DEVICE_NODE']]],
    'ResourceList' : [ 0x14, ['_LIST_ENTRY']],
    'BestResourceList' : [ 0x1c, ['_LIST_ENTRY']],
    'BestConfig' : [ 0x24, ['_LIST_ENTRY']],
    'ActiveArbiterList' : [ 0x2c, ['_LIST_ENTRY']],
    'State' : [ 0x34, ['unsigned char']],
    'ResourcesChanged' : [ 0x35, ['unsigned char']],
} ],
  '_DBGKD_CONTINUE' : [ 0x4, {
    'ContinueStatus' : [ 0x0, ['long']],
} ],
  '_WHEA_PCIEXPRESS_VERSION' : [ 0x4, {
    'MinorVersion' : [ 0x0, ['unsigned char']],
    'MajorVersion' : [ 0x1, ['unsigned char']],
    'Reserved' : [ 0x2, ['unsigned short']],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_SECURITY_DESCRIPTOR' : [ 0x14, {
    'Revision' : [ 0x0, ['unsigned char']],
    'Sbz1' : [ 0x1, ['unsigned char']],
    'Control' : [ 0x2, ['unsigned short']],
    'Owner' : [ 0x4, ['pointer', ['void']]],
    'Group' : [ 0x8, ['pointer', ['void']]],
    'Sacl' : [ 0xc, ['pointer', ['_ACL']]],
    'Dacl' : [ 0x10, ['pointer', ['_ACL']]],
} ],
  '__unnamed_1e33' : [ 0x4, {
    'Balance' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='long')]],
    'Parent' : [ 0x0, ['pointer', ['_MMADDRESS_NODE']]],
} ],
  '_MMADDRESS_NODE' : [ 0x14, {
    'u1' : [ 0x0, ['__unnamed_1e33']],
    'LeftChild' : [ 0x4, ['pointer', ['_MMADDRESS_NODE']]],
    'RightChild' : [ 0x8, ['pointer', ['_MMADDRESS_NODE']]],
    'StartingVpn' : [ 0xc, ['unsigned long']],
    'EndingVpn' : [ 0x10, ['unsigned long']],
} ],
  '_RTL_USER_PROCESS_PARAMETERS' : [ 0x294, {
    'MaximumLength' : [ 0x0, ['unsigned long']],
    'Length' : [ 0x4, ['unsigned long']],
    'Flags' : [ 0x8, ['unsigned long']],
    'DebugFlags' : [ 0xc, ['unsigned long']],
    'ConsoleHandle' : [ 0x10, ['pointer', ['void']]],
    'ConsoleFlags' : [ 0x14, ['unsigned long']],
    'StandardInput' : [ 0x18, ['pointer', ['void']]],
    'StandardOutput' : [ 0x1c, ['pointer', ['void']]],
    'StandardError' : [ 0x20, ['pointer', ['void']]],
    'CurrentDirectory' : [ 0x24, ['_CURDIR']],
    'DllPath' : [ 0x30, ['_UNICODE_STRING']],
    'ImagePathName' : [ 0x38, ['_UNICODE_STRING']],
    'CommandLine' : [ 0x40, ['_UNICODE_STRING']],
    'Environment' : [ 0x48, ['pointer', ['void']]],
    'StartingX' : [ 0x4c, ['unsigned long']],
    'StartingY' : [ 0x50, ['unsigned long']],
    'CountX' : [ 0x54, ['unsigned long']],
    'CountY' : [ 0x58, ['unsigned long']],
    'CountCharsX' : [ 0x5c, ['unsigned long']],
    'CountCharsY' : [ 0x60, ['unsigned long']],
    'FillAttribute' : [ 0x64, ['unsigned long']],
    'WindowFlags' : [ 0x68, ['unsigned long']],
    'ShowWindowFlags' : [ 0x6c, ['unsigned long']],
    'WindowTitle' : [ 0x70, ['_UNICODE_STRING']],
    'DesktopInfo' : [ 0x78, ['_UNICODE_STRING']],
    'ShellInfo' : [ 0x80, ['_UNICODE_STRING']],
    'RuntimeData' : [ 0x88, ['_UNICODE_STRING']],
    'CurrentDirectores' : [ 0x90, ['array', 32, ['_RTL_DRIVE_LETTER_CURDIR']]],
    'EnvironmentSize' : [ 0x290, ['unsigned long']],
} ],
  '_PHYSICAL_MEMORY_RUN' : [ 0x8, {
    'BasePage' : [ 0x0, ['unsigned long']],
    'PageCount' : [ 0x4, ['unsigned long']],
} ],
  '_MI_VERIFIER_DRIVER_ENTRY' : [ 0x58, {
    'Links' : [ 0x0, ['_LIST_ENTRY']],
    'Loads' : [ 0x8, ['unsigned long']],
    'Unloads' : [ 0xc, ['unsigned long']],
    'BaseName' : [ 0x10, ['_UNICODE_STRING']],
    'StartAddress' : [ 0x18, ['pointer', ['void']]],
    'EndAddress' : [ 0x1c, ['pointer', ['void']]],
    'Flags' : [ 0x20, ['unsigned long']],
    'Signature' : [ 0x24, ['unsigned long']],
    'PoolPageHeaders' : [ 0x28, ['_SLIST_HEADER']],
    'PoolTrackers' : [ 0x30, ['_SLIST_HEADER']],
    'CurrentPagedPoolAllocations' : [ 0x38, ['unsigned long']],
    'CurrentNonPagedPoolAllocations' : [ 0x3c, ['unsigned long']],
    'PeakPagedPoolAllocations' : [ 0x40, ['unsigned long']],
    'PeakNonPagedPoolAllocations' : [ 0x44, ['unsigned long']],
    'PagedBytes' : [ 0x48, ['unsigned long']],
    'NonPagedBytes' : [ 0x4c, ['unsigned long']],
    'PeakPagedBytes' : [ 0x50, ['unsigned long']],
    'PeakNonPagedBytes' : [ 0x54, ['unsigned long']],
} ],
  '_RTL_SRWLOCK' : [ 0x4, {
    'Locked' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Waiting' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Waking' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'MultipleShared' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'Shared' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 32, native_type='unsigned long')]],
    'Value' : [ 0x0, ['unsigned long']],
    'Ptr' : [ 0x0, ['pointer', ['void']]],
} ],
  '_ALPC_MESSAGE_ZONE' : [ 0x18, {
    'Mdl' : [ 0x0, ['pointer', ['_MDL']]],
    'UserVa' : [ 0x4, ['pointer', ['void']]],
    'UserLimit' : [ 0x8, ['pointer', ['void']]],
    'SystemVa' : [ 0xc, ['pointer', ['void']]],
    'SystemLimit' : [ 0x10, ['pointer', ['void']]],
    'Size' : [ 0x14, ['unsigned long']],
} ],
  '_KTMOBJECT_NAMESPACE_LINK' : [ 0x14, {
    'Links' : [ 0x0, ['_RTL_BALANCED_LINKS']],
    'Expired' : [ 0x10, ['unsigned char']],
} ],
  '_CACHE_MANAGER_CALLBACKS' : [ 0x10, {
    'AcquireForLazyWrite' : [ 0x0, ['pointer', ['void']]],
    'ReleaseFromLazyWrite' : [ 0x4, ['pointer', ['void']]],
    'AcquireForReadAhead' : [ 0x8, ['pointer', ['void']]],
    'ReleaseFromReadAhead' : [ 0xc, ['pointer', ['void']]],
} ],
  '_FILE_BASIC_INFORMATION' : [ 0x28, {
    'CreationTime' : [ 0x0, ['_LARGE_INTEGER']],
    'LastAccessTime' : [ 0x8, ['_LARGE_INTEGER']],
    'LastWriteTime' : [ 0x10, ['_LARGE_INTEGER']],
    'ChangeTime' : [ 0x18, ['_LARGE_INTEGER']],
    'FileAttributes' : [ 0x20, ['unsigned long']],
} ],
  '_RTL_RANGE' : [ 0x20, {
    'Start' : [ 0x0, ['unsigned long long']],
    'End' : [ 0x8, ['unsigned long long']],
    'UserData' : [ 0x10, ['pointer', ['void']]],
    'Owner' : [ 0x14, ['pointer', ['void']]],
    'Attributes' : [ 0x18, ['unsigned char']],
    'Flags' : [ 0x19, ['unsigned char']],
} ],
  '_SYSTEM_POWER_POLICY' : [ 0xe8, {
    'Revision' : [ 0x0, ['unsigned long']],
    'PowerButton' : [ 0x4, ['POWER_ACTION_POLICY']],
    'SleepButton' : [ 0x10, ['POWER_ACTION_POLICY']],
    'LidClose' : [ 0x1c, ['POWER_ACTION_POLICY']],
    'LidOpenWake' : [ 0x28, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'Reserved' : [ 0x2c, ['unsigned long']],
    'Idle' : [ 0x30, ['POWER_ACTION_POLICY']],
    'IdleTimeout' : [ 0x3c, ['unsigned long']],
    'IdleSensitivity' : [ 0x40, ['unsigned char']],
    'DynamicThrottle' : [ 0x41, ['unsigned char']],
    'Spare2' : [ 0x42, ['array', 2, ['unsigned char']]],
    'MinSleep' : [ 0x44, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'MaxSleep' : [ 0x48, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'ReducedLatencySleep' : [ 0x4c, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'WinLogonFlags' : [ 0x50, ['unsigned long']],
    'Spare3' : [ 0x54, ['unsigned long']],
    'DozeS4Timeout' : [ 0x58, ['unsigned long']],
    'BroadcastCapacityResolution' : [ 0x5c, ['unsigned long']],
    'DischargePolicy' : [ 0x60, ['array', 4, ['SYSTEM_POWER_LEVEL']]],
    'VideoTimeout' : [ 0xc0, ['unsigned long']],
    'VideoDimDisplay' : [ 0xc4, ['unsigned char']],
    'VideoReserved' : [ 0xc8, ['array', 3, ['unsigned long']]],
    'SpindownTimeout' : [ 0xd4, ['unsigned long']],
    'OptimizeForPower' : [ 0xd8, ['unsigned char']],
    'FanThrottleTolerance' : [ 0xd9, ['unsigned char']],
    'ForcedThrottle' : [ 0xda, ['unsigned char']],
    'MinThrottle' : [ 0xdb, ['unsigned char']],
    'OverThrottled' : [ 0xdc, ['POWER_ACTION_POLICY']],
} ],
  '_POOL_HEADER' : [ 0x8, {
    'PreviousSize' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 9, native_type='unsigned short')]],
    'PoolIndex' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 16, native_type='unsigned short')]],
    'BlockSize' : [ 0x2, ['BitField', dict(start_bit = 0, end_bit = 9, native_type='unsigned short')]],
    'PoolType' : [ 0x2, ['BitField', dict(start_bit = 9, end_bit = 16, native_type='unsigned short')]],
    'Ulong1' : [ 0x0, ['unsigned long']],
    'PoolTag' : [ 0x4, ['unsigned long']],
    'AllocatorBackTraceIndex' : [ 0x4, ['unsigned short']],
    'PoolTagHash' : [ 0x6, ['unsigned short']],
} ],
  '_ETW_PROVIDER_TABLE_ENTRY' : [ 0x10, {
    'RefCount' : [ 0x0, ['long']],
    'State' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'EtwProviderStateFree', 1: 'EtwProviderStateTransition', 2: 'EtwProviderStateActive', 3: 'EtwProviderStateMax'})]],
    'RegEntry' : [ 0x8, ['pointer', ['_ETW_REG_ENTRY']]],
    'Caller' : [ 0xc, ['pointer', ['void']]],
} ],
  '_SE_AUDIT_PROCESS_CREATION_INFO' : [ 0x4, {
    'ImageFileName' : [ 0x0, ['pointer', ['_OBJECT_NAME_INFORMATION']]],
} ],
  '_HEAP_ENTRY_EXTRA' : [ 0x8, {
    'AllocatorBackTraceIndex' : [ 0x0, ['unsigned short']],
    'TagIndex' : [ 0x2, ['unsigned short']],
    'Settable' : [ 0x4, ['unsigned long']],
    'ZeroInit' : [ 0x0, ['unsigned long long']],
} ],
  '_VF_POOL_TRACE' : [ 0x40, {
    'Address' : [ 0x0, ['pointer', ['void']]],
    'Size' : [ 0x4, ['unsigned long']],
    'Thread' : [ 0x8, ['pointer', ['_ETHREAD']]],
    'StackTrace' : [ 0xc, ['array', 13, ['pointer', ['void']]]],
} ],
  '__unnamed_1e6b' : [ 0x4, {
    'LongFlags' : [ 0x0, ['unsigned long']],
    'Flags' : [ 0x0, ['_MM_SESSION_SPACE_FLAGS']],
} ],
  '_MM_SESSION_SPACE' : [ 0x1ec0, {
    'ReferenceCount' : [ 0x0, ['long']],
    'u' : [ 0x4, ['__unnamed_1e6b']],
    'SessionId' : [ 0x8, ['unsigned long']],
    'ProcessReferenceToSession' : [ 0xc, ['long']],
    'ProcessList' : [ 0x10, ['_LIST_ENTRY']],
    'LastProcessSwappedOutTime' : [ 0x18, ['_LARGE_INTEGER']],
    'SessionPageDirectoryIndex' : [ 0x20, ['unsigned long']],
    'NonPagablePages' : [ 0x24, ['unsigned long']],
    'CommittedPages' : [ 0x28, ['unsigned long']],
    'PagedPoolStart' : [ 0x2c, ['pointer', ['void']]],
    'PagedPoolEnd' : [ 0x30, ['pointer', ['void']]],
    'SessionObject' : [ 0x34, ['pointer', ['void']]],
    'SessionObjectHandle' : [ 0x38, ['pointer', ['void']]],
    'ResidentProcessCount' : [ 0x3c, ['long']],
    'ImageLoadingCount' : [ 0x40, ['long']],
    'SessionPoolAllocationFailures' : [ 0x44, ['array', 4, ['unsigned long']]],
    'ImageList' : [ 0x54, ['_LIST_ENTRY']],
    'LocaleId' : [ 0x5c, ['unsigned long']],
    'AttachCount' : [ 0x60, ['unsigned long']],
    'AttachGate' : [ 0x64, ['_KGATE']],
    'WsListEntry' : [ 0x74, ['_LIST_ENTRY']],
    'Lookaside' : [ 0x80, ['array', 25, ['_GENERAL_LOOKASIDE']]],
    'Session' : [ 0xd00, ['_MMSESSION']],
    'PagedPoolInfo' : [ 0xd38, ['_MM_PAGED_POOL_INFO']],
    'Vm' : [ 0xd70, ['_MMSUPPORT']],
    'Wsle' : [ 0xdb8, ['pointer', ['_MMWSLE']]],
    'DriverUnload' : [ 0xdbc, ['pointer', ['void']]],
    'PagedPool' : [ 0xdc0, ['_POOL_DESCRIPTOR']],
    'PageTables' : [ 0x1df4, ['pointer', ['_MMPTE']]],
    'SpecialPool' : [ 0x1df8, ['_MI_SPECIAL_POOL']],
    'SessionPteLock' : [ 0x1e10, ['_KGUARDED_MUTEX']],
    'PoolBigEntriesInUse' : [ 0x1e30, ['long']],
    'PagedPoolPdeCount' : [ 0x1e34, ['unsigned long']],
    'SpecialPoolPdeCount' : [ 0x1e38, ['unsigned long']],
    'DynamicSessionPdeCount' : [ 0x1e3c, ['unsigned long']],
    'SystemPteInfo' : [ 0x1e40, ['_MI_SYSTEM_PTE_TYPE']],
    'PoolTrackTableExpansion' : [ 0x1e6c, ['pointer', ['void']]],
    'PoolTrackTableExpansionSize' : [ 0x1e70, ['unsigned long']],
    'PoolTrackBigPages' : [ 0x1e74, ['pointer', ['void']]],
    'PoolTrackBigPagesSize' : [ 0x1e78, ['unsigned long']],
    'SessionPoolPdes' : [ 0x1e7c, ['_RTL_BITMAP']],
} ],
  '_WORK_QUEUE_ITEM' : [ 0x10, {
    'List' : [ 0x0, ['_LIST_ENTRY']],
    'WorkerRoutine' : [ 0x8, ['pointer', ['void']]],
    'Parameter' : [ 0xc, ['pointer', ['void']]],
} ],
  '_OBJECT_HANDLE_COUNT_ENTRY' : [ 0x8, {
    'Process' : [ 0x0, ['pointer', ['_EPROCESS']]],
    'HandleCount' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 24, native_type='unsigned long')]],
    'LockCount' : [ 0x4, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
} ],
  '_CLIENT_ID' : [ 0x8, {
    'UniqueProcess' : [ 0x0, ['pointer', ['void']]],
    'UniqueThread' : [ 0x4, ['pointer', ['void']]],
} ],
  '_VI_DEADLOCK_RESOURCE' : [ 0x80, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'VfDeadlockUnknown', 1: 'VfDeadlockMutex', 2: 'VfDeadlockMutexAbandoned', 3: 'VfDeadlockFastMutex', 4: 'VfDeadlockFastMutexUnsafe', 5: 'VfDeadlockSpinLock', 6: 'VfDeadlockTypeMaximum'})]],
    'NodeCount' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned long')]],
    'RecursionCount' : [ 0x4, ['BitField', dict(start_bit = 16, end_bit = 32, native_type='unsigned long')]],
    'ResourceAddress' : [ 0x8, ['pointer', ['void']]],
    'ThreadOwner' : [ 0xc, ['pointer', ['_VI_DEADLOCK_THREAD']]],
    'ResourceList' : [ 0x10, ['_LIST_ENTRY']],
    'HashChainList' : [ 0x18, ['_LIST_ENTRY']],
    'FreeListEntry' : [ 0x18, ['_LIST_ENTRY']],
    'StackTrace' : [ 0x20, ['array', 8, ['pointer', ['void']]]],
    'LastAcquireTrace' : [ 0x40, ['array', 8, ['pointer', ['void']]]],
    'LastReleaseTrace' : [ 0x60, ['array', 8, ['pointer', ['void']]]],
} ],
  '_DBGKD_GET_SET_BUS_DATA' : [ 0x14, {
    'BusDataType' : [ 0x0, ['unsigned long']],
    'BusNumber' : [ 0x4, ['unsigned long']],
    'SlotNumber' : [ 0x8, ['unsigned long']],
    'Offset' : [ 0xc, ['unsigned long']],
    'Length' : [ 0x10, ['unsigned long']],
} ],
  '_PRIVILEGE_SET' : [ 0x14, {
    'PrivilegeCount' : [ 0x0, ['unsigned long']],
    'Control' : [ 0x4, ['unsigned long']],
    'Privilege' : [ 0x8, ['array', 1, ['_LUID_AND_ATTRIBUTES']]],
} ],
  '_MMSECTION_FLAGS' : [ 0x4, {
    'BeingDeleted' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'BeingCreated' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'BeingPurged' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'NoModifiedWriting' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'FailAllIo' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'Image' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'Based' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'File' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'Networked' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'Rom' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'PhysicalMemory' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'CopyOnWrite' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'Reserve' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'Commit' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'Accessed' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'WasPurged' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'UserReference' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'GlobalMemory' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'DeleteOnClose' : [ 0x0, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'FilePointerNull' : [ 0x0, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'GlobalOnlyPerSession' : [ 0x0, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'SetMappedFileIoComplete' : [ 0x0, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'CollidedFlush' : [ 0x0, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long')]],
    'NoChange' : [ 0x0, ['BitField', dict(start_bit = 23, end_bit = 24, native_type='unsigned long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long')]],
    'UserWritable' : [ 0x0, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'PreferredNode' : [ 0x0, ['BitField', dict(start_bit = 26, end_bit = 32, native_type='unsigned long')]],
} ],
  '_SECURITY_CLIENT_CONTEXT' : [ 0x3c, {
    'SecurityQos' : [ 0x0, ['_SECURITY_QUALITY_OF_SERVICE']],
    'ClientToken' : [ 0xc, ['pointer', ['void']]],
    'DirectlyAccessClientToken' : [ 0x10, ['unsigned char']],
    'DirectAccessEffectiveOnly' : [ 0x11, ['unsigned char']],
    'ServerIsRemote' : [ 0x12, ['unsigned char']],
    'ClientTokenControl' : [ 0x14, ['_TOKEN_CONTROL']],
} ],
  '_MM_PAGED_POOL_INFO' : [ 0x38, {
    'Mutex' : [ 0x0, ['_KGUARDED_MUTEX']],
    'PagedPoolAllocationMap' : [ 0x20, ['_RTL_BITMAP']],
    'FirstPteForPagedPool' : [ 0x28, ['pointer', ['_MMPTE']]],
    'PagedPoolHint' : [ 0x2c, ['unsigned long']],
    'PagedPoolCommit' : [ 0x30, ['unsigned long']],
    'AllocatedPagedPool' : [ 0x34, ['unsigned long']],
} ],
  '_BITMAP_RANGE' : [ 0x20, {
    'Links' : [ 0x0, ['_LIST_ENTRY']],
    'BasePage' : [ 0x8, ['long long']],
    'FirstDirtyPage' : [ 0x10, ['unsigned long']],
    'LastDirtyPage' : [ 0x14, ['unsigned long']],
    'DirtyPages' : [ 0x18, ['unsigned long']],
    'Bitmap' : [ 0x1c, ['pointer', ['unsigned long']]],
} ],
  '_IO_SECURITY_CONTEXT' : [ 0x10, {
    'SecurityQos' : [ 0x0, ['pointer', ['_SECURITY_QUALITY_OF_SERVICE']]],
    'AccessState' : [ 0x4, ['pointer', ['_ACCESS_STATE']]],
    'DesiredAccess' : [ 0x8, ['unsigned long']],
    'FullCreateOptions' : [ 0xc, ['unsigned long']],
} ],
  '_WHEA_GENERIC_PROCESSOR_ERROR' : [ 0xc0, {
    'ValidBits' : [ 0x0, ['_WHEA_GENERIC_PROCESSOR_ERROR_VALIDBITS']],
    'ProcessorType' : [ 0x8, ['unsigned char']],
    'InstructionSet' : [ 0x9, ['unsigned char']],
    'ErrorType' : [ 0xa, ['unsigned char']],
    'Operation' : [ 0xb, ['unsigned char']],
    'Flags' : [ 0xc, ['unsigned char']],
    'Level' : [ 0xd, ['unsigned char']],
    'Reserved' : [ 0xe, ['unsigned short']],
    'CPUVersion' : [ 0x10, ['unsigned long long']],
    'CPUBrandString' : [ 0x18, ['array', 128, ['unsigned char']]],
    'ProcessorId' : [ 0x98, ['unsigned long long']],
    'TargetAddress' : [ 0xa0, ['unsigned long long']],
    'RequesterId' : [ 0xa8, ['unsigned long long']],
    'ResponderId' : [ 0xb0, ['unsigned long long']],
    'InstructionPointer' : [ 0xb8, ['unsigned long long']],
} ],
  '_HANDLE_TRACE_DB_ENTRY' : [ 0x50, {
    'ClientId' : [ 0x0, ['_CLIENT_ID']],
    'Handle' : [ 0x8, ['pointer', ['void']]],
    'Type' : [ 0xc, ['unsigned long']],
    'StackTrace' : [ 0x10, ['array', 16, ['pointer', ['void']]]],
} ],
  '_POP_TRIGGER_WAIT' : [ 0x20, {
    'Event' : [ 0x0, ['_KEVENT']],
    'Status' : [ 0x10, ['long']],
    'Link' : [ 0x14, ['_LIST_ENTRY']],
    'Trigger' : [ 0x1c, ['pointer', ['_POP_ACTION_TRIGGER']]],
} ],
  '_IO_TIMER' : [ 0x18, {
    'Type' : [ 0x0, ['short']],
    'TimerFlag' : [ 0x2, ['short']],
    'TimerList' : [ 0x4, ['_LIST_ENTRY']],
    'TimerRoutine' : [ 0xc, ['pointer', ['void']]],
    'Context' : [ 0x10, ['pointer', ['void']]],
    'DeviceObject' : [ 0x14, ['pointer', ['_DEVICE_OBJECT']]],
} ],
  '_FXSAVE_FORMAT' : [ 0x208, {
    'ControlWord' : [ 0x0, ['unsigned short']],
    'StatusWord' : [ 0x2, ['unsigned short']],
    'TagWord' : [ 0x4, ['unsigned short']],
    'ErrorOpcode' : [ 0x6, ['unsigned short']],
    'ErrorOffset' : [ 0x8, ['unsigned long']],
    'ErrorSelector' : [ 0xc, ['unsigned long']],
    'DataOffset' : [ 0x10, ['unsigned long']],
    'DataSelector' : [ 0x14, ['unsigned long']],
    'MXCsr' : [ 0x18, ['unsigned long']],
    'MXCsrMask' : [ 0x1c, ['unsigned long']],
    'RegisterArea' : [ 0x20, ['array', 128, ['unsigned char']]],
    'Reserved3' : [ 0xa0, ['array', 128, ['unsigned char']]],
    'Reserved4' : [ 0x120, ['array', 224, ['unsigned char']]],
    'Align16Byte' : [ 0x200, ['array', 8, ['unsigned char']]],
} ],
  '_ARBITER_TEST_ALLOCATION_PARAMETERS' : [ 0xc, {
    'ArbitrationList' : [ 0x0, ['pointer', ['_LIST_ENTRY']]],
    'AllocateFromCount' : [ 0x4, ['unsigned long']],
    'AllocateFrom' : [ 0x8, ['pointer', ['_CM_PARTIAL_RESOURCE_DESCRIPTOR']]],
} ],
  '_MI_SPECIAL_POOL' : [ 0x18, {
    'PteBase' : [ 0x0, ['pointer', ['_MMPTE']]],
    'FreePteHead' : [ 0x4, ['_MMPTE']],
    'FreePteTail' : [ 0x8, ['_MMPTE']],
    'PagesInUse' : [ 0xc, ['long']],
    'SpecialPoolPdes' : [ 0x10, ['_RTL_BITMAP']],
} ],
  '_ARBITER_QUERY_CONFLICT_PARAMETERS' : [ 0x10, {
    'PhysicalDeviceObject' : [ 0x0, ['pointer', ['_DEVICE_OBJECT']]],
    'ConflictingResource' : [ 0x4, ['pointer', ['_IO_RESOURCE_DESCRIPTOR']]],
    'ConflictCount' : [ 0x8, ['pointer', ['unsigned long']]],
    'Conflicts' : [ 0xc, ['pointer', ['pointer', ['_ARBITER_CONFLICT_INFO']]]],
} ],
  '_PHYSICAL_MEMORY_DESCRIPTOR' : [ 0x10, {
    'NumberOfRuns' : [ 0x0, ['unsigned long']],
    'NumberOfPages' : [ 0x4, ['unsigned long']],
    'Run' : [ 0x8, ['array', 1, ['_PHYSICAL_MEMORY_RUN']]],
} ],
  '_PNP_DEVICE_EVENT_LIST' : [ 0x4c, {
    'Status' : [ 0x0, ['long']],
    'EventQueueMutex' : [ 0x4, ['_KMUTANT']],
    'Lock' : [ 0x24, ['_KGUARDED_MUTEX']],
    'List' : [ 0x44, ['_LIST_ENTRY']],
} ],
  '_MAILSLOT_CREATE_PARAMETERS' : [ 0x18, {
    'MailslotQuota' : [ 0x0, ['unsigned long']],
    'MaximumMessageSize' : [ 0x4, ['unsigned long']],
    'ReadTimeout' : [ 0x8, ['_LARGE_INTEGER']],
    'TimeoutSpecified' : [ 0x10, ['unsigned char']],
} ],
  '_PO_IRP_MANAGER' : [ 0x10, {
    'DeviceIrpQueue' : [ 0x0, ['_PO_IRP_QUEUE']],
    'SystemIrpQueue' : [ 0x8, ['_PO_IRP_QUEUE']],
} ],
  '_WHEA_PCIEXPRESS_BRIDGE_CONTROL_STATUS' : [ 0x4, {
    'BridgeSecondaryStatus' : [ 0x0, ['unsigned short']],
    'BridgeControl' : [ 0x2, ['unsigned short']],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_KDPC_DATA' : [ 0x14, {
    'DpcListHead' : [ 0x0, ['_LIST_ENTRY']],
    'DpcLock' : [ 0x8, ['unsigned long']],
    'DpcQueueDepth' : [ 0xc, ['long']],
    'DpcCount' : [ 0x10, ['unsigned long']],
} ],
  '_NAMED_PIPE_CREATE_PARAMETERS' : [ 0x28, {
    'NamedPipeType' : [ 0x0, ['unsigned long']],
    'ReadMode' : [ 0x4, ['unsigned long']],
    'CompletionMode' : [ 0x8, ['unsigned long']],
    'MaximumInstances' : [ 0xc, ['unsigned long']],
    'InboundQuota' : [ 0x10, ['unsigned long']],
    'OutboundQuota' : [ 0x14, ['unsigned long']],
    'DefaultTimeout' : [ 0x18, ['_LARGE_INTEGER']],
    'TimeoutSpecified' : [ 0x20, ['unsigned char']],
} ],
  '_CM_BIG_DATA' : [ 0x8, {
    'Signature' : [ 0x0, ['unsigned short']],
    'Count' : [ 0x2, ['unsigned short']],
    'List' : [ 0x4, ['unsigned long']],
} ],
  '_CM_WORKITEM' : [ 0x10, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'WorkerRoutine' : [ 0x8, ['pointer', ['void']]],
    'Parameter' : [ 0xc, ['pointer', ['void']]],
} ],
  '__unnamed_1ee4' : [ 0x8, {
    'UserData' : [ 0x0, ['pointer', ['void']]],
    'Owner' : [ 0x4, ['pointer', ['void']]],
} ],
  '__unnamed_1ee6' : [ 0x8, {
    'ListHead' : [ 0x0, ['_LIST_ENTRY']],
} ],
  '_RTLP_RANGE_LIST_ENTRY' : [ 0x28, {
    'Start' : [ 0x0, ['unsigned long long']],
    'End' : [ 0x8, ['unsigned long long']],
    'Allocated' : [ 0x10, ['__unnamed_1ee4']],
    'Merged' : [ 0x10, ['__unnamed_1ee6']],
    'Attributes' : [ 0x18, ['unsigned char']],
    'PublicFlags' : [ 0x19, ['unsigned char']],
    'PrivateFlags' : [ 0x1a, ['unsigned short']],
    'ListEntry' : [ 0x1c, ['_LIST_ENTRY']],
} ],
  '_ALPC_COMPLETION_PACKET_LOOKASIDE_ENTRY' : [ 0xc, {
    'ListEntry' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Packet' : [ 0x4, ['pointer', ['void']]],
    'Lookaside' : [ 0x8, ['pointer', ['_ALPC_COMPLETION_PACKET_LOOKASIDE']]],
} ],
  '__unnamed_1eed' : [ 0x2, {
    'AsUSHORT' : [ 0x0, ['unsigned short']],
    'AllowScaling' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'Disabled' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 16, native_type='unsigned short')]],
} ],
  'PROCESSOR_IDLESTATE_POLICY' : [ 0x20, {
    'Revision' : [ 0x0, ['unsigned short']],
    'Flags' : [ 0x2, ['__unnamed_1eed']],
    'PolicyCount' : [ 0x4, ['unsigned long']],
    'Policy' : [ 0x8, ['array', 3, ['PROCESSOR_IDLESTATE_INFO']]],
} ],
  '_ACTIVATION_CONTEXT_STACK' : [ 0x18, {
    'ActiveFrame' : [ 0x0, ['pointer', ['_RTL_ACTIVATION_CONTEXT_STACK_FRAME']]],
    'FrameListCache' : [ 0x4, ['_LIST_ENTRY']],
    'Flags' : [ 0xc, ['unsigned long']],
    'NextCookieSequenceNumber' : [ 0x10, ['unsigned long']],
    'StackId' : [ 0x14, ['unsigned long']],
} ],
  '_MSUBSECTION' : [ 0x38, {
    'ControlArea' : [ 0x0, ['pointer', ['_CONTROL_AREA']]],
    'SubsectionBase' : [ 0x4, ['pointer', ['_MMPTE']]],
    'NextSubsection' : [ 0x8, ['pointer', ['_SUBSECTION']]],
    'NextMappedSubsection' : [ 0x8, ['pointer', ['_MSUBSECTION']]],
    'PtesInSubsection' : [ 0xc, ['unsigned long']],
    'UnusedPtes' : [ 0x10, ['unsigned long']],
    'GlobalPerSessionHead' : [ 0x10, ['pointer', ['_MM_AVL_TABLE']]],
    'u' : [ 0x14, ['__unnamed_14c5']],
    'StartingSector' : [ 0x18, ['unsigned long']],
    'NumberOfFullSectors' : [ 0x1c, ['unsigned long']],
    'u1' : [ 0x20, ['__unnamed_1cf7']],
    'LeftChild' : [ 0x24, ['pointer', ['_MMSUBSECTION_NODE']]],
    'RightChild' : [ 0x28, ['pointer', ['_MMSUBSECTION_NODE']]],
    'DereferenceList' : [ 0x2c, ['_LIST_ENTRY']],
    'NumberOfMappedViews' : [ 0x34, ['unsigned long']],
} ],
  '_RTL_DRIVE_LETTER_CURDIR' : [ 0x10, {
    'Flags' : [ 0x0, ['unsigned short']],
    'Length' : [ 0x2, ['unsigned short']],
    'TimeStamp' : [ 0x4, ['unsigned long']],
    'DosPath' : [ 0x8, ['_STRING']],
} ],
  '_VIRTUAL_EFI_RUNTIME_SERVICES' : [ 0x38, {
    'GetTime' : [ 0x0, ['unsigned long']],
    'SetTime' : [ 0x4, ['unsigned long']],
    'GetWakeupTime' : [ 0x8, ['unsigned long']],
    'SetWakeupTime' : [ 0xc, ['unsigned long']],
    'SetVirtualAddressMap' : [ 0x10, ['unsigned long']],
    'ConvertPointer' : [ 0x14, ['unsigned long']],
    'GetVariable' : [ 0x18, ['unsigned long']],
    'GetNextVariableName' : [ 0x1c, ['unsigned long']],
    'SetVariable' : [ 0x20, ['unsigned long']],
    'GetNextHighMonotonicCount' : [ 0x24, ['unsigned long']],
    'ResetSystem' : [ 0x28, ['unsigned long']],
    'UpdateCapsule' : [ 0x2c, ['unsigned long']],
    'QueryCapsuleCapabilities' : [ 0x30, ['unsigned long']],
    'QueryVariableInfo' : [ 0x34, ['unsigned long']],
} ],
  'SYSTEM_POWER_CAPABILITIES' : [ 0x4c, {
    'PowerButtonPresent' : [ 0x0, ['unsigned char']],
    'SleepButtonPresent' : [ 0x1, ['unsigned char']],
    'LidPresent' : [ 0x2, ['unsigned char']],
    'SystemS1' : [ 0x3, ['unsigned char']],
    'SystemS2' : [ 0x4, ['unsigned char']],
    'SystemS3' : [ 0x5, ['unsigned char']],
    'SystemS4' : [ 0x6, ['unsigned char']],
    'SystemS5' : [ 0x7, ['unsigned char']],
    'HiberFilePresent' : [ 0x8, ['unsigned char']],
    'FullWake' : [ 0x9, ['unsigned char']],
    'VideoDimPresent' : [ 0xa, ['unsigned char']],
    'ApmPresent' : [ 0xb, ['unsigned char']],
    'UpsPresent' : [ 0xc, ['unsigned char']],
    'ThermalControl' : [ 0xd, ['unsigned char']],
    'ProcessorThrottle' : [ 0xe, ['unsigned char']],
    'ProcessorMinThrottle' : [ 0xf, ['unsigned char']],
    'ProcessorMaxThrottle' : [ 0x10, ['unsigned char']],
    'FastSystemS4' : [ 0x11, ['unsigned char']],
    'spare2' : [ 0x12, ['array', 3, ['unsigned char']]],
    'DiskSpinDown' : [ 0x15, ['unsigned char']],
    'spare3' : [ 0x16, ['array', 8, ['unsigned char']]],
    'SystemBatteriesPresent' : [ 0x1e, ['unsigned char']],
    'BatteriesAreShortTerm' : [ 0x1f, ['unsigned char']],
    'BatteryScale' : [ 0x20, ['array', 3, ['BATTERY_REPORTING_SCALE']]],
    'AcOnLineWake' : [ 0x38, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'SoftLidWake' : [ 0x3c, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'RtcWake' : [ 0x40, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'MinDeviceWakeState' : [ 0x44, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'DefaultLowLatencyWake' : [ 0x48, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
} ],
  '_WHEA_MEMORY_ERROR_VALIDBITS' : [ 0x8, {
    'ErrorStatus' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'PhysicalAddress' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'PhysicalAddressMask' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'Node' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long long')]],
    'Card' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long long')]],
    'Module' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long long')]],
    'Bank' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long long')]],
    'Device' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long long')]],
    'Row' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long long')]],
    'Column' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long long')]],
    'BitPosition' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'RequesterId' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long long')]],
    'ResponderId' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long long')]],
    'TargetId' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long long')]],
    'ErrorType' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 64, native_type='unsigned long long')]],
    'ValidBits' : [ 0x0, ['unsigned long long']],
} ],
  '_WHEA_PCIEXPRESS_DEVICE_ID' : [ 0x10, {
    'VendorID' : [ 0x0, ['unsigned short']],
    'DeviceID' : [ 0x2, ['unsigned short']],
    'ClassCode' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 24, native_type='unsigned long')]],
    'FunctionNumber' : [ 0x4, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
    'DeviceNumber' : [ 0x8, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned long')]],
    'Segment' : [ 0x8, ['BitField', dict(start_bit = 8, end_bit = 24, native_type='unsigned long')]],
    'PrimaryBusNumber' : [ 0x8, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
    'SecondaryBusNumber' : [ 0xc, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned long')]],
    'Reserved1' : [ 0xc, ['BitField', dict(start_bit = 8, end_bit = 10, native_type='unsigned long')]],
    'SlotNumber' : [ 0xc, ['BitField', dict(start_bit = 10, end_bit = 24, native_type='unsigned long')]],
    'Reserved2' : [ 0xc, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
} ],
  '_WNODE_HEADER' : [ 0x30, {
    'BufferSize' : [ 0x0, ['unsigned long']],
    'ProviderId' : [ 0x4, ['unsigned long']],
    'HistoricalContext' : [ 0x8, ['unsigned long long']],
    'Version' : [ 0x8, ['unsigned long']],
    'Linkage' : [ 0xc, ['unsigned long']],
    'CountLost' : [ 0x10, ['unsigned long']],
    'KernelHandle' : [ 0x10, ['pointer', ['void']]],
    'TimeStamp' : [ 0x10, ['_LARGE_INTEGER']],
    'Guid' : [ 0x18, ['_GUID']],
    'ClientContext' : [ 0x28, ['unsigned long']],
    'Flags' : [ 0x2c, ['unsigned long']],
} ],
  '__unnamed_1f11' : [ 0x4, {
    'ImageCommitment' : [ 0x0, ['unsigned long']],
    'CreatingProcess' : [ 0x0, ['pointer', ['_EPROCESS']]],
} ],
  '__unnamed_1f15' : [ 0x4, {
    'ImageInformation' : [ 0x0, ['pointer', ['_MI_SECTION_IMAGE_INFORMATION']]],
    'FirstMappedVa' : [ 0x0, ['pointer', ['void']]],
} ],
  '_SEGMENT' : [ 0x30, {
    'ControlArea' : [ 0x0, ['pointer', ['_CONTROL_AREA']]],
    'TotalNumberOfPtes' : [ 0x4, ['unsigned long']],
    'SegmentFlags' : [ 0x8, ['_SEGMENT_FLAGS']],
    'NumberOfCommittedPages' : [ 0xc, ['unsigned long']],
    'SizeOfSegment' : [ 0x10, ['unsigned long long']],
    'ExtendInfo' : [ 0x18, ['pointer', ['_MMEXTEND_INFO']]],
    'BasedAddress' : [ 0x18, ['pointer', ['void']]],
    'SegmentLock' : [ 0x1c, ['_EX_PUSH_LOCK']],
    'u1' : [ 0x20, ['__unnamed_1f11']],
    'u2' : [ 0x24, ['__unnamed_1f15']],
    'PrototypePte' : [ 0x28, ['pointer', ['_MMPTE']]],
    'ThePtes' : [ 0x2c, ['array', 1, ['_MMPTE']]],
} ],
  '_WHEA_PCIXDEVICE_ID' : [ 0x10, {
    'VendorId' : [ 0x0, ['unsigned short']],
    'DeviceId' : [ 0x2, ['unsigned short']],
    'ClassCode' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 24, native_type='unsigned long')]],
    'FunctionNumber' : [ 0x4, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
    'DeviceNumber' : [ 0x8, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned long')]],
    'BusNumber' : [ 0x8, ['BitField', dict(start_bit = 8, end_bit = 16, native_type='unsigned long')]],
    'SegmentNumber' : [ 0x8, ['BitField', dict(start_bit = 16, end_bit = 24, native_type='unsigned long')]],
    'Reserved1' : [ 0x8, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
    'Reserved2' : [ 0xc, ['unsigned long']],
} ],
  '_PCAT_FIRMWARE_INFORMATION' : [ 0x4, {
    'PlaceHolder' : [ 0x0, ['unsigned long']],
} ],
  '_PRIVATE_CACHE_MAP' : [ 0x58, {
    'NodeTypeCode' : [ 0x0, ['short']],
    'Flags' : [ 0x0, ['_PRIVATE_CACHE_MAP_FLAGS']],
    'UlongFlags' : [ 0x0, ['unsigned long']],
    'ReadAheadMask' : [ 0x4, ['unsigned long']],
    'FileObject' : [ 0x8, ['pointer', ['_FILE_OBJECT']]],
    'FileOffset1' : [ 0x10, ['_LARGE_INTEGER']],
    'BeyondLastByte1' : [ 0x18, ['_LARGE_INTEGER']],
    'FileOffset2' : [ 0x20, ['_LARGE_INTEGER']],
    'BeyondLastByte2' : [ 0x28, ['_LARGE_INTEGER']],
    'ReadAheadOffset' : [ 0x30, ['array', 2, ['_LARGE_INTEGER']]],
    'ReadAheadLength' : [ 0x40, ['array', 2, ['unsigned long']]],
    'ReadAheadSpinLock' : [ 0x48, ['unsigned long']],
    'PrivateLinks' : [ 0x4c, ['_LIST_ENTRY']],
    'ReadAheadWorkItem' : [ 0x54, ['pointer', ['void']]],
} ],
  '_CM_KEY_NODE' : [ 0x50, {
    'Signature' : [ 0x0, ['unsigned short']],
    'Flags' : [ 0x2, ['unsigned short']],
    'LastWriteTime' : [ 0x4, ['_LARGE_INTEGER']],
    'Spare' : [ 0xc, ['unsigned long']],
    'Parent' : [ 0x10, ['unsigned long']],
    'SubKeyCounts' : [ 0x14, ['array', 2, ['unsigned long']]],
    'SubKeyLists' : [ 0x1c, ['array', 2, ['unsigned long']]],
    'ValueList' : [ 0x24, ['_CHILD_LIST']],
    'ChildHiveReference' : [ 0x1c, ['_CM_KEY_REFERENCE']],
    'Security' : [ 0x2c, ['unsigned long']],
    'Class' : [ 0x30, ['unsigned long']],
    'MaxNameLen' : [ 0x34, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned long')]],
    'UserFlags' : [ 0x34, ['BitField', dict(start_bit = 16, end_bit = 20, native_type='unsigned long')]],
    'VirtControlFlags' : [ 0x34, ['BitField', dict(start_bit = 20, end_bit = 24, native_type='unsigned long')]],
    'Debug' : [ 0x34, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
    'MaxClassLen' : [ 0x38, ['unsigned long']],
    'MaxValueNameLen' : [ 0x3c, ['unsigned long']],
    'MaxValueDataLen' : [ 0x40, ['unsigned long']],
    'WorkVar' : [ 0x44, ['unsigned long']],
    'NameLength' : [ 0x48, ['unsigned short']],
    'ClassLength' : [ 0x4a, ['unsigned short']],
    'Name' : [ 0x4c, ['array', 1, ['wchar']]],
} ],
  '_RTL_HANDLE_TABLE' : [ 0x20, {
    'MaximumNumberOfHandles' : [ 0x0, ['unsigned long']],
    'SizeOfHandleTableEntry' : [ 0x4, ['unsigned long']],
    'Reserved' : [ 0x8, ['array', 2, ['unsigned long']]],
    'FreeHandles' : [ 0x10, ['pointer', ['_RTL_HANDLE_TABLE_ENTRY']]],
    'CommittedHandles' : [ 0x14, ['pointer', ['_RTL_HANDLE_TABLE_ENTRY']]],
    'UnCommittedHandles' : [ 0x18, ['pointer', ['_RTL_HANDLE_TABLE_ENTRY']]],
    'MaxReservedHandles' : [ 0x1c, ['pointer', ['_RTL_HANDLE_TABLE_ENTRY']]],
} ],
  '_PTE_TRACKER' : [ 0x30, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Mdl' : [ 0x8, ['pointer', ['_MDL']]],
    'Count' : [ 0xc, ['unsigned long']],
    'SystemVa' : [ 0x10, ['pointer', ['void']]],
    'StartVa' : [ 0x14, ['pointer', ['void']]],
    'Offset' : [ 0x18, ['unsigned long']],
    'Length' : [ 0x1c, ['unsigned long']],
    'Page' : [ 0x20, ['unsigned long']],
    'IoMapping' : [ 0x24, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Matched' : [ 0x24, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'CacheAttribute' : [ 0x24, ['BitField', dict(start_bit = 2, end_bit = 4, native_type='unsigned long')]],
    'Spare' : [ 0x24, ['BitField', dict(start_bit = 4, end_bit = 32, native_type='unsigned long')]],
    'CallingAddress' : [ 0x28, ['pointer', ['void']]],
    'CallersCaller' : [ 0x2c, ['pointer', ['void']]],
} ],
  '_MMPFNLIST' : [ 0x10, {
    'Total' : [ 0x0, ['unsigned long']],
    'ListName' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'ZeroedPageList', 1: 'FreePageList', 2: 'StandbyPageList', 3: 'ModifiedPageList', 4: 'ModifiedNoWritePageList', 5: 'BadPageList', 6: 'ActiveAndValid', 7: 'TransitionPage'})]],
    'Flink' : [ 0x8, ['unsigned long']],
    'Blink' : [ 0xc, ['unsigned long']],
} ],
  '_DEVOBJ_EXTENSION' : [ 0x3c, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['unsigned short']],
    'DeviceObject' : [ 0x4, ['pointer', ['_DEVICE_OBJECT']]],
    'PowerFlags' : [ 0x8, ['unsigned long']],
    'Dope' : [ 0xc, ['pointer', ['_DEVICE_OBJECT_POWER_EXTENSION']]],
    'ExtensionFlags' : [ 0x10, ['unsigned long']],
    'DeviceNode' : [ 0x14, ['pointer', ['void']]],
    'AttachedTo' : [ 0x18, ['pointer', ['_DEVICE_OBJECT']]],
    'StartIoCount' : [ 0x1c, ['long']],
    'StartIoKey' : [ 0x20, ['long']],
    'StartIoFlags' : [ 0x24, ['unsigned long']],
    'Vpb' : [ 0x28, ['pointer', ['_VPB']]],
    'DependentList' : [ 0x2c, ['_LIST_ENTRY']],
    'ProviderList' : [ 0x34, ['_LIST_ENTRY']],
} ],
  '_DBGKD_GET_VERSION64' : [ 0x28, {
    'MajorVersion' : [ 0x0, ['unsigned short']],
    'MinorVersion' : [ 0x2, ['unsigned short']],
    'ProtocolVersion' : [ 0x4, ['unsigned char']],
    'KdSecondaryVersion' : [ 0x5, ['unsigned char']],
    'Flags' : [ 0x6, ['unsigned short']],
    'MachineType' : [ 0x8, ['unsigned short']],
    'MaxPacketType' : [ 0xa, ['unsigned char']],
    'MaxStateChange' : [ 0xb, ['unsigned char']],
    'MaxManipulate' : [ 0xc, ['unsigned char']],
    'Simulation' : [ 0xd, ['unsigned char']],
    'Unused' : [ 0xe, ['array', 1, ['unsigned short']]],
    'KernBase' : [ 0x10, ['unsigned long long']],
    'PsLoadedModuleList' : [ 0x18, ['unsigned long long']],
    'DebuggerDataList' : [ 0x20, ['unsigned long long']],
} ],
  '_WHEA_PCIEXPRESS_COMMAND_STATUS' : [ 0x4, {
    'Command' : [ 0x0, ['unsigned short']],
    'Status' : [ 0x2, ['unsigned short']],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_HMAP_ENTRY' : [ 0x10, {
    'BlockAddress' : [ 0x0, ['unsigned long']],
    'BinAddress' : [ 0x4, ['unsigned long']],
    'CmView' : [ 0x8, ['pointer', ['_CM_VIEW_OF_FILE']]],
    'MemAlloc' : [ 0xc, ['unsigned long']],
} ],
  '_RTL_ATOM_TABLE_ENTRY' : [ 0x10, {
    'HashLink' : [ 0x0, ['pointer', ['_RTL_ATOM_TABLE_ENTRY']]],
    'HandleIndex' : [ 0x4, ['unsigned short']],
    'Atom' : [ 0x6, ['unsigned short']],
    'ReferenceCount' : [ 0x8, ['unsigned short']],
    'Flags' : [ 0xa, ['unsigned char']],
    'NameLength' : [ 0xb, ['unsigned char']],
    'Name' : [ 0xc, ['array', 1, ['wchar']]],
} ],
  '_TXN_PARAMETER_BLOCK' : [ 0x8, {
    'Length' : [ 0x0, ['unsigned short']],
    'TxFsContext' : [ 0x2, ['unsigned short']],
    'TransactionObject' : [ 0x4, ['pointer', ['void']]],
} ],
  '_LOADER_PERFORMANCE_DATA' : [ 0x10, {
    'StartTime' : [ 0x0, ['unsigned long long']],
    'EndTime' : [ 0x8, ['unsigned long long']],
} ],
  '_X86_DBGKD_CONTROL_SET' : [ 0x10, {
    'TraceFlag' : [ 0x0, ['unsigned long']],
    'Dr7' : [ 0x4, ['unsigned long']],
    'CurrentSymbolStart' : [ 0x8, ['unsigned long']],
    'CurrentSymbolEnd' : [ 0xc, ['unsigned long']],
} ],
  '_MMSESSION' : [ 0x38, {
    'SystemSpaceViewLock' : [ 0x0, ['_KGUARDED_MUTEX']],
    'SystemSpaceViewLockPointer' : [ 0x20, ['pointer', ['_KGUARDED_MUTEX']]],
    'SystemSpaceViewTable' : [ 0x24, ['pointer', ['_MMVIEW']]],
    'SystemSpaceHashSize' : [ 0x28, ['unsigned long']],
    'SystemSpaceHashEntries' : [ 0x2c, ['unsigned long']],
    'SystemSpaceHashKey' : [ 0x30, ['unsigned long']],
    'BitmapFailures' : [ 0x34, ['unsigned long']],
} ],
  '_WHEA_PCIEXPRESS_ERROR_VALIDBITS' : [ 0x8, {
    'PortType' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'Version' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'CommandStatus' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'DeviceId' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long long')]],
    'DeviceSerialNumber' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long long')]],
    'BridgeControlStatus' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long long')]],
    'ExpressCapability' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long long')]],
    'AerInfo' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 64, native_type='unsigned long long')]],
    'ValidBits' : [ 0x0, ['unsigned long long']],
} ],
  '_ETW_REG_ENTRY' : [ 0x2c, {
    'RegList' : [ 0x0, ['_LIST_ENTRY']],
    'GuidEntry' : [ 0x8, ['pointer', ['_ETW_GUID_ENTRY']]],
    'Index' : [ 0xc, ['unsigned short']],
    'Flags' : [ 0xe, ['unsigned short']],
    'EnableMask' : [ 0x10, ['unsigned char']],
    'ReplyQueue' : [ 0x14, ['pointer', ['_ETW_REPLY_QUEUE']]],
    'ReplySlot' : [ 0x14, ['array', 4, ['pointer', ['_ETW_REG_ENTRY']]]],
    'Process' : [ 0x24, ['pointer', ['_EPROCESS']]],
    'Callback' : [ 0x24, ['pointer', ['void']]],
    'CallbackContext' : [ 0x28, ['pointer', ['void']]],
} ],
  '_LPCP_PORT_OBJECT' : [ 0xa4, {
    'ConnectionPort' : [ 0x0, ['pointer', ['_LPCP_PORT_OBJECT']]],
    'ConnectedPort' : [ 0x4, ['pointer', ['_LPCP_PORT_OBJECT']]],
    'MsgQueue' : [ 0x8, ['_LPCP_PORT_QUEUE']],
    'Creator' : [ 0x18, ['_CLIENT_ID']],
    'ClientSectionBase' : [ 0x20, ['pointer', ['void']]],
    'ServerSectionBase' : [ 0x24, ['pointer', ['void']]],
    'PortContext' : [ 0x28, ['pointer', ['void']]],
    'ClientThread' : [ 0x2c, ['pointer', ['_ETHREAD']]],
    'SecurityQos' : [ 0x30, ['_SECURITY_QUALITY_OF_SERVICE']],
    'StaticSecurity' : [ 0x3c, ['_SECURITY_CLIENT_CONTEXT']],
    'LpcReplyChainHead' : [ 0x78, ['_LIST_ENTRY']],
    'LpcDataInfoChainHead' : [ 0x80, ['_LIST_ENTRY']],
    'ServerProcess' : [ 0x88, ['pointer', ['_EPROCESS']]],
    'MappingProcess' : [ 0x88, ['pointer', ['_EPROCESS']]],
    'MaxMessageLength' : [ 0x8c, ['unsigned short']],
    'MaxConnectionInfoLength' : [ 0x8e, ['unsigned short']],
    'Flags' : [ 0x90, ['unsigned long']],
    'WaitEvent' : [ 0x94, ['_KEVENT']],
} ],
  '_ARBITER_LIST_ENTRY' : [ 0x38, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'AlternativeCount' : [ 0x8, ['unsigned long']],
    'Alternatives' : [ 0xc, ['pointer', ['_IO_RESOURCE_DESCRIPTOR']]],
    'PhysicalDeviceObject' : [ 0x10, ['pointer', ['_DEVICE_OBJECT']]],
    'RequestSource' : [ 0x14, ['Enumeration', dict(target = 'long', choices = {0: 'ArbiterRequestLegacyReported', 1: 'ArbiterRequestHalReported', 2: 'ArbiterRequestLegacyAssigned', 3: 'ArbiterRequestPnpDetected', 4: 'ArbiterRequestPnpEnumerated', -1: 'ArbiterRequestUndefined'})]],
    'Flags' : [ 0x18, ['unsigned long']],
    'WorkSpace' : [ 0x1c, ['long']],
    'InterfaceType' : [ 0x20, ['Enumeration', dict(target = 'long', choices = {0: 'Internal', 1: 'Isa', 2: 'Eisa', 3: 'MicroChannel', 4: 'TurboChannel', 5: 'PCIBus', 6: 'VMEBus', 7: 'NuBus', 8: 'PCMCIABus', 9: 'CBus', 10: 'MPIBus', 11: 'MPSABus', 12: 'ProcessorInternal', 13: 'InternalPowerBus', 14: 'PNPISABus', 15: 'PNPBus', 16: 'Vmcs', 17: 'MaximumInterfaceType', -1: 'InterfaceTypeUndefined'})]],
    'SlotNumber' : [ 0x24, ['unsigned long']],
    'BusNumber' : [ 0x28, ['unsigned long']],
    'Assignment' : [ 0x2c, ['pointer', ['_CM_PARTIAL_RESOURCE_DESCRIPTOR']]],
    'SelectedAlternative' : [ 0x30, ['pointer', ['_IO_RESOURCE_DESCRIPTOR']]],
    'Result' : [ 0x34, ['Enumeration', dict(target = 'long', choices = {0: 'ArbiterResultSuccess', 1: 'ArbiterResultExternalConflict', 2: 'ArbiterResultNullRequest', -1: 'ArbiterResultUndefined'})]],
} ],
  '_KNODE' : [ 0x80, {
    'PagedPoolSListHead' : [ 0x0, ['_SLIST_HEADER']],
    'NonPagedPoolSListHead' : [ 0x8, ['array', 3, ['_SLIST_HEADER']]],
    'PfnDereferenceSListHead' : [ 0x20, ['_SLIST_HEADER']],
    'ProcessorMask' : [ 0x28, ['unsigned long']],
    'Color' : [ 0x2c, ['unsigned char']],
    'Seed' : [ 0x2d, ['unsigned char']],
    'NodeNumber' : [ 0x2e, ['unsigned char']],
    'Flags' : [ 0x2f, ['_flags']],
    'MmShiftedColor' : [ 0x30, ['unsigned long']],
    'FreeCount' : [ 0x34, ['array', 2, ['unsigned long']]],
    'PfnDeferredList' : [ 0x3c, ['pointer', ['_SINGLE_LIST_ENTRY']]],
    'CachedKernelStacks' : [ 0x40, ['_CACHED_KSTACK_LIST']],
} ],
  '_CACHED_KSTACK_LIST' : [ 0x18, {
    'SListHead' : [ 0x0, ['_SLIST_HEADER']],
    'MinimumFree' : [ 0x8, ['long']],
    'Misses' : [ 0xc, ['unsigned long']],
    'MissesLast' : [ 0x10, ['unsigned long']],
} ],
  '_POP_DEVICE_SYS_STATE' : [ 0x188, {
    'IrpMinor' : [ 0x0, ['unsigned char']],
    'SystemState' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'SpinLock' : [ 0x8, ['unsigned long']],
    'Thread' : [ 0xc, ['pointer', ['_KTHREAD']]],
    'AbortEvent' : [ 0x10, ['pointer', ['_KEVENT']]],
    'ReadySemaphore' : [ 0x14, ['pointer', ['_KSEMAPHORE']]],
    'FinishedSemaphore' : [ 0x18, ['pointer', ['_KSEMAPHORE']]],
    'GetNewDeviceList' : [ 0x1c, ['unsigned char']],
    'Order' : [ 0x20, ['_PO_DEVICE_NOTIFY_ORDER']],
    'NotifyGdiLevelForPowerOn' : [ 0x168, ['long']],
    'NotifyGdiLevelForResumeUI' : [ 0x16c, ['long']],
    'Pending' : [ 0x170, ['_LIST_ENTRY']],
    'Status' : [ 0x178, ['long']],
    'FailedDevice' : [ 0x17c, ['pointer', ['_DEVICE_OBJECT']]],
    'Waking' : [ 0x180, ['unsigned char']],
    'Cancelled' : [ 0x181, ['unsigned char']],
    'IgnoreErrors' : [ 0x182, ['unsigned char']],
    'IgnoreNotImplemented' : [ 0x183, ['unsigned char']],
    'TimeRefreshLockAcquired' : [ 0x184, ['unsigned char']],
} ],
  '_SEGMENT_FLAGS' : [ 0x4, {
    'TotalNumberOfPtes4132' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 10, native_type='unsigned long')]],
    'ExtraSharedWowSubsections' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'LargePages' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'WatchProto' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'DebugSymbolsLoaded' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'WriteCombined' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'NoCache' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'FloppyMedia' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'DefaultProtectionMask' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 22, native_type='unsigned long')]],
    'ContainsPxeSubsection' : [ 0x0, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long')]],
    'Binary32' : [ 0x0, ['BitField', dict(start_bit = 23, end_bit = 24, native_type='unsigned long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
} ],
  '_EX_WORK_QUEUE' : [ 0x3c, {
    'WorkerQueue' : [ 0x0, ['_KQUEUE']],
    'DynamicThreadCount' : [ 0x28, ['unsigned long']],
    'WorkItemsProcessed' : [ 0x2c, ['unsigned long']],
    'WorkItemsProcessedLastPass' : [ 0x30, ['unsigned long']],
    'QueueDepthLastPass' : [ 0x34, ['unsigned long']],
    'Info' : [ 0x38, ['EX_QUEUE_WORKER_INFO']],
} ],
  '_SHARED_CACHE_MAP_LIST_CURSOR' : [ 0xc, {
    'SharedCacheMapLinks' : [ 0x0, ['_LIST_ENTRY']],
    'Flags' : [ 0x8, ['unsigned long']],
} ],
  '_CM_KEY_INDEX' : [ 0x8, {
    'Signature' : [ 0x0, ['unsigned short']],
    'Count' : [ 0x2, ['unsigned short']],
    'List' : [ 0x4, ['array', 1, ['unsigned long']]],
} ],
  '_VI_DEADLOCK_THREAD' : [ 0x1c, {
    'Thread' : [ 0x0, ['pointer', ['_KTHREAD']]],
    'CurrentSpinNode' : [ 0x4, ['pointer', ['_VI_DEADLOCK_NODE']]],
    'CurrentOtherNode' : [ 0x8, ['pointer', ['_VI_DEADLOCK_NODE']]],
    'ListEntry' : [ 0xc, ['_LIST_ENTRY']],
    'FreeListEntry' : [ 0xc, ['_LIST_ENTRY']],
    'NodeCount' : [ 0x14, ['unsigned long']],
    'PagingCount' : [ 0x18, ['unsigned long']],
} ],
  '_PPM_IDLE_STATE' : [ 0x20, {
    'IdleHandler' : [ 0x0, ['pointer', ['void']]],
    'Context' : [ 0x4, ['pointer', ['void']]],
    'Latency' : [ 0x8, ['unsigned long']],
    'Power' : [ 0xc, ['unsigned long']],
    'TimeCheck' : [ 0x10, ['unsigned long']],
    'StateFlags' : [ 0x14, ['unsigned long']],
    'PromotePercent' : [ 0x18, ['unsigned char']],
    'DemotePercent' : [ 0x19, ['unsigned char']],
    'PromotePercentBase' : [ 0x1a, ['unsigned char']],
    'DemotePercentBase' : [ 0x1b, ['unsigned char']],
    'StateType' : [ 0x1c, ['unsigned char']],
} ],
  '_WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_FLAGS' : [ 0x4, {
    'Primary' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ContainmentWarning' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Reset' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'ThresholdExceeded' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'ResourceNotAvailable' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'LatentError' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 32, native_type='unsigned long')]],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_KRESOURCEMANAGER' : [ 0x154, {
    'NotificationAvailable' : [ 0x0, ['_KEVENT']],
    'cookie' : [ 0x10, ['unsigned long']],
    'State' : [ 0x14, ['Enumeration', dict(target = 'long', choices = {0: 'KResourceManagerUninitialized', 1: 'KResourceManagerOffline', 2: 'KResourceManagerOnline'})]],
    'Flags' : [ 0x18, ['unsigned long']],
    'Mutex' : [ 0x1c, ['_KMUTANT']],
    'NamespaceLink' : [ 0x3c, ['_KTMOBJECT_NAMESPACE_LINK']],
    'RmId' : [ 0x50, ['_GUID']],
    'NotificationQueue' : [ 0x60, ['_KQUEUE']],
    'NotificationMutex' : [ 0x88, ['_KMUTANT']],
    'EnlistmentHead' : [ 0xa8, ['_LIST_ENTRY']],
    'EnlistmentCount' : [ 0xb0, ['unsigned long']],
    'NotificationRoutine' : [ 0xb4, ['pointer', ['void']]],
    'Key' : [ 0xb8, ['pointer', ['void']]],
    'ProtocolListHead' : [ 0xbc, ['_LIST_ENTRY']],
    'PendingPropReqListHead' : [ 0xc4, ['_LIST_ENTRY']],
    'CRMListEntry' : [ 0xcc, ['_LIST_ENTRY']],
    'Tm' : [ 0xd4, ['pointer', ['_KTM']]],
    'Description' : [ 0xd8, ['_UNICODE_STRING']],
    'Enlistments' : [ 0xe0, ['_KTMOBJECT_NAMESPACE']],
    'CompletionBinding' : [ 0x140, ['_KRESOURCEMANAGER_COMPLETION_BINDING']],
} ],
  '_FILE_NETWORK_OPEN_INFORMATION' : [ 0x38, {
    'CreationTime' : [ 0x0, ['_LARGE_INTEGER']],
    'LastAccessTime' : [ 0x8, ['_LARGE_INTEGER']],
    'LastWriteTime' : [ 0x10, ['_LARGE_INTEGER']],
    'ChangeTime' : [ 0x18, ['_LARGE_INTEGER']],
    'AllocationSize' : [ 0x20, ['_LARGE_INTEGER']],
    'EndOfFile' : [ 0x28, ['_LARGE_INTEGER']],
    'FileAttributes' : [ 0x30, ['unsigned long']],
} ],
  '_MM_DRIVER_VERIFIER_DATA' : [ 0x78, {
    'Level' : [ 0x0, ['unsigned long']],
    'RaiseIrqls' : [ 0x4, ['unsigned long']],
    'AcquireSpinLocks' : [ 0x8, ['unsigned long']],
    'SynchronizeExecutions' : [ 0xc, ['unsigned long']],
    'AllocationsAttempted' : [ 0x10, ['unsigned long']],
    'AllocationsSucceeded' : [ 0x14, ['unsigned long']],
    'AllocationsSucceededSpecialPool' : [ 0x18, ['unsigned long']],
    'AllocationsWithNoTag' : [ 0x1c, ['unsigned long']],
    'TrimRequests' : [ 0x20, ['unsigned long']],
    'Trims' : [ 0x24, ['unsigned long']],
    'AllocationsFailed' : [ 0x28, ['unsigned long']],
    'AllocationsFailedDeliberately' : [ 0x2c, ['unsigned long']],
    'Loads' : [ 0x30, ['unsigned long']],
    'Unloads' : [ 0x34, ['unsigned long']],
    'UnTrackedPool' : [ 0x38, ['unsigned long']],
    'UserTrims' : [ 0x3c, ['unsigned long']],
    'CurrentPagedPoolAllocations' : [ 0x40, ['unsigned long']],
    'CurrentNonPagedPoolAllocations' : [ 0x44, ['unsigned long']],
    'PeakPagedPoolAllocations' : [ 0x48, ['unsigned long']],
    'PeakNonPagedPoolAllocations' : [ 0x4c, ['unsigned long']],
    'PagedBytes' : [ 0x50, ['unsigned long']],
    'NonPagedBytes' : [ 0x54, ['unsigned long']],
    'PeakPagedBytes' : [ 0x58, ['unsigned long']],
    'PeakNonPagedBytes' : [ 0x5c, ['unsigned long']],
    'BurstAllocationsFailedDeliberately' : [ 0x60, ['unsigned long']],
    'SessionTrims' : [ 0x64, ['unsigned long']],
    'OptionChanges' : [ 0x68, ['unsigned long']],
    'VerifyMode' : [ 0x6c, ['unsigned long']],
    'PreviousBucketName' : [ 0x70, ['_UNICODE_STRING']],
} ],
  '_HEAP_FREE_ENTRY_EXTRA' : [ 0x4, {
    'TagIndex' : [ 0x0, ['unsigned short']],
    'FreeBackTraceIndex' : [ 0x2, ['unsigned short']],
} ],
  '_VI_DEADLOCK_GLOBALS' : [ 0x40e0, {
    'TimeAcquire' : [ 0x0, ['long long']],
    'TimeRelease' : [ 0x8, ['long long']],
    'ResourceDatabase' : [ 0x10, ['pointer', ['_LIST_ENTRY']]],
    'ResourceDatabaseCount' : [ 0x14, ['unsigned long']],
    'ResourceAddressRange' : [ 0x18, ['array', 1023, ['_VI_DEADLOCK_ADDRESS_RANGE']]],
    'ThreadDatabase' : [ 0x2010, ['pointer', ['_LIST_ENTRY']]],
    'ThreadDatabaseCount' : [ 0x2014, ['unsigned long']],
    'ThreadAddressRange' : [ 0x2018, ['array', 1023, ['_VI_DEADLOCK_ADDRESS_RANGE']]],
    'AllocationFailures' : [ 0x4010, ['unsigned long']],
    'NodesTrimmedBasedOnAge' : [ 0x4014, ['unsigned long']],
    'NodesTrimmedBasedOnCount' : [ 0x4018, ['unsigned long']],
    'NodesSearched' : [ 0x401c, ['unsigned long']],
    'MaxNodesSearched' : [ 0x4020, ['unsigned long']],
    'SequenceNumber' : [ 0x4024, ['unsigned long']],
    'RecursionDepthLimit' : [ 0x4028, ['unsigned long']],
    'SearchedNodesLimit' : [ 0x402c, ['unsigned long']],
    'DepthLimitHits' : [ 0x4030, ['unsigned long']],
    'SearchLimitHits' : [ 0x4034, ['unsigned long']],
    'ABC_ACB_Skipped' : [ 0x4038, ['unsigned long']],
    'OutOfOrderReleases' : [ 0x403c, ['unsigned long']],
    'NodesReleasedOutOfOrder' : [ 0x4040, ['unsigned long']],
    'TotalReleases' : [ 0x4044, ['unsigned long']],
    'RootNodesDeleted' : [ 0x4048, ['unsigned long']],
    'ForgetHistoryCounter' : [ 0x404c, ['unsigned long']],
    'Instigator' : [ 0x4050, ['pointer', ['void']]],
    'NumberOfParticipants' : [ 0x4054, ['unsigned long']],
    'Participant' : [ 0x4058, ['array', 32, ['pointer', ['_VI_DEADLOCK_NODE']]]],
    'ChildrenCountWatermark' : [ 0x40d8, ['long']],
} ],
  '_POP_DISPLAY_RESUME_CONTEXT' : [ 0x50, {
    'WorkItem' : [ 0x0, ['_WORK_QUEUE_ITEM']],
    'WorkerThread' : [ 0x10, ['pointer', ['_ETHREAD']]],
    'PrepareUIEvent' : [ 0x14, ['_KEVENT']],
    'PowerOnEvent' : [ 0x24, ['_KEVENT']],
    'DoneEvent' : [ 0x34, ['_KEVENT']],
    'WorkerQueued' : [ 0x44, ['unsigned long']],
    'WorkerAbort' : [ 0x48, ['unsigned long']],
    'NoResumeUI' : [ 0x4c, ['unsigned long']],
} ],
  '_KTM' : [ 0x228, {
    'cookie' : [ 0x0, ['unsigned long']],
    'Mutex' : [ 0x4, ['_KMUTANT']],
    'State' : [ 0x24, ['Enumeration', dict(target = 'long', choices = {0: 'KKtmUninitialized', 1: 'KKtmInitialized', 2: 'KKtmRecovering', 3: 'KKtmOnline', 4: 'KKtmRecoveryFailed', 5: 'KKtmOffline'})]],
    'NamespaceLink' : [ 0x28, ['_KTMOBJECT_NAMESPACE_LINK']],
    'TmIdentity' : [ 0x3c, ['_GUID']],
    'Flags' : [ 0x4c, ['unsigned long']],
    'VolatileFlags' : [ 0x50, ['unsigned long']],
    'LogFileName' : [ 0x54, ['_UNICODE_STRING']],
    'LogFileObject' : [ 0x5c, ['pointer', ['_FILE_OBJECT']]],
    'MarshallingContext' : [ 0x60, ['pointer', ['void']]],
    'LogManagementContext' : [ 0x64, ['pointer', ['void']]],
    'Transactions' : [ 0x68, ['_KTMOBJECT_NAMESPACE']],
    'ResourceManagers' : [ 0xc8, ['_KTMOBJECT_NAMESPACE']],
    'LsnOrderedMutex' : [ 0x128, ['_KMUTANT']],
    'LsnOrderedList' : [ 0x148, ['_LIST_ENTRY']],
    'CommitVirtualClock' : [ 0x150, ['_LARGE_INTEGER']],
    'CommitVirtualClockMutex' : [ 0x158, ['_FAST_MUTEX']],
    'BaseLsn' : [ 0x178, ['_CLS_LSN']],
    'CurrentReadLsn' : [ 0x180, ['_CLS_LSN']],
    'LastRecoveredLsn' : [ 0x188, ['_CLS_LSN']],
    'TmRmHandle' : [ 0x190, ['pointer', ['void']]],
    'TmRm' : [ 0x194, ['pointer', ['_KRESOURCEMANAGER']]],
    'LogFullNotifyEvent' : [ 0x198, ['_KEVENT']],
    'CheckpointWorkItem' : [ 0x1a8, ['_WORK_QUEUE_ITEM']],
    'CheckpointTargetLsn' : [ 0x1b8, ['_CLS_LSN']],
    'LogFullCompletedWorkItem' : [ 0x1c0, ['_WORK_QUEUE_ITEM']],
    'LogWriteResource' : [ 0x1d0, ['_ERESOURCE']],
    'LogFlags' : [ 0x208, ['unsigned long']],
    'LogFullStatus' : [ 0x20c, ['long']],
    'RecoveryStatus' : [ 0x210, ['long']],
    'LastCheckBaseLsn' : [ 0x218, ['_CLS_LSN']],
    'RestartOrderedList' : [ 0x220, ['_LIST_ENTRY']],
} ],
  '_PNP_DEVICE_EVENT_ENTRY' : [ 0x60, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Argument' : [ 0x8, ['unsigned long']],
    'CallerEvent' : [ 0xc, ['pointer', ['_KEVENT']]],
    'Callback' : [ 0x10, ['pointer', ['void']]],
    'Context' : [ 0x14, ['pointer', ['void']]],
    'VetoType' : [ 0x18, ['pointer', ['Enumeration', dict(target = 'long', choices = {0: 'PNP_VetoTypeUnknown', 1: 'PNP_VetoLegacyDevice', 2: 'PNP_VetoPendingClose', 3: 'PNP_VetoWindowsApp', 4: 'PNP_VetoWindowsService', 5: 'PNP_VetoOutstandingOpen', 6: 'PNP_VetoDevice', 7: 'PNP_VetoDriver', 8: 'PNP_VetoIllegalDeviceRequest', 9: 'PNP_VetoInsufficientPower', 10: 'PNP_VetoNonDisableable', 11: 'PNP_VetoLegacyDriver', 12: 'PNP_VetoInsufficientRights'})]]],
    'VetoName' : [ 0x1c, ['pointer', ['_UNICODE_STRING']]],
    'Data' : [ 0x20, ['_PLUGPLAY_EVENT_BLOCK']],
} ],
  '_CONFIGURATION_COMPONENT' : [ 0x24, {
    'Class' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'SystemClass', 1: 'ProcessorClass', 2: 'CacheClass', 3: 'AdapterClass', 4: 'ControllerClass', 5: 'PeripheralClass', 6: 'MemoryClass', 7: 'MaximumClass'})]],
    'Type' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'ArcSystem', 1: 'CentralProcessor', 2: 'FloatingPointProcessor', 3: 'PrimaryIcache', 4: 'PrimaryDcache', 5: 'SecondaryIcache', 6: 'SecondaryDcache', 7: 'SecondaryCache', 8: 'EisaAdapter', 9: 'TcAdapter', 10: 'ScsiAdapter', 11: 'DtiAdapter', 12: 'MultiFunctionAdapter', 13: 'DiskController', 14: 'TapeController', 15: 'CdromController', 16: 'WormController', 17: 'SerialController', 18: 'NetworkController', 19: 'DisplayController', 20: 'ParallelController', 21: 'PointerController', 22: 'KeyboardController', 23: 'AudioController', 24: 'OtherController', 25: 'DiskPeripheral', 26: 'FloppyDiskPeripheral', 27: 'TapePeripheral', 28: 'ModemPeripheral', 29: 'MonitorPeripheral', 30: 'PrinterPeripheral', 31: 'PointerPeripheral', 32: 'KeyboardPeripheral', 33: 'TerminalPeripheral', 34: 'OtherPeripheral', 35: 'LinePeripheral', 36: 'NetworkPeripheral', 37: 'SystemMemory', 38: 'DockingInformation', 39: 'RealModeIrqRoutingTable', 40: 'RealModePCIEnumeration', 41: 'MaximumType'})]],
    'Flags' : [ 0x8, ['_DEVICE_FLAGS']],
    'Version' : [ 0xc, ['unsigned short']],
    'Revision' : [ 0xe, ['unsigned short']],
    'Key' : [ 0x10, ['unsigned long']],
    'AffinityMask' : [ 0x14, ['unsigned long']],
    'ConfigurationDataLength' : [ 0x18, ['unsigned long']],
    'IdentifierLength' : [ 0x1c, ['unsigned long']],
    'Identifier' : [ 0x20, ['pointer', ['unsigned char']]],
} ],
  '_VF_BTS_RECORD' : [ 0xc, {
    'JumpedFrom' : [ 0x0, ['pointer', ['void']]],
    'JumpedTo' : [ 0x4, ['pointer', ['void']]],
    'Unused1' : [ 0x8, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned long')]],
    'Predicted' : [ 0x8, ['BitField', dict(start_bit = 3, end_bit = 7, native_type='unsigned long')]],
    'Unused2' : [ 0x8, ['BitField', dict(start_bit = 7, end_bit = 32, native_type='unsigned long')]],
} ],
  '_KTRANSACTION' : [ 0x1e0, {
    'OutcomeEvent' : [ 0x0, ['_KEVENT']],
    'cookie' : [ 0x10, ['unsigned long']],
    'Mutex' : [ 0x14, ['_KMUTANT']],
    'TreeTx' : [ 0x34, ['pointer', ['_KTRANSACTION']]],
    'GlobalNamespaceLink' : [ 0x38, ['_KTMOBJECT_NAMESPACE_LINK']],
    'TmNamespaceLink' : [ 0x4c, ['_KTMOBJECT_NAMESPACE_LINK']],
    'UOW' : [ 0x60, ['_GUID']],
    'State' : [ 0x70, ['Enumeration', dict(target = 'long', choices = {0: 'KTransactionUninitialized', 1: 'KTransactionActive', 2: 'KTransactionPreparing', 3: 'KTransactionPrepared', 4: 'KTransactionInDoubt', 5: 'KTransactionCommitted', 6: 'KTransactionAborted', 7: 'KTransactionDelegated', 8: 'KTransactionPrePreparing', 9: 'KTransactionForgotten', 10: 'KTransactionRecovering', 11: 'KTransactionPrePrepared'})]],
    'Flags' : [ 0x74, ['unsigned long']],
    'EnlistmentHead' : [ 0x78, ['_LIST_ENTRY']],
    'EnlistmentCount' : [ 0x80, ['unsigned long']],
    'RecoverableEnlistmentCount' : [ 0x84, ['unsigned long']],
    'PrePrepareRequiredEnlistmentCount' : [ 0x88, ['unsigned long']],
    'PrepareRequiredEnlistmentCount' : [ 0x8c, ['unsigned long']],
    'OutcomeRequiredEnlistmentCount' : [ 0x90, ['unsigned long']],
    'PendingResponses' : [ 0x94, ['unsigned long']],
    'SuperiorEnlistment' : [ 0x98, ['pointer', ['_KENLISTMENT']]],
    'LastLsn' : [ 0xa0, ['_CLS_LSN']],
    'PromotedEntry' : [ 0xa8, ['_LIST_ENTRY']],
    'PromoterTransaction' : [ 0xb0, ['pointer', ['_KTRANSACTION']]],
    'PromotePropagation' : [ 0xb4, ['pointer', ['void']]],
    'IsolationLevel' : [ 0xb8, ['unsigned long']],
    'IsolationFlags' : [ 0xbc, ['unsigned long']],
    'Timeout' : [ 0xc0, ['_LARGE_INTEGER']],
    'Description' : [ 0xc8, ['_UNICODE_STRING']],
    'RollbackThread' : [ 0xd0, ['pointer', ['_KTHREAD']]],
    'RollbackWorkItem' : [ 0xd4, ['_WORK_QUEUE_ITEM']],
    'RollbackDpc' : [ 0xe4, ['_KDPC']],
    'RollbackTimer' : [ 0x108, ['_KTIMER']],
    'LsnOrderedEntry' : [ 0x130, ['_LIST_ENTRY']],
    'Outcome' : [ 0x138, ['Enumeration', dict(target = 'long', choices = {0: 'KTxOutcomeUninitialized', 1: 'KTxOutcomeUndetermined', 2: 'KTxOutcomeCommitted', 3: 'KTxOutcomeAborted', 4: 'KTxOutcomeUnavailable'})]],
    'Tm' : [ 0x13c, ['pointer', ['_KTM']]],
    'CommitReservation' : [ 0x140, ['long long']],
    'TransactionHistory' : [ 0x148, ['array', 10, ['_KTRANSACTION_HISTORY']]],
    'TransactionHistoryCount' : [ 0x198, ['unsigned long']],
    'DTCPrivateInformation' : [ 0x19c, ['pointer', ['void']]],
    'DTCPrivateInformationLength' : [ 0x1a0, ['unsigned long']],
    'DTCPrivateInformationMutex' : [ 0x1a4, ['_KMUTANT']],
    'PromotedTxSelfHandle' : [ 0x1c4, ['pointer', ['void']]],
    'PendingPromotionCount' : [ 0x1c8, ['unsigned long']],
    'PromotionCompletedEvent' : [ 0x1cc, ['_KEVENT']],
} ],
  '_PRIVATE_CACHE_MAP_FLAGS' : [ 0x4, {
    'DontUse' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned long')]],
    'ReadAheadActive' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'ReadAheadEnabled' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'PagePriority' : [ 0x0, ['BitField', dict(start_bit = 18, end_bit = 21, native_type='unsigned long')]],
    'Available' : [ 0x0, ['BitField', dict(start_bit = 21, end_bit = 32, native_type='unsigned long')]],
} ],
  '_CM_KCB_UOW' : [ 0x38, {
    'TransactionListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'KCBLock' : [ 0x8, ['pointer', ['_CM_INTENT_LOCK']]],
    'KeyLock' : [ 0xc, ['pointer', ['_CM_INTENT_LOCK']]],
    'KCBListEntry' : [ 0x10, ['_LIST_ENTRY']],
    'KeyControlBlock' : [ 0x18, ['pointer', ['_CM_KEY_CONTROL_BLOCK']]],
    'Transaction' : [ 0x1c, ['pointer', ['_CM_TRANS']]],
    'UoWState' : [ 0x20, ['unsigned long']],
    'ActionType' : [ 0x24, ['Enumeration', dict(target = 'long', choices = {0: 'UoWAddThisKey', 1: 'UoWAddChildKey', 2: 'UoWDeleteThisKey', 3: 'UoWDeleteChildKey', 4: 'UoWSetValueNew', 5: 'UoWSetValueExisting', 6: 'UoWDeleteValue', 7: 'UoWSetKeyUserFlags', 8: 'UoWSetLastWriteTime', 9: 'UoWSetSecurityDescriptor', 10: 'UoWRenameSubKey', 11: 'UoWRenameOldSubKey', 12: 'UoWRenameNewSubKey', 13: 'UoWIsolation', 14: 'UoWInvalid'})]],
    'StorageType' : [ 0x28, ['Enumeration', dict(target = 'long', choices = {0: 'Stable', 1: 'Volatile', 2: 'InvalidStorage'})]],
    'ChildKCB' : [ 0x30, ['pointer', ['_CM_KEY_CONTROL_BLOCK']]],
    'VolatileKeyCell' : [ 0x30, ['unsigned long']],
    'OldValueCell' : [ 0x30, ['unsigned long']],
    'NewValueCell' : [ 0x34, ['unsigned long']],
    'UserFlags' : [ 0x30, ['unsigned long']],
    'LastWriteTime' : [ 0x30, ['_LARGE_INTEGER']],
    'TxSecurityCell' : [ 0x30, ['unsigned long']],
    'OldChildKCB' : [ 0x30, ['pointer', ['_CM_KEY_CONTROL_BLOCK']]],
    'NewChildKCB' : [ 0x34, ['pointer', ['_CM_KEY_CONTROL_BLOCK']]],
    'OtherChildKCB' : [ 0x30, ['pointer', ['_CM_KEY_CONTROL_BLOCK']]],
    'ThisVolatileKeyCell' : [ 0x34, ['unsigned long']],
} ],
  '_KPROCESSOR_STATE' : [ 0x320, {
    'ContextFrame' : [ 0x0, ['_CONTEXT']],
    'SpecialRegisters' : [ 0x2cc, ['_KSPECIAL_REGISTERS']],
} ],
  '_MMPTE_TRANSITION' : [ 0x4, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Write' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Owner' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'WriteThrough' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'CacheDisable' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 10, native_type='unsigned long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'Transition' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'PageFrameNumber' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 32, native_type='unsigned long')]],
} ],
  '_flags' : [ 0x1, {
    'Removable' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Fill' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 8, native_type='unsigned char')]],
} ],
  '__unnamed_1fd5' : [ 0x8, {
    'Head' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 24, native_type='unsigned long long')]],
    'Tail' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 48, native_type='unsigned long long')]],
    'ActiveThreadCount' : [ 0x0, ['BitField', dict(start_bit = 48, end_bit = 64, native_type='unsigned long long')]],
} ],
  '__unnamed_1fd7' : [ 0x8, {
    's1' : [ 0x0, ['__unnamed_1fd5']],
    'Value' : [ 0x0, ['unsigned long long']],
} ],
  '_ALPC_COMPLETION_LIST_STATE' : [ 0x8, {
    'u1' : [ 0x0, ['__unnamed_1fd7']],
} ],
  '_CM_KEY_SECURITY_CACHE' : [ 0x2c, {
    'Cell' : [ 0x0, ['unsigned long']],
    'ConvKey' : [ 0x4, ['unsigned long']],
    'List' : [ 0x8, ['_LIST_ENTRY']],
    'DescriptorLength' : [ 0x10, ['unsigned long']],
    'RealRefCount' : [ 0x14, ['unsigned long']],
    'Descriptor' : [ 0x18, ['_SECURITY_DESCRIPTOR_RELATIVE']],
} ],
  '_CM_NAME_HASH' : [ 0xc, {
    'ConvKey' : [ 0x0, ['unsigned long']],
    'NextHash' : [ 0x4, ['pointer', ['_CM_NAME_HASH']]],
    'NameLength' : [ 0x8, ['unsigned short']],
    'Name' : [ 0xa, ['array', 1, ['wchar']]],
} ],
  '_MMSECURE_FLAGS' : [ 0x4, {
    'ReadOnly' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'NoWrite' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 12, native_type='unsigned long')]],
} ],
  '_PO_IRP_QUEUE' : [ 0x8, {
    'CurrentIrp' : [ 0x0, ['pointer', ['_IRP']]],
    'PendingIrpList' : [ 0x4, ['pointer', ['_IRP']]],
} ],
  '__unnamed_1fe9' : [ 0x4, {
    'Active' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'OnlyTryAcquireUsed' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ReleasedOutOfOrder' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'SequenceNumber' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
    'Whole' : [ 0x0, ['unsigned long']],
} ],
  '_VI_DEADLOCK_NODE' : [ 0x6c, {
    'Parent' : [ 0x0, ['pointer', ['_VI_DEADLOCK_NODE']]],
    'ChildrenList' : [ 0x4, ['_LIST_ENTRY']],
    'SiblingsList' : [ 0xc, ['_LIST_ENTRY']],
    'ResourceList' : [ 0x14, ['_LIST_ENTRY']],
    'FreeListEntry' : [ 0x14, ['_LIST_ENTRY']],
    'Root' : [ 0x1c, ['pointer', ['_VI_DEADLOCK_RESOURCE']]],
    'ThreadEntry' : [ 0x20, ['pointer', ['_VI_DEADLOCK_THREAD']]],
    'u1' : [ 0x24, ['__unnamed_1fe9']],
    'ChildrenCount' : [ 0x28, ['long']],
    'StackTrace' : [ 0x2c, ['array', 8, ['pointer', ['void']]]],
    'ParentStackTrace' : [ 0x4c, ['array', 8, ['pointer', ['void']]]],
} ],
  'PROCESSOR_IDLESTATE_INFO' : [ 0x8, {
    'TimeCheck' : [ 0x0, ['unsigned long']],
    'DemotePercent' : [ 0x4, ['unsigned char']],
    'PromotePercent' : [ 0x5, ['unsigned char']],
    'Spare' : [ 0x6, ['array', 2, ['unsigned char']]],
} ],
  '_KTMOBJECT_NAMESPACE' : [ 0x60, {
    'Table' : [ 0x0, ['_RTL_AVL_TABLE']],
    'Mutex' : [ 0x38, ['_KMUTANT']],
    'LinksOffset' : [ 0x58, ['unsigned short']],
    'GuidOffset' : [ 0x5a, ['unsigned short']],
    'Expired' : [ 0x5c, ['unsigned char']],
} ],
  '_LPCP_PORT_QUEUE' : [ 0x10, {
    'NonPagedPortQueue' : [ 0x0, ['pointer', ['_LPCP_NONPAGED_PORT_QUEUE']]],
    'Semaphore' : [ 0x4, ['pointer', ['_KSEMAPHORE']]],
    'ReceiveHead' : [ 0x8, ['_LIST_ENTRY']],
} ],
  '_CM_KEY_REFERENCE' : [ 0x8, {
    'KeyCell' : [ 0x0, ['unsigned long']],
    'KeyHive' : [ 0x4, ['pointer', ['_HHIVE']]],
} ],
  'SYSTEM_POWER_LEVEL' : [ 0x18, {
    'Enable' : [ 0x0, ['unsigned char']],
    'Spare' : [ 0x1, ['array', 3, ['unsigned char']]],
    'BatteryLevel' : [ 0x4, ['unsigned long']],
    'PowerPolicy' : [ 0x8, ['POWER_ACTION_POLICY']],
    'MinSystemState' : [ 0x14, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
} ],
  '_OBJECT_DUMP_CONTROL' : [ 0x8, {
    'Stream' : [ 0x0, ['pointer', ['void']]],
    'Detail' : [ 0x4, ['unsigned long']],
} ],
  '_OBJECT_SYMBOLIC_LINK' : [ 0x20, {
    'CreationTime' : [ 0x0, ['_LARGE_INTEGER']],
    'LinkTarget' : [ 0x8, ['_UNICODE_STRING']],
    'LinkTargetRemaining' : [ 0x10, ['_UNICODE_STRING']],
    'LinkTargetObject' : [ 0x18, ['pointer', ['void']]],
    'DosDeviceDriveIndex' : [ 0x1c, ['unsigned long']],
} ],
  '_LPCP_NONPAGED_PORT_QUEUE' : [ 0x18, {
    'Semaphore' : [ 0x0, ['_KSEMAPHORE']],
    'BackPointer' : [ 0x14, ['pointer', ['_LPCP_PORT_OBJECT']]],
} ],
}
