/*****************************************************************************/
/*                                    XDMF                                   */
/*                       eXtensible Data Model and Format                    */
/*                                                                           */
/*  Id : XdmfDSMDescription.hpp                                              */
/*                                                                           */
/*  Author:                                                                  */
/*     Andrew Burns                                                          */
/*     andrew.j.burns2@us.army.mil                                           */
/*     US Army Research Laboratory                                           */
/*     Aberdeen Proving Ground, MD                                           */
/*                                                                           */
/*     Copyright @ 2013 US Army Research Laboratory                          */
/*     All Rights Reserved                                                   */
/*     See Copyright.txt for details                                         */
/*                                                                           */
/*     This software is distributed WITHOUT ANY WARRANTY; without            */
/*     even the implied warranty of MERCHANTABILITY or FITNESS               */
/*     FOR A PARTICULAR PURPOSE.  See the above copyright notice             */
/*     for more information.                                                 */
/*                                                                           */
/*****************************************************************************/
#ifndef XDMFDSMDESCRIPTION_HPP_
#define XDMFDSMDESCRIPTION_HPP_

// C Compatible Includes
#include "XdmfCore.hpp"
#include "XdmfItem.hpp"
#include "XdmfHeavyDataDescription.hpp"

#ifdef __cplusplus

/**
 * @brief Holds information about a dsm buffer so that a process can connect.
 *
 * XdmfDSMDescription stores the information required to connect
 * to an existing DSM buffer
 */
class XDMFCORE_EXPORT XdmfDSMDescription : public XdmfHeavyDataDescription {

public:

  /**
   * 
   */
  static shared_ptr<XdmfDSMDescription> New();

  virtual ~XdmfDSMDescription();

  LOKI_DEFINE_VISITABLE(XdmfDSMDescription, XdmfItem)
  static const std::string ItemTag;

  std::map<std::string, std::string> getItemProperties() const;

  virtual std::string getItemTag() const;

  std::string getPortDescription() const;

  using XdmfItem::insert;

  void setPortDescription(std::string portDesc);

  virtual void traverse(const shared_ptr<XdmfBaseVisitor> visitor);

  XdmfDSMDescription(XdmfDSMDescription &);

protected:

  XdmfDSMDescription();

  virtual void
  populateItem(const std::map<std::string, std::string> & itemProperties,
               const std::vector<shared_ptr<XdmfItem> > & childItems,
               const XdmfCoreReader * const reader);

private:

  XdmfDSMDescription(const XdmfDSMDescription &);  // Not implemented.
  void operator=(const XdmfDSMDescription &);  // Not implemented.

  std::string mPortDescription;
};

#ifdef _WIN32
XDMFCORE_TEMPLATE template class XDMFCORE_EXPORT
shared_ptr<Loki::BaseVisitor>;
XDMFCORE_TEMPLATE template class XDMFCORE_EXPORT
Loki::Visitor<shared_ptr<XdmfDSMDescription>,
              shared_ptr<XdmfItem> >;
#endif

#endif

#ifdef __cplusplus
extern "C" {
#endif

// C wrappers go here

struct XDMFDSMDESCRIPTION; // Simply as a typedef to ensure correct typing
typedef struct XDMFDSMDESCRIPTION XDMFDSMDESCRIPTION;

XDMFCORE_EXPORT XDMFDSMDESCRIPTION * XdmfDSMDescriptionNew();

// C Wrappers for parent classes are generated by macros

XDMF_ITEM_C_CHILD_DECLARE(XdmfDSMDescription, XDMFDSMDESCRIPTION, XDMFCORE)

#ifdef __cplusplus
}
#endif

#endif /* XDMFDSMDESCRIPTION_HPP_ */
