/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.types.Type;

public class ExpressionValue
extends Expression {
    ExpressionValue(Object object, Type type) {
        super(1);
        this.dataType = type;
        this.valueData = object;
    }

    @Override
    public byte getNullability() {
        return this.valueData == null ? (byte)1 : 0;
    }

    @Override
    public String getSQL() {
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                return this.dataType.convertToSQLString(this.valueData);
            }
        }
        throw Error.runtimeError(201, "ExpressionValue");
    }

    @Override
    protected String describe(Session session, int n) {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        switch (this.opType) {
            case 1: {
                stringBuilder.append("VALUE = ").append(this.dataType.convertToSQLString(this.valueData));
                stringBuilder.append(", TYPE = ").append(this.dataType.getNameString());
                return stringBuilder.toString();
            }
        }
        throw Error.runtimeError(201, "ExpressionValue");
    }

    @Override
    Object getValue(Session session, Type type) {
        if (this.dataType == type || this.valueData == null) {
            return this.valueData;
        }
        return type.convertToType(session, this.valueData, this.dataType);
    }

    @Override
    public Object getValue(Session session) {
        return this.valueData;
    }
}

