/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.util;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;

public class CaretVisibilityEnforcerOnFocusGain
implements PropertyChangeListener,
FocusListener {
    private int caretBlinkRate;
    private JTextComponent textComponent;
    private boolean enforceCaretVisibility;

    public CaretVisibilityEnforcerOnFocusGain(JTextComponent textComponent) {
        this.textComponent = textComponent;
        this.enforceCaretVisibility = false;
    }

    public void setEnforceVisibilityOnFocusGain(boolean visible) {
        if (this.enforceCaretVisibility == visible) {
            return;
        }
        this.enforceCaretVisibility = visible;
        if (this.enforceCaretVisibility) {
            this.setupWithCaret(this.textComponent.getCaret());
            this.textComponent.addPropertyChangeListener("caret", this);
        } else {
            this.removeListenersWithCaret(this.textComponent.getCaret());
            this.textComponent.removePropertyChangeListener("caret", this);
        }
    }

    private void setupWithCaret(Caret caret) {
        if (caret != null) {
            this.textComponent.addFocusListener(this);
            this.textComponent.addPropertyChangeListener("editable", this);
            this.caretBlinkRate = caret.getBlinkRate();
            if (!this.textComponent.isEditable()) {
                caret.setBlinkRate(0);
            }
        } else {
            this.caretBlinkRate = 0;
        }
    }

    private void removeListenersWithCaret(Caret caret) {
        if (caret != null) {
            this.textComponent.removeFocusListener(this);
            this.textComponent.removePropertyChangeListener("editable", this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("caret".equals(propertyName)) {
            this.removeListenersWithCaret((Caret)evt.getOldValue());
            this.setupWithCaret((Caret)evt.getNewValue());
        } else if ("editable".equals(propertyName)) {
            if (evt.getNewValue() == Boolean.TRUE) {
                this.textComponent.getCaret().setBlinkRate(this.caretBlinkRate);
            } else {
                this.textComponent.getCaret().setBlinkRate(0);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.textComponent.getCaret().setVisible(true);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }
}

