/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.view.widgets.WritableFileChooser;

public class TableExportAction<T extends JTable>
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(TableExportAction.class);
    private static final String CSV_EXTENSION = ".csv";
    private static String defaultText;
    private static Icon defaultIcon;
    private T exportTable;

    public TableExportAction(T table) {
        this(table, TableExportAction.getDefaultText(), TableExportAction.getDefaultIcon());
    }

    public TableExportAction(T table, String name) {
        this(table, name, TableExportAction.getDefaultIcon());
    }

    public TableExportAction(T table, String name, Icon icon) {
        super(name, icon);
        this.exportTable = table;
    }

    public static String getDefaultText() {
        if (defaultText == null) {
            defaultText = Constant.messages.getString("export.button.name");
        }
        return defaultText;
    }

    public static Icon getDefaultIcon() {
        if (defaultIcon == null) {
            defaultIcon = new ImageIcon(TableExportAction.class.getResource("/resource/icon/16/115.png"));
        }
        return defaultIcon;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        WritableFileChooser chooser = new WritableFileChooser(Model.getSingleton().getOptionsParam().getUserDirectory()){
            private static final long serialVersionUID = 1L;

            @Override
            public void approveSelection() {
                String filePath;
                File file = this.getSelectedFile();
                if (file != null && !(filePath = file.getAbsolutePath()).toLowerCase(Locale.ROOT).endsWith(TableExportAction.CSV_EXTENSION)) {
                    this.setSelectedFile(new File(filePath + TableExportAction.CSV_EXTENSION));
                }
                super.approveSelection();
            }
        };
        chooser.setSelectedFile(new File(Constant.messages.getString("export.button.default.filename")));
        if (chooser.showSaveDialog(View.getSingleton().getMainFrame()) == 0) {
            boolean success = true;
            try (CSVPrinter pw = new CSVPrinter((Appendable)Files.newBufferedWriter(chooser.getSelectedFile().toPath(), StandardCharsets.UTF_8, new OpenOption[0]), CSVFormat.DEFAULT);){
                pw.printRecord(this.getColumnNames());
                int rowCount = ((JTable)this.getTable()).getRowCount();
                for (int row = 0; row < rowCount; ++row) {
                    pw.printRecord(this.getRowCells(row));
                }
            }
            catch (Exception ex) {
                success = false;
                JOptionPane.showMessageDialog(View.getSingleton().getMainFrame(), Constant.messages.getString("export.button.error") + "\n" + ex.getMessage());
                LOGGER.error("Export Failed: " + ex.getMessage(), (Throwable)ex);
            }
            if (success) {
                JOptionPane.showMessageDialog(View.getSingleton().getMainFrame(), Constant.messages.getString("export.button.success"));
            }
        }
    }

    protected List<String> getColumnNames() {
        ArrayList<String> columnNamesList = new ArrayList<String>();
        for (int col = 0; col < ((JTable)this.getTable()).getColumnCount(); ++col) {
            columnNamesList.add(((JTable)this.getTable()).getColumnModel().getColumn(col).getHeaderValue().toString());
        }
        return columnNamesList;
    }

    protected List<Object> getRowCells(int row) {
        ArrayList<Object> cells = new ArrayList<Object>();
        for (int col = 0; col < ((JTable)this.getTable()).getColumnCount(); ++col) {
            Object value = ((JTable)this.getTable()).getValueAt(row, col);
            cells.add(value == null ? "" : value.toString());
        }
        return cells;
    }

    protected T getTable() {
        return this.exportTable;
    }

    public void setTable(T table) {
        this.exportTable = table;
    }
}

