/*
 * Decompiled with CFR 0.152.
 */
package sun.security.acl;

import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.AclEntry;
import java.security.acl.Group;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.security.acl.AclEnumerator;
import sun.security.acl.OwnerImpl;

public class AclImpl
extends OwnerImpl
implements Acl {
    private Hashtable<Principal, AclEntry> allowedUsersTable = new Hashtable(23);
    private Hashtable<Principal, AclEntry> allowedGroupsTable = new Hashtable(23);
    private Hashtable<Principal, AclEntry> deniedUsersTable = new Hashtable(23);
    private Hashtable<Principal, AclEntry> deniedGroupsTable = new Hashtable(23);
    private String aclName = null;
    private Vector<Permission> zeroSet = new Vector(1, 1);

    public AclImpl(Principal owner, String name) {
        super(owner);
        try {
            this.setName(owner, name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setName(Principal caller, String name) throws NotOwnerException {
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        this.aclName = name;
    }

    @Override
    public String getName() {
        return this.aclName;
    }

    @Override
    public synchronized boolean addEntry(Principal caller, AclEntry entry) throws NotOwnerException {
        Principal key;
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        Hashtable<Principal, AclEntry> aclTable = this.findTable(entry);
        if (aclTable.get(key = entry.getPrincipal()) != null) {
            return false;
        }
        aclTable.put(key, entry);
        return true;
    }

    @Override
    public synchronized boolean removeEntry(Principal caller, AclEntry entry) throws NotOwnerException {
        Principal key;
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        Hashtable<Principal, AclEntry> aclTable = this.findTable(entry);
        AclEntry o = aclTable.remove(key = entry.getPrincipal());
        return o != null;
    }

    @Override
    public synchronized Enumeration<Permission> getPermissions(Principal user) {
        Enumeration<Permission> groupPositive = this.subtract(this.getGroupPositive(user), this.getGroupNegative(user));
        Enumeration<Permission> groupNegative = this.subtract(this.getGroupNegative(user), this.getGroupPositive(user));
        Enumeration<Permission> individualPositive = this.subtract(this.getIndividualPositive(user), this.getIndividualNegative(user));
        Enumeration<Permission> individualNegative = this.subtract(this.getIndividualNegative(user), this.getIndividualPositive(user));
        Enumeration<Permission> temp1 = this.subtract(groupPositive, individualNegative);
        Enumeration<Permission> netPositive = AclImpl.union(individualPositive, temp1);
        individualPositive = this.subtract(this.getIndividualPositive(user), this.getIndividualNegative(user));
        individualNegative = this.subtract(this.getIndividualNegative(user), this.getIndividualPositive(user));
        temp1 = this.subtract(groupNegative, individualPositive);
        Enumeration<Permission> netNegative = AclImpl.union(individualNegative, temp1);
        return this.subtract(netPositive, netNegative);
    }

    @Override
    public boolean checkPermission(Principal principal, Permission permission) {
        Enumeration<Permission> permSet = this.getPermissions(principal);
        while (permSet.hasMoreElements()) {
            Permission p = permSet.nextElement();
            if (!p.equals(permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Enumeration<AclEntry> entries() {
        return new AclEnumerator(this, this.allowedUsersTable, this.allowedGroupsTable, this.deniedUsersTable, this.deniedGroupsTable);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        Enumeration<AclEntry> entries = this.entries();
        while (entries.hasMoreElements()) {
            AclEntry entry = entries.nextElement();
            sb.append(entry.toString().trim());
            sb.append("\n");
        }
        return sb.toString();
    }

    private Hashtable<Principal, AclEntry> findTable(AclEntry entry) {
        Hashtable<Principal, AclEntry> aclTable = null;
        Principal p = entry.getPrincipal();
        aclTable = p instanceof Group ? (entry.isNegative() ? this.deniedGroupsTable : this.allowedGroupsTable) : (entry.isNegative() ? this.deniedUsersTable : this.allowedUsersTable);
        return aclTable;
    }

    private static Enumeration<Permission> union(Enumeration<Permission> e1, Enumeration<Permission> e2) {
        Vector<Permission> v = new Vector<Permission>(20, 20);
        while (e1.hasMoreElements()) {
            v.addElement(e1.nextElement());
        }
        while (e2.hasMoreElements()) {
            Permission o = e2.nextElement();
            if (v.contains(o)) continue;
            v.addElement(o);
        }
        return v.elements();
    }

    private Enumeration<Permission> subtract(Enumeration<Permission> e1, Enumeration<Permission> e2) {
        Vector<Permission> v = new Vector<Permission>(20, 20);
        while (e1.hasMoreElements()) {
            v.addElement(e1.nextElement());
        }
        while (e2.hasMoreElements()) {
            Permission o = e2.nextElement();
            if (!v.contains(o)) continue;
            v.removeElement(o);
        }
        return v.elements();
    }

    private Enumeration<Permission> getGroupPositive(Principal user) {
        Enumeration<Permission> groupPositive = this.zeroSet.elements();
        Enumeration<Principal> e = this.allowedGroupsTable.keys();
        while (e.hasMoreElements()) {
            Group g = (Group)e.nextElement();
            if (!g.isMember(user)) continue;
            AclEntry ae = this.allowedGroupsTable.get(g);
            groupPositive = AclImpl.union(ae.permissions(), groupPositive);
        }
        return groupPositive;
    }

    private Enumeration<Permission> getGroupNegative(Principal user) {
        Enumeration<Permission> groupNegative = this.zeroSet.elements();
        Enumeration<Principal> e = this.deniedGroupsTable.keys();
        while (e.hasMoreElements()) {
            Group g = (Group)e.nextElement();
            if (!g.isMember(user)) continue;
            AclEntry ae = this.deniedGroupsTable.get(g);
            groupNegative = AclImpl.union(ae.permissions(), groupNegative);
        }
        return groupNegative;
    }

    private Enumeration<Permission> getIndividualPositive(Principal user) {
        Enumeration<Permission> individualPositive = this.zeroSet.elements();
        AclEntry ae = this.allowedUsersTable.get(user);
        if (ae != null) {
            individualPositive = ae.permissions();
        }
        return individualPositive;
    }

    private Enumeration<Permission> getIndividualNegative(Principal user) {
        Enumeration<Permission> individualNegative = this.zeroSet.elements();
        AclEntry ae = this.deniedUsersTable.get(user);
        if (ae != null) {
            individualNegative = ae.permissions();
        }
        return individualNegative;
    }
}

