/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11.wrapper;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.CK_INFO;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_MECHANISM_INFO;
import sun.security.pkcs11.wrapper.CK_NOTIFY;
import sun.security.pkcs11.wrapper.CK_SESSION_INFO;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class PKCS11 {
    private static final String PKCS11_WRAPPER = "j2pkcs11";
    private final String pkcs11ModulePath;
    private long pNativeData;
    private static final Map<String, PKCS11> moduleMap;

    public static void loadNative() {
    }

    public static native long freeMechanism(long var0);

    private static native void initializeLibrary();

    private static native void finalizeLibrary();

    PKCS11(String string, String string2) throws IOException {
        this.connect(string, string2);
        this.pkcs11ModulePath = string;
    }

    public static synchronized PKCS11 getInstance(String string, String string2, CK_C_INITIALIZE_ARGS cK_C_INITIALIZE_ARGS, boolean bl) throws IOException, PKCS11Exception {
        PKCS11 pKCS11 = moduleMap.get(string);
        if (pKCS11 == null) {
            block4: {
                pKCS11 = cK_C_INITIALIZE_ARGS != null && (cK_C_INITIALIZE_ARGS.flags & 2L) != 0L ? new PKCS11(string, string2) : new SynchronizedPKCS11(string, string2);
                if (!bl) {
                    try {
                        pKCS11.C_Initialize(cK_C_INITIALIZE_ARGS);
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        if (pKCS11Exception.getErrorCode() == 401L) break block4;
                        throw pKCS11Exception;
                    }
                }
            }
            moduleMap.put(string, pKCS11);
        }
        return pKCS11;
    }

    private native void connect(String var1, String var2) throws IOException;

    private native void disconnect();

    native void C_Initialize(Object var1) throws PKCS11Exception;

    public native void C_Finalize(Object var1) throws PKCS11Exception;

    public native CK_INFO C_GetInfo() throws PKCS11Exception;

    public native long[] C_GetSlotList(boolean var1) throws PKCS11Exception;

    public native CK_SLOT_INFO C_GetSlotInfo(long var1) throws PKCS11Exception;

    public native CK_TOKEN_INFO C_GetTokenInfo(long var1) throws PKCS11Exception;

    public native long[] C_GetMechanismList(long var1) throws PKCS11Exception;

    public native CK_MECHANISM_INFO C_GetMechanismInfo(long var1, long var3) throws PKCS11Exception;

    public native long C_OpenSession(long var1, long var3, Object var5, CK_NOTIFY var6) throws PKCS11Exception;

    public native void C_CloseSession(long var1) throws PKCS11Exception;

    public native CK_SESSION_INFO C_GetSessionInfo(long var1) throws PKCS11Exception;

    public native byte[] C_GetOperationState(long var1) throws PKCS11Exception;

    public native void C_SetOperationState(long var1, byte[] var3, long var4, long var6) throws PKCS11Exception;

    public native void C_Login(long var1, long var3, char[] var5) throws PKCS11Exception;

    public native void C_Logout(long var1) throws PKCS11Exception;

    public native long C_CreateObject(long var1, CK_ATTRIBUTE[] var3) throws PKCS11Exception;

    public native long C_CopyObject(long var1, long var3, CK_ATTRIBUTE[] var5) throws PKCS11Exception;

    public native void C_DestroyObject(long var1, long var3) throws PKCS11Exception;

    public native void C_GetAttributeValue(long var1, long var3, CK_ATTRIBUTE[] var5) throws PKCS11Exception;

    public native void C_SetAttributeValue(long var1, long var3, CK_ATTRIBUTE[] var5) throws PKCS11Exception;

    public native void C_FindObjectsInit(long var1, CK_ATTRIBUTE[] var3) throws PKCS11Exception;

    public native long[] C_FindObjects(long var1, long var3) throws PKCS11Exception;

    public native void C_FindObjectsFinal(long var1) throws PKCS11Exception;

    public native void C_EncryptInit(long var1, CK_MECHANISM var3, long var4) throws PKCS11Exception;

    public native int C_Encrypt(long var1, long var3, byte[] var5, int var6, int var7, long var8, byte[] var10, int var11, int var12) throws PKCS11Exception;

    public native int C_EncryptUpdate(long var1, long var3, byte[] var5, int var6, int var7, long var8, byte[] var10, int var11, int var12) throws PKCS11Exception;

    public native int C_EncryptFinal(long var1, long var3, byte[] var5, int var6, int var7) throws PKCS11Exception;

    public native void C_DecryptInit(long var1, CK_MECHANISM var3, long var4) throws PKCS11Exception;

    public native int C_Decrypt(long var1, long var3, byte[] var5, int var6, int var7, long var8, byte[] var10, int var11, int var12) throws PKCS11Exception;

    public native int C_DecryptUpdate(long var1, long var3, byte[] var5, int var6, int var7, long var8, byte[] var10, int var11, int var12) throws PKCS11Exception;

    public native int C_DecryptFinal(long var1, long var3, byte[] var5, int var6, int var7) throws PKCS11Exception;

    public native void C_DigestInit(long var1, CK_MECHANISM var3) throws PKCS11Exception;

    public native int C_DigestSingle(long var1, CK_MECHANISM var3, byte[] var4, int var5, int var6, byte[] var7, int var8, int var9) throws PKCS11Exception;

    public native void C_DigestUpdate(long var1, long var3, byte[] var5, int var6, int var7) throws PKCS11Exception;

    public native void C_DigestKey(long var1, long var3) throws PKCS11Exception;

    public native int C_DigestFinal(long var1, byte[] var3, int var4, int var5) throws PKCS11Exception;

    public native void C_SignInit(long var1, CK_MECHANISM var3, long var4) throws PKCS11Exception;

    public native byte[] C_Sign(long var1, byte[] var3) throws PKCS11Exception;

    public native void C_SignUpdate(long var1, long var3, byte[] var5, int var6, int var7) throws PKCS11Exception;

    public native byte[] C_SignFinal(long var1, int var3) throws PKCS11Exception;

    public native void C_SignRecoverInit(long var1, CK_MECHANISM var3, long var4) throws PKCS11Exception;

    public native int C_SignRecover(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8) throws PKCS11Exception;

    public native void C_VerifyInit(long var1, CK_MECHANISM var3, long var4) throws PKCS11Exception;

    public native void C_Verify(long var1, byte[] var3, byte[] var4) throws PKCS11Exception;

    public native void C_VerifyUpdate(long var1, long var3, byte[] var5, int var6, int var7) throws PKCS11Exception;

    public native void C_VerifyFinal(long var1, byte[] var3) throws PKCS11Exception;

    public native void C_VerifyRecoverInit(long var1, CK_MECHANISM var3, long var4) throws PKCS11Exception;

    public native int C_VerifyRecover(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8) throws PKCS11Exception;

    public native byte[] getNativeKeyInfo(long var1, long var3, long var5, CK_MECHANISM var7) throws PKCS11Exception;

    public native long createNativeKey(long var1, byte[] var3, long var4, CK_MECHANISM var6) throws PKCS11Exception;

    public native long C_GenerateKey(long var1, CK_MECHANISM var3, CK_ATTRIBUTE[] var4) throws PKCS11Exception;

    public native long[] C_GenerateKeyPair(long var1, CK_MECHANISM var3, CK_ATTRIBUTE[] var4, CK_ATTRIBUTE[] var5) throws PKCS11Exception;

    public native byte[] C_WrapKey(long var1, CK_MECHANISM var3, long var4, long var6) throws PKCS11Exception;

    public native long C_UnwrapKey(long var1, CK_MECHANISM var3, long var4, byte[] var6, CK_ATTRIBUTE[] var7) throws PKCS11Exception;

    public native long C_DeriveKey(long var1, CK_MECHANISM var3, long var4, CK_ATTRIBUTE[] var6) throws PKCS11Exception;

    public native void C_SeedRandom(long var1, byte[] var3) throws PKCS11Exception;

    public native void C_GenerateRandom(long var1, byte[] var3) throws PKCS11Exception;

    public String toString() {
        return "Module name: " + this.pkcs11ModulePath;
    }

    protected void finalize() throws Throwable {
        this.disconnect();
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.loadLibrary(PKCS11.PKCS11_WRAPPER);
                return null;
            }
        });
        PKCS11.initializeLibrary();
        moduleMap = new HashMap<String, PKCS11>();
    }

    static class SynchronizedPKCS11
    extends PKCS11 {
        SynchronizedPKCS11(String string, String string2) throws IOException {
            super(string, string2);
        }

        @Override
        synchronized void C_Initialize(Object object) throws PKCS11Exception {
            super.C_Initialize(object);
        }

        @Override
        public synchronized void C_Finalize(Object object) throws PKCS11Exception {
            super.C_Finalize(object);
        }

        @Override
        public synchronized CK_INFO C_GetInfo() throws PKCS11Exception {
            return super.C_GetInfo();
        }

        @Override
        public synchronized long[] C_GetSlotList(boolean bl) throws PKCS11Exception {
            return super.C_GetSlotList(bl);
        }

        @Override
        public synchronized CK_SLOT_INFO C_GetSlotInfo(long l) throws PKCS11Exception {
            return super.C_GetSlotInfo(l);
        }

        @Override
        public synchronized CK_TOKEN_INFO C_GetTokenInfo(long l) throws PKCS11Exception {
            return super.C_GetTokenInfo(l);
        }

        @Override
        public synchronized long[] C_GetMechanismList(long l) throws PKCS11Exception {
            return super.C_GetMechanismList(l);
        }

        @Override
        public synchronized CK_MECHANISM_INFO C_GetMechanismInfo(long l, long l2) throws PKCS11Exception {
            return super.C_GetMechanismInfo(l, l2);
        }

        @Override
        public synchronized long C_OpenSession(long l, long l2, Object object, CK_NOTIFY cK_NOTIFY) throws PKCS11Exception {
            return super.C_OpenSession(l, l2, object, cK_NOTIFY);
        }

        @Override
        public synchronized void C_CloseSession(long l) throws PKCS11Exception {
            super.C_CloseSession(l);
        }

        @Override
        public synchronized CK_SESSION_INFO C_GetSessionInfo(long l) throws PKCS11Exception {
            return super.C_GetSessionInfo(l);
        }

        @Override
        public synchronized void C_Login(long l, long l2, char[] cArray) throws PKCS11Exception {
            super.C_Login(l, l2, cArray);
        }

        @Override
        public synchronized void C_Logout(long l) throws PKCS11Exception {
            super.C_Logout(l);
        }

        @Override
        public synchronized long C_CreateObject(long l, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
            return super.C_CreateObject(l, cK_ATTRIBUTEArray);
        }

        @Override
        public synchronized long C_CopyObject(long l, long l2, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
            return super.C_CopyObject(l, l2, cK_ATTRIBUTEArray);
        }

        @Override
        public synchronized void C_DestroyObject(long l, long l2) throws PKCS11Exception {
            super.C_DestroyObject(l, l2);
        }

        @Override
        public synchronized void C_GetAttributeValue(long l, long l2, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
            super.C_GetAttributeValue(l, l2, cK_ATTRIBUTEArray);
        }

        @Override
        public synchronized void C_SetAttributeValue(long l, long l2, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
            super.C_SetAttributeValue(l, l2, cK_ATTRIBUTEArray);
        }

        @Override
        public synchronized void C_FindObjectsInit(long l, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
            super.C_FindObjectsInit(l, cK_ATTRIBUTEArray);
        }

        @Override
        public synchronized long[] C_FindObjects(long l, long l2) throws PKCS11Exception {
            return super.C_FindObjects(l, l2);
        }

        @Override
        public synchronized void C_FindObjectsFinal(long l) throws PKCS11Exception {
            super.C_FindObjectsFinal(l);
        }

        @Override
        public synchronized void C_EncryptInit(long l, CK_MECHANISM cK_MECHANISM, long l2) throws PKCS11Exception {
            super.C_EncryptInit(l, cK_MECHANISM, l2);
        }

        @Override
        public synchronized int C_Encrypt(long l, long l2, byte[] byArray, int n, int n2, long l3, byte[] byArray2, int n3, int n4) throws PKCS11Exception {
            return super.C_Encrypt(l, l2, byArray, n, n2, l3, byArray2, n3, n4);
        }

        @Override
        public synchronized int C_EncryptUpdate(long l, long l2, byte[] byArray, int n, int n2, long l3, byte[] byArray2, int n3, int n4) throws PKCS11Exception {
            return super.C_EncryptUpdate(l, l2, byArray, n, n2, l3, byArray2, n3, n4);
        }

        @Override
        public synchronized int C_EncryptFinal(long l, long l2, byte[] byArray, int n, int n2) throws PKCS11Exception {
            return super.C_EncryptFinal(l, l2, byArray, n, n2);
        }

        @Override
        public synchronized void C_DecryptInit(long l, CK_MECHANISM cK_MECHANISM, long l2) throws PKCS11Exception {
            super.C_DecryptInit(l, cK_MECHANISM, l2);
        }

        @Override
        public synchronized int C_Decrypt(long l, long l2, byte[] byArray, int n, int n2, long l3, byte[] byArray2, int n3, int n4) throws PKCS11Exception {
            return super.C_Decrypt(l, l2, byArray, n, n2, l3, byArray2, n3, n4);
        }

        @Override
        public synchronized int C_DecryptUpdate(long l, long l2, byte[] byArray, int n, int n2, long l3, byte[] byArray2, int n3, int n4) throws PKCS11Exception {
            return super.C_DecryptUpdate(l, l2, byArray, n, n2, l3, byArray2, n3, n4);
        }

        @Override
        public synchronized int C_DecryptFinal(long l, long l2, byte[] byArray, int n, int n2) throws PKCS11Exception {
            return super.C_DecryptFinal(l, l2, byArray, n, n2);
        }

        @Override
        public synchronized void C_DigestInit(long l, CK_MECHANISM cK_MECHANISM) throws PKCS11Exception {
            super.C_DigestInit(l, cK_MECHANISM);
        }

        @Override
        public synchronized int C_DigestSingle(long l, CK_MECHANISM cK_MECHANISM, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws PKCS11Exception {
            return super.C_DigestSingle(l, cK_MECHANISM, byArray, n, n2, byArray2, n3, n4);
        }

        @Override
        public synchronized void C_DigestUpdate(long l, long l2, byte[] byArray, int n, int n2) throws PKCS11Exception {
            super.C_DigestUpdate(l, l2, byArray, n, n2);
        }

        @Override
        public synchronized void C_DigestKey(long l, long l2) throws PKCS11Exception {
            super.C_DigestKey(l, l2);
        }

        @Override
        public synchronized int C_DigestFinal(long l, byte[] byArray, int n, int n2) throws PKCS11Exception {
            return super.C_DigestFinal(l, byArray, n, n2);
        }

        @Override
        public synchronized void C_SignInit(long l, CK_MECHANISM cK_MECHANISM, long l2) throws PKCS11Exception {
            super.C_SignInit(l, cK_MECHANISM, l2);
        }

        @Override
        public synchronized byte[] C_Sign(long l, byte[] byArray) throws PKCS11Exception {
            return super.C_Sign(l, byArray);
        }

        @Override
        public synchronized void C_SignUpdate(long l, long l2, byte[] byArray, int n, int n2) throws PKCS11Exception {
            super.C_SignUpdate(l, l2, byArray, n, n2);
        }

        @Override
        public synchronized byte[] C_SignFinal(long l, int n) throws PKCS11Exception {
            return super.C_SignFinal(l, n);
        }

        @Override
        public synchronized void C_SignRecoverInit(long l, CK_MECHANISM cK_MECHANISM, long l2) throws PKCS11Exception {
            super.C_SignRecoverInit(l, cK_MECHANISM, l2);
        }

        @Override
        public synchronized int C_SignRecover(long l, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws PKCS11Exception {
            return super.C_SignRecover(l, byArray, n, n2, byArray2, n3, n4);
        }

        @Override
        public synchronized void C_VerifyInit(long l, CK_MECHANISM cK_MECHANISM, long l2) throws PKCS11Exception {
            super.C_VerifyInit(l, cK_MECHANISM, l2);
        }

        @Override
        public synchronized void C_Verify(long l, byte[] byArray, byte[] byArray2) throws PKCS11Exception {
            super.C_Verify(l, byArray, byArray2);
        }

        @Override
        public synchronized void C_VerifyUpdate(long l, long l2, byte[] byArray, int n, int n2) throws PKCS11Exception {
            super.C_VerifyUpdate(l, l2, byArray, n, n2);
        }

        @Override
        public synchronized void C_VerifyFinal(long l, byte[] byArray) throws PKCS11Exception {
            super.C_VerifyFinal(l, byArray);
        }

        @Override
        public synchronized void C_VerifyRecoverInit(long l, CK_MECHANISM cK_MECHANISM, long l2) throws PKCS11Exception {
            super.C_VerifyRecoverInit(l, cK_MECHANISM, l2);
        }

        @Override
        public synchronized int C_VerifyRecover(long l, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws PKCS11Exception {
            return super.C_VerifyRecover(l, byArray, n, n2, byArray2, n3, n4);
        }

        @Override
        public synchronized long C_GenerateKey(long l, CK_MECHANISM cK_MECHANISM, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
            return super.C_GenerateKey(l, cK_MECHANISM, cK_ATTRIBUTEArray);
        }

        @Override
        public synchronized long[] C_GenerateKeyPair(long l, CK_MECHANISM cK_MECHANISM, CK_ATTRIBUTE[] cK_ATTRIBUTEArray, CK_ATTRIBUTE[] cK_ATTRIBUTEArray2) throws PKCS11Exception {
            return super.C_GenerateKeyPair(l, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        }

        @Override
        public synchronized byte[] C_WrapKey(long l, CK_MECHANISM cK_MECHANISM, long l2, long l3) throws PKCS11Exception {
            return super.C_WrapKey(l, cK_MECHANISM, l2, l3);
        }

        @Override
        public synchronized long C_UnwrapKey(long l, CK_MECHANISM cK_MECHANISM, long l2, byte[] byArray, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
            return super.C_UnwrapKey(l, cK_MECHANISM, l2, byArray, cK_ATTRIBUTEArray);
        }

        @Override
        public synchronized long C_DeriveKey(long l, CK_MECHANISM cK_MECHANISM, long l2, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
            return super.C_DeriveKey(l, cK_MECHANISM, l2, cK_ATTRIBUTEArray);
        }

        @Override
        public synchronized void C_SeedRandom(long l, byte[] byArray) throws PKCS11Exception {
            super.C_SeedRandom(l, byArray);
        }

        @Override
        public synchronized void C_GenerateRandom(long l, byte[] byArray) throws PKCS11Exception {
            super.C_GenerateRandom(l, byArray);
        }
    }
}

