/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import sun.awt.SunToolkit;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.SurfaceType;
import sun.java2d.loops.TransformBlit;
import sun.java2d.pipe.Region;
import sun.java2d.xr.XRCompositeManager;
import sun.java2d.xr.XRMaskImage;
import sun.java2d.xr.XRSurfaceData;
import sun.java2d.xr.XRUtils;

class XRPMTransformedBlit
extends TransformBlit {
    final Rectangle compositeBounds = new Rectangle();
    final double[] srcCoords = new double[8];
    final double[] dstCoords = new double[8];

    public XRPMTransformedBlit(SurfaceType surfaceType, SurfaceType surfaceType2) {
        super(surfaceType, CompositeType.AnyAlpha, surfaceType2);
    }

    protected void adjustCompositeBounds(boolean bl, AffineTransform affineTransform, int n, int n2, int n3, int n4) {
        double d;
        double d2;
        double d3;
        double d4;
        this.srcCoords[0] = n;
        this.srcCoords[1] = n2;
        this.srcCoords[2] = n + n3;
        this.srcCoords[3] = n2 + n4;
        if (bl) {
            affineTransform.transform(this.srcCoords, 0, this.dstCoords, 0, 2);
            d4 = Math.min(this.dstCoords[0], this.dstCoords[2]);
            d3 = Math.min(this.dstCoords[1], this.dstCoords[3]);
            d2 = Math.max(this.dstCoords[0], this.dstCoords[2]);
            d = Math.max(this.dstCoords[1], this.dstCoords[3]);
            d4 = Math.ceil(d4 - 0.5);
            d3 = Math.ceil(d3 - 0.5);
            d2 = Math.ceil(d2 - 0.5);
            d = Math.ceil(d - 0.5);
        } else {
            this.srcCoords[4] = n;
            this.srcCoords[5] = n2 + n4;
            this.srcCoords[6] = n + n3;
            this.srcCoords[7] = n2;
            affineTransform.transform(this.srcCoords, 0, this.dstCoords, 0, 4);
            d4 = Math.min(this.dstCoords[0], Math.min(this.dstCoords[2], Math.min(this.dstCoords[4], this.dstCoords[6])));
            d3 = Math.min(this.dstCoords[1], Math.min(this.dstCoords[3], Math.min(this.dstCoords[5], this.dstCoords[7])));
            d2 = Math.max(this.dstCoords[0], Math.max(this.dstCoords[2], Math.max(this.dstCoords[4], this.dstCoords[6])));
            d = Math.max(this.dstCoords[1], Math.max(this.dstCoords[3], Math.max(this.dstCoords[5], this.dstCoords[7])));
            d4 = Math.floor(d4);
            d3 = Math.floor(d3);
            d2 = Math.ceil(d2);
            d = Math.ceil(d);
        }
        this.compositeBounds.x = (int)d4;
        this.compositeBounds.y = (int)d3;
        this.compositeBounds.width = (int)(d2 - d4);
        this.compositeBounds.height = (int)(d - d3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Transform(SurfaceData surfaceData, SurfaceData surfaceData2, Composite composite, Region region, AffineTransform affineTransform, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        try {
            SunToolkit.awtLock();
            XRSurfaceData xRSurfaceData = (XRSurfaceData)surfaceData2;
            XRSurfaceData xRSurfaceData2 = (XRSurfaceData)surfaceData;
            XRCompositeManager xRCompositeManager = XRCompositeManager.getInstance(xRSurfaceData2);
            float f = ((AlphaComposite)composite).getAlpha();
            int n8 = XRUtils.ATransOpToXRQuality(n);
            boolean bl = XRUtils.isTransformQuadrantRotated(affineTransform);
            this.adjustCompositeBounds(bl, affineTransform, n4, n5, n6, n7);
            xRSurfaceData.validateAsDestination(null, region);
            xRSurfaceData.maskBuffer.validateCompositeState(composite, null, null, null);
            AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(-this.compositeBounds.x, -this.compositeBounds.y);
            affineTransform2.concatenate(affineTransform);
            AffineTransform affineTransform3 = (AffineTransform)affineTransform2.clone();
            affineTransform2.translate(-n2, -n3);
            try {
                affineTransform2.invert();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                affineTransform2.setToIdentity();
            }
            if (!(n8 == 0 || bl && f == 1.0f)) {
                XRMaskImage xRMaskImage = xRSurfaceData2.maskBuffer.getMaskImage();
                int n9 = bl ? xRCompositeManager.getExtraAlphaMask() : xRMaskImage.prepareBlitMask(xRSurfaceData, affineTransform3, n6, n7);
                xRSurfaceData2.validateAsSource(affineTransform2, 2, n8);
                xRSurfaceData.maskBuffer.con.renderComposite(xRCompositeManager.getCompRule(), xRSurfaceData2.picture, n9, xRSurfaceData.picture, 0, 0, 0, 0, this.compositeBounds.x, this.compositeBounds.y, this.compositeBounds.width, this.compositeBounds.height);
            } else {
                int n10 = n8 == 0 ? 0 : 2;
                xRSurfaceData2.validateAsSource(affineTransform2, n10, n8);
                xRSurfaceData.maskBuffer.compositeBlit(xRSurfaceData2, xRSurfaceData, 0, 0, this.compositeBounds.x, this.compositeBounds.y, this.compositeBounds.width, this.compositeBounds.height);
            }
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }
}

