/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.runtime;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.server.LogStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import sun.security.action.GetPropertyAction;

public abstract class Log {
    public static final Level BRIEF = Level.FINE;
    public static final Level VERBOSE = Level.FINER;
    private static final LogFactory logFactory;

    public abstract boolean isLoggable(Level var1);

    public abstract void log(Level var1, String var2);

    public abstract void log(Level var1, String var2, Throwable var3);

    public abstract void setOutputStream(OutputStream var1);

    public abstract PrintStream getPrintStream();

    public static Log getLog(String string, String string2, int n) {
        Level level = n < 0 ? null : (n == 0 ? Level.OFF : (n > 0 && n <= 10 ? BRIEF : (n > 10 && n <= 20 ? VERBOSE : Level.FINEST)));
        return logFactory.createLog(string, string2, level);
    }

    public static Log getLog(String string, String string2, boolean bl) {
        Level level = bl ? VERBOSE : null;
        return logFactory.createLog(string, string2, level);
    }

    private static String[] getSource() {
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        return new String[]{stackTraceElementArray[3].getClassName(), stackTraceElementArray[3].getMethodName()};
    }

    static {
        boolean bl = Boolean.valueOf(AccessController.doPrivileged(new GetPropertyAction("sun.rmi.log.useOld")));
        logFactory = bl ? new LogStreamLogFactory() : new LoggerLogFactory();
    }

    private static class LogStreamLog
    extends Log {
        private final LogStream stream;
        private int levelValue = Level.OFF.intValue();

        private LogStreamLog(LogStream logStream, Level level) {
            if (logStream != null && level != null) {
                this.levelValue = level.intValue();
            }
            this.stream = logStream;
        }

        @Override
        public synchronized boolean isLoggable(Level level) {
            return level.intValue() >= this.levelValue;
        }

        @Override
        public void log(Level level, String string) {
            if (this.isLoggable(level)) {
                String[] stringArray = Log.getSource();
                this.stream.println(LogStreamLog.unqualifiedName(stringArray[0]) + "." + stringArray[1] + ": " + string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void log(Level level, String string, Throwable throwable) {
            if (this.isLoggable(level)) {
                LogStream logStream = this.stream;
                synchronized (logStream) {
                    String[] stringArray = Log.getSource();
                    this.stream.println(LogStreamLog.unqualifiedName(stringArray[0]) + "." + stringArray[1] + ": " + string);
                    throwable.printStackTrace(this.stream);
                }
            }
        }

        @Override
        public PrintStream getPrintStream() {
            return this.stream;
        }

        @Override
        public synchronized void setOutputStream(OutputStream outputStream) {
            if (outputStream != null) {
                if (VERBOSE.intValue() < this.levelValue) {
                    this.levelValue = VERBOSE.intValue();
                }
                this.stream.setOutputStream(outputStream);
            } else {
                this.levelValue = Level.OFF.intValue();
            }
        }

        private static String unqualifiedName(String string) {
            int n = string.lastIndexOf(".");
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            string = string.replace('$', '.');
            return string;
        }
    }

    private static class LogStreamLogFactory
    implements LogFactory {
        LogStreamLogFactory() {
        }

        @Override
        public Log createLog(String string, String string2, Level level) {
            LogStream logStream = null;
            if (string2 != null) {
                logStream = LogStream.log(string2);
            }
            return new LogStreamLog(logStream, level);
        }
    }

    private static class LoggerPrintStream
    extends PrintStream {
        private final Logger logger;
        private int last = -1;
        private final ByteArrayOutputStream bufOut = (ByteArrayOutputStream)this.out;

        private LoggerPrintStream(Logger logger) {
            super(new ByteArrayOutputStream());
            this.logger = logger;
        }

        @Override
        public void write(int n) {
            if (this.last == 13 && n == 10) {
                this.last = -1;
                return;
            }
            if (n == 10 || n == 13) {
                try {
                    String string = Thread.currentThread().getName() + ": " + this.bufOut.toString();
                    this.logger.logp(Level.INFO, "LogStream", "print", string);
                }
                finally {
                    this.bufOut.reset();
                }
            } else {
                super.write(n);
            }
            this.last = n;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            if (n2 < 0) {
                throw new ArrayIndexOutOfBoundsException(n2);
            }
            for (int i = 0; i < n2; ++i) {
                this.write(byArray[n + i]);
            }
        }

        public String toString() {
            return "RMI";
        }
    }

    private static class InternalStreamHandler
    extends StreamHandler {
        InternalStreamHandler(OutputStream outputStream) {
            super(outputStream, new SimpleFormatter());
        }

        @Override
        public void publish(LogRecord logRecord) {
            super.publish(logRecord);
            this.flush();
        }

        @Override
        public void close() {
            this.flush();
        }
    }

    private static class LoggerLog
    extends Log {
        private static final Handler alternateConsole = AccessController.doPrivileged(new PrivilegedAction<Handler>(){

            @Override
            public Handler run() {
                InternalStreamHandler internalStreamHandler = new InternalStreamHandler(System.err);
                internalStreamHandler.setLevel(Level.ALL);
                return internalStreamHandler;
            }
        });
        private InternalStreamHandler copyHandler = null;
        private final Logger logger;
        private LoggerPrintStream loggerSandwich;

        private LoggerLog(final Logger logger, final Level level) {
            this.logger = logger;
            if (level != null) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        if (!logger.isLoggable(level)) {
                            logger.setLevel(level);
                        }
                        logger.addHandler(alternateConsole);
                        return null;
                    }
                });
            }
        }

        @Override
        public boolean isLoggable(Level level) {
            return this.logger.isLoggable(level);
        }

        @Override
        public void log(Level level, String string) {
            if (this.isLoggable(level)) {
                String[] stringArray = Log.getSource();
                this.logger.logp(level, stringArray[0], stringArray[1], Thread.currentThread().getName() + ": " + string);
            }
        }

        @Override
        public void log(Level level, String string, Throwable throwable) {
            if (this.isLoggable(level)) {
                String[] stringArray = Log.getSource();
                this.logger.logp(level, stringArray[0], stringArray[1], Thread.currentThread().getName() + ": " + string, throwable);
            }
        }

        @Override
        public synchronized void setOutputStream(OutputStream outputStream) {
            if (outputStream != null) {
                if (!this.logger.isLoggable(VERBOSE)) {
                    this.logger.setLevel(VERBOSE);
                }
                this.copyHandler = new InternalStreamHandler(outputStream);
                this.copyHandler.setLevel(VERBOSE);
                this.logger.addHandler(this.copyHandler);
            } else {
                if (this.copyHandler != null) {
                    this.logger.removeHandler(this.copyHandler);
                }
                this.copyHandler = null;
            }
        }

        @Override
        public synchronized PrintStream getPrintStream() {
            if (this.loggerSandwich == null) {
                this.loggerSandwich = new LoggerPrintStream(this.logger);
            }
            return this.loggerSandwich;
        }
    }

    private static class LoggerLogFactory
    implements LogFactory {
        LoggerLogFactory() {
        }

        @Override
        public Log createLog(String string, String string2, Level level) {
            Logger logger = Logger.getLogger(string);
            return new LoggerLog(logger, level);
        }
    }

    private static interface LogFactory {
        public Log createLog(String var1, String var2, Level var3);
    }
}

