/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.Mutable;

public class MutableShort
extends Number
implements Comparable<MutableShort>,
Mutable<Number> {
    private static final long serialVersionUID = -2135791679L;
    private short value;

    public MutableShort() {
    }

    public MutableShort(short value2) {
        this.value = value2;
    }

    public MutableShort(Number value2) {
        this.value = value2.shortValue();
    }

    public MutableShort(String value2) {
        this.value = Short.parseShort(value2);
    }

    @Override
    public Short getValue() {
        return this.value;
    }

    @Override
    public void setValue(short value2) {
        this.value = value2;
    }

    @Override
    public void setValue(Number value2) {
        this.value = value2.shortValue();
    }

    public void increment() {
        this.value = (short)(this.value + 1);
    }

    public short getAndIncrement() {
        short last2 = this.value;
        this.value = (short)(this.value + 1);
        return last2;
    }

    public short incrementAndGet() {
        this.value = (short)(this.value + 1);
        return this.value;
    }

    public void decrement() {
        this.value = (short)(this.value - 1);
    }

    public short getAndDecrement() {
        short last2 = this.value;
        this.value = (short)(this.value - 1);
        return last2;
    }

    public short decrementAndGet() {
        this.value = (short)(this.value - 1);
        return this.value;
    }

    public void add(short operand) {
        this.value = (short)(this.value + operand);
    }

    public void add(Number operand) {
        this.value = (short)(this.value + operand.shortValue());
    }

    public void subtract(short operand) {
        this.value = (short)(this.value - operand);
    }

    public void subtract(Number operand) {
        this.value = (short)(this.value - operand.shortValue());
    }

    public short addAndGet(short operand) {
        this.value = (short)(this.value + operand);
        return this.value;
    }

    public short addAndGet(Number operand) {
        this.value = (short)(this.value + operand.shortValue());
        return this.value;
    }

    public short getAndAdd(short operand) {
        short last2 = this.value;
        this.value = (short)(this.value + operand);
        return last2;
    }

    public short getAndAdd(Number operand) {
        short last2 = this.value;
        this.value = (short)(this.value + operand.shortValue());
        return last2;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public Short toShort() {
        return this.shortValue();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableShort) {
            return this.value == ((MutableShort)obj).shortValue();
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int compareTo(MutableShort other) {
        return NumberUtils.compare(this.value, other.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

