/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.exec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.InvalidExitUtil;
import org.zeroturnaround.exec.MessageLogger;
import org.zeroturnaround.exec.ProcessAttributes;
import org.zeroturnaround.exec.ProcessOutput;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.close.ProcessCloser;
import org.zeroturnaround.exec.listener.ProcessListener;
import org.zeroturnaround.exec.stop.ProcessStopper;

class WaitForProcess
implements Callable<ProcessResult> {
    private static final Logger log = LoggerFactory.getLogger(WaitForProcess.class);
    private final Process process;
    private final ProcessAttributes attributes;
    private final ProcessStopper stopper;
    private final ProcessCloser closer;
    private final ByteArrayOutputStream out;
    private final ProcessListener listener;
    private final MessageLogger messageLogger;
    private volatile Thread workerThread;

    public WaitForProcess(Process process, ProcessAttributes attributes, ProcessStopper stopper, ProcessCloser closer, ByteArrayOutputStream out2, ProcessListener listener, MessageLogger messageLogger) {
        this.process = process;
        this.attributes = attributes;
        this.stopper = stopper;
        this.closer = closer;
        this.out = out2;
        this.listener = listener;
        this.messageLogger = messageLogger;
    }

    public Process getProcess() {
        return this.process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProcessResult call() throws IOException, InterruptedException {
        try {
            int exit;
            block6: {
                this.workerThread = Thread.currentThread();
                boolean finished = false;
                try {
                    exit = this.process.waitFor();
                    finished = true;
                    this.messageLogger.message(log, "{} stopped with exit code {}", this, exit);
                    if (finished) break block6;
                }
                catch (Throwable throwable) {
                    if (!finished) {
                        this.messageLogger.message(log, "Stopping {}...", this);
                        this.stopper.stop(this.process);
                    }
                    this.closer.close(this.process);
                    throw throwable;
                }
                this.messageLogger.message(log, "Stopping {}...", this);
                this.stopper.stop(this.process);
            }
            this.closer.close(this.process);
            ProcessOutput output = this.getCurrentOutput();
            ProcessResult result2 = new ProcessResult(exit, output);
            InvalidExitUtil.checkExit(this.attributes, result2);
            this.listener.afterFinish(this.process, result2);
            ProcessResult processResult = result2;
            return processResult;
        }
        finally {
            this.listener.afterStop(this.process);
            this.workerThread = null;
        }
    }

    private ProcessOutput getCurrentOutput() {
        return this.out == null ? null : new ProcessOutput(this.out.toByteArray());
    }

    public void addExceptionMessageSuffix(StringBuilder sb) {
        InvalidExitUtil.addExceptionMessageSuffix(this.attributes, sb, this.getCurrentOutput());
    }

    public StackTraceElement[] getStackTrace() {
        Thread t = this.workerThread;
        return t == null ? null : t.getStackTrace();
    }

    public String toString() {
        return this.process.toString();
    }
}

