/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.texplate.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/islandoftex/texplate/util/PathUtils;", "", "()V", "TEMPLATES_FOLDER", "", "USER_APPLICATION_FOLDER", "userTemplatePath", "Ljava/nio/file/Path;", "getUserTemplatePath", "()Ljava/nio/file/Path;", "getTemplatePath", "name", "texplate"})
public final class PathUtils {
    private static final String TEMPLATES_FOLDER = "templates";
    private static final String USER_APPLICATION_FOLDER = ".texplate";
    public static final PathUtils INSTANCE;

    private final Path getUserTemplatePath() {
        Path path;
        try {
            Path path2 = Paths.get(System.getProperty("user.home"), USER_APPLICATION_FOLDER, TEMPLATES_FOLDER);
            Intrinsics.checkExpressionValueIsNotNull(path2, "Paths.get(System.getProp\u2026FOLDER, TEMPLATES_FOLDER)");
            path = path2;
        }
        catch (RuntimeException e) {
            Path path3 = Paths.get(".", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull(path3, "Paths.get(\".\")");
            path = path3;
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Path getTemplatePath(@NotNull String name) throws FileNotFoundException {
        Path path;
        Intrinsics.checkParameterIsNotNull(name, "name");
        if (StringsKt.endsWith$default(name, ".toml", false, 2, null) && Files.exists(Paths.get(name, new String[0]), new LinkOption[0])) {
            Path path2 = Paths.get(name, new String[0]);
            Intrinsics.checkExpressionValueIsNotNull(path2, "Paths.get(name)");
            return path2;
        }
        String fullName = name + ".toml";
        Path reference = INSTANCE.getUserTemplatePath().resolve(fullName);
        if (Files.exists(reference, new LinkOption[0])) {
            Path path3 = reference;
            path = path3;
            Intrinsics.checkExpressionValueIsNotNull(path3, "reference");
        } else {
            void var3_3;
            try {
                Path tempFile = Files.createTempFile(null, null, new FileAttribute[0]);
                File file = tempFile.toFile();
                Intrinsics.checkExpressionValueIsNotNull(file, "tempFile.toFile()");
                URL uRL = PathUtils.class.getResource("/org/islandoftex/texplate/templates/texplate-" + fullName);
                Intrinsics.checkExpressionValueIsNotNull(uRL, "PathUtils::class.java\n  \u2026ates/texplate-$fullName\")");
                URL uRL2 = uRL;
                File file2 = file;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                byte[] byArray = TextStreamsKt.readBytes(uRL2);
                boolean bl2 = false;
                boolean bl3 = false;
                String string = new String(byArray, charset);
                FilesKt.writeText$default(file2, string, null, 2, null);
            }
            catch (RuntimeException e) {
                throw (Throwable)new FileNotFoundException("I am sorry, but the template file '" + fullName + "' could not be found in the " + "default template locations (system and user). Make " + "sure the reference is correct and try again. For " + "reference, these are the paths I searched: '" + INSTANCE.getUserTemplatePath() + "'.");
            }
            void v5 = var3_3;
            path = v5;
            Intrinsics.checkExpressionValueIsNotNull(v5, "try {\n                va\u2026ath + \"'.\")\n            }");
        }
        return path;
    }

    private PathUtils() {
    }

    static {
        PathUtils pathUtils;
        INSTANCE = pathUtils = new PathUtils();
    }
}

