/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.Locale;

public final class ContextName {
    private static final String ROOT_NAME = "ROOT";
    private static final String VERSION_MARKER = "##";
    private static final String FWD_SLASH_REPLACEMENT = "#";
    private final String baseName;
    private final String path;
    private final String version;
    private final String name;

    @Deprecated
    public ContextName(String string) {
        this(string, true);
    }

    public ContextName(String string, boolean bl) {
        String string2;
        String string3 = string;
        if (string3.startsWith("/")) {
            string3 = string3.substring(1);
        }
        if ((string3 = string3.replaceAll("/", FWD_SLASH_REPLACEMENT)).startsWith(VERSION_MARKER) || "".equals(string3)) {
            string3 = ROOT_NAME + string3;
        }
        if (bl && (string3.toLowerCase(Locale.ENGLISH).endsWith(".war") || string3.toLowerCase(Locale.ENGLISH).endsWith(".xml"))) {
            string3 = string3.substring(0, string3.length() - 4);
        }
        this.baseName = string3;
        int n = this.baseName.indexOf(VERSION_MARKER);
        if (n > -1) {
            this.version = this.baseName.substring(n + 2);
            string2 = this.baseName.substring(0, n);
        } else {
            this.version = "";
            string2 = this.baseName;
        }
        this.path = ROOT_NAME.equals(string2) ? "" : "/" + string2.replaceAll(FWD_SLASH_REPLACEMENT, "/");
        this.name = n > -1 ? this.path + VERSION_MARKER + this.version : this.path;
    }

    public ContextName(String string, String string2) {
        this.path = string == null || "/".equals(string) || "/ROOT".equals(string) ? "" : string;
        this.version = string2 == null ? "" : string2;
        this.name = "".equals(this.version) ? this.path : this.path + VERSION_MARKER + this.version;
        StringBuilder stringBuilder = new StringBuilder();
        if ("".equals(this.path)) {
            stringBuilder.append(ROOT_NAME);
        } else {
            stringBuilder.append(this.path.substring(1).replaceAll("/", FWD_SLASH_REPLACEMENT));
        }
        if (this.version.length() > 0) {
            stringBuilder.append(VERSION_MARKER);
            stringBuilder.append(this.version);
        }
        this.baseName = stringBuilder.toString();
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getPath() {
        return this.path;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        StringBuilder stringBuilder = new StringBuilder();
        if ("".equals(this.path)) {
            stringBuilder.append('/');
        } else {
            stringBuilder.append(this.path);
        }
        if (!"".equals(this.version)) {
            stringBuilder.append(VERSION_MARKER);
            stringBuilder.append(this.version);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getDisplayName();
    }
}

