/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.pool2.ObjectPool;

public class PoolingDriver
implements Driver {
    protected static final HashMap<String, ObjectPool<? extends Connection>> pools;
    private final boolean accessToUnderlyingConnectionAllowed;
    public static final String URL_PREFIX = "jdbc:apache:commons:dbcp:";
    protected static final int URL_PREFIX_LEN;
    protected static final int MAJOR_VERSION = 1;
    protected static final int MINOR_VERSION = 0;

    public PoolingDriver() {
        this(true);
    }

    protected PoolingDriver(boolean bl) {
        this.accessToUnderlyingConnectionAllowed = bl;
    }

    protected boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public synchronized ObjectPool<? extends Connection> getConnectionPool(String string) throws SQLException {
        ObjectPool<? extends Connection> objectPool = pools.get(string);
        if (null == objectPool) {
            throw new SQLException("Pool not registered: " + string);
        }
        return objectPool;
    }

    public synchronized void registerPool(String string, ObjectPool<? extends Connection> objectPool) {
        pools.put(string, objectPool);
    }

    public synchronized void closePool(String string) throws SQLException {
        ObjectPool<? extends Connection> objectPool = pools.get(string);
        if (objectPool != null) {
            pools.remove(string);
            try {
                objectPool.close();
            }
            catch (Exception exception) {
                throw new SQLException("Error closing pool " + string, exception);
            }
        }
    }

    public synchronized String[] getPoolNames() {
        Set<String> set = pools.keySet();
        return set.toArray(new String[0]);
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        return string == null ? false : string.startsWith(URL_PREFIX);
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        if (this.acceptsURL(string)) {
            ObjectPool<? extends Connection> objectPool = this.getConnectionPool(string.substring(URL_PREFIX_LEN));
            try {
                Connection connection = objectPool.borrowObject();
                if (connection == null) {
                    return null;
                }
                return new PoolGuardConnectionWrapper(objectPool, connection);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new SQLException("Cannot get a connection, pool error: " + noSuchElementException.getMessage(), noSuchElementException);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new SQLException("Cannot get a connection, general error: " + exception.getMessage(), exception);
            }
        }
        return null;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public void invalidateConnection(Connection connection) throws SQLException {
        if (connection instanceof PoolGuardConnectionWrapper) {
            PoolGuardConnectionWrapper poolGuardConnectionWrapper = (PoolGuardConnectionWrapper)connection;
            ObjectPool objectPool = poolGuardConnectionWrapper.pool;
            try {
                objectPool.invalidateObject(poolGuardConnectionWrapper.getDelegateInternal());
            }
            catch (Exception exception) {}
        } else {
            throw new SQLException("Invalid connection class");
        }
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        return new DriverPropertyInfo[0];
    }

    static {
        try {
            DriverManager.registerDriver(new PoolingDriver());
        }
        catch (Exception exception) {
            // empty catch block
        }
        pools = new HashMap();
        URL_PREFIX_LEN = URL_PREFIX.length();
    }

    private class PoolGuardConnectionWrapper
    extends DelegatingConnection<Connection> {
        private final ObjectPool<? extends Connection> pool;

        PoolGuardConnectionWrapper(ObjectPool<? extends Connection> objectPool, Connection connection) {
            super(connection);
            this.pool = objectPool;
        }

        @Override
        public Connection getDelegate() {
            if (PoolingDriver.this.isAccessToUnderlyingConnectionAllowed()) {
                return super.getDelegate();
            }
            return null;
        }

        @Override
        public Connection getInnermostDelegate() {
            if (PoolingDriver.this.isAccessToUnderlyingConnectionAllowed()) {
                return super.getInnermostDelegate();
            }
            return null;
        }
    }
}

