/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import org.netbeans.lib.profiler.wireprotocol.Response;

public class ThreadDumpResponse
extends Response {
    private boolean jdk15;
    private Date time;
    Object[] cdThreads;

    public ThreadDumpResponse(boolean bl, Date date, Object[] objectArray) {
        super(true, 14);
        this.jdk15 = bl;
        this.time = date;
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        this.cdThreads = objectArray;
    }

    ThreadDumpResponse() {
        super(true, 14);
    }

    public boolean isJDK15() {
        return this.jdk15;
    }

    public Date getTime() {
        return this.time;
    }

    public Object[] getThreads() {
        return this.cdThreads;
    }

    void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.jdk15 = objectInputStream.readBoolean();
        long l = objectInputStream.readLong();
        this.time = new Date(l);
        int n = objectInputStream.readInt();
        this.cdThreads = new Object[n];
        for (int i = 0; i < n; ++i) {
            try {
                this.cdThreads[i] = objectInputStream.readObject();
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException);
            }
        }
    }

    void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeBoolean(this.jdk15);
        objectOutputStream.writeLong(this.time.getTime());
        objectOutputStream.writeInt(this.cdThreads.length);
        for (int i = 0; i < this.cdThreads.length; ++i) {
            objectOutputStream.writeObject(this.cdThreads[i]);
        }
        this.time = null;
        this.cdThreads = null;
    }
}

