/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java.impl;

import com.sun.tools.visualvm.heapviewer.java.LocalObjectNode;
import com.sun.tools.visualvm.heapviewer.java.StackFrameNode;
import com.sun.tools.visualvm.heapviewer.java.ThreadNode;
import com.sun.tools.visualvm.heapviewer.java.impl.Bundle;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import com.sun.tools.visualvm.heapviewer.model.RootNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaFrameGCRoot;
import org.netbeans.lib.profiler.heap.ThreadObjectGCRoot;
import org.netbeans.modules.profiler.heapwalk.details.api.DetailsSupport;

class JavaThreadsObjects {
    private static final int JVMTI_THREAD_STATE_ALIVE = 1;
    private static final int JVMTI_THREAD_STATE_TERMINATED = 2;
    private static final int JVMTI_THREAD_STATE_RUNNABLE = 4;
    private static final int JVMTI_THREAD_STATE_BLOCKED_ON_MONITOR_ENTER = 1024;
    private static final int JVMTI_THREAD_STATE_WAITING_INDEFINITELY = 16;
    private static final int JVMTI_THREAD_STATE_WAITING_WITH_TIMEOUT = 32;

    JavaThreadsObjects() {
    }

    static HeapViewerNode[] getThreads(RootNode rootNode, Heap heap) {
        ArrayList<ThreadNode> threadNodes = new ArrayList<ThreadNode>();
        Collection roots = heap.getGCRoots();
        Map<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>> javaFrameMap = JavaThreadsObjects.computeJavaFrameMap(roots);
        for (GCRoot root : roots) {
            if (!root.getKind().equals("thread object")) continue;
            ThreadObjectGCRoot threadRoot = (ThreadObjectGCRoot)root;
            Instance threadInstance = threadRoot.getInstance();
            if (threadInstance != null) {
                String threadName = JavaThreadsObjects.getThreadName(heap, threadInstance);
                Boolean daemon = (Boolean)threadInstance.getValueOfField("daemon");
                Integer priority = (Integer)threadInstance.getValueOfField("priority");
                Long threadId = (Long)threadInstance.getValueOfField("tid");
                Integer threadStatus = (Integer)threadInstance.getValueOfField("threadStatus");
                StackTraceElement[] stack = threadRoot.getStackTrace();
                Map<Integer, List<JavaFrameGCRoot>> localsMap = javaFrameMap.get(threadRoot);
                String tName = "\"" + threadName + "\"" + (daemon != false ? " daemon" : "") + " prio=" + priority;
                if (threadId != null) {
                    tName = tName + " tid=" + threadId;
                }
                if (threadStatus != null) {
                    tName = tName + " " + (Object)((Object)JavaThreadsObjects.toThreadState(threadStatus));
                }
                final ArrayList<StackFrameNode> stackFrameNodes = new ArrayList<StackFrameNode>();
                ThreadNode threadNode = new ThreadNode(tName, threadInstance){

                    @Override
                    protected HeapViewerNode[] computeChildren(RootNode root) {
                        return stackFrameNodes.toArray(HeapViewerNode.NO_NODES);
                    }
                };
                if (stack != null) {
                    for (int i = 0; i < stack.length; ++i) {
                        List<JavaFrameGCRoot> locals;
                        ArrayList<LocalObjectNode> localVariableNodes = new ArrayList<LocalObjectNode>();
                        if (localsMap != null && (locals = localsMap.get(i)) != null) {
                            for (JavaFrameGCRoot localVar : locals) {
                                Instance localInstance = localVar.getInstance();
                                if (localInstance != null) {
                                    localVariableNodes.add(new LocalObjectNode(localInstance, Bundle.JavaThreadsObjects_LocalVariable()));
                                    continue;
                                }
                                localVariableNodes.add(new LocalObjectNode.Unknown());
                            }
                        }
                        StackTraceElement stackElement = stack[i];
                        StackFrameNode stackFrameNode = new StackFrameNode(stackElement.toString(), localVariableNodes.toArray(HeapViewerNode.NO_NODES));
                        stackFrameNodes.add(stackFrameNode);
                    }
                }
                threadNodes.add(threadNode);
                continue;
            }
            threadNodes.add(new ThreadNode.Unknown());
        }
        return threadNodes.toArray(HeapViewerNode.NO_NODES);
    }

    private static Map<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>> computeJavaFrameMap(Collection<GCRoot> roots) {
        HashMap<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>> javaFrameMap = new HashMap<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>>();
        for (GCRoot root : roots) {
            ArrayList<JavaFrameGCRoot> locals;
            if (!"Java frame".equals(root.getKind())) continue;
            JavaFrameGCRoot frameGCroot = (JavaFrameGCRoot)root;
            ThreadObjectGCRoot threadObj = frameGCroot.getThreadGCRoot();
            Integer frameNo = frameGCroot.getFrameNumber();
            HashMap<Integer, ArrayList<JavaFrameGCRoot>> stackMap = (HashMap<Integer, ArrayList<JavaFrameGCRoot>>)javaFrameMap.get(threadObj);
            if (stackMap == null) {
                stackMap = new HashMap<Integer, ArrayList<JavaFrameGCRoot>>();
                javaFrameMap.put(threadObj, stackMap);
            }
            if ((locals = (ArrayList<JavaFrameGCRoot>)stackMap.get(frameNo)) == null) {
                locals = new ArrayList<JavaFrameGCRoot>(2);
                stackMap.put(frameNo, locals);
            }
            locals.add(frameGCroot);
        }
        return javaFrameMap;
    }

    private static String getThreadName(Heap heap, Instance threadInstance) {
        Object threadName = threadInstance.getValueOfField("name");
        if (threadName == null) {
            return "*null*";
        }
        return DetailsSupport.getDetailsString((Instance)((Instance)threadName), (Heap)heap);
    }

    private static Thread.State toThreadState(int threadStatus) {
        if ((threadStatus & 4) != 0) {
            return Thread.State.RUNNABLE;
        }
        if ((threadStatus & 0x400) != 0) {
            return Thread.State.BLOCKED;
        }
        if ((threadStatus & 0x10) != 0) {
            return Thread.State.WAITING;
        }
        if ((threadStatus & 0x20) != 0) {
            return Thread.State.TIMED_WAITING;
        }
        if ((threadStatus & 2) != 0) {
            return Thread.State.TERMINATED;
        }
        if ((threadStatus & 1) == 0) {
            return Thread.State.NEW;
        }
        return Thread.State.RUNNABLE;
    }
}

