/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.Caret;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.lib.profiler.ui.components.JTitledPanel;
import org.netbeans.lib.profiler.ui.components.NoCaret;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.HintsController;
import org.netbeans.modules.profiler.heapwalk.ui.Bundle;

public class HintsControllerUI
extends JTitledPanel {
    private static final Number OBJECTS_DEFAULT = 20;
    private static final int OBJECTS_MAX = 100;
    private HintsController hintsController;
    private HTMLTextArea componentsArea;
    private JPanel hintsTextContainer;
    private JSpinner spinner;
    private JLabel textLabel1;
    private JLabel textLabel2;
    private JButton findButton;
    private HTMLTextArea dataArea;

    public HintsControllerUI(HintsController hintsController) {
        super(Bundle.HintsControllerUI_ViewTitleHints(), Icons.getIcon((String)"GeneralIcons.Find"), true);
        this.hintsController = hintsController;
        this.initComponents();
    }

    public void setComponents(String string) {
        this.componentsArea.setText(string);
        try {
            this.componentsArea.setCaretPosition(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.componentsArea.setVisible(true);
    }

    public void setResult(String string) {
        this.dataArea.setText(string);
        try {
            this.dataArea.setCaretPosition(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.findButton.setEnabled(true);
    }

    private void initComponents() {
        final int n = new JTextField().getPreferredSize().height;
        this.setLayout(new BorderLayout());
        this.hintsTextContainer = new JPanel(new GridBagLayout());
        this.hintsTextContainer.setOpaque(false);
        this.hintsTextContainer.setBorder(BorderFactory.createMatteBorder(0, 0, 10, 0, UIUtils.getProfilerResultsBackground()));
        this.textLabel1 = new JLabel(Bundle.HintsControllerUI_Label1String());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.hintsTextContainer.add((Component)this.textLabel1, gridBagConstraints);
        this.spinner = new JExtendedSpinner(new SpinnerNumberModel(OBJECTS_DEFAULT, Integer.valueOf(1), Integer.valueOf(100), (Number)1)){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, n);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.hintsTextContainer.add((Component)this.spinner, gridBagConstraints);
        this.textLabel2 = new JLabel(Bundle.HintsControllerUI_Label2String());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.hintsTextContainer.add((Component)this.textLabel2, gridBagConstraints);
        this.findButton = new JButton(Bundle.HintsControllerUI_FindButton()){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                HintsControllerUI.this.findButton.setEnabled(false);
                int n = ((Number)HintsControllerUI.this.spinner.getValue()).intValue();
                HintsControllerUI.this.hintsController.computeBiggestObjects(n);
            }
        };
        this.findButton.setToolTipText(Bundle.HintsControllerUI_FindButtonTooltip());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.hintsTextContainer.add((Component)this.findButton, gridBagConstraints);
        JPanel jPanel = new JPanel(null);
        jPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.hintsTextContainer.add((Component)jPanel, gridBagConstraints);
        this.dataArea = new HTMLTextArea(){

            protected void showURL(URL uRL) {
                if (uRL == null) {
                    return;
                }
                HintsControllerUI.this.hintsController.showURL(uRL);
            }
        };
        this.componentsArea = new HTMLTextArea(){

            protected void showURL(URL uRL) {
                if (uRL == null) {
                    return;
                }
                HintsControllerUI.this.hintsController.showURL(uRL);
            }
        };
        this.componentsArea.setVisible(false);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setOpaque(true);
        jPanel2.setBackground(this.dataArea.getBackground());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.componentsArea, gridBagConstraints);
        String string = Icons.getResource((String)"HeapWalkerIcons.BiggestObjects");
        HTMLTextArea hTMLTextArea = new HTMLTextArea("<b><img border='0' align='bottom' src='nbresloc:/" + string + "'>&nbsp;&nbsp;" + Bundle.HintsControllerUI_BiggestObjectsCaption() + "</b><br><hr>");
        hTMLTextArea.setCaret((Caret)new NoCaret());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)hTMLTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 9, 0, 0);
        jPanel2.add((Component)this.hintsTextContainer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 9, 0, 0);
        jPanel2.add((Component)this.dataArea, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane(jPanel2, 20, 30);
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, this.getTitleBorderColor()), BorderFactory.createMatteBorder(5, 4, 5, 5, UIUtils.getProfilerResultsBackground())));
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        this.setLayout(new BorderLayout());
        this.add(jScrollPane, "Center");
        this.setBackground(this.dataArea.getBackground());
    }
}

