/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JToggleButton;
import org.netbeans.lib.profiler.charts.axis.TimeAxisUtils;
import org.netbeans.lib.profiler.results.threads.ThreadData;
import org.netbeans.lib.profiler.results.threads.ThreadsDataManager;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.modules.profiler.api.icons.Icons;

public class ViewManager
extends ProfilerTableContainer.ColumnChangeAdapter {
    private static final int MIN_TIMEMARK_STEP = 120;
    public static final String PROP_NEW_OFFSET = "newOffset";
    private static final int MAX_ZOOM = 5;
    private static final int MIN_VIEW = 3;
    private final int column;
    private final ThreadsDataManager data;
    private final Map<Integer, RowView> rowViews;
    private int offset;
    private int width;
    private int prefWidth;
    private boolean fit = false;
    private double zoom;
    private double lastZoom = this.zoom = (double)0.03f;
    private Action zoomInAction;
    private Action zoomOutAction;
    private Action fitAction;
    private long firstTimeMark;
    private long _firstTimeMark;
    private long timeMarksStep;
    private String format;

    private static ResourceBundle BUNDLE() {
        return ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.threads.Bundle");
    }

    public ViewManager(int n, ThreadsDataManager threadsDataManager) {
        this.column = n;
        this.data = threadsDataManager;
        this.updateTimeMarks(true);
        this.rowViews = new HashMap<Integer, RowView>();
    }

    public int zoomIn() {
        return this.setZoom(this.zoom * 1.2);
    }

    public int zoomOut() {
        return this.setZoom(this.zoom * 0.8);
    }

    public int setZoom(double d) {
        int n = this.offset;
        if (this.zoom != d) {
            double d2 = this.zoom;
            this.zoomChanged(this.zoom, d);
            if (!this.isFit()) {
                double d3 = (double)(this.offset + this.width / 2) / d2;
                n = Math.max((int)(d3 * d - (double)(this.width / 2)), 0);
            }
            this.updateActions();
        }
        return n;
    }

    public double getZoom() {
        return this.zoom;
    }

    public Action zoomInAction() {
        if (this.zoomInAction == null) {
            this.zoomInAction = new AbstractAction(null, Icons.getIcon((String)"GeneralIcons.ZoomIn")){
                {
                    this.putValue("ShortDescription", ViewManager.BUNDLE().getString("ACT_ZoomIn"));
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ViewManager.this.zoomIn();
                    Integer n2 = n == ViewManager.this.offset ? null : Integer.valueOf(n);
                    ViewManager.this.zoomInAction.putValue(ViewManager.PROP_NEW_OFFSET, n2);
                }
            };
        }
        return this.zoomInAction;
    }

    public Action zoomOutAction() {
        if (this.zoomOutAction == null) {
            this.zoomOutAction = new AbstractAction(null, Icons.getIcon((String)"GeneralIcons.ZoomOut")){
                {
                    this.putValue("ShortDescription", ViewManager.BUNDLE().getString("ACT_ZoomOut"));
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ViewManager.this.zoomOut();
                    Integer n2 = n == ViewManager.this.offset ? null : Integer.valueOf(n);
                    ViewManager.this.zoomOutAction.putValue(ViewManager.PROP_NEW_OFFSET, n2);
                }
            };
        }
        return this.zoomOutAction;
    }

    public Action fitAction() {
        if (this.fitAction == null) {
            this.fitAction = new AbstractAction(null, Icons.getIcon((String)"GeneralIcons.ScaleToFit")){
                {
                    this.putValue("ShortDescription", ViewManager.BUNDLE().getString("ACT_ScaleToFit"));
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = actionEvent.getSource();
                    if (object instanceof JToggleButton) {
                        ViewManager.this.fit = ((JToggleButton)object).isSelected();
                        if (ViewManager.this.fit) {
                            ViewManager.this.lastZoom = ViewManager.this.zoom;
                        } else {
                            ViewManager.this.zoom = ViewManager.this.lastZoom;
                        }
                        ViewManager.this.updateTimeMarks(true);
                        ViewManager.this.updateActions();
                    }
                }
            };
        }
        return this.fitAction;
    }

    private void updateActions() {
        if (this.zoomInAction != null) {
            this.zoomInAction.setEnabled(this.isFit() ? false : this.getViewWidth() > 0 && this.zoom <= 5.0);
        }
        if (this.zoomOutAction != null) {
            this.zoomOutAction.setEnabled(this.isFit() ? false : this.prefWidth >= this.width / 3);
        }
    }

    private long getFirstTime() {
        return this.data.getStartTime();
    }

    public int getViewWidth() {
        return (int)((double)this.getDataWidth() * this.zoom);
    }

    private int getDataWidth() {
        return (int)(this.data.getEndTime() - this.data.getStartTime());
    }

    public long getFirstTimeMark(boolean bl) {
        return bl ? this._firstTimeMark : this.firstTimeMark;
    }

    public long getTimeMarksStep() {
        return this.timeMarksStep;
    }

    public String getTimeMarksFormat() {
        return this.format;
    }

    public int getTimePosition(long l, boolean bl) {
        return !bl || this.isFit() ? (int)((double)(l - this.data.getStartTime()) * this.zoom) : (int)((double)(l - this.data.getStartTime()) * this.zoom) - this.offset;
    }

    private void updateTimeMarks(boolean bl) {
        if (bl) {
            this.timeMarksStep = TimeAxisUtils.getTimeUnits((double)this.zoom, (int)120);
        }
        long l = this.data.getStartTime();
        long l2 = l + (long)((double)this.offset / this.zoom);
        this.firstTimeMark = l / this.timeMarksStep * this.timeMarksStep + this.timeMarksStep;
        this._firstTimeMark = l2 / this.timeMarksStep * this.timeMarksStep + this.timeMarksStep;
        long l3 = l + (long)((double)this.width / this.zoom);
        this.format = TimeAxisUtils.getFormatString((long)this.timeMarksStep, (long)l, (long)l3);
    }

    public RowView getRowView(int n) {
        RowView rowView = this.rowViews.get(n);
        if (rowView == null) {
            rowView = new RowView(this.data.getThreadData(n));
            this.rowViews.put(n, rowView);
        }
        return rowView;
    }

    public void update() {
        if (this.isFit()) {
            this.zoomChanged(this.zoom, (double)this.width / (double)this.getDataWidth());
        }
    }

    public void reset() {
        this.lastZoom = this.zoom = (double)0.03f;
        this.rowViews.clear();
        this.updateTimeMarks(true);
    }

    @Override
    public void columnOffsetChanged(int n, int n2, int n3) {
        if (this.column != n) {
            return;
        }
        this.offset = n3;
        this.updateTimeMarks(false);
        for (RowView rowView : this.rowViews.values()) {
            rowView.offsetChanged(n2, n3);
        }
    }

    @Override
    public void columnWidthChanged(int n, int n2, int n3) {
        if (this.column != n) {
            return;
        }
        this.width = n3;
        if (!this.isFit()) {
            for (RowView rowView : this.rowViews.values()) {
                rowView.widthChanged(n2, n3);
            }
        }
        this.updateActions();
    }

    @Override
    public void columnPreferredWidthChanged(int n, int n2, int n3) {
        if (this.column != n) {
            return;
        }
        this.prefWidth = n3;
        this.updateTimeMarks(false);
        if (!this.isFit()) {
            for (RowView rowView : this.rowViews.values()) {
                rowView.preferredWidthChanged(n2, n3);
            }
        }
        this.updateActions();
    }

    public void zoomChanged(double d, double d2) {
        this.zoom = d2;
        this.updateTimeMarks(true);
        for (RowView rowView : this.rowViews.values()) {
            rowView.zoomChanged(d, d2);
        }
    }

    public void setFit(boolean bl) {
        this.fit = bl;
    }

    public boolean isFit() {
        return this.fit;
    }

    private boolean isTrackingEnd() {
        return this.offset + this.width >= this.prefWidth;
    }

    private static enum Position {
        LEFT,
        WITHIN,
        RIGHT;

    }

    public class RowView
    implements Comparable<RowView> {
        private final ThreadData data;
        private int i = -1;
        private boolean lastMaxIn = true;

        RowView(ThreadData threadData) {
            this.data = threadData;
            if (this.getMaxIndex() >= 0) {
                this.i = this.findLastIndex();
            }
        }

        public int getLastIndex() {
            return this.i == Integer.MIN_VALUE || this.i == Integer.MAX_VALUE ? -1 : this.i;
        }

        public int getMaxIndex() {
            return this.data.size() - 1;
        }

        public long getTime(int n) {
            return this.data.getTimeStampAt(n);
        }

        public int getState(int n) {
            return this.data.getStateAt(n);
        }

        public int getPosition(long l) {
            return (int)((double)(l - ViewManager.this.getFirstTime()) * ViewManager.this.zoom);
        }

        public int getMaxPosition() {
            return ViewManager.this.getViewWidth();
        }

        private int findLastIndex() {
            if (ViewManager.this.isTrackingEnd() || ViewManager.this.isFit()) {
                return this.getMaxIndex();
            }
            this.i = Integer.MIN_VALUE;
            return this.findLastIndexLeft();
        }

        private int findLastIndexLeft() {
            if (this.i == Integer.MAX_VALUE) {
                return this.i;
            }
            int n = this.getMaxIndex();
            int n2 = this.i == Integer.MIN_VALUE ? n : this.i;
            Position position = this.getIndexPosition(n2);
            while (n2 > 0 && Position.RIGHT.equals((Object)position)) {
                position = this.getIndexPosition(--n2);
            }
            if (Position.RIGHT.equals((Object)position)) {
                return Integer.MAX_VALUE;
            }
            if (Position.LEFT.equals((Object)position) && n2 == n && this.getMaxPosition() - ViewManager.this.offset < 0) {
                return Integer.MIN_VALUE;
            }
            return n2;
        }

        private int findLastIndexRight() {
            if (this.i == Integer.MIN_VALUE) {
                return this.i;
            }
            int n = this.getMaxIndex();
            int n2 = this.i == Integer.MAX_VALUE ? 0 : this.i;
            Position position = this.getIndexPosition(n2);
            while (n2 < n && !Position.RIGHT.equals((Object)position)) {
                position = this.getIndexPosition(++n2);
            }
            if (Position.RIGHT.equals((Object)position)) {
                return n2 == 0 ? Integer.MAX_VALUE : n2 - 1;
            }
            if (Position.LEFT.equals((Object)position) && n2 == n && this.getMaxPosition() - ViewManager.this.offset < 0) {
                return Integer.MIN_VALUE;
            }
            return n2;
        }

        private Position getIndexPosition(int n) {
            int n2 = this.getPosition(this.getTime(n)) - ViewManager.this.offset;
            if (n2 < 0) {
                return Position.LEFT;
            }
            if (n2 >= ViewManager.this.width) {
                return Position.RIGHT;
            }
            return Position.WITHIN;
        }

        private void offsetChanged(int n, int n2) {
            int n3 = this.getMaxIndex();
            if (n3 == -1) {
                return;
            }
            this.i = ViewManager.this.isTrackingEnd() ? n3 : (n2 > n ? (this.i == -1 ? this.findLastIndex() : this.findLastIndexRight()) : (this.i == -1 ? this.findLastIndex() : this.findLastIndexLeft()));
        }

        private void widthChanged(int n, int n2) {
            int n3 = this.getMaxIndex();
            if (n3 == -1) {
                return;
            }
            this.i = ViewManager.this.isTrackingEnd() || ViewManager.this.isFit() ? n3 : (n2 > n ? (this.i == -1 ? this.findLastIndex() : this.findLastIndexRight()) : (this.i == -1 ? this.findLastIndex() : this.findLastIndexLeft()));
        }

        private void preferredWidthChanged(int n, int n2) {
            int n3 = this.getMaxIndex();
            if (n3 == -1) {
                return;
            }
            int n4 = this.getMaxPosition() - ViewManager.this.offset;
            if (n4 >= 0 && n4 < ViewManager.this.width) {
                this.i = n3;
                this.lastMaxIn = true;
            } else {
                if (this.lastMaxIn && n4 >= ViewManager.this.width) {
                    this.i = n3;
                    this.findLastIndexLeft();
                }
                this.lastMaxIn = false;
            }
        }

        private void zoomChanged(double d, double d2) {
            int n = this.getMaxIndex();
            if (n == -1) {
                return;
            }
            this.i = ViewManager.this.isTrackingEnd() || ViewManager.this.isFit() ? n : this.findLastIndex();
        }

        @Override
        public int compareTo(RowView rowView) {
            return Long.compare(this.data.getFirstTimeStamp(), rowView.data.getFirstTimeStamp());
        }

        public String toString() {
            return ViewManager.BUNDLE().getString("COL_Timeline");
        }
    }
}

