/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.options.filetypes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.ui.options.filetypes.FileAssociationsModel;
import org.netbeans.core.ui.options.filetypes.NewExtensionPanel;
import org.netbeans.core.ui.options.filetypes.OpenAsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public final class OpenAsAction
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(OpenAsAction.class.getName());
    private final DataObject dob;

    public OpenAsAction(DataObject dataObject) {
        this.dob = dataObject;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        OpenAsPanel openAsPanel = new OpenAsPanel();
        FileAssociationsModel fileAssociationsModel = new FileAssociationsModel();
        openAsPanel.setModel(fileAssociationsModel);
        FileObject fileObject = this.dob.getPrimaryFile();
        String string2 = fileObject.getExt();
        openAsPanel.setExtension(string2);
        String string3 = NbBundle.getMessage(NewExtensionPanel.class, (String)"OpenAsPanel.open");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)openAsPanel, NbBundle.getMessage(OpenAsPanel.class, (String)"OpenAsPanel.title"), true, new Object[]{string3, DialogDescriptor.CANCEL_OPTION}, (Object)string3, 0, null, null);
        DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
        if (string3.equals(dialogDescriptor.getValue()) && (string = openAsPanel.getMimeType()) != null) {
            OpenCookie openCookie;
            this.dob.addPropertyChangeListener(new PropertyChangeListener(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("valid") && !((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                        LOGGER.log(Level.FINE, "PROP_VALID {0} - {1}", new Object[]{propertyChangeEvent.getNewValue(), propertyChangeEvent});
                        try {
                            OpenCookie openCookie = (OpenCookie)DataObject.find((FileObject)OpenAsAction.this.dob.getPrimaryFile()).getCookie(OpenCookie.class);
                            if (openCookie == null) return;
                            openCookie.open();
                            return;
                        }
                        catch (DataObjectNotFoundException dataObjectNotFoundException) {
                            LOGGER.log(Level.INFO, null, dataObjectNotFoundException);
                            return;
                        }
                        finally {
                            OpenAsAction.this.dob.removePropertyChangeListener((PropertyChangeListener)this);
                        }
                    } else {
                        OpenAsAction.this.dob.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                }
            });
            fileAssociationsModel.setMimeType(string2, string);
            fileAssociationsModel.store();
            try {
                this.dob.setValid(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                LOGGER.log(Level.INFO, "Can't convert", propertyVetoException);
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(OpenAsAction.class, (String)"ERR_CantConvert", (Object)fileObject.getPath(), (Object)string), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            try {
                openCookie = (OpenCookie)DataObject.find((FileObject)fileObject).getLookup().lookup(OpenCookie.class);
                if (openCookie != null) {
                    openCookie.open();
                    return;
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOGGER.log(Level.INFO, null, dataObjectNotFoundException);
            }
            openCookie = new NotifyDescriptor.Message((Object)NbBundle.getMessage(OpenAsAction.class, (String)"ERR_CantOpen", (Object)fileObject.getPath()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)openCookie);
        }
    }
}

