/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.Cursor;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.results.ProfilingResultsDispatcher;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.coderegion.CodeRegionResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUResultsDiff;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.jdbc.JdbcResultsDiff;
import org.netbeans.lib.profiler.results.jdbc.JdbcResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ResultsListener;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.SnapshotsListener;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerStorage;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.windows.WindowManager;

public final class ResultsManager {
    private static final Logger LOGGER = Logger.getLogger(ResultsManager.class.getName());
    public static final String SNAPSHOT_EXTENSION = "nps";
    public static final String HEAPDUMP_EXTENSION = "hprof";
    public static final String STACKTRACES_SNAPSHOT_EXTENSION = "npss";
    static final String HEAPDUMP_PREFIX = "heapdump-";
    private static final String SNAPSHOT_PREFIX = "snapshot-";
    private static final long MINIMAL_TIMESTAMP = 946684800000L;
    private ArrayList<LoadedSnapshot> loadedSnapshots = new ArrayList();
    private File exportDir;
    private HashMap<FileObject, ProfilingSettings> settingsCache = new HashMap();
    private HashMap<FileObject, Integer> typeCache = new HashMap();
    private Window mainWindow;
    private boolean resultsAvailable = false;
    private Lookup.Result<SnapshotsListener> snapshotListeners;
    private Lookup.Result<ResultsListener> resultsListeners;
    private static final String HPROF_HEADER = "JAVA PROFILE 1.0";
    private static final long MIN_HPROF_SIZE = 0x100000L;

    private ResultsManager() {
        Lookup lookup = Lookup.getDefault();
        this.snapshotListeners = lookup.lookupResult(SnapshotsListener.class);
        this.resultsListeners = lookup.lookupResult(ResultsListener.class);
    }

    public static ResultsManager getDefault() {
        return Singleton.INSTANCE;
    }

    public String getDefaultSnapshotFileName(LoadedSnapshot loadedSnapshot) {
        return SNAPSHOT_PREFIX + loadedSnapshot.getSnapshot().getTimeTaken();
    }

    public String getSnapshotDisplayName(LoadedSnapshot loadedSnapshot) {
        String string;
        String string2 = string = loadedSnapshot.getFile() == null ? null : loadedSnapshot.getFile().getName();
        if (string == null) {
            string = this.getDefaultSnapshotFileName(loadedSnapshot);
        } else {
            int n = string.lastIndexOf(46);
            if (n > 0 && n <= string.length() - 2) {
                string = string.substring(0, n);
            }
        }
        return this.getSnapshotDisplayName(string, loadedSnapshot.getType());
    }

    public String getSnapshotDisplayName(String string, int n) {
        String string2;
        block5: {
            if (string.startsWith(SNAPSHOT_PREFIX)) {
                String string3 = string.substring(SNAPSHOT_PREFIX.length(), string.length());
                try {
                    long l = Long.parseLong(string3);
                    if (l > 946684800000L) {
                        string2 = StringUtils.formatUserDate((Date)new Date(l));
                        break block5;
                    }
                    string2 = string;
                }
                catch (NumberFormatException numberFormatException) {
                    string2 = string;
                }
            } else {
                string2 = string;
            }
        }
        return string2;
    }

    public String getDefaultHeapDumpFileName(long l) {
        return HEAPDUMP_PREFIX + l;
    }

    public String getHeapDumpDisplayName(String string) {
        String string2;
        block5: {
            if (string.startsWith(HEAPDUMP_PREFIX)) {
                String string3 = string.substring(HEAPDUMP_PREFIX.length(), string.length());
                try {
                    long l = Long.parseLong(string3);
                    if (l > 946684800000L) {
                        string2 = StringUtils.formatUserDate((Date)new Date(l));
                        break block5;
                    }
                    string2 = string;
                }
                catch (NumberFormatException numberFormatException) {
                    string2 = string;
                }
            } else {
                string2 = string;
            }
        }
        return string2;
    }

    public LoadedSnapshot[] getLoadedSnapshots() {
        return this.loadedSnapshots.toArray(new LoadedSnapshot[0]);
    }

    public LoadedSnapshot getSnapshotFromFileObject(FileObject fileObject) {
        LoadedSnapshot loadedSnapshot = this.findAlreadyLoadedSnapshot(fileObject);
        if (loadedSnapshot != null) {
            return loadedSnapshot;
        }
        try {
            return this.loadSnapshotFromFileObject(fileObject);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, null, iOException);
            return null;
        }
    }

    public ProfilingSettings getSnapshotSettings(FileObject fileObject) {
        ProfilingSettings profilingSettings = this.settingsCache.get(fileObject);
        if (profilingSettings == null && !this.settingsCache.containsKey(fileObject)) {
            profilingSettings = this.readSettingsFromFile(fileObject);
            this.settingsCache.put(fileObject, profilingSettings);
        }
        return profilingSettings;
    }

    public int getSnapshotType(FileObject fileObject) {
        Integer n = this.typeCache.get(fileObject);
        if (n == null) {
            n = this.readTypeFromFile(fileObject);
            this.typeCache.put(fileObject, n);
        }
        return n;
    }

    public void closeSnapshot(LoadedSnapshot loadedSnapshot) {
        if (loadedSnapshot != null) {
            this.loadedSnapshots.remove(loadedSnapshot);
            this.fireSnapshotRemoved(loadedSnapshot);
        }
    }

    public void compareSnapshots(FileObject fileObject, FileObject fileObject2) {
        LoadedSnapshot loadedSnapshot = null;
        LoadedSnapshot loadedSnapshot2 = null;
        FileObject fileObject3 = fileObject;
        try {
            loadedSnapshot = this.findAlreadyLoadedSnapshot(fileObject);
            if (loadedSnapshot == null) {
                loadedSnapshot = this.loadSnapshotImpl(fileObject);
            }
            fileObject3 = fileObject2;
            loadedSnapshot2 = this.findAlreadyLoadedSnapshot(fileObject2);
            if (loadedSnapshot2 == null) {
                loadedSnapshot2 = this.loadSnapshotFromFileObject(fileObject2);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.INFO, Bundle.ResultsManager_SnapshotLoadFailed(fileObject3.getPath()), exception);
            ProfilerDialogs.displayError((String)Bundle.ResultsManager_SnapshotLoadFailedMsg(fileObject3.getNameExt(), exception.getMessage()));
            return;
        }
        if (loadedSnapshot != null && loadedSnapshot2 != null) {
            this.compareSnapshots(loadedSnapshot, loadedSnapshot2);
        } else {
            ProfilerDialogs.displayError((String)Bundle.ResultsManager_SnapshotsLoadFailedMsg());
        }
    }

    public ResultsSnapshot createDiffSnapshot(LoadedSnapshot loadedSnapshot, LoadedSnapshot loadedSnapshot2) {
        ResultsSnapshot resultsSnapshot = loadedSnapshot.getSnapshot();
        ResultsSnapshot resultsSnapshot2 = loadedSnapshot2.getSnapshot();
        CPUResultsDiff cPUResultsDiff = null;
        if (resultsSnapshot instanceof SampledMemoryResultsSnapshot && resultsSnapshot2 instanceof SampledMemoryResultsSnapshot) {
            SampledMemoryResultsSnapshot sampledMemoryResultsSnapshot = (SampledMemoryResultsSnapshot)resultsSnapshot;
            SampledMemoryResultsSnapshot sampledMemoryResultsSnapshot2 = (SampledMemoryResultsSnapshot)resultsSnapshot2;
            ResultsManager.checkObjectSizes(sampledMemoryResultsSnapshot.getClassNames(), sampledMemoryResultsSnapshot.getObjectsCounts(), sampledMemoryResultsSnapshot.getObjectsSizePerClass(), 1, sampledMemoryResultsSnapshot2.getClassNames(), sampledMemoryResultsSnapshot2.getObjectsCounts(), sampledMemoryResultsSnapshot2.getObjectsSizePerClass(), 1);
            cPUResultsDiff = new SampledMemoryResultsDiff((SampledMemoryResultsSnapshot)resultsSnapshot, (SampledMemoryResultsSnapshot)resultsSnapshot2);
        } else if (resultsSnapshot instanceof AllocMemoryResultsSnapshot && resultsSnapshot2 instanceof AllocMemoryResultsSnapshot) {
            AllocMemoryResultsSnapshot allocMemoryResultsSnapshot = (AllocMemoryResultsSnapshot)resultsSnapshot;
            AllocMemoryResultsSnapshot allocMemoryResultsSnapshot2 = (AllocMemoryResultsSnapshot)resultsSnapshot2;
            ResultsManager.checkObjectSizes(allocMemoryResultsSnapshot.getClassNames(), allocMemoryResultsSnapshot.getObjectsCounts(), allocMemoryResultsSnapshot.getObjectsSizePerClass(), Integer.MAX_VALUE, allocMemoryResultsSnapshot2.getClassNames(), allocMemoryResultsSnapshot2.getObjectsCounts(), allocMemoryResultsSnapshot2.getObjectsSizePerClass(), Integer.MAX_VALUE);
            cPUResultsDiff = new AllocMemoryResultsDiff((AllocMemoryResultsSnapshot)resultsSnapshot, (AllocMemoryResultsSnapshot)resultsSnapshot2);
        } else if (resultsSnapshot instanceof LivenessMemoryResultsSnapshot && resultsSnapshot2 instanceof LivenessMemoryResultsSnapshot) {
            LivenessMemoryResultsSnapshot livenessMemoryResultsSnapshot = (LivenessMemoryResultsSnapshot)resultsSnapshot;
            LivenessMemoryResultsSnapshot livenessMemoryResultsSnapshot2 = (LivenessMemoryResultsSnapshot)resultsSnapshot2;
            ResultsManager.checkObjectSizes(livenessMemoryResultsSnapshot.getClassNames(), livenessMemoryResultsSnapshot.getNTrackedLiveObjects(), livenessMemoryResultsSnapshot.getTrackedLiveObjectsSize(), 1, livenessMemoryResultsSnapshot2.getClassNames(), livenessMemoryResultsSnapshot2.getNTrackedLiveObjects(), livenessMemoryResultsSnapshot2.getTrackedLiveObjectsSize(), 1);
            cPUResultsDiff = new LivenessMemoryResultsDiff((LivenessMemoryResultsSnapshot)resultsSnapshot, (LivenessMemoryResultsSnapshot)resultsSnapshot2);
        } else if (resultsSnapshot instanceof CPUResultsSnapshot && resultsSnapshot2 instanceof CPUResultsSnapshot) {
            cPUResultsDiff = new CPUResultsDiff((CPUResultsSnapshot)resultsSnapshot, (CPUResultsSnapshot)resultsSnapshot2);
        } else if (resultsSnapshot instanceof JdbcResultsSnapshot && resultsSnapshot2 instanceof JdbcResultsSnapshot) {
            cPUResultsDiff = new JdbcResultsDiff((JdbcResultsSnapshot)resultsSnapshot, (JdbcResultsSnapshot)resultsSnapshot2);
        }
        return cPUResultsDiff;
    }

    public void compareSnapshots(final LoadedSnapshot loadedSnapshot, final LoadedSnapshot loadedSnapshot2) {
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SnapshotResultsWindow snapshotResultsWindow = SnapshotResultsWindow.get(loadedSnapshot, 0, false);
                if (!snapshotResultsWindow.setRefSnapshot(loadedSnapshot2)) {
                    ProfilerDialogs.displayError((String)Bundle.ResultsManager_CannotCompareSnapshotsMsg(loadedSnapshot.getFile().getName(), loadedSnapshot2.getFile().getName()));
                } else {
                    snapshotResultsWindow.open();
                    snapshotResultsWindow.requestActive();
                }
            }
        });
    }

    static void checkObjectSizes(String[] stringArray, int[] nArray, long[] lArray, int n, String[] stringArray2, int[] nArray2, long[] lArray2, int n2) {
        long l;
        int n3;
        String string = "java.lang.Object";
        String string2 = "java/lang/Object";
        int n4 = -1;
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            if (!string.equals(stringArray[n3]) && !string2.equals(stringArray[n3])) continue;
            n4 = n3;
            break;
        }
        if (n4 == -1 || nArray[n4] == 0) {
            return;
        }
        n3 = -1;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!string.equals(stringArray2[i]) && !string2.equals(stringArray2[i])) continue;
            n3 = i;
            break;
        }
        if (n3 == -1 || nArray2[n3] == 0) {
            return;
        }
        long l2 = n == 1 ? lArray[n4] / (long)nArray[n4] : 0L;
        long l3 = l = n2 == 1 ? lArray2[n3] / (long)nArray2[n3] : 0L;
        if (l2 != l) {
            ProfilerDialogs.displayWarningDNSA((String)Bundle.ResultsManager_DifferentObjectSize(), (String)Bundle.ResultsManager_CaptionWarning(), null, (String)"ResultsManager.checkObjectSizes", (boolean)false);
        }
    }

    public void deleteSnapshot(FileObject fileObject) {
        LoadedSnapshot loadedSnapshot = this.findLoadedSnapshot(FileUtil.toFile((FileObject)fileObject));
        try {
            fileObject.delete();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, Bundle.ResultsManager_SnapshotDeleteFailedMsg(iOException.getMessage()), iOException);
            return;
        }
        if (loadedSnapshot != null) {
            this.loadedSnapshots.remove(loadedSnapshot);
            this.fireSnapshotRemoved(loadedSnapshot);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exportSnapshots(final FileObject[] fileObjectArray) {
        Object object;
        assert (fileObjectArray != null);
        assert (fileObjectArray.length > 0);
        final String[] stringArray = new String[1];
        final String[] stringArray2 = new String[1];
        final FileObject[] fileObjectArray2 = new FileObject[1];
        if (fileObjectArray.length == 1) {
            object = this.selectSnapshotTargetFile(fileObjectArray[0].getName(), fileObjectArray[0].getExt().equals(HEAPDUMP_EXTENSION));
            if (object == null || !this.checkFileExists((SelectedFile)object)) return;
            stringArray[0] = ((SelectedFile)object).fileName;
            stringArray2[0] = ((SelectedFile)object).fileExt;
            fileObjectArray2[0] = ((SelectedFile)object).folder;
        } else {
            object = new JFileChooser();
            if (this.exportDir != null) {
                ((JFileChooser)object).setCurrentDirectory(this.exportDir);
            }
            ((JFileChooser)object).setDialogTitle(Bundle.ResultsManager_SelectDirDialogCaption());
            ((JFileChooser)object).setApproveButtonText(Bundle.ResultsManager_SaveButtonName());
            ((JFileChooser)object).setFileSelectionMode(1);
            ((JFileChooser)object).setMultiSelectionEnabled(false);
            if (((JFileChooser)object).showSaveDialog(WindowManager.getDefault().getMainWindow()) != 0) return;
            File file = ((JFileChooser)object).getSelectedFile();
            if (!file.exists()) {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.ResultsManager_DirectoryDoesntExistMsg(), (String)Bundle.ResultsManager_DirectoryDoesntExistCaption())) {
                    return;
                }
                file.mkdir();
            }
            this.exportDir = file;
            fileObjectArray2[0] = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        }
        object = ProgressHandle.createHandle((String)Bundle.MSG_SavingSnapshots());
        object.setInitialDelay(500);
        object.start();
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable((ProgressHandle)object){
            final /* synthetic */ ProgressHandle val$ph;
            {
                this.val$ph = progressHandle;
            }

            @Override
            public void run() {
                try {
                    for (int i = 0; i < fileObjectArray.length; ++i) {
                        ResultsManager.this.exportSnapshot(fileObjectArray[i], fileObjectArray2[0], stringArray[0] != null ? stringArray[0] : fileObjectArray[i].getName(), stringArray2[0] != null ? stringArray2[0] : fileObjectArray[i].getExt());
                    }
                }
                finally {
                    this.val$ph.finish();
                }
            }
        });
    }

    public LoadedSnapshot findLoadedSnapshot(ResultsSnapshot resultsSnapshot) {
        for (LoadedSnapshot loadedSnapshot : this.loadedSnapshots) {
            if (loadedSnapshot.getSnapshot() != resultsSnapshot) continue;
            return loadedSnapshot;
        }
        return null;
    }

    public LoadedSnapshot findLoadedSnapshot(File file) {
        for (LoadedSnapshot loadedSnapshot : this.loadedSnapshots) {
            if (loadedSnapshot.getFile() == null || !loadedSnapshot.getFile().equals(file)) continue;
            return loadedSnapshot;
        }
        return null;
    }

    public static boolean checkHprofFile(File file) {
        try {
            if (file.isFile() && file.canRead() && file.length() > 0x100000L) {
                byte[] byArray = new byte[HPROF_HEADER.length() + 4];
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                randomAccessFile.readFully(byArray);
                randomAccessFile.close();
                if (new String(byArray).startsWith(HPROF_HEADER)) {
                    return true;
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return false;
    }

    public FileObject[] listSavedHeapdumps(Lookup.Provider provider, File file) {
        try {
            FileObject fileObject = null;
            fileObject = provider == null && file != null ? FileUtil.toFileObject((File)file) : ProfilerStorage.getProjectFolder((Lookup.Provider)provider, (boolean)false);
            if (fileObject == null) {
                return new FileObject[0];
            }
            fileObject.refresh();
            FileObject[] fileObjectArray = fileObject.getChildren();
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FileObject fileObject2 = fileObjectArray[i];
                if (!ResultsManager.checkHprofFile(FileUtil.toFile((FileObject)fileObjectArray[i]))) continue;
                arrayList.add(fileObject2);
            }
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    FileObject fileObject = (FileObject)object;
                    FileObject fileObject2 = (FileObject)object2;
                    return fileObject.getName().compareTo(fileObject2.getName());
                }
            });
            return arrayList.toArray(new FileObject[0]);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, Bundle.ResultsManager_ObtainSavedSnapshotsFailedMsg(iOException.getMessage()), iOException);
            return new FileObject[0];
        }
    }

    public FileObject[] listSavedSnapshots(Lookup.Provider provider, File file) {
        try {
            FileObject fileObject = null;
            fileObject = provider == null && file != null ? FileUtil.toFileObject((File)file) : ProfilerStorage.getProjectFolder((Lookup.Provider)provider, (boolean)false);
            if (fileObject == null) {
                return new FileObject[0];
            }
            fileObject.refresh();
            FileObject[] fileObjectArray = fileObject.getChildren();
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FileObject fileObject2 = fileObjectArray[i];
                if (!fileObject2.getExt().equalsIgnoreCase(SNAPSHOT_EXTENSION)) continue;
                arrayList.add(fileObject2);
            }
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    FileObject fileObject = (FileObject)object;
                    FileObject fileObject2 = (FileObject)object2;
                    return fileObject.getName().compareTo(fileObject2.getName());
                }
            });
            return arrayList.toArray(new FileObject[0]);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, Bundle.ResultsManager_ObtainSavedSnapshotsFailedMsg(iOException.getMessage()), iOException);
            return new FileObject[0];
        }
    }

    public boolean hasSnapshotsFor(Lookup.Provider provider) {
        try {
            FileObject[] fileObjectArray;
            FileObject fileObject = ProfilerStorage.getProjectFolder((Lookup.Provider)provider, (boolean)false);
            if (fileObject == null) {
                return false;
            }
            fileObject.refresh();
            for (FileObject fileObject2 : fileObjectArray = fileObject.getChildren()) {
                if (fileObject2.getExt().equalsIgnoreCase(SNAPSHOT_EXTENSION)) {
                    return true;
                }
                if (!ResultsManager.checkHprofFile(FileUtil.toFile((FileObject)fileObject2))) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, Bundle.ResultsManager_ObtainSavedSnapshotsFailedMsg(iOException.getMessage()), iOException);
        }
        return false;
    }

    public int getSnapshotsCountFor(Lookup.Provider provider) {
        int n = 0;
        try {
            FileObject[] fileObjectArray;
            FileObject fileObject = ProfilerStorage.getProjectFolder((Lookup.Provider)provider, (boolean)false);
            if (fileObject == null) {
                return n;
            }
            fileObject.refresh();
            for (FileObject fileObject2 : fileObjectArray = fileObject.getChildren()) {
                if (!fileObject2.getExt().equalsIgnoreCase(SNAPSHOT_EXTENSION) && !ResultsManager.checkHprofFile(FileUtil.toFile((FileObject)fileObject2))) continue;
                ++n;
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, Bundle.ResultsManager_ObtainSavedSnapshotsFailedMsg(iOException.getMessage()), iOException);
        }
        return n;
    }

    public LoadedSnapshot loadSnapshot(FileObject fileObject) {
        try {
            return this.loadSnapshotImpl(fileObject);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, Bundle.ResultsManager_SnapshotLoadFailed(fileObject.getPath()), iOException);
            ProfilerDialogs.displayError((String)Bundle.ResultsManager_SnapshotLoadFailedMsg(fileObject.getNameExt(), iOException.getMessage()));
            return null;
        }
    }

    public LoadedSnapshot[] loadSnapshots(FileObject[] fileObjectArray) {
        LoadedSnapshot[] loadedSnapshotArray = new LoadedSnapshot[fileObjectArray.length];
        for (int i = 0; i < fileObjectArray.length; ++i) {
            try {
                if (fileObjectArray[i] == null) continue;
                loadedSnapshotArray[i] = this.loadSnapshotImpl(fileObjectArray[i]);
                continue;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, Bundle.ResultsManager_SnapshotLoadFailed(fileObjectArray[i].getPath()), iOException);
                ProfilerDialogs.displayError((String)Bundle.ResultsManager_SnapshotLoadFailedMsg(fileObjectArray[i].getNameExt(), iOException.getMessage()));
            }
        }
        return loadedSnapshotArray;
    }

    public void openSnapshot(File file) {
        File file2 = FileUtil.normalizeFile((File)file);
        FileObject fileObject = FileUtil.toFileObject((File)file2);
        this.openSnapshot(fileObject);
    }

    public void openSnapshot(FileObject fileObject) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
            if (openCookie != null) {
                openCookie.open();
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
    }

    public void openSnapshot(LoadedSnapshot loadedSnapshot) {
        this.openSnapshot(loadedSnapshot, -1, false);
    }

    public void openSnapshot(final LoadedSnapshot loadedSnapshot, final int n, final boolean bl) {
        if (loadedSnapshot == null) {
            ProfilerDialogs.displayError((String)Bundle.ResultsManager_CannotOpenSnapshotMsg());
        } else {
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    SnapshotResultsWindow snapshotResultsWindow = SnapshotResultsWindow.get(loadedSnapshot, n, bl);
                    snapshotResultsWindow.open();
                    snapshotResultsWindow.requestActive();
                }
            });
        }
    }

    public void openSnapshots(LoadedSnapshot[] loadedSnapshotArray) {
        LoadedSnapshot loadedSnapshot = null;
        try {
            SnapshotResultsWindow snapshotResultsWindow = null;
            for (int i = 0; i < loadedSnapshotArray.length; ++i) {
                loadedSnapshot = loadedSnapshotArray[i];
                if (loadedSnapshotArray[i] == null) continue;
                snapshotResultsWindow = SnapshotResultsWindow.get(loadedSnapshot);
                snapshotResultsWindow.open();
            }
            if (snapshotResultsWindow != null) {
                snapshotResultsWindow.requestActive();
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.INFO, Bundle.ResultsManager_SnapshotLoadFailed(loadedSnapshot.getFile().getAbsoluteFile()), exception);
            ProfilerDialogs.displayError((String)Bundle.ResultsManager_SnapshotLoadFailedMsg(loadedSnapshot.getFile().getName(), exception.getMessage()));
        }
    }

    public LoadedSnapshot prepareSnapshot() {
        return this.prepareSnapshot(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadedSnapshot prepareSnapshot(boolean bl) {
        TargetAppRunner targetAppRunner;
        Profiler profiler;
        CodeRegionResultsSnapshot codeRegionResultsSnapshot = null;
        if (!this.resultsAvailable()) {
            return null;
        }
        try {
            profiler = Profiler.getDefault();
            targetAppRunner = profiler.getTargetAppRunner();
            ProfilerClient profilerClient = targetAppRunner.getProfilerClient();
            int n = profiler.getLastProfilingSettings().getProfilingType();
            try {
                switch (n) {
                    case 2: 
                    case 4: 
                    case 128: {
                        codeRegionResultsSnapshot = profilerClient.getMemoryProfilingResultsSnapshot(bl);
                        break;
                    }
                    case 8: 
                    case 16: 
                    case 64: {
                        codeRegionResultsSnapshot = profilerClient.getCPUProfilingResultsSnapshot(bl);
                        break;
                    }
                    case 32: {
                        codeRegionResultsSnapshot = profilerClient.getCodeRegionProfilingResultsSnapshot();
                        break;
                    }
                    case 256: {
                        codeRegionResultsSnapshot = profilerClient.getJdbcProfilingResultsSnapshot(bl);
                    }
                }
            }
            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                ProfilerDialogs.displayWarning((String)Bundle.ResultsManager_ProfiledAppTerminatedMsg());
                ProfilerLogger.log((String)targetAppOrVMTerminated.getMessage());
            }
            catch (CPUResultsSnapshot.NoDataAvailableException noDataAvailableException) {
                LOGGER.log(Level.SEVERE, Bundle.ResultsManager_DataNotAvailableMsg(), noDataAvailableException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                try {
                    this.reset();
                    targetAppRunner.resetTimers();
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    profilerClient.resetClientData();
                }
                LOGGER.log(Level.SEVERE, Bundle.ResultsManager_OutOfMemoryMsg(), outOfMemoryError);
            }
        }
        finally {
            if (codeRegionResultsSnapshot != null) {
                profiler = new ProfilingSettings();
                Profiler.getDefault().getLastProfilingSettings().copySettingsInto((ProfilingSettings)profiler);
                profiler.setSettingsName(Profiler.getDefault().getLastProfilingSettings().getSettingsName());
                targetAppRunner = NetBeansProfiler.getDefaultNB().getProfiledProject();
                return new LoadedSnapshot((ResultsSnapshot)codeRegionResultsSnapshot, (ProfilingSettings)profiler, null, (Lookup.Provider)targetAppRunner);
            }
        }
        return null;
    }

    public void reset() {
        ProfilingResultsDispatcher.getDefault().reset();
        this.resultsReset();
    }

    public boolean resultsAvailable() {
        return this.resultsAvailable;
    }

    public ExportUtils.Exportable createSnapshotExporter(final LoadedSnapshot loadedSnapshot) {
        return this.createSnapshotExporter(new SnapshotHandle(){

            @Override
            public LoadedSnapshot getSnapshot() {
                return loadedSnapshot;
            }
        });
    }

    public ExportUtils.Exportable createSnapshotExporter(final SnapshotHandle snapshotHandle) {
        return new ExportUtils.Exportable(){

            public String getName() {
                return Bundle.ResultsManager_ExportSnapshotData();
            }

            public boolean isEnabled() {
                return true;
            }

            public ExportUtils.ExportProvider[] getProviders() {
                final LoadedSnapshot loadedSnapshot = snapshotHandle.getSnapshot();
                return new ExportUtils.ExportProvider[]{new ExportUtils.AbstractNPSExportProvider(loadedSnapshot.getFile()){

                    protected void doExport(File file) {
                        ResultsManager.this.exportSnapshot(loadedSnapshot, file);
                    }
                }};
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exportSnapshot(LoadedSnapshot loadedSnapshot, File file) {
        File file2 = loadedSnapshot.getFile();
        if (file2 != null) {
            try {
                Files.copy(file2.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                return true;
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.INFO, throwable.getMessage(), throwable);
                String string = throwable.getLocalizedMessage().replace("<", "&lt;").replace(">", "&gt;");
                ProfilerDialogs.displayError((String)Bundle.ResultsManager_SnapshotExportFailedMsg(string));
                return false;
            }
        }
        FileLock fileLock = null;
        FileObject fileObject = null;
        FilterOutputStream filterOutputStream = null;
        try {
            file = FileUtil.normalizeFile((File)file);
            fileObject = file.isFile() ? FileUtil.toFileObject((File)file) : FileUtil.createData((File)file);
            fileLock = fileObject.lock();
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            filterOutputStream = new DataOutputStream(bufferedOutputStream);
            loadedSnapshot.save((DataOutputStream)filterOutputStream);
            filterOutputStream.close();
        }
        catch (IOException iOException) {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                if (fileLock != null) {
                    fileObject.delete(fileLock);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProfilerDialogs.displayError((String)Bundle.ResultsManager_SnapshotSaveFailedMsg(iOException.getMessage()));
            boolean bl = false;
            return bl;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                if (fileLock != null) {
                    fileObject.delete(fileLock);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProfilerDialogs.displayError((String)Bundle.ResultsManager_OutOfMemorySavingMsg());
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveSnapshot(LoadedSnapshot loadedSnapshot, FileObject fileObject) {
        FileLock fileLock = null;
        FilterOutputStream filterOutputStream = null;
        boolean bl = loadedSnapshot.isSaved();
        loadedSnapshot.setSaved(true);
        try {
            fileLock = fileObject.lock();
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            filterOutputStream = new DataOutputStream(bufferedOutputStream);
            loadedSnapshot.save((DataOutputStream)filterOutputStream);
            filterOutputStream.close();
            loadedSnapshot.setFile(FileUtil.toFile((FileObject)fileObject));
            loadedSnapshot.setSaved(true);
            this.fireSnapshotSaved(loadedSnapshot);
        }
        catch (IOException iOException) {
            loadedSnapshot.setSaved(bl);
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                if (fileLock != null) {
                    fileObject.delete(fileLock);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProfilerDialogs.displayError((String)Bundle.ResultsManager_SnapshotSaveFailedMsg(iOException.getMessage()));
            boolean bl2 = false;
            return bl2;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            loadedSnapshot.setSaved(bl);
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                if (fileLock != null) {
                    fileObject.delete(fileLock);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProfilerDialogs.displayError((String)Bundle.ResultsManager_OutOfMemorySavingMsg());
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        return true;
    }

    public boolean saveSnapshot(LoadedSnapshot loadedSnapshot) {
        FileObject fileObject = null;
        Lookup.Provider provider = loadedSnapshot.getProject();
        FileObject fileObject2 = null;
        try {
            fileObject2 = ProfilerStorage.getProjectFolder((Lookup.Provider)provider, (boolean)true);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, Bundle.ResultsManager_CantFindSnapshotLocationMsg(iOException.getMessage()), iOException);
            return false;
        }
        try {
            fileObject = fileObject2.createData(this.getDefaultSnapshotFileName(loadedSnapshot), SNAPSHOT_EXTENSION);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, Bundle.ResultsManager_SnapshotCreateInProjectFailedMsg(iOException.getMessage()), iOException);
            return false;
        }
        return this.saveSnapshot(loadedSnapshot, fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadedSnapshot takeSnapshot() {
        CommonUtils.runInEventDispatchThreadAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                ResultsManager.this.mainWindow = WindowManager.getDefault().getMainWindow();
            }
        });
        Cursor cursor = this.mainWindow.getCursor();
        this.mainWindow.setCursor(Cursor.getPredefinedCursor(3));
        try {
            LoadedSnapshot loadedSnapshot = this.prepareSnapshot();
            if (loadedSnapshot != null) {
                this.loadedSnapshots.add(loadedSnapshot);
                this.fireSnapshotTaken(loadedSnapshot);
                LoadedSnapshot loadedSnapshot2 = loadedSnapshot;
                return loadedSnapshot2;
            }
        }
        finally {
            this.mainWindow.setCursor(cursor);
        }
        return null;
    }

    protected void fireResultsAvailable() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "fireResultsAvailable", new Exception());
        }
        if (this.resultsListeners.allClasses().isEmpty()) {
            return;
        }
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (ResultsListener resultsListener : ResultsManager.this.resultsListeners.allInstances()) {
                    resultsListener.resultsAvailable();
                }
            }
        });
    }

    protected void fireResultsReset() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "fireResultsReset", new Exception());
        }
        if (this.resultsListeners.allClasses().isEmpty()) {
            return;
        }
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (ResultsListener resultsListener : ResultsManager.this.resultsListeners.allInstances()) {
                    resultsListener.resultsReset();
                }
            }
        });
    }

    protected void fireSnapshotLoaded(final LoadedSnapshot loadedSnapshot) {
        if (this.snapshotListeners.allClasses().isEmpty()) {
            return;
        }
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (SnapshotsListener snapshotsListener : ResultsManager.this.snapshotListeners.allInstances()) {
                    snapshotsListener.snapshotLoaded(loadedSnapshot);
                }
            }
        });
    }

    protected void fireSnapshotRemoved(final LoadedSnapshot loadedSnapshot) {
        if (this.snapshotListeners.allClasses().isEmpty()) {
            return;
        }
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (SnapshotsListener snapshotsListener : ResultsManager.this.snapshotListeners.allInstances()) {
                    snapshotsListener.snapshotRemoved(loadedSnapshot);
                }
            }
        });
    }

    protected void fireSnapshotSaved(final LoadedSnapshot loadedSnapshot) {
        if (this.snapshotListeners.allClasses().isEmpty()) {
            return;
        }
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (SnapshotsListener snapshotsListener : ResultsManager.this.snapshotListeners.allInstances()) {
                    snapshotsListener.snapshotSaved(loadedSnapshot);
                }
            }
        });
    }

    protected void fireSnapshotTaken(final LoadedSnapshot loadedSnapshot) {
        if (this.snapshotListeners.allClasses().isEmpty()) {
            return;
        }
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (SnapshotsListener snapshotsListener : ResultsManager.this.snapshotListeners.allInstances()) {
                    snapshotsListener.snapshotTaken(loadedSnapshot);
                }
            }
        });
    }

    void resultsBecameAvailable() {
        if (Profiler.getDefault().getProfilingState() == 1) {
            return;
        }
        this.resultsAvailable = true;
        this.fireResultsAvailable();
    }

    void resultsReset() {
        this.resultsAvailable = false;
        this.fireResultsReset();
    }

    SelectedFile selectSnapshotTargetFile(String string, final boolean bl) {
        String string2;
        FileObject fileObject;
        String string3;
        JFileChooser jFileChooser = new JFileChooser();
        if (this.exportDir != null) {
            jFileChooser.setCurrentDirectory(this.exportDir);
        }
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setDialogTitle(Bundle.ResultsManager_SelectFileOrDirDialogCaption());
        jFileChooser.setApproveButtonText(Bundle.ResultsManager_SaveButtonName());
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith("." + (bl ? ResultsManager.HEAPDUMP_EXTENSION : ResultsManager.SNAPSHOT_EXTENSION));
            }

            @Override
            public String getDescription() {
                if (bl) {
                    return Bundle.ResultsManager_ProfilerHeapdumpFileFilter(ResultsManager.HEAPDUMP_EXTENSION);
                }
                return Bundle.ResultsManager_ProfilerSnapshotFileFilter(ResultsManager.SNAPSHOT_EXTENSION);
            }
        });
        if (jFileChooser.showSaveDialog(WindowManager.getDefault().getMainWindow()) != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        String string4 = string3 = bl ? HEAPDUMP_EXTENSION : SNAPSHOT_EXTENSION;
        if (file.isDirectory()) {
            this.exportDir = jFileChooser.getCurrentDirectory();
            fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            string2 = string;
        } else {
            this.exportDir = jFileChooser.getCurrentDirectory();
            fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.exportDir));
            String string5 = file.getName();
            int n = string5.lastIndexOf(46);
            if (n == -1) {
                string2 = string5;
            } else if (bl || string5.endsWith("." + string3)) {
                string2 = string5.substring(0, n);
                string3 = string5.substring(n + 1);
            } else {
                string2 = string5;
            }
        }
        return new SelectedFile(fileObject, string2, string3);
    }

    private boolean checkFileExists(SelectedFile selectedFile) {
        FileObject fileObject = selectedFile.folder.getFileObject(selectedFile.fileName, selectedFile.fileExt);
        if (fileObject != null) {
            if (!ProfilerDialogs.displayConfirmation((String)Bundle.ResultsManager_OverwriteFileDialogMsg(selectedFile.fileName + "." + selectedFile.fileExt), (String)Bundle.ResultsManager_OverwriteFileDialogCaption())) {
                return false;
            }
            try {
                fileObject.delete();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, Bundle.ResultsManager_FileDeleteFailedMsg(iOException.getMessage()), iOException);
                return false;
            }
        }
        return true;
    }

    private void exportSnapshot(FileObject fileObject, FileObject fileObject2, String string, String string2) {
        if (this.checkFileExists(new SelectedFile(fileObject2, string, string2))) {
            try {
                FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2, (String)string, (String)string2);
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.INFO, throwable.getMessage(), throwable);
                String string3 = throwable.getLocalizedMessage().replace("<", "&lt;").replace(">", "&gt;");
                ProfilerDialogs.displayError((String)Bundle.ResultsManager_SnapshotExportFailedMsg(string3));
            }
        }
    }

    private LoadedSnapshot findAlreadyLoadedSnapshot(FileObject fileObject) {
        Iterator<LoadedSnapshot> iterator = this.loadedSnapshots.iterator();
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return null;
        }
        while (iterator.hasNext()) {
            LoadedSnapshot loadedSnapshot = iterator.next();
            if (loadedSnapshot.getFile() == null || !loadedSnapshot.getFile().equals(file)) continue;
            return loadedSnapshot;
        }
        return null;
    }

    private Lookup.Provider findProjectForSnapshot(FileObject fileObject) {
        return ProfilerStorage.getProjectFromFolder((FileObject)fileObject.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadedSnapshot loadSnapshotFromFileObject(FileObject fileObject) throws IOException {
        FilterInputStream filterInputStream = null;
        try {
            InputStream inputStream = fileObject.getInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            filterInputStream = new DataInputStream(bufferedInputStream);
            LoadedSnapshot loadedSnapshot = LoadedSnapshot.loadSnapshot((DataInputStream)filterInputStream);
            if (loadedSnapshot != null) {
                loadedSnapshot.setFile(FileUtil.toFile((FileObject)fileObject));
                loadedSnapshot.setProject(this.findProjectForSnapshot(fileObject));
            }
            LoadedSnapshot loadedSnapshot2 = loadedSnapshot;
            return loadedSnapshot2;
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
    }

    private LoadedSnapshot loadSnapshotImpl(FileObject fileObject) throws IOException {
        LoadedSnapshot loadedSnapshot = this.findAlreadyLoadedSnapshot(fileObject);
        if (loadedSnapshot != null) {
            return loadedSnapshot;
        }
        loadedSnapshot = this.loadSnapshotFromFileObject(fileObject);
        if (loadedSnapshot != null) {
            this.loadedSnapshots.add(loadedSnapshot);
            this.fireSnapshotLoaded(loadedSnapshot);
        }
        return loadedSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfilingSettings readSettingsFromFile(FileObject fileObject) {
        BufferedInputStream bufferedInputStream;
        LoadedSnapshot loadedSnapshot = this.findAlreadyLoadedSnapshot(fileObject);
        if (loadedSnapshot != null) {
            return loadedSnapshot.getSettings();
        }
        FilterInputStream filterInputStream = null;
        try {
            InputStream inputStream = fileObject.getInputStream();
            bufferedInputStream = new BufferedInputStream(inputStream);
            filterInputStream = new DataInputStream(bufferedInputStream);
            byte[] byArray = new byte["nBpRoFiLeR".length()];
            int n = ((DataInputStream)filterInputStream).read(byArray);
            if (n != "nBpRoFiLeR".length() || !"nBpRoFiLeR".equals(new String(byArray))) {
                ProfilingSettings profilingSettings = null;
                return profilingSettings;
            }
            byte by = ((DataInputStream)filterInputStream).readByte();
            byte by2 = ((DataInputStream)filterInputStream).readByte();
            int n2 = ((DataInputStream)filterInputStream).readInt();
            int n3 = ((DataInputStream)filterInputStream).readInt();
            int n4 = ((DataInputStream)filterInputStream).readInt();
            if (((DataInputStream)filterInputStream).skipBytes(n3) != n3) {
                ProfilingSettings profilingSettings = null;
                return profilingSettings;
            }
            int n5 = ((DataInputStream)filterInputStream).readInt();
            byte[] byArray2 = new byte[n5];
            if (((DataInputStream)filterInputStream).read(byArray2) != n5) {
                ProfilingSettings profilingSettings = null;
                return profilingSettings;
            }
            Properties properties = new Properties();
            ProfilingSettings profilingSettings = new ProfilingSettings();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            BufferedInputStream bufferedInputStream2 = new BufferedInputStream(byteArrayInputStream);
            DataInputStream dataInputStream = new DataInputStream(bufferedInputStream2);
            try {
                properties.load(dataInputStream);
            }
            catch (IOException iOException) {
                ProfilerLogger.log((Exception)iOException);
                ProfilingSettings profilingSettings2 = null;
                try {
                    if (filterInputStream != null) {
                        filterInputStream.close();
                    }
                }
                catch (IOException iOException2) {
                    ProfilerLogger.log((Exception)iOException2);
                }
                return profilingSettings2;
            }
            finally {
                dataInputStream.close();
            }
            profilingSettings.load((Map)properties);
            ProfilingSettings profilingSettings3 = profilingSettings;
            return profilingSettings3;
        }
        catch (Exception exception) {
            ProfilerLogger.log((Exception)exception);
            bufferedInputStream = null;
            return bufferedInputStream;
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (IOException iOException) {
                ProfilerLogger.log((Exception)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readTypeFromFile(FileObject fileObject) {
        LoadedSnapshot loadedSnapshot = this.findAlreadyLoadedSnapshot(fileObject);
        if (loadedSnapshot != null) {
            return loadedSnapshot.getType();
        }
        FilterInputStream filterInputStream = null;
        try {
            int n;
            InputStream inputStream = fileObject.getInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            filterInputStream = new DataInputStream(bufferedInputStream);
            byte[] byArray = new byte["nBpRoFiLeR".length()];
            int n2 = ((DataInputStream)filterInputStream).read(byArray);
            if (n2 != "nBpRoFiLeR".length() || !"nBpRoFiLeR".equals(new String(byArray))) {
                int n3 = 0;
                return n3;
            }
            byte by = ((DataInputStream)filterInputStream).readByte();
            byte by2 = ((DataInputStream)filterInputStream).readByte();
            int n4 = n = ((DataInputStream)filterInputStream).readInt();
            return n4;
        }
        catch (Exception exception) {
            int n = 0;
            return n;
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
    }

    public static interface SnapshotHandle {
        public LoadedSnapshot getSnapshot();
    }

    public static final class ResultsMonitor
    implements CPUCCTProvider.Listener,
    MemoryCCTProvider.Listener {
        public void cctEstablished(RuntimeCCTNode runtimeCCTNode, boolean bl) {
            if (!bl) {
                ResultsManager resultsManager = ResultsManager.getDefault();
                if (!resultsManager.resultsAvailable() && !this.isSomeResultsAvailable()) {
                    return;
                }
                resultsManager.resultsBecameAvailable();
            }
        }

        public void cctReset() {
            ResultsManager.getDefault().resultsReset();
        }

        private boolean isSomeResultsAvailable() {
            Profiler profiler = Profiler.getDefault();
            ProfilerClient profilerClient = profiler.getTargetAppRunner().getProfilerClient();
            int n = profiler.getLastProfilingSettings().getProfilingType();
            if (n == 8 || n == 16) {
                try {
                    profilerClient.getCPUProfilingResultsSnapshot(false);
                }
                catch (CPUResultsSnapshot.NoDataAvailableException noDataAvailableException) {
                    return false;
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    return false;
                }
            }
            return true;
        }
    }

    private static class Singleton {
        private static final ResultsManager INSTANCE = new ResultsManager();

        private Singleton() {
        }
    }

    static class SelectedFile {
        FileObject folder;
        String fileExt;
        String fileName;

        SelectedFile(FileObject fileObject, String string, String string2) {
            this.folder = fileObject;
            this.fileName = string;
            this.fileExt = string2;
        }
    }
}

