/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.datasource;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.DataSourceProvider;
import com.sun.tools.visualvm.core.datasupport.DataChangeEvent;
import com.sun.tools.visualvm.core.datasupport.DataChangeListener;
import java.util.Set;

public final class DataSourceRepository
extends DataSourceProvider {
    private static DataSourceRepository sharedInstance;
    private final Listener dataChangeListener = new Listener();

    public static synchronized DataSourceRepository sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new DataSourceRepository();
        }
        return sharedInstance;
    }

    @Override
    void registerDataSourcesImpl(Set<? extends DataSource> added) {
        super.registerDataSourcesImpl(added);
        for (DataSource dataSource : added) {
            dataSource.getRepository().addDataChangeListener(this.dataChangeListener, DataSource.class);
        }
    }

    @Override
    void unregisterDataSourcesImpl(Set<? extends DataSource> removed) {
        super.unregisterDataSourcesImpl(removed);
        for (DataSource dataSource : removed) {
            dataSource.getRepository().removeDataChangeListener(this.dataChangeListener);
        }
    }

    private DataSourceRepository() {
        this.registerDataSource(DataSource.ROOT);
    }

    private class Listener
    implements DataChangeListener<DataSource> {
        private Listener() {
        }

        @Override
        public void dataChanged(DataChangeEvent<DataSource> event) {
            Set<DataSource> added = event.getAdded();
            Set<DataSource> removed = event.getRemoved();
            if (!added.isEmpty() || !removed.isEmpty()) {
                DataSourceRepository.this.changeDataSources(added, removed);
            }
        }
    }
}

