/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiler;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.application.jvm.JvmFactory;
import com.sun.tools.visualvm.profiler.JavaInfo;
import com.sun.tools.visualvm.profiler.JavaPlatformSelector;
import com.sun.tools.visualvm.profiler.ProfilerSupport;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.filters.InstrumentationFilter;
import org.netbeans.lib.profiler.global.CalibrationDataFileIO;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;

final class CalibrationSupport {
    private CalibrationSupport() {
    }

    static boolean checkCalibration(Application app, Runnable before, Runnable after) {
        int arch;
        Jvm jvm = JvmFactory.getJVMFor((Application)app);
        Properties properties = jvm.getSystemProperties();
        if (properties == null) {
            return false;
        }
        String java = Platform.getJDKVersionString((String)properties.getProperty("java.version"));
        if (CalibrationSupport.checkCalibration(java, arch = Platform.getSystemArchitecture((String)properties.getProperty("sun.arch.data.model")))) {
            return true;
        }
        String executable = JavaInfo.getJDKExecutable(properties.getProperty("java.home"));
        return CalibrationSupport.calibrate(executable, java, arch, before, after);
    }

    static boolean checkCalibration(String java, int arch, Runnable before, Runnable after) {
        if (CalibrationSupport.checkCalibration(java, arch)) {
            return true;
        }
        return CalibrationSupport.calibrate(java, arch, before, after);
    }

    static boolean calibrate(String java, int arch, Runnable before, Runnable after) {
        return CalibrationSupport.calibrate(null, java, arch, before, after);
    }

    static String getCalibrationDataFileName(String targetJDKVerString) {
        String fileName = "machinedata." + targetJDKVerString;
        try {
            return Platform.getProfilerUserDir() + File.separator + fileName;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static boolean checkCalibration(String jdkString, int arch) {
        ProfilingSessionStatus status = NetBeansProfiler.getDefaultNB().getTargetAppRunner().getProfilingSessionStatus();
        status.targetJDKVersionString = jdkString;
        return CalibrationDataFileIO.readSavedCalibrationData((ProfilingSessionStatus)status) == 0;
    }

    private static boolean calibrate(String executable, String java, int arch, Runnable before, Runnable after) {
        TargetAppRunner runner;
        File executableF;
        boolean noarch = arch == -1;
        File file = executableF = executable == null ? null : new File(executable);
        if (!CalibrationSupport.isFile(executableF)) {
            String javaName = ProfilerSupport.getJavaName(java);
            String archName = noarch ? null : ProfilerSupport.getArchName(arch);
            executable = JavaPlatformSelector.selectJavaBinary(javaName, archName, java, noarch ? null : Integer.toString(arch));
            File file2 = executableF = executable == null ? null : new File(executable);
            if (!CalibrationSupport.isFile(executableF)) {
                return false;
            }
        }
        if (noarch) {
            String[] archS = JavaInfo.getSystemProperties(executableF, "sun.arch.data.model");
            try {
                arch = Integer.parseInt(archS[0]);
            }
            catch (Exception archName) {
                // empty catch block
            }
            if (arch == -1) {
                return false;
            }
        }
        if ((runner = NetBeansProfiler.getDefaultNB().getTargetAppRunner()) == null) {
            return false;
        }
        ProfilerEngineSettings pes = runner.getProfilerEngineSettings();
        int savedPort = pes.getPortNo();
        InstrumentationFilter savedInstrFilter = pes.getInstrumentationFilter();
        String savedJVMExeFile = pes.getTargetJVMExeFile();
        String savedJDKVersionString = pes.getTargetJDKVersionString();
        int savedArch = pes.getSystemArchitecture();
        String savedCP = pes.getMainClassPath();
        pes.setTargetJVMExeFile(executable);
        pes.setTargetJDKVersionString(java);
        pes.setSystemArchitecture(arch);
        pes.setPortNo(ProfilerIDESettings.getInstance().getCalibrationPortNo());
        pes.setInstrumentationFilter((GenericFilter)new InstrumentationFilter());
        pes.setMainClassPath("");
        if (before != null) {
            before.run();
        }
        boolean result = CalibrationSupport.calibrateJVM();
        if (after != null) {
            after.run();
        }
        pes.setPortNo(savedPort);
        pes.setInstrumentationFilter((GenericFilter)savedInstrFilter);
        pes.setTargetJDKVersionString(savedJDKVersionString);
        pes.setSystemArchitecture(savedArch);
        pes.setTargetJVMExeFile(savedJVMExeFile);
        pes.setMainClassPath(savedCP);
        return result;
    }

    private static boolean calibrateJVM() {
        try {
            return NetBeansProfiler.getDefaultNB().runConfiguredCalibration();
        }
        catch (Exception e) {
            System.err.println(">>> Profiler calibration failed: " + e.getMessage());
            e.printStackTrace(System.err);
            return false;
        }
    }

    private static boolean isFile(File file) {
        return file != null && file.isFile();
    }
}

