/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.columns.ui;

import java.awt.Component;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.gephi.datalab.plugin.manipulators.columns.DuplicateColumn;
import org.gephi.datalab.spi.DialogControls;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulator;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulatorUI;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Table;
import org.gephi.ui.utils.ColumnTitleValidator;
import org.gephi.ui.utils.SupportedColumnTypeWrapper;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.util.NbBundle;

public class DuplicateColumnUI
extends JPanel
implements AttributeColumnsManipulatorUI {
    private DuplicateColumn manipulator;
    private Table table;
    private DialogControls dialogControls;
    private JLabel descriptionLabel;
    private JLabel titleLabel;
    private JTextField titleTextField;
    private JComboBox typeComboBox;
    private JLabel typeLabel;

    public DuplicateColumnUI() {
        this.initComponents();
        this.titleTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.refreshOkButton();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.refreshOkButton();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.refreshOkButton();
            }

            private void refreshOkButton() {
                String text = DuplicateColumnUI.this.titleTextField.getText();
                DuplicateColumnUI.this.dialogControls.setOkButtonEnabled(text != null && !text.isEmpty() && !DuplicateColumnUI.this.table.hasColumn(text));
            }
        });
    }

    public void setup(AttributeColumnsManipulator m, GraphModel graphModel, Table table, Column column, DialogControls dialogControls) {
        this.table = table;
        this.dialogControls = dialogControls;
        this.manipulator = (DuplicateColumn)m;
        this.descriptionLabel.setText(NbBundle.getMessage(DuplicateColumnUI.class, (String)"DuplicateColumnUI.descriptionLabel.text", (Object)column.getTitle()));
        this.titleTextField.setText(NbBundle.getMessage(DuplicateColumnUI.class, (String)"DuplicateColumnUI.new.title", (Object)column.getTitle()));
        List supportedTypesWrappers = SupportedColumnTypeWrapper.buildOrderedSupportedTypesList((GraphModel)graphModel);
        for (SupportedColumnTypeWrapper supportedColumnTypeWrapper : supportedTypesWrappers) {
            this.typeComboBox.addItem(supportedColumnTypeWrapper);
        }
        this.typeComboBox.setSelectedItem(new SupportedColumnTypeWrapper(column.getTypeClass()));
    }

    public void unSetup() {
        this.manipulator.setColumnType(((SupportedColumnTypeWrapper)this.typeComboBox.getSelectedItem()).getType());
        this.manipulator.setTitle(this.titleTextField.getText());
    }

    public String getDisplayName() {
        return this.manipulator.getName();
    }

    public JPanel getSettingsPanel() {
        ValidationPanel validationPanel = new ValidationPanel();
        validationPanel.setInnerComponent((Component)this);
        ValidationGroup group = validationPanel.getValidationGroup();
        group.add((JTextComponent)this.titleTextField, new Validator[]{new ColumnTitleValidator(this.table)});
        return validationPanel;
    }

    public boolean isModal() {
        return true;
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.titleTextField = new JTextField();
        this.typeLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.descriptionLabel = new JLabel();
        this.titleLabel.setText(NbBundle.getMessage(DuplicateColumnUI.class, (String)"DuplicateColumnUI.titleLabel.text"));
        this.titleTextField.setText(NbBundle.getMessage(DuplicateColumnUI.class, (String)"DuplicateColumnUI.titleTextField.text"));
        this.typeLabel.setText(NbBundle.getMessage(DuplicateColumnUI.class, (String)"DuplicateColumnUI.typeLabel.text"));
        this.descriptionLabel.setHorizontalAlignment(0);
        this.descriptionLabel.setText(null);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.descriptionLabel, GroupLayout.Alignment.LEADING, -1, 299, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.titleTextField, -1, 203, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.typeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typeComboBox, 0, 199, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.descriptionLabel, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleLabel).addComponent(this.titleTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeLabel).addComponent(this.typeComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

