/*
 * Decompiled with CFR 0.152.
 */
package ch.poole.openinghoursparser;

import ch.poole.openinghoursparser.I18n;
import ch.poole.openinghoursparser.OpeningHoursParseException;
import ch.poole.openinghoursparser.ParseException;
import java.util.ArrayList;
import java.util.List;

public enum Month {
    JAN("Jan"),
    FEB("Feb"),
    MAR("Mar"),
    APR("Apr"),
    MAY("May"),
    JUN("Jun"),
    JUL("Jul"),
    AUG("Aug"),
    SEP("Sep"),
    OCT("Oct"),
    NOV("Nov"),
    DEC("Dec");

    private static final int[] LASTDAY;
    private final String name;

    private Month(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static Month getValue(String month) {
        for (Month m : Month.values()) {
            if (!m.toString().equals(month)) continue;
            return m;
        }
        throw new IllegalArgumentException(I18n.tr("invalid_month", month));
    }

    public static List<String> nameValues() {
        ArrayList<String> result = new ArrayList<String>();
        for (Month m : Month.values()) {
            result.add(m.toString());
        }
        return result;
    }

    public static int lastDay(int year, Month month) throws ParseException {
        if (month != FEB) {
            return LASTDAY[month.ordinal()];
        }
        if (year == Integer.MIN_VALUE) {
            throw new OpeningHoursParseException(I18n.tr("missing_day_for_February", new Object[0]));
        }
        if (year / 4 * 4 == year && year / 100 * 100 != year) {
            return 29;
        }
        return 28;
    }

    static {
        LASTDAY = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    }
}

