/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.annotations.NotNull;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class RandomAccessStreamReader
extends RandomAccessReader {
    public static final int DEFAULT_CHUNK_LENGTH = 2048;
    @NotNull
    private final InputStream _stream;
    private final int _chunkLength;
    private final ArrayList<byte[]> _chunks = new ArrayList();
    private boolean _isStreamFinished;
    private long _streamLength;

    public RandomAccessStreamReader(@NotNull InputStream stream) {
        this(stream, 2048, -1L);
    }

    public RandomAccessStreamReader(@NotNull InputStream stream, int chunkLength) {
        this(stream, chunkLength, -1L);
    }

    public RandomAccessStreamReader(@NotNull InputStream stream, int chunkLength, long streamLength) {
        if (stream == null) {
            throw new NullPointerException();
        }
        if (chunkLength <= 0) {
            throw new IllegalArgumentException("chunkLength must be greater than zero");
        }
        this._chunkLength = chunkLength;
        this._stream = stream;
        this._streamLength = streamLength;
    }

    @Override
    public long getLength() throws IOException {
        if (this._streamLength != -1L) {
            return this._streamLength;
        }
        this.isValidIndex(Integer.MAX_VALUE, 1);
        assert (this._isStreamFinished);
        return this._streamLength;
    }

    @Override
    protected void validateIndex(int index, int bytesRequested) throws IOException {
        if (index < 0) {
            throw new BufferBoundsException(String.format("Attempt to read from buffer using a negative index (%d)", index));
        }
        if (bytesRequested < 0) {
            throw new BufferBoundsException("Number of requested bytes must be zero or greater");
        }
        if ((long)index + (long)bytesRequested - 1L > Integer.MAX_VALUE) {
            throw new BufferBoundsException(String.format("Number of requested bytes summed with starting index exceed maximum range of signed 32 bit integers (requested index: %d, requested count: %d)", index, bytesRequested));
        }
        if (!this.isValidIndex(index, bytesRequested)) {
            assert (this._isStreamFinished);
            throw new BufferBoundsException(index, bytesRequested, this._streamLength);
        }
    }

    @Override
    protected boolean isValidIndex(int index, int bytesRequested) throws IOException {
        if (index < 0 || bytesRequested < 0) {
            return false;
        }
        long endIndexLong = (long)index + (long)bytesRequested - 1L;
        if (endIndexLong > Integer.MAX_VALUE) {
            return false;
        }
        int endIndex = (int)endIndexLong;
        if (this._isStreamFinished) {
            return (long)endIndex < this._streamLength;
        }
        int chunkIndex = endIndex / this._chunkLength;
        while (chunkIndex >= this._chunks.size()) {
            assert (!this._isStreamFinished);
            byte[] chunk = new byte[this._chunkLength];
            int totalBytesRead = 0;
            while (!this._isStreamFinished && totalBytesRead != this._chunkLength) {
                int bytesRead = this._stream.read(chunk, totalBytesRead, this._chunkLength - totalBytesRead);
                if (bytesRead == -1) {
                    this._isStreamFinished = true;
                    int observedStreamLength = this._chunks.size() * this._chunkLength + totalBytesRead;
                    if (this._streamLength == -1L) {
                        this._streamLength = observedStreamLength;
                    } else if (this._streamLength != (long)observedStreamLength) assert (false);
                    if ((long)endIndex < this._streamLength) continue;
                    this._chunks.add(chunk);
                    return false;
                }
                totalBytesRead += bytesRead;
            }
            this._chunks.add(chunk);
        }
        return true;
    }

    @Override
    public int toUnshiftedOffset(int localOffset) {
        return localOffset;
    }

    @Override
    public byte getByte(int index) throws IOException {
        assert (index >= 0);
        int chunkIndex = index / this._chunkLength;
        int innerIndex = index % this._chunkLength;
        byte[] chunk = this._chunks.get(chunkIndex);
        return chunk[innerIndex];
    }

    @Override
    @NotNull
    public byte[] getBytes(int index, int count) throws IOException {
        this.validateIndex(index, count);
        byte[] bytes = new byte[count];
        int remaining = count;
        int fromIndex = index;
        int toIndex = 0;
        while (remaining != 0) {
            int fromChunkIndex = fromIndex / this._chunkLength;
            int fromInnerIndex = fromIndex % this._chunkLength;
            int length = Math.min(remaining, this._chunkLength - fromInnerIndex);
            byte[] chunk = this._chunks.get(fromChunkIndex);
            System.arraycopy(chunk, fromInnerIndex, bytes, toIndex, length);
            remaining -= length;
            fromIndex += length;
            toIndex += length;
        }
        return bytes;
    }
}

