/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.jcs3.engine.AbstractCacheEventQueue;
import org.apache.commons.jcs3.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs3.engine.behavior.ICacheListener;
import org.apache.commons.jcs3.engine.stats.StatElement;
import org.apache.commons.jcs3.engine.stats.Stats;
import org.apache.commons.jcs3.engine.stats.behavior.IStats;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.threadpool.ThreadPoolManager;

public class PooledCacheEventQueue<K, V>
extends AbstractCacheEventQueue<K, V> {
    private static final Log log = LogManager.getLog(PooledCacheEventQueue.class);
    private static final ICacheEventQueue.QueueType queueType = ICacheEventQueue.QueueType.POOLED;
    protected ExecutorService pool = null;
    protected BlockingQueue<Runnable> queue = null;

    public PooledCacheEventQueue(ICacheListener<K, V> listener, long listenerId, String cacheName, int maxFailure, int waitBeforeRetry, String threadPoolName) {
        this.initialize(listener, listenerId, cacheName, maxFailure, waitBeforeRetry, threadPoolName);
    }

    protected void initialize(ICacheListener<K, V> listener, long listenerId, String cacheName, int maxFailure, int waitBeforeRetry, String threadPoolName) {
        super.initialize(listener, listenerId, cacheName, maxFailure, waitBeforeRetry);
        this.pool = ThreadPoolManager.getInstance().getExecutorService(threadPoolName == null ? "cache_event_queue" : threadPoolName);
        if (this.pool instanceof ThreadPoolExecutor) {
            this.queue = ((ThreadPoolExecutor)this.pool).getQueue();
        }
    }

    @Override
    public ICacheEventQueue.QueueType getQueueType() {
        return queueType;
    }

    @Override
    public synchronized void destroy() {
        if (this.isWorking()) {
            this.setWorking(false);
            this.pool.shutdownNow();
            log.info("Cache event queue destroyed: {0}", this);
        }
    }

    @Override
    protected void put(AbstractCacheEventQueue.AbstractCacheEvent event) {
        this.pool.execute(event);
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Pooled Cache Event Queue");
        ArrayList elems = new ArrayList();
        elems.add(new StatElement<Boolean>("Working", this.isWorking()));
        elems.add(new StatElement<Boolean>("Empty", this.isEmpty()));
        if (this.queue != null) {
            elems.add(new StatElement<Integer>("Queue Size", this.queue.size()));
            elems.add(new StatElement<Integer>("Queue Capacity", this.queue.remainingCapacity()));
        }
        stats.setStatElements(elems);
        return stats;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        if (this.queue == null) {
            return 0;
        }
        return this.queue.size();
    }
}

