/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DownloadPolicy;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.UpdatePrimitivesTask;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UpdateSelectionAction
extends JosmAction {
    public static void handlePrimitiveGoneException(long id, OsmPrimitiveType type) {
        MultiFetchServerObjectReader reader = MultiFetchServerObjectReader.create();
        reader.append(MainApplication.getLayerManager().getEditDataSet(), id, type);
        try {
            DataSet ds = reader.parseOsm(NullProgressMonitor.INSTANCE);
            MainApplication.getLayerManager().getEditLayer().mergeFrom(ds);
        }
        catch (OsmTransferException e) {
            ExceptionDialogUtil.explainException(e);
        }
    }

    public static void updatePrimitives(Collection<OsmPrimitive> selection) {
        MainApplication.worker.submit(new UpdatePrimitivesTask(MainApplication.getLayerManager().getEditLayer(), selection));
    }

    public static void updatePrimitive(PrimitiveId id) {
        CheckParameterUtil.ensureParameterNotNull(id, "id");
        UpdateSelectionAction.updatePrimitives(Collections.singleton(Optional.ofNullable(Optional.ofNullable(MainApplication.getLayerManager().getEditLayer()).orElseThrow((Supplier<IllegalStateException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePrimitive$0(), ()Ljava/lang/IllegalStateException;)()).data.getPrimitiveById(id)).orElseThrow(() -> new IllegalStateException(I18n.tr("Did not find an object with id {0} in the current dataset", id)))));
    }

    public UpdateSelectionAction() {
        super(I18n.tr("Update selection", new Object[0]), "updatedata", I18n.tr("Updates the currently selected objects from the server (re-downloads data)", new Object[0]), Shortcut.registerShortcut("file:updateselection", I18n.tr("File: {0}", I18n.tr("Update selection", new Object[0])), 85, 5008), true, "updateselection", true);
        this.setHelpId(HelpUtil.ht("/Action/UpdateSelection"));
    }

    public UpdateSelectionAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean register, String toolbarId) {
        super(name, iconName, tooltip, shortcut, register, toolbarId, true);
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null || selection.isEmpty()) {
            this.setEnabled(false);
        } else {
            DataSet ds = selection.iterator().next().getDataSet();
            this.setEnabled(!ds.isLocked() && DownloadPolicy.BLOCKED != ds.getDownloadPolicy() && !NetworkManager.isOffline(OnlineResource.OSM_API));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> toUpdate = this.getData();
        if (toUpdate.isEmpty()) {
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("There are no selected objects to update.", new Object[0]), I18n.tr("Selection empty", new Object[0]), 1);
            return;
        }
        UpdateSelectionAction.updatePrimitives(toUpdate);
    }

    public Collection<OsmPrimitive> getData() {
        return this.getLayerManager().getEditDataSet().getAllSelected();
    }

    private static /* synthetic */ IllegalStateException lambda$updatePrimitive$0() {
        return new IllegalStateException(I18n.tr("No current dataset found", new Object[0]));
    }
}

