/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Comparator;
import java.util.HashMap;
import java.util.function.Function;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.tools.AlphanumComparator;

public final class PrimitiveComparator {
    public static Comparator<IPrimitive> comparingNames() {
        return PrimitiveComparator.doComparingNames();
    }

    static <T extends IPrimitive> Comparator<T> doComparingNames() {
        Comparator<String> digitsLast = Comparator.comparing(str -> !str.isEmpty() && Character.isDigit(str.charAt(0)) ? 1 : 0);
        return Comparator.comparing(PrimitiveComparator.memoize(DefaultNameFormatter.getInstance()::format), digitsLast.thenComparing(AlphanumComparator.getInstance()));
    }

    public static Comparator<IPrimitive> comparingUniqueId() {
        return PrimitiveComparator.doComparingUniqueId();
    }

    static <T extends IPrimitive> Comparator<T> doComparingUniqueId() {
        return Comparator.comparing(PrimitiveId::getUniqueId);
    }

    public static Comparator<IPrimitive> orderingNodesWaysRelations() {
        return PrimitiveComparator.doOrderingNodesWaysRelations();
    }

    static <T extends IPrimitive> Comparator<T> doOrderingNodesWaysRelations() {
        return Comparator.comparingInt(osm -> osm.getType().ordinal());
    }

    public static Comparator<IPrimitive> orderingWaysRelationsNodes() {
        return PrimitiveComparator.doOrderingWaysRelationsNodes();
    }

    static <T extends IPrimitive> Comparator<T> doOrderingWaysRelationsNodes() {
        return Comparator.comparingInt(osm -> {
            switch (osm.getType()) {
                case WAY: {
                    return 1;
                }
                case RELATION: {
                    return 2;
                }
                case NODE: {
                    return 3;
                }
            }
            throw new IllegalStateException();
        });
    }

    public static Comparator<IPrimitive> orderingRelationsWaysNodes() {
        return PrimitiveComparator.doOrderingRelationsWaysNodes();
    }

    static <T extends IPrimitive> Comparator<T> doOrderingRelationsWaysNodes() {
        return Comparator.comparingInt(osm -> {
            switch (osm.getType()) {
                case RELATION: {
                    return 1;
                }
                case WAY: {
                    return 2;
                }
                case NODE: {
                    return 3;
                }
            }
            throw new IllegalStateException();
        });
    }

    private static <T, R> Function<T, R> memoize(Function<T, R> base) {
        HashMap cache = new HashMap();
        return t -> cache.computeIfAbsent(t, base);
    }

    private PrimitiveComparator() {
    }
}

